#include "../../std.h"

#include "file.h"
#include "files.h"

#ifndef HAVE_OLD_LIBXML_INCLUDES
#include <libxml/parser.h>
#else
#include <parser.h>
#ifndef xmlChildrenNode
#define xmlChildrenNode childs
#endif
#endif

extern "C" {
extern GACLentry *GACLparseEntry(xmlNodePtr cur);
};

static GACLacl *GACLacquireAcl(char *str)
{
  xmlDocPtr   doc;
  xmlNodePtr  cur;
  GACLacl    *acl;
  GACLentry  *entry;

  doc = xmlParseMemory(str,strlen(str));
  if (doc == NULL) return NULL;

  cur = xmlDocGetRootElement(doc);

  if (xmlStrcmp(cur->name, (const xmlChar *) "gacl"))
    {
      free(doc);
      free(cur);
      return NULL;
    }

  cur = cur->xmlChildrenNode;

  acl = GACLnewAcl();

  while (cur != NULL)
       {
         if(xmlNodeIsText(cur)) { cur=cur->next; continue; };
         entry = GACLparseEntry(cur);
         if (entry == NULL)
           {
             GACLfreeAcl(acl);
             xmlFreeDoc(doc);
             return NULL;
           }

         GACLaddEntry(acl, entry);

         cur=cur->next;
       }

  xmlFreeDoc(doc);
  return acl;
}

static int check_acl(AuthUser &user,const std::string& gname) {
  if(user.DN()[0] == 0) return FILE_ACC_NONE;
  GACLacl* acl;
  struct stat st;
  if(stat(gname.c_str(),&st) == 0) {
    if(!S_ISREG(st.st_mode)) return FILE_ACC_NONE;
    acl=GACLloadAcl((char*)(gname.c_str()));
  } else {
    return FILE_ACC_NONE;
  };
  GACLperm perm = AuthUserGACLTest(acl,user);
  GACLfreeAcl(acl);
  return perm;
}

static int write_acl(const AuthUser &user,const char* acl,const std::string& gname) {
//  if(!(check_acl(user,gname) & GACL_PERM_ADMIN)) return -1;
  if((!acl) || (!*acl)) return -1;
  GACLacl* acl_ = GACLacquireAcl((char*)acl);
  if(acl_ == NULL) return -1;
  if(!GACLsaveAcl((char*)(gname.c_str()),acl_)) { GACLfreeAcl(acl_); return -1;
};
  return 0;
}

static int read_acl(const AuthUser &user,std::string& acl,const std::string& gname) {
  int h=::open(gname.c_str(),O_RDONLY);
  if(h==-1) return -1;
  int l = 0;
  for(;;) {
    char acl_buf[1024];
    int ll = ::read(h,acl_buf,sizeof(acl_buf)-1);
    if(ll == -1) { close(h); return -1; };
    if(l>=10240) { close(h); return -1; };
    if(ll == 0) break;
    acl_buf[ll]=0; acl.append(acl_buf);
    l+=ll;
  };
  close(h);
  return 0;
}



int SEFile::check_acl(const AuthUser &user) {
  std::string gname=path+".acl";
  return ::check_acl((AuthUser&)user,gname);
}

int SEFile::write_acl(const AuthUser &user,const char* acl) {
  std::string gname=path+".acl";
  return ::write_acl(user,acl,gname);
}

int SEFile::read_acl(const AuthUser &user,std::string& acl) {
  std::string gname=path+".acl";
  return ::read_acl(user,acl,gname);
}

int SEFiles::check_acl(const AuthUser &user) {
  std::string gname=path+"/.acl";
  return ::check_acl((AuthUser&)user,gname);
}

int SEFiles::write_acl(const AuthUser &user,const char* acl) {
  std::string gname=path+"/.acl";
  return ::write_acl(user,acl,gname);
}

int SEFiles::read_acl(const AuthUser &user,std::string& acl) {
  std::string gname=path+"/.acl";
  return ::read_acl(user,acl,gname);
}

