/* file_soapC.cpp
   Generated by gSOAP 2.7.8a from file_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "file_soapH.h"

SOAP_SOURCE_STAMP("@(#) file_soapC.cpp ver 2.7.8a 2009-04-06 10:45:31 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_long:
		return soap_in_long(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_ns__filestate:
		return soap_in_ns__filestate(soap, NULL, NULL, "ns:filestate");
	case SOAP_TYPE_ns__fileinfo:
		return soap_in_ns__fileinfo(soap, NULL, NULL, "ns:fileinfo");
	case SOAP_TYPE_ns__del:
		return soap_in_ns__del(soap, NULL, NULL, "ns:del");
	case SOAP_TYPE_ns__acl:
		return soap_in_ns__acl(soap, NULL, NULL, "ns:acl");
	case SOAP_TYPE_ns__info:
		return soap_in_ns__info(soap, NULL, NULL, "ns:info");
	case SOAP_TYPE_ns__update:
		return soap_in_ns__update(soap, NULL, NULL, "ns:update");
	case SOAP_TYPE_ns__add:
		return soap_in_ns__add(soap, NULL, NULL, "ns:add");
	case SOAP_TYPE_ns__delResponse:
		return soap_in_ns__delResponse(soap, NULL, NULL, "ns:delResponse");
	case SOAP_TYPE_ns__aclResponse:
		return soap_in_ns__aclResponse(soap, NULL, NULL, "ns:aclResponse");
	case SOAP_TYPE_ns__infoResponse:
		return soap_in_ns__infoResponse(soap, NULL, NULL, "ns:infoResponse");
	case SOAP_TYPE_ns__updateResponse:
		return soap_in_ns__updateResponse(soap, NULL, NULL, "ns:updateResponse");
	case SOAP_TYPE_ns__addResponse:
		return soap_in_ns__addResponse(soap, NULL, NULL, "ns:addResponse");
	case SOAP_TYPE_PointerTons__fileinfo:
		return soap_in_PointerTons__fileinfo(soap, NULL, NULL, "ns:fileinfo");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTons__filestate:
		return soap_in_PointerTons__filestate(soap, NULL, NULL, "ns:filestate");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_in_PointerTounsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_long;
			return soap_in_long(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:filestate"))
		{	*type = SOAP_TYPE_ns__filestate;
			return soap_in_ns__filestate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:fileinfo"))
		{	*type = SOAP_TYPE_ns__fileinfo;
			return soap_in_ns__fileinfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:del"))
		{	*type = SOAP_TYPE_ns__del;
			return soap_in_ns__del(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:acl"))
		{	*type = SOAP_TYPE_ns__acl;
			return soap_in_ns__acl(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:info"))
		{	*type = SOAP_TYPE_ns__info;
			return soap_in_ns__info(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:update"))
		{	*type = SOAP_TYPE_ns__update;
			return soap_in_ns__update(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:add"))
		{	*type = SOAP_TYPE_ns__add;
			return soap_in_ns__add(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:delResponse"))
		{	*type = SOAP_TYPE_ns__delResponse;
			return soap_in_ns__delResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:aclResponse"))
		{	*type = SOAP_TYPE_ns__aclResponse;
			return soap_in_ns__aclResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:infoResponse"))
		{	*type = SOAP_TYPE_ns__infoResponse;
			return soap_in_ns__infoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:updateResponse"))
		{	*type = SOAP_TYPE_ns__updateResponse;
			return soap_in_ns__updateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:addResponse"))
		{	*type = SOAP_TYPE_ns__addResponse;
			return soap_in_ns__addResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_long:
		return soap_out_long(soap, tag, id, (const long *)ptr, "xsd:long");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_ns__filestate:
		return soap_out_ns__filestate(soap, tag, id, (const enum ns__filestate *)ptr, "ns:filestate");
	case SOAP_TYPE_ns__fileinfo:
		return ((ns__fileinfo *)ptr)->soap_out(soap, tag, id, "ns:fileinfo");
	case SOAP_TYPE_ns__del:
		return soap_out_ns__del(soap, tag, id, (const struct ns__del *)ptr, "ns:del");
	case SOAP_TYPE_ns__acl:
		return soap_out_ns__acl(soap, tag, id, (const struct ns__acl *)ptr, "ns:acl");
	case SOAP_TYPE_ns__info:
		return soap_out_ns__info(soap, tag, id, (const struct ns__info *)ptr, "ns:info");
	case SOAP_TYPE_ns__update:
		return soap_out_ns__update(soap, tag, id, (const struct ns__update *)ptr, "ns:update");
	case SOAP_TYPE_ns__add:
		return soap_out_ns__add(soap, tag, id, (const struct ns__add *)ptr, "ns:add");
	case SOAP_TYPE_ns__delResponse:
		return soap_out_ns__delResponse(soap, tag, id, (const struct ns__delResponse *)ptr, "ns:delResponse");
	case SOAP_TYPE_ns__aclResponse:
		return soap_out_ns__aclResponse(soap, tag, id, (const struct ns__aclResponse *)ptr, "ns:aclResponse");
	case SOAP_TYPE_ns__infoResponse:
		return soap_out_ns__infoResponse(soap, tag, id, (const struct ns__infoResponse *)ptr, "ns:infoResponse");
	case SOAP_TYPE_ns__updateResponse:
		return soap_out_ns__updateResponse(soap, tag, id, (const struct ns__updateResponse *)ptr, "ns:updateResponse");
	case SOAP_TYPE_ns__addResponse:
		return soap_out_ns__addResponse(soap, tag, id, (const struct ns__addResponse *)ptr, "ns:addResponse");
	case SOAP_TYPE_PointerTons__fileinfo:
		return soap_out_PointerTons__fileinfo(soap, tag, id, (ns__fileinfo *const*)ptr, "ns:fileinfo");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTons__filestate:
		return soap_out_PointerTons__filestate(soap, tag, id, (enum ns__filestate *const*)ptr, "ns:filestate");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_out_PointerTounsignedLONG64(soap, tag, id, (ULONG64 *const*)ptr, "xsd:unsignedLong");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ns__fileinfo:
		((ns__fileinfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns__del:
		soap_serialize_ns__del(soap, (const struct ns__del *)ptr);
		break;
	case SOAP_TYPE_ns__acl:
		soap_serialize_ns__acl(soap, (const struct ns__acl *)ptr);
		break;
	case SOAP_TYPE_ns__info:
		soap_serialize_ns__info(soap, (const struct ns__info *)ptr);
		break;
	case SOAP_TYPE_ns__update:
		soap_serialize_ns__update(soap, (const struct ns__update *)ptr);
		break;
	case SOAP_TYPE_ns__add:
		soap_serialize_ns__add(soap, (const struct ns__add *)ptr);
		break;
	case SOAP_TYPE_ns__delResponse:
		soap_serialize_ns__delResponse(soap, (const struct ns__delResponse *)ptr);
		break;
	case SOAP_TYPE_ns__aclResponse:
		soap_serialize_ns__aclResponse(soap, (const struct ns__aclResponse *)ptr);
		break;
	case SOAP_TYPE_ns__infoResponse:
		soap_serialize_ns__infoResponse(soap, (const struct ns__infoResponse *)ptr);
		break;
	case SOAP_TYPE_ns__updateResponse:
		soap_serialize_ns__updateResponse(soap, (const struct ns__updateResponse *)ptr);
		break;
	case SOAP_TYPE_ns__addResponse:
		soap_serialize_ns__addResponse(soap, (const struct ns__addResponse *)ptr);
		break;
	case SOAP_TYPE_PointerTons__fileinfo:
		soap_serialize_PointerTons__fileinfo(soap, (ns__fileinfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons__filestate:
		soap_serialize_PointerTons__filestate(soap, (enum ns__filestate *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedLONG64:
		soap_serialize_PointerTounsignedLONG64(soap, (ULONG64 *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_ns__fileinfo:
		return (void*)soap_instantiate_ns__fileinfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__addResponse:
		return (void*)soap_instantiate_ns__addResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__updateResponse:
		return (void*)soap_instantiate_ns__updateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__infoResponse:
		return (void*)soap_instantiate_ns__infoResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__aclResponse:
		return (void*)soap_instantiate_ns__aclResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__delResponse:
		return (void*)soap_instantiate_ns__delResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__add:
		return (void*)soap_instantiate_ns__add(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__update:
		return (void*)soap_instantiate_ns__update(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__info:
		return (void*)soap_instantiate_ns__info(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__acl:
		return (void*)soap_instantiate_ns__acl(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__del:
		return (void*)soap_instantiate_ns__del(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_ns__fileinfo:
		if (p->size < 0)
			delete (ns__fileinfo*)p->ptr;
		else
			delete[] (ns__fileinfo*)p->ptr;
		break;
	case SOAP_TYPE_ns__addResponse:
		if (p->size < 0)
			delete (struct ns__addResponse*)p->ptr;
		else
			delete[] (struct ns__addResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__updateResponse:
		if (p->size < 0)
			delete (struct ns__updateResponse*)p->ptr;
		else
			delete[] (struct ns__updateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__infoResponse:
		if (p->size < 0)
			delete (struct ns__infoResponse*)p->ptr;
		else
			delete[] (struct ns__infoResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__aclResponse:
		if (p->size < 0)
			delete (struct ns__aclResponse*)p->ptr;
		else
			delete[] (struct ns__aclResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__delResponse:
		if (p->size < 0)
			delete (struct ns__delResponse*)p->ptr;
		else
			delete[] (struct ns__delResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__add:
		if (p->size < 0)
			delete (struct ns__add*)p->ptr;
		else
			delete[] (struct ns__add*)p->ptr;
		break;
	case SOAP_TYPE_ns__update:
		if (p->size < 0)
			delete (struct ns__update*)p->ptr;
		else
			delete[] (struct ns__update*)p->ptr;
		break;
	case SOAP_TYPE_ns__info:
		if (p->size < 0)
			delete (struct ns__info*)p->ptr;
		else
			delete[] (struct ns__info*)p->ptr;
		break;
	case SOAP_TYPE_ns__acl:
		if (p->size < 0)
			delete (struct ns__acl*)p->ptr;
		else
			delete[] (struct ns__acl*)p->ptr;
		break;
	case SOAP_TYPE_ns__del:
		if (p->size < 0)
			delete (struct ns__del*)p->ptr;
		else
			delete[] (struct ns__del*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_long(struct soap *soap, long *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_long
	*a = SOAP_DEFAULT_long;
#else
	*a = (long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_long(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_long);
	if (soap_out_long(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_long(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_long(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_long(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_long(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{
	return soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__filestate(struct soap *soap, enum ns__filestate *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ns__filestate
	*a = SOAP_DEFAULT_ns__filestate;
#else
	*a = (enum ns__filestate)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__filestate(struct soap *soap, const enum ns__filestate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__filestate);
	if (soap_out_ns__filestate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ns__filestate[] =
{	{ (long)accepted, "accepted" },
	{ (long)collecting, "collecting" },
	{ (long)complete, "complete" },
	{ (long)deleting, "deleting" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ns__filestate2s(struct soap *soap, enum ns__filestate n)
{	const char *s = soap_code_str(soap_codes_ns__filestate, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__filestate(struct soap *soap, const char *tag, int id, const enum ns__filestate *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__filestate), type);
	soap_send(soap, soap_ns__filestate2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ns__filestate * SOAP_FMAC4 soap_get_ns__filestate(struct soap *soap, enum ns__filestate *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__filestate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ns__filestate(struct soap *soap, const char *s, enum ns__filestate *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ns__filestate, s);
	if (map)
		*a = (enum ns__filestate)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum ns__filestate)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ns__filestate * SOAP_FMAC4 soap_in_ns__filestate(struct soap *soap, const char *tag, enum ns__filestate *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ns__filestate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__filestate, sizeof(enum ns__filestate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ns__filestate(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ns__filestate *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__filestate, 0, sizeof(enum ns__filestate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

void ns__fileinfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((ns__fileinfo*)this)->id);
	soap_serialize_PointerTounsignedLONG64(soap, &((ns__fileinfo*)this)->size);
	soap_serialize_string(soap, &((ns__fileinfo*)this)->checksum);
	soap_serialize_string(soap, &((ns__fileinfo*)this)->acl);
	soap_serialize_string(soap, &((ns__fileinfo*)this)->created);
	soap_serialize_PointerTons__filestate(soap, &((ns__fileinfo*)this)->state);
	if (((ns__fileinfo*)this)->url)
	{	int i;
		for (i = 0; i < ((ns__fileinfo*)this)->__size_url; i++)
		{
			soap_serialize_string(soap, ((ns__fileinfo*)this)->url + i);
		}
	}
	/* transient ns__fileinfo skipped */
	/* transient ~ns__fileinfo skipped */
}

void ns__fileinfo::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	soap_default_string(soap, &((ns__fileinfo*)this)->id);
	((ns__fileinfo*)this)->size = NULL;
	soap_default_string(soap, &((ns__fileinfo*)this)->checksum);
	soap_default_string(soap, &((ns__fileinfo*)this)->acl);
	soap_default_string(soap, &((ns__fileinfo*)this)->created);
	((ns__fileinfo*)this)->state = NULL;
	((ns__fileinfo*)this)->__size_url = 0;
	((ns__fileinfo*)this)->url = NULL;
	/* transient ns__fileinfo skipped */
	/* transient ~ns__fileinfo skipped */
}

int ns__fileinfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns__fileinfo);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ns__fileinfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns__fileinfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__fileinfo(struct soap *soap, const char *tag, int id, const ns__fileinfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__fileinfo), type);
	soap_out_string(soap, "id", -1, &(((ns__fileinfo*)a)->id), "");
	soap_out_PointerTounsignedLONG64(soap, "size", -1, &(((ns__fileinfo*)a)->size), "");
	soap_out_string(soap, "checksum", -1, &(((ns__fileinfo*)a)->checksum), "");
	soap_out_string(soap, "acl", -1, &(((ns__fileinfo*)a)->acl), "");
	soap_out_string(soap, "created", -1, &(((ns__fileinfo*)a)->created), "");
	soap_out_PointerTons__filestate(soap, "state", -1, &(((ns__fileinfo*)a)->state), "");
	if (((ns__fileinfo*)a)->url)
	{	int i;
		for (i = 0; i < ((ns__fileinfo*)a)->__size_url; i++)
			soap_out_string(soap, "url", -1, ((ns__fileinfo*)a)->url + i, "");
	}
	/* transient ns__fileinfo skipped */
	/* transient ~ns__fileinfo skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ns__fileinfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns__fileinfo(soap, this, tag, type);
}

SOAP_FMAC3 ns__fileinfo * SOAP_FMAC4 soap_get_ns__fileinfo(struct soap *soap, ns__fileinfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__fileinfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ns__fileinfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns__fileinfo(soap, tag, this, type);
}

SOAP_FMAC3 ns__fileinfo * SOAP_FMAC4 soap_in_ns__fileinfo(struct soap *soap, const char *tag, ns__fileinfo *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ns__fileinfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns__fileinfo, sizeof(ns__fileinfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns__fileinfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns__fileinfo *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_size1 = 1, soap_flag_checksum1 = 1, soap_flag_acl1 = 1, soap_flag_created1 = 1, soap_flag_state1 = 1, soap_flag_url1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(((ns__fileinfo*)a)->id), "xsd:string"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_size1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "size", &(((ns__fileinfo*)a)->size), "xsd:unsignedLong"))
				{	soap_flag_size1--;
					continue;
				}
			if (soap_flag_checksum1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "checksum", &(((ns__fileinfo*)a)->checksum), "xsd:string"))
				{	soap_flag_checksum1--;
					continue;
				}
			if (soap_flag_acl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "acl", &(((ns__fileinfo*)a)->acl), "xsd:string"))
				{	soap_flag_acl1--;
					continue;
				}
			if (soap_flag_created1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "created", &(((ns__fileinfo*)a)->created), "xsd:string"))
				{	soap_flag_created1--;
					continue;
				}
			if (soap_flag_state1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons__filestate(soap, "state", &(((ns__fileinfo*)a)->state), "ns:filestate"))
				{	soap_flag_state1--;
					continue;
				}
			if (soap_flag_url1 && soap->error == SOAP_TAG_MISMATCH)
			{	char **p;
				soap_new_block(soap);
				for (((ns__fileinfo*)a)->__size_url = 0; !soap_element_begin_in(soap, "url", 1); ((ns__fileinfo*)a)->__size_url++)
				{	p = (char **)soap_push_block(soap, sizeof(char *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_string(soap, "url", p, "xsd:string"))
						break;
					soap_flag_url1 = 0;
				}
				((ns__fileinfo*)a)->url = (char **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_url1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient ns__fileinfo skipped */
			/* transient ~ns__fileinfo skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns__fileinfo *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__fileinfo, 0, sizeof(ns__fileinfo), 0, soap_copy_ns__fileinfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ns__fileinfo * SOAP_FMAC6 soap_new_ns__fileinfo(struct soap *soap, int n)
{	return soap_instantiate_ns__fileinfo(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__fileinfo(struct soap *soap, ns__fileinfo *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ns__fileinfo * SOAP_FMAC4 soap_instantiate_ns__fileinfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__fileinfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__fileinfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ns__fileinfo;
		if (size)
			*size = sizeof(ns__fileinfo);
	}
	else
	{	cp->ptr = (void*)new ns__fileinfo[n];
		if (size)
			*size = n * sizeof(ns__fileinfo);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns__fileinfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__fileinfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns__fileinfo %p -> %p\n", q, p));
	*(ns__fileinfo*)p = *(ns__fileinfo*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__del(struct soap *soap, const struct ns__del *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__del(struct soap *soap, struct ns__del *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__del(struct soap *soap, const struct ns__del *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__del);
	if (soap_out_ns__del(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__del(struct soap *soap, const char *tag, int id, const struct ns__del *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__del), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__del * SOAP_FMAC4 soap_get_ns__del(struct soap *soap, struct ns__del *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__del(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__del * SOAP_FMAC4 soap_in_ns__del(struct soap *soap, const char *tag, struct ns__del *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__del *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__del, sizeof(struct ns__del), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__del(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__del *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__del, 0, sizeof(struct ns__del), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__del * SOAP_FMAC6 soap_new_ns__del(struct soap *soap, int n)
{	return soap_instantiate_ns__del(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__del(struct soap *soap, struct ns__del *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__del * SOAP_FMAC4 soap_instantiate_ns__del(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__del(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__del, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__del;
		if (size)
			*size = sizeof(struct ns__del);
	}
	else
	{	cp->ptr = (void*)new struct ns__del[n];
		if (size)
			*size = n * sizeof(struct ns__del);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__del*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__del(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__del %p -> %p\n", q, p));
	*(struct ns__del*)p = *(struct ns__del*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__acl(struct soap *soap, const struct ns__acl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->acl);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__acl(struct soap *soap, struct ns__acl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->acl);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__acl(struct soap *soap, const struct ns__acl *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__acl);
	if (soap_out_ns__acl(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__acl(struct soap *soap, const char *tag, int id, const struct ns__acl *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__acl), type);
	soap_out_string(soap, "acl", -1, &a->acl, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__acl * SOAP_FMAC4 soap_get_ns__acl(struct soap *soap, struct ns__acl *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__acl(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__acl * SOAP_FMAC4 soap_in_ns__acl(struct soap *soap, const char *tag, struct ns__acl *a, const char *type)
{
	short soap_flag_acl = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__acl *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__acl, sizeof(struct ns__acl), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__acl(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_acl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "acl", &a->acl, "xsd:string"))
				{	soap_flag_acl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__acl *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__acl, 0, sizeof(struct ns__acl), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__acl * SOAP_FMAC6 soap_new_ns__acl(struct soap *soap, int n)
{	return soap_instantiate_ns__acl(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__acl(struct soap *soap, struct ns__acl *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__acl * SOAP_FMAC4 soap_instantiate_ns__acl(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__acl(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__acl, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__acl;
		if (size)
			*size = sizeof(struct ns__acl);
	}
	else
	{	cp->ptr = (void*)new struct ns__acl[n];
		if (size)
			*size = n * sizeof(struct ns__acl);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__acl*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__acl(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__acl %p -> %p\n", q, p));
	*(struct ns__acl*)p = *(struct ns__acl*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__info(struct soap *soap, const struct ns__info *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->pattern);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__info(struct soap *soap, struct ns__info *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->pattern);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__info(struct soap *soap, const struct ns__info *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__info);
	if (soap_out_ns__info(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__info(struct soap *soap, const char *tag, int id, const struct ns__info *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__info), type);
	soap_out_string(soap, "pattern", -1, &a->pattern, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__info * SOAP_FMAC4 soap_get_ns__info(struct soap *soap, struct ns__info *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__info(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__info * SOAP_FMAC4 soap_in_ns__info(struct soap *soap, const char *tag, struct ns__info *a, const char *type)
{
	short soap_flag_pattern = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__info *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__info, sizeof(struct ns__info), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__info(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_pattern && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "pattern", &a->pattern, "xsd:string"))
				{	soap_flag_pattern--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__info *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__info, 0, sizeof(struct ns__info), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__info * SOAP_FMAC6 soap_new_ns__info(struct soap *soap, int n)
{	return soap_instantiate_ns__info(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__info(struct soap *soap, struct ns__info *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__info * SOAP_FMAC4 soap_instantiate_ns__info(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__info(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__info, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__info;
		if (size)
			*size = sizeof(struct ns__info);
	}
	else
	{	cp->ptr = (void*)new struct ns__info[n];
		if (size)
			*size = n * sizeof(struct ns__info);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__info*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__info(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__info %p -> %p\n", q, p));
	*(struct ns__info*)p = *(struct ns__info*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__update(struct soap *soap, const struct ns__update *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons__fileinfo(soap, &a->file);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__update(struct soap *soap, struct ns__update *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->file = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__update(struct soap *soap, const struct ns__update *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__update);
	if (soap_out_ns__update(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__update(struct soap *soap, const char *tag, int id, const struct ns__update *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__update), type);
	soap_out_PointerTons__fileinfo(soap, "file", -1, &a->file, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__update * SOAP_FMAC4 soap_get_ns__update(struct soap *soap, struct ns__update *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__update(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__update * SOAP_FMAC4 soap_in_ns__update(struct soap *soap, const char *tag, struct ns__update *a, const char *type)
{
	short soap_flag_file = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__update *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__update, sizeof(struct ns__update), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__update(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_file && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons__fileinfo(soap, "file", &a->file, "ns:fileinfo"))
				{	soap_flag_file--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__update *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__update, 0, sizeof(struct ns__update), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__update * SOAP_FMAC6 soap_new_ns__update(struct soap *soap, int n)
{	return soap_instantiate_ns__update(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__update(struct soap *soap, struct ns__update *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__update * SOAP_FMAC4 soap_instantiate_ns__update(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__update(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__update, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__update;
		if (size)
			*size = sizeof(struct ns__update);
	}
	else
	{	cp->ptr = (void*)new struct ns__update[n];
		if (size)
			*size = n * sizeof(struct ns__update);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__update*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__update(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__update %p -> %p\n", q, p));
	*(struct ns__update*)p = *(struct ns__update*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__add(struct soap *soap, const struct ns__add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons__fileinfo(soap, &a->file);
	if (a->source)
	{	int i;
		for (i = 0; i < a->__size_source; i++)
		{
			soap_serialize_string(soap, a->source + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__add(struct soap *soap, struct ns__add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->file = NULL;
	a->__size_source = 0;
	a->source = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__add(struct soap *soap, const struct ns__add *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__add);
	if (soap_out_ns__add(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__add(struct soap *soap, const char *tag, int id, const struct ns__add *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__add), type);
	soap_out_PointerTons__fileinfo(soap, "file", -1, &a->file, "");
	if (a->source)
	{	int i;
		for (i = 0; i < a->__size_source; i++)
			soap_out_string(soap, "source", -1, a->source + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_get_ns__add(struct soap *soap, struct ns__add *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__add(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_in_ns__add(struct soap *soap, const char *tag, struct ns__add *a, const char *type)
{
	short soap_flag_file = 1, soap_flag_source = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__add *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__add, sizeof(struct ns__add), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__add(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_file && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons__fileinfo(soap, "file", &a->file, "ns:fileinfo"))
				{	soap_flag_file--;
					continue;
				}
			if (soap_flag_source && soap->error == SOAP_TAG_MISMATCH)
			{	char **p;
				soap_new_block(soap);
				for (a->__size_source = 0; !soap_element_begin_in(soap, "source", 1); a->__size_source++)
				{	p = (char **)soap_push_block(soap, sizeof(char *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_string(soap, "source", p, "xsd:string"))
						break;
					soap_flag_source = 0;
				}
				a->source = (char **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_source && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__add *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__add, 0, sizeof(struct ns__add), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__add * SOAP_FMAC6 soap_new_ns__add(struct soap *soap, int n)
{	return soap_instantiate_ns__add(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__add(struct soap *soap, struct ns__add *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__add * SOAP_FMAC4 soap_instantiate_ns__add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__add(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__add, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__add;
		if (size)
			*size = sizeof(struct ns__add);
	}
	else
	{	cp->ptr = (void*)new struct ns__add[n];
		if (size)
			*size = n * sizeof(struct ns__add);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__add*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__add(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__add %p -> %p\n", q, p));
	*(struct ns__add*)p = *(struct ns__add*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__delResponse(struct soap *soap, const struct ns__delResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->error_description);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__delResponse(struct soap *soap, struct ns__delResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->error_code);
	soap_default_int(soap, &a->sub_error_code);
	soap_default_string(soap, &a->error_description);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__delResponse(struct soap *soap, const struct ns__delResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__delResponse);
	if (soap_out_ns__delResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__delResponse(struct soap *soap, const char *tag, int id, const struct ns__delResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__delResponse), type);
	soap_element_result(soap, "error-code");
	soap_out_int(soap, "error-code", -1, &a->error_code, "");
	soap_out_int(soap, "sub-error-code", -1, &a->sub_error_code, "");
	soap_out_string(soap, "error-description", -1, &a->error_description, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__delResponse * SOAP_FMAC4 soap_get_ns__delResponse(struct soap *soap, struct ns__delResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__delResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__delResponse * SOAP_FMAC4 soap_in_ns__delResponse(struct soap *soap, const char *tag, struct ns__delResponse *a, const char *type)
{
	short soap_flag_error_code = 1, soap_flag_sub_error_code = 1, soap_flag_error_description = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__delResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__delResponse, sizeof(struct ns__delResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__delResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "error-code", &a->error_code, "xsd:int"))
				{	soap_flag_error_code--;
					continue;
				}
			if (soap_flag_sub_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sub-error-code", &a->sub_error_code, "xsd:int"))
				{	soap_flag_sub_error_code--;
					continue;
				}
			if (soap_flag_error_description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "error-description", &a->error_description, "xsd:string"))
				{	soap_flag_error_description--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_error_code > 0 || soap_flag_sub_error_code > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__delResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__delResponse, 0, sizeof(struct ns__delResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__delResponse * SOAP_FMAC6 soap_new_ns__delResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__delResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__delResponse(struct soap *soap, struct ns__delResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__delResponse * SOAP_FMAC4 soap_instantiate_ns__delResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__delResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__delResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__delResponse;
		if (size)
			*size = sizeof(struct ns__delResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__delResponse[n];
		if (size)
			*size = n * sizeof(struct ns__delResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__delResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__delResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__delResponse %p -> %p\n", q, p));
	*(struct ns__delResponse*)p = *(struct ns__delResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__aclResponse(struct soap *soap, const struct ns__aclResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->error_description);
	soap_serialize_string(soap, &a->acl);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__aclResponse(struct soap *soap, struct ns__aclResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->error_code);
	soap_default_int(soap, &a->sub_error_code);
	soap_default_string(soap, &a->error_description);
	soap_default_string(soap, &a->acl);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__aclResponse(struct soap *soap, const struct ns__aclResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__aclResponse);
	if (soap_out_ns__aclResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__aclResponse(struct soap *soap, const char *tag, int id, const struct ns__aclResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__aclResponse), type);
	soap_element_result(soap, "error-code");
	soap_out_int(soap, "error-code", -1, &a->error_code, "");
	soap_out_int(soap, "sub-error-code", -1, &a->sub_error_code, "");
	soap_out_string(soap, "error-description", -1, &a->error_description, "");
	soap_out_string(soap, "acl", -1, &a->acl, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__aclResponse * SOAP_FMAC4 soap_get_ns__aclResponse(struct soap *soap, struct ns__aclResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__aclResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__aclResponse * SOAP_FMAC4 soap_in_ns__aclResponse(struct soap *soap, const char *tag, struct ns__aclResponse *a, const char *type)
{
	short soap_flag_error_code = 1, soap_flag_sub_error_code = 1, soap_flag_error_description = 1, soap_flag_acl = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__aclResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__aclResponse, sizeof(struct ns__aclResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__aclResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "error-code", &a->error_code, "xsd:int"))
				{	soap_flag_error_code--;
					continue;
				}
			if (soap_flag_sub_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sub-error-code", &a->sub_error_code, "xsd:int"))
				{	soap_flag_sub_error_code--;
					continue;
				}
			if (soap_flag_error_description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "error-description", &a->error_description, "xsd:string"))
				{	soap_flag_error_description--;
					continue;
				}
			if (soap_flag_acl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "acl", &a->acl, "xsd:string"))
				{	soap_flag_acl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_error_code > 0 || soap_flag_sub_error_code > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__aclResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__aclResponse, 0, sizeof(struct ns__aclResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__aclResponse * SOAP_FMAC6 soap_new_ns__aclResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__aclResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__aclResponse(struct soap *soap, struct ns__aclResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__aclResponse * SOAP_FMAC4 soap_instantiate_ns__aclResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__aclResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__aclResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__aclResponse;
		if (size)
			*size = sizeof(struct ns__aclResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__aclResponse[n];
		if (size)
			*size = n * sizeof(struct ns__aclResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__aclResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__aclResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__aclResponse %p -> %p\n", q, p));
	*(struct ns__aclResponse*)p = *(struct ns__aclResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__infoResponse(struct soap *soap, const struct ns__infoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->error_description);
	if (a->file)
	{	int i;
		for (i = 0; i < a->__size_file; i++)
		{
			soap_embedded(soap, a->file + i, SOAP_TYPE_ns__fileinfo);
			a->file[i].soap_serialize(soap);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__infoResponse(struct soap *soap, struct ns__infoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->error_code);
	soap_default_int(soap, &a->sub_error_code);
	soap_default_string(soap, &a->error_description);
	a->__size_file = 0;
	a->file = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__infoResponse(struct soap *soap, const struct ns__infoResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__infoResponse);
	if (soap_out_ns__infoResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__infoResponse(struct soap *soap, const char *tag, int id, const struct ns__infoResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__infoResponse), type);
	soap_element_result(soap, "error-code");
	soap_out_int(soap, "error-code", -1, &a->error_code, "");
	soap_out_int(soap, "sub-error-code", -1, &a->sub_error_code, "");
	soap_out_string(soap, "error-description", -1, &a->error_description, "");
	if (a->file)
	{	int i;
		for (i = 0; i < a->__size_file; i++)
			a->file[i].soap_out(soap, "file", -1, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__infoResponse * SOAP_FMAC4 soap_get_ns__infoResponse(struct soap *soap, struct ns__infoResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__infoResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__infoResponse * SOAP_FMAC4 soap_in_ns__infoResponse(struct soap *soap, const char *tag, struct ns__infoResponse *a, const char *type)
{
	short soap_flag_error_code = 1, soap_flag_sub_error_code = 1, soap_flag_error_description = 1, soap_flag_file = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__infoResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__infoResponse, sizeof(struct ns__infoResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__infoResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "error-code", &a->error_code, "xsd:int"))
				{	soap_flag_error_code--;
					continue;
				}
			if (soap_flag_sub_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sub-error-code", &a->sub_error_code, "xsd:int"))
				{	soap_flag_sub_error_code--;
					continue;
				}
			if (soap_flag_error_description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "error-description", &a->error_description, "xsd:string"))
				{	soap_flag_error_description--;
					continue;
				}
			if (soap_flag_file && soap->error == SOAP_TAG_MISMATCH)
			{	ns__fileinfo *p;
				ns__fileinfo q;
				q.soap_default(soap);
				soap_new_block(soap);
				for (a->__size_file = 0; !soap_element_begin_in(soap, "file", 1); a->__size_file++)
				{	p = (ns__fileinfo *)soap_push_block(soap, sizeof(ns__fileinfo));
					memcpy(p, &q, sizeof(ns__fileinfo));
					p->soap_default(soap);
					soap_revert(soap);
					if (!soap_in_ns__fileinfo(soap, "file", p, "ns:fileinfo"))
						break;
					soap_flag_file = 0;
				}
				a->file = (ns__fileinfo *)soap_save_block(soap, NULL, 1);
				if (!soap_flag_file && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_error_code > 0 || soap_flag_sub_error_code > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__infoResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__infoResponse, 0, sizeof(struct ns__infoResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__infoResponse * SOAP_FMAC6 soap_new_ns__infoResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__infoResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__infoResponse(struct soap *soap, struct ns__infoResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__infoResponse * SOAP_FMAC4 soap_instantiate_ns__infoResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__infoResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__infoResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__infoResponse;
		if (size)
			*size = sizeof(struct ns__infoResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__infoResponse[n];
		if (size)
			*size = n * sizeof(struct ns__infoResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__infoResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__infoResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__infoResponse %p -> %p\n", q, p));
	*(struct ns__infoResponse*)p = *(struct ns__infoResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__updateResponse(struct soap *soap, const struct ns__updateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->error_description);
	soap_embedded(soap, &a->file, SOAP_TYPE_ns__fileinfo);
	a->file.soap_serialize(soap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__updateResponse(struct soap *soap, struct ns__updateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->error_code);
	soap_default_int(soap, &a->sub_error_code);
	soap_default_string(soap, &a->error_description);
	a->file.ns__fileinfo::soap_default(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__updateResponse(struct soap *soap, const struct ns__updateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__updateResponse);
	if (soap_out_ns__updateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__updateResponse(struct soap *soap, const char *tag, int id, const struct ns__updateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__updateResponse), type);
	soap_element_result(soap, "error-code");
	soap_out_int(soap, "error-code", -1, &a->error_code, "");
	soap_out_int(soap, "sub-error-code", -1, &a->sub_error_code, "");
	soap_out_string(soap, "error-description", -1, &a->error_description, "");
	a->file.soap_out(soap, "file", -1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__updateResponse * SOAP_FMAC4 soap_get_ns__updateResponse(struct soap *soap, struct ns__updateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__updateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__updateResponse * SOAP_FMAC4 soap_in_ns__updateResponse(struct soap *soap, const char *tag, struct ns__updateResponse *a, const char *type)
{
	short soap_flag_error_code = 1, soap_flag_sub_error_code = 1, soap_flag_error_description = 1, soap_flag_file = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__updateResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns__updateResponse, sizeof(struct ns__updateResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_ns__updateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "error-code", &a->error_code, "xsd:int"))
				{	soap_flag_error_code--;
					continue;
				}
			if (soap_flag_sub_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sub-error-code", &a->sub_error_code, "xsd:int"))
				{	soap_flag_sub_error_code--;
					continue;
				}
			if (soap_flag_error_description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "error-description", &a->error_description, "xsd:string"))
				{	soap_flag_error_description--;
					continue;
				}
			if (soap_flag_file && soap->error == SOAP_TAG_MISMATCH)
				if (a->file.soap_in(soap, "file", "ns:fileinfo"))
				{	soap_flag_file--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_error_code > 0 || soap_flag_sub_error_code > 0 || soap_flag_file > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__updateResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__updateResponse, 0, sizeof(struct ns__updateResponse), 0, soap_copy_ns__updateResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__updateResponse * SOAP_FMAC6 soap_new_ns__updateResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__updateResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__updateResponse(struct soap *soap, struct ns__updateResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__updateResponse * SOAP_FMAC4 soap_instantiate_ns__updateResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__updateResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__updateResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__updateResponse;
		if (size)
			*size = sizeof(struct ns__updateResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__updateResponse[n];
		if (size)
			*size = n * sizeof(struct ns__updateResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__updateResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__updateResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__updateResponse %p -> %p\n", q, p));
	*(struct ns__updateResponse*)p = *(struct ns__updateResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__addResponse(struct soap *soap, const struct ns__addResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->error_description);
	soap_embedded(soap, &a->file, SOAP_TYPE_ns__fileinfo);
	a->file.soap_serialize(soap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__addResponse(struct soap *soap, struct ns__addResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->error_code);
	soap_default_int(soap, &a->sub_error_code);
	soap_default_string(soap, &a->error_description);
	a->file.ns__fileinfo::soap_default(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__addResponse(struct soap *soap, const struct ns__addResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__addResponse);
	if (soap_out_ns__addResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__addResponse(struct soap *soap, const char *tag, int id, const struct ns__addResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__addResponse), type);
	soap_element_result(soap, "error-code");
	soap_out_int(soap, "error-code", -1, &a->error_code, "");
	soap_out_int(soap, "sub-error-code", -1, &a->sub_error_code, "");
	soap_out_string(soap, "error-description", -1, &a->error_description, "");
	a->file.soap_out(soap, "file", -1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_get_ns__addResponse(struct soap *soap, struct ns__addResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__addResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_in_ns__addResponse(struct soap *soap, const char *tag, struct ns__addResponse *a, const char *type)
{
	short soap_flag_error_code = 1, soap_flag_sub_error_code = 1, soap_flag_error_description = 1, soap_flag_file = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ns__addResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns__addResponse, sizeof(struct ns__addResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	soap_default_ns__addResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "error-code", &a->error_code, "xsd:int"))
				{	soap_flag_error_code--;
					continue;
				}
			if (soap_flag_sub_error_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sub-error-code", &a->sub_error_code, "xsd:int"))
				{	soap_flag_sub_error_code--;
					continue;
				}
			if (soap_flag_error_description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "error-description", &a->error_description, "xsd:string"))
				{	soap_flag_error_description--;
					continue;
				}
			if (soap_flag_file && soap->error == SOAP_TAG_MISMATCH)
				if (a->file.soap_in(soap, "file", "ns:fileinfo"))
				{	soap_flag_file--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_error_code > 0 || soap_flag_sub_error_code > 0 || soap_flag_file > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__addResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ns__addResponse, 0, sizeof(struct ns__addResponse), 0, soap_copy_ns__addResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__addResponse * SOAP_FMAC6 soap_new_ns__addResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__addResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__addResponse(struct soap *soap, struct ns__addResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__addResponse * SOAP_FMAC4 soap_instantiate_ns__addResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__addResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__addResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__addResponse;
		if (size)
			*size = sizeof(struct ns__addResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__addResponse[n];
		if (size)
			*size = n * sizeof(struct ns__addResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__addResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__addResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__addResponse %p -> %p\n", q, p));
	*(struct ns__addResponse*)p = *(struct ns__addResponse*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons__fileinfo(struct soap *soap, ns__fileinfo *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns__fileinfo))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons__fileinfo(struct soap *soap, ns__fileinfo *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons__fileinfo);
	if (soap_out_PointerTons__fileinfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons__fileinfo(struct soap *soap, const char *tag, int id, ns__fileinfo *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns__fileinfo);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns__fileinfo ** SOAP_FMAC4 soap_get_PointerTons__fileinfo(struct soap *soap, ns__fileinfo **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons__fileinfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ns__fileinfo ** SOAP_FMAC4 soap_in_PointerTons__fileinfo(struct soap *soap, const char *tag, ns__fileinfo **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ns__fileinfo **)soap_malloc(soap, sizeof(ns__fileinfo *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns__fileinfo *)soap_instantiate_ns__fileinfo(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ns__fileinfo **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns__fileinfo, sizeof(ns__fileinfo), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostring(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_string))
		soap_serialize_string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostring(struct soap *soap, char **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostring);
	if (soap_out_PointerTostring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostring(struct soap *soap, const char *tag, int id, char **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_string);
	if (id < 0)
		return soap->error;
	return soap_out_string(soap, tag, id, *a, type);
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_get_PointerTostring(struct soap *soap, char ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_in_PointerTostring(struct soap *soap, const char *tag, char ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (char ***)soap_malloc(soap, sizeof(char **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (char ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_string, sizeof(char *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons__filestate(struct soap *soap, enum ns__filestate *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_ns__filestate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons__filestate(struct soap *soap, enum ns__filestate *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons__filestate);
	if (soap_out_PointerTons__filestate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons__filestate(struct soap *soap, const char *tag, int id, enum ns__filestate *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns__filestate);
	if (id < 0)
		return soap->error;
	return soap_out_ns__filestate(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum ns__filestate ** SOAP_FMAC4 soap_get_PointerTons__filestate(struct soap *soap, enum ns__filestate **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons__filestate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum ns__filestate ** SOAP_FMAC4 soap_in_PointerTons__filestate(struct soap *soap, const char *tag, enum ns__filestate **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (enum ns__filestate **)soap_malloc(soap, sizeof(enum ns__filestate *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns__filestate(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum ns__filestate **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns__filestate, sizeof(enum ns__filestate), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedLONG64(struct soap *soap, ULONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedLONG64(struct soap *soap, ULONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedLONG64);
	if (soap_out_PointerTounsignedLONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedLONG64(struct soap *soap, const char *tag, int id, ULONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedLONG64);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedLONG64(soap, tag, id, *a, type);
}

SOAP_FMAC3 ULONG64 ** SOAP_FMAC4 soap_get_PointerTounsignedLONG64(struct soap *soap, ULONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedLONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ULONG64 ** SOAP_FMAC4 soap_in_PointerTounsignedLONG64(struct soap *soap, const char *tag, ULONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ULONG64 **)soap_malloc(soap, sizeof(ULONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedLONG64(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (ULONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedLONG64, sizeof(ULONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

/* End of file_soapC.cpp */
