#include "../../std.h"

#include <ldap.h>

#include "se_ldap.h"

#include "se_ns_rc.h"


SENameServerRC::SENameServerRC(const char* contact,const char* se_url) try: SENameServer(contact,se_url),valid(false),url(contact) {
  if(strcasecmp(url.Protocol().c_str(),"rc")) return;
  valid=true;
  name=se_url;
  std::string::size_type n = name.find(':');
  if(n != std::string::npos) name=name.substr(n+3);
  n=name.find('/');
  if(n != std::string::npos) name.resize(n);
} catch (std::exception e) {
}

SENameServerRC::~SENameServerRC(void) {




}

int SENameServerRC::Get(SEAttributes& file) {
  int err=0;
  LDAPConnector ldap(url.Host().c_str(),url.Port());
  if(!ldap) {
    return -1;
  };
  std::string filter = "&(filename="; filter+=file.id(); filter+=")";
  err=ldap.CheckEntry(url.Path().c_str(),filter.c_str());
  if(err == -1) {
    return -1;
  };
  if(err == 1) {
    return -1;
  };
  std::list<LDAPConnector::Attribute> attrs;
  attrs.push_back(LDAPConnector::Attribute("filechecksum"));
  attrs.push_back(LDAPConnector::Attribute("size"));
  attrs.push_back(LDAPConnector::Attribute("modifytime"));
  err=ldap.GetAttributes((std::string("rf=")+file.id()+",fin=LFROOT,"+url.Path()).c_str(),attrs);
  if(err == -1) {
    return -1;
  };
  if(err == 1) {
    return -1;
  };
  uint64_t size;
  struct tm; 
  uint8_t cksum[16];












  return err;
}

int SENameServerRC::Register(SEFile& file,bool require_unique) {
  int err=0;
  LDAPConnector ldap(url.Host().c_str(),url.Port());
  if(!ldap) {
    return -1;
  };
  std::string loc_url = se_url();
  //std::string::size_type n = loc_url.find(':');
  //if(n == std::string::npos) {
  //  return -1;
  //};
  //loc_url.replace(0,n,"se");
  // store LFN
  std::list<LDAPConnector::Attribute> attrs;
  attrs.push_back(LDAPConnector::Attribute("filename",file.id()));
  err=ldap.SetAttributes(url.Path().c_str(),attrs);
  if(err==-1) return -1;
  if(err == 1) {
    // if LFN present compare metadata
    if(require_unique) return -1;
    std::string filter = "&";
    char buf[100];
    snprintf(buf,99,"%Lu",file.size());
    filter+="(size="; filter+=buf; filter+=")";
    if(file.checksum_available()) {
      const char* s = file.checksum().c_str();
      if(strncmp(s,"cksum:",6) == 0) {
        filter+="(filechecksum="; filter+=(s+6); filter+=")";
      };
    };
    snprintf(buf,99,"%u",timegm((struct tm*)file.created()));
    filter+="(modifytime="; filter+=buf; filter+=")";
    err=ldap.CheckEntry((std::string("rf=")+file.id()+",fin=LFROOT,"+url.Path()).c_str(),filter.c_str());
    if(err != 0) return -1;
  } else {
    // store metadata
    std::list<LDAPConnector::Attribute> attrs;
    attrs.push_back(LDAPConnector::Attribute("objectClass","top"));
    attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusTop"));
    attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusReplicaFileGroup"));
    err=ldap.CreateEntry(("fin=LFROOT,"+url.Path()).c_str(),attrs);
    if(err == -1) return -1; 
    attrs.clear();
    attrs.push_back(LDAPConnector::Attribute("objectClass","top"));
    attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusTop"));
    attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusReplicaLogicalFile"));
    char buf[100];
//    for(int i = 0;i<16;i++) snprintf(buf+(i*2),99-(i*2),"%02x",file.md5()[i]);
//    attrs.push_back(LDAPConnector::Attribute("filechecksum",buf));
    snprintf(buf,99,"%Lu",file.size());
    attrs.push_back(LDAPConnector::Attribute("size",buf));
//    snprintf(buf,99,"%u",timegm((struct tm*)file.created()));
//    attrs.push_back(LDAPConnector::Attribute("modifytime",buf));
    err=ldap.CreateEntry((std::string("rf=")+file.id()+",fin=LFROOT,"+url.Path()).c_str(),attrs);
    if(err == -1) return -1; 
    if(err == 1) {  // inconsistency - existing metadata for non-existent LFN
      return -1;
    };
  };
  // create location
  attrs.clear();
  attrs.push_back(LDAPConnector::Attribute("objectClass","top"));
  attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusTop"));
  attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusReplicaInfo"));
  attrs.push_back(LDAPConnector::Attribute("objectClass","GlobusReplicaLocation"));
  attrs.push_back(LDAPConnector::Attribute("uc",loc_url.c_str()));
  attrs.push_back(LDAPConnector::Attribute("filename",file.id()));
  err=ldap.CreateEntry((std::string("re=")+name+","+url.Path()).c_str(),attrs);
  if(err == -1) return -1;
  if(err == 1) {
    // store location
    attrs.clear();
    attrs.push_back(LDAPConnector::Attribute("filename",file.id()));
    err=ldap.SetAttributes((std::string("re=")+name+","+url.Path()).c_str(),attrs);
    if(err==-1) return -1;
  };
  file.state_reg(REG_STATE_ANNOUNCED);
  return 0;
}

int SENameServerRC::Unregister(SEFile& file,bool allow_last) {
  return -1;
}

int SENameServerRC::Modify(SEFile& file) {
  return -1;
}

