#include "../../std.h"

#include "se_registrator.h"
#include "../../misc/time_utils.h"

// Manage registration/unregistration to Indexing Service
void SERegistrator_Thread::func(void) {
  TimeInterval files_interval(60*60); // 1 hour
  while(true) {
    files.block();
    // go through all storages
    for(SEFilesList::iterator fs = files.begin();fs!=files.end();++fs) {
      SENameServer* ns = (*fs)->NS();
      files.unblock();
      if(ns) ns->Maintain();
      // go through all files
      // check if it is time to retry registration (TODO)
      if(*fs) (*fs)->Register();
      if(*fs) (*fs)->Unregister();
      if(files_interval.test()) if(*fs) (*fs)->Maintain();
      files.block();
    };
    files.unblock();
    idle(10*60*1000); // 10 minutes
  };
}

