#include "../../std.h"

#include "../../misc/inttostring.h"
#include "../../misc/log_time.h"
#include "../../auth/auth.h"

#include "../httpsd.h"

HTTP_Service::HTTP_Service(void) {
}

HTTP_Service::~HTTP_Service(void) {
}

HTTP_Error HTTP_Service::get(const char* uri,int &keep_alive) {
  odlog(ERROR)<<"HTTP_Service: virtual get - running incomplete service ?"<<std::endl;
  return HTTP_NOT_IMPLEMENTED;
}

HTTP_Error HTTP_Service::put(const char* uri,int &keep_alive) {
  odlog(ERROR)<<"HTTP_Service: virtual put - running incomplete service ?"<<std::endl;
  return HTTP_NOT_IMPLEMENTED;
}

HTTP_Error HTTP_Service::post(const char* uri,int &keep_alive) {
  odlog(ERROR)<<"HTTP_Service: virtual post - running incomplete service ?"<<std::endl;
  return HTTP_NOT_IMPLEMENTED;
}

static bool match_url(const std::string& uri,bool subtree,const char* u,std::string& subpath) {
  // 'u' contains full url
  // 'uri' is url/path taken from configuration
  // each service can be configured to serve either:
  // 1) path
  // 2) port+path
  // 3) full url
  subpath="";
  const char* u_ = u;
  if((uri.length()==0) || (uri[0] == '/')) { // serving path
    // Skip protocol
    u_=strchr(u_,':'); if(u_==NULL) return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    // Skip host:port
    u_++; u_=strchr(u_,'/'); if(u_==NULL) u_=""; // top url
  } else if(uri[0] == ':') { // serving port+path
    // Skip protocol
    u_=strchr(u_,':'); if(u_==NULL) return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    // Skip host
    u_++; u_=strchr(u_,':'); if(u_==NULL) return false; // bad url
  };
  if(strncmp(u_,uri.c_str(),uri.length()) != 0) return false;
  if(u_[uri.length()] == 0) return true;
  if(subtree) {
    if(u_[uri.length()] == '/') {
      subpath=u_+uri.length()+1;
      return true;
    };
    return false;
  } else {
    if((u_[uri.length()] == '/') && (u_[uri.length()+1] == 0)) return true;
    return false;
  };
}

bool HTTP_Service_description::match(const char* u,std::string& subpath) {
  return match_url(uri,properties.subtree,u,subpath);
}

bool HTTP_Service_item::match(const char *u,std::string& subpath) {
  return match_url(uri,subtree,u,subpath);
};


HTTP_Service* HTTP_Service_description::create(HTTP_Connector& c) {
  return (*creator)(c,uri.c_str(),properties.arg);
}

HTTP_Service_description::HTTP_Service_description(const char* u,service_creator c,const HTTP_Service_Properties &prop):creator(c),uri(u),properties(prop) {
}


HTTP_Services::HTTP_Services(void) {
  pthread_mutex_init(&lock,NULL);
}

HTTP_Services::~HTTP_Services(void) {
  pthread_mutex_destroy(&lock);
}

bool HTTP_Services::add(const char* u,service_creator c,const HTTP_Service_Properties &prop) {
  pthread_mutex_lock(&lock);
  desc.push_back(HTTP_Service_description(u,c,prop));
  pthread_mutex_unlock(&lock);
  return true;
}

bool HTTP_Services::remove(const char* u,service_creator c) {
  pthread_mutex_lock(&lock);
  odlog(ERROR)<<"IMPLEMET ME, PLEASE! Removing service '"<<u<<"'"<<std::endl;

/* !!!!!!!!!!!!!! TODO !!!!!!!!!!!!!!! */


  pthread_mutex_unlock(&lock);
  return true;
}

HTTP_Service* HTTP_Services::get(HTTP_Connector& c,const char* u) {
  // 'u' contains full url
  std::string subpath;
  pthread_mutex_lock(&lock);
  for(std::list<HTTP_Service_item>::iterator i = serv.begin();i!=serv.end();++i) {
    if((i->con == &c) && (i->match(u,subpath))) {
      odilog(DEBUG,c.pid)<<"Taking service from cache: "<<u<<std::endl;
      HTTP_Service* s = i->serv;
      pthread_mutex_unlock(&lock);
      if(s) {
        s->requested_url=u;
        s->requested_path=subpath;
      };
      return s;
    };
  };
  for(std::list<HTTP_Service_description>::iterator i = desc.begin();i!=desc.end();++i) {
    if(i->match(u,subpath)) {
      odilog(INFO,c.pid)<<"Creating new service: "<<u<<std::endl;
      HTTP_Service* s = i->create(c);
      if(s == NULL) break;
      serv.push_back(HTTP_Service_item(&c,i->uri.c_str(),i->properties.subtree,s)); 
      pthread_mutex_unlock(&lock);
      s->requested_url=u;
      s->requested_path=subpath;
      return s; 
    };
  };
  pthread_mutex_unlock(&lock);
  return NULL;
}

void HTTP_Services::close(const HTTP_Connector& c) {
  pthread_mutex_lock(&lock);
  for(std::list<HTTP_Service_item>::iterator i = serv.begin();i!=serv.end();) {
    if(i->con == &c) {
      delete (i->serv);
      i=serv.erase(i);
    } else { ++i; };
  };
  pthread_mutex_unlock(&lock);
}


