#ifndef __SAFELIST_H__
#define __SAFELIST_H__

#include "condition.h"

template <typename T> class SafeList {
 private:
  typedef enum {
    no_act = 0,
    unlink_act = 1,
    delete_act = 2
  } object_action_t;
  struct object_s {
    T* p;
    int usage;
    object_action_t act;
    struct object_s* prev;
    struct object_s* next;
  };
  typedef struct object_s object_t;
  object_t* first;
  object_t* last;
  LockSimple lock;
  int amount;
  // decrease counter and unlink from chain if 0
  void unuse(object_t* object) {
    if(!object) return;
    if((--(object->usage)) == 0) { 
      if(object->act != no_act) {
        if((object == first) && (object == last)) { first=NULL; last=NULL; }
        else if(object == first) { object->next->prev=NULL; first=object->next;}
        else if(object == last) { object->prev->next=NULL; last=object->prev; }
        else {object->prev->next=object->next;object->next->prev=object->prev;};
        if(object->act == delete_act) delete object->p;
        free(object);
      };
    };
  };
  void use(object_t* object) {
    if(!object) return;
    object->usage++;
  };
 public:
  class iterator {
   friend class SafeList<T>;
   private:
    SafeList* list;
    object_t* p;
    void inc(void) {
      if(list) {
        list->unuse(p);
        while(p) {
          p=p->next; if(p) if(p->act == no_act) break;
        };
        list->use(p);
      };
    };
    void dec(void) {
      if(list) {
        list->unuse(p);
        while(p) {
          p=p->prev; if(p) if(p->act == no_act) break;
        };
        list->use(p);
      };
    };
   public:
    iterator(void) { list=NULL; p=NULL; };
//    iterator(const iterator &i) { list=i.list; p=i.p; };
    void operator=(const iterator &i) {
      SafeList* l = list;
      if(l) l->lock.block();
      if(i.list && (i.list!=l)) i.list->lock.block();
      if(l) l->unuse(p);
      if(i.list) i.list->use(i.p);
      list=i.list; p=i.p;
      if(i.list && (i.list!=l)) i.list->lock.unblock();
      if(l) l->lock.unblock();
    }; 
    ~iterator(void) {
      if(list) {
        list->lock.block();
        list->unuse(p);
        list->lock.unblock();
      };
    };
    void operator++(void) { 
      if(list) {
        list->lock.block();
        list->unuse(p);
        while(p) {
          p=p->next; if(p) if(p->act == no_act) break;
        };
        list->use(p);
        list->lock.unblock();
      };
    };
    void operator--(void) {
      if(list) {
        list->lock.block();
        list->unuse(p);
        while(p) {
          p=p->prev; if(p) if(p->act == no_act) break;
        };
        list->use(p);
        list->lock.unblock();
      };
    };
    bool operator==(const iterator i) const {
      if(!list) return false;
      return ((list == i.list) && (p == i.p));
    };
    bool operator!=(const iterator i) const {
      if(!list) return true;
      return !((list == i.list) && (p == i.p));
    };
    T& operator*(void) const { return *(p->p); };
    T* operator->(void) const { if(p==NULL) return NULL; return p->p; };
    operator bool(void) const { return (list!=NULL); };
    bool exists(void) { return (p!=NULL); }; 
  };
 friend class iterator;
 public:
  SafeList(void) { first=NULL; last=NULL; amount=0; };
  ~SafeList(void) {  // !!!!!!!!!!!!  Destroy objects
  };
  iterator begin(void) {
    iterator i; i.list=this; i.p=first;
    lock.block();
    if(i.p) {
      use(i.p); if(i.p->act != no_act) i.inc();
    };
    lock.unblock();
    return i;
  };
  iterator end(void) { iterator i; i.list=this; i.p=NULL; return i; };
  iterator add(T& a) {
    object_t *p = (object_t*)malloc(sizeof(object_t));
    p->p=&a; p->usage=0; p->act=no_act; p->next=NULL; p->prev=NULL;
    lock.block();
    if(last) {
      last->next=p; p->prev=last; last=p;
    } else {
      first=p; last=p;
    };
    iterator i; i.list=this; i.p=p; p->usage++;
    amount++;
    lock.unblock();
    return i;
  };
  void remove(iterator &i) { // unlink and delete object
    if(i.list != this) return;
    if(i.p == NULL) return;
    lock.block();
    if(i.p->act == no_act) amount--;
    // check usage
    if((--(i.p->usage))) { // schedule action
      i.p->act=delete_act;
      i.p=i.p->next; // modify pointer to point to next object
      if(i.p) i.p->usage++;
      lock.unblock();
      return;
    };
    // unlink
    if((i.p == first) && (i.p == last)) { first=NULL; last=NULL; }
    else if(i.p == first) { i.p->next->prev=NULL; first=i.p->next; }
    else if(i.p == last) { i.p->prev->next=NULL; last=i.p->prev; }
    else { i.p->prev->next=i.p->next; i.p->next->prev=i.p->prev; };
    object_t* oo = i.p;
    i.p=i.p->next; // modify pointer to point to next object
    if(i.p) i.p->usage++;
    // delete object
    delete oo->p; free(oo);
    lock.unblock();
    return;
  };
  T* unlink(iterator &i) {
    if(i.list != this) return NULL;
    if(i.p == NULL) return NULL;
    lock.block();
    if(i.p->act == no_act) amount--;
    // check usage
    if((--(i.p->usage))) { // schedule action
      if(i.p->act != delete_act) i.p->act=unlink_act; 
      T* o = i.p->p;
      i.p=i.p->next; // modify pointer to point to next object
      if(i.p) i.p->usage++;
      lock.unblock();
      return o;
    };
    // unlink
    if((i.p == first) && (i.p == last)) { first=NULL; last=NULL; }
    else if(i.p == first) { i.p->next->prev=NULL; first=i.p->next; }
    else if(i.p == last) { i.p->prev->next=NULL; last=i.p->prev; }
    else { i.p->prev->next=i.p->next; i.p->next->prev=i.p->prev; };
    T* o = i.p->p;
    object_t oo = i.p;
    i.p=i.p->next; // modify pointer to point to next object
    if(i.p) i.p->usage++;
    free(oo);
    lock.unblock();
    return o;
  };
  int size(void) { return amount; };
  operator bool(void) { return (amount > 0); };
};

#endif
