#ifndef __THREAD_H__
#define __THREAD_H__

#include "condition.h"
#include <pthread.h>

class Thread {
 private:
  pthread_t thr;
  CondSimple kicker;
  bool stop;
  static void* run(void* it) {
    ((Thread*)it)->thr = pthread_self();
    ((Thread*)it)->idle(-1);
    ((Thread*)it)->func();
    ((Thread*)it)->exit();
    return NULL;
  };
  virtual void func(void) {
    std::cerr<<"Pure virtual thread started and finished"<<std::endl;
  };
  bool valid;
 public:
  Thread(void):stop(false) {
    valid=false;
    if(pthread_create(&thr,NULL,&run,(void*)this) != 0) return;
    pthread_detach(thr);
    valid=true; 
  };
  ~Thread(void) {
    exit();
  };
  void attention(void) {
    kicker.signal();
  };
  void exit(void) {
    if(pthread_equal(pthread_self(),thr)) {
      kicker.block(); valid=false; kicker.signal_nonblock(); kicker.unblock();
      pthread_exit(NULL);
    };
    stop=true;
    while(valid) kicker.wait();
  };
  void idle(int t = 0) {
    if(pthread_equal(pthread_self(),thr)) {
      if(stop) exit();
      if(t<0) { kicker.wait(); } else { kicker.wait(t); };
      if(stop) exit();
    };
  };
  operator bool(void) { return valid; };
};

#endif // __THREAD_H__
