#include "../std.h"

#include "../misc/stringtoint.h"
#include "../misc/inttostring.h"
#include "time_utils.h"
#include <iostream>


int stringtotime(struct tm &t,const std::string &s) {
  if(s.length() != 14) {
    return -1;
  };
  memset(&t,0,sizeof(t));
  if((!stringtoint(s.substr(0,4),t.tm_year)) ||
     (!stringtoint(s.substr(4,2),t.tm_mon)) ||
     (!stringtoint(s.substr(6,2),t.tm_mday)) ||
     (!stringtoint(s.substr(8,2),t.tm_hour)) ||
     (!stringtoint(s.substr(10,2),t.tm_min)) ||
     (!stringtoint(s.substr(12,2),t.tm_sec))) {
    return -1;
  };
  t.tm_year-=1900;
  t.tm_mon-=1;
  return 0;
}

int timetostring(const struct tm &t,std::string &s) {
  char buf[256];
  int l = snprintf(buf,255,"%04u%02u%02u%02u%02u%02u",
    t.tm_year+1900,t.tm_mon+1,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec);
  buf[l]=0; s=buf;
  return (l==14)?0:1;
}

std::string timetostring(const struct tm &t) {
  std::string s;
  timetostring(t,s);
  return s;
}

int timetostring(const time_t &t,std::string &s) {
  struct tm* tt;
  struct tm tt_;
  tt=gmtime_r (&t,&tt_);
  if(tt == NULL) return 1;
  return timetostring(*tt,s);
}

std::string timetostring(const time_t &t) {
  std::string s;
  timetostring(t,s);
  return s;
}

int stringtotime(time_t &t,const std::string &s) {
  struct tm tt;
  int r = stringtotime(tt,s);
  if(r != 0) return r;
  t = mktime(&tt);
  if(t == -1) return -1;
  /* timezone conversion */
  long int timezone_;
  struct tm  tt_buf;
  struct tm* tt_;
  time_t t_;
  tt_=gmtime_r(&t,&tt_buf);
  tt_->tm_isdst=-1; t_ = mktime(tt_); timezone_=t-t_;
  t+=timezone_;
  return 0;
}
