#ifndef GM_REPLICA_H
#define GM_REPLICA_H

#include <string>
#include <list>
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
#include <globus_replica_catalog.h>
#include <pthread.h>
#endif

class RCManager;

class RCLocation {
 public:
  std::string name;
  std::string url;
  RCLocation(const char* url,const char* name);
  RCLocation(const std::string &url,const std::string &name);
};

class RCFile {
 friend class RCManager;
 private:
  typedef unsigned long long int ullint;
  std::string name;
  std::string path;  /* real full name */
  ullint size_i;
  std::string size;
  bool   size_valid;
  // ullint checksum_i; !!!
  std::string checksum;
  bool   checksum_valid;
  ullint timestamp_i;
  std::string timestamp;
  bool   timestamp_valid;
 public:
  RCFile(void);
  RCFile(const std::string &name);
  // RCFile(const std::string &name,const std::string &path);
  // RCFile(const std::string &name,ullint size,ullint checksum,ullint timestamp);
  RCFile(const std::string &name,ullint size,const char* checksum,ullint timestamp);
  // RCFile(const std::string &name_,ullint size_,bool size_valid_,ullint checksum_,
  //        bool checksum_valid_,ullint timestamp_,bool timestamp_valid_);
  RCFile(const std::string &name_,ullint size_,bool size_valid_,const char* checksum_,
         bool checksum_valid_,ullint timestamp_,bool timestamp_valid_);
  ~RCFile(void);
  bool is_valid(void) { return (name.length() != 0); };
  RCFile& operator= (const RCFile &file);
  const char* get_name(void) const { return name.c_str(); };
  // ullint get_checksum(void) const { return checksum_i; }; !!!
  const char* get_checksum(void) const { return checksum.c_str(); };
  ullint get_size(void) const { return size_i; };
  ullint get_timestamp(void) const { return timestamp_i; };
};

class RCManager {
 private:
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
  static pthread_mutex_t sasl_mutex;
  globus_replica_catalog_collection_handle_t handle;
  globus_replica_catalog_collection_handleattr_t attrs;
  globus_replica_catalog_authentication_mode_t auth_mode;
#endif
  bool inited;  
 public:
  RCManager(const std::string &url,const std::string &manager,const std::string &pwd,bool secure=false);
  ~RCManager(void);
  bool AddFile(const RCFile &RCFile,bool unique = true);
  bool UpdateFile(const RCFile &RCFile);
  bool AddFileLocation(const RCFile &file,
             const std::string &host,const std::string &root_dir,bool unique);
//  bool CheckLocation(const std::string &host);
  /* from given hostname construct url for sending file to */
  bool GetLocations(const std::string &host,std::list<RCLocation> &locs,const char* file_name = NULL,bool reverse = false);
  bool GetFile(RCFile &file);
  bool RemoveFile(const RCFile &file);
  bool RemoveFileLocation(const RCFile &file,const std::string &host);
  bool ListFiles(std::list<RCFile> &files);
  bool is_open(void) { return inited; };
};

#endif
