#include "../std.h"
#include <string>
#include "replica_utils.h"

const char* rc_url_head = "rc://";
static const char* ldap_url_head = "ldap://";

bool extract_RC_from_url(std::string &url,std::string &rc_url) {
  std::string::size_type host_pos=strlen(rc_url_head);
  if(strncasecmp(rc_url_head,url.c_str(),host_pos)) {
    url.resize(0); return false;
  };
  std::string::size_type path_pos=url.find('/',host_pos);
  if(path_pos == std::string::npos) path_pos=url.length();
  std::string::size_type rc_pos=url.find('@',host_pos);
  if(rc_pos == std::string::npos) rc_pos=host_pos-1;
  if(rc_pos >= path_pos) rc_pos=host_pos-1;
  if(path_pos != url.length()) { path_pos=url.find('/',path_pos+1); };
  if(path_pos == std::string::npos) path_pos=url.length();
  rc_pos++;
  rc_url="ldap://"+url.substr(rc_pos,path_pos-rc_pos);
  url.erase(rc_pos,path_pos-rc_pos);
  return true;
}

bool insert_RC_to_url(std::string &url,const std::string &rc_url) {
  std::string::size_type host_pos=strlen(rc_url_head);
  if(strncasecmp(rc_url_head,url.c_str(),host_pos)) return false;
  std::string::size_type path_pos=url.find('/',host_pos);
  if(path_pos == std::string::npos) path_pos=url.length();
  std::string::size_type rc_pos=url.find('@',host_pos);
  if(rc_pos == std::string::npos) rc_pos=url.length();
  if(rc_pos >= path_pos) rc_pos=host_pos;
  if(url[rc_pos] != '@') return false; /* already have rc */
  rc_pos++;
  if(url[rc_pos] != '/') return false; /* already have rc */
  int l=strlen(ldap_url_head);
  std::string rc_url_(rc_url);
  /* remove ldap:// */
  if(!strncasecmp(rc_url_.c_str(),ldap_url_head,l)) { rc_url_.erase(0,l); };
  /* make sure there is one / */
  if(rc_url_.find('/') == std::string::npos) rc_url_+='/';
  url.insert(rc_pos,rc_url_);
  return true;
}
