#include "../std.h"
#include "../misc/stringtoint.h"
#include "../misc/substitute.h"
#include "../misc/log_time.h"
#include "url_map.h"


UrlMap::UrlMap(void) {
}

UrlMap::~UrlMap(void) {
}

bool UrlMap::map(std::string &url) const {
  for(std::list<map_entry>::const_iterator i=entries.begin();
                                                       i!=entries.end();++i) {
    if(!strncmp(url.c_str(),i->initial.c_str(),i->initial.length())) {
      std::string tmp_url = url;
      tmp_url.replace(0,i->initial.length(),i->replacement);
      /* must return semi-valid url */
      if(tmp_url[0] == '/') { /* local file - check permissions */
        int h = open(tmp_url.c_str(),O_RDONLY);
        if(h == -1) {
          olog << "file "<<tmp_url<<" is not accessible"<<std::endl;
          return false;
        };
        close(h);
        olog<<"Mapping "<<url<<" to ";
        if(i->access.length() != 0) {  /* how it should be accessed on nodes */
          tmp_url.replace(0,i->replacement.length(),i->access);
          url="link://"+tmp_url;
        }
        else {
          url="file://"+tmp_url;
        };
        olog_<<url<<std::endl;
        return true;
      };
      /* other cases are treated as url */
      olog<<"Mapping "<<url<<" to "<<tmp_url<<std::endl;
      url=tmp_url;
      return true;
    };
  };
  return false;
}

bool UrlMap::local(const std::string &url) const {
  for(std::list<map_entry>::const_iterator i=entries.begin();
                                                     i!=entries.end();++i) {
    if(!strncmp(url.c_str(),i->initial.c_str(),i->initial.length())) {
      return true;
    };
  };
  return false;
}

void UrlMap::add(const std::string &templ,const std::string &repl,const std::string &accs) {
  entries.push_back(map_entry(templ,repl,accs));
}

void UrlMap::add(const char* templ,const char* repl,const char* accs) {
  entries.push_back(map_entry(templ,repl,accs));
}

