#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <map>
#include <algorithm>
#include <ctype.h>

#ifdef HAVE_SSTREAM
#include <sstream>
#else
#include <strstream>
#endif

#include <iomanip>

#include "Utils.h"


// need to wrap for gcc 3.2
inline int to_lower (int x) { return tolower(x); }


std::map <int, int> ParseStringToMap (const std::string & value) {

  // Parses a string of the type "2 4:711 6:710" to an integer to integer map
  // A missing second arguments are given the value INT_MAX

  std::map <int, int> result;

  if (value.empty()) return result;
  std::string::size_type pos = 0;
  while (pos != std::string::npos) {
    std::string::size_type spacepos = value.find (' ', pos);
    std::string entry;
    if (spacepos == std::string::npos)
      entry = value.substr (pos);
    else
      entry = value.substr (pos, spacepos - pos);
    int first;
    int second;
    std::string::size_type colonpos = entry.find (':');
    if (colonpos == std::string::npos) {
      first = atoi (entry.c_str());
      second = INT_MAX;
    }
    else {
      first = atoi (entry.substr (0, colonpos).c_str());
      second = atoi (entry.substr (colonpos + 1).c_str());
    }
    result [first] = second;
    pos = spacepos;
    if (pos != std::string::npos) pos++;
  }
  return result;
}


std::map <long int, int> ParseFreeCpuStringToMap (const std::string & value) {

  std::map <long int, int> result;

  if (value.empty()) return result;
  std::string::size_type pos = 0;
  while (pos != std::string::npos) {
    std::string::size_type spacepos = value.find (' ', pos);
    std::string entry;
    if (spacepos == std::string::npos)
      entry = value.substr (pos);
    else
      entry = value.substr (pos, spacepos - pos);
    int first;
    long int second;
    std::string::size_type colonpos = entry.find (':');
    if (colonpos == std::string::npos) {
      first = atoi (entry.c_str());
      second = LONG_MAX;
    }
    else {
      first = atoi (entry.substr (0, colonpos).c_str());
      second = atol (entry.substr (colonpos + 1).c_str()) * 60;
    }
    result [second] = first;
    pos = spacepos;
    if (pos != std::string::npos) pos++;
  }
  return result;
}


std::map <std::string, std::string> ParseOptionString (const std::string & optstring) {

  std::map <std::string, std::string> result;

  if (optstring.empty()) return result;
  std::string::size_type pos = 0;
  while (pos != std::string::npos) {
    std::string::size_type semicpos = optstring.find (';', pos);
    std::string entry;
    if (semicpos == std::string::npos)
      entry = optstring.substr (pos);
    else
      entry = optstring.substr (pos, semicpos - pos);
    std::string first;
    std::string second;
    std::string::size_type equalpos = entry.find ('=');
    if (equalpos == std::string::npos) {
      first = entry;
      second = "";
    }
    else {
      first = entry.substr (0, equalpos);
      second = entry.substr (equalpos + 1);
    }
    // make the key case insensitive
    std::transform (first.begin(), first.end(), first.begin(), to_lower);
    result [first] = second;
    pos = semicpos;
    if (pos != std::string::npos) pos++;
  }
  return result;
}


bool GetBooleanOption (const std::map <std::string, std::string> & options,
		       const std::string & opt, bool * value) {

  const std::map <std::string, std::string>::const_iterator mssi = options.find (opt);
  if (mssi != options.end()) {
    if (mssi->second [0] == 'y' || mssi->second [0] == 'Y' || // yes
	mssi->second [0] == 't' || mssi->second [0] == 'T' || // true
	mssi->second [0] == '1') {
      *value = true;
      return true;
    }
    if (mssi->second [0] == 'n' || mssi->second [0] == 'N' || // no
	mssi->second [0] == 'f' || mssi->second [0] == 'F' || // false
	mssi->second [0] == '0') {
      *value = false;
      return true;
    }
  }
  return false;
}


void RemoveDefaultPort (std::string & url) {

  std::string::size_type pos = url.find ("://");
  if (pos == std::string::npos) return;
  std::string protocol = url.substr (0, pos);
  pos += 3;
  std::string::size_type slashpos = url.find ('/', pos);
  std::string::size_type colonpos = url.find (':', pos);
  if (colonpos == std::string::npos) return;
  if (slashpos != std::string::npos && slashpos < colonpos) return;
  std::string port;
  if (slashpos == std::string::npos)
    port = url.substr (colonpos + 1);
  else
    port = url.substr (colonpos + 1, slashpos - colonpos - 1);
  if ((protocol == "ftp" && port == "21") ||
      (protocol == "http" && port == "80") ||
      (protocol == "sftp" && port == "115") ||
      (protocol == "https" && port == "443") ||
      (protocol == "gsiftp" && port == "2811")) {
    if (slashpos == std::string::npos)
      url.erase (colonpos);
    else
      url.erase (colonpos, slashpos - colonpos);
  }
}


std::string UnX509 (const std::string & escaped) {

  std::string unescaped (escaped);
  std::string::size_type pos = 0;
  while ((pos = unescaped.find ("\\x", pos)) != std::string::npos) {
#ifdef HAVE_SSTREAM
    std::stringstream ss (unescaped.substr (pos + 2, 2));
#else
    std::strstream ss;
    ss << unescaped.substr (pos + 2, 2) << ends;
#endif
    int i;
    ss >> std::hex >> i;
    unescaped.replace (pos, 4, 1, i);
  }
  return unescaped;
}
