#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstdlib>
#include <cstring>
#include <iostream>
#include <string>
#include <vector>

#include "Preferences.h"
#include "CertInfo.h"
#include "DateTime.h"
#include "MdsQuery.h"

#define __UI_LIBRARY__
#include "ui_uploader.h"

#include "ngui.h"


extern "C"
int ngresumexx (const std::vector <std::string> & jobs,
		const std::vector <std::string> & joblists,
		const std::vector <std::string> & clusterselect_,
		const std::vector <std::string> & clusterreject_,
		const std::vector <std::string> & status,
		const bool all,
		int timeout,
		int debug,
		const bool anonymous) {

  std::vector <std::string> clusterselect = ResolveAliases (clusterselect_);
  std::vector <std::string> clusterreject = ResolveAliases (clusterreject_);

  std::vector <std::string> jobids;
  std::vector <Cluster> clusterlist;

  int error = 0;
  ActivateGlobus();

  // setting defaults

  if (timeout == UNDEFINED) timeout = iGetEnv ("NGTIMEOUT");
  if (timeout == UNDEFINED) timeout = iGetDef ("NGTIMEOUT");
  if (timeout == UNDEFINED) timeout = DEFAULT_TIMEOUT;

  if (debug == UNDEFINED) debug = iGetEnv ("NGDEBUG");
  if (debug == UNDEFINED) debug = iGetDef ("NGDEBUG");
  if (debug == UNDEFINED) debug = 0;

  // get user info

  CertInfo user;
  if (!user) {
    error = 1;
    goto errorexit;
  }

  if (debug) {
    std::cout << "User subject name: " << user.GetSN() << std::endl;
    std::cout << "Remaining proxy lifetime: "
	      << Period (user.TimeLeft()) << std::endl;
  }

  // finding the information

  jobids = GetJobIDs (jobs, joblists, clusterselect, clusterreject, status,
		      all);

  if (all && jobids.empty()) {
    std::cout << "ngresume: No jobs" << std::endl;
    goto errorexit;
  }

  if (jobids.empty()) {
    std::cerr << "ngresume: no valid jobids given" << std::endl;
    std::cerr << "Use \"ngresume -help\" for help" << std::endl;
    error = 1;
    goto errorexit;
  }

  for (std::vector <std::string>::iterator vsi = jobids.begin();
       vsi != jobids.end(); vsi++) {
    int pos0 = 0;
    if (vsi->substr (0, 9) == "gsiftp://") pos0 = 9;
    std::string::size_type pos = vsi->find_first_of (":/", pos0);
    if (pos == std::string::npos) {
      std::cerr << "ngresume: invalid jobid: " << *vsi << std::endl;
      error = 1;
      continue;
    }
    std::string clustername = vsi->substr (pos0, pos - pos0);
    bool found = false;
    for (std::vector <Cluster>::iterator cli = clusterlist.begin();
	 !found && cli != clusterlist.end(); cli++)
      if (clustername == cli->GetName()) found = true;
    if (!found) clusterlist.push_back (clustername);
  }

  if (clusterlist.empty()) {
    std::cerr << "ngresume: no valid jobids given" << std::endl;
    error = 1;
    goto errorexit;
  }

  FindClusterInfo (clusterlist, Mds::JobManipulation, user.GetSNx(), anonymous,
		   timeout, debug);

  for (std::vector <std::string>::iterator vsi = jobids.begin();
       vsi != jobids.end(); vsi++) {

    Cluster * c = NULL;
    std::string rerunable;

    bool found = false;
    bool selected = false;

    for (std::vector <Cluster>::iterator cli = clusterlist.begin();
	 !found && cli != clusterlist.end(); cli++)
      for (std::vector <Queue>::iterator qli = cli->queues.begin();
	   !found && qli != cli->queues.end(); qli++)
	for (std::vector <Job>::iterator jli = qli->jobs.begin();
	     !found && jli != qli->jobs.end(); jli++)
	  if (*vsi == jli->GetId()) {
	    if (jli->IsStatus (status)) {
	      selected = true;
	      c = &*cli;
	      rerunable = jli->GetRerunable();
	    }
	    found = true;
	  }

    if (!found) {
      std::cerr << "ngresume: no job with jobid " << *vsi << " found"
		<< std::endl;
      error = 1;
      continue;
    }
    if (!selected)
      continue;
    if (rerunable.empty()) {
      std::cerr << "ngresume: job " << *vsi << " could not be resumed"
		<< std::endl;
      error = 1;
      continue;
    }
    std::string::size_type pos = vsi->rfind ('/');
    if (pos == std::string::npos) {
      std::cerr << "ngresume: invalid jobid: " << *vsi << std::endl;
      error = 1;
      continue;
    }
    std::string shortid = vsi->substr (pos + 1);

    const std::vector <std::string> filenames;

    std::cout << "ngresume: resuming job " << *vsi << " at state " << rerunable
	      << std::endl;

    char * shortjobid = strdup (shortid.c_str());
    int err = ui_uploader (c->GetContact().c_str(), NULL, &shortjobid, NULL,
			   RSL_ACTION_RESTART, filenames, debug, timeout);
    free (shortjobid);

    if (err) {
      std::cerr << "ngresume: job " << *vsi << " could not be resumed."
		<< std::endl;
      error = 1;
      continue;
    }
  }

 errorexit:
  DeactivateGlobus();
  return error;
}
