#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>
#include <stdio.h>

#include "Preferences.h"
#include "CertInfo.h"
#include "DateTime.h"
#include "MdsQuery.h"
#include "Giis.h"

#include "ngui.h"


extern "C"
int ngsyncxx (const std::vector <std::string> & clusterselect_,
	      const std::vector <std::string> & clusterreject_,
	      const std::vector <std::string> & giisurls,
	      const bool force,
	      int timeout,
	      int debug,
	      const bool anonymous) {

  std::vector <std::string> clusterselect = ResolveAliases (clusterselect_);
  std::vector <std::string> clusterreject = ResolveAliases (clusterreject_);

  std::vector <Giis> giislist;
  std::vector <Cluster> clusterlist;
  std::multimap <std::string, std::string> ngjobmap;

  int error = 0;
  ActivateGlobus();

  // setting defaults

  if (timeout == UNDEFINED) timeout = iGetEnv ("NGTIMEOUT");
  if (timeout == UNDEFINED) timeout = iGetDef ("NGTIMEOUT");
  if (timeout == UNDEFINED) timeout = DEFAULT_TIMEOUT;

  if (debug == UNDEFINED) debug = iGetEnv ("NGDEBUG");
  if (debug == UNDEFINED) debug = iGetDef ("NGDEBUG");
  if (debug == UNDEFINED) debug = 0;

  // get user info

  CertInfo user;
  if (!user) {
    error = 1;
    goto errorexit;
  }

  if (debug) {
    std::cout << "User subject name: " << user.GetSN() << std::endl;
    std::cout << "Remaining proxy lifetime: "
	 << Period (user.TimeLeft()) << std::endl;
  }

  if (!force) {
    std::cout << "Synchronizing the local list of active jobs with the information in the MDS" << std::endl;
    std::cout << "can result in some inconsistencies. Very recently submitted jobs might not yet" << std::endl;
    std::cout << "be present in the MDS information, whereas jobs very recently scheduled for" << std::endl;
    std::cout << "deletion can still be present." << std::endl;
    std::cout << "Are you sure you want to synchronize your local job list? [y/n] ";
    std::string response;
    std::cin >> response;
    if (response != "y" && response != "Y") {
      std::cout << "Cancelling synchronization request" << std::endl;
      goto errorexit;
    }
  }

  // find available clusters

  for (std::vector <std::string>::const_iterator vsi = clusterselect.begin();
       vsi != clusterselect.end(); vsi++) {
    bool found = false;
    for (std::vector <Cluster>::iterator cli = clusterlist.begin();
	 !found && cli != clusterlist.end(); cli++)
      if (*vsi == cli->GetName()) found = true;
    if (!found) clusterlist.push_back (*vsi);
  }

  if (clusterlist.empty()) {
    if (GetGiises (giisurls, giislist)) {
      error = 1;
      goto errorexit;
    }

    clusterlist = FindClusters (giislist, user.GetSNx(), anonymous,
				timeout, debug);
    if (clusterlist.empty()) {
      std::cerr << "ngsync: could not retrieve cluster list from giis" << std::endl;
      error = 1;
      goto errorexit;
    }
  }

  for (std::vector <std::string>::const_iterator vsi = clusterreject.begin();
       vsi != clusterreject.end(); vsi++)
    for (std::vector <Cluster>::iterator cli = clusterlist.begin();
	 cli != clusterlist.end(); cli++)
      if (cli->GetName() == *vsi) {
	if (debug) std::cout << "Rejecting cluster: " << *vsi << std::endl;
	clusterlist.erase (cli);
	break;
      }

  FindClusterInfo (clusterlist, Mds::JobInfo, user.GetSNx(), anonymous,
		   timeout, debug);

  // finding the information

  for (std::vector <Cluster>::iterator cli = clusterlist.begin();
       cli != clusterlist.end(); cli++)
    for (std::vector <Queue>::iterator qli = cli->queues.begin();
	 qli != cli->queues.end(); qli++)
      for (std::vector <Job>::iterator jli = qli->jobs.begin();
	   jli != qli->jobs.end(); jli++)
	ngjobmap.insert (std::multimap <std::string, std::string>::value_type (jli->GetName(),
								jli->GetId()));

  if (!ngjobmap.empty()) {
    std::string filename = GetEnv ("HOME");
    filename.append ("/.ngjobs");
    std::ofstream ngjobs (filename.c_str());

    if (debug) std::cout << "Found the following jobs:" << std::endl;

    for (std::multimap <std::string, std::string>::iterator mmssi = ngjobmap.begin();
	 mmssi != ngjobmap.end(); mmssi++) {
      ngjobs << mmssi->second << '#' << mmssi->first << std::endl;
      if (debug) std::cout << mmssi->second << std::endl;
    }

    ngjobs.close();
  }
  else {
    std::cout << "No jobs found." << std::endl;

    std::string filename = GetEnv ("HOME");
    filename.append ("/.ngjobs");
    remove (filename.c_str());
  }

 errorexit:
  DeactivateGlobus();
  return error;
}
