#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "ngui.h"

extern "C" {


const char * ngversion () { return VERSION; }


int ngcat (const char *const *const jobs,
	   const char *const *const joblists,
	   const char *const *const clusterselect,
	   const char *const *const clusterreject,
	   const char *const *const status,
	   const int all,
	   const int whichfile,
	   const int timeout,
	   const int debug,
	   const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);

  return ngcatxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		  whichfile, timeout, debug, anonymous);
}


int ngclean (const char *const *const jobs,
	     const char *const *const joblists,
	     const char *const *const clusterselect,
	     const char *const *const clusterreject,
	     const char *const *const status,
	     const int all,
	     const int force,
	     const int timeout,
	     const int debug,
	     const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);

  return ngcleanxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		    force, timeout, debug, anonymous);
}


int ngget (const char *const *const jobs,
	   const char *const *const joblists,
	   const char *const *const clusterselect,
	   const char *const *const clusterreject,
	   const char *const *const status,
	   const int all,
	   const char * directory,
	   const int usejobname,
	   const int keep,
	   const int timeout,
	   const int debug,
	   const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
    std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);
  std::string DIRECTORY;
  if (directory) DIRECTORY = directory;

  return nggetxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		  DIRECTORY, usejobname, keep, timeout, debug, anonymous);
}


int ngkill (const char *const *const jobs,
	    const char *const *const joblists,
	    const char *const *const clusterselect,
	    const char *const *const clusterreject,
	    const char *const *const status,
	    const int all,
	    const int keep,
	    const int timeout,
	    const int debug,
	    const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);

  return ngkillxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		   keep, timeout, debug, anonymous);
}


int ngrenew (const char *const *const jobs,
	     const char *const *const joblists,
	     const char *const *const clusterselect,
	     const char *const *const clusterreject,
	     const char *const *const status,
	     const int all,
	     const int timeout,
	     const int debug,
	     const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);

  return ngrenewxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		    timeout, debug, anonymous);
}


int ngresub (const char *const *const jobs,
	     const char *const *const joblists,
	     const char *const *const clusterselect,
	     const char *const *const clusterreject,
	     const char *const *const status,
	     const int all,
	     const char *const *const klusterselect,
	     const char *const *const klusterreject,
	     const char *const *const giisurls,
	     const char *const joblist,
	     const int dryrun,
	     const int dumpxrsl,
	     const int keep,
	     const int timeout,
	     const int debug,
	     const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);
  std::vector <std::string> KLUSTERSELECT;
  if (klusterselect)
    for (int i = 0; klusterselect[i]; i++)
      KLUSTERSELECT.push_back (klusterselect[i]);
  std::vector <std::string> KLUSTERREJECT;
  if (klusterreject)
    for (int i = 0; klusterreject[i]; i++)
      KLUSTERREJECT.push_back (klusterreject[i]);
  std::vector <std::string> GIISURLS;
  if (giisurls)
    for (int i = 0; giisurls[i]; i++)
      GIISURLS.push_back (giisurls[i]);
  std::string JOBLIST;
  if (joblist) JOBLIST = joblist;

  return ngresubxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		    KLUSTERSELECT, KLUSTERREJECT, GIISURLS, JOBLIST, dryrun,
		    dumpxrsl, keep, timeout, debug, anonymous);
}


int ngstat (const char *const *const jobs,
	    const char *const *const joblists,
	    const char *const *const clusterselect,
	    const char *const *const clusterreject,
	    const char *const *const status,
	    const int all,
	    const char *const *const giisurls,
	    const int clusters,
	    const int longlist,
	    const int timeout,
	    const int debug,
	    const int anonymous) {

  std::vector <std::string> JOBS;
  if (jobs)
    for (int i = 0; jobs[i]; i++)
      JOBS.push_back (jobs[i]);
  std::vector <std::string> JOBLISTS;
  if (joblists)
    for (int i = 0; joblists[i]; i++)
      JOBLISTS.push_back (joblists[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> STATUS;
  if (status)
    for (int i = 0; status[i]; i++)
      STATUS.push_back (status[i]);
  std::vector <std::string> GIISURLS;
  if (giisurls)
    for (int i = 0; giisurls[i]; i++)
      GIISURLS.push_back (giisurls[i]);

  return ngstatxx (JOBS, JOBLISTS, CLUSTERSELECT, CLUSTERREJECT, STATUS, all,
		   GIISURLS, clusters, longlist, timeout, debug, anonymous);
}


int ngsub (const char *const *const xrslfiles,
	   const char *const *const xrslstrings,
	   const char *const *const clusterselect,
	   const char *const *const clusterreject,
	   const char *const *const giisurls,
	   const char *const joblist,
	   const int dryrun,
	   const int dumpxrsl,
	   const int timeout,
	   const int debug,
	   const int anonymous) {

  std::vector <std::string> XRSLFILES;
  if (xrslfiles)
    for (int i = 0; xrslfiles[i]; i++)
      XRSLFILES.push_back (xrslfiles[i]);
  std::vector <std::string> XRSLSTRINGS;
  if (xrslstrings)
    for (int i = 0; xrslstrings[i]; i++)
      XRSLSTRINGS.push_back (xrslstrings[i]);
  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> GIISURLS;
  if (giisurls)
    for (int i = 0; giisurls[i]; i++)
      GIISURLS.push_back (giisurls[i]);
  std::string JOBLIST;
  if (joblist) JOBLIST = joblist;

  return ngsubxx (XRSLFILES, XRSLSTRINGS, CLUSTERSELECT, CLUSTERREJECT,
		  GIISURLS, JOBLIST, dryrun, dumpxrsl, timeout, debug,
		  anonymous);
}


int ngsync (const char *const *const clusterselect,
	    const char *const *const clusterreject,
	    const char *const *const giisurls,
	    const int force,
	    const int timeout,
	    const int debug,
	    const int anonymous) {

  std::vector <std::string> CLUSTERSELECT;
  if (clusterselect)
    for (int i = 0; clusterselect[i]; i++)
      CLUSTERSELECT.push_back (clusterselect[i]);
  std::vector <std::string> CLUSTERREJECT;
  if (clusterreject)
    for (int i = 0; clusterreject[i]; i++)
      CLUSTERREJECT.push_back (clusterreject[i]);
  std::vector <std::string> GIISURLS;
  if (giisurls)
    for (int i = 0; giisurls[i]; i++)
      GIISURLS.push_back (giisurls[i]);

  return ngsyncxx (CLUSTERSELECT, CLUSTERREJECT, GIISURLS, force, timeout,
		   debug, anonymous);
}

}
