#ifndef ARCLIB_TARGET
#define ARCLIB_TARGET

#include <list>

#include <arc/resource.h>
#include <arc/xrsl.h>

/** Exception class thrown in case of an error with targets. */
class TargetError : public ARCLibError {
 public:
	/** Standard exception class constructor. */
	TargetError(std::string message) : ARCLibError(message) { }
};


/** A Target is a possible job-submission target. Specifically it is a Queue
 *  with an Xrsl -- split into sub-Xrsls -- attached.
 */
class Target : public Queue {

	public:
		/** Constructor taking a queue and a xrsl. */
		Target(Queue aqueue, Xrsl axrsl = Xrsl());

		/** Puts an xrsl onto the target. */
		void AddXrsl(Xrsl axrsl);

		/** Returns the full list of subxrsl's left. Originally it is obtained
		 *  by calling SplitOrRelation on the given xrsl but the number might
		 *  be reduced during brokering.
		 */
		std::list<Xrsl>& GetXrsls();

		/** Returns the CpuTime of target. Basically it grabs the cputime,
		 *  gridtime or benchmarks attribute and scales it after the
		 *  information obtained from the Queue.
		 */		
		long GetCputime(Xrsl xrsl) throw(XrslError);

	private:
		/** The list of subxrsl's. */
		std::list<Xrsl> xrsls;
};


/** This function constructs the possible targets from the list of queues
 *  given. It performs a couple of check e.g. whether the user is authorized
 *  or the queue has any cpus at all and remove those queues where this
 *  does not hold.
 */
std::list<Target> ConstructTargets(std::list<Queue> queues,
                                   Xrsl axrsl = Xrsl()) throw(TargetError);


#endif // ARCLIB_TARGET
