#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <arc/broker.h>
#include <arc/notify.h>

#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#define _(A) dgettext("arclib", (A))
#else
#define _(A) (A)
#endif


void Broker::SetupAttributeBrokering(const std::string& attribute,
                                     std::list<Target>& targets) {

	std::list<Target>::iterator targit = targets.begin();
	while (targit != targets.end()) {

		std::list<Xrsl>& xrsls = targit->GetXrsls(); // target sub-xrsls
		std::list<Xrsl>::iterator xrslit = xrsls.begin();
		while (xrslit != xrsls.end()) {

			std::list<XrslRelation> rel = xrslit->GetAllRelations(attribute);
			bool erasesub = false;
			std::list<XrslRelation>::iterator it;
			for (it = rel.begin(); it != rel.end(); it++) {
				if (!RelationCheck(*targit, *it)) {
					notify(VERBOSE) << _("One sub-xrsl erased for target")
					                << " " << targit->name << "@"
					                << targit->cluster.hostname << " "
					                << _("by xrsl-attribute") << ": "
					                << attribute << std::endl;
					erasesub = true;
					break;
				}
			}
			
			if (erasesub) {
				xrslit = xrsls.erase(xrslit);
			} else {
				xrslit++;
			}
		}

		if (xrsls.size()==0) {
			notify(DEBUG) << _("Target") << " " << targit->name << "@"
			              << targit->cluster.hostname << " "
			              << _("eliminated by xrsl-attribute") << ": "
			              << attribute << std::endl;
			targit = targets.erase(targit);
		} else {
			targit++;
		}
	}
}


void Broker::SetupSorting(std::list<Target>& targets) {
	std::list<Target>::iterator it, it2, it3;

	if (GetNotifyLevel()>=VERBOSE) {
		notify(VERBOSE) << _("Targets being sorted") << ": ";
		std::list<Target>::iterator it;
		for (it = targets.begin(); it != targets.end(); it++)
			notify(VERBOSE) << it->name << "@" << it->cluster.hostname << ", ";
		notify(VERBOSE) << std::endl;
	}

	for (it = targets.begin(); it != targets.end(); it++) {
		it3 = it; it3++;
		for (it2 = it3; it2 != targets.end(); it2++) {
			if (Compare(*it, *it2)) {
				Target tmp = *it;
				*it = *it2;
				*it2 = tmp;
			}
		}
	}
}


bool Broker::RelationCheck(Target& target, XrslRelation& rel) {
	return true;
}


bool Broker::Compare(Target& target1, Target& target2) {
	return false; // equivalent to no sorting
}


void PerformBrokering(std::list<Broker*> brokers,
                      std::list<Target>& targets) {

	std::list<Broker*>::iterator it;
	for (it = brokers.begin(); it != brokers.end(); it++) {
		if (!targets.empty())
			(*it)->DoBrokering(targets);
	}
}
