#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef _GNU_SOURCE
#define _GNU_SOURCE 1
#include <dlfcn.h>
#include <arc/globusmodules.h>
#undef _GNU_SOURCE
#else
#include <dlfcn.h>
#include <arc/globusmodules.h>
#endif

#include <locale.h>
#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#define _(A) dgettext("arclib", (A))
#else
#define _(A) (A)
#endif

#include <globus_common.h>

#define GLOBUSMODULE_CLASS(class_name, module_name) \
\
class_name::class_name() throw(GlobusModuleError) { \
	activated = false; \
	globus_module_descriptor_t* module = \
	    (globus_module_descriptor_t*)dlsym(RTLD_DEFAULT, module_name); \
	if (module) { \
		int res = globus_module_activate(module); \
		if (res == GLOBUS_SUCCESS) activated = true; \
	} \
	if (!activated) \
		throw GlobusModuleError( \
			_("Failed to initialise") + std::string(" "module_name)); \
} \
\
\
class_name::~class_name() { \
	if (activated) { \
		globus_module_descriptor_t* module = \
		    (globus_module_descriptor_t*)dlsym(RTLD_DEFAULT, module_name); \
		/* workaround!!! if(module) globus_module_deactivate(module); */ \
	} \
} \
\
\
bool class_name::isactive(void) { \
	return activated; \
}


GLOBUSMODULE_CLASS(GlobusCommonModule, "globus_i_common_module")

GLOBUSMODULE_CLASS(GlobusGASSTransferModule, "globus_i_gass_transfer_module")

GLOBUSMODULE_CLASS(GlobusFTPControlModule, "globus_i_ftp_control_module")

GLOBUSMODULE_CLASS(GlobusFTPClientModule, "globus_i_ftp_client_module")

GLOBUSMODULE_CLASS(GlobusReplicaCatalogModule, "globus_i_replica_catalog_module")

GLOBUSMODULE_CLASS(GlobusGSIGSSAPIModule, "globus_i_gsi_gssapi_module")

GLOBUSMODULE_CLASS(GlobusErrorModule, "globus_i_error_module")

#if GLOBUS_IO_VERSION<5
GLOBUSMODULE_CLASS(GlobusIOModule, "globus_i_io_module")
#else
GLOBUSMODULE_CLASS(GlobusIOModule, "globus_l_io_module")
#endif

GLOBUSMODULE_CLASS(GlobusRSLModule, "globus_i_rsl_module")

GLOBUSMODULE_CLASS(GlobusGSICredentialModule, "globus_i_gsi_credential_module")

GLOBUSMODULE_CLASS(GlobusGSISysconfigModule, "globus_i_gsi_sysconfig_module")

GLOBUSMODULE_CLASS(GlobusRLSClientModule, "globus_rls_client_module")
