#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <arc/datetime.h>
#include <arc/notify.h>

Notify* Notify::notifier = NULL;


Notify::Notify() {
	nullstream = new std::ofstream("/dev/null");
	outstream = &std::cout;
	notifylevel = INFO;
	dotimestamp = false;
}


Notify::~Notify() {
	delete nullstream;
}


Notify* Notify::getNotifier() {
	if (notifier==NULL)
		notifier = new Notify();
	return notifier;
}


std::ostream& Notify::GetNullStream() {
	return *nullstream;
}


std::ostream& Notify::GetOutStream() {
	return *outstream;
}


void Notify::SetOutStream(std::ostream& stream) {
	outstream = &stream;
}


NotifyLevel Notify::GetNotifyLevel() {
	return notifylevel;
}


void Notify::SetNotifyLevel(const NotifyLevel level) {
	notifylevel = level;
}


void Notify::SetNotifyTimeStamp(bool timestamp) {
	dotimestamp = timestamp;
}


bool Notify::GetNotifyTimeStamp() {
	return dotimestamp;
}


std::ostream& notify(const NotifyLevel level) {
	if (level>Notify::getNotifier()->GetNotifyLevel()) {
		return Notify::getNotifier()->GetNullStream();
	} else {
		if(Notify::getNotifier()->GetNotifyTimeStamp()) {
			return Notify::getNotifier()->GetOutStream() << TimeStamp() << " ";
		} else {
			return Notify::getNotifier()->GetOutStream();
		}
	}
}


void SetNotifyLevel(const NotifyLevel level) {
	Notify::getNotifier()->SetNotifyLevel(level);
}


NotifyLevel GetNotifyLevel() {
	return Notify::getNotifier()->GetNotifyLevel();
}


void SetNotifyTimeStamp(const bool timestamp) {
	Notify::getNotifier()->SetNotifyTimeStamp(timestamp);
}
