#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if defined(__GXX_ABI_VERSION) && __GXX_ABI_VERSION >= 100
#include <cxxabi.h>
#endif

#include <cstdlib>
#include <string>
#include <typeinfo>

#include <arc/stringconv.h>

#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#define _(A) dgettext("arclib", (A))
#else
#define _(A) (A)
#endif

std::string StringConvErrorString(const std::type_info& t, bool empty) {

	std::string typestr(t.name());
#if defined(__GXX_ABI_VERSION) && __GXX_ABI_VERSION >= 100
	char* type = __cxxabiv1::__cxa_demangle(t.name(), NULL, NULL, NULL);
	if (type!=NULL) {
		typestr = type;
		free(type);
	}
#endif
	if (typestr.size() == 1) {
		switch (typestr[0]) {
		case 'v':
			typestr = "void";
			break;
		case 'w':
			typestr = "wchar_t";
			break;
		case 'b':
			typestr = "bool";
			break;
		case 'c':
			typestr = "char";
			break;
		case 'h':
			typestr = "unsigned char";
			break;
		case 's':
			typestr = "short";
			break;
		case 't':
			typestr = "unsigned short";
			break;
		case 'i':
			typestr = "int";
			break;
		case 'j':
			typestr = "unsigned int";
			break;
		case 'l':
			typestr = "long";
			break;
		case 'm':
			typestr = "unsigned long";
			break;
		case 'x':
			typestr = "long long";
			break;
		case 'y':
			typestr = "unsigned long long";
			break;
		case 'n':
			typestr = "__int128";
			break;
		case 'o':
			typestr = "unsigned __int128";
			break;
		case 'f':
			typestr = "float";
			break;
		case 'd':
			typestr = "double";
			break;
		case 'e':
			typestr = "long double";
			break;
		case 'g':
			typestr = "__float128";
			break;
		case 'z':
			typestr = "ellipsis";
			break;
		}
	}

	if (empty)
		return _("Can not convert empty string to") + (" " + typestr);
	else
		return _("Can not convert string to") + (" " + typestr);
}
