#include "../../std.h"


#include "srm2_soapH.h"
#include "permission_srm.h"
#include "identity_srm.h"

#include "object_access_srm.h"

ObjectAccessSRMv2::ObjectAccessSRMv2(void) {
}

ObjectAccessSRMv2::ObjectAccessSRMv2(const ObjectAccess& o):ObjectAccess(o) {
}

ObjectAccessSRMv2::~ObjectAccessSRMv2(void) {
}

SRMv2__TPermissionMode ObjectAccessSRMv2::get(struct soap* sp,SRMv2__TUserID* user) {
  if(!sp) return SRMv2__TPermissionMode__None;
  std::string uid("");
  if(user && (user->value)) uid=user->value;
  bool r = false;
  bool w = false;
  bool x = false;
  std::list<ObjectAccess::Item>::iterator i = items_.begin();
  for(;i!=items_.end();++i) {
    Identity* id = i->id();
    Permission* perm = i->permission();
    if((id == NULL) || (perm == NULL)) continue;
    if(IdentitySRMv2(*id).get() == uid) {
      PermissionSRMv2 p(*perm);
      r|=p.allowRead(); w|=p.allowWrite(); x|=p.allowExecute();
    };
  };
  PermissionSRMv2 p; p.allowRead(r); p.allowWrite(w); p.allowExecute(x);
  return p.get();
}

SRMv2__ArrayOfTUserPermission* ObjectAccessSRMv2::get(struct soap* sp) {
  if(!sp) return NULL;
  SRMv2__ArrayOfTUserPermission* a = soap_new_SRMv2__ArrayOfTUserPermission(sp,-1);
  if(a == NULL) return NULL;
  a->soap_default(sp);
  if(items_.size() <= 0) return a;
  a->userPermissionArray=(SRMv2__TUserPermission**)soap_malloc(sp,
                           sizeof(SRMv2__TUserPermission*)*items_.size());
  if(a->userPermissionArray == NULL) return NULL;
  std::list<ObjectAccess::Item>::iterator i = items_.begin();
  int n = 0;  
  for(;i!=items_.end();++i) {
    Identity* id = i->id();
    Permission* perm = i->permission();
    if((id == NULL) || (perm == NULL)) continue;
    a->userPermissionArray[n]=soap_new_SRMv2__TUserPermission(sp,-1);
    if(a->userPermissionArray[n] == NULL) return NULL;
    a->userPermissionArray[n]->soap_default(sp);
    a->userPermissionArray[n]->userID=soap_new_SRMv2__TUserID(sp,-1);
    if(a->userPermissionArray[n]->userID == NULL) return NULL;
    a->userPermissionArray[n]->userID->soap_default(sp);
    a->userPermissionArray[n]->userID->value=soap_strdup(sp,IdentitySRMv2(*id).get().c_str());
    if(a->userPermissionArray[n]->userID->value == NULL) return NULL;
    a->userPermissionArray[n]->mode=PermissionSRMv2(*perm).get();
    n++;
  };
  a->__sizeuserPermissionArray=n;
  return a;
}


void ObjectAccessSRMv2::modify_add(SRMv2__TUserID* user,SRMv2__TPermissionMode mode) {
  if(user == NULL) return;
  if(user->value == NULL) return;
  IdentitySRMv2 id(user->value);
  std::list<ObjectAccess::Item>::iterator i = items_.begin();
  // Looking for same identity
  for(;i!=items_.end();++i) {
    Identity* id_ = i->id(); if(id_ == NULL) continue;
    if(id == (*id_)) break;
  };
  if(i==items_.end()) {
    // Put new identity into list
    PermissionSRMv2 perm(mode);
    add(&id,&perm);
  } else {
    PermissionSRMv2* perm = (PermissionSRMv2*)(i->permission());
    if(perm) {
      perm->add(mode);
    };    
  };
}

void ObjectAccessSRMv2::modify_remove(SRMv2__TUserID* user,SRMv2__TPermissionMode mode) {
  if(user == NULL) return;
  if(user->value == NULL) return;
  IdentitySRMv2 id(user->value);
  std::list<ObjectAccess::Item>::iterator i = items_.begin();
  // Looking for same identity
  for(;i!=items_.end();++i) {
    Identity* id_ = i->id(); if(id_ == NULL) continue;
    if(id == (*id_)) break;
  };
  if(i!=items_.end()) {
    PermissionSRMv2* perm = (PermissionSRMv2*)(i->permission());
    if(perm) {
      perm->remove(mode);
    };
  };
}

void ObjectAccessSRMv2::clear(void) {
  items_.clear();
}

void ObjectAccessSRMv2::modify_add(SRMv2__TUserID* owner,
                  SRMv2__TOwnerPermission* ownerPermission,
                  SRMv2__ArrayOfTUserPermission* userPermission,
                  SRMv2__ArrayOfTGroupPermission* groupPermission,
                  SRMv2__TOtherPermission* otherPermission) {
  if(owner && ownerPermission) modify_add(owner,ownerPermission->mode);
  if(userPermission && userPermission->userPermissionArray && userPermission->__sizeuserPermissionArray) { 
    for(int n = 0;n<userPermission->__sizeuserPermissionArray;n++) {
      SRMv2__TUserPermission* p = userPermission->userPermissionArray[n];
      if(p) modify_add(p->userID,p->mode);
    };
  };
  if(groupPermission && groupPermission->groupPermissionArray && groupPermission->__sizegroupPermissionArray) { 
    for(int n = 0;n<groupPermission->__sizegroupPermissionArray;n++) {
      SRMv2__TGroupPermission* p = groupPermission->groupPermissionArray[n];
      if(p) {
        if(p->groupID) {
          SRMv2__TUserID u; u.value=p->groupID->value;
          modify_add(&u,p->mode);
        };
      };
    };
  };
}

void ObjectAccessSRMv2::modify_remove(SRMv2__TUserID* owner,
                  SRMv2__TOwnerPermission* ownerPermission,
                  SRMv2__ArrayOfTUserPermission* userPermission,
                  SRMv2__ArrayOfTGroupPermission* groupPermission,
                  SRMv2__TOtherPermission* otherPermission) {
  if(owner && ownerPermission) modify_remove(owner,ownerPermission->mode);
  if(userPermission && userPermission->userPermissionArray && userPermission->__sizeuserPermissionArray) {
    for(int n = 0;n<userPermission->__sizeuserPermissionArray;n++) {
      SRMv2__TUserPermission* p = userPermission->userPermissionArray[n];
      if(p) modify_remove(p->userID,p->mode);
    };
  };
  if(groupPermission && groupPermission->groupPermissionArray && groupPermission->__sizegroupPermissionArray) {
    for(int n = 0;n<groupPermission->__sizegroupPermissionArray;n++) {
      SRMv2__TGroupPermission* p = groupPermission->groupPermissionArray[n];
      if(p) {
        if(p->groupID) {
          SRMv2__TUserID u; u.value=p->groupID->value;
          modify_remove(&u,p->mode);
        };
      };
    };
  };
}

void ObjectAccessSRMv2::modify_set(SRMv2__TUserID* owner,
                  SRMv2__TOwnerPermission* ownerPermission,
                  SRMv2__ArrayOfTUserPermission* userPermission,
                  SRMv2__ArrayOfTGroupPermission* groupPermission,
                  SRMv2__TOtherPermission* otherPermission) {
  clear();
  modify_add(owner,ownerPermission,userPermission,groupPermission,otherPermission);
}

