#include "../../std.h"

#include <string>

#include "../se.h"
#include "../se/files.h"
#include "../../datamove/datapoint.h"
#include "../../misc/log_time.h"
#include "../../misc/escaped.h"
#include "../../misc/time_utils.h"

// one more hack
#undef SOAP_FMAC3
#define WITH_NOGLOBAL
#define SOAP_FMAC3 static
#include "srm1_soapC.cpp"
#include "srm1_soapClient.cpp"
#include "srm1_soapServer.cpp"

#include "srm_url.h"
#include "srm_utils.h"
#include "srm_request.h"

#include "srm.h"

#define WRONG_PROTOCOLS_MESSAGE "No supported protocols requested. Use HTTPS/G."

// --------------------------------------------------------------

int SRMv1Meth__get(struct soap *sp,
    ArrayOfstring*                      SURLs,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__getResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(it->se == NULL) return SOAP_FAULT;
  int n = SURLs?SURLs->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n); // Worst case
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="get";
  if(array_is_empty(SURLs)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  const char* proto = check_protocols(Protocols);
  if(!proto) {
    r._Result->errorMessage=WRONG_PROTOCOLS_MESSAGE;
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
   (files->check_acl(it->c->identity()) | it->se->check_acl()) & FILE_ACC_READ;
  acl_top_flags=acl_top_flags?0:FILE_ACC_READ;
  // Loop through requested files
  n=0;
  SRMRequest* request = new SRMRequest(requestId++,it->c->identity().DN(),"get");
  if(request) r._Result->requestId=request->id();
  for(;n<SURLs->__size;) {
    const char* surl = SURLs->__ptr[n];
    if(surl == NULL) continue;
    // extract file id
    bool isshort;
    std::string id = get_ID_from_SURL(surl,it->service_url.c_str(),&isshort);
    SRMv1Type__RequestFileStatus *f_status=            
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    // find stored file
    files->acquire();
    f_status->SURL=(char*)surl;
    f_status->fileId=n;
    SEFiles::iterator f =
            get_file(sp,id,files,f_status,it->c->identity(),acl_top_flags);
    if(f != files->end()) {
      f_status->TURL=soap_strdup(sp,
                    make_TURL(it->se->base_url(proto),f->id()).c_str());
      f->pin(it->c->identity().DN(),DEFAULT_PIN_TIME);
    } else {
      f_status->TURL=NULL;
    };
    files->release();
    if(request) {
      SRMRequestFile* f_ = request->add(f);
      if(f_) f_->shorturl(isshort);
    };
    ++n;
  };
  //r._Result->state ="Done";
  r._Result->state ="Active";
  r._Result->errorMessage=NULL;
  it->requests->add(request);
  return SOAP_OK;
}

int SRMv1Meth__copy(struct soap *sp,
    ArrayOfstring*                      sourceSURLs,
    ArrayOfstring*                      destSURLs,
    ArrayOfboolean*                     undefined_arg,
  struct SRMv1Meth__copyResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  int n = sourceSURLs?sourceSURLs->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="copy";
  if(array_is_empty(sourceSURLs)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  if(array_is_empty(destSURLs) || (destSURLs->__size != n)) {
    r._Result->errorMessage="Number of destinations does not match";
    return SOAP_OK;
  };
  // Check if destinations are local. If not - reject request.
  URL u_s(it->service_url.c_str());
  for(n=0;n<destSURLs->__size;n++) {
    if(destSURLs->__ptr[n] == NULL) {
      r._Result->errorMessage="At least one of destinations is missing";
      return SOAP_OK;
    };
    SRM_URL u(destSURLs->__ptr[n]);
    if(!u) {
      r._Result->errorMessage="This service only supports SRM destinations";
      return SOAP_OK;
    };
    if((u.Host() != u_s.Host()) ||
       (u.Port() != u_s.Port()) ||
       (u.Path() != u_s.Path())) {
      r._Result->errorMessage="This service only supports local destinations";
      return SOAP_OK;
    };
  };
  // Check if sources are supported
  for(n=0;n<sourceSURLs->__size;n++) {
    if(destSURLs->__ptr[n] == NULL) {
      r._Result->errorMessage="At least one of sources is missing";
      return SOAP_OK;
    };
    // Rude method - but cleanest so far
    DataPoint u(destSURLs->__ptr[n]);
    if(!u) {
      r._Result->errorMessage="At least one of sources is unsupported";
      return SOAP_OK;
    };
  };
  // Behave like for "put" request. Only define files with sources.
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
             (files->check_acl(it->c->identity()) | it->se->check_acl()) & 
             FILE_ACC_CREATE;
  if(!acl_top_flags) {
    r._Result->errorMessage="Access denied.";
    return SOAP_OK;
  };
  SRMRequest* request = new SRMRequest(requestId++,it->c->identity().DN(),"copy");
  if(request) r._Result->requestId=request->id();
  // Loop through requested files
  for(n=0;n<sourceSURLs->__size;++n) {
    SRMv1Type__RequestFileStatus *f_status=
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    SRM_URL dest(destSURLs->__ptr[n]);
    if(!dest) continue; // should not happen - URL is already checked
    std::string id = dest.FileName();
    if(id.length() == 0) continue;
    long long size = 0;
    std::string surl_;
    if(dest.Short()) {
      surl_=make_SURL_short(it->service_url,id);
    } else {
      surl_=make_SURL(it->service_url,id);
    };
    f_status->SURL=soap_strdup(sp,surl_.c_str());
    f_status->size=size;
    f_status->checksumValue=NULL;
    f_status->checksumType=NULL;
    f_status->isPinned=false;
    f_status->isPermanent=true;
    f_status->isCached=false;
    //f_status->estSecondsToStart=60;
    f_status->state="Failed";
    f_status->sourceFilename=soap_strdup(sp,sourceSURLs->__ptr[n]);
    f_status->destFilename=soap_strdup(sp,destSURLs->__ptr[n]);
    f_status->queueOrder=0;
    f_status->fileId=n;
    f_status->TURL=NULL;
    f_status->owner=NULL;
    f_status->group=NULL;
    f_status->permMode=0;
    // create new file
    SEAttributes attr(id.c_str(),it->c->identity());
    //attr.checksum(std::string("undefined:"));
    time_t t = 0; attr.created(&t);
    attr.source(sourceSURLs->__ptr[n]);
    SEFiles::iterator f = it->se->new_file(attr);
    if(!f.exists()) {
      r._Result->errorMessage="Failed to create one of new files";
      if(request) delete request;
      // TODO: destroy other files
      return SOAP_OK;
    };
    // Here file is inserted into list already
    // Store user's proxy (if delegated)
    int hh = -1;
    const char* proxy_fname = it->c->identity().proxy();
    if(proxy_fname && proxy_fname[0]) {
      int hh=::open(proxy_fname,O_RDONLY);
      if(hh != -1) {
        std::string cred;
        const char* s;
        char buf[256];
        for(;;) {
          int ll=::read(hh,buf,sizeof(buf));
          if((ll==0) || (ll==-1)) break;
          cred.append(buf,ll);
        };
        ::close(hh);
        if(f->write_credentials(cred.c_str()) != 0) {
          odlog(ERROR)<<"Can't write delegated credentials"<<std::endl; 
        };
      } else {
        odlog(ERROR)<<"Can't read delegated credentials"<<std::endl; 
      };
    };
    std::string acl = it->c->identity_subject();
    if(acl.length()) acl="<gacl><entry><person><dn>"+acl+
            "</dn></person>"+
            "<allow><read/><write/><list/><admin/></allow></entry></gacl>";
    if(f->write_acl(it->c->identity(),acl.c_str()) != 0) {
      odlog(ERROR)<<"SRM: failed to acquire/store ACL: "<<acl<<std::endl;
      if(f->state_file() == FILE_STATE_ACCEPTED) files->remove(*f);
      r._Result->errorMessage="Failed to create ACL for file";
      if(request) delete request;
      return SOAP_OK;
    };
    // register *new* file
    if(!it->se->register_new_file(&(*f))) {
      r._Result->errorMessage="Failed to register new file";
      if(request) delete request;
      return SOAP_OK;
    };
    file_state_t fst = FILE_STATE_REQUESTED;
    //if(size == 0) fst=FILE_STATE_COMPLETE; // empty file easy to handle
    if(!f->state_file(fst)) {
      odlog(ERROR)<<"SRM: failed to set "<<file_state_str[fst]<<std::endl;
      files->NS()->Unregister(*f);
      // TODO: if failed set state to repeat later
      files->remove(*f);
      r._Result->errorMessage="Failed to remember file's state";
      if(request) delete request;
      return SOAP_OK;
    };
    // Prepare answer about this file
    f_status->state="Pending";
    // Link file to request
    if(request) {
      SRMRequestFile* f_ = request->add(f);
      if(f_) { f_->shorturl(dest.Short()); f_->running(true); };
    };
  };
  r._Result->errorMessage=NULL;
  r._Result->state ="Pending";
  r._Result->retryDeltaTime=60;
  it->requests->add(request);
  it->se->new_files();
  return SOAP_OK;
}

int SRMv1Meth__ping(struct soap *sp,
  bool &_Result) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  _Result=true;
  return SOAP_OK;
}

int SRMv1Meth__ping(struct soap *sp,
  struct SRMv1Meth__pingResponse& r) {
  SRMv1Meth__ping(sp,r._Result);
}

int SRMv1Meth__pin(struct soap *sp,
    ArrayOfstring*                      TURLs,
  struct SRMv1Meth__pinResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  int n = TURLs?TURLs->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="pin";
  if(array_is_empty(TURLs)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
         files->check_acl(it->c->identity()) | it->se->check_acl() &
         (FILE_ACC_READ | FILE_ACC_WRITE);
  acl_top_flags=acl_top_flags?0:(FILE_ACC_READ | FILE_ACC_WRITE);
  // Loop through requested files
  n=0;
  for(;n<TURLs->__size;++n) {
    const char* turl = TURLs->__ptr[n];
    if(turl == NULL) continue;
    // extract file id
    std::string id = get_ID_from_TURL(turl,it->service_url.c_str());
    if(id.length() == 0) continue;
    SRMv1Type__RequestFileStatus *f_status=
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    // find stored file
    files->acquire();
    f_status->fileId=n;
    f_status->SURL=NULL;
    SEFiles::iterator f =
           get_file(sp,id,files,f_status,it->c->identity(),acl_top_flags);
    f_status->TURL=(char*)turl;
    if(f != files->end()) {
      f->pin(it->c->identity().DN(),DEFAULT_PIN_TIME);
      f_status->isPinned=(f->pinned() > 0);
    };
    files->release();
  };
  r._Result->state ="Done";
  r._Result->errorMessage=NULL;
  return SOAP_OK;
}

int SRMv1Meth__unPin(struct soap *sp,
    ArrayOfstring*                      TURLs,
    int                                 RequestId,
  struct SRMv1Meth__unPinResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  int n = TURLs?TURLs->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="unpin";
  r._Result->requestId=RequestId;
  if(array_is_empty(TURLs)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
         files->check_acl(it->c->identity()) | it->se->check_acl() &
         (FILE_ACC_READ | FILE_ACC_WRITE);
  acl_top_flags=acl_top_flags?0:(FILE_ACC_READ | FILE_ACC_WRITE);
  // Loop through requested files
  n=0;
  for(;n<TURLs->__size;++n) {
    const char* turl = TURLs->__ptr[n];
    if(turl == NULL) continue;
    // extract file id
    std::string id = get_ID_from_TURL(turl,it->service_url.c_str());
    if(id.length() == 0) continue;
    SRMv1Type__RequestFileStatus *f_status=
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    // find stored file
    files->acquire();
    f_status->fileId=n;
    f_status->SURL=NULL;
    SEFiles::iterator f =
           get_file(sp,id,files,f_status,it->c->identity(),acl_top_flags);
    f_status->TURL=(char*)turl;
    if(f != files->end()) {
      f->unpin(it->c->identity().DN());
      f_status->isPinned=(f->pinned() > 0);
    };
    files->release();
  };
  r._Result->state ="Done";
  r._Result->errorMessage=NULL;
  return SOAP_OK;
}

int SRMv1Meth__mkPermanent(struct soap *sp,
    ArrayOfstring*                      SURLs,
  struct SRMv1Meth__mkPermanentResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  int n = SURLs?SURLs->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="mkPermanent";
  if(array_is_empty(SURLs)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
          (files->check_acl(it->c->identity()) | it->se->check_acl()) &
          FILE_ACC_READ;
  acl_top_flags=acl_top_flags?0:FILE_ACC_READ;
  // Loop through requested files
  n=0;
  for(;n<SURLs->__size;++n) {
    const char* surl = SURLs->__ptr[n];
    if(surl == NULL) continue;
    // extract file id
    std::string id = get_ID_from_SURL(surl,it->service_url.c_str());
    SRMv1Type__RequestFileStatus *f_status=            
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    // find stored file
    files->acquire();
    f_status->SURL=(char*)surl;
    f_status->fileId=n;
    SEFiles::iterator f =
          get_file(sp,id,files,f_status,it->c->identity(),acl_top_flags);
    f_status->TURL=NULL;
    files->release();
  };
  r._Result->state ="Done";
  r._Result->errorMessage=NULL;
  return SOAP_OK;
}

int SRMv1Meth__getEstGetTime(struct soap *sp,
    ArrayOfstring*                      SURLs,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__getEstGetTimeResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  int n = SURLs?SURLs->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="getEstGetTime";
  if(array_is_empty(SURLs)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  const char* proto = check_protocols(Protocols);
  if(!proto) {
    r._Result->errorMessage=WRONG_PROTOCOLS_MESSAGE;
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
            (files->check_acl(it->c->identity()) | it->se->check_acl()) &
            FILE_ACC_READ;
  acl_top_flags=acl_top_flags?0:FILE_ACC_READ;
  // Loop through requested files
  n=0;
  for(;n<SURLs->__size;++n) {
    const char* surl = SURLs->__ptr[n];
    if(surl == NULL) continue;
    // extract file id
    std::string id = get_ID_from_SURL(surl,it->service_url.c_str());
    SRMv1Type__RequestFileStatus *f_status=            
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    // find stored file
    files->acquire();
    f_status->SURL=(char*)surl;
    f_status->fileId=n;
    SEFiles::iterator f =
           get_file(sp,id,files,f_status,it->c->identity(),acl_top_flags);
    if(f != files->end()) {
      f_status->TURL=soap_strdup(sp,
                          make_TURL(it->se->base_url(proto),f->id()).c_str());
    } else {
      f_status->TURL=NULL;
    };
    // TODO: pin
    files->release();
  };
  r._Result->state ="Done";
  r._Result->errorMessage=NULL;
  return SOAP_OK;
}

int SRMv1Meth__getEstPutTime(struct soap *sp,
    ArrayOfstring*                      Src_file_names,
    ArrayOfstring*                      Dest_file_names,
    ArrayOflong*                        sizes,
    ArrayOfboolean*                     wantPermanent,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__getEstPutTimeResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  int n = Src_file_names?Src_file_names->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="getEstPutTime";
  if(array_is_empty(Src_file_names)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  if(array_is_empty(Dest_file_names) || (Dest_file_names->__size != n)) {
    r._Result->errorMessage="Number of destinations does not match";
    return SOAP_OK;
  };
  if(array_is_empty(sizes) || (sizes->__size != n)) {
    r._Result->errorMessage="Number of sizes does not match";
    return SOAP_OK;
  };
  if(array_is_empty(wantPermanent) || (wantPermanent->__size != n)) {
    r._Result->errorMessage="Number of wantPermanent does not match";
    return SOAP_OK;
  };
  const char* proto = check_protocols(Protocols);
  if(!proto) {
    r._Result->errorMessage=WRONG_PROTOCOLS_MESSAGE;
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags = 
             (files->check_acl(it->c->identity()) | it->se->check_acl()) &
             FILE_ACC_CREATE;
  if(!acl_top_flags) {
    r._Result->errorMessage="Access denied.";
    return SOAP_OK;
  };
  // Loop through requested files
  n=0;
  for(;n<Dest_file_names->__size;++n) {
    SRMv1Type__RequestFileStatus *f_status=
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    const char* filename  = Dest_file_names->__ptr[n];
    if(filename == NULL) continue;
    bool isshort;
    std::string id = strip_SURL_to_ID(filename,it->service_url.c_str(),&isshort);
    long long size = sizes->__ptr[n];
    {
      std::string surl_;
      if(isshort) {
        surl_=make_SURL_short(it->service_url,id);
      } else {
        surl_=make_SURL(it->service_url,id);
      };
      f_status->SURL=soap_strdup(sp,surl_.c_str());
      f_status->size=size;
      f_status->checksumValue=NULL;
      f_status->checksumType=NULL;
      f_status->isPinned=false;
      f_status->isPermanent=true;
      f_status->isCached=true;
      f_status->estSecondsToStart=0;
      f_status->state="Failed";
      f_status->sourceFilename=NULL;
      f_status->destFilename=soap_strdup(sp,filename);
      f_status->queueOrder=0;
      f_status->fileId=n;
      f_status->TURL=NULL;
      f_status->owner=NULL;
      f_status->group=NULL;
      f_status->permMode=0;
      f_status->state=NULL; // "Ready";
      f_status->TURL=NULL;
    };
  };
  r._Result->errorMessage=NULL;
  r._Result->state ="Done";
  return SOAP_OK;
}

int SRMv1Meth__put(struct soap *sp,
    ArrayOfstring*                      Src_file_names,
    ArrayOfstring*                      Dest_file_names,
    ArrayOflong*                        sizes,
    ArrayOfboolean*                     wantPermanent,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__putResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  int n = Src_file_names?Src_file_names->__size:0;
  r._Result=soap_error_SRMv1Type__RequestStatus(sp,n);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="put";
  if(array_is_empty(Src_file_names)) {
    r._Result->errorMessage=NULL;
    r._Result->state ="Done";
    return SOAP_OK;
  };
  if(array_is_empty(Dest_file_names) || (Dest_file_names->__size != n)) {
    r._Result->errorMessage="Number of destinations does not match";
    return SOAP_OK;
  };
  if(array_is_empty(sizes) || (sizes->__size != n)) {
    r._Result->errorMessage="Number of sizes does not match";
    return SOAP_OK;
  };
  if(array_is_empty(wantPermanent) || (wantPermanent->__size != n)) {
    r._Result->errorMessage="Number of wantPermanent does not match";
    return SOAP_OK;
  };
  const char* proto = check_protocols(Protocols);
  if(!proto) {
    r._Result->errorMessage=WRONG_PROTOCOLS_MESSAGE;
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
             (files->check_acl(it->c->identity()) | it->se->check_acl()) &
             FILE_ACC_CREATE;
  if(!acl_top_flags) {
    r._Result->errorMessage="Access denied.";
    return SOAP_OK;
  };
  SRMRequest* request = new SRMRequest(requestId++,it->c->identity().DN(),"put");
  if(request) r._Result->requestId=request->id();
  // Loop through requested files
  n=0;
  for(;n<Dest_file_names->__size;) {
    SRMv1Type__RequestFileStatus *f_status=
                             soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    if(f_status == NULL) continue;
    f_status->soap_default(sp);
    r._Result->fileStatuses->__ptr[n]=f_status;
    const char* filename  = Dest_file_names->__ptr[n];
    if(filename == NULL) continue;
    bool isshort;
    std::string id = strip_SURL_to_ID(filename,it->service_url.c_str(),&isshort);
    long long size = sizes->__ptr[n];
    {
      std::string surl_;
      if(isshort) {
        surl_=make_SURL_short(it->service_url,id);
      } else {
        surl_=make_SURL(it->service_url,id);
      };
      f_status->SURL=soap_strdup(sp,surl_.c_str());
      f_status->size=size;
      f_status->checksumValue=NULL;
      f_status->checksumType=NULL;
      f_status->isPinned=false;
      f_status->isPermanent=true;
      f_status->isCached=true;
      f_status->estSecondsToStart=0;
      f_status->state="Failed";
      f_status->sourceFilename=NULL;
      f_status->destFilename=soap_strdup(sp,filename);
      f_status->queueOrder=0;
      f_status->fileId=n;
      f_status->TURL=NULL;
      f_status->owner=NULL;
      f_status->group=NULL;
      f_status->permMode=0;
    };
    // create new file
    SEAttributes attr(id.c_str(),it->c->identity());
    attr.size(size);
    attr.checksum(std::string("undefined:"));
    time_t t = 0;
    attr.created(&t);
    SEFiles::iterator f = it->se->new_file(attr);
    if(!f.exists()) {
      r._Result->errorMessage="Failed to create new file";
      if(request) delete request;
      return SOAP_OK;
    };
    // Here file is inserted into list already
    // Store user's proxy (if delegated)
    int hh = -1;
    const char* proxy_fname = it->c->identity().proxy();
    if(proxy_fname && proxy_fname[0]) {
      int hh=::open(proxy_fname,O_RDONLY);
      if(hh != -1) {
        std::string cred;
        const char* s;
        char buf[256];
        for(;;) {
          int ll=::read(hh,buf,sizeof(buf));
          if((ll==0) || (ll==-1)) break;
          cred.append(buf,ll);
        };
        ::close(hh);
        if(f->write_credentials(cred.c_str()) != 0) {
          odlog(ERROR)<<"Can't write delegated credentials"<<std::endl; 
        };
      } else {
        odlog(ERROR)<<"Can't read delegated credentials"<<std::endl; 
      };
    };
    std::string acl = it->c->identity_subject();
    if(acl.length()) acl="<gacl><entry><person><dn>"+acl+
            "</dn></person>"+
            "<allow><read/><write/><list/><admin/></allow></entry></gacl>";
    if(strcasecmp(proto,"http") == 0) {
      // There is no sense to protect data if chosen protocol is HTTP
      acl="<gacl><entry><any-user></any-user><allow><read/><write/><list/><admin/></allow></entry></gacl>";
    };
    if(f->write_acl(it->c->identity(),acl.c_str()) != 0) {
      odlog(ERROR)<<"SRM: failed to acquire/store ACL: "<<acl<<std::endl;
      if(f->state_file() == FILE_STATE_ACCEPTED) files->remove(*f);
      r._Result->errorMessage="Failed to create ACL for file";
      if(request) delete request;
      return SOAP_OK;
    };
    // register *new* file
    if(!it->se->register_new_file(&(*f))) {
      r._Result->errorMessage="Failed to register new file";
      if(request) delete request;
      return SOAP_OK;
    };
    file_state_t fst = FILE_STATE_COLLECTING;
    if(size == 0) fst=FILE_STATE_COMPLETE; // empty file easy to handle
    if(!f->state_file(fst)) {
      odlog(ERROR)<<"SRM: failed to set "<<file_state_str[fst]<<std::endl;
      files->NS()->Unregister(*f);
      // TODO: if failed set state to repeat later
      files->remove(*f);
      r._Result->errorMessage="Failed to remember file's state";
      if(request) delete request;
      return SOAP_OK;
    };
    // Prepare answer about this file
    f_status->state="Ready";
    f_status->TURL=soap_strdup(sp,
                        make_TURL(it->se->base_url(proto),f->id()).c_str());
    // Link file to request
    if(request) {
      SRMRequestFile* f_ = request->add(f);
      if(f_) f_->shorturl(isshort);
    };
    ++n;
  };
  r._Result->errorMessage=NULL;
  r._Result->state ="Active";
  it->requests->add(request);
  return SOAP_OK;
}

// ------------------------------------------------------
// Methods which act on existing request
// ------------------------------------------------------
int SRMv1Meth__setFileStatus(struct soap *sp,
    int                                 RequestId,
    int                                 fileId,
    char*                               state,
  struct SRMv1Meth__setFileStatusResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  SRMRequest* request = it->requests->acquire(RequestId,it->c->identity().DN());
  if(!request) {
    r._Result=soap_error_SRMv1Type__RequestStatus(sp,0,
                                 "There is no request with such id");
    return SOAP_OK;
  };
  SRMRequestFile* f = request->file(fileId);
  r._Result=NULL;
  if(f == NULL) {
    r._Result=soap_error_SRMv1Type__RequestStatus(sp,0,
                              "There is no file with such id");
  } else {
    if(strcasecmp(state,"failed") == 0) {
      // Any file can fail - that means request to delete
      f->running(false);


    } else if(strcasecmp(state,"running") == 0) {
      // Allowed to change from "ready" to "running".
      // But this does not affect SE files
      f->running(true);
    } else if(strcasecmp(state,"done") == 0) {
      // Means unpin
      f->running(false);
      f->file().unpin(it->c->identity().DN());
    } else {
      // Not sure how to report error in such case
      r._Result=soap_error_SRMv1Type__RequestStatus(sp,0,
                                "Can't change to this state");
    };
    // So far report every file in request
    if(r._Result==NULL) r._Result=request->get(sp,it->service_url.c_str());
  };
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="setFileStatus";
  r._Result->requestId=RequestId;
  if((strcasecmp(state,"done") == 0) ||
     (strcasecmp(state,"running") == 0)) {
    // Done and Running states may not be generated automatically - 
    // have to replace
    if(r._Result->fileStatuses && 
       r._Result->fileStatuses->__ptr) {
      for(int n = 0;n<r._Result->fileStatuses->__size;n++) {
        if(r._Result->fileStatuses->__ptr[n] && 
           (r._Result->fileStatuses->__ptr[n]->fileId == fileId)) {
          if(r._Result->fileStatuses->__ptr[n]->state &&
             (strcasecmp("ready",r._Result->fileStatuses->__ptr[n]->state)==0)){
            r._Result->fileStatuses->__ptr[n]->state=state;
          };
          break;
        };
      };
    };
  };
  if(request) {
    request->release();
    // File state change may turn request into obsolete
    it->requests->maintain(RequestId);
  };
  return SOAP_OK;
}

int SRMv1Meth__getRequestStatus(struct soap *sp,
    int                                 RequestId,
  struct SRMv1Meth__getRequestStatusResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  SRMRequest* request = it->requests->acquire(RequestId,it->c->identity().DN());
  if(!request) {
    r._Result=soap_error_SRMv1Type__RequestStatus(sp,1,"There is no request with such id");
  } else {
    r._Result=request->get(sp,it->service_url.c_str());
  };
  if(r._Result==NULL) return SOAP_OK;
  r._Result->type="getRequestStatus";
  r._Result->requestId=RequestId;
  if(request) request->release();
  return SOAP_OK;
}

// ------------------------------------------------------
// Simple methods
// ------------------------------------------------------
int SRMv1Meth__getProtocols(struct soap *sp,
  struct SRMv1Meth__getProtocolsResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  r._Result=soap_new_ArrayOfstring(sp,-1);
  get_protocols(r._Result);
  //r._Result->__ptr=supported_protocols;
  //r._Result->__size=supported_protocols_size;
  return SOAP_OK;
}

int SRMv1Meth__advisoryDelete(struct soap *sp,
    ArrayOfstring*                      SURLs,
  struct SRMv1Meth__advisoryDeleteResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  if(array_is_empty(SURLs)) {
    return SOAP_OK;
  };
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
               (files->check_acl(it->c->identity()) | it->se->check_acl()) &
               FILE_ACC_DELETE;
  acl_top_flags=acl_top_flags?0:FILE_ACC_DELETE;
  // Loop through requested files
  int n = 0;
  for(;n<SURLs->__size;++n) {
    const char* surl = SURLs->__ptr[n];
    if(surl == NULL) continue;
    // extract file id
    std::string id = get_ID_from_SURL(surl,it->service_url.c_str());
    SEFiles::iterator f = files->begin();
    for(;f!=files->end();++f) {
      odlog(DEBUG)<<"file: "<<f->id()<<std::endl;
      if(id == f->id()) {
        odlog(VERBOSE)<<"matched"<<std::endl;
        if((!acl_top_flags) ||
           (f->check_acl(it->c->identity()) & acl_top_flags)) {
          odlog(VERBOSE)<<"allowed"<<std::endl;
          if(!(f->pinned())) it->se->delete_file(*f);
        };
        break;
      };
    };
  };
  return SOAP_OK;
}

int SRMv1Meth__getFileMetaData(struct soap *sp,
    ArrayOfstring*                      SURLs,
  struct SRMv1Meth__getFileMetaDataResponse& r) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  r._Result=soap_new_ArrayOfFileMetaData(sp,-1);
  if(r._Result==NULL) return SOAP_OK;
  r._Result->soap_default(sp);
  int n = SURLs?SURLs->__size:0;
  r._Result->__size=0; r._Result->__ptr=NULL;
  if(n <= 0) return SOAP_OK;
  r._Result->__ptr=(SRMv1Type__FileMetaData**)soap_malloc(sp,
                                  sizeof(SRMv1Type__FileMetaData*)*n);
  if(r._Result->__ptr == NULL) return SOAP_OK;
  r._Result->__size=n;
  for(n=0;n<SURLs->__size;n++) r._Result->__ptr[n]=NULL;
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
         files->check_acl(it->c->identity()) | it->se->check_acl() &
         (FILE_ACC_READ | FILE_ACC_WRITE);
  acl_top_flags=acl_top_flags?0:(FILE_ACC_READ | FILE_ACC_WRITE);
  for(n=0;n<SURLs->__size;n++) {
    const char* surl = SURLs->__ptr[n];
    if(surl == NULL) continue;
    std::string id = get_ID_from_SURL(surl,it->service_url.c_str());
    SEFiles::iterator f =
            find_file(id,files,it->c->identity(),acl_top_flags);
    if(f == files->end()) continue;
    SRMv1Type__FileMetaData* meta = soap_new_SRMv1Type__FileMetaData(sp,-1);
    if(meta == NULL) continue;
    meta->soap_default(sp);
    r._Result->__ptr[n]=meta;
    meta->SURL=(char*)surl;
    meta->size=f->size();
    meta->owner=NULL;
    meta->group=NULL;
    meta->permMode=0;
    convert_checksum(sp,f->checksum(),
                &(meta->checksumType),&(meta->checksumValue));
    meta->isPinned=(f->pinned() > 0);
    meta->isPermanent=true;
    meta->isCached=true;
  };
  return SOAP_OK;
}
