/* srm2_soapC.cpp
   Generated by gSOAP 2.7.8a from srm2_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "srm2_soapH.h"

SOAP_SOURCE_STAMP("@(#) srm2_soapC.cpp ver 2.7.8a 2009-04-06 10:50:17 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_SRMv2__TStatusCode:
		return soap_in_SRMv2__TStatusCode(soap, NULL, NULL, "SRMv2:TStatusCode");
	case SOAP_TYPE_SRMv2__TOverwriteMode:
		return soap_in_SRMv2__TOverwriteMode(soap, NULL, NULL, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_SRMv2__TRequestType:
		return soap_in_SRMv2__TRequestType(soap, NULL, NULL, "SRMv2:TRequestType");
	case SOAP_TYPE_SRMv2__TPermissionType:
		return soap_in_SRMv2__TPermissionType(soap, NULL, NULL, "SRMv2:TPermissionType");
	case SOAP_TYPE_SRMv2__TPermissionMode:
		return soap_in_SRMv2__TPermissionMode(soap, NULL, NULL, "SRMv2:TPermissionMode");
	case SOAP_TYPE_SRMv2__TFileType:
		return soap_in_SRMv2__TFileType(soap, NULL, NULL, "SRMv2:TFileType");
	case SOAP_TYPE_SRMv2__TFileStorageType:
		return soap_in_SRMv2__TFileStorageType(soap, NULL, NULL, "SRMv2:TFileStorageType");
	case SOAP_TYPE_SRMv2__TSpaceType:
		return soap_in_SRMv2__TSpaceType(soap, NULL, NULL, "SRMv2:TSpaceType");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse:
		return soap_in_SRMv2__srmGetRequestIDResponse(soap, NULL, NULL, "SRMv2:srmGetRequestIDResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestIDRequest:
		return soap_in_SRMv2__srmGetRequestIDRequest(soap, NULL, NULL, "SRMv2:srmGetRequestIDRequest");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		return soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		return soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		return soap_in_SRMv2__srmGetRequestSummaryResponse(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		return soap_in_SRMv2__srmGetRequestSummaryRequest(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		return soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		return soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		return soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		return soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		return soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		return soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		return soap_in_SRMv2__srmResumeRequestResponse(soap, NULL, NULL, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		return soap_in_SRMv2__srmResumeRequestRequest(soap, NULL, NULL, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		return soap_in_SRMv2__srmSuspendRequestResponse(soap, NULL, NULL, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		return soap_in_SRMv2__srmSuspendRequestRequest(soap, NULL, NULL, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		return soap_in_SRMv2__srmAbortFilesResponse(soap, NULL, NULL, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		return soap_in_SRMv2__srmAbortFilesRequest(soap, NULL, NULL, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		return soap_in_SRMv2__srmAbortRequestResponse(soap, NULL, NULL, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		return soap_in_SRMv2__srmAbortRequestRequest(soap, NULL, NULL, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		return soap_in_SRMv2__srmPutDoneResponse(soap, NULL, NULL, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		return soap_in_SRMv2__srmPutDoneRequest(soap, NULL, NULL, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		return soap_in_SRMv2__srmReleaseFilesResponse(soap, NULL, NULL, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		return soap_in_SRMv2__srmReleaseFilesRequest(soap, NULL, NULL, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse:
		return soap_in_SRMv2__srmRemoveFilesResponse(soap, NULL, NULL, "SRMv2:srmRemoveFilesResponse");
	case SOAP_TYPE_SRMv2__srmRemoveFilesRequest:
		return soap_in_SRMv2__srmRemoveFilesRequest(soap, NULL, NULL, "SRMv2:srmRemoveFilesRequest");
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		return soap_in_SRMv2__srmCopyResponse(soap, NULL, NULL, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		return soap_in_SRMv2__srmCopyRequest(soap, NULL, NULL, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		return soap_in_SRMv2__srmPrepareToPutResponse(soap, NULL, NULL, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		return soap_in_SRMv2__srmPrepareToPutRequest(soap, NULL, NULL, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		return soap_in_SRMv2__srmPrepareToGetResponse(soap, NULL, NULL, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		return soap_in_SRMv2__srmPrepareToGetRequest(soap, NULL, NULL, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_SRMv2__srmMvResponse:
		return soap_in_SRMv2__srmMvResponse(soap, NULL, NULL, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmMvRequest:
		return soap_in_SRMv2__srmMvRequest(soap, NULL, NULL, "SRMv2:srmMvRequest");
	case SOAP_TYPE_SRMv2__srmLsResponse:
		return soap_in_SRMv2__srmLsResponse(soap, NULL, NULL, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmLsRequest:
		return soap_in_SRMv2__srmLsRequest(soap, NULL, NULL, "SRMv2:srmLsRequest");
	case SOAP_TYPE_SRMv2__srmRmResponse:
		return soap_in_SRMv2__srmRmResponse(soap, NULL, NULL, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmRequest:
		return soap_in_SRMv2__srmRmRequest(soap, NULL, NULL, "SRMv2:srmRmRequest");
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		return soap_in_SRMv2__srmRmdirResponse(soap, NULL, NULL, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		return soap_in_SRMv2__srmRmdirRequest(soap, NULL, NULL, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		return soap_in_SRMv2__srmMkdirResponse(soap, NULL, NULL, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		return soap_in_SRMv2__srmMkdirRequest(soap, NULL, NULL, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		return soap_in_SRMv2__srmCheckPermissionResponse(soap, NULL, NULL, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		return soap_in_SRMv2__srmCheckPermissionRequest(soap, NULL, NULL, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse:
		return soap_in_SRMv2__srmReassignToUserResponse(soap, NULL, NULL, "SRMv2:srmReassignToUserResponse");
	case SOAP_TYPE_SRMv2__srmReassignToUserRequest:
		return soap_in_SRMv2__srmReassignToUserRequest(soap, NULL, NULL, "SRMv2:srmReassignToUserRequest");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		return soap_in_SRMv2__srmSetPermissionResponse(soap, NULL, NULL, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		return soap_in_SRMv2__srmSetPermissionRequest(soap, NULL, NULL, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse:
		return soap_in_SRMv2__srmGetSpaceTokenResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceTokenResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest:
		return soap_in_SRMv2__srmGetSpaceTokenRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceTokenRequest");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse:
		return soap_in_SRMv2__srmChangeFileStorageTypeResponse(soap, NULL, NULL, "SRMv2:srmChangeFileStorageTypeResponse");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest:
		return soap_in_SRMv2__srmChangeFileStorageTypeRequest(soap, NULL, NULL, "SRMv2:srmChangeFileStorageTypeRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		return soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		return soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse:
		return soap_in_SRMv2__srmCompactSpaceResponse(soap, NULL, NULL, "SRMv2:srmCompactSpaceResponse");
	case SOAP_TYPE_SRMv2__srmCompactSpaceRequest:
		return soap_in_SRMv2__srmCompactSpaceRequest(soap, NULL, NULL, "SRMv2:srmCompactSpaceRequest");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		return soap_in_SRMv2__srmUpdateSpaceResponse(soap, NULL, NULL, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		return soap_in_SRMv2__srmUpdateSpaceRequest(soap, NULL, NULL, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		return soap_in_SRMv2__srmReleaseSpaceResponse(soap, NULL, NULL, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		return soap_in_SRMv2__srmReleaseSpaceRequest(soap, NULL, NULL, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		return soap_in_SRMv2__srmReserveSpaceResponse(soap, NULL, NULL, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		return soap_in_SRMv2__srmReserveSpaceRequest(soap, NULL, NULL, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		return soap_in_SRMv2__TRequestTokenReturn(soap, NULL, NULL, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestToken:
		return soap_in_SRMv2__ArrayOfTRequestToken(soap, NULL, NULL, "SRMv2:ArrayOfTRequestToken");
	case SOAP_TYPE_SRMv2__ArrayOfTSURL:
		return soap_in_SRMv2__ArrayOfTSURL(soap, NULL, NULL, "SRMv2:ArrayOfTSURL");
	case SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring:
		return soap_in_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, NULL, NULL, "SRMv2:ArrayOf_xsd_string");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		return soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, NULL, NULL, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		return soap_in_SRMv2__TSURLPermissionReturn(soap, NULL, NULL, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		return soap_in_SRMv2__ArrayOfTRequestSummary(soap, NULL, NULL, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_SRMv2__TRequestSummary:
		return soap_in_SRMv2__TRequestSummary(soap, NULL, NULL, "SRMv2:TRequestSummary");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		return soap_in_SRMv2__TCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		return soap_in_SRMv2__TPutRequestFileStatus(soap, NULL, NULL, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTGetRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		return soap_in_SRMv2__TGetRequestFileStatus(soap, NULL, NULL, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		return soap_in_SRMv2__ArrayOfTSURLReturnStatus(soap, NULL, NULL, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		return soap_in_SRMv2__TSURLReturnStatus(soap, NULL, NULL, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TReturnStatus:
		return soap_in_SRMv2__TReturnStatus(soap, NULL, NULL, "SRMv2:TReturnStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		return soap_in_SRMv2__ArrayOfTCopyFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		return soap_in_SRMv2__TCopyFileRequest(soap, NULL, NULL, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		return soap_in_SRMv2__ArrayOfTPutFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		return soap_in_SRMv2__TPutFileRequest(soap, NULL, NULL, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		return soap_in_SRMv2__ArrayOfTGetFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		return soap_in_SRMv2__TGetFileRequest(soap, NULL, NULL, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLInfo:
		return soap_in_SRMv2__ArrayOfTSURLInfo(soap, NULL, NULL, "SRMv2:ArrayOfTSURLInfo");
	case SOAP_TYPE_SRMv2__TSURLInfo:
		return soap_in_SRMv2__TSURLInfo(soap, NULL, NULL, "SRMv2:TSURLInfo");
	case SOAP_TYPE_SRMv2__TDirOption:
		return soap_in_SRMv2__TDirOption(soap, NULL, NULL, "SRMv2:TDirOption");
	case SOAP_TYPE_SRMv2__TStorageSystemInfo:
		return soap_in_SRMv2__TStorageSystemInfo(soap, NULL, NULL, "SRMv2:TStorageSystemInfo");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		return soap_in_SRMv2__ArrayOfTMetaDataSpace(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		return soap_in_SRMv2__TMetaDataSpace(soap, NULL, NULL, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		return soap_in_SRMv2__ArrayOfTMetaDataPathDetail(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		return soap_in_SRMv2__TMetaDataPathDetail(soap, NULL, NULL, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__TTURL:
		return soap_in_SRMv2__TTURL(soap, NULL, NULL, "SRMv2:TTURL");
	case SOAP_TYPE_SRMv2__TSURL:
		return soap_in_SRMv2__TSURL(soap, NULL, NULL, "SRMv2:TSURL");
	case SOAP_TYPE_SRMv2__TLifeTimeInSeconds:
		return soap_in_SRMv2__TLifeTimeInSeconds(soap, NULL, NULL, "SRMv2:TLifeTimeInSeconds");
	case SOAP_TYPE_SRMv2__TGMTTime:
		return soap_in_SRMv2__TGMTTime(soap, NULL, NULL, "SRMv2:TGMTTime");
	case SOAP_TYPE_SRMv2__TSizeInBytes:
		return soap_in_SRMv2__TSizeInBytes(soap, NULL, NULL, "SRMv2:TSizeInBytes");
	case SOAP_TYPE_SRMv2__TCheckSumValue:
		return soap_in_SRMv2__TCheckSumValue(soap, NULL, NULL, "SRMv2:TCheckSumValue");
	case SOAP_TYPE_SRMv2__TCheckSumType:
		return soap_in_SRMv2__TCheckSumType(soap, NULL, NULL, "SRMv2:TCheckSumType");
	case SOAP_TYPE_SRMv2__TOtherPermission:
		return soap_in_SRMv2__TOtherPermission(soap, NULL, NULL, "SRMv2:TOtherPermission");
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		return soap_in_SRMv2__ArrayOfTGroupPermission(soap, NULL, NULL, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_SRMv2__TGroupPermission:
		return soap_in_SRMv2__TGroupPermission(soap, NULL, NULL, "SRMv2:TGroupPermission");
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		return soap_in_SRMv2__ArrayOfTUserPermission(soap, NULL, NULL, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_SRMv2__TUserPermission:
		return soap_in_SRMv2__TUserPermission(soap, NULL, NULL, "SRMv2:TUserPermission");
	case SOAP_TYPE_SRMv2__TOwnerPermission:
		return soap_in_SRMv2__TOwnerPermission(soap, NULL, NULL, "SRMv2:TOwnerPermission");
	case SOAP_TYPE_SRMv2__TGroupID:
		return soap_in_SRMv2__TGroupID(soap, NULL, NULL, "SRMv2:TGroupID");
	case SOAP_TYPE_SRMv2__TUserID:
		return soap_in_SRMv2__TUserID(soap, NULL, NULL, "SRMv2:TUserID");
	case SOAP_TYPE_SRMv2__ArrayOfTSpaceToken:
		return soap_in_SRMv2__ArrayOfTSpaceToken(soap, NULL, NULL, "SRMv2:ArrayOfTSpaceToken");
	case SOAP_TYPE_SRMv2__TSpaceToken:
		return soap_in_SRMv2__TSpaceToken(soap, NULL, NULL, "SRMv2:TSpaceToken");
	case SOAP_TYPE_SRMv2__TRequestToken:
		return soap_in_SRMv2__TRequestToken(soap, NULL, NULL, "SRMv2:TRequestToken");
	case SOAP_TYPE_SRMv2__srmGetRequestID:
		return soap_in_SRMv2__srmGetRequestID(soap, NULL, NULL, "SRMv2:srmGetRequestID");
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse_:
		return soap_in_SRMv2__srmGetRequestIDResponse_(soap, NULL, NULL, "SRMv2:srmGetRequestIDResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		return soap_in_SRMv2__srmExtendFileLifeTime(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTime");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		return soap_in_SRMv2__srmExtendFileLifeTimeResponse_(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		return soap_in_SRMv2__srmGetRequestSummary(soap, NULL, NULL, "SRMv2:srmGetRequestSummary");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		return soap_in_SRMv2__srmGetRequestSummaryResponse_(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		return soap_in_SRMv2__srmStatusOfCopyRequest(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		return soap_in_SRMv2__srmStatusOfCopyRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		return soap_in_SRMv2__srmStatusOfPutRequest(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		return soap_in_SRMv2__srmStatusOfPutRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		return soap_in_SRMv2__srmStatusOfGetRequest(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		return soap_in_SRMv2__srmStatusOfGetRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		return soap_in_SRMv2__srmResumeRequest(soap, NULL, NULL, "SRMv2:srmResumeRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		return soap_in_SRMv2__srmResumeRequestResponse_(soap, NULL, NULL, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		return soap_in_SRMv2__srmSuspendRequest(soap, NULL, NULL, "SRMv2:srmSuspendRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		return soap_in_SRMv2__srmSuspendRequestResponse_(soap, NULL, NULL, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		return soap_in_SRMv2__srmAbortFiles(soap, NULL, NULL, "SRMv2:srmAbortFiles");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		return soap_in_SRMv2__srmAbortFilesResponse_(soap, NULL, NULL, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		return soap_in_SRMv2__srmAbortRequest(soap, NULL, NULL, "SRMv2:srmAbortRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		return soap_in_SRMv2__srmAbortRequestResponse_(soap, NULL, NULL, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmPutDone:
		return soap_in_SRMv2__srmPutDone(soap, NULL, NULL, "SRMv2:srmPutDone");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		return soap_in_SRMv2__srmPutDoneResponse_(soap, NULL, NULL, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		return soap_in_SRMv2__srmReleaseFiles(soap, NULL, NULL, "SRMv2:srmReleaseFiles");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		return soap_in_SRMv2__srmReleaseFilesResponse_(soap, NULL, NULL, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmRemoveFiles:
		return soap_in_SRMv2__srmRemoveFiles(soap, NULL, NULL, "SRMv2:srmRemoveFiles");
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse_:
		return soap_in_SRMv2__srmRemoveFilesResponse_(soap, NULL, NULL, "SRMv2:srmRemoveFilesResponse");
	case SOAP_TYPE_SRMv2__srmCopy:
		return soap_in_SRMv2__srmCopy(soap, NULL, NULL, "SRMv2:srmCopy");
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		return soap_in_SRMv2__srmCopyResponse_(soap, NULL, NULL, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		return soap_in_SRMv2__srmPrepareToPut(soap, NULL, NULL, "SRMv2:srmPrepareToPut");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		return soap_in_SRMv2__srmPrepareToPutResponse_(soap, NULL, NULL, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		return soap_in_SRMv2__srmPrepareToGet(soap, NULL, NULL, "SRMv2:srmPrepareToGet");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		return soap_in_SRMv2__srmPrepareToGetResponse_(soap, NULL, NULL, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmMv:
		return soap_in_SRMv2__srmMv(soap, NULL, NULL, "SRMv2:srmMv");
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		return soap_in_SRMv2__srmMvResponse_(soap, NULL, NULL, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmLs:
		return soap_in_SRMv2__srmLs(soap, NULL, NULL, "SRMv2:srmLs");
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		return soap_in_SRMv2__srmLsResponse_(soap, NULL, NULL, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmRm:
		return soap_in_SRMv2__srmRm(soap, NULL, NULL, "SRMv2:srmRm");
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		return soap_in_SRMv2__srmRmResponse_(soap, NULL, NULL, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmdir:
		return soap_in_SRMv2__srmRmdir(soap, NULL, NULL, "SRMv2:srmRmdir");
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		return soap_in_SRMv2__srmRmdirResponse_(soap, NULL, NULL, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdir:
		return soap_in_SRMv2__srmMkdir(soap, NULL, NULL, "SRMv2:srmMkdir");
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		return soap_in_SRMv2__srmMkdirResponse_(soap, NULL, NULL, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		return soap_in_SRMv2__srmCheckPermission(soap, NULL, NULL, "SRMv2:srmCheckPermission");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		return soap_in_SRMv2__srmCheckPermissionResponse_(soap, NULL, NULL, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmReassignToUser:
		return soap_in_SRMv2__srmReassignToUser(soap, NULL, NULL, "SRMv2:srmReassignToUser");
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse_:
		return soap_in_SRMv2__srmReassignToUserResponse_(soap, NULL, NULL, "SRMv2:srmReassignToUserResponse");
	case SOAP_TYPE_SRMv2__srmSetPermission:
		return soap_in_SRMv2__srmSetPermission(soap, NULL, NULL, "SRMv2:srmSetPermission");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		return soap_in_SRMv2__srmSetPermissionResponse_(soap, NULL, NULL, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceToken:
		return soap_in_SRMv2__srmGetSpaceToken(soap, NULL, NULL, "SRMv2:srmGetSpaceToken");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse_:
		return soap_in_SRMv2__srmGetSpaceTokenResponse_(soap, NULL, NULL, "SRMv2:srmGetSpaceTokenResponse");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageType:
		return soap_in_SRMv2__srmChangeFileStorageType(soap, NULL, NULL, "SRMv2:srmChangeFileStorageType");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse_:
		return soap_in_SRMv2__srmChangeFileStorageTypeResponse_(soap, NULL, NULL, "SRMv2:srmChangeFileStorageTypeResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		return soap_in_SRMv2__srmGetSpaceMetaData(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaData");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		return soap_in_SRMv2__srmGetSpaceMetaDataResponse_(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmCompactSpace:
		return soap_in_SRMv2__srmCompactSpace(soap, NULL, NULL, "SRMv2:srmCompactSpace");
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse_:
		return soap_in_SRMv2__srmCompactSpaceResponse_(soap, NULL, NULL, "SRMv2:srmCompactSpaceResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		return soap_in_SRMv2__srmUpdateSpace(soap, NULL, NULL, "SRMv2:srmUpdateSpace");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		return soap_in_SRMv2__srmUpdateSpaceResponse_(soap, NULL, NULL, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		return soap_in_SRMv2__srmReleaseSpace(soap, NULL, NULL, "SRMv2:srmReleaseSpace");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		return soap_in_SRMv2__srmReleaseSpaceResponse_(soap, NULL, NULL, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		return soap_in_SRMv2__srmReserveSpace(soap, NULL, NULL, "SRMv2:srmReserveSpace");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		return soap_in_SRMv2__srmReserveSpaceResponse_(soap, NULL, NULL, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestIDRequest:
		return soap_in_PointerToSRMv2__srmGetRequestIDRequest(soap, NULL, NULL, "SRMv2:srmGetRequestIDRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestIDResponse:
		return soap_in_PointerToSRMv2__srmGetRequestIDResponse(soap, NULL, NULL, "SRMv2:srmGetRequestIDResponse");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeRequest:
		return soap_in_PointerToSRMv2__srmExtendFileLifeTimeRequest(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeResponse:
		return soap_in_PointerToSRMv2__srmExtendFileLifeTimeResponse(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryRequest:
		return soap_in_PointerToSRMv2__srmGetRequestSummaryRequest(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryResponse:
		return soap_in_PointerToSRMv2__srmGetRequestSummaryResponse(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfCopyRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfCopyRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfPutRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfPutRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfGetRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfGetRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestRequest:
		return soap_in_PointerToSRMv2__srmResumeRequestRequest(soap, NULL, NULL, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestResponse:
		return soap_in_PointerToSRMv2__srmResumeRequestResponse(soap, NULL, NULL, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestRequest:
		return soap_in_PointerToSRMv2__srmSuspendRequestRequest(soap, NULL, NULL, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestResponse:
		return soap_in_PointerToSRMv2__srmSuspendRequestResponse(soap, NULL, NULL, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesRequest:
		return soap_in_PointerToSRMv2__srmAbortFilesRequest(soap, NULL, NULL, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesResponse:
		return soap_in_PointerToSRMv2__srmAbortFilesResponse(soap, NULL, NULL, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestRequest:
		return soap_in_PointerToSRMv2__srmAbortRequestRequest(soap, NULL, NULL, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestResponse:
		return soap_in_PointerToSRMv2__srmAbortRequestResponse(soap, NULL, NULL, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneRequest:
		return soap_in_PointerToSRMv2__srmPutDoneRequest(soap, NULL, NULL, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneResponse:
		return soap_in_PointerToSRMv2__srmPutDoneResponse(soap, NULL, NULL, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesRequest:
		return soap_in_PointerToSRMv2__srmReleaseFilesRequest(soap, NULL, NULL, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesResponse:
		return soap_in_PointerToSRMv2__srmReleaseFilesResponse(soap, NULL, NULL, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRemoveFilesRequest:
		return soap_in_PointerToSRMv2__srmRemoveFilesRequest(soap, NULL, NULL, "SRMv2:srmRemoveFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRemoveFilesResponse:
		return soap_in_PointerToSRMv2__srmRemoveFilesResponse(soap, NULL, NULL, "SRMv2:srmRemoveFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCopyRequest:
		return soap_in_PointerToSRMv2__srmCopyRequest(soap, NULL, NULL, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCopyResponse:
		return soap_in_PointerToSRMv2__srmCopyResponse(soap, NULL, NULL, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutRequest:
		return soap_in_PointerToSRMv2__srmPrepareToPutRequest(soap, NULL, NULL, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutResponse:
		return soap_in_PointerToSRMv2__srmPrepareToPutResponse(soap, NULL, NULL, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetRequest:
		return soap_in_PointerToSRMv2__srmPrepareToGetRequest(soap, NULL, NULL, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetResponse:
		return soap_in_PointerToSRMv2__srmPrepareToGetResponse(soap, NULL, NULL, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMvRequest:
		return soap_in_PointerToSRMv2__srmMvRequest(soap, NULL, NULL, "SRMv2:srmMvRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMvResponse:
		return soap_in_PointerToSRMv2__srmMvResponse(soap, NULL, NULL, "SRMv2:srmMvResponse");
	case SOAP_TYPE_PointerToSRMv2__srmLsRequest:
		return soap_in_PointerToSRMv2__srmLsRequest(soap, NULL, NULL, "SRMv2:srmLsRequest");
	case SOAP_TYPE_PointerToSRMv2__srmLsResponse:
		return soap_in_PointerToSRMv2__srmLsResponse(soap, NULL, NULL, "SRMv2:srmLsResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmRequest:
		return soap_in_PointerToSRMv2__srmRmRequest(soap, NULL, NULL, "SRMv2:srmRmRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmResponse:
		return soap_in_PointerToSRMv2__srmRmResponse(soap, NULL, NULL, "SRMv2:srmRmResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirRequest:
		return soap_in_PointerToSRMv2__srmRmdirRequest(soap, NULL, NULL, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirResponse:
		return soap_in_PointerToSRMv2__srmRmdirResponse(soap, NULL, NULL, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirRequest:
		return soap_in_PointerToSRMv2__srmMkdirRequest(soap, NULL, NULL, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirResponse:
		return soap_in_PointerToSRMv2__srmMkdirResponse(soap, NULL, NULL, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionRequest:
		return soap_in_PointerToSRMv2__srmCheckPermissionRequest(soap, NULL, NULL, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionResponse:
		return soap_in_PointerToSRMv2__srmCheckPermissionResponse(soap, NULL, NULL, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReassignToUserRequest:
		return soap_in_PointerToSRMv2__srmReassignToUserRequest(soap, NULL, NULL, "SRMv2:srmReassignToUserRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReassignToUserResponse:
		return soap_in_PointerToSRMv2__srmReassignToUserResponse(soap, NULL, NULL, "SRMv2:srmReassignToUserResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionRequest:
		return soap_in_PointerToSRMv2__srmSetPermissionRequest(soap, NULL, NULL, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionResponse:
		return soap_in_PointerToSRMv2__srmSetPermissionResponse(soap, NULL, NULL, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokenRequest:
		return soap_in_PointerToSRMv2__srmGetSpaceTokenRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceTokenRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokenResponse:
		return soap_in_PointerToSRMv2__srmGetSpaceTokenResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceTokenResponse");
	case SOAP_TYPE_PointerToSRMv2__srmChangeFileStorageTypeRequest:
		return soap_in_PointerToSRMv2__srmChangeFileStorageTypeRequest(soap, NULL, NULL, "SRMv2:srmChangeFileStorageTypeRequest");
	case SOAP_TYPE_PointerToSRMv2__srmChangeFileStorageTypeResponse:
		return soap_in_PointerToSRMv2__srmChangeFileStorageTypeResponse(soap, NULL, NULL, "SRMv2:srmChangeFileStorageTypeResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataRequest:
		return soap_in_PointerToSRMv2__srmGetSpaceMetaDataRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataResponse:
		return soap_in_PointerToSRMv2__srmGetSpaceMetaDataResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCompactSpaceRequest:
		return soap_in_PointerToSRMv2__srmCompactSpaceRequest(soap, NULL, NULL, "SRMv2:srmCompactSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCompactSpaceResponse:
		return soap_in_PointerToSRMv2__srmCompactSpaceResponse(soap, NULL, NULL, "SRMv2:srmCompactSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceRequest:
		return soap_in_PointerToSRMv2__srmUpdateSpaceRequest(soap, NULL, NULL, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceResponse:
		return soap_in_PointerToSRMv2__srmUpdateSpaceResponse(soap, NULL, NULL, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceRequest:
		return soap_in_PointerToSRMv2__srmReleaseSpaceRequest(soap, NULL, NULL, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceResponse:
		return soap_in_PointerToSRMv2__srmReleaseSpaceResponse(soap, NULL, NULL, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceRequest:
		return soap_in_PointerToSRMv2__srmReserveSpaceRequest(soap, NULL, NULL, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceResponse:
		return soap_in_PointerToSRMv2__srmReserveSpaceResponse(soap, NULL, NULL, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestSummary:
		return soap_in_PointerToSRMv2__ArrayOfTRequestSummary(soap, NULL, NULL, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestToken:
		return soap_in_PointerToSRMv2__ArrayOfTRequestToken(soap, NULL, NULL, "SRMv2:ArrayOfTRequestToken");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURL:
		return soap_in_PointerToSRMv2__ArrayOfTSURL(soap, NULL, NULL, "SRMv2:ArrayOfTSURL");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyFileRequest:
		return soap_in_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutFileRequest:
		return soap_in_PointerToSRMv2__ArrayOfTPutFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring:
		return soap_in_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, NULL, NULL, "SRMv2:ArrayOf_xsd_string");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetFileRequest:
		return soap_in_PointerToSRMv2__ArrayOfTGetFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLPermissionReturn:
		return soap_in_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, NULL, NULL, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLReturnStatus:
		return soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, NULL, NULL, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLInfo:
		return soap_in_PointerToSRMv2__ArrayOfTSURLInfo(soap, NULL, NULL, "SRMv2:ArrayOfTSURLInfo");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataSpace:
		return soap_in_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSpaceToken:
		return soap_in_PointerToSRMv2__ArrayOfTSpaceToken(soap, NULL, NULL, "SRMv2:ArrayOfTSpaceToken");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestToken:
		return soap_in_PointerToPointerToSRMv2__TRequestToken(soap, NULL, NULL, "SRMv2:TRequestToken");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURL:
		return soap_in_PointerToPointerToSRMv2__TSURL(soap, NULL, NULL, "SRMv2:TSURL");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLPermissionReturn:
		return soap_in_PointerToPointerToSRMv2__TSURLPermissionReturn(soap, NULL, NULL, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TSURLPermissionReturn:
		return soap_in_PointerToSRMv2__TSURLPermissionReturn(soap, NULL, NULL, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TPermissionType:
		return soap_in_PointerToSRMv2__TPermissionType(soap, NULL, NULL, "SRMv2:TPermissionType");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestSummary:
		return soap_in_PointerToPointerToSRMv2__TRequestSummary(soap, NULL, NULL, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestSummary:
		return soap_in_PointerToSRMv2__TRequestSummary(soap, NULL, NULL, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestType:
		return soap_in_PointerToSRMv2__TRequestType(soap, NULL, NULL, "SRMv2:TRequestType");
	case SOAP_TYPE_PointerToSRMv2__TRequestToken:
		return soap_in_PointerToSRMv2__TRequestToken(soap, NULL, NULL, "SRMv2:TRequestToken");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TCopyRequestFileStatus:
		return soap_in_PointerToSRMv2__TCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TPutRequestFileStatus(soap, NULL, NULL, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TPutRequestFileStatus:
		return soap_in_PointerToSRMv2__TPutRequestFileStatus(soap, NULL, NULL, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TGetRequestFileStatus(soap, NULL, NULL, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TGetRequestFileStatus:
		return soap_in_PointerToSRMv2__TGetRequestFileStatus(soap, NULL, NULL, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TTURL:
		return soap_in_PointerToSRMv2__TTURL(soap, NULL, NULL, "SRMv2:TTURL");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLReturnStatus:
		return soap_in_PointerToPointerToSRMv2__TSURLReturnStatus(soap, NULL, NULL, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TSURLReturnStatus:
		return soap_in_PointerToSRMv2__TSURLReturnStatus(soap, NULL, NULL, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyFileRequest:
		return soap_in_PointerToPointerToSRMv2__TCopyFileRequest(soap, NULL, NULL, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TCopyFileRequest:
		return soap_in_PointerToSRMv2__TCopyFileRequest(soap, NULL, NULL, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TOverwriteMode:
		return soap_in_PointerToSRMv2__TOverwriteMode(soap, NULL, NULL, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutFileRequest:
		return soap_in_PointerToPointerToSRMv2__TPutFileRequest(soap, NULL, NULL, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TPutFileRequest:
		return soap_in_PointerToSRMv2__TPutFileRequest(soap, NULL, NULL, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetFileRequest:
		return soap_in_PointerToPointerToSRMv2__TGetFileRequest(soap, NULL, NULL, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TGetFileRequest:
		return soap_in_PointerToSRMv2__TGetFileRequest(soap, NULL, NULL, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TDirOption:
		return soap_in_PointerToSRMv2__TDirOption(soap, NULL, NULL, "SRMv2:TDirOption");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLInfo:
		return soap_in_PointerToPointerToSRMv2__TSURLInfo(soap, NULL, NULL, "SRMv2:TSURLInfo");
	case SOAP_TYPE_PointerToSRMv2__TSURLInfo:
		return soap_in_PointerToSRMv2__TSURLInfo(soap, NULL, NULL, "SRMv2:TSURLInfo");
	case SOAP_TYPE_PointerToSRMv2__TStorageSystemInfo:
		return soap_in_PointerToSRMv2__TStorageSystemInfo(soap, NULL, NULL, "SRMv2:TStorageSystemInfo");
	case SOAP_TYPE_PointerTobool:
		return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataSpace:
		return soap_in_PointerToPointerToSRMv2__TMetaDataSpace(soap, NULL, NULL, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataSpace:
		return soap_in_PointerToSRMv2__TMetaDataSpace(soap, NULL, NULL, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TSpaceType:
		return soap_in_PointerToSRMv2__TSpaceType(soap, NULL, NULL, "SRMv2:TSpaceType");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataPathDetail:
		return soap_in_PointerToPointerToSRMv2__TMetaDataPathDetail(soap, NULL, NULL, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataPathDetail:
		return soap_in_PointerToSRMv2__TMetaDataPathDetail(soap, NULL, NULL, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataPathDetail:
		return soap_in_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TSURL:
		return soap_in_PointerToSRMv2__TSURL(soap, NULL, NULL, "SRMv2:TSURL");
	case SOAP_TYPE_PointerToSRMv2__TCheckSumValue:
		return soap_in_PointerToSRMv2__TCheckSumValue(soap, NULL, NULL, "SRMv2:TCheckSumValue");
	case SOAP_TYPE_PointerToSRMv2__TCheckSumType:
		return soap_in_PointerToSRMv2__TCheckSumType(soap, NULL, NULL, "SRMv2:TCheckSumType");
	case SOAP_TYPE_PointerToSRMv2__TLifeTimeInSeconds:
		return soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, NULL, NULL, "SRMv2:TLifeTimeInSeconds");
	case SOAP_TYPE_PointerToSRMv2__TFileType:
		return soap_in_PointerToSRMv2__TFileType(soap, NULL, NULL, "SRMv2:TFileType");
	case SOAP_TYPE_PointerToSRMv2__TFileStorageType:
		return soap_in_PointerToSRMv2__TFileStorageType(soap, NULL, NULL, "SRMv2:TFileStorageType");
	case SOAP_TYPE_PointerToSRMv2__TGMTTime:
		return soap_in_PointerToSRMv2__TGMTTime(soap, NULL, NULL, "SRMv2:TGMTTime");
	case SOAP_TYPE_PointerToSRMv2__TOtherPermission:
		return soap_in_PointerToSRMv2__TOtherPermission(soap, NULL, NULL, "SRMv2:TOtherPermission");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGroupPermission:
		return soap_in_PointerToSRMv2__ArrayOfTGroupPermission(soap, NULL, NULL, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTUserPermission:
		return soap_in_PointerToSRMv2__ArrayOfTUserPermission(soap, NULL, NULL, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TOwnerPermission:
		return soap_in_PointerToSRMv2__TOwnerPermission(soap, NULL, NULL, "SRMv2:TOwnerPermission");
	case SOAP_TYPE_PointerToSRMv2__TSizeInBytes:
		return soap_in_PointerToSRMv2__TSizeInBytes(soap, NULL, NULL, "SRMv2:TSizeInBytes");
	case SOAP_TYPE_PointerToSRMv2__TReturnStatus:
		return soap_in_PointerToSRMv2__TReturnStatus(soap, NULL, NULL, "SRMv2:TReturnStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGroupPermission:
		return soap_in_PointerToPointerToSRMv2__TGroupPermission(soap, NULL, NULL, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__TGroupPermission:
		return soap_in_PointerToSRMv2__TGroupPermission(soap, NULL, NULL, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__TGroupID:
		return soap_in_PointerToSRMv2__TGroupID(soap, NULL, NULL, "SRMv2:TGroupID");
	case SOAP_TYPE_PointerToPointerToSRMv2__TUserPermission:
		return soap_in_PointerToPointerToSRMv2__TUserPermission(soap, NULL, NULL, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TUserPermission:
		return soap_in_PointerToSRMv2__TUserPermission(soap, NULL, NULL, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TUserID:
		return soap_in_PointerToSRMv2__TUserID(soap, NULL, NULL, "SRMv2:TUserID");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSpaceToken:
		return soap_in_PointerToPointerToSRMv2__TSpaceToken(soap, NULL, NULL, "SRMv2:TSpaceToken");
	case SOAP_TYPE_PointerToSRMv2__TSpaceToken:
		return soap_in_PointerToSRMv2__TSpaceToken(soap, NULL, NULL, "SRMv2:TSpaceToken");
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TStatusCode"))
		{	*type = SOAP_TYPE_SRMv2__TStatusCode;
			return soap_in_SRMv2__TStatusCode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TOverwriteMode"))
		{	*type = SOAP_TYPE_SRMv2__TOverwriteMode;
			return soap_in_SRMv2__TOverwriteMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestType"))
		{	*type = SOAP_TYPE_SRMv2__TRequestType;
			return soap_in_SRMv2__TRequestType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPermissionType"))
		{	*type = SOAP_TYPE_SRMv2__TPermissionType;
			return soap_in_SRMv2__TPermissionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPermissionMode"))
		{	*type = SOAP_TYPE_SRMv2__TPermissionMode;
			return soap_in_SRMv2__TPermissionMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TFileType"))
		{	*type = SOAP_TYPE_SRMv2__TFileType;
			return soap_in_SRMv2__TFileType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TFileStorageType"))
		{	*type = SOAP_TYPE_SRMv2__TFileStorageType;
			return soap_in_SRMv2__TFileStorageType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSpaceType"))
		{	*type = SOAP_TYPE_SRMv2__TSpaceType;
			return soap_in_SRMv2__TSpaceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestIDResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestIDResponse;
			return soap_in_SRMv2__srmGetRequestIDResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestIDRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestIDRequest;
			return soap_in_SRMv2__srmGetRequestIDRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse;
			return soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest;
			return soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummaryResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse;
			return soap_in_SRMv2__srmGetRequestSummaryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummaryRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest;
			return soap_in_SRMv2__srmGetRequestSummaryRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse;
			return soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest;
			return soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse;
			return soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest;
			return soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse;
			return soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest;
			return soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequestResponse;
			return soap_in_SRMv2__srmResumeRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequestRequest;
			return soap_in_SRMv2__srmResumeRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequestResponse;
			return soap_in_SRMv2__srmSuspendRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequestRequest;
			return soap_in_SRMv2__srmSuspendRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFilesResponse;
			return soap_in_SRMv2__srmAbortFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFilesRequest;
			return soap_in_SRMv2__srmAbortFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequestResponse;
			return soap_in_SRMv2__srmAbortRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequestRequest;
			return soap_in_SRMv2__srmAbortRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDoneResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDoneResponse;
			return soap_in_SRMv2__srmPutDoneResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDoneRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDoneRequest;
			return soap_in_SRMv2__srmPutDoneRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFilesResponse;
			return soap_in_SRMv2__srmReleaseFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFilesRequest;
			return soap_in_SRMv2__srmReleaseFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRemoveFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRemoveFilesResponse;
			return soap_in_SRMv2__srmRemoveFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRemoveFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmRemoveFilesRequest;
			return soap_in_SRMv2__srmRemoveFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopyResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCopyResponse;
			return soap_in_SRMv2__srmCopyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopyRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmCopyRequest;
			return soap_in_SRMv2__srmCopyRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPutResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPutResponse;
			return soap_in_SRMv2__srmPrepareToPutResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPutRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPutRequest;
			return soap_in_SRMv2__srmPrepareToPutRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGetResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGetResponse;
			return soap_in_SRMv2__srmPrepareToGetResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGetRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGetRequest;
			return soap_in_SRMv2__srmPrepareToGetRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMvResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMvResponse;
			return soap_in_SRMv2__srmMvResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMvRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmMvRequest;
			return soap_in_SRMv2__srmMvRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLsResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmLsResponse;
			return soap_in_SRMv2__srmLsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLsRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmLsRequest;
			return soap_in_SRMv2__srmLsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmResponse;
			return soap_in_SRMv2__srmRmResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmRmRequest;
			return soap_in_SRMv2__srmRmRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdirResponse;
			return soap_in_SRMv2__srmRmdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdirRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdirRequest;
			return soap_in_SRMv2__srmRmdirRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdirResponse;
			return soap_in_SRMv2__srmMkdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdirRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdirRequest;
			return soap_in_SRMv2__srmMkdirRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermissionResponse;
			return soap_in_SRMv2__srmCheckPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermissionRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermissionRequest;
			return soap_in_SRMv2__srmCheckPermissionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReassignToUserResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReassignToUserResponse;
			return soap_in_SRMv2__srmReassignToUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReassignToUserRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReassignToUserRequest;
			return soap_in_SRMv2__srmReassignToUserRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermissionResponse;
			return soap_in_SRMv2__srmSetPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermissionRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermissionRequest;
			return soap_in_SRMv2__srmSetPermissionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokenResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse;
			return soap_in_SRMv2__srmGetSpaceTokenResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokenRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest;
			return soap_in_SRMv2__srmGetSpaceTokenRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeFileStorageTypeResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse;
			return soap_in_SRMv2__srmChangeFileStorageTypeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeFileStorageTypeRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest;
			return soap_in_SRMv2__srmChangeFileStorageTypeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaDataResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse;
			return soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaDataRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest;
			return soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCompactSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCompactSpaceResponse;
			return soap_in_SRMv2__srmCompactSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCompactSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmCompactSpaceRequest;
			return soap_in_SRMv2__srmCompactSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpaceResponse;
			return soap_in_SRMv2__srmUpdateSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpaceRequest;
			return soap_in_SRMv2__srmUpdateSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpaceResponse;
			return soap_in_SRMv2__srmReleaseSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpaceRequest;
			return soap_in_SRMv2__srmReleaseSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpaceResponse;
			return soap_in_SRMv2__srmReserveSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpaceRequest;
			return soap_in_SRMv2__srmReserveSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestTokenReturn"))
		{	*type = SOAP_TYPE_SRMv2__TRequestTokenReturn;
			return soap_in_SRMv2__TRequestTokenReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTRequestToken"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTRequestToken;
			return soap_in_SRMv2__ArrayOfTRequestToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURL"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURL;
			return soap_in_SRMv2__ArrayOfTSURL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOf_xsd_string"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring;
			return soap_in_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURLPermissionReturn"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn;
			return soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURLPermissionReturn"))
		{	*type = SOAP_TYPE_SRMv2__TSURLPermissionReturn;
			return soap_in_SRMv2__TSURLPermissionReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTRequestSummary"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTRequestSummary;
			return soap_in_SRMv2__ArrayOfTRequestSummary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestSummary"))
		{	*type = SOAP_TYPE_SRMv2__TRequestSummary;
			return soap_in_SRMv2__TRequestSummary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTCopyRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TCopyRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TCopyRequestFileStatus;
			return soap_in_SRMv2__TCopyRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTPutRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPutRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TPutRequestFileStatus;
			return soap_in_SRMv2__TPutRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTGetRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTGetRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGetRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TGetRequestFileStatus;
			return soap_in_SRMv2__TGetRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURLReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus;
			return soap_in_SRMv2__ArrayOfTSURLReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURLReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__TSURLReturnStatus;
			return soap_in_SRMv2__TSURLReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__TReturnStatus;
			return soap_in_SRMv2__TReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTCopyFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest;
			return soap_in_SRMv2__ArrayOfTCopyFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TCopyFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__TCopyFileRequest;
			return soap_in_SRMv2__TCopyFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTPutFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest;
			return soap_in_SRMv2__ArrayOfTPutFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPutFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__TPutFileRequest;
			return soap_in_SRMv2__TPutFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTGetFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest;
			return soap_in_SRMv2__ArrayOfTGetFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGetFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__TGetFileRequest;
			return soap_in_SRMv2__TGetFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURLInfo"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURLInfo;
			return soap_in_SRMv2__ArrayOfTSURLInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURLInfo"))
		{	*type = SOAP_TYPE_SRMv2__TSURLInfo;
			return soap_in_SRMv2__TSURLInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TDirOption"))
		{	*type = SOAP_TYPE_SRMv2__TDirOption;
			return soap_in_SRMv2__TDirOption(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TStorageSystemInfo"))
		{	*type = SOAP_TYPE_SRMv2__TStorageSystemInfo;
			return soap_in_SRMv2__TStorageSystemInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTMetaDataSpace"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace;
			return soap_in_SRMv2__ArrayOfTMetaDataSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TMetaDataSpace"))
		{	*type = SOAP_TYPE_SRMv2__TMetaDataSpace;
			return soap_in_SRMv2__TMetaDataSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTMetaDataPathDetail"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail;
			return soap_in_SRMv2__ArrayOfTMetaDataPathDetail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TMetaDataPathDetail"))
		{	*type = SOAP_TYPE_SRMv2__TMetaDataPathDetail;
			return soap_in_SRMv2__TMetaDataPathDetail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TTURL"))
		{	*type = SOAP_TYPE_SRMv2__TTURL;
			return soap_in_SRMv2__TTURL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURL"))
		{	*type = SOAP_TYPE_SRMv2__TSURL;
			return soap_in_SRMv2__TSURL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TLifeTimeInSeconds"))
		{	*type = SOAP_TYPE_SRMv2__TLifeTimeInSeconds;
			return soap_in_SRMv2__TLifeTimeInSeconds(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGMTTime"))
		{	*type = SOAP_TYPE_SRMv2__TGMTTime;
			return soap_in_SRMv2__TGMTTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSizeInBytes"))
		{	*type = SOAP_TYPE_SRMv2__TSizeInBytes;
			return soap_in_SRMv2__TSizeInBytes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TCheckSumValue"))
		{	*type = SOAP_TYPE_SRMv2__TCheckSumValue;
			return soap_in_SRMv2__TCheckSumValue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TCheckSumType"))
		{	*type = SOAP_TYPE_SRMv2__TCheckSumType;
			return soap_in_SRMv2__TCheckSumType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TOtherPermission"))
		{	*type = SOAP_TYPE_SRMv2__TOtherPermission;
			return soap_in_SRMv2__TOtherPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTGroupPermission"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTGroupPermission;
			return soap_in_SRMv2__ArrayOfTGroupPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGroupPermission"))
		{	*type = SOAP_TYPE_SRMv2__TGroupPermission;
			return soap_in_SRMv2__TGroupPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTUserPermission"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTUserPermission;
			return soap_in_SRMv2__ArrayOfTUserPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TUserPermission"))
		{	*type = SOAP_TYPE_SRMv2__TUserPermission;
			return soap_in_SRMv2__TUserPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TOwnerPermission"))
		{	*type = SOAP_TYPE_SRMv2__TOwnerPermission;
			return soap_in_SRMv2__TOwnerPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGroupID"))
		{	*type = SOAP_TYPE_SRMv2__TGroupID;
			return soap_in_SRMv2__TGroupID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TUserID"))
		{	*type = SOAP_TYPE_SRMv2__TUserID;
			return soap_in_SRMv2__TUserID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSpaceToken"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSpaceToken;
			return soap_in_SRMv2__ArrayOfTSpaceToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSpaceToken"))
		{	*type = SOAP_TYPE_SRMv2__TSpaceToken;
			return soap_in_SRMv2__TSpaceToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestToken"))
		{	*type = SOAP_TYPE_SRMv2__TRequestToken;
			return soap_in_SRMv2__TRequestToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestID"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestID;
			return soap_in_SRMv2__srmGetRequestID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestIDResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestIDResponse_;
			return soap_in_SRMv2__srmGetRequestIDResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTime"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTime;
			return soap_in_SRMv2__srmExtendFileLifeTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_;
			return soap_in_SRMv2__srmExtendFileLifeTimeResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummary"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummary;
			return soap_in_SRMv2__srmGetRequestSummary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummaryResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_;
			return soap_in_SRMv2__srmGetRequestSummaryResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequest;
			return soap_in_SRMv2__srmStatusOfCopyRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_;
			return soap_in_SRMv2__srmStatusOfCopyRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequest;
			return soap_in_SRMv2__srmStatusOfPutRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_;
			return soap_in_SRMv2__srmStatusOfPutRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequest;
			return soap_in_SRMv2__srmStatusOfGetRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_;
			return soap_in_SRMv2__srmStatusOfGetRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequest;
			return soap_in_SRMv2__srmResumeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequestResponse_;
			return soap_in_SRMv2__srmResumeRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequest;
			return soap_in_SRMv2__srmSuspendRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequestResponse_;
			return soap_in_SRMv2__srmSuspendRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFiles"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFiles;
			return soap_in_SRMv2__srmAbortFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFilesResponse_;
			return soap_in_SRMv2__srmAbortFilesResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequest;
			return soap_in_SRMv2__srmAbortRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequestResponse_;
			return soap_in_SRMv2__srmAbortRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDone"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDone;
			return soap_in_SRMv2__srmPutDone(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDoneResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDoneResponse_;
			return soap_in_SRMv2__srmPutDoneResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFiles"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFiles;
			return soap_in_SRMv2__srmReleaseFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFilesResponse_;
			return soap_in_SRMv2__srmReleaseFilesResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRemoveFiles"))
		{	*type = SOAP_TYPE_SRMv2__srmRemoveFiles;
			return soap_in_SRMv2__srmRemoveFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRemoveFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRemoveFilesResponse_;
			return soap_in_SRMv2__srmRemoveFilesResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopy"))
		{	*type = SOAP_TYPE_SRMv2__srmCopy;
			return soap_in_SRMv2__srmCopy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopyResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCopyResponse_;
			return soap_in_SRMv2__srmCopyResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPut"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPut;
			return soap_in_SRMv2__srmPrepareToPut(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPutResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPutResponse_;
			return soap_in_SRMv2__srmPrepareToPutResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGet"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGet;
			return soap_in_SRMv2__srmPrepareToGet(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGetResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGetResponse_;
			return soap_in_SRMv2__srmPrepareToGetResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMv"))
		{	*type = SOAP_TYPE_SRMv2__srmMv;
			return soap_in_SRMv2__srmMv(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMvResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMvResponse_;
			return soap_in_SRMv2__srmMvResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLs"))
		{	*type = SOAP_TYPE_SRMv2__srmLs;
			return soap_in_SRMv2__srmLs(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLsResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmLsResponse_;
			return soap_in_SRMv2__srmLsResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRm"))
		{	*type = SOAP_TYPE_SRMv2__srmRm;
			return soap_in_SRMv2__srmRm(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmResponse_;
			return soap_in_SRMv2__srmRmResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdir"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdir;
			return soap_in_SRMv2__srmRmdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdirResponse_;
			return soap_in_SRMv2__srmRmdirResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdir"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdir;
			return soap_in_SRMv2__srmMkdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdirResponse_;
			return soap_in_SRMv2__srmMkdirResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermission"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermission;
			return soap_in_SRMv2__srmCheckPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermissionResponse_;
			return soap_in_SRMv2__srmCheckPermissionResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReassignToUser"))
		{	*type = SOAP_TYPE_SRMv2__srmReassignToUser;
			return soap_in_SRMv2__srmReassignToUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReassignToUserResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReassignToUserResponse_;
			return soap_in_SRMv2__srmReassignToUserResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermission"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermission;
			return soap_in_SRMv2__srmSetPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermissionResponse_;
			return soap_in_SRMv2__srmSetPermissionResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceToken"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceToken;
			return soap_in_SRMv2__srmGetSpaceToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokenResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse_;
			return soap_in_SRMv2__srmGetSpaceTokenResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeFileStorageType"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeFileStorageType;
			return soap_in_SRMv2__srmChangeFileStorageType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeFileStorageTypeResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse_;
			return soap_in_SRMv2__srmChangeFileStorageTypeResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaData"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaData;
			return soap_in_SRMv2__srmGetSpaceMetaData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaDataResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_;
			return soap_in_SRMv2__srmGetSpaceMetaDataResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCompactSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmCompactSpace;
			return soap_in_SRMv2__srmCompactSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCompactSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCompactSpaceResponse_;
			return soap_in_SRMv2__srmCompactSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpace;
			return soap_in_SRMv2__srmUpdateSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_;
			return soap_in_SRMv2__srmUpdateSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpace;
			return soap_in_SRMv2__srmReleaseSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_;
			return soap_in_SRMv2__srmReleaseSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpace;
			return soap_in_SRMv2__srmReserveSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpaceResponse_;
			return soap_in_SRMv2__srmReserveSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_SRMv2__TStatusCode:
		return soap_out_SRMv2__TStatusCode(soap, tag, id, (const enum SRMv2__TStatusCode *)ptr, "SRMv2:TStatusCode");
	case SOAP_TYPE_SRMv2__TOverwriteMode:
		return soap_out_SRMv2__TOverwriteMode(soap, tag, id, (const enum SRMv2__TOverwriteMode *)ptr, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_SRMv2__TRequestType:
		return soap_out_SRMv2__TRequestType(soap, tag, id, (const enum SRMv2__TRequestType *)ptr, "SRMv2:TRequestType");
	case SOAP_TYPE_SRMv2__TPermissionType:
		return soap_out_SRMv2__TPermissionType(soap, tag, id, (const enum SRMv2__TPermissionType *)ptr, "SRMv2:TPermissionType");
	case SOAP_TYPE_SRMv2__TPermissionMode:
		return soap_out_SRMv2__TPermissionMode(soap, tag, id, (const enum SRMv2__TPermissionMode *)ptr, "SRMv2:TPermissionMode");
	case SOAP_TYPE_SRMv2__TFileType:
		return soap_out_SRMv2__TFileType(soap, tag, id, (const enum SRMv2__TFileType *)ptr, "SRMv2:TFileType");
	case SOAP_TYPE_SRMv2__TFileStorageType:
		return soap_out_SRMv2__TFileStorageType(soap, tag, id, (const enum SRMv2__TFileStorageType *)ptr, "SRMv2:TFileStorageType");
	case SOAP_TYPE_SRMv2__TSpaceType:
		return soap_out_SRMv2__TSpaceType(soap, tag, id, (const enum SRMv2__TSpaceType *)ptr, "SRMv2:TSpaceType");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse:
		return ((SRMv2__srmGetRequestIDResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestIDResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestIDRequest:
		return ((SRMv2__srmGetRequestIDRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestIDRequest");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		return ((SRMv2__srmExtendFileLifeTimeResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		return ((SRMv2__srmExtendFileLifeTimeRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		return ((SRMv2__srmGetRequestSummaryResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		return ((SRMv2__srmGetRequestSummaryRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		return ((SRMv2__srmStatusOfCopyRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		return ((SRMv2__srmStatusOfCopyRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		return ((SRMv2__srmStatusOfPutRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		return ((SRMv2__srmStatusOfPutRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		return ((SRMv2__srmStatusOfGetRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		return ((SRMv2__srmStatusOfGetRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		return ((SRMv2__srmResumeRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		return ((SRMv2__srmResumeRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		return ((SRMv2__srmSuspendRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		return ((SRMv2__srmSuspendRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		return ((SRMv2__srmAbortFilesResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		return ((SRMv2__srmAbortFilesRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		return ((SRMv2__srmAbortRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		return ((SRMv2__srmAbortRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		return ((SRMv2__srmPutDoneResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		return ((SRMv2__srmPutDoneRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		return ((SRMv2__srmReleaseFilesResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		return ((SRMv2__srmReleaseFilesRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse:
		return ((SRMv2__srmRemoveFilesResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRemoveFilesResponse");
	case SOAP_TYPE_SRMv2__srmRemoveFilesRequest:
		return ((SRMv2__srmRemoveFilesRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRemoveFilesRequest");
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		return ((SRMv2__srmCopyResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		return ((SRMv2__srmCopyRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		return ((SRMv2__srmPrepareToPutResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		return ((SRMv2__srmPrepareToPutRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		return ((SRMv2__srmPrepareToGetResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		return ((SRMv2__srmPrepareToGetRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_SRMv2__srmMvResponse:
		return ((SRMv2__srmMvResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmMvRequest:
		return ((SRMv2__srmMvRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMvRequest");
	case SOAP_TYPE_SRMv2__srmLsResponse:
		return ((SRMv2__srmLsResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmLsRequest:
		return ((SRMv2__srmLsRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmLsRequest");
	case SOAP_TYPE_SRMv2__srmRmResponse:
		return ((SRMv2__srmRmResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmRequest:
		return ((SRMv2__srmRmRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmRequest");
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		return ((SRMv2__srmRmdirResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		return ((SRMv2__srmRmdirRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		return ((SRMv2__srmMkdirResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		return ((SRMv2__srmMkdirRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		return ((SRMv2__srmCheckPermissionResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		return ((SRMv2__srmCheckPermissionRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse:
		return ((SRMv2__srmReassignToUserResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReassignToUserResponse");
	case SOAP_TYPE_SRMv2__srmReassignToUserRequest:
		return ((SRMv2__srmReassignToUserRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReassignToUserRequest");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		return ((SRMv2__srmSetPermissionResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		return ((SRMv2__srmSetPermissionRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse:
		return ((SRMv2__srmGetSpaceTokenResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceTokenResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest:
		return ((SRMv2__srmGetSpaceTokenRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceTokenRequest");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse:
		return ((SRMv2__srmChangeFileStorageTypeResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmChangeFileStorageTypeResponse");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest:
		return ((SRMv2__srmChangeFileStorageTypeRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmChangeFileStorageTypeRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		return ((SRMv2__srmGetSpaceMetaDataResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		return ((SRMv2__srmGetSpaceMetaDataRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse:
		return ((SRMv2__srmCompactSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCompactSpaceResponse");
	case SOAP_TYPE_SRMv2__srmCompactSpaceRequest:
		return ((SRMv2__srmCompactSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCompactSpaceRequest");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		return ((SRMv2__srmUpdateSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		return ((SRMv2__srmUpdateSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		return ((SRMv2__srmReleaseSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		return ((SRMv2__srmReleaseSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		return ((SRMv2__srmReserveSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		return ((SRMv2__srmReserveSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		return ((SRMv2__TRequestTokenReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestToken:
		return ((SRMv2__ArrayOfTRequestToken *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTRequestToken");
	case SOAP_TYPE_SRMv2__ArrayOfTSURL:
		return ((SRMv2__ArrayOfTSURL *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURL");
	case SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring:
		return ((SRMv2__ArrayOf_USCORExsd_USCOREstring *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOf_xsd_string");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		return ((SRMv2__ArrayOfTSURLPermissionReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		return ((SRMv2__TSURLPermissionReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		return ((SRMv2__ArrayOfTRequestSummary *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_SRMv2__TRequestSummary:
		return ((SRMv2__TRequestSummary *)ptr)->soap_out(soap, tag, id, "SRMv2:TRequestSummary");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		return ((SRMv2__ArrayOfTCopyRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		return ((SRMv2__TCopyRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		return ((SRMv2__ArrayOfTPutRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		return ((SRMv2__TPutRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		return ((SRMv2__ArrayOfTGetRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		return ((SRMv2__TGetRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		return ((SRMv2__ArrayOfTSURLReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		return ((SRMv2__TSURLReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TReturnStatus:
		return ((SRMv2__TReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TReturnStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		return ((SRMv2__ArrayOfTCopyFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		return ((SRMv2__TCopyFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		return ((SRMv2__ArrayOfTPutFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		return ((SRMv2__TPutFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		return ((SRMv2__ArrayOfTGetFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		return ((SRMv2__TGetFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLInfo:
		return ((SRMv2__ArrayOfTSURLInfo *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURLInfo");
	case SOAP_TYPE_SRMv2__TSURLInfo:
		return ((SRMv2__TSURLInfo *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURLInfo");
	case SOAP_TYPE_SRMv2__TDirOption:
		return ((SRMv2__TDirOption *)ptr)->soap_out(soap, tag, id, "SRMv2:TDirOption");
	case SOAP_TYPE_SRMv2__TStorageSystemInfo:
		return ((SRMv2__TStorageSystemInfo *)ptr)->soap_out(soap, tag, id, "SRMv2:TStorageSystemInfo");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		return ((SRMv2__ArrayOfTMetaDataSpace *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		return ((SRMv2__TMetaDataSpace *)ptr)->soap_out(soap, tag, id, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		return ((SRMv2__ArrayOfTMetaDataPathDetail *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		return ((SRMv2__TMetaDataPathDetail *)ptr)->soap_out(soap, tag, id, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__TTURL:
		return ((SRMv2__TTURL *)ptr)->soap_out(soap, tag, id, "SRMv2:TTURL");
	case SOAP_TYPE_SRMv2__TSURL:
		return ((SRMv2__TSURL *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURL");
	case SOAP_TYPE_SRMv2__TLifeTimeInSeconds:
		return ((SRMv2__TLifeTimeInSeconds *)ptr)->soap_out(soap, tag, id, "SRMv2:TLifeTimeInSeconds");
	case SOAP_TYPE_SRMv2__TGMTTime:
		return ((SRMv2__TGMTTime *)ptr)->soap_out(soap, tag, id, "SRMv2:TGMTTime");
	case SOAP_TYPE_SRMv2__TSizeInBytes:
		return ((SRMv2__TSizeInBytes *)ptr)->soap_out(soap, tag, id, "SRMv2:TSizeInBytes");
	case SOAP_TYPE_SRMv2__TCheckSumValue:
		return ((SRMv2__TCheckSumValue *)ptr)->soap_out(soap, tag, id, "SRMv2:TCheckSumValue");
	case SOAP_TYPE_SRMv2__TCheckSumType:
		return ((SRMv2__TCheckSumType *)ptr)->soap_out(soap, tag, id, "SRMv2:TCheckSumType");
	case SOAP_TYPE_SRMv2__TOtherPermission:
		return ((SRMv2__TOtherPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:TOtherPermission");
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		return ((SRMv2__ArrayOfTGroupPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_SRMv2__TGroupPermission:
		return ((SRMv2__TGroupPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:TGroupPermission");
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		return ((SRMv2__ArrayOfTUserPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_SRMv2__TUserPermission:
		return ((SRMv2__TUserPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:TUserPermission");
	case SOAP_TYPE_SRMv2__TOwnerPermission:
		return ((SRMv2__TOwnerPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:TOwnerPermission");
	case SOAP_TYPE_SRMv2__TGroupID:
		return ((SRMv2__TGroupID *)ptr)->soap_out(soap, tag, id, "SRMv2:TGroupID");
	case SOAP_TYPE_SRMv2__TUserID:
		return ((SRMv2__TUserID *)ptr)->soap_out(soap, tag, id, "SRMv2:TUserID");
	case SOAP_TYPE_SRMv2__ArrayOfTSpaceToken:
		return ((SRMv2__ArrayOfTSpaceToken *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSpaceToken");
	case SOAP_TYPE_SRMv2__TSpaceToken:
		return ((SRMv2__TSpaceToken *)ptr)->soap_out(soap, tag, id, "SRMv2:TSpaceToken");
	case SOAP_TYPE_SRMv2__TRequestToken:
		return ((SRMv2__TRequestToken *)ptr)->soap_out(soap, tag, id, "SRMv2:TRequestToken");
	case SOAP_TYPE_SRMv2__srmGetRequestID:
		return soap_out_SRMv2__srmGetRequestID(soap, tag, id, (const struct SRMv2__srmGetRequestID *)ptr, "SRMv2:srmGetRequestID");
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse_:
		return soap_out_SRMv2__srmGetRequestIDResponse_(soap, tag, id, (const struct SRMv2__srmGetRequestIDResponse_ *)ptr, "SRMv2:srmGetRequestIDResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		return soap_out_SRMv2__srmExtendFileLifeTime(soap, tag, id, (const struct SRMv2__srmExtendFileLifeTime *)ptr, "SRMv2:srmExtendFileLifeTime");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		return soap_out_SRMv2__srmExtendFileLifeTimeResponse_(soap, tag, id, (const struct SRMv2__srmExtendFileLifeTimeResponse_ *)ptr, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		return soap_out_SRMv2__srmGetRequestSummary(soap, tag, id, (const struct SRMv2__srmGetRequestSummary *)ptr, "SRMv2:srmGetRequestSummary");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		return soap_out_SRMv2__srmGetRequestSummaryResponse_(soap, tag, id, (const struct SRMv2__srmGetRequestSummaryResponse_ *)ptr, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		return soap_out_SRMv2__srmStatusOfCopyRequest(soap, tag, id, (const struct SRMv2__srmStatusOfCopyRequest *)ptr, "SRMv2:srmStatusOfCopyRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		return soap_out_SRMv2__srmStatusOfCopyRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfCopyRequestResponse_ *)ptr, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		return soap_out_SRMv2__srmStatusOfPutRequest(soap, tag, id, (const struct SRMv2__srmStatusOfPutRequest *)ptr, "SRMv2:srmStatusOfPutRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		return soap_out_SRMv2__srmStatusOfPutRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfPutRequestResponse_ *)ptr, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		return soap_out_SRMv2__srmStatusOfGetRequest(soap, tag, id, (const struct SRMv2__srmStatusOfGetRequest *)ptr, "SRMv2:srmStatusOfGetRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		return soap_out_SRMv2__srmStatusOfGetRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfGetRequestResponse_ *)ptr, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		return soap_out_SRMv2__srmResumeRequest(soap, tag, id, (const struct SRMv2__srmResumeRequest *)ptr, "SRMv2:srmResumeRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		return soap_out_SRMv2__srmResumeRequestResponse_(soap, tag, id, (const struct SRMv2__srmResumeRequestResponse_ *)ptr, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		return soap_out_SRMv2__srmSuspendRequest(soap, tag, id, (const struct SRMv2__srmSuspendRequest *)ptr, "SRMv2:srmSuspendRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		return soap_out_SRMv2__srmSuspendRequestResponse_(soap, tag, id, (const struct SRMv2__srmSuspendRequestResponse_ *)ptr, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		return soap_out_SRMv2__srmAbortFiles(soap, tag, id, (const struct SRMv2__srmAbortFiles *)ptr, "SRMv2:srmAbortFiles");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		return soap_out_SRMv2__srmAbortFilesResponse_(soap, tag, id, (const struct SRMv2__srmAbortFilesResponse_ *)ptr, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		return soap_out_SRMv2__srmAbortRequest(soap, tag, id, (const struct SRMv2__srmAbortRequest *)ptr, "SRMv2:srmAbortRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		return soap_out_SRMv2__srmAbortRequestResponse_(soap, tag, id, (const struct SRMv2__srmAbortRequestResponse_ *)ptr, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmPutDone:
		return soap_out_SRMv2__srmPutDone(soap, tag, id, (const struct SRMv2__srmPutDone *)ptr, "SRMv2:srmPutDone");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		return soap_out_SRMv2__srmPutDoneResponse_(soap, tag, id, (const struct SRMv2__srmPutDoneResponse_ *)ptr, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		return soap_out_SRMv2__srmReleaseFiles(soap, tag, id, (const struct SRMv2__srmReleaseFiles *)ptr, "SRMv2:srmReleaseFiles");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		return soap_out_SRMv2__srmReleaseFilesResponse_(soap, tag, id, (const struct SRMv2__srmReleaseFilesResponse_ *)ptr, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmRemoveFiles:
		return soap_out_SRMv2__srmRemoveFiles(soap, tag, id, (const struct SRMv2__srmRemoveFiles *)ptr, "SRMv2:srmRemoveFiles");
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse_:
		return soap_out_SRMv2__srmRemoveFilesResponse_(soap, tag, id, (const struct SRMv2__srmRemoveFilesResponse_ *)ptr, "SRMv2:srmRemoveFilesResponse");
	case SOAP_TYPE_SRMv2__srmCopy:
		return soap_out_SRMv2__srmCopy(soap, tag, id, (const struct SRMv2__srmCopy *)ptr, "SRMv2:srmCopy");
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		return soap_out_SRMv2__srmCopyResponse_(soap, tag, id, (const struct SRMv2__srmCopyResponse_ *)ptr, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		return soap_out_SRMv2__srmPrepareToPut(soap, tag, id, (const struct SRMv2__srmPrepareToPut *)ptr, "SRMv2:srmPrepareToPut");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		return soap_out_SRMv2__srmPrepareToPutResponse_(soap, tag, id, (const struct SRMv2__srmPrepareToPutResponse_ *)ptr, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		return soap_out_SRMv2__srmPrepareToGet(soap, tag, id, (const struct SRMv2__srmPrepareToGet *)ptr, "SRMv2:srmPrepareToGet");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		return soap_out_SRMv2__srmPrepareToGetResponse_(soap, tag, id, (const struct SRMv2__srmPrepareToGetResponse_ *)ptr, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmMv:
		return soap_out_SRMv2__srmMv(soap, tag, id, (const struct SRMv2__srmMv *)ptr, "SRMv2:srmMv");
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		return soap_out_SRMv2__srmMvResponse_(soap, tag, id, (const struct SRMv2__srmMvResponse_ *)ptr, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmLs:
		return soap_out_SRMv2__srmLs(soap, tag, id, (const struct SRMv2__srmLs *)ptr, "SRMv2:srmLs");
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		return soap_out_SRMv2__srmLsResponse_(soap, tag, id, (const struct SRMv2__srmLsResponse_ *)ptr, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmRm:
		return soap_out_SRMv2__srmRm(soap, tag, id, (const struct SRMv2__srmRm *)ptr, "SRMv2:srmRm");
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		return soap_out_SRMv2__srmRmResponse_(soap, tag, id, (const struct SRMv2__srmRmResponse_ *)ptr, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmdir:
		return soap_out_SRMv2__srmRmdir(soap, tag, id, (const struct SRMv2__srmRmdir *)ptr, "SRMv2:srmRmdir");
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		return soap_out_SRMv2__srmRmdirResponse_(soap, tag, id, (const struct SRMv2__srmRmdirResponse_ *)ptr, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdir:
		return soap_out_SRMv2__srmMkdir(soap, tag, id, (const struct SRMv2__srmMkdir *)ptr, "SRMv2:srmMkdir");
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		return soap_out_SRMv2__srmMkdirResponse_(soap, tag, id, (const struct SRMv2__srmMkdirResponse_ *)ptr, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		return soap_out_SRMv2__srmCheckPermission(soap, tag, id, (const struct SRMv2__srmCheckPermission *)ptr, "SRMv2:srmCheckPermission");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		return soap_out_SRMv2__srmCheckPermissionResponse_(soap, tag, id, (const struct SRMv2__srmCheckPermissionResponse_ *)ptr, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmReassignToUser:
		return soap_out_SRMv2__srmReassignToUser(soap, tag, id, (const struct SRMv2__srmReassignToUser *)ptr, "SRMv2:srmReassignToUser");
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse_:
		return soap_out_SRMv2__srmReassignToUserResponse_(soap, tag, id, (const struct SRMv2__srmReassignToUserResponse_ *)ptr, "SRMv2:srmReassignToUserResponse");
	case SOAP_TYPE_SRMv2__srmSetPermission:
		return soap_out_SRMv2__srmSetPermission(soap, tag, id, (const struct SRMv2__srmSetPermission *)ptr, "SRMv2:srmSetPermission");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		return soap_out_SRMv2__srmSetPermissionResponse_(soap, tag, id, (const struct SRMv2__srmSetPermissionResponse_ *)ptr, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceToken:
		return soap_out_SRMv2__srmGetSpaceToken(soap, tag, id, (const struct SRMv2__srmGetSpaceToken *)ptr, "SRMv2:srmGetSpaceToken");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse_:
		return soap_out_SRMv2__srmGetSpaceTokenResponse_(soap, tag, id, (const struct SRMv2__srmGetSpaceTokenResponse_ *)ptr, "SRMv2:srmGetSpaceTokenResponse");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageType:
		return soap_out_SRMv2__srmChangeFileStorageType(soap, tag, id, (const struct SRMv2__srmChangeFileStorageType *)ptr, "SRMv2:srmChangeFileStorageType");
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse_:
		return soap_out_SRMv2__srmChangeFileStorageTypeResponse_(soap, tag, id, (const struct SRMv2__srmChangeFileStorageTypeResponse_ *)ptr, "SRMv2:srmChangeFileStorageTypeResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		return soap_out_SRMv2__srmGetSpaceMetaData(soap, tag, id, (const struct SRMv2__srmGetSpaceMetaData *)ptr, "SRMv2:srmGetSpaceMetaData");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		return soap_out_SRMv2__srmGetSpaceMetaDataResponse_(soap, tag, id, (const struct SRMv2__srmGetSpaceMetaDataResponse_ *)ptr, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmCompactSpace:
		return soap_out_SRMv2__srmCompactSpace(soap, tag, id, (const struct SRMv2__srmCompactSpace *)ptr, "SRMv2:srmCompactSpace");
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse_:
		return soap_out_SRMv2__srmCompactSpaceResponse_(soap, tag, id, (const struct SRMv2__srmCompactSpaceResponse_ *)ptr, "SRMv2:srmCompactSpaceResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		return soap_out_SRMv2__srmUpdateSpace(soap, tag, id, (const struct SRMv2__srmUpdateSpace *)ptr, "SRMv2:srmUpdateSpace");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		return soap_out_SRMv2__srmUpdateSpaceResponse_(soap, tag, id, (const struct SRMv2__srmUpdateSpaceResponse_ *)ptr, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		return soap_out_SRMv2__srmReleaseSpace(soap, tag, id, (const struct SRMv2__srmReleaseSpace *)ptr, "SRMv2:srmReleaseSpace");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		return soap_out_SRMv2__srmReleaseSpaceResponse_(soap, tag, id, (const struct SRMv2__srmReleaseSpaceResponse_ *)ptr, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		return soap_out_SRMv2__srmReserveSpace(soap, tag, id, (const struct SRMv2__srmReserveSpace *)ptr, "SRMv2:srmReserveSpace");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		return soap_out_SRMv2__srmReserveSpaceResponse_(soap, tag, id, (const struct SRMv2__srmReserveSpaceResponse_ *)ptr, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestIDRequest:
		return soap_out_PointerToSRMv2__srmGetRequestIDRequest(soap, tag, id, (SRMv2__srmGetRequestIDRequest *const*)ptr, "SRMv2:srmGetRequestIDRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestIDResponse:
		return soap_out_PointerToSRMv2__srmGetRequestIDResponse(soap, tag, id, (SRMv2__srmGetRequestIDResponse *const*)ptr, "SRMv2:srmGetRequestIDResponse");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeRequest:
		return soap_out_PointerToSRMv2__srmExtendFileLifeTimeRequest(soap, tag, id, (SRMv2__srmExtendFileLifeTimeRequest *const*)ptr, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeResponse:
		return soap_out_PointerToSRMv2__srmExtendFileLifeTimeResponse(soap, tag, id, (SRMv2__srmExtendFileLifeTimeResponse *const*)ptr, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryRequest:
		return soap_out_PointerToSRMv2__srmGetRequestSummaryRequest(soap, tag, id, (SRMv2__srmGetRequestSummaryRequest *const*)ptr, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryResponse:
		return soap_out_PointerToSRMv2__srmGetRequestSummaryResponse(soap, tag, id, (SRMv2__srmGetRequestSummaryResponse *const*)ptr, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfCopyRequestRequest(soap, tag, id, (SRMv2__srmStatusOfCopyRequestRequest *const*)ptr, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfCopyRequestResponse(soap, tag, id, (SRMv2__srmStatusOfCopyRequestResponse *const*)ptr, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfPutRequestRequest(soap, tag, id, (SRMv2__srmStatusOfPutRequestRequest *const*)ptr, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfPutRequestResponse(soap, tag, id, (SRMv2__srmStatusOfPutRequestResponse *const*)ptr, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfGetRequestRequest(soap, tag, id, (SRMv2__srmStatusOfGetRequestRequest *const*)ptr, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfGetRequestResponse(soap, tag, id, (SRMv2__srmStatusOfGetRequestResponse *const*)ptr, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestRequest:
		return soap_out_PointerToSRMv2__srmResumeRequestRequest(soap, tag, id, (SRMv2__srmResumeRequestRequest *const*)ptr, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestResponse:
		return soap_out_PointerToSRMv2__srmResumeRequestResponse(soap, tag, id, (SRMv2__srmResumeRequestResponse *const*)ptr, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestRequest:
		return soap_out_PointerToSRMv2__srmSuspendRequestRequest(soap, tag, id, (SRMv2__srmSuspendRequestRequest *const*)ptr, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestResponse:
		return soap_out_PointerToSRMv2__srmSuspendRequestResponse(soap, tag, id, (SRMv2__srmSuspendRequestResponse *const*)ptr, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesRequest:
		return soap_out_PointerToSRMv2__srmAbortFilesRequest(soap, tag, id, (SRMv2__srmAbortFilesRequest *const*)ptr, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesResponse:
		return soap_out_PointerToSRMv2__srmAbortFilesResponse(soap, tag, id, (SRMv2__srmAbortFilesResponse *const*)ptr, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestRequest:
		return soap_out_PointerToSRMv2__srmAbortRequestRequest(soap, tag, id, (SRMv2__srmAbortRequestRequest *const*)ptr, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestResponse:
		return soap_out_PointerToSRMv2__srmAbortRequestResponse(soap, tag, id, (SRMv2__srmAbortRequestResponse *const*)ptr, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneRequest:
		return soap_out_PointerToSRMv2__srmPutDoneRequest(soap, tag, id, (SRMv2__srmPutDoneRequest *const*)ptr, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneResponse:
		return soap_out_PointerToSRMv2__srmPutDoneResponse(soap, tag, id, (SRMv2__srmPutDoneResponse *const*)ptr, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesRequest:
		return soap_out_PointerToSRMv2__srmReleaseFilesRequest(soap, tag, id, (SRMv2__srmReleaseFilesRequest *const*)ptr, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesResponse:
		return soap_out_PointerToSRMv2__srmReleaseFilesResponse(soap, tag, id, (SRMv2__srmReleaseFilesResponse *const*)ptr, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRemoveFilesRequest:
		return soap_out_PointerToSRMv2__srmRemoveFilesRequest(soap, tag, id, (SRMv2__srmRemoveFilesRequest *const*)ptr, "SRMv2:srmRemoveFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRemoveFilesResponse:
		return soap_out_PointerToSRMv2__srmRemoveFilesResponse(soap, tag, id, (SRMv2__srmRemoveFilesResponse *const*)ptr, "SRMv2:srmRemoveFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCopyRequest:
		return soap_out_PointerToSRMv2__srmCopyRequest(soap, tag, id, (SRMv2__srmCopyRequest *const*)ptr, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCopyResponse:
		return soap_out_PointerToSRMv2__srmCopyResponse(soap, tag, id, (SRMv2__srmCopyResponse *const*)ptr, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutRequest:
		return soap_out_PointerToSRMv2__srmPrepareToPutRequest(soap, tag, id, (SRMv2__srmPrepareToPutRequest *const*)ptr, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutResponse:
		return soap_out_PointerToSRMv2__srmPrepareToPutResponse(soap, tag, id, (SRMv2__srmPrepareToPutResponse *const*)ptr, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetRequest:
		return soap_out_PointerToSRMv2__srmPrepareToGetRequest(soap, tag, id, (SRMv2__srmPrepareToGetRequest *const*)ptr, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetResponse:
		return soap_out_PointerToSRMv2__srmPrepareToGetResponse(soap, tag, id, (SRMv2__srmPrepareToGetResponse *const*)ptr, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMvRequest:
		return soap_out_PointerToSRMv2__srmMvRequest(soap, tag, id, (SRMv2__srmMvRequest *const*)ptr, "SRMv2:srmMvRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMvResponse:
		return soap_out_PointerToSRMv2__srmMvResponse(soap, tag, id, (SRMv2__srmMvResponse *const*)ptr, "SRMv2:srmMvResponse");
	case SOAP_TYPE_PointerToSRMv2__srmLsRequest:
		return soap_out_PointerToSRMv2__srmLsRequest(soap, tag, id, (SRMv2__srmLsRequest *const*)ptr, "SRMv2:srmLsRequest");
	case SOAP_TYPE_PointerToSRMv2__srmLsResponse:
		return soap_out_PointerToSRMv2__srmLsResponse(soap, tag, id, (SRMv2__srmLsResponse *const*)ptr, "SRMv2:srmLsResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmRequest:
		return soap_out_PointerToSRMv2__srmRmRequest(soap, tag, id, (SRMv2__srmRmRequest *const*)ptr, "SRMv2:srmRmRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmResponse:
		return soap_out_PointerToSRMv2__srmRmResponse(soap, tag, id, (SRMv2__srmRmResponse *const*)ptr, "SRMv2:srmRmResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirRequest:
		return soap_out_PointerToSRMv2__srmRmdirRequest(soap, tag, id, (SRMv2__srmRmdirRequest *const*)ptr, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirResponse:
		return soap_out_PointerToSRMv2__srmRmdirResponse(soap, tag, id, (SRMv2__srmRmdirResponse *const*)ptr, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirRequest:
		return soap_out_PointerToSRMv2__srmMkdirRequest(soap, tag, id, (SRMv2__srmMkdirRequest *const*)ptr, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirResponse:
		return soap_out_PointerToSRMv2__srmMkdirResponse(soap, tag, id, (SRMv2__srmMkdirResponse *const*)ptr, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionRequest:
		return soap_out_PointerToSRMv2__srmCheckPermissionRequest(soap, tag, id, (SRMv2__srmCheckPermissionRequest *const*)ptr, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionResponse:
		return soap_out_PointerToSRMv2__srmCheckPermissionResponse(soap, tag, id, (SRMv2__srmCheckPermissionResponse *const*)ptr, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReassignToUserRequest:
		return soap_out_PointerToSRMv2__srmReassignToUserRequest(soap, tag, id, (SRMv2__srmReassignToUserRequest *const*)ptr, "SRMv2:srmReassignToUserRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReassignToUserResponse:
		return soap_out_PointerToSRMv2__srmReassignToUserResponse(soap, tag, id, (SRMv2__srmReassignToUserResponse *const*)ptr, "SRMv2:srmReassignToUserResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionRequest:
		return soap_out_PointerToSRMv2__srmSetPermissionRequest(soap, tag, id, (SRMv2__srmSetPermissionRequest *const*)ptr, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionResponse:
		return soap_out_PointerToSRMv2__srmSetPermissionResponse(soap, tag, id, (SRMv2__srmSetPermissionResponse *const*)ptr, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokenRequest:
		return soap_out_PointerToSRMv2__srmGetSpaceTokenRequest(soap, tag, id, (SRMv2__srmGetSpaceTokenRequest *const*)ptr, "SRMv2:srmGetSpaceTokenRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokenResponse:
		return soap_out_PointerToSRMv2__srmGetSpaceTokenResponse(soap, tag, id, (SRMv2__srmGetSpaceTokenResponse *const*)ptr, "SRMv2:srmGetSpaceTokenResponse");
	case SOAP_TYPE_PointerToSRMv2__srmChangeFileStorageTypeRequest:
		return soap_out_PointerToSRMv2__srmChangeFileStorageTypeRequest(soap, tag, id, (SRMv2__srmChangeFileStorageTypeRequest *const*)ptr, "SRMv2:srmChangeFileStorageTypeRequest");
	case SOAP_TYPE_PointerToSRMv2__srmChangeFileStorageTypeResponse:
		return soap_out_PointerToSRMv2__srmChangeFileStorageTypeResponse(soap, tag, id, (SRMv2__srmChangeFileStorageTypeResponse *const*)ptr, "SRMv2:srmChangeFileStorageTypeResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataRequest:
		return soap_out_PointerToSRMv2__srmGetSpaceMetaDataRequest(soap, tag, id, (SRMv2__srmGetSpaceMetaDataRequest *const*)ptr, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataResponse:
		return soap_out_PointerToSRMv2__srmGetSpaceMetaDataResponse(soap, tag, id, (SRMv2__srmGetSpaceMetaDataResponse *const*)ptr, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCompactSpaceRequest:
		return soap_out_PointerToSRMv2__srmCompactSpaceRequest(soap, tag, id, (SRMv2__srmCompactSpaceRequest *const*)ptr, "SRMv2:srmCompactSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCompactSpaceResponse:
		return soap_out_PointerToSRMv2__srmCompactSpaceResponse(soap, tag, id, (SRMv2__srmCompactSpaceResponse *const*)ptr, "SRMv2:srmCompactSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceRequest:
		return soap_out_PointerToSRMv2__srmUpdateSpaceRequest(soap, tag, id, (SRMv2__srmUpdateSpaceRequest *const*)ptr, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceResponse:
		return soap_out_PointerToSRMv2__srmUpdateSpaceResponse(soap, tag, id, (SRMv2__srmUpdateSpaceResponse *const*)ptr, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceRequest:
		return soap_out_PointerToSRMv2__srmReleaseSpaceRequest(soap, tag, id, (SRMv2__srmReleaseSpaceRequest *const*)ptr, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceResponse:
		return soap_out_PointerToSRMv2__srmReleaseSpaceResponse(soap, tag, id, (SRMv2__srmReleaseSpaceResponse *const*)ptr, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceRequest:
		return soap_out_PointerToSRMv2__srmReserveSpaceRequest(soap, tag, id, (SRMv2__srmReserveSpaceRequest *const*)ptr, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceResponse:
		return soap_out_PointerToSRMv2__srmReserveSpaceResponse(soap, tag, id, (SRMv2__srmReserveSpaceResponse *const*)ptr, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestSummary:
		return soap_out_PointerToSRMv2__ArrayOfTRequestSummary(soap, tag, id, (SRMv2__ArrayOfTRequestSummary *const*)ptr, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestToken:
		return soap_out_PointerToSRMv2__ArrayOfTRequestToken(soap, tag, id, (SRMv2__ArrayOfTRequestToken *const*)ptr, "SRMv2:ArrayOfTRequestToken");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURL:
		return soap_out_PointerToSRMv2__ArrayOfTSURL(soap, tag, id, (SRMv2__ArrayOfTSURL *const*)ptr, "SRMv2:ArrayOfTSURL");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTCopyRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyFileRequest:
		return soap_out_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, tag, id, (SRMv2__ArrayOfTCopyFileRequest *const*)ptr, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTPutRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutFileRequest:
		return soap_out_PointerToSRMv2__ArrayOfTPutFileRequest(soap, tag, id, (SRMv2__ArrayOfTPutFileRequest *const*)ptr, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTGetRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring:
		return soap_out_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, tag, id, (SRMv2__ArrayOf_USCORExsd_USCOREstring *const*)ptr, "SRMv2:ArrayOf_xsd_string");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetFileRequest:
		return soap_out_PointerToSRMv2__ArrayOfTGetFileRequest(soap, tag, id, (SRMv2__ArrayOfTGetFileRequest *const*)ptr, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLPermissionReturn:
		return soap_out_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, tag, id, (SRMv2__ArrayOfTSURLPermissionReturn *const*)ptr, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLReturnStatus:
		return soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, tag, id, (SRMv2__ArrayOfTSURLReturnStatus *const*)ptr, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLInfo:
		return soap_out_PointerToSRMv2__ArrayOfTSURLInfo(soap, tag, id, (SRMv2__ArrayOfTSURLInfo *const*)ptr, "SRMv2:ArrayOfTSURLInfo");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataSpace:
		return soap_out_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, tag, id, (SRMv2__ArrayOfTMetaDataSpace *const*)ptr, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSpaceToken:
		return soap_out_PointerToSRMv2__ArrayOfTSpaceToken(soap, tag, id, (SRMv2__ArrayOfTSpaceToken *const*)ptr, "SRMv2:ArrayOfTSpaceToken");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestToken:
		return soap_out_PointerToPointerToSRMv2__TRequestToken(soap, tag, id, (SRMv2__TRequestToken **const*)ptr, "SRMv2:TRequestToken");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURL:
		return soap_out_PointerToPointerToSRMv2__TSURL(soap, tag, id, (SRMv2__TSURL **const*)ptr, "SRMv2:TSURL");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLPermissionReturn:
		return soap_out_PointerToPointerToSRMv2__TSURLPermissionReturn(soap, tag, id, (SRMv2__TSURLPermissionReturn **const*)ptr, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TSURLPermissionReturn:
		return soap_out_PointerToSRMv2__TSURLPermissionReturn(soap, tag, id, (SRMv2__TSURLPermissionReturn *const*)ptr, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TPermissionType:
		return soap_out_PointerToSRMv2__TPermissionType(soap, tag, id, (enum SRMv2__TPermissionType *const*)ptr, "SRMv2:TPermissionType");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestSummary:
		return soap_out_PointerToPointerToSRMv2__TRequestSummary(soap, tag, id, (SRMv2__TRequestSummary **const*)ptr, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestSummary:
		return soap_out_PointerToSRMv2__TRequestSummary(soap, tag, id, (SRMv2__TRequestSummary *const*)ptr, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestType:
		return soap_out_PointerToSRMv2__TRequestType(soap, tag, id, (enum SRMv2__TRequestType *const*)ptr, "SRMv2:TRequestType");
	case SOAP_TYPE_PointerToSRMv2__TRequestToken:
		return soap_out_PointerToSRMv2__TRequestToken(soap, tag, id, (SRMv2__TRequestToken *const*)ptr, "SRMv2:TRequestToken");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TCopyRequestFileStatus(soap, tag, id, (SRMv2__TCopyRequestFileStatus **const*)ptr, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TCopyRequestFileStatus:
		return soap_out_PointerToSRMv2__TCopyRequestFileStatus(soap, tag, id, (SRMv2__TCopyRequestFileStatus *const*)ptr, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TPutRequestFileStatus(soap, tag, id, (SRMv2__TPutRequestFileStatus **const*)ptr, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TPutRequestFileStatus:
		return soap_out_PointerToSRMv2__TPutRequestFileStatus(soap, tag, id, (SRMv2__TPutRequestFileStatus *const*)ptr, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TGetRequestFileStatus(soap, tag, id, (SRMv2__TGetRequestFileStatus **const*)ptr, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TGetRequestFileStatus:
		return soap_out_PointerToSRMv2__TGetRequestFileStatus(soap, tag, id, (SRMv2__TGetRequestFileStatus *const*)ptr, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TTURL:
		return soap_out_PointerToSRMv2__TTURL(soap, tag, id, (SRMv2__TTURL *const*)ptr, "SRMv2:TTURL");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLReturnStatus:
		return soap_out_PointerToPointerToSRMv2__TSURLReturnStatus(soap, tag, id, (SRMv2__TSURLReturnStatus **const*)ptr, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TSURLReturnStatus:
		return soap_out_PointerToSRMv2__TSURLReturnStatus(soap, tag, id, (SRMv2__TSURLReturnStatus *const*)ptr, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyFileRequest:
		return soap_out_PointerToPointerToSRMv2__TCopyFileRequest(soap, tag, id, (SRMv2__TCopyFileRequest **const*)ptr, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TCopyFileRequest:
		return soap_out_PointerToSRMv2__TCopyFileRequest(soap, tag, id, (SRMv2__TCopyFileRequest *const*)ptr, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TOverwriteMode:
		return soap_out_PointerToSRMv2__TOverwriteMode(soap, tag, id, (enum SRMv2__TOverwriteMode *const*)ptr, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutFileRequest:
		return soap_out_PointerToPointerToSRMv2__TPutFileRequest(soap, tag, id, (SRMv2__TPutFileRequest **const*)ptr, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TPutFileRequest:
		return soap_out_PointerToSRMv2__TPutFileRequest(soap, tag, id, (SRMv2__TPutFileRequest *const*)ptr, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetFileRequest:
		return soap_out_PointerToPointerToSRMv2__TGetFileRequest(soap, tag, id, (SRMv2__TGetFileRequest **const*)ptr, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TGetFileRequest:
		return soap_out_PointerToSRMv2__TGetFileRequest(soap, tag, id, (SRMv2__TGetFileRequest *const*)ptr, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TDirOption:
		return soap_out_PointerToSRMv2__TDirOption(soap, tag, id, (SRMv2__TDirOption *const*)ptr, "SRMv2:TDirOption");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLInfo:
		return soap_out_PointerToPointerToSRMv2__TSURLInfo(soap, tag, id, (SRMv2__TSURLInfo **const*)ptr, "SRMv2:TSURLInfo");
	case SOAP_TYPE_PointerToSRMv2__TSURLInfo:
		return soap_out_PointerToSRMv2__TSURLInfo(soap, tag, id, (SRMv2__TSURLInfo *const*)ptr, "SRMv2:TSURLInfo");
	case SOAP_TYPE_PointerToSRMv2__TStorageSystemInfo:
		return soap_out_PointerToSRMv2__TStorageSystemInfo(soap, tag, id, (SRMv2__TStorageSystemInfo *const*)ptr, "SRMv2:TStorageSystemInfo");
	case SOAP_TYPE_PointerTobool:
		return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataSpace:
		return soap_out_PointerToPointerToSRMv2__TMetaDataSpace(soap, tag, id, (SRMv2__TMetaDataSpace **const*)ptr, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataSpace:
		return soap_out_PointerToSRMv2__TMetaDataSpace(soap, tag, id, (SRMv2__TMetaDataSpace *const*)ptr, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TSpaceType:
		return soap_out_PointerToSRMv2__TSpaceType(soap, tag, id, (enum SRMv2__TSpaceType *const*)ptr, "SRMv2:TSpaceType");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataPathDetail:
		return soap_out_PointerToPointerToSRMv2__TMetaDataPathDetail(soap, tag, id, (SRMv2__TMetaDataPathDetail **const*)ptr, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataPathDetail:
		return soap_out_PointerToSRMv2__TMetaDataPathDetail(soap, tag, id, (SRMv2__TMetaDataPathDetail *const*)ptr, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataPathDetail:
		return soap_out_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, tag, id, (SRMv2__ArrayOfTMetaDataPathDetail *const*)ptr, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TSURL:
		return soap_out_PointerToSRMv2__TSURL(soap, tag, id, (SRMv2__TSURL *const*)ptr, "SRMv2:TSURL");
	case SOAP_TYPE_PointerToSRMv2__TCheckSumValue:
		return soap_out_PointerToSRMv2__TCheckSumValue(soap, tag, id, (SRMv2__TCheckSumValue *const*)ptr, "SRMv2:TCheckSumValue");
	case SOAP_TYPE_PointerToSRMv2__TCheckSumType:
		return soap_out_PointerToSRMv2__TCheckSumType(soap, tag, id, (SRMv2__TCheckSumType *const*)ptr, "SRMv2:TCheckSumType");
	case SOAP_TYPE_PointerToSRMv2__TLifeTimeInSeconds:
		return soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, tag, id, (SRMv2__TLifeTimeInSeconds *const*)ptr, "SRMv2:TLifeTimeInSeconds");
	case SOAP_TYPE_PointerToSRMv2__TFileType:
		return soap_out_PointerToSRMv2__TFileType(soap, tag, id, (enum SRMv2__TFileType *const*)ptr, "SRMv2:TFileType");
	case SOAP_TYPE_PointerToSRMv2__TFileStorageType:
		return soap_out_PointerToSRMv2__TFileStorageType(soap, tag, id, (enum SRMv2__TFileStorageType *const*)ptr, "SRMv2:TFileStorageType");
	case SOAP_TYPE_PointerToSRMv2__TGMTTime:
		return soap_out_PointerToSRMv2__TGMTTime(soap, tag, id, (SRMv2__TGMTTime *const*)ptr, "SRMv2:TGMTTime");
	case SOAP_TYPE_PointerToSRMv2__TOtherPermission:
		return soap_out_PointerToSRMv2__TOtherPermission(soap, tag, id, (SRMv2__TOtherPermission *const*)ptr, "SRMv2:TOtherPermission");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGroupPermission:
		return soap_out_PointerToSRMv2__ArrayOfTGroupPermission(soap, tag, id, (SRMv2__ArrayOfTGroupPermission *const*)ptr, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTUserPermission:
		return soap_out_PointerToSRMv2__ArrayOfTUserPermission(soap, tag, id, (SRMv2__ArrayOfTUserPermission *const*)ptr, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TOwnerPermission:
		return soap_out_PointerToSRMv2__TOwnerPermission(soap, tag, id, (SRMv2__TOwnerPermission *const*)ptr, "SRMv2:TOwnerPermission");
	case SOAP_TYPE_PointerToSRMv2__TSizeInBytes:
		return soap_out_PointerToSRMv2__TSizeInBytes(soap, tag, id, (SRMv2__TSizeInBytes *const*)ptr, "SRMv2:TSizeInBytes");
	case SOAP_TYPE_PointerToSRMv2__TReturnStatus:
		return soap_out_PointerToSRMv2__TReturnStatus(soap, tag, id, (SRMv2__TReturnStatus *const*)ptr, "SRMv2:TReturnStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGroupPermission:
		return soap_out_PointerToPointerToSRMv2__TGroupPermission(soap, tag, id, (SRMv2__TGroupPermission **const*)ptr, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__TGroupPermission:
		return soap_out_PointerToSRMv2__TGroupPermission(soap, tag, id, (SRMv2__TGroupPermission *const*)ptr, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__TGroupID:
		return soap_out_PointerToSRMv2__TGroupID(soap, tag, id, (SRMv2__TGroupID *const*)ptr, "SRMv2:TGroupID");
	case SOAP_TYPE_PointerToPointerToSRMv2__TUserPermission:
		return soap_out_PointerToPointerToSRMv2__TUserPermission(soap, tag, id, (SRMv2__TUserPermission **const*)ptr, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TUserPermission:
		return soap_out_PointerToSRMv2__TUserPermission(soap, tag, id, (SRMv2__TUserPermission *const*)ptr, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TUserID:
		return soap_out_PointerToSRMv2__TUserID(soap, tag, id, (SRMv2__TUserID *const*)ptr, "SRMv2:TUserID");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSpaceToken:
		return soap_out_PointerToPointerToSRMv2__TSpaceToken(soap, tag, id, (SRMv2__TSpaceToken **const*)ptr, "SRMv2:TSpaceToken");
	case SOAP_TYPE_PointerToSRMv2__TSpaceToken:
		return soap_out_PointerToSRMv2__TSpaceToken(soap, tag, id, (SRMv2__TSpaceToken *const*)ptr, "SRMv2:TSpaceToken");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse:
		((SRMv2__srmGetRequestIDResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestIDRequest:
		((SRMv2__srmGetRequestIDRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		((SRMv2__srmExtendFileLifeTimeResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		((SRMv2__srmExtendFileLifeTimeRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		((SRMv2__srmGetRequestSummaryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		((SRMv2__srmGetRequestSummaryRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		((SRMv2__srmStatusOfCopyRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		((SRMv2__srmStatusOfCopyRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		((SRMv2__srmStatusOfPutRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		((SRMv2__srmStatusOfPutRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		((SRMv2__srmStatusOfGetRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		((SRMv2__srmStatusOfGetRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		((SRMv2__srmResumeRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		((SRMv2__srmResumeRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		((SRMv2__srmSuspendRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		((SRMv2__srmSuspendRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		((SRMv2__srmAbortFilesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		((SRMv2__srmAbortFilesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		((SRMv2__srmAbortRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		((SRMv2__srmAbortRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		((SRMv2__srmPutDoneResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		((SRMv2__srmPutDoneRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		((SRMv2__srmReleaseFilesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		((SRMv2__srmReleaseFilesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse:
		((SRMv2__srmRemoveFilesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFilesRequest:
		((SRMv2__srmRemoveFilesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		((SRMv2__srmCopyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		((SRMv2__srmCopyRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		((SRMv2__srmPrepareToPutResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		((SRMv2__srmPrepareToPutRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		((SRMv2__srmPrepareToGetResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		((SRMv2__srmPrepareToGetRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse:
		((SRMv2__srmMvResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMvRequest:
		((SRMv2__srmMvRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse:
		((SRMv2__srmLsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmLsRequest:
		((SRMv2__srmLsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse:
		((SRMv2__srmRmResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmRequest:
		((SRMv2__srmRmRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		((SRMv2__srmRmdirResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		((SRMv2__srmRmdirRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		((SRMv2__srmMkdirResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		((SRMv2__srmMkdirRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		((SRMv2__srmCheckPermissionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		((SRMv2__srmCheckPermissionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse:
		((SRMv2__srmReassignToUserResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUserRequest:
		((SRMv2__srmReassignToUserRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		((SRMv2__srmSetPermissionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		((SRMv2__srmSetPermissionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse:
		((SRMv2__srmGetSpaceTokenResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest:
		((SRMv2__srmGetSpaceTokenRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse:
		((SRMv2__srmChangeFileStorageTypeResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest:
		((SRMv2__srmChangeFileStorageTypeRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		((SRMv2__srmGetSpaceMetaDataResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		((SRMv2__srmGetSpaceMetaDataRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse:
		((SRMv2__srmCompactSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpaceRequest:
		((SRMv2__srmCompactSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		((SRMv2__srmUpdateSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		((SRMv2__srmUpdateSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		((SRMv2__srmReleaseSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		((SRMv2__srmReleaseSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		((SRMv2__srmReserveSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		((SRMv2__srmReserveSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		((SRMv2__TRequestTokenReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestToken:
		((SRMv2__ArrayOfTRequestToken *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURL:
		((SRMv2__ArrayOfTSURL *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring:
		((SRMv2__ArrayOf_USCORExsd_USCOREstring *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		((SRMv2__ArrayOfTSURLPermissionReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		((SRMv2__TSURLPermissionReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		((SRMv2__ArrayOfTRequestSummary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TRequestSummary:
		((SRMv2__TRequestSummary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		((SRMv2__ArrayOfTCopyRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		((SRMv2__TCopyRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		((SRMv2__ArrayOfTPutRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		((SRMv2__TPutRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		((SRMv2__ArrayOfTGetRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		((SRMv2__TGetRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		((SRMv2__ArrayOfTSURLReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		((SRMv2__TSURLReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TReturnStatus:
		((SRMv2__TReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		((SRMv2__ArrayOfTCopyFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		((SRMv2__TCopyFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		((SRMv2__ArrayOfTPutFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		((SRMv2__TPutFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		((SRMv2__ArrayOfTGetFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		((SRMv2__TGetFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLInfo:
		((SRMv2__ArrayOfTSURLInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURLInfo:
		((SRMv2__TSURLInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TDirOption:
		((SRMv2__TDirOption *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TStorageSystemInfo:
		((SRMv2__TStorageSystemInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		((SRMv2__ArrayOfTMetaDataSpace *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		((SRMv2__TMetaDataSpace *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		((SRMv2__ArrayOfTMetaDataPathDetail *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		((SRMv2__TMetaDataPathDetail *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TTURL:
		((SRMv2__TTURL *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURL:
		((SRMv2__TSURL *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TLifeTimeInSeconds:
		((SRMv2__TLifeTimeInSeconds *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGMTTime:
		((SRMv2__TGMTTime *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSizeInBytes:
		((SRMv2__TSizeInBytes *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TCheckSumValue:
		((SRMv2__TCheckSumValue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TCheckSumType:
		((SRMv2__TCheckSumType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TOtherPermission:
		((SRMv2__TOtherPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		((SRMv2__ArrayOfTGroupPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGroupPermission:
		((SRMv2__TGroupPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		((SRMv2__ArrayOfTUserPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TUserPermission:
		((SRMv2__TUserPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TOwnerPermission:
		((SRMv2__TOwnerPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGroupID:
		((SRMv2__TGroupID *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TUserID:
		((SRMv2__TUserID *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSpaceToken:
		((SRMv2__ArrayOfTSpaceToken *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSpaceToken:
		((SRMv2__TSpaceToken *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TRequestToken:
		((SRMv2__TRequestToken *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestID:
		soap_serialize_SRMv2__srmGetRequestID(soap, (const struct SRMv2__srmGetRequestID *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse_:
		soap_serialize_SRMv2__srmGetRequestIDResponse_(soap, (const struct SRMv2__srmGetRequestIDResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		soap_serialize_SRMv2__srmExtendFileLifeTime(soap, (const struct SRMv2__srmExtendFileLifeTime *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		soap_serialize_SRMv2__srmExtendFileLifeTimeResponse_(soap, (const struct SRMv2__srmExtendFileLifeTimeResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		soap_serialize_SRMv2__srmGetRequestSummary(soap, (const struct SRMv2__srmGetRequestSummary *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		soap_serialize_SRMv2__srmGetRequestSummaryResponse_(soap, (const struct SRMv2__srmGetRequestSummaryResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		soap_serialize_SRMv2__srmStatusOfCopyRequest(soap, (const struct SRMv2__srmStatusOfCopyRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfCopyRequestResponse_(soap, (const struct SRMv2__srmStatusOfCopyRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		soap_serialize_SRMv2__srmStatusOfPutRequest(soap, (const struct SRMv2__srmStatusOfPutRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfPutRequestResponse_(soap, (const struct SRMv2__srmStatusOfPutRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		soap_serialize_SRMv2__srmStatusOfGetRequest(soap, (const struct SRMv2__srmStatusOfGetRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfGetRequestResponse_(soap, (const struct SRMv2__srmStatusOfGetRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		soap_serialize_SRMv2__srmResumeRequest(soap, (const struct SRMv2__srmResumeRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		soap_serialize_SRMv2__srmResumeRequestResponse_(soap, (const struct SRMv2__srmResumeRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		soap_serialize_SRMv2__srmSuspendRequest(soap, (const struct SRMv2__srmSuspendRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		soap_serialize_SRMv2__srmSuspendRequestResponse_(soap, (const struct SRMv2__srmSuspendRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		soap_serialize_SRMv2__srmAbortFiles(soap, (const struct SRMv2__srmAbortFiles *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		soap_serialize_SRMv2__srmAbortFilesResponse_(soap, (const struct SRMv2__srmAbortFilesResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		soap_serialize_SRMv2__srmAbortRequest(soap, (const struct SRMv2__srmAbortRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		soap_serialize_SRMv2__srmAbortRequestResponse_(soap, (const struct SRMv2__srmAbortRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPutDone:
		soap_serialize_SRMv2__srmPutDone(soap, (const struct SRMv2__srmPutDone *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		soap_serialize_SRMv2__srmPutDoneResponse_(soap, (const struct SRMv2__srmPutDoneResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		soap_serialize_SRMv2__srmReleaseFiles(soap, (const struct SRMv2__srmReleaseFiles *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		soap_serialize_SRMv2__srmReleaseFilesResponse_(soap, (const struct SRMv2__srmReleaseFilesResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFiles:
		soap_serialize_SRMv2__srmRemoveFiles(soap, (const struct SRMv2__srmRemoveFiles *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse_:
		soap_serialize_SRMv2__srmRemoveFilesResponse_(soap, (const struct SRMv2__srmRemoveFilesResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCopy:
		soap_serialize_SRMv2__srmCopy(soap, (const struct SRMv2__srmCopy *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		soap_serialize_SRMv2__srmCopyResponse_(soap, (const struct SRMv2__srmCopyResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		soap_serialize_SRMv2__srmPrepareToPut(soap, (const struct SRMv2__srmPrepareToPut *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		soap_serialize_SRMv2__srmPrepareToPutResponse_(soap, (const struct SRMv2__srmPrepareToPutResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		soap_serialize_SRMv2__srmPrepareToGet(soap, (const struct SRMv2__srmPrepareToGet *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		soap_serialize_SRMv2__srmPrepareToGetResponse_(soap, (const struct SRMv2__srmPrepareToGetResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMv:
		soap_serialize_SRMv2__srmMv(soap, (const struct SRMv2__srmMv *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		soap_serialize_SRMv2__srmMvResponse_(soap, (const struct SRMv2__srmMvResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmLs:
		soap_serialize_SRMv2__srmLs(soap, (const struct SRMv2__srmLs *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		soap_serialize_SRMv2__srmLsResponse_(soap, (const struct SRMv2__srmLsResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRm:
		soap_serialize_SRMv2__srmRm(soap, (const struct SRMv2__srmRm *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		soap_serialize_SRMv2__srmRmResponse_(soap, (const struct SRMv2__srmRmResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRmdir:
		soap_serialize_SRMv2__srmRmdir(soap, (const struct SRMv2__srmRmdir *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		soap_serialize_SRMv2__srmRmdirResponse_(soap, (const struct SRMv2__srmRmdirResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMkdir:
		soap_serialize_SRMv2__srmMkdir(soap, (const struct SRMv2__srmMkdir *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		soap_serialize_SRMv2__srmMkdirResponse_(soap, (const struct SRMv2__srmMkdirResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		soap_serialize_SRMv2__srmCheckPermission(soap, (const struct SRMv2__srmCheckPermission *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		soap_serialize_SRMv2__srmCheckPermissionResponse_(soap, (const struct SRMv2__srmCheckPermissionResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUser:
		soap_serialize_SRMv2__srmReassignToUser(soap, (const struct SRMv2__srmReassignToUser *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse_:
		soap_serialize_SRMv2__srmReassignToUserResponse_(soap, (const struct SRMv2__srmReassignToUserResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermission:
		soap_serialize_SRMv2__srmSetPermission(soap, (const struct SRMv2__srmSetPermission *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		soap_serialize_SRMv2__srmSetPermissionResponse_(soap, (const struct SRMv2__srmSetPermissionResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceToken:
		soap_serialize_SRMv2__srmGetSpaceToken(soap, (const struct SRMv2__srmGetSpaceToken *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse_:
		soap_serialize_SRMv2__srmGetSpaceTokenResponse_(soap, (const struct SRMv2__srmGetSpaceTokenResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageType:
		soap_serialize_SRMv2__srmChangeFileStorageType(soap, (const struct SRMv2__srmChangeFileStorageType *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse_:
		soap_serialize_SRMv2__srmChangeFileStorageTypeResponse_(soap, (const struct SRMv2__srmChangeFileStorageTypeResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		soap_serialize_SRMv2__srmGetSpaceMetaData(soap, (const struct SRMv2__srmGetSpaceMetaData *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		soap_serialize_SRMv2__srmGetSpaceMetaDataResponse_(soap, (const struct SRMv2__srmGetSpaceMetaDataResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpace:
		soap_serialize_SRMv2__srmCompactSpace(soap, (const struct SRMv2__srmCompactSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse_:
		soap_serialize_SRMv2__srmCompactSpaceResponse_(soap, (const struct SRMv2__srmCompactSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		soap_serialize_SRMv2__srmUpdateSpace(soap, (const struct SRMv2__srmUpdateSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		soap_serialize_SRMv2__srmUpdateSpaceResponse_(soap, (const struct SRMv2__srmUpdateSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		soap_serialize_SRMv2__srmReleaseSpace(soap, (const struct SRMv2__srmReleaseSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		soap_serialize_SRMv2__srmReleaseSpaceResponse_(soap, (const struct SRMv2__srmReleaseSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		soap_serialize_SRMv2__srmReserveSpace(soap, (const struct SRMv2__srmReserveSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		soap_serialize_SRMv2__srmReserveSpaceResponse_(soap, (const struct SRMv2__srmReserveSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestIDRequest:
		soap_serialize_PointerToSRMv2__srmGetRequestIDRequest(soap, (SRMv2__srmGetRequestIDRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestIDResponse:
		soap_serialize_PointerToSRMv2__srmGetRequestIDResponse(soap, (SRMv2__srmGetRequestIDResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeRequest:
		soap_serialize_PointerToSRMv2__srmExtendFileLifeTimeRequest(soap, (SRMv2__srmExtendFileLifeTimeRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeResponse:
		soap_serialize_PointerToSRMv2__srmExtendFileLifeTimeResponse(soap, (SRMv2__srmExtendFileLifeTimeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryRequest:
		soap_serialize_PointerToSRMv2__srmGetRequestSummaryRequest(soap, (SRMv2__srmGetRequestSummaryRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryResponse:
		soap_serialize_PointerToSRMv2__srmGetRequestSummaryResponse(soap, (SRMv2__srmGetRequestSummaryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfCopyRequestRequest(soap, (SRMv2__srmStatusOfCopyRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfCopyRequestResponse(soap, (SRMv2__srmStatusOfCopyRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfPutRequestRequest(soap, (SRMv2__srmStatusOfPutRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfPutRequestResponse(soap, (SRMv2__srmStatusOfPutRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfGetRequestRequest(soap, (SRMv2__srmStatusOfGetRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfGetRequestResponse(soap, (SRMv2__srmStatusOfGetRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestRequest:
		soap_serialize_PointerToSRMv2__srmResumeRequestRequest(soap, (SRMv2__srmResumeRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestResponse:
		soap_serialize_PointerToSRMv2__srmResumeRequestResponse(soap, (SRMv2__srmResumeRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestRequest:
		soap_serialize_PointerToSRMv2__srmSuspendRequestRequest(soap, (SRMv2__srmSuspendRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestResponse:
		soap_serialize_PointerToSRMv2__srmSuspendRequestResponse(soap, (SRMv2__srmSuspendRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesRequest:
		soap_serialize_PointerToSRMv2__srmAbortFilesRequest(soap, (SRMv2__srmAbortFilesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesResponse:
		soap_serialize_PointerToSRMv2__srmAbortFilesResponse(soap, (SRMv2__srmAbortFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestRequest:
		soap_serialize_PointerToSRMv2__srmAbortRequestRequest(soap, (SRMv2__srmAbortRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestResponse:
		soap_serialize_PointerToSRMv2__srmAbortRequestResponse(soap, (SRMv2__srmAbortRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneRequest:
		soap_serialize_PointerToSRMv2__srmPutDoneRequest(soap, (SRMv2__srmPutDoneRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneResponse:
		soap_serialize_PointerToSRMv2__srmPutDoneResponse(soap, (SRMv2__srmPutDoneResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesRequest:
		soap_serialize_PointerToSRMv2__srmReleaseFilesRequest(soap, (SRMv2__srmReleaseFilesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesResponse:
		soap_serialize_PointerToSRMv2__srmReleaseFilesResponse(soap, (SRMv2__srmReleaseFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRemoveFilesRequest:
		soap_serialize_PointerToSRMv2__srmRemoveFilesRequest(soap, (SRMv2__srmRemoveFilesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRemoveFilesResponse:
		soap_serialize_PointerToSRMv2__srmRemoveFilesResponse(soap, (SRMv2__srmRemoveFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCopyRequest:
		soap_serialize_PointerToSRMv2__srmCopyRequest(soap, (SRMv2__srmCopyRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCopyResponse:
		soap_serialize_PointerToSRMv2__srmCopyResponse(soap, (SRMv2__srmCopyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutRequest:
		soap_serialize_PointerToSRMv2__srmPrepareToPutRequest(soap, (SRMv2__srmPrepareToPutRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutResponse:
		soap_serialize_PointerToSRMv2__srmPrepareToPutResponse(soap, (SRMv2__srmPrepareToPutResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetRequest:
		soap_serialize_PointerToSRMv2__srmPrepareToGetRequest(soap, (SRMv2__srmPrepareToGetRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetResponse:
		soap_serialize_PointerToSRMv2__srmPrepareToGetResponse(soap, (SRMv2__srmPrepareToGetResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMvRequest:
		soap_serialize_PointerToSRMv2__srmMvRequest(soap, (SRMv2__srmMvRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMvResponse:
		soap_serialize_PointerToSRMv2__srmMvResponse(soap, (SRMv2__srmMvResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmLsRequest:
		soap_serialize_PointerToSRMv2__srmLsRequest(soap, (SRMv2__srmLsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmLsResponse:
		soap_serialize_PointerToSRMv2__srmLsResponse(soap, (SRMv2__srmLsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmRequest:
		soap_serialize_PointerToSRMv2__srmRmRequest(soap, (SRMv2__srmRmRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmResponse:
		soap_serialize_PointerToSRMv2__srmRmResponse(soap, (SRMv2__srmRmResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmdirRequest:
		soap_serialize_PointerToSRMv2__srmRmdirRequest(soap, (SRMv2__srmRmdirRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmdirResponse:
		soap_serialize_PointerToSRMv2__srmRmdirResponse(soap, (SRMv2__srmRmdirResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMkdirRequest:
		soap_serialize_PointerToSRMv2__srmMkdirRequest(soap, (SRMv2__srmMkdirRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMkdirResponse:
		soap_serialize_PointerToSRMv2__srmMkdirResponse(soap, (SRMv2__srmMkdirResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionRequest:
		soap_serialize_PointerToSRMv2__srmCheckPermissionRequest(soap, (SRMv2__srmCheckPermissionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionResponse:
		soap_serialize_PointerToSRMv2__srmCheckPermissionResponse(soap, (SRMv2__srmCheckPermissionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReassignToUserRequest:
		soap_serialize_PointerToSRMv2__srmReassignToUserRequest(soap, (SRMv2__srmReassignToUserRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReassignToUserResponse:
		soap_serialize_PointerToSRMv2__srmReassignToUserResponse(soap, (SRMv2__srmReassignToUserResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionRequest:
		soap_serialize_PointerToSRMv2__srmSetPermissionRequest(soap, (SRMv2__srmSetPermissionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionResponse:
		soap_serialize_PointerToSRMv2__srmSetPermissionResponse(soap, (SRMv2__srmSetPermissionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokenRequest:
		soap_serialize_PointerToSRMv2__srmGetSpaceTokenRequest(soap, (SRMv2__srmGetSpaceTokenRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokenResponse:
		soap_serialize_PointerToSRMv2__srmGetSpaceTokenResponse(soap, (SRMv2__srmGetSpaceTokenResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmChangeFileStorageTypeRequest:
		soap_serialize_PointerToSRMv2__srmChangeFileStorageTypeRequest(soap, (SRMv2__srmChangeFileStorageTypeRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmChangeFileStorageTypeResponse:
		soap_serialize_PointerToSRMv2__srmChangeFileStorageTypeResponse(soap, (SRMv2__srmChangeFileStorageTypeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataRequest:
		soap_serialize_PointerToSRMv2__srmGetSpaceMetaDataRequest(soap, (SRMv2__srmGetSpaceMetaDataRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataResponse:
		soap_serialize_PointerToSRMv2__srmGetSpaceMetaDataResponse(soap, (SRMv2__srmGetSpaceMetaDataResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCompactSpaceRequest:
		soap_serialize_PointerToSRMv2__srmCompactSpaceRequest(soap, (SRMv2__srmCompactSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCompactSpaceResponse:
		soap_serialize_PointerToSRMv2__srmCompactSpaceResponse(soap, (SRMv2__srmCompactSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceRequest:
		soap_serialize_PointerToSRMv2__srmUpdateSpaceRequest(soap, (SRMv2__srmUpdateSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceResponse:
		soap_serialize_PointerToSRMv2__srmUpdateSpaceResponse(soap, (SRMv2__srmUpdateSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceRequest:
		soap_serialize_PointerToSRMv2__srmReleaseSpaceRequest(soap, (SRMv2__srmReleaseSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceResponse:
		soap_serialize_PointerToSRMv2__srmReleaseSpaceResponse(soap, (SRMv2__srmReleaseSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceRequest:
		soap_serialize_PointerToSRMv2__srmReserveSpaceRequest(soap, (SRMv2__srmReserveSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceResponse:
		soap_serialize_PointerToSRMv2__srmReserveSpaceResponse(soap, (SRMv2__srmReserveSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestSummary:
		soap_serialize_PointerToSRMv2__ArrayOfTRequestSummary(soap, (SRMv2__ArrayOfTRequestSummary *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestToken:
		soap_serialize_PointerToSRMv2__ArrayOfTRequestToken(soap, (SRMv2__ArrayOfTRequestToken *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURL:
		soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, (SRMv2__ArrayOfTSURL *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, (SRMv2__ArrayOfTCopyRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyFileRequest:
		soap_serialize_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, (SRMv2__ArrayOfTCopyFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, (SRMv2__ArrayOfTPutRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutFileRequest:
		soap_serialize_PointerToSRMv2__ArrayOfTPutFileRequest(soap, (SRMv2__ArrayOfTPutFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, (SRMv2__ArrayOfTGetRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring:
		soap_serialize_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, (SRMv2__ArrayOf_USCORExsd_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetFileRequest:
		soap_serialize_PointerToSRMv2__ArrayOfTGetFileRequest(soap, (SRMv2__ArrayOfTGetFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLPermissionReturn:
		soap_serialize_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, (SRMv2__ArrayOfTSURLPermissionReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLReturnStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, (SRMv2__ArrayOfTSURLReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLInfo:
		soap_serialize_PointerToSRMv2__ArrayOfTSURLInfo(soap, (SRMv2__ArrayOfTSURLInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataSpace:
		soap_serialize_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, (SRMv2__ArrayOfTMetaDataSpace *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSpaceToken:
		soap_serialize_PointerToSRMv2__ArrayOfTSpaceToken(soap, (SRMv2__ArrayOfTSpaceToken *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestToken:
		soap_serialize_PointerToPointerToSRMv2__TRequestToken(soap, (SRMv2__TRequestToken **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURL:
		soap_serialize_PointerToPointerToSRMv2__TSURL(soap, (SRMv2__TSURL **const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLPermissionReturn:
		soap_serialize_PointerToPointerToSRMv2__TSURLPermissionReturn(soap, (SRMv2__TSURLPermissionReturn **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURLPermissionReturn:
		soap_serialize_PointerToSRMv2__TSURLPermissionReturn(soap, (SRMv2__TSURLPermissionReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPermissionType:
		soap_serialize_PointerToSRMv2__TPermissionType(soap, (enum SRMv2__TPermissionType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestSummary:
		soap_serialize_PointerToPointerToSRMv2__TRequestSummary(soap, (SRMv2__TRequestSummary **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRequestSummary:
		soap_serialize_PointerToSRMv2__TRequestSummary(soap, (SRMv2__TRequestSummary *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRequestType:
		soap_serialize_PointerToSRMv2__TRequestType(soap, (enum SRMv2__TRequestType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRequestToken:
		soap_serialize_PointerToSRMv2__TRequestToken(soap, (SRMv2__TRequestToken *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TCopyRequestFileStatus(soap, (SRMv2__TCopyRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TCopyRequestFileStatus:
		soap_serialize_PointerToSRMv2__TCopyRequestFileStatus(soap, (SRMv2__TCopyRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TPutRequestFileStatus(soap, (SRMv2__TPutRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPutRequestFileStatus:
		soap_serialize_PointerToSRMv2__TPutRequestFileStatus(soap, (SRMv2__TPutRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TGetRequestFileStatus(soap, (SRMv2__TGetRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGetRequestFileStatus:
		soap_serialize_PointerToSRMv2__TGetRequestFileStatus(soap, (SRMv2__TGetRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TTURL:
		soap_serialize_PointerToSRMv2__TTURL(soap, (SRMv2__TTURL *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLReturnStatus:
		soap_serialize_PointerToPointerToSRMv2__TSURLReturnStatus(soap, (SRMv2__TSURLReturnStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURLReturnStatus:
		soap_serialize_PointerToSRMv2__TSURLReturnStatus(soap, (SRMv2__TSURLReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyFileRequest:
		soap_serialize_PointerToPointerToSRMv2__TCopyFileRequest(soap, (SRMv2__TCopyFileRequest **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TCopyFileRequest:
		soap_serialize_PointerToSRMv2__TCopyFileRequest(soap, (SRMv2__TCopyFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TOverwriteMode:
		soap_serialize_PointerToSRMv2__TOverwriteMode(soap, (enum SRMv2__TOverwriteMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutFileRequest:
		soap_serialize_PointerToPointerToSRMv2__TPutFileRequest(soap, (SRMv2__TPutFileRequest **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPutFileRequest:
		soap_serialize_PointerToSRMv2__TPutFileRequest(soap, (SRMv2__TPutFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetFileRequest:
		soap_serialize_PointerToPointerToSRMv2__TGetFileRequest(soap, (SRMv2__TGetFileRequest **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGetFileRequest:
		soap_serialize_PointerToSRMv2__TGetFileRequest(soap, (SRMv2__TGetFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TDirOption:
		soap_serialize_PointerToSRMv2__TDirOption(soap, (SRMv2__TDirOption *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLInfo:
		soap_serialize_PointerToPointerToSRMv2__TSURLInfo(soap, (SRMv2__TSURLInfo **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURLInfo:
		soap_serialize_PointerToSRMv2__TSURLInfo(soap, (SRMv2__TSURLInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TStorageSystemInfo:
		soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, (SRMv2__TStorageSystemInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTobool:
		soap_serialize_PointerTobool(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataSpace:
		soap_serialize_PointerToPointerToSRMv2__TMetaDataSpace(soap, (SRMv2__TMetaDataSpace **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TMetaDataSpace:
		soap_serialize_PointerToSRMv2__TMetaDataSpace(soap, (SRMv2__TMetaDataSpace *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSpaceType:
		soap_serialize_PointerToSRMv2__TSpaceType(soap, (enum SRMv2__TSpaceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataPathDetail:
		soap_serialize_PointerToPointerToSRMv2__TMetaDataPathDetail(soap, (SRMv2__TMetaDataPathDetail **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TMetaDataPathDetail:
		soap_serialize_PointerToSRMv2__TMetaDataPathDetail(soap, (SRMv2__TMetaDataPathDetail *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataPathDetail:
		soap_serialize_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, (SRMv2__ArrayOfTMetaDataPathDetail *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURL:
		soap_serialize_PointerToSRMv2__TSURL(soap, (SRMv2__TSURL *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TCheckSumValue:
		soap_serialize_PointerToSRMv2__TCheckSumValue(soap, (SRMv2__TCheckSumValue *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TCheckSumType:
		soap_serialize_PointerToSRMv2__TCheckSumType(soap, (SRMv2__TCheckSumType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TLifeTimeInSeconds:
		soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, (SRMv2__TLifeTimeInSeconds *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TFileType:
		soap_serialize_PointerToSRMv2__TFileType(soap, (enum SRMv2__TFileType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TFileStorageType:
		soap_serialize_PointerToSRMv2__TFileStorageType(soap, (enum SRMv2__TFileStorageType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGMTTime:
		soap_serialize_PointerToSRMv2__TGMTTime(soap, (SRMv2__TGMTTime *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TOtherPermission:
		soap_serialize_PointerToSRMv2__TOtherPermission(soap, (SRMv2__TOtherPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGroupPermission:
		soap_serialize_PointerToSRMv2__ArrayOfTGroupPermission(soap, (SRMv2__ArrayOfTGroupPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTUserPermission:
		soap_serialize_PointerToSRMv2__ArrayOfTUserPermission(soap, (SRMv2__ArrayOfTUserPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TOwnerPermission:
		soap_serialize_PointerToSRMv2__TOwnerPermission(soap, (SRMv2__TOwnerPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSizeInBytes:
		soap_serialize_PointerToSRMv2__TSizeInBytes(soap, (SRMv2__TSizeInBytes *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TReturnStatus:
		soap_serialize_PointerToSRMv2__TReturnStatus(soap, (SRMv2__TReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TGroupPermission:
		soap_serialize_PointerToPointerToSRMv2__TGroupPermission(soap, (SRMv2__TGroupPermission **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGroupPermission:
		soap_serialize_PointerToSRMv2__TGroupPermission(soap, (SRMv2__TGroupPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGroupID:
		soap_serialize_PointerToSRMv2__TGroupID(soap, (SRMv2__TGroupID *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TUserPermission:
		soap_serialize_PointerToPointerToSRMv2__TUserPermission(soap, (SRMv2__TUserPermission **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TUserPermission:
		soap_serialize_PointerToSRMv2__TUserPermission(soap, (SRMv2__TUserPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TUserID:
		soap_serialize_PointerToSRMv2__TUserID(soap, (SRMv2__TUserID *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSpaceToken:
		soap_serialize_PointerToPointerToSRMv2__TSpaceToken(soap, (SRMv2__TSpaceToken **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSpaceToken:
		soap_serialize_PointerToSRMv2__TSpaceToken(soap, (SRMv2__TSpaceToken *const*)ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_SRMv2__TRequestToken:
		return (void*)soap_instantiate_SRMv2__TRequestToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSpaceToken:
		return (void*)soap_instantiate_SRMv2__TSpaceToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSpaceToken:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSpaceToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TUserID:
		return (void*)soap_instantiate_SRMv2__TUserID(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGroupID:
		return (void*)soap_instantiate_SRMv2__TGroupID(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TOwnerPermission:
		return (void*)soap_instantiate_SRMv2__TOwnerPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TUserPermission:
		return (void*)soap_instantiate_SRMv2__TUserPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		return (void*)soap_instantiate_SRMv2__ArrayOfTUserPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGroupPermission:
		return (void*)soap_instantiate_SRMv2__TGroupPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		return (void*)soap_instantiate_SRMv2__ArrayOfTGroupPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TOtherPermission:
		return (void*)soap_instantiate_SRMv2__TOtherPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TCheckSumType:
		return (void*)soap_instantiate_SRMv2__TCheckSumType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TCheckSumValue:
		return (void*)soap_instantiate_SRMv2__TCheckSumValue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSizeInBytes:
		return (void*)soap_instantiate_SRMv2__TSizeInBytes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGMTTime:
		return (void*)soap_instantiate_SRMv2__TGMTTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TLifeTimeInSeconds:
		return (void*)soap_instantiate_SRMv2__TLifeTimeInSeconds(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURL:
		return (void*)soap_instantiate_SRMv2__TSURL(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TTURL:
		return (void*)soap_instantiate_SRMv2__TTURL(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		return (void*)soap_instantiate_SRMv2__TMetaDataPathDetail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		return (void*)soap_instantiate_SRMv2__ArrayOfTMetaDataPathDetail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		return (void*)soap_instantiate_SRMv2__TMetaDataSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		return (void*)soap_instantiate_SRMv2__ArrayOfTMetaDataSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TStorageSystemInfo:
		return (void*)soap_instantiate_SRMv2__TStorageSystemInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TDirOption:
		return (void*)soap_instantiate_SRMv2__TDirOption(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURLInfo:
		return (void*)soap_instantiate_SRMv2__TSURLInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURLInfo:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURLInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		return (void*)soap_instantiate_SRMv2__TGetFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		return (void*)soap_instantiate_SRMv2__ArrayOfTGetFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		return (void*)soap_instantiate_SRMv2__TPutFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		return (void*)soap_instantiate_SRMv2__ArrayOfTPutFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		return (void*)soap_instantiate_SRMv2__TCopyFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		return (void*)soap_instantiate_SRMv2__ArrayOfTCopyFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TReturnStatus:
		return (void*)soap_instantiate_SRMv2__TReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		return (void*)soap_instantiate_SRMv2__TSURLReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURLReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TGetRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTGetRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TPutRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTPutRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TCopyRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TRequestSummary:
		return (void*)soap_instantiate_SRMv2__TRequestSummary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		return (void*)soap_instantiate_SRMv2__ArrayOfTRequestSummary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		return (void*)soap_instantiate_SRMv2__TSURLPermissionReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring:
		return (void*)soap_instantiate_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURL:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURL(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTRequestToken:
		return (void*)soap_instantiate_SRMv2__ArrayOfTRequestToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		return (void*)soap_instantiate_SRMv2__TRequestTokenReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmReserveSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmReserveSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCompactSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmCompactSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmCompactSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest:
		return (void*)soap_instantiate_SRMv2__srmChangeFileStorageTypeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse:
		return (void*)soap_instantiate_SRMv2__srmChangeFileStorageTypeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokenRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokenResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		return (void*)soap_instantiate_SRMv2__srmSetPermissionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		return (void*)soap_instantiate_SRMv2__srmSetPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReassignToUserRequest:
		return (void*)soap_instantiate_SRMv2__srmReassignToUserRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse:
		return (void*)soap_instantiate_SRMv2__srmReassignToUserResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		return (void*)soap_instantiate_SRMv2__srmCheckPermissionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		return (void*)soap_instantiate_SRMv2__srmCheckPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		return (void*)soap_instantiate_SRMv2__srmMkdirRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		return (void*)soap_instantiate_SRMv2__srmMkdirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		return (void*)soap_instantiate_SRMv2__srmRmdirRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		return (void*)soap_instantiate_SRMv2__srmRmdirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmRequest:
		return (void*)soap_instantiate_SRMv2__srmRmRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmResponse:
		return (void*)soap_instantiate_SRMv2__srmRmResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLsRequest:
		return (void*)soap_instantiate_SRMv2__srmLsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLsResponse:
		return (void*)soap_instantiate_SRMv2__srmLsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMvRequest:
		return (void*)soap_instantiate_SRMv2__srmMvRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMvResponse:
		return (void*)soap_instantiate_SRMv2__srmMvResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGetRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGetResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPutRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPutResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		return (void*)soap_instantiate_SRMv2__srmCopyRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		return (void*)soap_instantiate_SRMv2__srmCopyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRemoveFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmRemoveFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse:
		return (void*)soap_instantiate_SRMv2__srmRemoveFilesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmReleaseFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		return (void*)soap_instantiate_SRMv2__srmReleaseFilesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		return (void*)soap_instantiate_SRMv2__srmPutDoneRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		return (void*)soap_instantiate_SRMv2__srmPutDoneResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmAbortRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmAbortRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmAbortFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		return (void*)soap_instantiate_SRMv2__srmAbortFilesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmResumeRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmResumeRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummaryRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummaryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestIDRequest:
		return (void*)soap_instantiate_SRMv2__srmGetRequestIDRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse:
		return (void*)soap_instantiate_SRMv2__srmGetRequestIDResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmReserveSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		return (void*)soap_instantiate_SRMv2__srmReserveSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmCompactSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCompactSpace:
		return (void*)soap_instantiate_SRMv2__srmCompactSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse_:
		return (void*)soap_instantiate_SRMv2__srmChangeFileStorageTypeResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeFileStorageType:
		return (void*)soap_instantiate_SRMv2__srmChangeFileStorageType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokenResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceToken:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		return (void*)soap_instantiate_SRMv2__srmSetPermissionResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermission:
		return (void*)soap_instantiate_SRMv2__srmSetPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse_:
		return (void*)soap_instantiate_SRMv2__srmReassignToUserResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReassignToUser:
		return (void*)soap_instantiate_SRMv2__srmReassignToUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		return (void*)soap_instantiate_SRMv2__srmCheckPermissionResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		return (void*)soap_instantiate_SRMv2__srmCheckPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		return (void*)soap_instantiate_SRMv2__srmMkdirResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdir:
		return (void*)soap_instantiate_SRMv2__srmMkdir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		return (void*)soap_instantiate_SRMv2__srmRmdirResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdir:
		return (void*)soap_instantiate_SRMv2__srmRmdir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		return (void*)soap_instantiate_SRMv2__srmRmResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRm:
		return (void*)soap_instantiate_SRMv2__srmRm(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		return (void*)soap_instantiate_SRMv2__srmLsResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLs:
		return (void*)soap_instantiate_SRMv2__srmLs(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		return (void*)soap_instantiate_SRMv2__srmMvResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMv:
		return (void*)soap_instantiate_SRMv2__srmMv(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGetResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGet(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPutResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPut(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		return (void*)soap_instantiate_SRMv2__srmCopyResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopy:
		return (void*)soap_instantiate_SRMv2__srmCopy(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse_:
		return (void*)soap_instantiate_SRMv2__srmRemoveFilesResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRemoveFiles:
		return (void*)soap_instantiate_SRMv2__srmRemoveFiles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		return (void*)soap_instantiate_SRMv2__srmReleaseFilesResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		return (void*)soap_instantiate_SRMv2__srmReleaseFiles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		return (void*)soap_instantiate_SRMv2__srmPutDoneResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDone:
		return (void*)soap_instantiate_SRMv2__srmPutDone(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmAbortRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		return (void*)soap_instantiate_SRMv2__srmAbortRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		return (void*)soap_instantiate_SRMv2__srmAbortFilesResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		return (void*)soap_instantiate_SRMv2__srmAbortFiles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmResumeRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		return (void*)soap_instantiate_SRMv2__srmResumeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummaryResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetRequestIDResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestID:
		return (void*)soap_instantiate_SRMv2__srmGetRequestID(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_SRMv2__TRequestToken:
		if (p->size < 0)
			delete (SRMv2__TRequestToken*)p->ptr;
		else
			delete[] (SRMv2__TRequestToken*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSpaceToken:
		if (p->size < 0)
			delete (SRMv2__TSpaceToken*)p->ptr;
		else
			delete[] (SRMv2__TSpaceToken*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSpaceToken:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSpaceToken*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSpaceToken*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TUserID:
		if (p->size < 0)
			delete (SRMv2__TUserID*)p->ptr;
		else
			delete[] (SRMv2__TUserID*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGroupID:
		if (p->size < 0)
			delete (SRMv2__TGroupID*)p->ptr;
		else
			delete[] (SRMv2__TGroupID*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TOwnerPermission:
		if (p->size < 0)
			delete (SRMv2__TOwnerPermission*)p->ptr;
		else
			delete[] (SRMv2__TOwnerPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TUserPermission:
		if (p->size < 0)
			delete (SRMv2__TUserPermission*)p->ptr;
		else
			delete[] (SRMv2__TUserPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTUserPermission*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTUserPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGroupPermission:
		if (p->size < 0)
			delete (SRMv2__TGroupPermission*)p->ptr;
		else
			delete[] (SRMv2__TGroupPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTGroupPermission*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTGroupPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TOtherPermission:
		if (p->size < 0)
			delete (SRMv2__TOtherPermission*)p->ptr;
		else
			delete[] (SRMv2__TOtherPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TCheckSumType:
		if (p->size < 0)
			delete (SRMv2__TCheckSumType*)p->ptr;
		else
			delete[] (SRMv2__TCheckSumType*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TCheckSumValue:
		if (p->size < 0)
			delete (SRMv2__TCheckSumValue*)p->ptr;
		else
			delete[] (SRMv2__TCheckSumValue*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSizeInBytes:
		if (p->size < 0)
			delete (SRMv2__TSizeInBytes*)p->ptr;
		else
			delete[] (SRMv2__TSizeInBytes*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGMTTime:
		if (p->size < 0)
			delete (SRMv2__TGMTTime*)p->ptr;
		else
			delete[] (SRMv2__TGMTTime*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TLifeTimeInSeconds:
		if (p->size < 0)
			delete (SRMv2__TLifeTimeInSeconds*)p->ptr;
		else
			delete[] (SRMv2__TLifeTimeInSeconds*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURL:
		if (p->size < 0)
			delete (SRMv2__TSURL*)p->ptr;
		else
			delete[] (SRMv2__TSURL*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TTURL:
		if (p->size < 0)
			delete (SRMv2__TTURL*)p->ptr;
		else
			delete[] (SRMv2__TTURL*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		if (p->size < 0)
			delete (SRMv2__TMetaDataPathDetail*)p->ptr;
		else
			delete[] (SRMv2__TMetaDataPathDetail*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTMetaDataPathDetail*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTMetaDataPathDetail*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		if (p->size < 0)
			delete (SRMv2__TMetaDataSpace*)p->ptr;
		else
			delete[] (SRMv2__TMetaDataSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTMetaDataSpace*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTMetaDataSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TStorageSystemInfo:
		if (p->size < 0)
			delete (SRMv2__TStorageSystemInfo*)p->ptr;
		else
			delete[] (SRMv2__TStorageSystemInfo*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TDirOption:
		if (p->size < 0)
			delete (SRMv2__TDirOption*)p->ptr;
		else
			delete[] (SRMv2__TDirOption*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURLInfo:
		if (p->size < 0)
			delete (SRMv2__TSURLInfo*)p->ptr;
		else
			delete[] (SRMv2__TSURLInfo*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLInfo:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURLInfo*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURLInfo*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		if (p->size < 0)
			delete (SRMv2__TGetFileRequest*)p->ptr;
		else
			delete[] (SRMv2__TGetFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTGetFileRequest*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTGetFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		if (p->size < 0)
			delete (SRMv2__TPutFileRequest*)p->ptr;
		else
			delete[] (SRMv2__TPutFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTPutFileRequest*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTPutFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		if (p->size < 0)
			delete (SRMv2__TCopyFileRequest*)p->ptr;
		else
			delete[] (SRMv2__TCopyFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTCopyFileRequest*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTCopyFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TReturnStatus:
		if (p->size < 0)
			delete (SRMv2__TReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__TReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		if (p->size < 0)
			delete (SRMv2__TSURLReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__TSURLReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURLReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURLReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TGetRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TGetRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTGetRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTGetRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TPutRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TPutRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTPutRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTPutRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TCopyRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TCopyRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTCopyRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTCopyRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TRequestSummary:
		if (p->size < 0)
			delete (SRMv2__TRequestSummary*)p->ptr;
		else
			delete[] (SRMv2__TRequestSummary*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTRequestSummary*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTRequestSummary*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		if (p->size < 0)
			delete (SRMv2__TSURLPermissionReturn*)p->ptr;
		else
			delete[] (SRMv2__TSURLPermissionReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURLPermissionReturn*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURLPermissionReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring:
		if (p->size < 0)
			delete (SRMv2__ArrayOf_USCORExsd_USCOREstring*)p->ptr;
		else
			delete[] (SRMv2__ArrayOf_USCORExsd_USCOREstring*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURL:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURL*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURL*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestToken:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTRequestToken*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTRequestToken*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		if (p->size < 0)
			delete (SRMv2__TRequestTokenReturn*)p->ptr;
		else
			delete[] (SRMv2__TRequestTokenReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmReserveSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReserveSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmReserveSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReserveSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmReleaseSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmReleaseSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmUpdateSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmUpdateSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmUpdateSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmUpdateSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmCompactSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmCompactSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmCompactSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmCompactSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceMetaDataRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceMetaDataRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceMetaDataResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceMetaDataResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest:
		if (p->size < 0)
			delete (SRMv2__srmChangeFileStorageTypeRequest*)p->ptr;
		else
			delete[] (SRMv2__srmChangeFileStorageTypeRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse:
		if (p->size < 0)
			delete (SRMv2__srmChangeFileStorageTypeResponse*)p->ptr;
		else
			delete[] (SRMv2__srmChangeFileStorageTypeResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceTokenRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceTokenRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceTokenResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceTokenResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		if (p->size < 0)
			delete (SRMv2__srmSetPermissionRequest*)p->ptr;
		else
			delete[] (SRMv2__srmSetPermissionRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		if (p->size < 0)
			delete (SRMv2__srmSetPermissionResponse*)p->ptr;
		else
			delete[] (SRMv2__srmSetPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUserRequest:
		if (p->size < 0)
			delete (SRMv2__srmReassignToUserRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReassignToUserRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse:
		if (p->size < 0)
			delete (SRMv2__srmReassignToUserResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReassignToUserResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		if (p->size < 0)
			delete (SRMv2__srmCheckPermissionRequest*)p->ptr;
		else
			delete[] (SRMv2__srmCheckPermissionRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		if (p->size < 0)
			delete (SRMv2__srmCheckPermissionResponse*)p->ptr;
		else
			delete[] (SRMv2__srmCheckPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		if (p->size < 0)
			delete (SRMv2__srmMkdirRequest*)p->ptr;
		else
			delete[] (SRMv2__srmMkdirRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		if (p->size < 0)
			delete (SRMv2__srmMkdirResponse*)p->ptr;
		else
			delete[] (SRMv2__srmMkdirResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		if (p->size < 0)
			delete (SRMv2__srmRmdirRequest*)p->ptr;
		else
			delete[] (SRMv2__srmRmdirRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		if (p->size < 0)
			delete (SRMv2__srmRmdirResponse*)p->ptr;
		else
			delete[] (SRMv2__srmRmdirResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmRequest:
		if (p->size < 0)
			delete (SRMv2__srmRmRequest*)p->ptr;
		else
			delete[] (SRMv2__srmRmRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse:
		if (p->size < 0)
			delete (SRMv2__srmRmResponse*)p->ptr;
		else
			delete[] (SRMv2__srmRmResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLsRequest:
		if (p->size < 0)
			delete (SRMv2__srmLsRequest*)p->ptr;
		else
			delete[] (SRMv2__srmLsRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse:
		if (p->size < 0)
			delete (SRMv2__srmLsResponse*)p->ptr;
		else
			delete[] (SRMv2__srmLsResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMvRequest:
		if (p->size < 0)
			delete (SRMv2__srmMvRequest*)p->ptr;
		else
			delete[] (SRMv2__srmMvRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse:
		if (p->size < 0)
			delete (SRMv2__srmMvResponse*)p->ptr;
		else
			delete[] (SRMv2__srmMvResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToGetRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToGetRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToGetResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToGetResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToPutRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToPutRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToPutResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToPutResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		if (p->size < 0)
			delete (SRMv2__srmCopyRequest*)p->ptr;
		else
			delete[] (SRMv2__srmCopyRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		if (p->size < 0)
			delete (SRMv2__srmCopyResponse*)p->ptr;
		else
			delete[] (SRMv2__srmCopyResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFilesRequest:
		if (p->size < 0)
			delete (SRMv2__srmRemoveFilesRequest*)p->ptr;
		else
			delete[] (SRMv2__srmRemoveFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse:
		if (p->size < 0)
			delete (SRMv2__srmRemoveFilesResponse*)p->ptr;
		else
			delete[] (SRMv2__srmRemoveFilesResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		if (p->size < 0)
			delete (SRMv2__srmReleaseFilesRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		if (p->size < 0)
			delete (SRMv2__srmReleaseFilesResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseFilesResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		if (p->size < 0)
			delete (SRMv2__srmPutDoneRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPutDoneRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		if (p->size < 0)
			delete (SRMv2__srmPutDoneResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPutDoneResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmAbortRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmAbortRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmAbortRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmAbortRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		if (p->size < 0)
			delete (SRMv2__srmAbortFilesRequest*)p->ptr;
		else
			delete[] (SRMv2__srmAbortFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		if (p->size < 0)
			delete (SRMv2__srmAbortFilesResponse*)p->ptr;
		else
			delete[] (SRMv2__srmAbortFilesResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmSuspendRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmSuspendRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmSuspendRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmSuspendRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmResumeRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmResumeRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmResumeRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmResumeRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfGetRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfGetRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfGetRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfGetRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfPutRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfPutRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfPutRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfPutRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfCopyRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfCopyRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfCopyRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfCopyRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestSummaryRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestSummaryRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestSummaryResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestSummaryResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		if (p->size < 0)
			delete (SRMv2__srmExtendFileLifeTimeRequest*)p->ptr;
		else
			delete[] (SRMv2__srmExtendFileLifeTimeRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		if (p->size < 0)
			delete (SRMv2__srmExtendFileLifeTimeResponse*)p->ptr;
		else
			delete[] (SRMv2__srmExtendFileLifeTimeResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestIDRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestIDRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestIDRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestIDResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestIDResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReserveSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReserveSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmReserveSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmReserveSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmUpdateSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmUpdateSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmUpdateSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmUpdateSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmCompactSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmCompactSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCompactSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmCompactSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmCompactSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceMetaDataResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceMetaDataResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceMetaData*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceMetaData*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmChangeFileStorageTypeResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmChangeFileStorageTypeResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeFileStorageType:
		if (p->size < 0)
			delete (struct SRMv2__srmChangeFileStorageType*)p->ptr;
		else
			delete[] (struct SRMv2__srmChangeFileStorageType*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceTokenResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceTokenResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceToken:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceToken*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceToken*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmSetPermissionResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmSetPermissionResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermission:
		if (p->size < 0)
			delete (struct SRMv2__srmSetPermission*)p->ptr;
		else
			delete[] (struct SRMv2__srmSetPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUserResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReassignToUserResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReassignToUserResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReassignToUser:
		if (p->size < 0)
			delete (struct SRMv2__srmReassignToUser*)p->ptr;
		else
			delete[] (struct SRMv2__srmReassignToUser*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmCheckPermissionResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmCheckPermissionResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		if (p->size < 0)
			delete (struct SRMv2__srmCheckPermission*)p->ptr;
		else
			delete[] (struct SRMv2__srmCheckPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmMkdirResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmMkdirResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdir:
		if (p->size < 0)
			delete (struct SRMv2__srmMkdir*)p->ptr;
		else
			delete[] (struct SRMv2__srmMkdir*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmRmdirResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmRmdirResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdir:
		if (p->size < 0)
			delete (struct SRMv2__srmRmdir*)p->ptr;
		else
			delete[] (struct SRMv2__srmRmdir*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmRmResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmRmResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRm:
		if (p->size < 0)
			delete (struct SRMv2__srmRm*)p->ptr;
		else
			delete[] (struct SRMv2__srmRm*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmLsResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmLsResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLs:
		if (p->size < 0)
			delete (struct SRMv2__srmLs*)p->ptr;
		else
			delete[] (struct SRMv2__srmLs*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmMvResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmMvResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMv:
		if (p->size < 0)
			delete (struct SRMv2__srmMv*)p->ptr;
		else
			delete[] (struct SRMv2__srmMv*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToGetResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToGetResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToGet*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToGet*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToPutResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToPutResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToPut*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToPut*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmCopyResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmCopyResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopy:
		if (p->size < 0)
			delete (struct SRMv2__srmCopy*)p->ptr;
		else
			delete[] (struct SRMv2__srmCopy*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFilesResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmRemoveFilesResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmRemoveFilesResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRemoveFiles:
		if (p->size < 0)
			delete (struct SRMv2__srmRemoveFiles*)p->ptr;
		else
			delete[] (struct SRMv2__srmRemoveFiles*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseFilesResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseFilesResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseFiles*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseFiles*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPutDoneResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPutDoneResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDone:
		if (p->size < 0)
			delete (struct SRMv2__srmPutDone*)p->ptr;
		else
			delete[] (struct SRMv2__srmPutDone*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortFilesResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortFilesResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortFiles*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortFiles*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmSuspendRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmSuspendRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmSuspendRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmSuspendRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmResumeRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmResumeRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmResumeRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmResumeRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfGetRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfGetRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfGetRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfGetRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfPutRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfPutRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfPutRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfPutRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfCopyRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfCopyRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfCopyRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfCopyRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestSummaryResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestSummaryResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestSummary*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestSummary*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmExtendFileLifeTimeResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmExtendFileLifeTimeResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		if (p->size < 0)
			delete (struct SRMv2__srmExtendFileLifeTime*)p->ptr;
		else
			delete[] (struct SRMv2__srmExtendFileLifeTime*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestIDResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestIDResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestIDResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestID:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestID*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestID*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_code_str(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TStatusCode(struct soap *soap, enum SRMv2__TStatusCode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TStatusCode
	*a = SOAP_DEFAULT_SRMv2__TStatusCode;
#else
	*a = (enum SRMv2__TStatusCode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TStatusCode(struct soap *soap, const enum SRMv2__TStatusCode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TStatusCode);
	if (soap_out_SRMv2__TStatusCode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TStatusCode[] =
{	{ (long)SRMv2__TStatusCode__SRM_USCORESUCCESS, "SRM_SUCCESS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFAILURE, "SRM_FAILURE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREAUTHENTICATION_USCOREFAILURE, "SRM_AUTHENTICATION_FAILURE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREUNAUATHORIZED_USCOREACCESS, "SRM_UNAUATHORIZED_ACCESS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREINVALID_USCOREREQUEST, "SRM_INVALID_REQUEST" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREINVALID_USCOREPATH, "SRM_INVALID_PATH" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCORELIFETIME_USCOREEXPIRED, "SRM_FILE_LIFETIME_EXPIRED" },
	{ (long)SRMv2__TStatusCode__SRM_USCORESPACE_USCORELIFETIME_USCOREEXPIRED, "SRM_SPACE_LIFETIME_EXPIRED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREEXCEED_USCOREALLOCATION, "SRM_EXCEED_ALLOCATION" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENO_USCOREUSER_USCORESPACE, "SRM_NO_USER_SPACE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENO_USCOREFREE_USCORESPACE, "SRM_NO_FREE_SPACE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREDUPLICATION_USCOREERROR, "SRM_DUPLICATION_ERROR" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENON_USCOREEMPTY_USCOREDIRECTORY, "SRM_NON_EMPTY_DIRECTORY" },
	{ (long)SRMv2__TStatusCode__SRM_USCORETOO_USCOREMANY_USCORERESULTS, "SRM_TOO_MANY_RESULTS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREINTERNAL_USCOREERROR, "SRM_INTERNAL_ERROR" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFATAL_USCOREINTERNAL_USCOREERROR, "SRM_FATAL_INTERNAL_ERROR" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED, "SRM_NOT_SUPPORTED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCOREQUEUED, "SRM_REQUEST_QUEUED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCOREINPROGRESS, "SRM_REQUEST_INPROGRESS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCORESUSPENDED, "SRM_REQUEST_SUSPENDED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREABORTED, "SRM_ABORTED" },
	{ (long)SRMv2__TStatusCode__SRM_USCORERELEASED, "SRM_RELEASED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCOREPINNED, "SRM_FILE_PINNED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCOREIN_USCORECACHE, "SRM_FILE_IN_CACHE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORESPACE_USCOREAVAILABLE, "SRM_SPACE_AVAILABLE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORELOWER_USCORESPACE_USCOREGRANTED, "SRM_LOWER_SPACE_GRANTED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREDONE, "SRM_DONE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORECUSTOM_USCORESTATUS, "SRM_CUSTOM_STATUS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TStatusCode2s(struct soap *soap, enum SRMv2__TStatusCode n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TStatusCode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TStatusCode(struct soap *soap, const char *tag, int id, const enum SRMv2__TStatusCode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TStatusCode), type);
	soap_send(soap, soap_SRMv2__TStatusCode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TStatusCode * SOAP_FMAC4 soap_get_SRMv2__TStatusCode(struct soap *soap, enum SRMv2__TStatusCode *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TStatusCode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TStatusCode(struct soap *soap, const char *s, enum SRMv2__TStatusCode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TStatusCode, s);
	if (map)
		*a = (enum SRMv2__TStatusCode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 27)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TStatusCode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TStatusCode * SOAP_FMAC4 soap_in_SRMv2__TStatusCode(struct soap *soap, const char *tag, enum SRMv2__TStatusCode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TStatusCode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TStatusCode, sizeof(enum SRMv2__TStatusCode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TStatusCode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TStatusCode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TStatusCode, 0, sizeof(enum SRMv2__TStatusCode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TOverwriteMode(struct soap *soap, enum SRMv2__TOverwriteMode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TOverwriteMode
	*a = SOAP_DEFAULT_SRMv2__TOverwriteMode;
#else
	*a = (enum SRMv2__TOverwriteMode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TOverwriteMode(struct soap *soap, const enum SRMv2__TOverwriteMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TOverwriteMode);
	if (soap_out_SRMv2__TOverwriteMode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TOverwriteMode[] =
{	{ (long)SRMv2__TOverwriteMode__Never, "Never" },
	{ (long)SRMv2__TOverwriteMode__Always, "Always" },
	{ (long)SRMv2__TOverwriteMode__WhenFilesAreDifferent, "WhenFilesAreDifferent" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TOverwriteMode2s(struct soap *soap, enum SRMv2__TOverwriteMode n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TOverwriteMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TOverwriteMode(struct soap *soap, const char *tag, int id, const enum SRMv2__TOverwriteMode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TOverwriteMode), type);
	soap_send(soap, soap_SRMv2__TOverwriteMode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TOverwriteMode * SOAP_FMAC4 soap_get_SRMv2__TOverwriteMode(struct soap *soap, enum SRMv2__TOverwriteMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TOverwriteMode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TOverwriteMode(struct soap *soap, const char *s, enum SRMv2__TOverwriteMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TOverwriteMode, s);
	if (map)
		*a = (enum SRMv2__TOverwriteMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TOverwriteMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TOverwriteMode * SOAP_FMAC4 soap_in_SRMv2__TOverwriteMode(struct soap *soap, const char *tag, enum SRMv2__TOverwriteMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TOverwriteMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TOverwriteMode, sizeof(enum SRMv2__TOverwriteMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TOverwriteMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TOverwriteMode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TOverwriteMode, 0, sizeof(enum SRMv2__TOverwriteMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TRequestType(struct soap *soap, enum SRMv2__TRequestType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TRequestType
	*a = SOAP_DEFAULT_SRMv2__TRequestType;
#else
	*a = (enum SRMv2__TRequestType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TRequestType(struct soap *soap, const enum SRMv2__TRequestType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TRequestType);
	if (soap_out_SRMv2__TRequestType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TRequestType[] =
{	{ (long)SRMv2__TRequestType__PrepareToGet, "PrepareToGet" },
	{ (long)SRMv2__TRequestType__PrepareToPut, "PrepareToPut" },
	{ (long)SRMv2__TRequestType__Copy, "Copy" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TRequestType2s(struct soap *soap, enum SRMv2__TRequestType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TRequestType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRequestType(struct soap *soap, const char *tag, int id, const enum SRMv2__TRequestType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRequestType), type);
	soap_send(soap, soap_SRMv2__TRequestType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TRequestType * SOAP_FMAC4 soap_get_SRMv2__TRequestType(struct soap *soap, enum SRMv2__TRequestType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRequestType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TRequestType(struct soap *soap, const char *s, enum SRMv2__TRequestType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TRequestType, s);
	if (map)
		*a = (enum SRMv2__TRequestType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TRequestType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TRequestType * SOAP_FMAC4 soap_in_SRMv2__TRequestType(struct soap *soap, const char *tag, enum SRMv2__TRequestType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TRequestType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRequestType, sizeof(enum SRMv2__TRequestType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TRequestType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TRequestType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRequestType, 0, sizeof(enum SRMv2__TRequestType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TPermissionType(struct soap *soap, enum SRMv2__TPermissionType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TPermissionType
	*a = SOAP_DEFAULT_SRMv2__TPermissionType;
#else
	*a = (enum SRMv2__TPermissionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TPermissionType(struct soap *soap, const enum SRMv2__TPermissionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TPermissionType);
	if (soap_out_SRMv2__TPermissionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TPermissionType[] =
{	{ (long)SRMv2__TPermissionType__ADD, "ADD" },
	{ (long)SRMv2__TPermissionType__REMOVE, "REMOVE" },
	{ (long)SRMv2__TPermissionType__CHANGE, "CHANGE" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TPermissionType2s(struct soap *soap, enum SRMv2__TPermissionType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TPermissionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPermissionType(struct soap *soap, const char *tag, int id, const enum SRMv2__TPermissionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPermissionType), type);
	soap_send(soap, soap_SRMv2__TPermissionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TPermissionType * SOAP_FMAC4 soap_get_SRMv2__TPermissionType(struct soap *soap, enum SRMv2__TPermissionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPermissionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TPermissionType(struct soap *soap, const char *s, enum SRMv2__TPermissionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TPermissionType, s);
	if (map)
		*a = (enum SRMv2__TPermissionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TPermissionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TPermissionType * SOAP_FMAC4 soap_in_SRMv2__TPermissionType(struct soap *soap, const char *tag, enum SRMv2__TPermissionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TPermissionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPermissionType, sizeof(enum SRMv2__TPermissionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TPermissionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TPermissionType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPermissionType, 0, sizeof(enum SRMv2__TPermissionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TPermissionMode(struct soap *soap, enum SRMv2__TPermissionMode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TPermissionMode
	*a = SOAP_DEFAULT_SRMv2__TPermissionMode;
#else
	*a = (enum SRMv2__TPermissionMode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TPermissionMode(struct soap *soap, const enum SRMv2__TPermissionMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TPermissionMode);
	if (soap_out_SRMv2__TPermissionMode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TPermissionMode[] =
{	{ (long)SRMv2__TPermissionMode__None, "None" },
	{ (long)SRMv2__TPermissionMode__X, "X" },
	{ (long)SRMv2__TPermissionMode__W, "W" },
	{ (long)SRMv2__TPermissionMode__WX, "WX" },
	{ (long)SRMv2__TPermissionMode__R, "R" },
	{ (long)SRMv2__TPermissionMode__RX, "RX" },
	{ (long)SRMv2__TPermissionMode__RW, "RW" },
	{ (long)SRMv2__TPermissionMode__RWX, "RWX" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TPermissionMode2s(struct soap *soap, enum SRMv2__TPermissionMode n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TPermissionMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPermissionMode(struct soap *soap, const char *tag, int id, const enum SRMv2__TPermissionMode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPermissionMode), type);
	soap_send(soap, soap_SRMv2__TPermissionMode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TPermissionMode * SOAP_FMAC4 soap_get_SRMv2__TPermissionMode(struct soap *soap, enum SRMv2__TPermissionMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPermissionMode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TPermissionMode(struct soap *soap, const char *s, enum SRMv2__TPermissionMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TPermissionMode, s);
	if (map)
		*a = (enum SRMv2__TPermissionMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 7)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TPermissionMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TPermissionMode * SOAP_FMAC4 soap_in_SRMv2__TPermissionMode(struct soap *soap, const char *tag, enum SRMv2__TPermissionMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TPermissionMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPermissionMode, sizeof(enum SRMv2__TPermissionMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TPermissionMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TPermissionMode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPermissionMode, 0, sizeof(enum SRMv2__TPermissionMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TFileType(struct soap *soap, enum SRMv2__TFileType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TFileType
	*a = SOAP_DEFAULT_SRMv2__TFileType;
#else
	*a = (enum SRMv2__TFileType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TFileType(struct soap *soap, const enum SRMv2__TFileType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TFileType);
	if (soap_out_SRMv2__TFileType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TFileType[] =
{	{ (long)SRMv2__TFileType__File, "File" },
	{ (long)SRMv2__TFileType__Directory, "Directory" },
	{ (long)SRMv2__TFileType__Link, "Link" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TFileType2s(struct soap *soap, enum SRMv2__TFileType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TFileType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TFileType(struct soap *soap, const char *tag, int id, const enum SRMv2__TFileType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TFileType), type);
	soap_send(soap, soap_SRMv2__TFileType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TFileType * SOAP_FMAC4 soap_get_SRMv2__TFileType(struct soap *soap, enum SRMv2__TFileType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TFileType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TFileType(struct soap *soap, const char *s, enum SRMv2__TFileType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TFileType, s);
	if (map)
		*a = (enum SRMv2__TFileType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TFileType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TFileType * SOAP_FMAC4 soap_in_SRMv2__TFileType(struct soap *soap, const char *tag, enum SRMv2__TFileType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TFileType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TFileType, sizeof(enum SRMv2__TFileType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TFileType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TFileType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TFileType, 0, sizeof(enum SRMv2__TFileType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TFileStorageType(struct soap *soap, enum SRMv2__TFileStorageType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TFileStorageType
	*a = SOAP_DEFAULT_SRMv2__TFileStorageType;
#else
	*a = (enum SRMv2__TFileStorageType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TFileStorageType(struct soap *soap, const enum SRMv2__TFileStorageType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TFileStorageType);
	if (soap_out_SRMv2__TFileStorageType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TFileStorageType[] =
{	{ (long)SRMv2__TFileStorageType__Volatile, "Volatile" },
	{ (long)SRMv2__TFileStorageType__Durable, "Durable" },
	{ (long)SRMv2__TFileStorageType__Permanent, "Permanent" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TFileStorageType2s(struct soap *soap, enum SRMv2__TFileStorageType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TFileStorageType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TFileStorageType(struct soap *soap, const char *tag, int id, const enum SRMv2__TFileStorageType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TFileStorageType), type);
	soap_send(soap, soap_SRMv2__TFileStorageType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TFileStorageType * SOAP_FMAC4 soap_get_SRMv2__TFileStorageType(struct soap *soap, enum SRMv2__TFileStorageType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TFileStorageType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TFileStorageType(struct soap *soap, const char *s, enum SRMv2__TFileStorageType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TFileStorageType, s);
	if (map)
		*a = (enum SRMv2__TFileStorageType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TFileStorageType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TFileStorageType * SOAP_FMAC4 soap_in_SRMv2__TFileStorageType(struct soap *soap, const char *tag, enum SRMv2__TFileStorageType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TFileStorageType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TFileStorageType, sizeof(enum SRMv2__TFileStorageType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TFileStorageType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TFileStorageType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TFileStorageType, 0, sizeof(enum SRMv2__TFileStorageType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TSpaceType(struct soap *soap, enum SRMv2__TSpaceType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TSpaceType
	*a = SOAP_DEFAULT_SRMv2__TSpaceType;
#else
	*a = (enum SRMv2__TSpaceType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TSpaceType(struct soap *soap, const enum SRMv2__TSpaceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TSpaceType);
	if (soap_out_SRMv2__TSpaceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TSpaceType[] =
{	{ (long)SRMv2__TSpaceType__Volatile, "Volatile" },
	{ (long)SRMv2__TSpaceType__Durable, "Durable" },
	{ (long)SRMv2__TSpaceType__Permanent, "Permanent" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TSpaceType2s(struct soap *soap, enum SRMv2__TSpaceType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TSpaceType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSpaceType(struct soap *soap, const char *tag, int id, const enum SRMv2__TSpaceType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSpaceType), type);
	soap_send(soap, soap_SRMv2__TSpaceType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TSpaceType * SOAP_FMAC4 soap_get_SRMv2__TSpaceType(struct soap *soap, enum SRMv2__TSpaceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSpaceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TSpaceType(struct soap *soap, const char *s, enum SRMv2__TSpaceType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TSpaceType, s);
	if (map)
		*a = (enum SRMv2__TSpaceType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TSpaceType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TSpaceType * SOAP_FMAC4 soap_in_SRMv2__TSpaceType(struct soap *soap, const char *tag, enum SRMv2__TSpaceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TSpaceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSpaceType, sizeof(enum SRMv2__TSpaceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TSpaceType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TSpaceType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSpaceType, 0, sizeof(enum SRMv2__TSpaceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

void SRMv2__srmGetRequestIDResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTRequestToken(soap, &((SRMv2__srmGetRequestIDResponse*)this)->arrayOfRequestTokens);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetRequestIDResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestIDResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetRequestIDResponse*)this)->arrayOfRequestTokens = NULL;
	((SRMv2__srmGetRequestIDResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetRequestIDResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestIDResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestIDResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestIDResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestIDResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestIDResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestIDResponse), type);
	soap_out_PointerToSRMv2__ArrayOfTRequestToken(soap, "arrayOfRequestTokens", -1, &(((SRMv2__srmGetRequestIDResponse*)a)->arrayOfRequestTokens), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetRequestIDResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestIDResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestIDResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestIDResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestIDResponse(struct soap *soap, SRMv2__srmGetRequestIDResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestIDResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestIDResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestIDResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestIDResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestIDResponse(struct soap *soap, const char *tag, SRMv2__srmGetRequestIDResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestIDResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestIDResponse, sizeof(SRMv2__srmGetRequestIDResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestIDResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestIDResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfRequestTokens1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfRequestTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTRequestToken(soap, "arrayOfRequestTokens", &(((SRMv2__srmGetRequestIDResponse*)a)->arrayOfRequestTokens), "SRMv2:ArrayOfTRequestToken"))
				{	soap_flag_arrayOfRequestTokens1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetRequestIDResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestIDResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestIDResponse, 0, sizeof(SRMv2__srmGetRequestIDResponse), 0, soap_copy_SRMv2__srmGetRequestIDResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestIDResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestIDResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestIDResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestIDResponse(struct soap *soap, SRMv2__srmGetRequestIDResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestIDResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestIDResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestIDResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestIDResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestIDResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestIDResponse);
		((SRMv2__srmGetRequestIDResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestIDResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestIDResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestIDResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestIDResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestIDResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestIDResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestIDResponse*)p = *(SRMv2__srmGetRequestIDResponse*)q;
}

void SRMv2__srmGetRequestIDRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmGetRequestIDRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmGetRequestIDRequest*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestIDRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmGetRequestIDRequest*)this)->userRequestDescription);
	((SRMv2__srmGetRequestIDRequest*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetRequestIDRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestIDRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestIDRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestIDRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestIDRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestIDRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestIDRequest), type);
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmGetRequestIDRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmGetRequestIDRequest*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestIDRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestIDRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestIDRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestIDRequest(struct soap *soap, SRMv2__srmGetRequestIDRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestIDRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestIDRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestIDRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestIDRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestIDRequest(struct soap *soap, const char *tag, SRMv2__srmGetRequestIDRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestIDRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestIDRequest, sizeof(SRMv2__srmGetRequestIDRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestIDRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestIDRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userRequestDescription1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmGetRequestIDRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmGetRequestIDRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestIDRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestIDRequest, 0, sizeof(SRMv2__srmGetRequestIDRequest), 0, soap_copy_SRMv2__srmGetRequestIDRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestIDRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestIDRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestIDRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestIDRequest(struct soap *soap, SRMv2__srmGetRequestIDRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestIDRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestIDRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestIDRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestIDRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestIDRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestIDRequest);
		((SRMv2__srmGetRequestIDRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestIDRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestIDRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestIDRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestIDRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestIDRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestIDRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestIDRequest*)p = *(SRMv2__srmGetRequestIDRequest*)q;
}

void SRMv2__srmExtendFileLifeTimeResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmExtendFileLifeTimeResponse*)this)->newTimeExtended);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmExtendFileLifeTimeResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmExtendFileLifeTimeResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmExtendFileLifeTimeResponse*)this)->newTimeExtended = NULL;
	((SRMv2__srmExtendFileLifeTimeResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmExtendFileLifeTimeResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmExtendFileLifeTimeResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmExtendFileLifeTimeResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmExtendFileLifeTimeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse), type);
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "newTimeExtended", -1, &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->newTimeExtended), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmExtendFileLifeTimeResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmExtendFileLifeTimeResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC4 soap_get_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, SRMv2__srmExtendFileLifeTimeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmExtendFileLifeTimeResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC4 soap_in_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, const char *tag, SRMv2__srmExtendFileLifeTimeResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmExtendFileLifeTimeResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse, sizeof(SRMv2__srmExtendFileLifeTimeResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmExtendFileLifeTimeResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_newTimeExtended1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_newTimeExtended1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "newTimeExtended", &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->newTimeExtended), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_newTimeExtended1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmExtendFileLifeTimeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse, 0, sizeof(SRMv2__srmExtendFileLifeTimeResponse), 0, soap_copy_SRMv2__srmExtendFileLifeTimeResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC6 soap_new_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, SRMv2__srmExtendFileLifeTimeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeResponse;
		if (size)
			*size = sizeof(SRMv2__srmExtendFileLifeTimeResponse);
		((SRMv2__srmExtendFileLifeTimeResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmExtendFileLifeTimeResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmExtendFileLifeTimeResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmExtendFileLifeTimeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmExtendFileLifeTimeResponse %p -> %p\n", q, p));
	*(SRMv2__srmExtendFileLifeTimeResponse*)p = *(SRMv2__srmExtendFileLifeTimeResponse*)q;
}

void SRMv2__srmExtendFileLifeTimeRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->siteURL);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->newLifeTime);
	/* transient soap skipped */
}

void SRMv2__srmExtendFileLifeTimeRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->requestToken = NULL;
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->siteURL = NULL;
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->userID = NULL;
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->newLifeTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmExtendFileLifeTimeRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmExtendFileLifeTimeRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmExtendFileLifeTimeRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmExtendFileLifeTimeRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TSURL(soap, "siteURL", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->siteURL), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "newLifeTime", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->newLifeTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmExtendFileLifeTimeRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmExtendFileLifeTimeRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC4 soap_get_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, SRMv2__srmExtendFileLifeTimeRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmExtendFileLifeTimeRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC4 soap_in_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, const char *tag, SRMv2__srmExtendFileLifeTimeRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmExtendFileLifeTimeRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest, sizeof(SRMv2__srmExtendFileLifeTimeRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmExtendFileLifeTimeRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_siteURL1 = 1, soap_flag_userID1 = 1, soap_flag_newLifeTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_siteURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "siteURL", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->siteURL), "SRMv2:TSURL"))
				{	soap_flag_siteURL1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_newLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "newLifeTime", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->newLifeTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_newLifeTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0 || soap_flag_siteURL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmExtendFileLifeTimeRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest, 0, sizeof(SRMv2__srmExtendFileLifeTimeRequest), 0, soap_copy_SRMv2__srmExtendFileLifeTimeRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC6 soap_new_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, SRMv2__srmExtendFileLifeTimeRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeRequest;
		if (size)
			*size = sizeof(SRMv2__srmExtendFileLifeTimeRequest);
		((SRMv2__srmExtendFileLifeTimeRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmExtendFileLifeTimeRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmExtendFileLifeTimeRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmExtendFileLifeTimeRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmExtendFileLifeTimeRequest %p -> %p\n", q, p));
	*(SRMv2__srmExtendFileLifeTimeRequest*)p = *(SRMv2__srmExtendFileLifeTimeRequest*)q;
}

void SRMv2__srmGetRequestSummaryResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTRequestSummary(soap, &((SRMv2__srmGetRequestSummaryResponse*)this)->arrayOfRequestSummaries);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetRequestSummaryResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestSummaryResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetRequestSummaryResponse*)this)->arrayOfRequestSummaries = NULL;
	((SRMv2__srmGetRequestSummaryResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetRequestSummaryResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestSummaryResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestSummaryResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestSummaryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse), type);
	soap_out_PointerToSRMv2__ArrayOfTRequestSummary(soap, "arrayOfRequestSummaries", -1, &(((SRMv2__srmGetRequestSummaryResponse*)a)->arrayOfRequestSummaries), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetRequestSummaryResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestSummaryResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestSummaryResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, SRMv2__srmGetRequestSummaryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestSummaryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestSummaryResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestSummaryResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, const char *tag, SRMv2__srmGetRequestSummaryResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestSummaryResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse, sizeof(SRMv2__srmGetRequestSummaryResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestSummaryResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfRequestSummaries1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfRequestSummaries1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTRequestSummary(soap, "arrayOfRequestSummaries", &(((SRMv2__srmGetRequestSummaryResponse*)a)->arrayOfRequestSummaries), "SRMv2:ArrayOfTRequestSummary"))
				{	soap_flag_arrayOfRequestSummaries1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetRequestSummaryResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestSummaryResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse, 0, sizeof(SRMv2__srmGetRequestSummaryResponse), 0, soap_copy_SRMv2__srmGetRequestSummaryResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestSummaryResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, SRMv2__srmGetRequestSummaryResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestSummaryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestSummaryResponse);
		((SRMv2__srmGetRequestSummaryResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestSummaryResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestSummaryResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestSummaryResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestSummaryResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestSummaryResponse*)p = *(SRMv2__srmGetRequestSummaryResponse*)q;
}

void SRMv2__srmGetRequestSummaryRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTRequestToken(soap, &((SRMv2__srmGetRequestSummaryRequest*)this)->arrayOfRequestTokens);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmGetRequestSummaryRequest*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestSummaryRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetRequestSummaryRequest*)this)->arrayOfRequestTokens = NULL;
	((SRMv2__srmGetRequestSummaryRequest*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetRequestSummaryRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestSummaryRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestSummaryRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestSummaryRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest), type);
	soap_out_PointerToSRMv2__ArrayOfTRequestToken(soap, "arrayOfRequestTokens", -1, &(((SRMv2__srmGetRequestSummaryRequest*)a)->arrayOfRequestTokens), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmGetRequestSummaryRequest*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestSummaryRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestSummaryRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, SRMv2__srmGetRequestSummaryRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestSummaryRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestSummaryRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestSummaryRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, const char *tag, SRMv2__srmGetRequestSummaryRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestSummaryRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest, sizeof(SRMv2__srmGetRequestSummaryRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestSummaryRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfRequestTokens1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfRequestTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTRequestToken(soap, "arrayOfRequestTokens", &(((SRMv2__srmGetRequestSummaryRequest*)a)->arrayOfRequestTokens), "SRMv2:ArrayOfTRequestToken"))
				{	soap_flag_arrayOfRequestTokens1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmGetRequestSummaryRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfRequestTokens1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestSummaryRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest, 0, sizeof(SRMv2__srmGetRequestSummaryRequest), 0, soap_copy_SRMv2__srmGetRequestSummaryRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestSummaryRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, SRMv2__srmGetRequestSummaryRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestSummaryRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestSummaryRequest);
		((SRMv2__srmGetRequestSummaryRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestSummaryRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestSummaryRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestSummaryRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestSummaryRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestSummaryRequest*)p = *(SRMv2__srmGetRequestSummaryRequest*)q;
}

void SRMv2__srmStatusOfCopyRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfCopyRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, &((SRMv2__srmStatusOfCopyRequestResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfCopyRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfCopyRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfCopyRequestResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfCopyRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfCopyRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfCopyRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfCopyRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfCopyRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfCopyRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, SRMv2__srmStatusOfCopyRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfCopyRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfCopyRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfCopyRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse, sizeof(SRMv2__srmStatusOfCopyRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfCopyRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTCopyRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfCopyRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse, 0, sizeof(SRMv2__srmStatusOfCopyRequestResponse), 0, soap_copy_SRMv2__srmStatusOfCopyRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, SRMv2__srmStatusOfCopyRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfCopyRequestResponse);
		((SRMv2__srmStatusOfCopyRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfCopyRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfCopyRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfCopyRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfCopyRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfCopyRequestResponse*)p = *(SRMv2__srmStatusOfCopyRequestResponse*)q;
}

void SRMv2__srmStatusOfCopyRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfFromSURLs);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfToSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfCopyRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfCopyRequestRequest*)this)->requestToken = NULL;
	((SRMv2__srmStatusOfCopyRequestRequest*)this)->userID = NULL;
	((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfFromSURLs = NULL;
	((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfToSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfCopyRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfCopyRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfCopyRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfCopyRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfFromSURLs", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfFromSURLs), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfToSURLs", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfToSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfCopyRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfCopyRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, SRMv2__srmStatusOfCopyRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfCopyRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfCopyRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfCopyRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest, sizeof(SRMv2__srmStatusOfCopyRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfCopyRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1, soap_flag_arrayOfFromSURLs1 = 1, soap_flag_arrayOfToSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfFromSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfFromSURLs", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfFromSURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_arrayOfFromSURLs1--;
					continue;
				}
			if (soap_flag_arrayOfToSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfToSURLs", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfToSURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_arrayOfToSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfCopyRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest, 0, sizeof(SRMv2__srmStatusOfCopyRequestRequest), 0, soap_copy_SRMv2__srmStatusOfCopyRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, SRMv2__srmStatusOfCopyRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfCopyRequestRequest);
		((SRMv2__srmStatusOfCopyRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfCopyRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfCopyRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfCopyRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfCopyRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfCopyRequestRequest*)p = *(SRMv2__srmStatusOfCopyRequestRequest*)q;
}

void SRMv2__srmStatusOfPutRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfPutRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, &((SRMv2__srmStatusOfPutRequestResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfPutRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfPutRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfPutRequestResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfPutRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfPutRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfPutRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfPutRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfPutRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfPutRequestResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfPutRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfPutRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, SRMv2__srmStatusOfPutRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfPutRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfPutRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfPutRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse, sizeof(SRMv2__srmStatusOfPutRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfPutRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfPutRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfPutRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTPutRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfPutRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse, 0, sizeof(SRMv2__srmStatusOfPutRequestResponse), 0, soap_copy_SRMv2__srmStatusOfPutRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, SRMv2__srmStatusOfPutRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfPutRequestResponse);
		((SRMv2__srmStatusOfPutRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfPutRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfPutRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfPutRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfPutRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfPutRequestResponse*)p = *(SRMv2__srmStatusOfPutRequestResponse*)q;
}

void SRMv2__srmStatusOfPutRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->arrayOfToSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfPutRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfPutRequestRequest*)this)->requestToken = NULL;
	((SRMv2__srmStatusOfPutRequestRequest*)this)->userID = NULL;
	((SRMv2__srmStatusOfPutRequestRequest*)this)->arrayOfToSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfPutRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfPutRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfPutRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfPutRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmStatusOfPutRequestRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmStatusOfPutRequestRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfToSURLs", -1, &(((SRMv2__srmStatusOfPutRequestRequest*)a)->arrayOfToSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfPutRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfPutRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, SRMv2__srmStatusOfPutRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfPutRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfPutRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfPutRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest, sizeof(SRMv2__srmStatusOfPutRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfPutRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1, soap_flag_arrayOfToSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmStatusOfPutRequestRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmStatusOfPutRequestRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfToSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfToSURLs", &(((SRMv2__srmStatusOfPutRequestRequest*)a)->arrayOfToSURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_arrayOfToSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfPutRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest, 0, sizeof(SRMv2__srmStatusOfPutRequestRequest), 0, soap_copy_SRMv2__srmStatusOfPutRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, SRMv2__srmStatusOfPutRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfPutRequestRequest);
		((SRMv2__srmStatusOfPutRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfPutRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfPutRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfPutRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfPutRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfPutRequestRequest*)p = *(SRMv2__srmStatusOfPutRequestRequest*)q;
}

void SRMv2__srmStatusOfGetRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfGetRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, &((SRMv2__srmStatusOfGetRequestResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfGetRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfGetRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfGetRequestResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfGetRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfGetRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfGetRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfGetRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfGetRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfGetRequestResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfGetRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfGetRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, SRMv2__srmStatusOfGetRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfGetRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfGetRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfGetRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse, sizeof(SRMv2__srmStatusOfGetRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfGetRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfGetRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfGetRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTGetRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfGetRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse, 0, sizeof(SRMv2__srmStatusOfGetRequestResponse), 0, soap_copy_SRMv2__srmStatusOfGetRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, SRMv2__srmStatusOfGetRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfGetRequestResponse);
		((SRMv2__srmStatusOfGetRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfGetRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfGetRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfGetRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfGetRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfGetRequestResponse*)p = *(SRMv2__srmStatusOfGetRequestResponse*)q;
}

void SRMv2__srmStatusOfGetRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->arrayOfFromSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfGetRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfGetRequestRequest*)this)->requestToken = NULL;
	((SRMv2__srmStatusOfGetRequestRequest*)this)->userID = NULL;
	((SRMv2__srmStatusOfGetRequestRequest*)this)->arrayOfFromSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfGetRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfGetRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfGetRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfGetRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmStatusOfGetRequestRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmStatusOfGetRequestRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfFromSURLs", -1, &(((SRMv2__srmStatusOfGetRequestRequest*)a)->arrayOfFromSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfGetRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfGetRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, SRMv2__srmStatusOfGetRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfGetRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfGetRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfGetRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest, sizeof(SRMv2__srmStatusOfGetRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfGetRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1, soap_flag_arrayOfFromSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmStatusOfGetRequestRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmStatusOfGetRequestRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfFromSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfFromSURLs", &(((SRMv2__srmStatusOfGetRequestRequest*)a)->arrayOfFromSURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_arrayOfFromSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfGetRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest, 0, sizeof(SRMv2__srmStatusOfGetRequestRequest), 0, soap_copy_SRMv2__srmStatusOfGetRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, SRMv2__srmStatusOfGetRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfGetRequestRequest);
		((SRMv2__srmStatusOfGetRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfGetRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfGetRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfGetRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfGetRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfGetRequestRequest*)p = *(SRMv2__srmStatusOfGetRequestRequest*)q;
}

void SRMv2__srmResumeRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmResumeRequestResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmResumeRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmResumeRequestResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmResumeRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmResumeRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmResumeRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmResumeRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmResumeRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmResumeRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmResumeRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmResumeRequestResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmResumeRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmResumeRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmResumeRequestResponse(struct soap *soap, SRMv2__srmResumeRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmResumeRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmResumeRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmResumeRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmResumeRequestResponse(struct soap *soap, const char *tag, SRMv2__srmResumeRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmResumeRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmResumeRequestResponse, sizeof(SRMv2__srmResumeRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmResumeRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmResumeRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmResumeRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmResumeRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmResumeRequestResponse, 0, sizeof(SRMv2__srmResumeRequestResponse), 0, soap_copy_SRMv2__srmResumeRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmResumeRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmResumeRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmResumeRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmResumeRequestResponse(struct soap *soap, SRMv2__srmResumeRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmResumeRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmResumeRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmResumeRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmResumeRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmResumeRequestResponse);
		((SRMv2__srmResumeRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmResumeRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmResumeRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmResumeRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmResumeRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmResumeRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmResumeRequestResponse*)p = *(SRMv2__srmResumeRequestResponse*)q;
}

void SRMv2__srmResumeRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmResumeRequestRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmResumeRequestRequest*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__srmResumeRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmResumeRequestRequest*)this)->requestToken = NULL;
	((SRMv2__srmResumeRequestRequest*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__srmResumeRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmResumeRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmResumeRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmResumeRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmResumeRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmResumeRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmResumeRequestRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmResumeRequestRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmResumeRequestRequest*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmResumeRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmResumeRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmResumeRequestRequest(struct soap *soap, SRMv2__srmResumeRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmResumeRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmResumeRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmResumeRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmResumeRequestRequest(struct soap *soap, const char *tag, SRMv2__srmResumeRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmResumeRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmResumeRequestRequest, sizeof(SRMv2__srmResumeRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmResumeRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmResumeRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmResumeRequestRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmResumeRequestRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmResumeRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmResumeRequestRequest, 0, sizeof(SRMv2__srmResumeRequestRequest), 0, soap_copy_SRMv2__srmResumeRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmResumeRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmResumeRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmResumeRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmResumeRequestRequest(struct soap *soap, SRMv2__srmResumeRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmResumeRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmResumeRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmResumeRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmResumeRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmResumeRequestRequest);
		((SRMv2__srmResumeRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmResumeRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmResumeRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmResumeRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmResumeRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmResumeRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmResumeRequestRequest*)p = *(SRMv2__srmResumeRequestRequest*)q;
}

void SRMv2__srmSuspendRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmSuspendRequestResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmSuspendRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmSuspendRequestResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSuspendRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSuspendRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSuspendRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSuspendRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSuspendRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmSuspendRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSuspendRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmSuspendRequestResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSuspendRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSuspendRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmSuspendRequestResponse(struct soap *soap, SRMv2__srmSuspendRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSuspendRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSuspendRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSuspendRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmSuspendRequestResponse(struct soap *soap, const char *tag, SRMv2__srmSuspendRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSuspendRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSuspendRequestResponse, sizeof(SRMv2__srmSuspendRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSuspendRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSuspendRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmSuspendRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSuspendRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSuspendRequestResponse, 0, sizeof(SRMv2__srmSuspendRequestResponse), 0, soap_copy_SRMv2__srmSuspendRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSuspendRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmSuspendRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSuspendRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSuspendRequestResponse(struct soap *soap, SRMv2__srmSuspendRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmSuspendRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSuspendRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSuspendRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmSuspendRequestResponse);
		((SRMv2__srmSuspendRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSuspendRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSuspendRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSuspendRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSuspendRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSuspendRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmSuspendRequestResponse*)p = *(SRMv2__srmSuspendRequestResponse*)q;
}

void SRMv2__srmSuspendRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmSuspendRequestRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmSuspendRequestRequest*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__srmSuspendRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmSuspendRequestRequest*)this)->requestToken = NULL;
	((SRMv2__srmSuspendRequestRequest*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSuspendRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSuspendRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSuspendRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSuspendRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSuspendRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmSuspendRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSuspendRequestRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmSuspendRequestRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmSuspendRequestRequest*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSuspendRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSuspendRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmSuspendRequestRequest(struct soap *soap, SRMv2__srmSuspendRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSuspendRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSuspendRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSuspendRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmSuspendRequestRequest(struct soap *soap, const char *tag, SRMv2__srmSuspendRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSuspendRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSuspendRequestRequest, sizeof(SRMv2__srmSuspendRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSuspendRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSuspendRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmSuspendRequestRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmSuspendRequestRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSuspendRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSuspendRequestRequest, 0, sizeof(SRMv2__srmSuspendRequestRequest), 0, soap_copy_SRMv2__srmSuspendRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSuspendRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmSuspendRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSuspendRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSuspendRequestRequest(struct soap *soap, SRMv2__srmSuspendRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmSuspendRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSuspendRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSuspendRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmSuspendRequestRequest);
		((SRMv2__srmSuspendRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSuspendRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSuspendRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSuspendRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSuspendRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSuspendRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmSuspendRequestRequest*)p = *(SRMv2__srmSuspendRequestRequest*)q;
}

void SRMv2__srmAbortFilesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmAbortFilesResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmAbortFilesResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmAbortFilesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmAbortFilesResponse*)this)->returnStatus = NULL;
	((SRMv2__srmAbortFilesResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmAbortFilesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortFilesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortFilesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortFilesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortFilesResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortFilesResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmAbortFilesResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmAbortFilesResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortFilesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortFilesResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesResponse * SOAP_FMAC4 soap_get_SRMv2__srmAbortFilesResponse(struct soap *soap, SRMv2__srmAbortFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortFilesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortFilesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortFilesResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesResponse * SOAP_FMAC4 soap_in_SRMv2__srmAbortFilesResponse(struct soap *soap, const char *tag, SRMv2__srmAbortFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortFilesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortFilesResponse, sizeof(SRMv2__srmAbortFilesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortFilesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortFilesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmAbortFilesResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmAbortFilesResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortFilesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortFilesResponse, 0, sizeof(SRMv2__srmAbortFilesResponse), 0, soap_copy_SRMv2__srmAbortFilesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortFilesResponse * SOAP_FMAC6 soap_new_SRMv2__srmAbortFilesResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortFilesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortFilesResponse(struct soap *soap, SRMv2__srmAbortFilesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortFilesResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortFilesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortFilesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortFilesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesResponse;
		if (size)
			*size = sizeof(SRMv2__srmAbortFilesResponse);
		((SRMv2__srmAbortFilesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortFilesResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortFilesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortFilesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortFilesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortFilesResponse %p -> %p\n", q, p));
	*(SRMv2__srmAbortFilesResponse*)p = *(SRMv2__srmAbortFilesResponse*)q;
}

void SRMv2__srmAbortFilesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmAbortFilesRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmAbortFilesRequest*)this)->arrayOfSiteURLs);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmAbortFilesRequest*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__srmAbortFilesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmAbortFilesRequest*)this)->requestToken = NULL;
	((SRMv2__srmAbortFilesRequest*)this)->arrayOfSiteURLs = NULL;
	((SRMv2__srmAbortFilesRequest*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__srmAbortFilesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortFilesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortFilesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortFilesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortFilesRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortFilesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortFilesRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmAbortFilesRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfSiteURLs", -1, &(((SRMv2__srmAbortFilesRequest*)a)->arrayOfSiteURLs), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmAbortFilesRequest*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortFilesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortFilesRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesRequest * SOAP_FMAC4 soap_get_SRMv2__srmAbortFilesRequest(struct soap *soap, SRMv2__srmAbortFilesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortFilesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortFilesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortFilesRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesRequest * SOAP_FMAC4 soap_in_SRMv2__srmAbortFilesRequest(struct soap *soap, const char *tag, SRMv2__srmAbortFilesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortFilesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortFilesRequest, sizeof(SRMv2__srmAbortFilesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortFilesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortFilesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_arrayOfSiteURLs1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmAbortFilesRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfSiteURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfSiteURLs", &(((SRMv2__srmAbortFilesRequest*)a)->arrayOfSiteURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_arrayOfSiteURLs1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmAbortFilesRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0 || soap_flag_arrayOfSiteURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortFilesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortFilesRequest, 0, sizeof(SRMv2__srmAbortFilesRequest), 0, soap_copy_SRMv2__srmAbortFilesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortFilesRequest * SOAP_FMAC6 soap_new_SRMv2__srmAbortFilesRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortFilesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortFilesRequest(struct soap *soap, SRMv2__srmAbortFilesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortFilesRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortFilesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortFilesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortFilesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesRequest;
		if (size)
			*size = sizeof(SRMv2__srmAbortFilesRequest);
		((SRMv2__srmAbortFilesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortFilesRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortFilesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortFilesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortFilesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortFilesRequest %p -> %p\n", q, p));
	*(SRMv2__srmAbortFilesRequest*)p = *(SRMv2__srmAbortFilesRequest*)q;
}

void SRMv2__srmAbortRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmAbortRequestResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmAbortRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmAbortRequestResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmAbortRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmAbortRequestResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmAbortRequestResponse(struct soap *soap, SRMv2__srmAbortRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmAbortRequestResponse(struct soap *soap, const char *tag, SRMv2__srmAbortRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortRequestResponse, sizeof(SRMv2__srmAbortRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmAbortRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortRequestResponse, 0, sizeof(SRMv2__srmAbortRequestResponse), 0, soap_copy_SRMv2__srmAbortRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmAbortRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortRequestResponse(struct soap *soap, SRMv2__srmAbortRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmAbortRequestResponse);
		((SRMv2__srmAbortRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmAbortRequestResponse*)p = *(SRMv2__srmAbortRequestResponse*)q;
}

void SRMv2__srmAbortRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmAbortRequestRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmAbortRequestRequest*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__srmAbortRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmAbortRequestRequest*)this)->requestToken = NULL;
	((SRMv2__srmAbortRequestRequest*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__srmAbortRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortRequestRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmAbortRequestRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmAbortRequestRequest*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmAbortRequestRequest(struct soap *soap, SRMv2__srmAbortRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmAbortRequestRequest(struct soap *soap, const char *tag, SRMv2__srmAbortRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortRequestRequest, sizeof(SRMv2__srmAbortRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmAbortRequestRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmAbortRequestRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortRequestRequest, 0, sizeof(SRMv2__srmAbortRequestRequest), 0, soap_copy_SRMv2__srmAbortRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmAbortRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortRequestRequest(struct soap *soap, SRMv2__srmAbortRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmAbortRequestRequest);
		((SRMv2__srmAbortRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmAbortRequestRequest*)p = *(SRMv2__srmAbortRequestRequest*)q;
}

void SRMv2__srmPutDoneResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPutDoneResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmPutDoneResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmPutDoneResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPutDoneResponse*)this)->returnStatus = NULL;
	((SRMv2__srmPutDoneResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPutDoneResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPutDoneResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPutDoneResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPutDoneResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPutDoneResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPutDoneResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPutDoneResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPutDoneResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPutDoneResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPutDoneResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPutDoneResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneResponse * SOAP_FMAC4 soap_get_SRMv2__srmPutDoneResponse(struct soap *soap, SRMv2__srmPutDoneResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPutDoneResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPutDoneResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPutDoneResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneResponse * SOAP_FMAC4 soap_in_SRMv2__srmPutDoneResponse(struct soap *soap, const char *tag, SRMv2__srmPutDoneResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPutDoneResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPutDoneResponse, sizeof(SRMv2__srmPutDoneResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPutDoneResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPutDoneResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPutDoneResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPutDoneResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPutDoneResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPutDoneResponse, 0, sizeof(SRMv2__srmPutDoneResponse), 0, soap_copy_SRMv2__srmPutDoneResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPutDoneResponse * SOAP_FMAC6 soap_new_SRMv2__srmPutDoneResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPutDoneResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPutDoneResponse(struct soap *soap, SRMv2__srmPutDoneResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPutDoneResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPutDoneResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPutDoneResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPutDoneResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPutDoneResponse;
		if (size)
			*size = sizeof(SRMv2__srmPutDoneResponse);
		((SRMv2__srmPutDoneResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPutDoneResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPutDoneResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPutDoneResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPutDoneResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPutDoneResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPutDoneResponse %p -> %p\n", q, p));
	*(SRMv2__srmPutDoneResponse*)p = *(SRMv2__srmPutDoneResponse*)q;
}

void SRMv2__srmPutDoneRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmPutDoneRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmPutDoneRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmPutDoneRequest*)this)->arrayOfSiteURLs);
	/* transient soap skipped */
}

void SRMv2__srmPutDoneRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPutDoneRequest*)this)->requestToken = NULL;
	((SRMv2__srmPutDoneRequest*)this)->userID = NULL;
	((SRMv2__srmPutDoneRequest*)this)->arrayOfSiteURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPutDoneRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPutDoneRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPutDoneRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPutDoneRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPutDoneRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPutDoneRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPutDoneRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmPutDoneRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmPutDoneRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfSiteURLs", -1, &(((SRMv2__srmPutDoneRequest*)a)->arrayOfSiteURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPutDoneRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPutDoneRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneRequest * SOAP_FMAC4 soap_get_SRMv2__srmPutDoneRequest(struct soap *soap, SRMv2__srmPutDoneRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPutDoneRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPutDoneRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPutDoneRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneRequest * SOAP_FMAC4 soap_in_SRMv2__srmPutDoneRequest(struct soap *soap, const char *tag, SRMv2__srmPutDoneRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPutDoneRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPutDoneRequest, sizeof(SRMv2__srmPutDoneRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPutDoneRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPutDoneRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1, soap_flag_arrayOfSiteURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmPutDoneRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmPutDoneRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfSiteURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "arrayOfSiteURLs", &(((SRMv2__srmPutDoneRequest*)a)->arrayOfSiteURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_arrayOfSiteURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0 || soap_flag_arrayOfSiteURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPutDoneRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPutDoneRequest, 0, sizeof(SRMv2__srmPutDoneRequest), 0, soap_copy_SRMv2__srmPutDoneRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPutDoneRequest * SOAP_FMAC6 soap_new_SRMv2__srmPutDoneRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPutDoneRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPutDoneRequest(struct soap *soap, SRMv2__srmPutDoneRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPutDoneRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPutDoneRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPutDoneRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPutDoneRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPutDoneRequest;
		if (size)
			*size = sizeof(SRMv2__srmPutDoneRequest);
		((SRMv2__srmPutDoneRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPutDoneRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPutDoneRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPutDoneRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPutDoneRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPutDoneRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPutDoneRequest %p -> %p\n", q, p));
	*(SRMv2__srmPutDoneRequest*)p = *(SRMv2__srmPutDoneRequest*)q;
}

void SRMv2__srmReleaseFilesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReleaseFilesResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmReleaseFilesResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmReleaseFilesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReleaseFilesResponse*)this)->returnStatus = NULL;
	((SRMv2__srmReleaseFilesResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseFilesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseFilesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseFilesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseFilesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseFilesResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseFilesResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReleaseFilesResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmReleaseFilesResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseFilesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseFilesResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesResponse * SOAP_FMAC4 soap_get_SRMv2__srmReleaseFilesResponse(struct soap *soap, SRMv2__srmReleaseFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseFilesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseFilesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseFilesResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesResponse * SOAP_FMAC4 soap_in_SRMv2__srmReleaseFilesResponse(struct soap *soap, const char *tag, SRMv2__srmReleaseFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseFilesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseFilesResponse, sizeof(SRMv2__srmReleaseFilesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseFilesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseFilesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReleaseFilesResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmReleaseFilesResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseFilesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseFilesResponse, 0, sizeof(SRMv2__srmReleaseFilesResponse), 0, soap_copy_SRMv2__srmReleaseFilesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseFilesResponse * SOAP_FMAC6 soap_new_SRMv2__srmReleaseFilesResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseFilesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseFilesResponse(struct soap *soap, SRMv2__srmReleaseFilesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseFilesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseFilesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseFilesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesResponse;
		if (size)
			*size = sizeof(SRMv2__srmReleaseFilesResponse);
		((SRMv2__srmReleaseFilesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseFilesResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseFilesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseFilesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseFilesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseFilesResponse %p -> %p\n", q, p));
	*(SRMv2__srmReleaseFilesResponse*)p = *(SRMv2__srmReleaseFilesResponse*)q;
}

void SRMv2__srmReleaseFilesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmReleaseFilesRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmReleaseFilesRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmReleaseFilesRequest*)this)->siteURLs);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmReleaseFilesRequest*)this)->keepSpace);
	/* transient soap skipped */
}

void SRMv2__srmReleaseFilesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReleaseFilesRequest*)this)->requestToken = NULL;
	((SRMv2__srmReleaseFilesRequest*)this)->userID = NULL;
	((SRMv2__srmReleaseFilesRequest*)this)->siteURLs = NULL;
	((SRMv2__srmReleaseFilesRequest*)this)->keepSpace = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseFilesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseFilesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseFilesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseFilesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseFilesRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseFilesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseFilesRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "siteURLs", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->siteURLs), "");
	soap_out_PointerTobool(soap, "keepSpace", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->keepSpace), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseFilesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseFilesRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesRequest * SOAP_FMAC4 soap_get_SRMv2__srmReleaseFilesRequest(struct soap *soap, SRMv2__srmReleaseFilesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseFilesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseFilesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseFilesRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesRequest * SOAP_FMAC4 soap_in_SRMv2__srmReleaseFilesRequest(struct soap *soap, const char *tag, SRMv2__srmReleaseFilesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseFilesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseFilesRequest, sizeof(SRMv2__srmReleaseFilesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseFilesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseFilesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1, soap_flag_siteURLs1 = 1, soap_flag_keepSpace1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmReleaseFilesRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmReleaseFilesRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_siteURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "siteURLs", &(((SRMv2__srmReleaseFilesRequest*)a)->siteURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_siteURLs1--;
					continue;
				}
			if (soap_flag_keepSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "keepSpace", &(((SRMv2__srmReleaseFilesRequest*)a)->keepSpace), "xsd:boolean"))
				{	soap_flag_keepSpace1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_siteURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseFilesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseFilesRequest, 0, sizeof(SRMv2__srmReleaseFilesRequest), 0, soap_copy_SRMv2__srmReleaseFilesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseFilesRequest * SOAP_FMAC6 soap_new_SRMv2__srmReleaseFilesRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseFilesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseFilesRequest(struct soap *soap, SRMv2__srmReleaseFilesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseFilesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseFilesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseFilesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesRequest;
		if (size)
			*size = sizeof(SRMv2__srmReleaseFilesRequest);
		((SRMv2__srmReleaseFilesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseFilesRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseFilesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseFilesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseFilesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseFilesRequest %p -> %p\n", q, p));
	*(SRMv2__srmReleaseFilesRequest*)p = *(SRMv2__srmReleaseFilesRequest*)q;
}

void SRMv2__srmRemoveFilesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmRemoveFilesResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmRemoveFilesResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmRemoveFilesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRemoveFilesResponse*)this)->returnStatus = NULL;
	((SRMv2__srmRemoveFilesResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRemoveFilesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRemoveFilesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRemoveFilesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRemoveFilesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRemoveFilesResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmRemoveFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRemoveFilesResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmRemoveFilesResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmRemoveFilesResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRemoveFilesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRemoveFilesResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRemoveFilesResponse * SOAP_FMAC4 soap_get_SRMv2__srmRemoveFilesResponse(struct soap *soap, SRMv2__srmRemoveFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRemoveFilesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRemoveFilesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRemoveFilesResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRemoveFilesResponse * SOAP_FMAC4 soap_in_SRMv2__srmRemoveFilesResponse(struct soap *soap, const char *tag, SRMv2__srmRemoveFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRemoveFilesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRemoveFilesResponse, sizeof(SRMv2__srmRemoveFilesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRemoveFilesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRemoveFilesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmRemoveFilesResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmRemoveFilesResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRemoveFilesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRemoveFilesResponse, 0, sizeof(SRMv2__srmRemoveFilesResponse), 0, soap_copy_SRMv2__srmRemoveFilesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRemoveFilesResponse * SOAP_FMAC6 soap_new_SRMv2__srmRemoveFilesResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRemoveFilesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRemoveFilesResponse(struct soap *soap, SRMv2__srmRemoveFilesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRemoveFilesResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmRemoveFilesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRemoveFilesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRemoveFilesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRemoveFilesResponse;
		if (size)
			*size = sizeof(SRMv2__srmRemoveFilesResponse);
		((SRMv2__srmRemoveFilesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRemoveFilesResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRemoveFilesResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRemoveFilesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRemoveFilesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRemoveFilesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRemoveFilesResponse %p -> %p\n", q, p));
	*(SRMv2__srmRemoveFilesResponse*)p = *(SRMv2__srmRemoveFilesResponse*)q;
}

void SRMv2__srmRemoveFilesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmRemoveFilesRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmRemoveFilesRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURL(soap, &((SRMv2__srmRemoveFilesRequest*)this)->siteURLs);
	/* transient soap skipped */
}

void SRMv2__srmRemoveFilesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRemoveFilesRequest*)this)->requestToken = NULL;
	((SRMv2__srmRemoveFilesRequest*)this)->userID = NULL;
	((SRMv2__srmRemoveFilesRequest*)this)->siteURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRemoveFilesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRemoveFilesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRemoveFilesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRemoveFilesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRemoveFilesRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmRemoveFilesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRemoveFilesRequest), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmRemoveFilesRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmRemoveFilesRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURL(soap, "siteURLs", -1, &(((SRMv2__srmRemoveFilesRequest*)a)->siteURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRemoveFilesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRemoveFilesRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRemoveFilesRequest * SOAP_FMAC4 soap_get_SRMv2__srmRemoveFilesRequest(struct soap *soap, SRMv2__srmRemoveFilesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRemoveFilesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRemoveFilesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRemoveFilesRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRemoveFilesRequest * SOAP_FMAC4 soap_in_SRMv2__srmRemoveFilesRequest(struct soap *soap, const char *tag, SRMv2__srmRemoveFilesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRemoveFilesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRemoveFilesRequest, sizeof(SRMv2__srmRemoveFilesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRemoveFilesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRemoveFilesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_userID1 = 1, soap_flag_siteURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmRemoveFilesRequest*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmRemoveFilesRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_siteURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURL(soap, "siteURLs", &(((SRMv2__srmRemoveFilesRequest*)a)->siteURLs), "SRMv2:ArrayOfTSURL"))
				{	soap_flag_siteURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_siteURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRemoveFilesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRemoveFilesRequest, 0, sizeof(SRMv2__srmRemoveFilesRequest), 0, soap_copy_SRMv2__srmRemoveFilesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRemoveFilesRequest * SOAP_FMAC6 soap_new_SRMv2__srmRemoveFilesRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRemoveFilesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRemoveFilesRequest(struct soap *soap, SRMv2__srmRemoveFilesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRemoveFilesRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmRemoveFilesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRemoveFilesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRemoveFilesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRemoveFilesRequest;
		if (size)
			*size = sizeof(SRMv2__srmRemoveFilesRequest);
		((SRMv2__srmRemoveFilesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRemoveFilesRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRemoveFilesRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRemoveFilesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRemoveFilesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRemoveFilesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRemoveFilesRequest %p -> %p\n", q, p));
	*(SRMv2__srmRemoveFilesRequest*)p = *(SRMv2__srmRemoveFilesRequest*)q;
}

void SRMv2__srmCopyResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmCopyResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmCopyResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, &((SRMv2__srmCopyResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmCopyResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCopyResponse*)this)->requestToken = NULL;
	((SRMv2__srmCopyResponse*)this)->returnStatus = NULL;
	((SRMv2__srmCopyResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCopyResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCopyResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCopyResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCopyResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCopyResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmCopyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCopyResponse), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmCopyResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmCopyResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmCopyResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCopyResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCopyResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCopyResponse * SOAP_FMAC4 soap_get_SRMv2__srmCopyResponse(struct soap *soap, SRMv2__srmCopyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCopyResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCopyResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCopyResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCopyResponse * SOAP_FMAC4 soap_in_SRMv2__srmCopyResponse(struct soap *soap, const char *tag, SRMv2__srmCopyResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCopyResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCopyResponse, sizeof(SRMv2__srmCopyResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCopyResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCopyResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmCopyResponse*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmCopyResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmCopyResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTCopyRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCopyResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCopyResponse, 0, sizeof(SRMv2__srmCopyResponse), 0, soap_copy_SRMv2__srmCopyResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCopyResponse * SOAP_FMAC6 soap_new_SRMv2__srmCopyResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCopyResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCopyResponse(struct soap *soap, SRMv2__srmCopyResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCopyResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmCopyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCopyResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCopyResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCopyResponse;
		if (size)
			*size = sizeof(SRMv2__srmCopyResponse);
		((SRMv2__srmCopyResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCopyResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCopyResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCopyResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCopyResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCopyResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCopyResponse %p -> %p\n", q, p));
	*(SRMv2__srmCopyResponse*)p = *(SRMv2__srmCopyResponse*)q;
}

void SRMv2__srmCopyRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmCopyRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, &((SRMv2__srmCopyRequest*)this)->arrayOfFileRequests);
	soap_serialize_string(soap, &((SRMv2__srmCopyRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__TOverwriteMode(soap, &((SRMv2__srmCopyRequest*)this)->overwriteOption);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmCopyRequest*)this)->removeSourceFiles);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmCopyRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmCopyRequest*)this)->totalRetryTime);
	/* transient soap skipped */
}

void SRMv2__srmCopyRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCopyRequest*)this)->userID = NULL;
	((SRMv2__srmCopyRequest*)this)->arrayOfFileRequests = NULL;
	soap_default_string(soap, &((SRMv2__srmCopyRequest*)this)->userRequestDescription);
	((SRMv2__srmCopyRequest*)this)->overwriteOption = NULL;
	((SRMv2__srmCopyRequest*)this)->removeSourceFiles = NULL;
	((SRMv2__srmCopyRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmCopyRequest*)this)->totalRetryTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCopyRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCopyRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCopyRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCopyRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCopyRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmCopyRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCopyRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmCopyRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmCopyRequest*)a)->arrayOfFileRequests), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmCopyRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", -1, &(((SRMv2__srmCopyRequest*)a)->overwriteOption), "");
	soap_out_PointerTobool(soap, "removeSourceFiles", -1, &(((SRMv2__srmCopyRequest*)a)->removeSourceFiles), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmCopyRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "totalRetryTime", -1, &(((SRMv2__srmCopyRequest*)a)->totalRetryTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCopyRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCopyRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCopyRequest * SOAP_FMAC4 soap_get_SRMv2__srmCopyRequest(struct soap *soap, SRMv2__srmCopyRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCopyRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCopyRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCopyRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCopyRequest * SOAP_FMAC4 soap_in_SRMv2__srmCopyRequest(struct soap *soap, const char *tag, SRMv2__srmCopyRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCopyRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCopyRequest, sizeof(SRMv2__srmCopyRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCopyRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCopyRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_overwriteOption1 = 1, soap_flag_removeSourceFiles1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_totalRetryTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmCopyRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmCopyRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTCopyFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmCopyRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_overwriteOption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", &(((SRMv2__srmCopyRequest*)a)->overwriteOption), "SRMv2:TOverwriteMode"))
				{	soap_flag_overwriteOption1--;
					continue;
				}
			if (soap_flag_removeSourceFiles1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "removeSourceFiles", &(((SRMv2__srmCopyRequest*)a)->removeSourceFiles), "xsd:boolean"))
				{	soap_flag_removeSourceFiles1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmCopyRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_totalRetryTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "totalRetryTime", &(((SRMv2__srmCopyRequest*)a)->totalRetryTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_totalRetryTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFileRequests1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCopyRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCopyRequest, 0, sizeof(SRMv2__srmCopyRequest), 0, soap_copy_SRMv2__srmCopyRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCopyRequest * SOAP_FMAC6 soap_new_SRMv2__srmCopyRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCopyRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCopyRequest(struct soap *soap, SRMv2__srmCopyRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCopyRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmCopyRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCopyRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCopyRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCopyRequest;
		if (size)
			*size = sizeof(SRMv2__srmCopyRequest);
		((SRMv2__srmCopyRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCopyRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCopyRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCopyRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCopyRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCopyRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCopyRequest %p -> %p\n", q, p));
	*(SRMv2__srmCopyRequest*)p = *(SRMv2__srmCopyRequest*)q;
}

void SRMv2__srmPrepareToPutResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmPrepareToPutResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPrepareToPutResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, &((SRMv2__srmPrepareToPutResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToPutResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPrepareToPutResponse*)this)->requestToken = NULL;
	((SRMv2__srmPrepareToPutResponse*)this)->returnStatus = NULL;
	((SRMv2__srmPrepareToPutResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToPutResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToPutResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToPutResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToPutResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToPutResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToPutResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToPutResponse), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToPutResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToPutResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutResponse * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToPutResponse(struct soap *soap, SRMv2__srmPrepareToPutResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToPutResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToPutResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToPutResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutResponse * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToPutResponse(struct soap *soap, const char *tag, SRMv2__srmPrepareToPutResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToPutResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToPutResponse, sizeof(SRMv2__srmPrepareToPutResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToPutResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToPutResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmPrepareToPutResponse*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPrepareToPutResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPrepareToPutResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTPutRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToPutResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToPutResponse, 0, sizeof(SRMv2__srmPrepareToPutResponse), 0, soap_copy_SRMv2__srmPrepareToPutResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToPutResponse * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToPutResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToPutResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToPutResponse(struct soap *soap, SRMv2__srmPrepareToPutResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToPutResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToPutResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToPutResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutResponse;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToPutResponse);
		((SRMv2__srmPrepareToPutResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToPutResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToPutResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToPutResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToPutResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToPutResponse %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToPutResponse*)p = *(SRMv2__srmPrepareToPutResponse*)q;
}

void SRMv2__srmPrepareToPutRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmPrepareToPutRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTPutFileRequest(soap, &((SRMv2__srmPrepareToPutRequest*)this)->arrayOfFileRequests);
	soap_serialize_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, &((SRMv2__srmPrepareToPutRequest*)this)->arrayOfTransferProtocols);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__TOverwriteMode(soap, &((SRMv2__srmPrepareToPutRequest*)this)->overwriteOption);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmPrepareToPutRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmPrepareToPutRequest*)this)->totalRetryTime);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToPutRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPrepareToPutRequest*)this)->userID = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->arrayOfFileRequests = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->arrayOfTransferProtocols = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->userRequestDescription);
	((SRMv2__srmPrepareToPutRequest*)this)->overwriteOption = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->totalRetryTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToPutRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToPutRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToPutRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToPutRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToPutRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToPutRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToPutRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTPutFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->arrayOfFileRequests), "");
	soap_out_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, "arrayOfTransferProtocols", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->arrayOfTransferProtocols), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->overwriteOption), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "totalRetryTime", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->totalRetryTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToPutRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToPutRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutRequest * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToPutRequest(struct soap *soap, SRMv2__srmPrepareToPutRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToPutRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToPutRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToPutRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutRequest * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToPutRequest(struct soap *soap, const char *tag, SRMv2__srmPrepareToPutRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToPutRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToPutRequest, sizeof(SRMv2__srmPrepareToPutRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToPutRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToPutRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_arrayOfTransferProtocols1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_overwriteOption1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_totalRetryTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmPrepareToPutRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPutFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmPrepareToPutRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTPutFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_arrayOfTransferProtocols1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, "arrayOfTransferProtocols", &(((SRMv2__srmPrepareToPutRequest*)a)->arrayOfTransferProtocols), "SRMv2:ArrayOf_xsd_string"))
				{	soap_flag_arrayOfTransferProtocols1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmPrepareToPutRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_overwriteOption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", &(((SRMv2__srmPrepareToPutRequest*)a)->overwriteOption), "SRMv2:TOverwriteMode"))
				{	soap_flag_overwriteOption1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmPrepareToPutRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_totalRetryTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "totalRetryTime", &(((SRMv2__srmPrepareToPutRequest*)a)->totalRetryTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_totalRetryTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFileRequests1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToPutRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToPutRequest, 0, sizeof(SRMv2__srmPrepareToPutRequest), 0, soap_copy_SRMv2__srmPrepareToPutRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToPutRequest * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToPutRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToPutRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToPutRequest(struct soap *soap, SRMv2__srmPrepareToPutRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToPutRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToPutRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToPutRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutRequest;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToPutRequest);
		((SRMv2__srmPrepareToPutRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToPutRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToPutRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToPutRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToPutRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToPutRequest %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToPutRequest*)p = *(SRMv2__srmPrepareToPutRequest*)q;
}

void SRMv2__srmPrepareToGetResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__srmPrepareToGetResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPrepareToGetResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, &((SRMv2__srmPrepareToGetResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToGetResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPrepareToGetResponse*)this)->requestToken = NULL;
	((SRMv2__srmPrepareToGetResponse*)this)->returnStatus = NULL;
	((SRMv2__srmPrepareToGetResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToGetResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToGetResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToGetResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToGetResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToGetResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToGetResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToGetResponse), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToGetResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToGetResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetResponse * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToGetResponse(struct soap *soap, SRMv2__srmPrepareToGetResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToGetResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToGetResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToGetResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetResponse * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToGetResponse(struct soap *soap, const char *tag, SRMv2__srmPrepareToGetResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToGetResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToGetResponse, sizeof(SRMv2__srmPrepareToGetResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToGetResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToGetResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__srmPrepareToGetResponse*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPrepareToGetResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPrepareToGetResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTGetRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToGetResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToGetResponse, 0, sizeof(SRMv2__srmPrepareToGetResponse), 0, soap_copy_SRMv2__srmPrepareToGetResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToGetResponse * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToGetResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToGetResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToGetResponse(struct soap *soap, SRMv2__srmPrepareToGetResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToGetResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToGetResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToGetResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetResponse;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToGetResponse);
		((SRMv2__srmPrepareToGetResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToGetResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToGetResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToGetResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToGetResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToGetResponse %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToGetResponse*)p = *(SRMv2__srmPrepareToGetResponse*)q;
}

void SRMv2__srmPrepareToGetRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmPrepareToGetRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTGetFileRequest(soap, &((SRMv2__srmPrepareToGetRequest*)this)->arrayOfFileRequests);
	soap_serialize_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, &((SRMv2__srmPrepareToGetRequest*)this)->arrayOfTransferProtocols);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmPrepareToGetRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmPrepareToGetRequest*)this)->totalRetryTime);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToGetRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPrepareToGetRequest*)this)->userID = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->arrayOfFileRequests = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->arrayOfTransferProtocols = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->userRequestDescription);
	((SRMv2__srmPrepareToGetRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->totalRetryTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToGetRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToGetRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToGetRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToGetRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToGetRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToGetRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToGetRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTGetFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->arrayOfFileRequests), "");
	soap_out_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, "arrayOfTransferProtocols", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->arrayOfTransferProtocols), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "totalRetryTime", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->totalRetryTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToGetRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToGetRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetRequest * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToGetRequest(struct soap *soap, SRMv2__srmPrepareToGetRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToGetRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToGetRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToGetRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetRequest * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToGetRequest(struct soap *soap, const char *tag, SRMv2__srmPrepareToGetRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToGetRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToGetRequest, sizeof(SRMv2__srmPrepareToGetRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToGetRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToGetRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_arrayOfTransferProtocols1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_totalRetryTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmPrepareToGetRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmPrepareToGetRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTGetFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_arrayOfTransferProtocols1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOf_USCORExsd_USCOREstring(soap, "arrayOfTransferProtocols", &(((SRMv2__srmPrepareToGetRequest*)a)->arrayOfTransferProtocols), "SRMv2:ArrayOf_xsd_string"))
				{	soap_flag_arrayOfTransferProtocols1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmPrepareToGetRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmPrepareToGetRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_totalRetryTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "totalRetryTime", &(((SRMv2__srmPrepareToGetRequest*)a)->totalRetryTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_totalRetryTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFileRequests1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToGetRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToGetRequest, 0, sizeof(SRMv2__srmPrepareToGetRequest), 0, soap_copy_SRMv2__srmPrepareToGetRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToGetRequest * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToGetRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToGetRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToGetRequest(struct soap *soap, SRMv2__srmPrepareToGetRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToGetRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToGetRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToGetRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetRequest;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToGetRequest);
		((SRMv2__srmPrepareToGetRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToGetRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToGetRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToGetRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToGetRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToGetRequest %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToGetRequest*)p = *(SRMv2__srmPrepareToGetRequest*)q;
}

void SRMv2__srmMvResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmMvResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmMvResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmMvResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMvResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMvResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMvResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMvResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMvResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmMvResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMvResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmMvResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMvResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMvResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMvResponse * SOAP_FMAC4 soap_get_SRMv2__srmMvResponse(struct soap *soap, SRMv2__srmMvResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMvResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMvResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMvResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMvResponse * SOAP_FMAC4 soap_in_SRMv2__srmMvResponse(struct soap *soap, const char *tag, SRMv2__srmMvResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMvResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMvResponse, sizeof(SRMv2__srmMvResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMvResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMvResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmMvResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMvResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMvResponse, 0, sizeof(SRMv2__srmMvResponse), 0, soap_copy_SRMv2__srmMvResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMvResponse * SOAP_FMAC6 soap_new_SRMv2__srmMvResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMvResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMvResponse(struct soap *soap, SRMv2__srmMvResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMvResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmMvResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMvResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMvResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMvResponse;
		if (size)
			*size = sizeof(SRMv2__srmMvResponse);
		((SRMv2__srmMvResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMvResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMvResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMvResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMvResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMvResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMvResponse %p -> %p\n", q, p));
	*(SRMv2__srmMvResponse*)p = *(SRMv2__srmMvResponse*)q;
}

void SRMv2__srmMvRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmMvRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__srmMvRequest*)this)->fromPath);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__srmMvRequest*)this)->toPath);
	/* transient soap skipped */
}

void SRMv2__srmMvRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmMvRequest*)this)->userID = NULL;
	((SRMv2__srmMvRequest*)this)->fromPath = NULL;
	((SRMv2__srmMvRequest*)this)->toPath = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMvRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMvRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMvRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMvRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMvRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmMvRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMvRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmMvRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "fromPath", -1, &(((SRMv2__srmMvRequest*)a)->fromPath), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "toPath", -1, &(((SRMv2__srmMvRequest*)a)->toPath), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMvRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMvRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMvRequest * SOAP_FMAC4 soap_get_SRMv2__srmMvRequest(struct soap *soap, SRMv2__srmMvRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMvRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMvRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMvRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMvRequest * SOAP_FMAC4 soap_in_SRMv2__srmMvRequest(struct soap *soap, const char *tag, SRMv2__srmMvRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMvRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMvRequest, sizeof(SRMv2__srmMvRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMvRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMvRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_fromPath1 = 1, soap_flag_toPath1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmMvRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_fromPath1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "fromPath", &(((SRMv2__srmMvRequest*)a)->fromPath), "SRMv2:TSURLInfo"))
				{	soap_flag_fromPath1--;
					continue;
				}
			if (soap_flag_toPath1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "toPath", &(((SRMv2__srmMvRequest*)a)->toPath), "SRMv2:TSURLInfo"))
				{	soap_flag_toPath1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fromPath1 > 0 || soap_flag_toPath1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMvRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMvRequest, 0, sizeof(SRMv2__srmMvRequest), 0, soap_copy_SRMv2__srmMvRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMvRequest * SOAP_FMAC6 soap_new_SRMv2__srmMvRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMvRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMvRequest(struct soap *soap, SRMv2__srmMvRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMvRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmMvRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMvRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMvRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMvRequest;
		if (size)
			*size = sizeof(SRMv2__srmMvRequest);
		((SRMv2__srmMvRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMvRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMvRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMvRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMvRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMvRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMvRequest %p -> %p\n", q, p));
	*(SRMv2__srmMvRequest*)p = *(SRMv2__srmMvRequest*)q;
}

void SRMv2__srmLsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, &((SRMv2__srmLsResponse*)this)->details);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmLsResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmLsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmLsResponse*)this)->details = NULL;
	((SRMv2__srmLsResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmLsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmLsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmLsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmLsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmLsResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmLsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmLsResponse), type);
	soap_out_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "details", -1, &(((SRMv2__srmLsResponse*)a)->details), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmLsResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmLsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmLsResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmLsResponse * SOAP_FMAC4 soap_get_SRMv2__srmLsResponse(struct soap *soap, SRMv2__srmLsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmLsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmLsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmLsResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmLsResponse * SOAP_FMAC4 soap_in_SRMv2__srmLsResponse(struct soap *soap, const char *tag, SRMv2__srmLsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmLsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmLsResponse, sizeof(SRMv2__srmLsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmLsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmLsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_details1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_details1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "details", &(((SRMv2__srmLsResponse*)a)->details), "SRMv2:ArrayOfTMetaDataPathDetail"))
				{	soap_flag_details1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmLsResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmLsResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmLsResponse, 0, sizeof(SRMv2__srmLsResponse), 0, soap_copy_SRMv2__srmLsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmLsResponse * SOAP_FMAC6 soap_new_SRMv2__srmLsResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmLsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmLsResponse(struct soap *soap, SRMv2__srmLsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmLsResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmLsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmLsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmLsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmLsResponse;
		if (size)
			*size = sizeof(SRMv2__srmLsResponse);
		((SRMv2__srmLsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmLsResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmLsResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmLsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmLsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmLsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmLsResponse %p -> %p\n", q, p));
	*(SRMv2__srmLsResponse*)p = *(SRMv2__srmLsResponse*)q;
}

void SRMv2__srmLsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmLsRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLInfo(soap, &((SRMv2__srmLsRequest*)this)->paths);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__srmLsRequest*)this)->fileStorageType);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmLsRequest*)this)->fullDetailedList);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmLsRequest*)this)->allLevelRecursive);
	soap_serialize_PointerToint(soap, &((SRMv2__srmLsRequest*)this)->numOfLevels);
	soap_serialize_PointerToint(soap, &((SRMv2__srmLsRequest*)this)->offset);
	soap_serialize_PointerToint(soap, &((SRMv2__srmLsRequest*)this)->count);
	/* transient soap skipped */
}

void SRMv2__srmLsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmLsRequest*)this)->userID = NULL;
	((SRMv2__srmLsRequest*)this)->paths = NULL;
	((SRMv2__srmLsRequest*)this)->fileStorageType = NULL;
	((SRMv2__srmLsRequest*)this)->fullDetailedList = NULL;
	((SRMv2__srmLsRequest*)this)->allLevelRecursive = NULL;
	((SRMv2__srmLsRequest*)this)->numOfLevels = NULL;
	((SRMv2__srmLsRequest*)this)->offset = NULL;
	((SRMv2__srmLsRequest*)this)->count = NULL;
	/* transient soap skipped */
}

int SRMv2__srmLsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmLsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmLsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmLsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmLsRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmLsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmLsRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmLsRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLInfo(soap, "paths", -1, &(((SRMv2__srmLsRequest*)a)->paths), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", -1, &(((SRMv2__srmLsRequest*)a)->fileStorageType), "");
	soap_out_PointerTobool(soap, "fullDetailedList", -1, &(((SRMv2__srmLsRequest*)a)->fullDetailedList), "");
	soap_out_PointerTobool(soap, "allLevelRecursive", -1, &(((SRMv2__srmLsRequest*)a)->allLevelRecursive), "");
	soap_out_PointerToint(soap, "numOfLevels", -1, &(((SRMv2__srmLsRequest*)a)->numOfLevels), "");
	soap_out_PointerToint(soap, "offset", -1, &(((SRMv2__srmLsRequest*)a)->offset), "");
	soap_out_PointerToint(soap, "count", -1, &(((SRMv2__srmLsRequest*)a)->count), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmLsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmLsRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmLsRequest * SOAP_FMAC4 soap_get_SRMv2__srmLsRequest(struct soap *soap, SRMv2__srmLsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmLsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmLsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmLsRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmLsRequest * SOAP_FMAC4 soap_in_SRMv2__srmLsRequest(struct soap *soap, const char *tag, SRMv2__srmLsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmLsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmLsRequest, sizeof(SRMv2__srmLsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmLsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmLsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_paths1 = 1, soap_flag_fileStorageType1 = 1, soap_flag_fullDetailedList1 = 1, soap_flag_allLevelRecursive1 = 1, soap_flag_numOfLevels1 = 1, soap_flag_offset1 = 1, soap_flag_count1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmLsRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_paths1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLInfo(soap, "paths", &(((SRMv2__srmLsRequest*)a)->paths), "SRMv2:ArrayOfTSURLInfo"))
				{	soap_flag_paths1--;
					continue;
				}
			if (soap_flag_fileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", &(((SRMv2__srmLsRequest*)a)->fileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_fileStorageType1--;
					continue;
				}
			if (soap_flag_fullDetailedList1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "fullDetailedList", &(((SRMv2__srmLsRequest*)a)->fullDetailedList), "xsd:boolean"))
				{	soap_flag_fullDetailedList1--;
					continue;
				}
			if (soap_flag_allLevelRecursive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "allLevelRecursive", &(((SRMv2__srmLsRequest*)a)->allLevelRecursive), "xsd:boolean"))
				{	soap_flag_allLevelRecursive1--;
					continue;
				}
			if (soap_flag_numOfLevels1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "numOfLevels", &(((SRMv2__srmLsRequest*)a)->numOfLevels), "xsd:int"))
				{	soap_flag_numOfLevels1--;
					continue;
				}
			if (soap_flag_offset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "offset", &(((SRMv2__srmLsRequest*)a)->offset), "xsd:int"))
				{	soap_flag_offset1--;
					continue;
				}
			if (soap_flag_count1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "count", &(((SRMv2__srmLsRequest*)a)->count), "xsd:int"))
				{	soap_flag_count1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_paths1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmLsRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmLsRequest, 0, sizeof(SRMv2__srmLsRequest), 0, soap_copy_SRMv2__srmLsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmLsRequest * SOAP_FMAC6 soap_new_SRMv2__srmLsRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmLsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmLsRequest(struct soap *soap, SRMv2__srmLsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmLsRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmLsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmLsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmLsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmLsRequest;
		if (size)
			*size = sizeof(SRMv2__srmLsRequest);
		((SRMv2__srmLsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmLsRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmLsRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmLsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmLsRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmLsRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmLsRequest %p -> %p\n", q, p));
	*(SRMv2__srmLsRequest*)p = *(SRMv2__srmLsRequest*)q;
}

void SRMv2__srmRmResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmRmResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmRmResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmRmResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRmResponse*)this)->returnStatus = NULL;
	((SRMv2__srmRmResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmRmResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmRmResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmRmResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmResponse * SOAP_FMAC4 soap_get_SRMv2__srmRmResponse(struct soap *soap, SRMv2__srmRmResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmResponse * SOAP_FMAC4 soap_in_SRMv2__srmRmResponse(struct soap *soap, const char *tag, SRMv2__srmRmResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmResponse, sizeof(SRMv2__srmRmResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmRmResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmRmResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmResponse, 0, sizeof(SRMv2__srmRmResponse), 0, soap_copy_SRMv2__srmRmResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmResponse * SOAP_FMAC6 soap_new_SRMv2__srmRmResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmResponse(struct soap *soap, SRMv2__srmRmResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmResponse;
		if (size)
			*size = sizeof(SRMv2__srmRmResponse);
		((SRMv2__srmRmResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmResponse %p -> %p\n", q, p));
	*(SRMv2__srmRmResponse*)p = *(SRMv2__srmRmResponse*)q;
}

void SRMv2__srmRmRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmRmRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLInfo(soap, &((SRMv2__srmRmRequest*)this)->arrayOfFilePaths);
	/* transient soap skipped */
}

void SRMv2__srmRmRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRmRequest*)this)->userID = NULL;
	((SRMv2__srmRmRequest*)this)->arrayOfFilePaths = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmRmRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmRmRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLInfo(soap, "arrayOfFilePaths", -1, &(((SRMv2__srmRmRequest*)a)->arrayOfFilePaths), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmRequest * SOAP_FMAC4 soap_get_SRMv2__srmRmRequest(struct soap *soap, SRMv2__srmRmRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmRequest * SOAP_FMAC4 soap_in_SRMv2__srmRmRequest(struct soap *soap, const char *tag, SRMv2__srmRmRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmRequest, sizeof(SRMv2__srmRmRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_arrayOfFilePaths1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmRmRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfFilePaths1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLInfo(soap, "arrayOfFilePaths", &(((SRMv2__srmRmRequest*)a)->arrayOfFilePaths), "SRMv2:ArrayOfTSURLInfo"))
				{	soap_flag_arrayOfFilePaths1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFilePaths1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmRequest, 0, sizeof(SRMv2__srmRmRequest), 0, soap_copy_SRMv2__srmRmRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmRequest * SOAP_FMAC6 soap_new_SRMv2__srmRmRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmRequest(struct soap *soap, SRMv2__srmRmRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmRequest;
		if (size)
			*size = sizeof(SRMv2__srmRmRequest);
		((SRMv2__srmRmRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmRequest %p -> %p\n", q, p));
	*(SRMv2__srmRmRequest*)p = *(SRMv2__srmRmRequest*)q;
}

void SRMv2__srmRmdirResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmRmdirResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmRmdirResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRmdirResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmdirResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmdirResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmdirResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmdirResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmdirResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmRmdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmdirResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmRmdirResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmdirResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmdirResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmdirResponse * SOAP_FMAC4 soap_get_SRMv2__srmRmdirResponse(struct soap *soap, SRMv2__srmRmdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmdirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmdirResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmdirResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmdirResponse * SOAP_FMAC4 soap_in_SRMv2__srmRmdirResponse(struct soap *soap, const char *tag, SRMv2__srmRmdirResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmdirResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmdirResponse, sizeof(SRMv2__srmRmdirResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmdirResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmdirResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmRmdirResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmdirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmdirResponse, 0, sizeof(SRMv2__srmRmdirResponse), 0, soap_copy_SRMv2__srmRmdirResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmdirResponse * SOAP_FMAC6 soap_new_SRMv2__srmRmdirResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmdirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmdirResponse(struct soap *soap, SRMv2__srmRmdirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmdirResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmdirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmdirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmdirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmdirResponse;
		if (size)
			*size = sizeof(SRMv2__srmRmdirResponse);
		((SRMv2__srmRmdirResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmdirResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmdirResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmdirResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmdirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmdirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmdirResponse %p -> %p\n", q, p));
	*(SRMv2__srmRmdirResponse*)p = *(SRMv2__srmRmdirResponse*)q;
}

void SRMv2__srmRmdirRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmRmdirRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__srmRmdirRequest*)this)->directoryPath);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmRmdirRequest*)this)->recursive);
	/* transient soap skipped */
}

void SRMv2__srmRmdirRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRmdirRequest*)this)->userID = NULL;
	((SRMv2__srmRmdirRequest*)this)->directoryPath = NULL;
	((SRMv2__srmRmdirRequest*)this)->recursive = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmdirRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmdirRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmdirRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmdirRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmdirRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmRmdirRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmdirRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmRmdirRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "directoryPath", -1, &(((SRMv2__srmRmdirRequest*)a)->directoryPath), "");
	soap_out_PointerTobool(soap, "recursive", -1, &(((SRMv2__srmRmdirRequest*)a)->recursive), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmdirRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmdirRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmdirRequest * SOAP_FMAC4 soap_get_SRMv2__srmRmdirRequest(struct soap *soap, SRMv2__srmRmdirRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmdirRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmdirRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmdirRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmdirRequest * SOAP_FMAC4 soap_in_SRMv2__srmRmdirRequest(struct soap *soap, const char *tag, SRMv2__srmRmdirRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmdirRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmdirRequest, sizeof(SRMv2__srmRmdirRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmdirRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmdirRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_directoryPath1 = 1, soap_flag_recursive1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmRmdirRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_directoryPath1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "directoryPath", &(((SRMv2__srmRmdirRequest*)a)->directoryPath), "SRMv2:TSURLInfo"))
				{	soap_flag_directoryPath1--;
					continue;
				}
			if (soap_flag_recursive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "recursive", &(((SRMv2__srmRmdirRequest*)a)->recursive), "xsd:boolean"))
				{	soap_flag_recursive1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_directoryPath1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmdirRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmdirRequest, 0, sizeof(SRMv2__srmRmdirRequest), 0, soap_copy_SRMv2__srmRmdirRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmdirRequest * SOAP_FMAC6 soap_new_SRMv2__srmRmdirRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmdirRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmdirRequest(struct soap *soap, SRMv2__srmRmdirRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmdirRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmdirRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmdirRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmdirRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmdirRequest;
		if (size)
			*size = sizeof(SRMv2__srmRmdirRequest);
		((SRMv2__srmRmdirRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmdirRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmdirRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmdirRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmdirRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmdirRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmdirRequest %p -> %p\n", q, p));
	*(SRMv2__srmRmdirRequest*)p = *(SRMv2__srmRmdirRequest*)q;
}

void SRMv2__srmMkdirResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmMkdirResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmMkdirResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmMkdirResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMkdirResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMkdirResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMkdirResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMkdirResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMkdirResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmMkdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMkdirResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmMkdirResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMkdirResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMkdirResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMkdirResponse * SOAP_FMAC4 soap_get_SRMv2__srmMkdirResponse(struct soap *soap, SRMv2__srmMkdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMkdirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMkdirResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMkdirResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMkdirResponse * SOAP_FMAC4 soap_in_SRMv2__srmMkdirResponse(struct soap *soap, const char *tag, SRMv2__srmMkdirResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMkdirResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMkdirResponse, sizeof(SRMv2__srmMkdirResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMkdirResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMkdirResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmMkdirResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMkdirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMkdirResponse, 0, sizeof(SRMv2__srmMkdirResponse), 0, soap_copy_SRMv2__srmMkdirResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMkdirResponse * SOAP_FMAC6 soap_new_SRMv2__srmMkdirResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMkdirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMkdirResponse(struct soap *soap, SRMv2__srmMkdirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMkdirResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmMkdirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMkdirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMkdirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMkdirResponse;
		if (size)
			*size = sizeof(SRMv2__srmMkdirResponse);
		((SRMv2__srmMkdirResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMkdirResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMkdirResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMkdirResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMkdirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMkdirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMkdirResponse %p -> %p\n", q, p));
	*(SRMv2__srmMkdirResponse*)p = *(SRMv2__srmMkdirResponse*)q;
}

void SRMv2__srmMkdirRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmMkdirRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__srmMkdirRequest*)this)->directoryPath);
	/* transient soap skipped */
}

void SRMv2__srmMkdirRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmMkdirRequest*)this)->userID = NULL;
	((SRMv2__srmMkdirRequest*)this)->directoryPath = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMkdirRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMkdirRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMkdirRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMkdirRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMkdirRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmMkdirRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMkdirRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmMkdirRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "directoryPath", -1, &(((SRMv2__srmMkdirRequest*)a)->directoryPath), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMkdirRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMkdirRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMkdirRequest * SOAP_FMAC4 soap_get_SRMv2__srmMkdirRequest(struct soap *soap, SRMv2__srmMkdirRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMkdirRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMkdirRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMkdirRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMkdirRequest * SOAP_FMAC4 soap_in_SRMv2__srmMkdirRequest(struct soap *soap, const char *tag, SRMv2__srmMkdirRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMkdirRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMkdirRequest, sizeof(SRMv2__srmMkdirRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMkdirRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMkdirRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_directoryPath1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmMkdirRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_directoryPath1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "directoryPath", &(((SRMv2__srmMkdirRequest*)a)->directoryPath), "SRMv2:TSURLInfo"))
				{	soap_flag_directoryPath1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_directoryPath1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMkdirRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMkdirRequest, 0, sizeof(SRMv2__srmMkdirRequest), 0, soap_copy_SRMv2__srmMkdirRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMkdirRequest * SOAP_FMAC6 soap_new_SRMv2__srmMkdirRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMkdirRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMkdirRequest(struct soap *soap, SRMv2__srmMkdirRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMkdirRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmMkdirRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMkdirRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMkdirRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMkdirRequest;
		if (size)
			*size = sizeof(SRMv2__srmMkdirRequest);
		((SRMv2__srmMkdirRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMkdirRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMkdirRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMkdirRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMkdirRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMkdirRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMkdirRequest %p -> %p\n", q, p));
	*(SRMv2__srmMkdirRequest*)p = *(SRMv2__srmMkdirRequest*)q;
}

void SRMv2__srmCheckPermissionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, &((SRMv2__srmCheckPermissionResponse*)this)->arrayOfPermissions);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmCheckPermissionResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmCheckPermissionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCheckPermissionResponse*)this)->arrayOfPermissions = NULL;
	((SRMv2__srmCheckPermissionResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCheckPermissionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCheckPermissionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCheckPermissionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCheckPermissionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCheckPermissionResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmCheckPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCheckPermissionResponse), type);
	soap_out_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, "arrayOfPermissions", -1, &(((SRMv2__srmCheckPermissionResponse*)a)->arrayOfPermissions), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmCheckPermissionResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCheckPermissionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCheckPermissionResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionResponse * SOAP_FMAC4 soap_get_SRMv2__srmCheckPermissionResponse(struct soap *soap, SRMv2__srmCheckPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCheckPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCheckPermissionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCheckPermissionResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionResponse * SOAP_FMAC4 soap_in_SRMv2__srmCheckPermissionResponse(struct soap *soap, const char *tag, SRMv2__srmCheckPermissionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCheckPermissionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCheckPermissionResponse, sizeof(SRMv2__srmCheckPermissionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCheckPermissionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCheckPermissionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfPermissions1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, "arrayOfPermissions", &(((SRMv2__srmCheckPermissionResponse*)a)->arrayOfPermissions), "SRMv2:ArrayOfTSURLPermissionReturn"))
				{	soap_flag_arrayOfPermissions1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmCheckPermissionResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCheckPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCheckPermissionResponse, 0, sizeof(SRMv2__srmCheckPermissionResponse), 0, soap_copy_SRMv2__srmCheckPermissionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCheckPermissionResponse * SOAP_FMAC6 soap_new_SRMv2__srmCheckPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCheckPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCheckPermissionResponse(struct soap *soap, SRMv2__srmCheckPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmCheckPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCheckPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCheckPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionResponse;
		if (size)
			*size = sizeof(SRMv2__srmCheckPermissionResponse);
		((SRMv2__srmCheckPermissionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCheckPermissionResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCheckPermissionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCheckPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCheckPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCheckPermissionResponse %p -> %p\n", q, p));
	*(SRMv2__srmCheckPermissionResponse*)p = *(SRMv2__srmCheckPermissionResponse*)q;
}

void SRMv2__srmCheckPermissionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTSURLInfo(soap, &((SRMv2__srmCheckPermissionRequest*)this)->arrayOfSiteURLs);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmCheckPermissionRequest*)this)->userID);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmCheckPermissionRequest*)this)->checkInLocalCacheOnly);
	/* transient soap skipped */
}

void SRMv2__srmCheckPermissionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCheckPermissionRequest*)this)->arrayOfSiteURLs = NULL;
	((SRMv2__srmCheckPermissionRequest*)this)->userID = NULL;
	((SRMv2__srmCheckPermissionRequest*)this)->checkInLocalCacheOnly = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCheckPermissionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCheckPermissionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCheckPermissionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCheckPermissionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCheckPermissionRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmCheckPermissionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCheckPermissionRequest), type);
	soap_out_PointerToSRMv2__ArrayOfTSURLInfo(soap, "arrayOfSiteURLs", -1, &(((SRMv2__srmCheckPermissionRequest*)a)->arrayOfSiteURLs), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmCheckPermissionRequest*)a)->userID), "");
	soap_out_PointerTobool(soap, "checkInLocalCacheOnly", -1, &(((SRMv2__srmCheckPermissionRequest*)a)->checkInLocalCacheOnly), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCheckPermissionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCheckPermissionRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionRequest * SOAP_FMAC4 soap_get_SRMv2__srmCheckPermissionRequest(struct soap *soap, SRMv2__srmCheckPermissionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCheckPermissionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCheckPermissionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCheckPermissionRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionRequest * SOAP_FMAC4 soap_in_SRMv2__srmCheckPermissionRequest(struct soap *soap, const char *tag, SRMv2__srmCheckPermissionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCheckPermissionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCheckPermissionRequest, sizeof(SRMv2__srmCheckPermissionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCheckPermissionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCheckPermissionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfSiteURLs1 = 1, soap_flag_userID1 = 1, soap_flag_checkInLocalCacheOnly1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfSiteURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLInfo(soap, "arrayOfSiteURLs", &(((SRMv2__srmCheckPermissionRequest*)a)->arrayOfSiteURLs), "SRMv2:ArrayOfTSURLInfo"))
				{	soap_flag_arrayOfSiteURLs1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmCheckPermissionRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_checkInLocalCacheOnly1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "checkInLocalCacheOnly", &(((SRMv2__srmCheckPermissionRequest*)a)->checkInLocalCacheOnly), "xsd:boolean"))
				{	soap_flag_checkInLocalCacheOnly1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSiteURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCheckPermissionRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCheckPermissionRequest, 0, sizeof(SRMv2__srmCheckPermissionRequest), 0, soap_copy_SRMv2__srmCheckPermissionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCheckPermissionRequest * SOAP_FMAC6 soap_new_SRMv2__srmCheckPermissionRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCheckPermissionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCheckPermissionRequest(struct soap *soap, SRMv2__srmCheckPermissionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmCheckPermissionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCheckPermissionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCheckPermissionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionRequest;
		if (size)
			*size = sizeof(SRMv2__srmCheckPermissionRequest);
		((SRMv2__srmCheckPermissionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCheckPermissionRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCheckPermissionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCheckPermissionRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCheckPermissionRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCheckPermissionRequest %p -> %p\n", q, p));
	*(SRMv2__srmCheckPermissionRequest*)p = *(SRMv2__srmCheckPermissionRequest*)q;
}

void SRMv2__srmReassignToUserResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReassignToUserResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmReassignToUserResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReassignToUserResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReassignToUserResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReassignToUserResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReassignToUserResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReassignToUserResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReassignToUserResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReassignToUserResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReassignToUserResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReassignToUserResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReassignToUserResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReassignToUserResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReassignToUserResponse * SOAP_FMAC4 soap_get_SRMv2__srmReassignToUserResponse(struct soap *soap, SRMv2__srmReassignToUserResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReassignToUserResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReassignToUserResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReassignToUserResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReassignToUserResponse * SOAP_FMAC4 soap_in_SRMv2__srmReassignToUserResponse(struct soap *soap, const char *tag, SRMv2__srmReassignToUserResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReassignToUserResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReassignToUserResponse, sizeof(SRMv2__srmReassignToUserResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReassignToUserResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReassignToUserResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReassignToUserResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReassignToUserResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReassignToUserResponse, 0, sizeof(SRMv2__srmReassignToUserResponse), 0, soap_copy_SRMv2__srmReassignToUserResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReassignToUserResponse * SOAP_FMAC6 soap_new_SRMv2__srmReassignToUserResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReassignToUserResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReassignToUserResponse(struct soap *soap, SRMv2__srmReassignToUserResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReassignToUserResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReassignToUserResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReassignToUserResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReassignToUserResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReassignToUserResponse;
		if (size)
			*size = sizeof(SRMv2__srmReassignToUserResponse);
		((SRMv2__srmReassignToUserResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReassignToUserResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReassignToUserResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReassignToUserResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReassignToUserResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReassignToUserResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReassignToUserResponse %p -> %p\n", q, p));
	*(SRMv2__srmReassignToUserResponse*)p = *(SRMv2__srmReassignToUserResponse*)q;
}

void SRMv2__srmReassignToUserRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmReassignToUserRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmReassignToUserRequest*)this)->assignedUser);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmReassignToUserRequest*)this)->lifeTimeOfThisAssignment);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__srmReassignToUserRequest*)this)->path);
	/* transient soap skipped */
}

void SRMv2__srmReassignToUserRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReassignToUserRequest*)this)->userID = NULL;
	((SRMv2__srmReassignToUserRequest*)this)->assignedUser = NULL;
	((SRMv2__srmReassignToUserRequest*)this)->lifeTimeOfThisAssignment = NULL;
	((SRMv2__srmReassignToUserRequest*)this)->path = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReassignToUserRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReassignToUserRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReassignToUserRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReassignToUserRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReassignToUserRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReassignToUserRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReassignToUserRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmReassignToUserRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TUserID(soap, "assignedUser", -1, &(((SRMv2__srmReassignToUserRequest*)a)->assignedUser), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifeTimeOfThisAssignment", -1, &(((SRMv2__srmReassignToUserRequest*)a)->lifeTimeOfThisAssignment), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "path", -1, &(((SRMv2__srmReassignToUserRequest*)a)->path), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReassignToUserRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReassignToUserRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReassignToUserRequest * SOAP_FMAC4 soap_get_SRMv2__srmReassignToUserRequest(struct soap *soap, SRMv2__srmReassignToUserRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReassignToUserRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReassignToUserRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReassignToUserRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReassignToUserRequest * SOAP_FMAC4 soap_in_SRMv2__srmReassignToUserRequest(struct soap *soap, const char *tag, SRMv2__srmReassignToUserRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReassignToUserRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReassignToUserRequest, sizeof(SRMv2__srmReassignToUserRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReassignToUserRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReassignToUserRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_assignedUser1 = 1, soap_flag_lifeTimeOfThisAssignment1 = 1, soap_flag_path1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmReassignToUserRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_assignedUser1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "assignedUser", &(((SRMv2__srmReassignToUserRequest*)a)->assignedUser), "SRMv2:TUserID"))
				{	soap_flag_assignedUser1--;
					continue;
				}
			if (soap_flag_lifeTimeOfThisAssignment1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifeTimeOfThisAssignment", &(((SRMv2__srmReassignToUserRequest*)a)->lifeTimeOfThisAssignment), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifeTimeOfThisAssignment1--;
					continue;
				}
			if (soap_flag_path1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "path", &(((SRMv2__srmReassignToUserRequest*)a)->path), "SRMv2:TSURLInfo"))
				{	soap_flag_path1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_assignedUser1 > 0 || soap_flag_lifeTimeOfThisAssignment1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReassignToUserRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReassignToUserRequest, 0, sizeof(SRMv2__srmReassignToUserRequest), 0, soap_copy_SRMv2__srmReassignToUserRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReassignToUserRequest * SOAP_FMAC6 soap_new_SRMv2__srmReassignToUserRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReassignToUserRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReassignToUserRequest(struct soap *soap, SRMv2__srmReassignToUserRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReassignToUserRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReassignToUserRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReassignToUserRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReassignToUserRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReassignToUserRequest;
		if (size)
			*size = sizeof(SRMv2__srmReassignToUserRequest);
		((SRMv2__srmReassignToUserRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReassignToUserRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReassignToUserRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReassignToUserRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReassignToUserRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReassignToUserRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReassignToUserRequest %p -> %p\n", q, p));
	*(SRMv2__srmReassignToUserRequest*)p = *(SRMv2__srmReassignToUserRequest*)q;
}

void SRMv2__srmSetPermissionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmSetPermissionResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmSetPermissionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmSetPermissionResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSetPermissionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSetPermissionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSetPermissionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSetPermissionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSetPermissionResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmSetPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSetPermissionResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmSetPermissionResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSetPermissionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSetPermissionResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionResponse * SOAP_FMAC4 soap_get_SRMv2__srmSetPermissionResponse(struct soap *soap, SRMv2__srmSetPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSetPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSetPermissionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSetPermissionResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionResponse * SOAP_FMAC4 soap_in_SRMv2__srmSetPermissionResponse(struct soap *soap, const char *tag, SRMv2__srmSetPermissionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSetPermissionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSetPermissionResponse, sizeof(SRMv2__srmSetPermissionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSetPermissionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSetPermissionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmSetPermissionResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSetPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSetPermissionResponse, 0, sizeof(SRMv2__srmSetPermissionResponse), 0, soap_copy_SRMv2__srmSetPermissionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSetPermissionResponse * SOAP_FMAC6 soap_new_SRMv2__srmSetPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSetPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSetPermissionResponse(struct soap *soap, SRMv2__srmSetPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSetPermissionResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmSetPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSetPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSetPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionResponse;
		if (size)
			*size = sizeof(SRMv2__srmSetPermissionResponse);
		((SRMv2__srmSetPermissionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSetPermissionResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSetPermissionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSetPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSetPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSetPermissionResponse %p -> %p\n", q, p));
	*(SRMv2__srmSetPermissionResponse*)p = *(SRMv2__srmSetPermissionResponse*)q;
}

void SRMv2__srmSetPermissionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmSetPermissionRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__srmSetPermissionRequest*)this)->path);
	soap_embedded(soap, &((SRMv2__srmSetPermissionRequest*)this)->permissionType, SOAP_TYPE_SRMv2__TPermissionType);
	soap_serialize_PointerToSRMv2__TOwnerPermission(soap, &((SRMv2__srmSetPermissionRequest*)this)->ownerPermission);
	soap_serialize_PointerToSRMv2__ArrayOfTUserPermission(soap, &((SRMv2__srmSetPermissionRequest*)this)->userPermission);
	soap_serialize_PointerToSRMv2__ArrayOfTGroupPermission(soap, &((SRMv2__srmSetPermissionRequest*)this)->groupPermission);
	soap_serialize_PointerToSRMv2__TOtherPermission(soap, &((SRMv2__srmSetPermissionRequest*)this)->otherPermission);
	/* transient soap skipped */
}

void SRMv2__srmSetPermissionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmSetPermissionRequest*)this)->userID = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->path = NULL;
	soap_default_SRMv2__TPermissionType(soap, &((SRMv2__srmSetPermissionRequest*)this)->permissionType);
	((SRMv2__srmSetPermissionRequest*)this)->ownerPermission = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->userPermission = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->groupPermission = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->otherPermission = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSetPermissionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSetPermissionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSetPermissionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSetPermissionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSetPermissionRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmSetPermissionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSetPermissionRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmSetPermissionRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "path", -1, &(((SRMv2__srmSetPermissionRequest*)a)->path), "");
	soap_out_SRMv2__TPermissionType(soap, "permissionType", -1, &(((SRMv2__srmSetPermissionRequest*)a)->permissionType), "");
	soap_out_PointerToSRMv2__TOwnerPermission(soap, "ownerPermission", -1, &(((SRMv2__srmSetPermissionRequest*)a)->ownerPermission), "");
	soap_out_PointerToSRMv2__ArrayOfTUserPermission(soap, "userPermission", -1, &(((SRMv2__srmSetPermissionRequest*)a)->userPermission), "");
	soap_out_PointerToSRMv2__ArrayOfTGroupPermission(soap, "groupPermission", -1, &(((SRMv2__srmSetPermissionRequest*)a)->groupPermission), "");
	soap_out_PointerToSRMv2__TOtherPermission(soap, "otherPermission", -1, &(((SRMv2__srmSetPermissionRequest*)a)->otherPermission), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSetPermissionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSetPermissionRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionRequest * SOAP_FMAC4 soap_get_SRMv2__srmSetPermissionRequest(struct soap *soap, SRMv2__srmSetPermissionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSetPermissionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSetPermissionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSetPermissionRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionRequest * SOAP_FMAC4 soap_in_SRMv2__srmSetPermissionRequest(struct soap *soap, const char *tag, SRMv2__srmSetPermissionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSetPermissionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSetPermissionRequest, sizeof(SRMv2__srmSetPermissionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSetPermissionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSetPermissionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_path1 = 1, soap_flag_permissionType1 = 1, soap_flag_ownerPermission1 = 1, soap_flag_userPermission1 = 1, soap_flag_groupPermission1 = 1, soap_flag_otherPermission1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmSetPermissionRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_path1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "path", &(((SRMv2__srmSetPermissionRequest*)a)->path), "SRMv2:TSURLInfo"))
				{	soap_flag_path1--;
					continue;
				}
			if (soap_flag_permissionType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TPermissionType(soap, "permissionType", &(((SRMv2__srmSetPermissionRequest*)a)->permissionType), "SRMv2:TPermissionType"))
				{	soap_flag_permissionType1--;
					continue;
				}
			if (soap_flag_ownerPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOwnerPermission(soap, "ownerPermission", &(((SRMv2__srmSetPermissionRequest*)a)->ownerPermission), "SRMv2:TOwnerPermission"))
				{	soap_flag_ownerPermission1--;
					continue;
				}
			if (soap_flag_userPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTUserPermission(soap, "userPermission", &(((SRMv2__srmSetPermissionRequest*)a)->userPermission), "SRMv2:ArrayOfTUserPermission"))
				{	soap_flag_userPermission1--;
					continue;
				}
			if (soap_flag_groupPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGroupPermission(soap, "groupPermission", &(((SRMv2__srmSetPermissionRequest*)a)->groupPermission), "SRMv2:ArrayOfTGroupPermission"))
				{	soap_flag_groupPermission1--;
					continue;
				}
			if (soap_flag_otherPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOtherPermission(soap, "otherPermission", &(((SRMv2__srmSetPermissionRequest*)a)->otherPermission), "SRMv2:TOtherPermission"))
				{	soap_flag_otherPermission1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_path1 > 0 || soap_flag_permissionType1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSetPermissionRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSetPermissionRequest, 0, sizeof(SRMv2__srmSetPermissionRequest), 0, soap_copy_SRMv2__srmSetPermissionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSetPermissionRequest * SOAP_FMAC6 soap_new_SRMv2__srmSetPermissionRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSetPermissionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSetPermissionRequest(struct soap *soap, SRMv2__srmSetPermissionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSetPermissionRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmSetPermissionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSetPermissionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSetPermissionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionRequest;
		if (size)
			*size = sizeof(SRMv2__srmSetPermissionRequest);
		((SRMv2__srmSetPermissionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSetPermissionRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSetPermissionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSetPermissionRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSetPermissionRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSetPermissionRequest %p -> %p\n", q, p));
	*(SRMv2__srmSetPermissionRequest*)p = *(SRMv2__srmSetPermissionRequest*)q;
}

void SRMv2__srmGetSpaceTokenResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTSpaceToken(soap, &((SRMv2__srmGetSpaceTokenResponse*)this)->arrayOfPossibleSpaceTokens);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetSpaceTokenResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceTokenResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetSpaceTokenResponse*)this)->arrayOfPossibleSpaceTokens = NULL;
	((SRMv2__srmGetSpaceTokenResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceTokenResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceTokenResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceTokenResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceTokenResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse), type);
	soap_out_PointerToSRMv2__ArrayOfTSpaceToken(soap, "arrayOfPossibleSpaceTokens", -1, &(((SRMv2__srmGetSpaceTokenResponse*)a)->arrayOfPossibleSpaceTokens), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetSpaceTokenResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceTokenResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceTokenResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokenResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, SRMv2__srmGetSpaceTokenResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceTokenResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceTokenResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceTokenResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokenResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, const char *tag, SRMv2__srmGetSpaceTokenResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceTokenResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse, sizeof(SRMv2__srmGetSpaceTokenResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceTokenResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfPossibleSpaceTokens1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfPossibleSpaceTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSpaceToken(soap, "arrayOfPossibleSpaceTokens", &(((SRMv2__srmGetSpaceTokenResponse*)a)->arrayOfPossibleSpaceTokens), "SRMv2:ArrayOfTSpaceToken"))
				{	soap_flag_arrayOfPossibleSpaceTokens1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetSpaceTokenResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceTokenResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse, 0, sizeof(SRMv2__srmGetSpaceTokenResponse), 0, soap_copy_SRMv2__srmGetSpaceTokenResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceTokenResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceTokenResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, SRMv2__srmGetSpaceTokenResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokenResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceTokenResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceTokenResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokenResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceTokenResponse);
		((SRMv2__srmGetSpaceTokenResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokenResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceTokenResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceTokenResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceTokenResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceTokenResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceTokenResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceTokenResponse*)p = *(SRMv2__srmGetSpaceTokenResponse*)q;
}

void SRMv2__srmGetSpaceTokenRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmGetSpaceTokenRequest*)this)->userID);
	soap_serialize_string(soap, &((SRMv2__srmGetSpaceTokenRequest*)this)->userSpaceTokenDescription);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceTokenRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetSpaceTokenRequest*)this)->userID = NULL;
	soap_default_string(soap, &((SRMv2__srmGetSpaceTokenRequest*)this)->userSpaceTokenDescription);
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceTokenRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceTokenRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceTokenRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceTokenRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmGetSpaceTokenRequest*)a)->userID), "");
	soap_out_string(soap, "userSpaceTokenDescription", -1, &(((SRMv2__srmGetSpaceTokenRequest*)a)->userSpaceTokenDescription), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceTokenRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceTokenRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokenRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, SRMv2__srmGetSpaceTokenRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceTokenRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceTokenRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceTokenRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokenRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, const char *tag, SRMv2__srmGetSpaceTokenRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceTokenRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest, sizeof(SRMv2__srmGetSpaceTokenRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceTokenRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_userSpaceTokenDescription1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmGetSpaceTokenRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_userSpaceTokenDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userSpaceTokenDescription", &(((SRMv2__srmGetSpaceTokenRequest*)a)->userSpaceTokenDescription), "xsd:string"))
				{	soap_flag_userSpaceTokenDescription1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_userSpaceTokenDescription1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceTokenRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest, 0, sizeof(SRMv2__srmGetSpaceTokenRequest), 0, soap_copy_SRMv2__srmGetSpaceTokenRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceTokenRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceTokenRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, SRMv2__srmGetSpaceTokenRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokenRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceTokenRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceTokenRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokenRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceTokenRequest);
		((SRMv2__srmGetSpaceTokenRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokenRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceTokenRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceTokenRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceTokenRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceTokenRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceTokenRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceTokenRequest*)p = *(SRMv2__srmGetSpaceTokenRequest*)q;
}

void SRMv2__srmChangeFileStorageTypeResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmChangeFileStorageTypeResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmChangeFileStorageTypeResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmChangeFileStorageTypeResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmChangeFileStorageTypeResponse*)this)->returnStatus = NULL;
	((SRMv2__srmChangeFileStorageTypeResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmChangeFileStorageTypeResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmChangeFileStorageTypeResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmChangeFileStorageTypeResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmChangeFileStorageTypeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmChangeFileStorageTypeResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmChangeFileStorageTypeResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmChangeFileStorageTypeResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmChangeFileStorageTypeResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmChangeFileStorageTypeResponse * SOAP_FMAC4 soap_get_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, SRMv2__srmChangeFileStorageTypeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmChangeFileStorageTypeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmChangeFileStorageTypeResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmChangeFileStorageTypeResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmChangeFileStorageTypeResponse * SOAP_FMAC4 soap_in_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, const char *tag, SRMv2__srmChangeFileStorageTypeResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmChangeFileStorageTypeResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse, sizeof(SRMv2__srmChangeFileStorageTypeResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmChangeFileStorageTypeResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmChangeFileStorageTypeResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmChangeFileStorageTypeResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmChangeFileStorageTypeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse, 0, sizeof(SRMv2__srmChangeFileStorageTypeResponse), 0, soap_copy_SRMv2__srmChangeFileStorageTypeResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmChangeFileStorageTypeResponse * SOAP_FMAC6 soap_new_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmChangeFileStorageTypeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, SRMv2__srmChangeFileStorageTypeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmChangeFileStorageTypeResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmChangeFileStorageTypeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmChangeFileStorageTypeResponse;
		if (size)
			*size = sizeof(SRMv2__srmChangeFileStorageTypeResponse);
		((SRMv2__srmChangeFileStorageTypeResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmChangeFileStorageTypeResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmChangeFileStorageTypeResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmChangeFileStorageTypeResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmChangeFileStorageTypeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmChangeFileStorageTypeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmChangeFileStorageTypeResponse %p -> %p\n", q, p));
	*(SRMv2__srmChangeFileStorageTypeResponse*)p = *(SRMv2__srmChangeFileStorageTypeResponse*)q;
}

void SRMv2__srmChangeFileStorageTypeRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmChangeFileStorageTypeRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLInfo(soap, &((SRMv2__srmChangeFileStorageTypeRequest*)this)->arrayOfPaths);
	soap_embedded(soap, &((SRMv2__srmChangeFileStorageTypeRequest*)this)->desiredStorageType, SOAP_TYPE_SRMv2__TFileStorageType);
	/* transient soap skipped */
}

void SRMv2__srmChangeFileStorageTypeRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmChangeFileStorageTypeRequest*)this)->userID = NULL;
	((SRMv2__srmChangeFileStorageTypeRequest*)this)->arrayOfPaths = NULL;
	soap_default_SRMv2__TFileStorageType(soap, &((SRMv2__srmChangeFileStorageTypeRequest*)this)->desiredStorageType);
	/* transient soap skipped */
}

int SRMv2__srmChangeFileStorageTypeRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmChangeFileStorageTypeRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmChangeFileStorageTypeRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmChangeFileStorageTypeRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmChangeFileStorageTypeRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLInfo(soap, "arrayOfPaths", -1, &(((SRMv2__srmChangeFileStorageTypeRequest*)a)->arrayOfPaths), "");
	soap_out_SRMv2__TFileStorageType(soap, "desiredStorageType", -1, &(((SRMv2__srmChangeFileStorageTypeRequest*)a)->desiredStorageType), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmChangeFileStorageTypeRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmChangeFileStorageTypeRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmChangeFileStorageTypeRequest * SOAP_FMAC4 soap_get_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, SRMv2__srmChangeFileStorageTypeRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmChangeFileStorageTypeRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmChangeFileStorageTypeRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmChangeFileStorageTypeRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmChangeFileStorageTypeRequest * SOAP_FMAC4 soap_in_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, const char *tag, SRMv2__srmChangeFileStorageTypeRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmChangeFileStorageTypeRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest, sizeof(SRMv2__srmChangeFileStorageTypeRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmChangeFileStorageTypeRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_arrayOfPaths1 = 1, soap_flag_desiredStorageType1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmChangeFileStorageTypeRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfPaths1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLInfo(soap, "arrayOfPaths", &(((SRMv2__srmChangeFileStorageTypeRequest*)a)->arrayOfPaths), "SRMv2:ArrayOfTSURLInfo"))
				{	soap_flag_arrayOfPaths1--;
					continue;
				}
			if (soap_flag_desiredStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TFileStorageType(soap, "desiredStorageType", &(((SRMv2__srmChangeFileStorageTypeRequest*)a)->desiredStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_desiredStorageType1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_desiredStorageType1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmChangeFileStorageTypeRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest, 0, sizeof(SRMv2__srmChangeFileStorageTypeRequest), 0, soap_copy_SRMv2__srmChangeFileStorageTypeRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmChangeFileStorageTypeRequest * SOAP_FMAC6 soap_new_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmChangeFileStorageTypeRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, SRMv2__srmChangeFileStorageTypeRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmChangeFileStorageTypeRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmChangeFileStorageTypeRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmChangeFileStorageTypeRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmChangeFileStorageTypeRequest;
		if (size)
			*size = sizeof(SRMv2__srmChangeFileStorageTypeRequest);
		((SRMv2__srmChangeFileStorageTypeRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmChangeFileStorageTypeRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmChangeFileStorageTypeRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmChangeFileStorageTypeRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmChangeFileStorageTypeRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmChangeFileStorageTypeRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmChangeFileStorageTypeRequest %p -> %p\n", q, p));
	*(SRMv2__srmChangeFileStorageTypeRequest*)p = *(SRMv2__srmChangeFileStorageTypeRequest*)q;
}

void SRMv2__srmGetSpaceMetaDataResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, &((SRMv2__srmGetSpaceMetaDataResponse*)this)->arrayOfSpaceDetails);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetSpaceMetaDataResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceMetaDataResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetSpaceMetaDataResponse*)this)->arrayOfSpaceDetails = NULL;
	((SRMv2__srmGetSpaceMetaDataResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceMetaDataResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceMetaDataResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceMetaDataResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceMetaDataResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse), type);
	soap_out_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, "arrayOfSpaceDetails", -1, &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->arrayOfSpaceDetails), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceMetaDataResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceMetaDataResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, SRMv2__srmGetSpaceMetaDataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceMetaDataResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, const char *tag, SRMv2__srmGetSpaceMetaDataResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceMetaDataResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse, sizeof(SRMv2__srmGetSpaceMetaDataResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceMetaDataResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfSpaceDetails1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfSpaceDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, "arrayOfSpaceDetails", &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->arrayOfSpaceDetails), "SRMv2:ArrayOfTMetaDataSpace"))
				{	soap_flag_arrayOfSpaceDetails1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceMetaDataResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse, 0, sizeof(SRMv2__srmGetSpaceMetaDataResponse), 0, soap_copy_SRMv2__srmGetSpaceMetaDataResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, SRMv2__srmGetSpaceMetaDataResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceMetaDataResponse);
		((SRMv2__srmGetSpaceMetaDataResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceMetaDataResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceMetaDataResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceMetaDataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceMetaDataResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceMetaDataResponse*)p = *(SRMv2__srmGetSpaceMetaDataResponse*)q;
}

void SRMv2__srmGetSpaceMetaDataRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmGetSpaceMetaDataRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__ArrayOfTSpaceToken(soap, &((SRMv2__srmGetSpaceMetaDataRequest*)this)->arrayOfSpaceTokens);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceMetaDataRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetSpaceMetaDataRequest*)this)->userID = NULL;
	((SRMv2__srmGetSpaceMetaDataRequest*)this)->arrayOfSpaceTokens = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceMetaDataRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceMetaDataRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceMetaDataRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceMetaDataRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__ArrayOfTSpaceToken(soap, "arrayOfSpaceTokens", -1, &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->arrayOfSpaceTokens), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceMetaDataRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceMetaDataRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, SRMv2__srmGetSpaceMetaDataRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceMetaDataRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, const char *tag, SRMv2__srmGetSpaceMetaDataRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceMetaDataRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest, sizeof(SRMv2__srmGetSpaceMetaDataRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceMetaDataRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_arrayOfSpaceTokens1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_arrayOfSpaceTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSpaceToken(soap, "arrayOfSpaceTokens", &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->arrayOfSpaceTokens), "SRMv2:ArrayOfTSpaceToken"))
				{	soap_flag_arrayOfSpaceTokens1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSpaceTokens1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceMetaDataRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest, 0, sizeof(SRMv2__srmGetSpaceMetaDataRequest), 0, soap_copy_SRMv2__srmGetSpaceMetaDataRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, SRMv2__srmGetSpaceMetaDataRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceMetaDataRequest);
		((SRMv2__srmGetSpaceMetaDataRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceMetaDataRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceMetaDataRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceMetaDataRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceMetaDataRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceMetaDataRequest*)p = *(SRMv2__srmGetSpaceMetaDataRequest*)q;
}

void SRMv2__srmCompactSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmCompactSpaceResponse*)this)->newSizeOfThisSpace);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmCompactSpaceResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmCompactSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCompactSpaceResponse*)this)->newSizeOfThisSpace = NULL;
	((SRMv2__srmCompactSpaceResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCompactSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCompactSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCompactSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCompactSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCompactSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmCompactSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCompactSpaceResponse), type);
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "newSizeOfThisSpace", -1, &(((SRMv2__srmCompactSpaceResponse*)a)->newSizeOfThisSpace), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmCompactSpaceResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCompactSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCompactSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCompactSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmCompactSpaceResponse(struct soap *soap, SRMv2__srmCompactSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCompactSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCompactSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCompactSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCompactSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmCompactSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmCompactSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCompactSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCompactSpaceResponse, sizeof(SRMv2__srmCompactSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCompactSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCompactSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_newSizeOfThisSpace1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_newSizeOfThisSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "newSizeOfThisSpace", &(((SRMv2__srmCompactSpaceResponse*)a)->newSizeOfThisSpace), "SRMv2:TSizeInBytes"))
				{	soap_flag_newSizeOfThisSpace1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmCompactSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCompactSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCompactSpaceResponse, 0, sizeof(SRMv2__srmCompactSpaceResponse), 0, soap_copy_SRMv2__srmCompactSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCompactSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmCompactSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCompactSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCompactSpaceResponse(struct soap *soap, SRMv2__srmCompactSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCompactSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmCompactSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCompactSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCompactSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCompactSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmCompactSpaceResponse);
		((SRMv2__srmCompactSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCompactSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCompactSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCompactSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCompactSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCompactSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCompactSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmCompactSpaceResponse*)p = *(SRMv2__srmCompactSpaceResponse*)q;
}

void SRMv2__srmCompactSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmCompactSpaceRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__srmCompactSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmCompactSpaceRequest*)this)->storageSystemInfo);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmCompactSpaceRequest*)this)->doDynamicCompactFromNowOn);
	/* transient soap skipped */
}

void SRMv2__srmCompactSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCompactSpaceRequest*)this)->userID = NULL;
	((SRMv2__srmCompactSpaceRequest*)this)->spaceToken = NULL;
	((SRMv2__srmCompactSpaceRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmCompactSpaceRequest*)this)->doDynamicCompactFromNowOn = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCompactSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCompactSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCompactSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCompactSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCompactSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmCompactSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCompactSpaceRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmCompactSpaceRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__srmCompactSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmCompactSpaceRequest*)a)->storageSystemInfo), "");
	soap_out_PointerTobool(soap, "doDynamicCompactFromNowOn", -1, &(((SRMv2__srmCompactSpaceRequest*)a)->doDynamicCompactFromNowOn), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCompactSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCompactSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCompactSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmCompactSpaceRequest(struct soap *soap, SRMv2__srmCompactSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCompactSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCompactSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCompactSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCompactSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmCompactSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmCompactSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCompactSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCompactSpaceRequest, sizeof(SRMv2__srmCompactSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCompactSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCompactSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_spaceToken1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_doDynamicCompactFromNowOn1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmCompactSpaceRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__srmCompactSpaceRequest*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmCompactSpaceRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_doDynamicCompactFromNowOn1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "doDynamicCompactFromNowOn", &(((SRMv2__srmCompactSpaceRequest*)a)->doDynamicCompactFromNowOn), "xsd:boolean"))
				{	soap_flag_doDynamicCompactFromNowOn1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCompactSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCompactSpaceRequest, 0, sizeof(SRMv2__srmCompactSpaceRequest), 0, soap_copy_SRMv2__srmCompactSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCompactSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmCompactSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCompactSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCompactSpaceRequest(struct soap *soap, SRMv2__srmCompactSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCompactSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmCompactSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCompactSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCompactSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCompactSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmCompactSpaceRequest);
		((SRMv2__srmCompactSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCompactSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCompactSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCompactSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCompactSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCompactSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCompactSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmCompactSpaceRequest*)p = *(SRMv2__srmCompactSpaceRequest*)q;
}

void SRMv2__srmUpdateSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfTotalSpace);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfGuaranteedSpace);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->lifetimeGranted);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmUpdateSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfTotalSpace = NULL;
	((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfGuaranteedSpace = NULL;
	((SRMv2__srmUpdateSpaceResponse*)this)->lifetimeGranted = NULL;
	((SRMv2__srmUpdateSpaceResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmUpdateSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmUpdateSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmUpdateSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmUpdateSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmUpdateSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse), type);
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "sizeOfTotalSpace", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfTotalSpace), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "sizeOfGuaranteedSpace", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfGuaranteedSpace), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeGranted", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->lifetimeGranted), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmUpdateSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmUpdateSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmUpdateSpaceResponse(struct soap *soap, SRMv2__srmUpdateSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmUpdateSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmUpdateSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmUpdateSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmUpdateSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmUpdateSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmUpdateSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse, sizeof(SRMv2__srmUpdateSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmUpdateSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmUpdateSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_sizeOfTotalSpace1 = 1, soap_flag_sizeOfGuaranteedSpace1 = 1, soap_flag_lifetimeGranted1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_sizeOfTotalSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "sizeOfTotalSpace", &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfTotalSpace), "SRMv2:TSizeInBytes"))
				{	soap_flag_sizeOfTotalSpace1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "sizeOfGuaranteedSpace", &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfGuaranteedSpace), "SRMv2:TSizeInBytes"))
				{	soap_flag_sizeOfGuaranteedSpace1--;
					continue;
				}
			if (soap_flag_lifetimeGranted1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeGranted", &(((SRMv2__srmUpdateSpaceResponse*)a)->lifetimeGranted), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeGranted1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmUpdateSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmUpdateSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse, 0, sizeof(SRMv2__srmUpdateSpaceResponse), 0, soap_copy_SRMv2__srmUpdateSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmUpdateSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmUpdateSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmUpdateSpaceResponse(struct soap *soap, SRMv2__srmUpdateSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmUpdateSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmUpdateSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmUpdateSpaceResponse);
		((SRMv2__srmUpdateSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmUpdateSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmUpdateSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmUpdateSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmUpdateSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmUpdateSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmUpdateSpaceResponse*)p = *(SRMv2__srmUpdateSpaceResponse*)q;
}

void SRMv2__srmUpdateSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfTotalSpaceDesired);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfGuaranteedSpaceDesired);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->newLifeTimeFromCallingTime);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmUpdateSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmUpdateSpaceRequest*)this)->userID = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->spaceToken = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfTotalSpaceDesired = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfGuaranteedSpaceDesired = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->newLifeTimeFromCallingTime = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmUpdateSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmUpdateSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmUpdateSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmUpdateSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmUpdateSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "newSizeOfTotalSpaceDesired", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfTotalSpaceDesired), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "newSizeOfGuaranteedSpaceDesired", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfGuaranteedSpaceDesired), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "newLifeTimeFromCallingTime", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->newLifeTimeFromCallingTime), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmUpdateSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmUpdateSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmUpdateSpaceRequest(struct soap *soap, SRMv2__srmUpdateSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmUpdateSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmUpdateSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmUpdateSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmUpdateSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmUpdateSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmUpdateSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest, sizeof(SRMv2__srmUpdateSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmUpdateSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmUpdateSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_spaceToken1 = 1, soap_flag_newSizeOfTotalSpaceDesired1 = 1, soap_flag_newSizeOfGuaranteedSpaceDesired1 = 1, soap_flag_newLifeTimeFromCallingTime1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmUpdateSpaceRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__srmUpdateSpaceRequest*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_newSizeOfTotalSpaceDesired1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "newSizeOfTotalSpaceDesired", &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfTotalSpaceDesired), "SRMv2:TSizeInBytes"))
				{	soap_flag_newSizeOfTotalSpaceDesired1--;
					continue;
				}
			if (soap_flag_newSizeOfGuaranteedSpaceDesired1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "newSizeOfGuaranteedSpaceDesired", &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfGuaranteedSpaceDesired), "SRMv2:TSizeInBytes"))
				{	soap_flag_newSizeOfGuaranteedSpaceDesired1--;
					continue;
				}
			if (soap_flag_newLifeTimeFromCallingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "newLifeTimeFromCallingTime", &(((SRMv2__srmUpdateSpaceRequest*)a)->newLifeTimeFromCallingTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_newLifeTimeFromCallingTime1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmUpdateSpaceRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmUpdateSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest, 0, sizeof(SRMv2__srmUpdateSpaceRequest), 0, soap_copy_SRMv2__srmUpdateSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmUpdateSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmUpdateSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmUpdateSpaceRequest(struct soap *soap, SRMv2__srmUpdateSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmUpdateSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmUpdateSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmUpdateSpaceRequest);
		((SRMv2__srmUpdateSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmUpdateSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmUpdateSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmUpdateSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmUpdateSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmUpdateSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmUpdateSpaceRequest*)p = *(SRMv2__srmUpdateSpaceRequest*)q;
}

void SRMv2__srmReleaseSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReleaseSpaceResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmReleaseSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReleaseSpaceResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReleaseSpaceResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmReleaseSpaceResponse(struct soap *soap, SRMv2__srmReleaseSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmReleaseSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmReleaseSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse, sizeof(SRMv2__srmReleaseSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReleaseSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse, 0, sizeof(SRMv2__srmReleaseSpaceResponse), 0, soap_copy_SRMv2__srmReleaseSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmReleaseSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseSpaceResponse(struct soap *soap, SRMv2__srmReleaseSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmReleaseSpaceResponse);
		((SRMv2__srmReleaseSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmReleaseSpaceResponse*)p = *(SRMv2__srmReleaseSpaceResponse*)q;
}

void SRMv2__srmReleaseSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->userID);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->storageSystemInfo);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->forceFileRelease);
	/* transient soap skipped */
}

void SRMv2__srmReleaseSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReleaseSpaceRequest*)this)->userID = NULL;
	((SRMv2__srmReleaseSpaceRequest*)this)->spaceToken = NULL;
	((SRMv2__srmReleaseSpaceRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmReleaseSpaceRequest*)this)->forceFileRelease = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->userID), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->storageSystemInfo), "");
	soap_out_PointerTobool(soap, "forceFileRelease", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->forceFileRelease), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmReleaseSpaceRequest(struct soap *soap, SRMv2__srmReleaseSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmReleaseSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmReleaseSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest, sizeof(SRMv2__srmReleaseSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_spaceToken1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_forceFileRelease1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmReleaseSpaceRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__srmReleaseSpaceRequest*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmReleaseSpaceRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_forceFileRelease1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "forceFileRelease", &(((SRMv2__srmReleaseSpaceRequest*)a)->forceFileRelease), "xsd:boolean"))
				{	soap_flag_forceFileRelease1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest, 0, sizeof(SRMv2__srmReleaseSpaceRequest), 0, soap_copy_SRMv2__srmReleaseSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmReleaseSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseSpaceRequest(struct soap *soap, SRMv2__srmReleaseSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmReleaseSpaceRequest);
		((SRMv2__srmReleaseSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmReleaseSpaceRequest*)p = *(SRMv2__srmReleaseSpaceRequest*)q;
}

void SRMv2__srmReserveSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TSpaceType(soap, &((SRMv2__srmReserveSpaceResponse*)this)->typeOfReservedSpace);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmReserveSpaceResponse*)this)->sizeOfTotalReservedSpace);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmReserveSpaceResponse*)this)->sizeOfGuaranteedReservedSpace);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmReserveSpaceResponse*)this)->lifetimeOfReservedSpace);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__srmReserveSpaceResponse*)this)->referenceHandleOfReservedSpace);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReserveSpaceResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmReserveSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReserveSpaceResponse*)this)->typeOfReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->sizeOfTotalReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->sizeOfGuaranteedReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->lifetimeOfReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->referenceHandleOfReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReserveSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReserveSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReserveSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReserveSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReserveSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReserveSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReserveSpaceResponse), type);
	soap_out_PointerToSRMv2__TSpaceType(soap, "typeOfReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->typeOfReservedSpace), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "sizeOfTotalReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfTotalReservedSpace), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "sizeOfGuaranteedReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfGuaranteedReservedSpace), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeOfReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->lifetimeOfReservedSpace), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "referenceHandleOfReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->referenceHandleOfReservedSpace), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReserveSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReserveSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmReserveSpaceResponse(struct soap *soap, SRMv2__srmReserveSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReserveSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReserveSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReserveSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmReserveSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmReserveSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReserveSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReserveSpaceResponse, sizeof(SRMv2__srmReserveSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReserveSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReserveSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_typeOfReservedSpace1 = 1, soap_flag_sizeOfTotalReservedSpace1 = 1, soap_flag_sizeOfGuaranteedReservedSpace1 = 1, soap_flag_lifetimeOfReservedSpace1 = 1, soap_flag_referenceHandleOfReservedSpace1 = 1, soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_typeOfReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceType(soap, "typeOfReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->typeOfReservedSpace), "SRMv2:TSpaceType"))
				{	soap_flag_typeOfReservedSpace1--;
					continue;
				}
			if (soap_flag_sizeOfTotalReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "sizeOfTotalReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfTotalReservedSpace), "SRMv2:TSizeInBytes"))
				{	soap_flag_sizeOfTotalReservedSpace1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "sizeOfGuaranteedReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfGuaranteedReservedSpace), "SRMv2:TSizeInBytes"))
				{	soap_flag_sizeOfGuaranteedReservedSpace1--;
					continue;
				}
			if (soap_flag_lifetimeOfReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeOfReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->lifetimeOfReservedSpace), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeOfReservedSpace1--;
					continue;
				}
			if (soap_flag_referenceHandleOfReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "referenceHandleOfReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->referenceHandleOfReservedSpace), "SRMv2:TSpaceToken"))
				{	soap_flag_referenceHandleOfReservedSpace1--;
					continue;
				}
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReserveSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReserveSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReserveSpaceResponse, 0, sizeof(SRMv2__srmReserveSpaceResponse), 0, soap_copy_SRMv2__srmReserveSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReserveSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmReserveSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReserveSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReserveSpaceResponse(struct soap *soap, SRMv2__srmReserveSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReserveSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReserveSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReserveSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmReserveSpaceResponse);
		((SRMv2__srmReserveSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReserveSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReserveSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReserveSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReserveSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReserveSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmReserveSpaceResponse*)p = *(SRMv2__srmReserveSpaceResponse*)q;
}

void SRMv2__srmReserveSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__srmReserveSpaceRequest*)this)->userID);
	soap_embedded(soap, &((SRMv2__srmReserveSpaceRequest*)this)->typeOfSpace, SOAP_TYPE_SRMv2__TSpaceType);
	soap_serialize_string(soap, &((SRMv2__srmReserveSpaceRequest*)this)->userSpaceTokenDescription);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmReserveSpaceRequest*)this)->sizeOfTotalSpaceDesired);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__srmReserveSpaceRequest*)this)->sizeOfGuaranteedSpaceDesired);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__srmReserveSpaceRequest*)this)->lifetimeOfSpaceToReserve);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__srmReserveSpaceRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmReserveSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReserveSpaceRequest*)this)->userID = NULL;
	soap_default_SRMv2__TSpaceType(soap, &((SRMv2__srmReserveSpaceRequest*)this)->typeOfSpace);
	soap_default_string(soap, &((SRMv2__srmReserveSpaceRequest*)this)->userSpaceTokenDescription);
	((SRMv2__srmReserveSpaceRequest*)this)->sizeOfTotalSpaceDesired = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->sizeOfGuaranteedSpaceDesired = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->lifetimeOfSpaceToReserve = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReserveSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReserveSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReserveSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReserveSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReserveSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReserveSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReserveSpaceRequest), type);
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->userID), "");
	soap_out_SRMv2__TSpaceType(soap, "typeOfSpace", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->typeOfSpace), "");
	soap_out_string(soap, "userSpaceTokenDescription", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->userSpaceTokenDescription), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "sizeOfTotalSpaceDesired", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->sizeOfTotalSpaceDesired), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "sizeOfGuaranteedSpaceDesired", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->sizeOfGuaranteedSpaceDesired), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeOfSpaceToReserve", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->lifetimeOfSpaceToReserve), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReserveSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReserveSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmReserveSpaceRequest(struct soap *soap, SRMv2__srmReserveSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReserveSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReserveSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReserveSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmReserveSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmReserveSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReserveSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReserveSpaceRequest, sizeof(SRMv2__srmReserveSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReserveSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReserveSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userID1 = 1, soap_flag_typeOfSpace1 = 1, soap_flag_userSpaceTokenDescription1 = 1, soap_flag_sizeOfTotalSpaceDesired1 = 1, soap_flag_sizeOfGuaranteedSpaceDesired1 = 1, soap_flag_lifetimeOfSpaceToReserve1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__srmReserveSpaceRequest*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			if (soap_flag_typeOfSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TSpaceType(soap, "typeOfSpace", &(((SRMv2__srmReserveSpaceRequest*)a)->typeOfSpace), "SRMv2:TSpaceType"))
				{	soap_flag_typeOfSpace1--;
					continue;
				}
			if (soap_flag_userSpaceTokenDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userSpaceTokenDescription", &(((SRMv2__srmReserveSpaceRequest*)a)->userSpaceTokenDescription), "xsd:string"))
				{	soap_flag_userSpaceTokenDescription1--;
					continue;
				}
			if (soap_flag_sizeOfTotalSpaceDesired1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "sizeOfTotalSpaceDesired", &(((SRMv2__srmReserveSpaceRequest*)a)->sizeOfTotalSpaceDesired), "SRMv2:TSizeInBytes"))
				{	soap_flag_sizeOfTotalSpaceDesired1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedSpaceDesired1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "sizeOfGuaranteedSpaceDesired", &(((SRMv2__srmReserveSpaceRequest*)a)->sizeOfGuaranteedSpaceDesired), "SRMv2:TSizeInBytes"))
				{	soap_flag_sizeOfGuaranteedSpaceDesired1--;
					continue;
				}
			if (soap_flag_lifetimeOfSpaceToReserve1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeOfSpaceToReserve", &(((SRMv2__srmReserveSpaceRequest*)a)->lifetimeOfSpaceToReserve), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeOfSpaceToReserve1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__srmReserveSpaceRequest*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_typeOfSpace1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReserveSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReserveSpaceRequest, 0, sizeof(SRMv2__srmReserveSpaceRequest), 0, soap_copy_SRMv2__srmReserveSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReserveSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmReserveSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReserveSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReserveSpaceRequest(struct soap *soap, SRMv2__srmReserveSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReserveSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReserveSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReserveSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmReserveSpaceRequest);
		((SRMv2__srmReserveSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReserveSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReserveSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReserveSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReserveSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReserveSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmReserveSpaceRequest*)p = *(SRMv2__srmReserveSpaceRequest*)q;
}

void SRMv2__TRequestTokenReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__TRequestTokenReturn*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TGMTTime(soap, &((SRMv2__TRequestTokenReturn*)this)->createdAtTime);
	/* transient soap skipped */
}

void SRMv2__TRequestTokenReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TRequestTokenReturn*)this)->requestToken = NULL;
	((SRMv2__TRequestTokenReturn*)this)->createdAtTime = NULL;
	/* transient soap skipped */
}

int SRMv2__TRequestTokenReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TRequestTokenReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TRequestTokenReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TRequestTokenReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRequestTokenReturn(struct soap *soap, const char *tag, int id, const SRMv2__TRequestTokenReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRequestTokenReturn), type);
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__TRequestTokenReturn*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TGMTTime(soap, "createdAtTime", -1, &(((SRMv2__TRequestTokenReturn*)a)->createdAtTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TRequestTokenReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TRequestTokenReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TRequestTokenReturn * SOAP_FMAC4 soap_get_SRMv2__TRequestTokenReturn(struct soap *soap, SRMv2__TRequestTokenReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRequestTokenReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TRequestTokenReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TRequestTokenReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TRequestTokenReturn * SOAP_FMAC4 soap_in_SRMv2__TRequestTokenReturn(struct soap *soap, const char *tag, SRMv2__TRequestTokenReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TRequestTokenReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRequestTokenReturn, sizeof(SRMv2__TRequestTokenReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TRequestTokenReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TRequestTokenReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_createdAtTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__TRequestTokenReturn*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_createdAtTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TGMTTime(soap, "createdAtTime", &(((SRMv2__TRequestTokenReturn*)a)->createdAtTime), "SRMv2:TGMTTime"))
				{	soap_flag_createdAtTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TRequestTokenReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRequestTokenReturn, 0, sizeof(SRMv2__TRequestTokenReturn), 0, soap_copy_SRMv2__TRequestTokenReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TRequestTokenReturn * SOAP_FMAC6 soap_new_SRMv2__TRequestTokenReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TRequestTokenReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TRequestTokenReturn(struct soap *soap, SRMv2__TRequestTokenReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TRequestTokenReturn * SOAP_FMAC4 soap_instantiate_SRMv2__TRequestTokenReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TRequestTokenReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TRequestTokenReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TRequestTokenReturn;
		if (size)
			*size = sizeof(SRMv2__TRequestTokenReturn);
		((SRMv2__TRequestTokenReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TRequestTokenReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__TRequestTokenReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__TRequestTokenReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TRequestTokenReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TRequestTokenReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TRequestTokenReturn %p -> %p\n", q, p));
	*(SRMv2__TRequestTokenReturn*)p = *(SRMv2__TRequestTokenReturn*)q;
}

void SRMv2__ArrayOfTRequestToken::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTRequestToken*)this)->requestTokenArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestToken*)this)->__sizerequestTokenArray; i++)
		{
			soap_serialize_PointerToSRMv2__TRequestToken(soap, ((SRMv2__ArrayOfTRequestToken*)this)->requestTokenArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTRequestToken::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTRequestToken*)this)->__sizerequestTokenArray = 0;
	((SRMv2__ArrayOfTRequestToken*)this)->requestTokenArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTRequestToken::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTRequestToken);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTRequestToken::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTRequestToken(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTRequestToken(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTRequestToken *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestToken), type);
	if (((SRMv2__ArrayOfTRequestToken*)a)->requestTokenArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestToken*)a)->__sizerequestTokenArray; i++)
			soap_out_PointerToSRMv2__TRequestToken(soap, "requestTokenArray", -1, ((SRMv2__ArrayOfTRequestToken*)a)->requestTokenArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTRequestToken::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTRequestToken(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestToken * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTRequestToken(struct soap *soap, SRMv2__ArrayOfTRequestToken *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTRequestToken(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTRequestToken::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTRequestToken(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestToken * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTRequestToken(struct soap *soap, const char *tag, SRMv2__ArrayOfTRequestToken *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTRequestToken *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestToken, sizeof(SRMv2__ArrayOfTRequestToken), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTRequestToken)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTRequestToken *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestTokenArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestTokenArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TRequestToken **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTRequestToken*)a)->__sizerequestTokenArray = 0; !soap_element_begin_in(soap, "requestTokenArray", 1); ((SRMv2__ArrayOfTRequestToken*)a)->__sizerequestTokenArray++)
				{	p = (SRMv2__TRequestToken **)soap_push_block(soap, sizeof(SRMv2__TRequestToken *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TRequestToken(soap, "requestTokenArray", p, "SRMv2:TRequestToken"))
						break;
					soap_flag_requestTokenArray1 = 0;
				}
				((SRMv2__ArrayOfTRequestToken*)a)->requestTokenArray = (SRMv2__TRequestToken **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_requestTokenArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTRequestToken *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTRequestToken, 0, sizeof(SRMv2__ArrayOfTRequestToken), 0, soap_copy_SRMv2__ArrayOfTRequestToken);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTRequestToken * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTRequestToken(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTRequestToken(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTRequestToken(struct soap *soap, SRMv2__ArrayOfTRequestToken *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestToken * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTRequestToken(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTRequestToken(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTRequestToken, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestToken;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTRequestToken);
		((SRMv2__ArrayOfTRequestToken*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestToken[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTRequestToken);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTRequestToken*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTRequestToken*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTRequestToken(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTRequestToken %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTRequestToken*)p = *(SRMv2__ArrayOfTRequestToken*)q;
}

void SRMv2__ArrayOfTSURL::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSURL*)this)->surlArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURL*)this)->__sizesurlArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSURL(soap, ((SRMv2__ArrayOfTSURL*)this)->surlArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSURL::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSURL*)this)->__sizesurlArray = 0;
	((SRMv2__ArrayOfTSURL*)this)->surlArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSURL::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSURL);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSURL::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSURL(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSURL(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSURL *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSURL), type);
	if (((SRMv2__ArrayOfTSURL*)a)->surlArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURL*)a)->__sizesurlArray; i++)
			soap_out_PointerToSRMv2__TSURL(soap, "surlArray", -1, ((SRMv2__ArrayOfTSURL*)a)->surlArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSURL::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSURL(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURL * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSURL(struct soap *soap, SRMv2__ArrayOfTSURL *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSURL(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSURL::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSURL(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURL * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSURL(struct soap *soap, const char *tag, SRMv2__ArrayOfTSURL *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSURL *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSURL, sizeof(SRMv2__ArrayOfTSURL), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSURL)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSURL *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surlArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surlArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSURL **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSURL*)a)->__sizesurlArray = 0; !soap_element_begin_in(soap, "surlArray", 1); ((SRMv2__ArrayOfTSURL*)a)->__sizesurlArray++)
				{	p = (SRMv2__TSURL **)soap_push_block(soap, sizeof(SRMv2__TSURL *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSURL(soap, "surlArray", p, "SRMv2:TSURL"))
						break;
					soap_flag_surlArray1 = 0;
				}
				((SRMv2__ArrayOfTSURL*)a)->surlArray = (SRMv2__TSURL **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSURL *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSURL, 0, sizeof(SRMv2__ArrayOfTSURL), 0, soap_copy_SRMv2__ArrayOfTSURL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSURL * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSURL(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSURL(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSURL(struct soap *soap, SRMv2__ArrayOfTSURL *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURL * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSURL(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSURL(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSURL, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURL;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSURL);
		((SRMv2__ArrayOfTSURL*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURL[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSURL);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSURL*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTSURL*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTSURL(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTSURL %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTSURL*)p = *(SRMv2__ArrayOfTSURL*)q;
}

void SRMv2__ArrayOf_USCORExsd_USCOREstring::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOf_USCORExsd_USCOREstring*)this)->stringArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOf_USCORExsd_USCOREstring*)this)->__sizestringArray; i++)
		{
			soap_serialize_string(soap, ((SRMv2__ArrayOf_USCORExsd_USCOREstring*)this)->stringArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOf_USCORExsd_USCOREstring::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOf_USCORExsd_USCOREstring*)this)->__sizestringArray = 0;
	((SRMv2__ArrayOf_USCORExsd_USCOREstring*)this)->stringArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOf_USCORExsd_USCOREstring::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOf_USCORExsd_USCOREstring::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOf_USCORExsd_USCOREstring *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring), type);
	if (((SRMv2__ArrayOf_USCORExsd_USCOREstring*)a)->stringArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOf_USCORExsd_USCOREstring*)a)->__sizestringArray; i++)
			soap_out_string(soap, "stringArray", -1, ((SRMv2__ArrayOf_USCORExsd_USCOREstring*)a)->stringArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOf_USCORExsd_USCOREstring::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC4 soap_get_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, SRMv2__ArrayOf_USCORExsd_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOf_USCORExsd_USCOREstring::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC4 soap_in_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, const char *tag, SRMv2__ArrayOf_USCORExsd_USCOREstring *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOf_USCORExsd_USCOREstring *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring, sizeof(SRMv2__ArrayOf_USCORExsd_USCOREstring), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOf_USCORExsd_USCOREstring *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_stringArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_stringArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	char **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOf_USCORExsd_USCOREstring*)a)->__sizestringArray = 0; !soap_element_begin_in(soap, "stringArray", 1); ((SRMv2__ArrayOf_USCORExsd_USCOREstring*)a)->__sizestringArray++)
				{	p = (char **)soap_push_block(soap, sizeof(char *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_string(soap, "stringArray", p, "xsd:string"))
						break;
					soap_flag_stringArray1 = 0;
				}
				((SRMv2__ArrayOf_USCORExsd_USCOREstring*)a)->stringArray = (char **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_stringArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOf_USCORExsd_USCOREstring *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring, 0, sizeof(SRMv2__ArrayOf_USCORExsd_USCOREstring), 0, soap_copy_SRMv2__ArrayOf_USCORExsd_USCOREstring);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC6 soap_new_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOf_USCORExsd_USCOREstring(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, SRMv2__ArrayOf_USCORExsd_USCOREstring *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOf_USCORExsd_USCOREstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOf_USCORExsd_USCOREstring, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOf_USCORExsd_USCOREstring;
		if (size)
			*size = sizeof(SRMv2__ArrayOf_USCORExsd_USCOREstring);
		((SRMv2__ArrayOf_USCORExsd_USCOREstring*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOf_USCORExsd_USCOREstring[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOf_USCORExsd_USCOREstring);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOf_USCORExsd_USCOREstring*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOf_USCORExsd_USCOREstring*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOf_USCORExsd_USCOREstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOf_USCORExsd_USCOREstring %p -> %p\n", q, p));
	*(SRMv2__ArrayOf_USCORExsd_USCOREstring*)p = *(SRMv2__ArrayOf_USCORExsd_USCOREstring*)q;
}

void SRMv2__ArrayOfTSURLPermissionReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSURLPermissionReturn*)this)->surlPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLPermissionReturn*)this)->__sizesurlPermissionArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSURLPermissionReturn(soap, ((SRMv2__ArrayOfTSURLPermissionReturn*)this)->surlPermissionArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSURLPermissionReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSURLPermissionReturn*)this)->__sizesurlPermissionArray = 0;
	((SRMv2__ArrayOfTSURLPermissionReturn*)this)->surlPermissionArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSURLPermissionReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSURLPermissionReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSURLPermissionReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSURLPermissionReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn), type);
	if (((SRMv2__ArrayOfTSURLPermissionReturn*)a)->surlPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLPermissionReturn*)a)->__sizesurlPermissionArray; i++)
			soap_out_PointerToSRMv2__TSURLPermissionReturn(soap, "surlPermissionArray", -1, ((SRMv2__ArrayOfTSURLPermissionReturn*)a)->surlPermissionArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSURLPermissionReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSURLPermissionReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, SRMv2__ArrayOfTSURLPermissionReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSURLPermissionReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, const char *tag, SRMv2__ArrayOfTSURLPermissionReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSURLPermissionReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn, sizeof(SRMv2__ArrayOfTSURLPermissionReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSURLPermissionReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surlPermissionArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surlPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSURLPermissionReturn **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSURLPermissionReturn*)a)->__sizesurlPermissionArray = 0; !soap_element_begin_in(soap, "surlPermissionArray", 1); ((SRMv2__ArrayOfTSURLPermissionReturn*)a)->__sizesurlPermissionArray++)
				{	p = (SRMv2__TSURLPermissionReturn **)soap_push_block(soap, sizeof(SRMv2__TSURLPermissionReturn *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSURLPermissionReturn(soap, "surlPermissionArray", p, "SRMv2:TSURLPermissionReturn"))
						break;
					soap_flag_surlPermissionArray1 = 0;
				}
				((SRMv2__ArrayOfTSURLPermissionReturn*)a)->surlPermissionArray = (SRMv2__TSURLPermissionReturn **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSURLPermissionReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn, 0, sizeof(SRMv2__ArrayOfTSURLPermissionReturn), 0, soap_copy_SRMv2__ArrayOfTSURLPermissionReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, SRMv2__ArrayOfTSURLPermissionReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLPermissionReturn;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSURLPermissionReturn);
		((SRMv2__ArrayOfTSURLPermissionReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLPermissionReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSURLPermissionReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSURLPermissionReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTSURLPermissionReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTSURLPermissionReturn %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTSURLPermissionReturn*)p = *(SRMv2__ArrayOfTSURLPermissionReturn*)q;
}

void SRMv2__TSURLPermissionReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TSURLPermissionReturn*)this)->status);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TSURLPermissionReturn*)this)->surl);
	soap_serialize_PointerToSRMv2__TPermissionType(soap, &((SRMv2__TSURLPermissionReturn*)this)->userPermission);
	/* transient soap skipped */
}

void SRMv2__TSURLPermissionReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TSURLPermissionReturn*)this)->status = NULL;
	((SRMv2__TSURLPermissionReturn*)this)->surl = NULL;
	((SRMv2__TSURLPermissionReturn*)this)->userPermission = NULL;
	/* transient soap skipped */
}

int SRMv2__TSURLPermissionReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSURLPermissionReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSURLPermissionReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSURLPermissionReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSURLPermissionReturn(struct soap *soap, const char *tag, int id, const SRMv2__TSURLPermissionReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSURLPermissionReturn), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TSURLPermissionReturn*)a)->status), "");
	soap_out_PointerToSRMv2__TSURL(soap, "surl", -1, &(((SRMv2__TSURLPermissionReturn*)a)->surl), "");
	soap_out_PointerToSRMv2__TPermissionType(soap, "userPermission", -1, &(((SRMv2__TSURLPermissionReturn*)a)->userPermission), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSURLPermissionReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSURLPermissionReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSURLPermissionReturn * SOAP_FMAC4 soap_get_SRMv2__TSURLPermissionReturn(struct soap *soap, SRMv2__TSURLPermissionReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSURLPermissionReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSURLPermissionReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSURLPermissionReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSURLPermissionReturn * SOAP_FMAC4 soap_in_SRMv2__TSURLPermissionReturn(struct soap *soap, const char *tag, SRMv2__TSURLPermissionReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSURLPermissionReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSURLPermissionReturn, sizeof(SRMv2__TSURLPermissionReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSURLPermissionReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSURLPermissionReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1, soap_flag_surl1 = 1, soap_flag_userPermission1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TSURLPermissionReturn*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_surl1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "surl", &(((SRMv2__TSURLPermissionReturn*)a)->surl), "SRMv2:TSURL"))
				{	soap_flag_surl1--;
					continue;
				}
			if (soap_flag_userPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TPermissionType(soap, "userPermission", &(((SRMv2__TSURLPermissionReturn*)a)->userPermission), "SRMv2:TPermissionType"))
				{	soap_flag_userPermission1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSURLPermissionReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSURLPermissionReturn, 0, sizeof(SRMv2__TSURLPermissionReturn), 0, soap_copy_SRMv2__TSURLPermissionReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSURLPermissionReturn * SOAP_FMAC6 soap_new_SRMv2__TSURLPermissionReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSURLPermissionReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSURLPermissionReturn(struct soap *soap, SRMv2__TSURLPermissionReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSURLPermissionReturn * SOAP_FMAC4 soap_instantiate_SRMv2__TSURLPermissionReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSURLPermissionReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSURLPermissionReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSURLPermissionReturn;
		if (size)
			*size = sizeof(SRMv2__TSURLPermissionReturn);
		((SRMv2__TSURLPermissionReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSURLPermissionReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__TSURLPermissionReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__TSURLPermissionReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSURLPermissionReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSURLPermissionReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSURLPermissionReturn %p -> %p\n", q, p));
	*(SRMv2__TSURLPermissionReturn*)p = *(SRMv2__TSURLPermissionReturn*)q;
}

void SRMv2__ArrayOfTRequestSummary::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTRequestSummary*)this)->summaryArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestSummary*)this)->__sizesummaryArray; i++)
		{
			soap_serialize_PointerToSRMv2__TRequestSummary(soap, ((SRMv2__ArrayOfTRequestSummary*)this)->summaryArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTRequestSummary::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTRequestSummary*)this)->__sizesummaryArray = 0;
	((SRMv2__ArrayOfTRequestSummary*)this)->summaryArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTRequestSummary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTRequestSummary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTRequestSummary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTRequestSummary(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTRequestSummary *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary), type);
	if (((SRMv2__ArrayOfTRequestSummary*)a)->summaryArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestSummary*)a)->__sizesummaryArray; i++)
			soap_out_PointerToSRMv2__TRequestSummary(soap, "summaryArray", -1, ((SRMv2__ArrayOfTRequestSummary*)a)->summaryArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTRequestSummary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTRequestSummary(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTRequestSummary(struct soap *soap, SRMv2__ArrayOfTRequestSummary *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTRequestSummary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTRequestSummary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTRequestSummary(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTRequestSummary(struct soap *soap, const char *tag, SRMv2__ArrayOfTRequestSummary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTRequestSummary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary, sizeof(SRMv2__ArrayOfTRequestSummary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTRequestSummary)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTRequestSummary *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_summaryArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_summaryArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TRequestSummary **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTRequestSummary*)a)->__sizesummaryArray = 0; !soap_element_begin_in(soap, "summaryArray", 1); ((SRMv2__ArrayOfTRequestSummary*)a)->__sizesummaryArray++)
				{	p = (SRMv2__TRequestSummary **)soap_push_block(soap, sizeof(SRMv2__TRequestSummary *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TRequestSummary(soap, "summaryArray", p, "SRMv2:TRequestSummary"))
						break;
					soap_flag_summaryArray1 = 0;
				}
				((SRMv2__ArrayOfTRequestSummary*)a)->summaryArray = (SRMv2__TRequestSummary **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_summaryArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTRequestSummary *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary, 0, sizeof(SRMv2__ArrayOfTRequestSummary), 0, soap_copy_SRMv2__ArrayOfTRequestSummary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTRequestSummary(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTRequestSummary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTRequestSummary(struct soap *soap, SRMv2__ArrayOfTRequestSummary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTRequestSummary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTRequestSummary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestSummary;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTRequestSummary);
		((SRMv2__ArrayOfTRequestSummary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestSummary[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTRequestSummary);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTRequestSummary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTRequestSummary*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTRequestSummary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTRequestSummary %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTRequestSummary*)p = *(SRMv2__ArrayOfTRequestSummary*)q;
}

void SRMv2__TRequestSummary::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((SRMv2__TRequestSummary*)this)->isSuspended, SOAP_TYPE_bool);
	soap_embedded(soap, &((SRMv2__TRequestSummary*)this)->numOfFinishedRequests, SOAP_TYPE_int);
	soap_embedded(soap, &((SRMv2__TRequestSummary*)this)->numOfProgressingRequests, SOAP_TYPE_int);
	soap_embedded(soap, &((SRMv2__TRequestSummary*)this)->numOfQueuedRequests, SOAP_TYPE_int);
	soap_serialize_PointerToSRMv2__TRequestToken(soap, &((SRMv2__TRequestSummary*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TRequestType(soap, &((SRMv2__TRequestSummary*)this)->requestType);
	soap_embedded(soap, &((SRMv2__TRequestSummary*)this)->totalFilesInThisRequest, SOAP_TYPE_int);
	/* transient soap skipped */
}

void SRMv2__TRequestSummary::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &((SRMv2__TRequestSummary*)this)->isSuspended);
	soap_default_int(soap, &((SRMv2__TRequestSummary*)this)->numOfFinishedRequests);
	soap_default_int(soap, &((SRMv2__TRequestSummary*)this)->numOfProgressingRequests);
	soap_default_int(soap, &((SRMv2__TRequestSummary*)this)->numOfQueuedRequests);
	((SRMv2__TRequestSummary*)this)->requestToken = NULL;
	((SRMv2__TRequestSummary*)this)->requestType = NULL;
	soap_default_int(soap, &((SRMv2__TRequestSummary*)this)->totalFilesInThisRequest);
	/* transient soap skipped */
}

int SRMv2__TRequestSummary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TRequestSummary);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TRequestSummary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TRequestSummary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRequestSummary(struct soap *soap, const char *tag, int id, const SRMv2__TRequestSummary *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRequestSummary), type);
	soap_out_bool(soap, "isSuspended", -1, &(((SRMv2__TRequestSummary*)a)->isSuspended), "");
	soap_out_int(soap, "numOfFinishedRequests", -1, &(((SRMv2__TRequestSummary*)a)->numOfFinishedRequests), "");
	soap_out_int(soap, "numOfProgressingRequests", -1, &(((SRMv2__TRequestSummary*)a)->numOfProgressingRequests), "");
	soap_out_int(soap, "numOfQueuedRequests", -1, &(((SRMv2__TRequestSummary*)a)->numOfQueuedRequests), "");
	soap_out_PointerToSRMv2__TRequestToken(soap, "requestToken", -1, &(((SRMv2__TRequestSummary*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TRequestType(soap, "requestType", -1, &(((SRMv2__TRequestSummary*)a)->requestType), "");
	soap_out_int(soap, "totalFilesInThisRequest", -1, &(((SRMv2__TRequestSummary*)a)->totalFilesInThisRequest), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TRequestSummary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TRequestSummary(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TRequestSummary * SOAP_FMAC4 soap_get_SRMv2__TRequestSummary(struct soap *soap, SRMv2__TRequestSummary *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRequestSummary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TRequestSummary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TRequestSummary(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TRequestSummary * SOAP_FMAC4 soap_in_SRMv2__TRequestSummary(struct soap *soap, const char *tag, SRMv2__TRequestSummary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TRequestSummary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRequestSummary, sizeof(SRMv2__TRequestSummary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TRequestSummary)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TRequestSummary *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_isSuspended1 = 1, soap_flag_numOfFinishedRequests1 = 1, soap_flag_numOfProgressingRequests1 = 1, soap_flag_numOfQueuedRequests1 = 1, soap_flag_requestToken1 = 1, soap_flag_requestType1 = 1, soap_flag_totalFilesInThisRequest1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_isSuspended1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isSuspended", &(((SRMv2__TRequestSummary*)a)->isSuspended), "xsd:boolean"))
				{	soap_flag_isSuspended1--;
					continue;
				}
			if (soap_flag_numOfFinishedRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "numOfFinishedRequests", &(((SRMv2__TRequestSummary*)a)->numOfFinishedRequests), "xsd:int"))
				{	soap_flag_numOfFinishedRequests1--;
					continue;
				}
			if (soap_flag_numOfProgressingRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "numOfProgressingRequests", &(((SRMv2__TRequestSummary*)a)->numOfProgressingRequests), "xsd:int"))
				{	soap_flag_numOfProgressingRequests1--;
					continue;
				}
			if (soap_flag_numOfQueuedRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "numOfQueuedRequests", &(((SRMv2__TRequestSummary*)a)->numOfQueuedRequests), "xsd:int"))
				{	soap_flag_numOfQueuedRequests1--;
					continue;
				}
			if (soap_flag_requestToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestToken(soap, "requestToken", &(((SRMv2__TRequestSummary*)a)->requestToken), "SRMv2:TRequestToken"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_requestType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestType(soap, "requestType", &(((SRMv2__TRequestSummary*)a)->requestType), "SRMv2:TRequestType"))
				{	soap_flag_requestType1--;
					continue;
				}
			if (soap_flag_totalFilesInThisRequest1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "totalFilesInThisRequest", &(((SRMv2__TRequestSummary*)a)->totalFilesInThisRequest), "xsd:int"))
				{	soap_flag_totalFilesInThisRequest1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_isSuspended1 > 0 || soap_flag_numOfFinishedRequests1 > 0 || soap_flag_numOfProgressingRequests1 > 0 || soap_flag_numOfQueuedRequests1 > 0 || soap_flag_totalFilesInThisRequest1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TRequestSummary *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRequestSummary, 0, sizeof(SRMv2__TRequestSummary), 0, soap_copy_SRMv2__TRequestSummary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TRequestSummary * SOAP_FMAC6 soap_new_SRMv2__TRequestSummary(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TRequestSummary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TRequestSummary(struct soap *soap, SRMv2__TRequestSummary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TRequestSummary * SOAP_FMAC4 soap_instantiate_SRMv2__TRequestSummary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TRequestSummary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TRequestSummary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TRequestSummary;
		if (size)
			*size = sizeof(SRMv2__TRequestSummary);
		((SRMv2__TRequestSummary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TRequestSummary[n];
		if (size)
			*size = n * sizeof(SRMv2__TRequestSummary);
		for (int i = 0; i < n; i++)
			((SRMv2__TRequestSummary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TRequestSummary*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TRequestSummary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TRequestSummary %p -> %p\n", q, p));
	*(SRMv2__TRequestSummary*)p = *(SRMv2__TRequestSummary*)q;
}

void SRMv2__ArrayOfTCopyRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->copyStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->__sizecopyStatusArray; i++)
		{
			soap_serialize_PointerToSRMv2__TCopyRequestFileStatus(soap, ((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->copyStatusArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTCopyRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->__sizecopyStatusArray = 0;
	((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->copyStatusArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTCopyRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTCopyRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTCopyRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus), type);
	if (((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->copyStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->__sizecopyStatusArray; i++)
			soap_out_PointerToSRMv2__TCopyRequestFileStatus(soap, "copyStatusArray", -1, ((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->copyStatusArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTCopyRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTCopyRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTCopyRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTCopyRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, const char *tag, SRMv2__ArrayOfTCopyRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTCopyRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus, sizeof(SRMv2__ArrayOfTCopyRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTCopyRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_copyStatusArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_copyStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TCopyRequestFileStatus **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->__sizecopyStatusArray = 0; !soap_element_begin_in(soap, "copyStatusArray", 1); ((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->__sizecopyStatusArray++)
				{	p = (SRMv2__TCopyRequestFileStatus **)soap_push_block(soap, sizeof(SRMv2__TCopyRequestFileStatus *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TCopyRequestFileStatus(soap, "copyStatusArray", p, "SRMv2:TCopyRequestFileStatus"))
						break;
					soap_flag_copyStatusArray1 = 0;
				}
				((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->copyStatusArray = (SRMv2__TCopyRequestFileStatus **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_copyStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTCopyRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus, 0, sizeof(SRMv2__ArrayOfTCopyRequestFileStatus), 0, soap_copy_SRMv2__ArrayOfTCopyRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTCopyRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTCopyRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTCopyRequestFileStatus);
		((SRMv2__ArrayOfTCopyRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTCopyRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTCopyRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTCopyRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTCopyRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTCopyRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTCopyRequestFileStatus*)p = *(SRMv2__ArrayOfTCopyRequestFileStatus*)q;
}

void SRMv2__TCopyRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TCopyRequestFileStatus*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TCopyRequestFileStatus*)this)->estimatedWaitTimeOnQueue);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TCopyRequestFileStatus*)this)->fileSize);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TCopyRequestFileStatus*)this)->fromSURL);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TCopyRequestFileStatus*)this)->remainingPinTime);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TCopyRequestFileStatus*)this)->status);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TCopyRequestFileStatus*)this)->toSURL);
	/* transient soap skipped */
}

void SRMv2__TCopyRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TCopyRequestFileStatus*)this)->estimatedProcessingTime = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->estimatedWaitTimeOnQueue = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->fileSize = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->fromSURL = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->remainingPinTime = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->status = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->toSURL = NULL;
	/* transient soap skipped */
}

int SRMv2__TCopyRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TCopyRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TCopyRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TCopyRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TCopyRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__TCopyRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TCopyRequestFileStatus), type);
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedProcessingTime", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedWaitTimeOnQueue", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->estimatedWaitTimeOnQueue), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "fileSize", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->fileSize), "");
	soap_out_PointerToSRMv2__TSURL(soap, "fromSURL", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->fromSURL), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "remainingPinTime", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->remainingPinTime), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->status), "");
	soap_out_PointerToSRMv2__TSURL(soap, "toSURL", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->toSURL), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TCopyRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TCopyRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TCopyRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__TCopyRequestFileStatus(struct soap *soap, SRMv2__TCopyRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TCopyRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TCopyRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TCopyRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TCopyRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__TCopyRequestFileStatus(struct soap *soap, const char *tag, SRMv2__TCopyRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TCopyRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TCopyRequestFileStatus, sizeof(SRMv2__TCopyRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TCopyRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TCopyRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_estimatedProcessingTime1 = 1, soap_flag_estimatedWaitTimeOnQueue1 = 1, soap_flag_fileSize1 = 1, soap_flag_fromSURL1 = 1, soap_flag_remainingPinTime1 = 1, soap_flag_status1 = 1, soap_flag_toSURL1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedProcessingTime", &(((SRMv2__TCopyRequestFileStatus*)a)->estimatedProcessingTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_estimatedWaitTimeOnQueue1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedWaitTimeOnQueue", &(((SRMv2__TCopyRequestFileStatus*)a)->estimatedWaitTimeOnQueue), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_estimatedWaitTimeOnQueue1--;
					continue;
				}
			if (soap_flag_fileSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "fileSize", &(((SRMv2__TCopyRequestFileStatus*)a)->fileSize), "SRMv2:TSizeInBytes"))
				{	soap_flag_fileSize1--;
					continue;
				}
			if (soap_flag_fromSURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "fromSURL", &(((SRMv2__TCopyRequestFileStatus*)a)->fromSURL), "SRMv2:TSURL"))
				{	soap_flag_fromSURL1--;
					continue;
				}
			if (soap_flag_remainingPinTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "remainingPinTime", &(((SRMv2__TCopyRequestFileStatus*)a)->remainingPinTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_remainingPinTime1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TCopyRequestFileStatus*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_toSURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "toSURL", &(((SRMv2__TCopyRequestFileStatus*)a)->toSURL), "SRMv2:TSURL"))
				{	soap_flag_toSURL1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fromSURL1 > 0 || soap_flag_status1 > 0 || soap_flag_toSURL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TCopyRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TCopyRequestFileStatus, 0, sizeof(SRMv2__TCopyRequestFileStatus), 0, soap_copy_SRMv2__TCopyRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TCopyRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__TCopyRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TCopyRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TCopyRequestFileStatus(struct soap *soap, SRMv2__TCopyRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TCopyRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__TCopyRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TCopyRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TCopyRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TCopyRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__TCopyRequestFileStatus);
		((SRMv2__TCopyRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TCopyRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__TCopyRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__TCopyRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TCopyRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TCopyRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TCopyRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__TCopyRequestFileStatus*)p = *(SRMv2__TCopyRequestFileStatus*)q;
}

void SRMv2__ArrayOfTPutRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTPutRequestFileStatus*)this)->putStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPutRequestFileStatus*)this)->__sizeputStatusArray; i++)
		{
			soap_serialize_PointerToSRMv2__TPutRequestFileStatus(soap, ((SRMv2__ArrayOfTPutRequestFileStatus*)this)->putStatusArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTPutRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTPutRequestFileStatus*)this)->__sizeputStatusArray = 0;
	((SRMv2__ArrayOfTPutRequestFileStatus*)this)->putStatusArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTPutRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTPutRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTPutRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTPutRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus), type);
	if (((SRMv2__ArrayOfTPutRequestFileStatus*)a)->putStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPutRequestFileStatus*)a)->__sizeputStatusArray; i++)
			soap_out_PointerToSRMv2__TPutRequestFileStatus(soap, "putStatusArray", -1, ((SRMv2__ArrayOfTPutRequestFileStatus*)a)->putStatusArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTPutRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTPutRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTPutRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTPutRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, const char *tag, SRMv2__ArrayOfTPutRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTPutRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus, sizeof(SRMv2__ArrayOfTPutRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTPutRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_putStatusArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_putStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TPutRequestFileStatus **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTPutRequestFileStatus*)a)->__sizeputStatusArray = 0; !soap_element_begin_in(soap, "putStatusArray", 1); ((SRMv2__ArrayOfTPutRequestFileStatus*)a)->__sizeputStatusArray++)
				{	p = (SRMv2__TPutRequestFileStatus **)soap_push_block(soap, sizeof(SRMv2__TPutRequestFileStatus *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TPutRequestFileStatus(soap, "putStatusArray", p, "SRMv2:TPutRequestFileStatus"))
						break;
					soap_flag_putStatusArray1 = 0;
				}
				((SRMv2__ArrayOfTPutRequestFileStatus*)a)->putStatusArray = (SRMv2__TPutRequestFileStatus **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_putStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTPutRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus, 0, sizeof(SRMv2__ArrayOfTPutRequestFileStatus), 0, soap_copy_SRMv2__ArrayOfTPutRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTPutRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTPutRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTPutRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTPutRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTPutRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTPutRequestFileStatus);
		((SRMv2__ArrayOfTPutRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTPutRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTPutRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTPutRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTPutRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTPutRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTPutRequestFileStatus*)p = *(SRMv2__ArrayOfTPutRequestFileStatus*)q;
}

void SRMv2__TPutRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TPutRequestFileStatus*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TPutRequestFileStatus*)this)->estimatedWaitTimeOnQueue);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TPutRequestFileStatus*)this)->fileSize);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TPutRequestFileStatus*)this)->remainingPinTime);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TPutRequestFileStatus*)this)->siteURL);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TPutRequestFileStatus*)this)->status);
	soap_serialize_PointerToSRMv2__TTURL(soap, &((SRMv2__TPutRequestFileStatus*)this)->transferURL);
	/* transient soap skipped */
}

void SRMv2__TPutRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TPutRequestFileStatus*)this)->estimatedProcessingTime = NULL;
	((SRMv2__TPutRequestFileStatus*)this)->estimatedWaitTimeOnQueue = NULL;
	((SRMv2__TPutRequestFileStatus*)this)->fileSize = NULL;
	((SRMv2__TPutRequestFileStatus*)this)->remainingPinTime = NULL;
	((SRMv2__TPutRequestFileStatus*)this)->siteURL = NULL;
	((SRMv2__TPutRequestFileStatus*)this)->status = NULL;
	((SRMv2__TPutRequestFileStatus*)this)->transferURL = NULL;
	/* transient soap skipped */
}

int SRMv2__TPutRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TPutRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TPutRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TPutRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPutRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__TPutRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPutRequestFileStatus), type);
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedProcessingTime", -1, &(((SRMv2__TPutRequestFileStatus*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedWaitTimeOnQueue", -1, &(((SRMv2__TPutRequestFileStatus*)a)->estimatedWaitTimeOnQueue), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "fileSize", -1, &(((SRMv2__TPutRequestFileStatus*)a)->fileSize), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "remainingPinTime", -1, &(((SRMv2__TPutRequestFileStatus*)a)->remainingPinTime), "");
	soap_out_PointerToSRMv2__TSURL(soap, "siteURL", -1, &(((SRMv2__TPutRequestFileStatus*)a)->siteURL), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TPutRequestFileStatus*)a)->status), "");
	soap_out_PointerToSRMv2__TTURL(soap, "transferURL", -1, &(((SRMv2__TPutRequestFileStatus*)a)->transferURL), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TPutRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TPutRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TPutRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__TPutRequestFileStatus(struct soap *soap, SRMv2__TPutRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPutRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TPutRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TPutRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TPutRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__TPutRequestFileStatus(struct soap *soap, const char *tag, SRMv2__TPutRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TPutRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPutRequestFileStatus, sizeof(SRMv2__TPutRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TPutRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TPutRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_estimatedProcessingTime1 = 1, soap_flag_estimatedWaitTimeOnQueue1 = 1, soap_flag_fileSize1 = 1, soap_flag_remainingPinTime1 = 1, soap_flag_siteURL1 = 1, soap_flag_status1 = 1, soap_flag_transferURL1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedProcessingTime", &(((SRMv2__TPutRequestFileStatus*)a)->estimatedProcessingTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_estimatedWaitTimeOnQueue1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedWaitTimeOnQueue", &(((SRMv2__TPutRequestFileStatus*)a)->estimatedWaitTimeOnQueue), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_estimatedWaitTimeOnQueue1--;
					continue;
				}
			if (soap_flag_fileSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "fileSize", &(((SRMv2__TPutRequestFileStatus*)a)->fileSize), "SRMv2:TSizeInBytes"))
				{	soap_flag_fileSize1--;
					continue;
				}
			if (soap_flag_remainingPinTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "remainingPinTime", &(((SRMv2__TPutRequestFileStatus*)a)->remainingPinTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_remainingPinTime1--;
					continue;
				}
			if (soap_flag_siteURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "siteURL", &(((SRMv2__TPutRequestFileStatus*)a)->siteURL), "SRMv2:TSURL"))
				{	soap_flag_siteURL1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TPutRequestFileStatus*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_transferURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TTURL(soap, "transferURL", &(((SRMv2__TPutRequestFileStatus*)a)->transferURL), "SRMv2:TTURL"))
				{	soap_flag_transferURL1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TPutRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPutRequestFileStatus, 0, sizeof(SRMv2__TPutRequestFileStatus), 0, soap_copy_SRMv2__TPutRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TPutRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__TPutRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TPutRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TPutRequestFileStatus(struct soap *soap, SRMv2__TPutRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TPutRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__TPutRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TPutRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TPutRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TPutRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__TPutRequestFileStatus);
		((SRMv2__TPutRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TPutRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__TPutRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__TPutRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TPutRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TPutRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TPutRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__TPutRequestFileStatus*)p = *(SRMv2__TPutRequestFileStatus*)q;
}

void SRMv2__ArrayOfTGetRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTGetRequestFileStatus*)this)->getStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTGetRequestFileStatus*)this)->__sizegetStatusArray; i++)
		{
			soap_serialize_PointerToSRMv2__TGetRequestFileStatus(soap, ((SRMv2__ArrayOfTGetRequestFileStatus*)this)->getStatusArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTGetRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTGetRequestFileStatus*)this)->__sizegetStatusArray = 0;
	((SRMv2__ArrayOfTGetRequestFileStatus*)this)->getStatusArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTGetRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTGetRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTGetRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTGetRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus), type);
	if (((SRMv2__ArrayOfTGetRequestFileStatus*)a)->getStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTGetRequestFileStatus*)a)->__sizegetStatusArray; i++)
			soap_out_PointerToSRMv2__TGetRequestFileStatus(soap, "getStatusArray", -1, ((SRMv2__ArrayOfTGetRequestFileStatus*)a)->getStatusArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTGetRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTGetRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTGetRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTGetRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTGetRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTGetRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTGetRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTGetRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, const char *tag, SRMv2__ArrayOfTGetRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTGetRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus, sizeof(SRMv2__ArrayOfTGetRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTGetRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_getStatusArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TGetRequestFileStatus **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTGetRequestFileStatus*)a)->__sizegetStatusArray = 0; !soap_element_begin_in(soap, "getStatusArray", 1); ((SRMv2__ArrayOfTGetRequestFileStatus*)a)->__sizegetStatusArray++)
				{	p = (SRMv2__TGetRequestFileStatus **)soap_push_block(soap, sizeof(SRMv2__TGetRequestFileStatus *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TGetRequestFileStatus(soap, "getStatusArray", p, "SRMv2:TGetRequestFileStatus"))
						break;
					soap_flag_getStatusArray1 = 0;
				}
				((SRMv2__ArrayOfTGetRequestFileStatus*)a)->getStatusArray = (SRMv2__TGetRequestFileStatus **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_getStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTGetRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus, 0, sizeof(SRMv2__ArrayOfTGetRequestFileStatus), 0, soap_copy_SRMv2__ArrayOfTGetRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTGetRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTGetRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTGetRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTGetRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTGetRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTGetRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTGetRequestFileStatus);
		((SRMv2__ArrayOfTGetRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTGetRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTGetRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTGetRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTGetRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTGetRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTGetRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTGetRequestFileStatus*)p = *(SRMv2__ArrayOfTGetRequestFileStatus*)q;
}

void SRMv2__TGetRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TGetRequestFileStatus*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TGetRequestFileStatus*)this)->estimatedWaitTimeOnQueue);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TGetRequestFileStatus*)this)->fileSize);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TGetRequestFileStatus*)this)->fromSURLInfo);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TGetRequestFileStatus*)this)->remainingPinTime);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TGetRequestFileStatus*)this)->status);
	soap_serialize_PointerToSRMv2__TTURL(soap, &((SRMv2__TGetRequestFileStatus*)this)->transferURL);
	/* transient soap skipped */
}

void SRMv2__TGetRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TGetRequestFileStatus*)this)->estimatedProcessingTime = NULL;
	((SRMv2__TGetRequestFileStatus*)this)->estimatedWaitTimeOnQueue = NULL;
	((SRMv2__TGetRequestFileStatus*)this)->fileSize = NULL;
	((SRMv2__TGetRequestFileStatus*)this)->fromSURLInfo = NULL;
	((SRMv2__TGetRequestFileStatus*)this)->remainingPinTime = NULL;
	((SRMv2__TGetRequestFileStatus*)this)->status = NULL;
	((SRMv2__TGetRequestFileStatus*)this)->transferURL = NULL;
	/* transient soap skipped */
}

int SRMv2__TGetRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TGetRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TGetRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TGetRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TGetRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__TGetRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TGetRequestFileStatus), type);
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedProcessingTime", -1, &(((SRMv2__TGetRequestFileStatus*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedWaitTimeOnQueue", -1, &(((SRMv2__TGetRequestFileStatus*)a)->estimatedWaitTimeOnQueue), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "fileSize", -1, &(((SRMv2__TGetRequestFileStatus*)a)->fileSize), "");
	soap_out_PointerToSRMv2__TSURL(soap, "fromSURLInfo", -1, &(((SRMv2__TGetRequestFileStatus*)a)->fromSURLInfo), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "remainingPinTime", -1, &(((SRMv2__TGetRequestFileStatus*)a)->remainingPinTime), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TGetRequestFileStatus*)a)->status), "");
	soap_out_PointerToSRMv2__TTURL(soap, "transferURL", -1, &(((SRMv2__TGetRequestFileStatus*)a)->transferURL), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TGetRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TGetRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TGetRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__TGetRequestFileStatus(struct soap *soap, SRMv2__TGetRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TGetRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TGetRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TGetRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TGetRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__TGetRequestFileStatus(struct soap *soap, const char *tag, SRMv2__TGetRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TGetRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TGetRequestFileStatus, sizeof(SRMv2__TGetRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TGetRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TGetRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_estimatedProcessingTime1 = 1, soap_flag_estimatedWaitTimeOnQueue1 = 1, soap_flag_fileSize1 = 1, soap_flag_fromSURLInfo1 = 1, soap_flag_remainingPinTime1 = 1, soap_flag_status1 = 1, soap_flag_transferURL1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedProcessingTime", &(((SRMv2__TGetRequestFileStatus*)a)->estimatedProcessingTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_estimatedWaitTimeOnQueue1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "estimatedWaitTimeOnQueue", &(((SRMv2__TGetRequestFileStatus*)a)->estimatedWaitTimeOnQueue), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_estimatedWaitTimeOnQueue1--;
					continue;
				}
			if (soap_flag_fileSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "fileSize", &(((SRMv2__TGetRequestFileStatus*)a)->fileSize), "SRMv2:TSizeInBytes"))
				{	soap_flag_fileSize1--;
					continue;
				}
			if (soap_flag_fromSURLInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "fromSURLInfo", &(((SRMv2__TGetRequestFileStatus*)a)->fromSURLInfo), "SRMv2:TSURL"))
				{	soap_flag_fromSURLInfo1--;
					continue;
				}
			if (soap_flag_remainingPinTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "remainingPinTime", &(((SRMv2__TGetRequestFileStatus*)a)->remainingPinTime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_remainingPinTime1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TGetRequestFileStatus*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_transferURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TTURL(soap, "transferURL", &(((SRMv2__TGetRequestFileStatus*)a)->transferURL), "SRMv2:TTURL"))
				{	soap_flag_transferURL1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fromSURLInfo1 > 0 || soap_flag_status1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TGetRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TGetRequestFileStatus, 0, sizeof(SRMv2__TGetRequestFileStatus), 0, soap_copy_SRMv2__TGetRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TGetRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__TGetRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TGetRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TGetRequestFileStatus(struct soap *soap, SRMv2__TGetRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TGetRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__TGetRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TGetRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TGetRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TGetRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__TGetRequestFileStatus);
		((SRMv2__TGetRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TGetRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__TGetRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__TGetRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TGetRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TGetRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TGetRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__TGetRequestFileStatus*)p = *(SRMv2__TGetRequestFileStatus*)q;
}

void SRMv2__ArrayOfTSURLReturnStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSURLReturnStatus*)this)->surlReturnStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLReturnStatus*)this)->__sizesurlReturnStatusArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSURLReturnStatus(soap, ((SRMv2__ArrayOfTSURLReturnStatus*)this)->surlReturnStatusArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSURLReturnStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSURLReturnStatus*)this)->__sizesurlReturnStatusArray = 0;
	((SRMv2__ArrayOfTSURLReturnStatus*)this)->surlReturnStatusArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSURLReturnStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSURLReturnStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSURLReturnStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSURLReturnStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus), type);
	if (((SRMv2__ArrayOfTSURLReturnStatus*)a)->surlReturnStatusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLReturnStatus*)a)->__sizesurlReturnStatusArray; i++)
			soap_out_PointerToSRMv2__TSURLReturnStatus(soap, "surlReturnStatusArray", -1, ((SRMv2__ArrayOfTSURLReturnStatus*)a)->surlReturnStatusArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSURLReturnStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSURLReturnStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLReturnStatus * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, SRMv2__ArrayOfTSURLReturnStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSURLReturnStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSURLReturnStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSURLReturnStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLReturnStatus * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, const char *tag, SRMv2__ArrayOfTSURLReturnStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSURLReturnStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus, sizeof(SRMv2__ArrayOfTSURLReturnStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSURLReturnStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surlReturnStatusArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surlReturnStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSURLReturnStatus **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSURLReturnStatus*)a)->__sizesurlReturnStatusArray = 0; !soap_element_begin_in(soap, "surlReturnStatusArray", 1); ((SRMv2__ArrayOfTSURLReturnStatus*)a)->__sizesurlReturnStatusArray++)
				{	p = (SRMv2__TSURLReturnStatus **)soap_push_block(soap, sizeof(SRMv2__TSURLReturnStatus *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSURLReturnStatus(soap, "surlReturnStatusArray", p, "SRMv2:TSURLReturnStatus"))
						break;
					soap_flag_surlReturnStatusArray1 = 0;
				}
				((SRMv2__ArrayOfTSURLReturnStatus*)a)->surlReturnStatusArray = (SRMv2__TSURLReturnStatus **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlReturnStatusArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSURLReturnStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus, 0, sizeof(SRMv2__ArrayOfTSURLReturnStatus), 0, soap_copy_SRMv2__ArrayOfTSURLReturnStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSURLReturnStatus * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSURLReturnStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, SRMv2__ArrayOfTSURLReturnStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLReturnStatus * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSURLReturnStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLReturnStatus;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSURLReturnStatus);
		((SRMv2__ArrayOfTSURLReturnStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLReturnStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSURLReturnStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSURLReturnStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTSURLReturnStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTSURLReturnStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTSURLReturnStatus %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTSURLReturnStatus*)p = *(SRMv2__ArrayOfTSURLReturnStatus*)q;
}

void SRMv2__TSURLReturnStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TSURLReturnStatus*)this)->status);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TSURLReturnStatus*)this)->surl);
	/* transient soap skipped */
}

void SRMv2__TSURLReturnStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TSURLReturnStatus*)this)->status = NULL;
	((SRMv2__TSURLReturnStatus*)this)->surl = NULL;
	/* transient soap skipped */
}

int SRMv2__TSURLReturnStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSURLReturnStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSURLReturnStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSURLReturnStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSURLReturnStatus(struct soap *soap, const char *tag, int id, const SRMv2__TSURLReturnStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSURLReturnStatus), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TSURLReturnStatus*)a)->status), "");
	soap_out_PointerToSRMv2__TSURL(soap, "surl", -1, &(((SRMv2__TSURLReturnStatus*)a)->surl), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSURLReturnStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSURLReturnStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSURLReturnStatus * SOAP_FMAC4 soap_get_SRMv2__TSURLReturnStatus(struct soap *soap, SRMv2__TSURLReturnStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSURLReturnStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSURLReturnStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSURLReturnStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSURLReturnStatus * SOAP_FMAC4 soap_in_SRMv2__TSURLReturnStatus(struct soap *soap, const char *tag, SRMv2__TSURLReturnStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSURLReturnStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSURLReturnStatus, sizeof(SRMv2__TSURLReturnStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSURLReturnStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSURLReturnStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1, soap_flag_surl1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TSURLReturnStatus*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_surl1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "surl", &(((SRMv2__TSURLReturnStatus*)a)->surl), "SRMv2:TSURL"))
				{	soap_flag_surl1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1 > 0 || soap_flag_surl1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSURLReturnStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSURLReturnStatus, 0, sizeof(SRMv2__TSURLReturnStatus), 0, soap_copy_SRMv2__TSURLReturnStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSURLReturnStatus * SOAP_FMAC6 soap_new_SRMv2__TSURLReturnStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSURLReturnStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSURLReturnStatus(struct soap *soap, SRMv2__TSURLReturnStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSURLReturnStatus * SOAP_FMAC4 soap_instantiate_SRMv2__TSURLReturnStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSURLReturnStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSURLReturnStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSURLReturnStatus;
		if (size)
			*size = sizeof(SRMv2__TSURLReturnStatus);
		((SRMv2__TSURLReturnStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSURLReturnStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__TSURLReturnStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__TSURLReturnStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSURLReturnStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSURLReturnStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSURLReturnStatus %p -> %p\n", q, p));
	*(SRMv2__TSURLReturnStatus*)p = *(SRMv2__TSURLReturnStatus*)q;
}

void SRMv2__TReturnStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TReturnStatus*)this)->explanation);
	/* transient soap skipped */
}

void SRMv2__TReturnStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TReturnStatus*)this)->explanation);
	soap_default_SRMv2__TStatusCode(soap, &((SRMv2__TReturnStatus*)this)->statusCode);
	/* transient soap skipped */
}

int SRMv2__TReturnStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TReturnStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TReturnStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TReturnStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TReturnStatus(struct soap *soap, const char *tag, int id, const SRMv2__TReturnStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TReturnStatus), type);
	soap_out_string(soap, "explanation", -1, &(((SRMv2__TReturnStatus*)a)->explanation), "");
	soap_out_SRMv2__TStatusCode(soap, "statusCode", -1, &(((SRMv2__TReturnStatus*)a)->statusCode), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TReturnStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TReturnStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TReturnStatus * SOAP_FMAC4 soap_get_SRMv2__TReturnStatus(struct soap *soap, SRMv2__TReturnStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TReturnStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TReturnStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TReturnStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TReturnStatus * SOAP_FMAC4 soap_in_SRMv2__TReturnStatus(struct soap *soap, const char *tag, SRMv2__TReturnStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TReturnStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TReturnStatus, sizeof(SRMv2__TReturnStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TReturnStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TReturnStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_explanation1 = 1, soap_flag_statusCode1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_explanation1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "explanation", &(((SRMv2__TReturnStatus*)a)->explanation), "xsd:string"))
				{	soap_flag_explanation1--;
					continue;
				}
			if (soap_flag_statusCode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TStatusCode(soap, "statusCode", &(((SRMv2__TReturnStatus*)a)->statusCode), "SRMv2:TStatusCode"))
				{	soap_flag_statusCode1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_statusCode1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TReturnStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TReturnStatus, 0, sizeof(SRMv2__TReturnStatus), 0, soap_copy_SRMv2__TReturnStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TReturnStatus * SOAP_FMAC6 soap_new_SRMv2__TReturnStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TReturnStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TReturnStatus(struct soap *soap, SRMv2__TReturnStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TReturnStatus * SOAP_FMAC4 soap_instantiate_SRMv2__TReturnStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TReturnStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TReturnStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TReturnStatus;
		if (size)
			*size = sizeof(SRMv2__TReturnStatus);
		((SRMv2__TReturnStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TReturnStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__TReturnStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__TReturnStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TReturnStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TReturnStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TReturnStatus %p -> %p\n", q, p));
	*(SRMv2__TReturnStatus*)p = *(SRMv2__TReturnStatus*)q;
}

void SRMv2__ArrayOfTCopyFileRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTCopyFileRequest*)this)->copyRequestArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTCopyFileRequest*)this)->__sizecopyRequestArray; i++)
		{
			soap_serialize_PointerToSRMv2__TCopyFileRequest(soap, ((SRMv2__ArrayOfTCopyFileRequest*)this)->copyRequestArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTCopyFileRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTCopyFileRequest*)this)->__sizecopyRequestArray = 0;
	((SRMv2__ArrayOfTCopyFileRequest*)this)->copyRequestArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTCopyFileRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTCopyFileRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTCopyFileRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTCopyFileRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest), type);
	if (((SRMv2__ArrayOfTCopyFileRequest*)a)->copyRequestArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTCopyFileRequest*)a)->__sizecopyRequestArray; i++)
			soap_out_PointerToSRMv2__TCopyFileRequest(soap, "copyRequestArray", -1, ((SRMv2__ArrayOfTCopyFileRequest*)a)->copyRequestArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTCopyFileRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTCopyFileRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyFileRequest * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, SRMv2__ArrayOfTCopyFileRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTCopyFileRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTCopyFileRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTCopyFileRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyFileRequest * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, const char *tag, SRMv2__ArrayOfTCopyFileRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTCopyFileRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest, sizeof(SRMv2__ArrayOfTCopyFileRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTCopyFileRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_copyRequestArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_copyRequestArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TCopyFileRequest **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTCopyFileRequest*)a)->__sizecopyRequestArray = 0; !soap_element_begin_in(soap, "copyRequestArray", 1); ((SRMv2__ArrayOfTCopyFileRequest*)a)->__sizecopyRequestArray++)
				{	p = (SRMv2__TCopyFileRequest **)soap_push_block(soap, sizeof(SRMv2__TCopyFileRequest *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TCopyFileRequest(soap, "copyRequestArray", p, "SRMv2:TCopyFileRequest"))
						break;
					soap_flag_copyRequestArray1 = 0;
				}
				((SRMv2__ArrayOfTCopyFileRequest*)a)->copyRequestArray = (SRMv2__TCopyFileRequest **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_copyRequestArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTCopyFileRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest, 0, sizeof(SRMv2__ArrayOfTCopyFileRequest), 0, soap_copy_SRMv2__ArrayOfTCopyFileRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTCopyFileRequest * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTCopyFileRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, SRMv2__ArrayOfTCopyFileRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyFileRequest * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTCopyFileRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTCopyFileRequest;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTCopyFileRequest);
		((SRMv2__ArrayOfTCopyFileRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTCopyFileRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTCopyFileRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTCopyFileRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTCopyFileRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTCopyFileRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTCopyFileRequest %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTCopyFileRequest*)p = *(SRMv2__ArrayOfTCopyFileRequest*)q;
}

void SRMv2__TCopyFileRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TDirOption(soap, &((SRMv2__TCopyFileRequest*)this)->dirOption);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__TCopyFileRequest*)this)->fileStorageType);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__TCopyFileRequest*)this)->fromSURLInfo);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TCopyFileRequest*)this)->lifetime);
	soap_serialize_PointerToSRMv2__TOverwriteMode(soap, &((SRMv2__TCopyFileRequest*)this)->overwriteMode);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__TCopyFileRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__TCopyFileRequest*)this)->toSURLInfo);
	/* transient soap skipped */
}

void SRMv2__TCopyFileRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TCopyFileRequest*)this)->dirOption = NULL;
	((SRMv2__TCopyFileRequest*)this)->fileStorageType = NULL;
	((SRMv2__TCopyFileRequest*)this)->fromSURLInfo = NULL;
	((SRMv2__TCopyFileRequest*)this)->lifetime = NULL;
	((SRMv2__TCopyFileRequest*)this)->overwriteMode = NULL;
	((SRMv2__TCopyFileRequest*)this)->spaceToken = NULL;
	((SRMv2__TCopyFileRequest*)this)->toSURLInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__TCopyFileRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TCopyFileRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TCopyFileRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TCopyFileRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TCopyFileRequest(struct soap *soap, const char *tag, int id, const SRMv2__TCopyFileRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TCopyFileRequest), type);
	soap_out_PointerToSRMv2__TDirOption(soap, "dirOption", -1, &(((SRMv2__TCopyFileRequest*)a)->dirOption), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", -1, &(((SRMv2__TCopyFileRequest*)a)->fileStorageType), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "fromSURLInfo", -1, &(((SRMv2__TCopyFileRequest*)a)->fromSURLInfo), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetime", -1, &(((SRMv2__TCopyFileRequest*)a)->lifetime), "");
	soap_out_PointerToSRMv2__TOverwriteMode(soap, "overwriteMode", -1, &(((SRMv2__TCopyFileRequest*)a)->overwriteMode), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__TCopyFileRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "toSURLInfo", -1, &(((SRMv2__TCopyFileRequest*)a)->toSURLInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TCopyFileRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TCopyFileRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TCopyFileRequest * SOAP_FMAC4 soap_get_SRMv2__TCopyFileRequest(struct soap *soap, SRMv2__TCopyFileRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TCopyFileRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TCopyFileRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TCopyFileRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TCopyFileRequest * SOAP_FMAC4 soap_in_SRMv2__TCopyFileRequest(struct soap *soap, const char *tag, SRMv2__TCopyFileRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TCopyFileRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TCopyFileRequest, sizeof(SRMv2__TCopyFileRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TCopyFileRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TCopyFileRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_dirOption1 = 1, soap_flag_fileStorageType1 = 1, soap_flag_fromSURLInfo1 = 1, soap_flag_lifetime1 = 1, soap_flag_overwriteMode1 = 1, soap_flag_spaceToken1 = 1, soap_flag_toSURLInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_dirOption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TDirOption(soap, "dirOption", &(((SRMv2__TCopyFileRequest*)a)->dirOption), "SRMv2:TDirOption"))
				{	soap_flag_dirOption1--;
					continue;
				}
			if (soap_flag_fileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", &(((SRMv2__TCopyFileRequest*)a)->fileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_fileStorageType1--;
					continue;
				}
			if (soap_flag_fromSURLInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "fromSURLInfo", &(((SRMv2__TCopyFileRequest*)a)->fromSURLInfo), "SRMv2:TSURLInfo"))
				{	soap_flag_fromSURLInfo1--;
					continue;
				}
			if (soap_flag_lifetime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetime", &(((SRMv2__TCopyFileRequest*)a)->lifetime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetime1--;
					continue;
				}
			if (soap_flag_overwriteMode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOverwriteMode(soap, "overwriteMode", &(((SRMv2__TCopyFileRequest*)a)->overwriteMode), "SRMv2:TOverwriteMode"))
				{	soap_flag_overwriteMode1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__TCopyFileRequest*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_toSURLInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "toSURLInfo", &(((SRMv2__TCopyFileRequest*)a)->toSURLInfo), "SRMv2:TSURLInfo"))
				{	soap_flag_toSURLInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fromSURLInfo1 > 0 || soap_flag_toSURLInfo1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TCopyFileRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TCopyFileRequest, 0, sizeof(SRMv2__TCopyFileRequest), 0, soap_copy_SRMv2__TCopyFileRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TCopyFileRequest * SOAP_FMAC6 soap_new_SRMv2__TCopyFileRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TCopyFileRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TCopyFileRequest(struct soap *soap, SRMv2__TCopyFileRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TCopyFileRequest * SOAP_FMAC4 soap_instantiate_SRMv2__TCopyFileRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TCopyFileRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TCopyFileRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TCopyFileRequest;
		if (size)
			*size = sizeof(SRMv2__TCopyFileRequest);
		((SRMv2__TCopyFileRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TCopyFileRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__TCopyFileRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__TCopyFileRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TCopyFileRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TCopyFileRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TCopyFileRequest %p -> %p\n", q, p));
	*(SRMv2__TCopyFileRequest*)p = *(SRMv2__TCopyFileRequest*)q;
}

void SRMv2__ArrayOfTPutFileRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTPutFileRequest*)this)->putRequestArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPutFileRequest*)this)->__sizeputRequestArray; i++)
		{
			soap_serialize_PointerToSRMv2__TPutFileRequest(soap, ((SRMv2__ArrayOfTPutFileRequest*)this)->putRequestArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTPutFileRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTPutFileRequest*)this)->__sizeputRequestArray = 0;
	((SRMv2__ArrayOfTPutFileRequest*)this)->putRequestArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTPutFileRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTPutFileRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTPutFileRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTPutFileRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest), type);
	if (((SRMv2__ArrayOfTPutFileRequest*)a)->putRequestArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPutFileRequest*)a)->__sizeputRequestArray; i++)
			soap_out_PointerToSRMv2__TPutFileRequest(soap, "putRequestArray", -1, ((SRMv2__ArrayOfTPutFileRequest*)a)->putRequestArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTPutFileRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTPutFileRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutFileRequest * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, SRMv2__ArrayOfTPutFileRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTPutFileRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTPutFileRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTPutFileRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutFileRequest * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, const char *tag, SRMv2__ArrayOfTPutFileRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTPutFileRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest, sizeof(SRMv2__ArrayOfTPutFileRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTPutFileRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_putRequestArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_putRequestArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TPutFileRequest **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTPutFileRequest*)a)->__sizeputRequestArray = 0; !soap_element_begin_in(soap, "putRequestArray", 1); ((SRMv2__ArrayOfTPutFileRequest*)a)->__sizeputRequestArray++)
				{	p = (SRMv2__TPutFileRequest **)soap_push_block(soap, sizeof(SRMv2__TPutFileRequest *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TPutFileRequest(soap, "putRequestArray", p, "SRMv2:TPutFileRequest"))
						break;
					soap_flag_putRequestArray1 = 0;
				}
				((SRMv2__ArrayOfTPutFileRequest*)a)->putRequestArray = (SRMv2__TPutFileRequest **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_putRequestArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTPutFileRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest, 0, sizeof(SRMv2__ArrayOfTPutFileRequest), 0, soap_copy_SRMv2__ArrayOfTPutFileRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTPutFileRequest * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTPutFileRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, SRMv2__ArrayOfTPutFileRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutFileRequest * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTPutFileRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTPutFileRequest;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTPutFileRequest);
		((SRMv2__ArrayOfTPutFileRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTPutFileRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTPutFileRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTPutFileRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTPutFileRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTPutFileRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTPutFileRequest %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTPutFileRequest*)p = *(SRMv2__ArrayOfTPutFileRequest*)q;
}

void SRMv2__TPutFileRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__TPutFileRequest*)this)->fileStorageType);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TPutFileRequest*)this)->knownSizeOfThisFile);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TPutFileRequest*)this)->lifetime);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__TPutFileRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__TPutFileRequest*)this)->toSURLInfo);
	/* transient soap skipped */
}

void SRMv2__TPutFileRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TPutFileRequest*)this)->fileStorageType = NULL;
	((SRMv2__TPutFileRequest*)this)->knownSizeOfThisFile = NULL;
	((SRMv2__TPutFileRequest*)this)->lifetime = NULL;
	((SRMv2__TPutFileRequest*)this)->spaceToken = NULL;
	((SRMv2__TPutFileRequest*)this)->toSURLInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__TPutFileRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TPutFileRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TPutFileRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TPutFileRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPutFileRequest(struct soap *soap, const char *tag, int id, const SRMv2__TPutFileRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPutFileRequest), type);
	soap_out_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", -1, &(((SRMv2__TPutFileRequest*)a)->fileStorageType), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "knownSizeOfThisFile", -1, &(((SRMv2__TPutFileRequest*)a)->knownSizeOfThisFile), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetime", -1, &(((SRMv2__TPutFileRequest*)a)->lifetime), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__TPutFileRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "toSURLInfo", -1, &(((SRMv2__TPutFileRequest*)a)->toSURLInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TPutFileRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TPutFileRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TPutFileRequest * SOAP_FMAC4 soap_get_SRMv2__TPutFileRequest(struct soap *soap, SRMv2__TPutFileRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPutFileRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TPutFileRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TPutFileRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TPutFileRequest * SOAP_FMAC4 soap_in_SRMv2__TPutFileRequest(struct soap *soap, const char *tag, SRMv2__TPutFileRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TPutFileRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPutFileRequest, sizeof(SRMv2__TPutFileRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TPutFileRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TPutFileRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fileStorageType1 = 1, soap_flag_knownSizeOfThisFile1 = 1, soap_flag_lifetime1 = 1, soap_flag_spaceToken1 = 1, soap_flag_toSURLInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", &(((SRMv2__TPutFileRequest*)a)->fileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_fileStorageType1--;
					continue;
				}
			if (soap_flag_knownSizeOfThisFile1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "knownSizeOfThisFile", &(((SRMv2__TPutFileRequest*)a)->knownSizeOfThisFile), "SRMv2:TSizeInBytes"))
				{	soap_flag_knownSizeOfThisFile1--;
					continue;
				}
			if (soap_flag_lifetime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetime", &(((SRMv2__TPutFileRequest*)a)->lifetime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetime1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__TPutFileRequest*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_toSURLInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "toSURLInfo", &(((SRMv2__TPutFileRequest*)a)->toSURLInfo), "SRMv2:TSURLInfo"))
				{	soap_flag_toSURLInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_toSURLInfo1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TPutFileRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPutFileRequest, 0, sizeof(SRMv2__TPutFileRequest), 0, soap_copy_SRMv2__TPutFileRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TPutFileRequest * SOAP_FMAC6 soap_new_SRMv2__TPutFileRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TPutFileRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TPutFileRequest(struct soap *soap, SRMv2__TPutFileRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TPutFileRequest * SOAP_FMAC4 soap_instantiate_SRMv2__TPutFileRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TPutFileRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TPutFileRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TPutFileRequest;
		if (size)
			*size = sizeof(SRMv2__TPutFileRequest);
		((SRMv2__TPutFileRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TPutFileRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__TPutFileRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__TPutFileRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TPutFileRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TPutFileRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TPutFileRequest %p -> %p\n", q, p));
	*(SRMv2__TPutFileRequest*)p = *(SRMv2__TPutFileRequest*)q;
}

void SRMv2__ArrayOfTGetFileRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTGetFileRequest*)this)->getRequestArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTGetFileRequest*)this)->__sizegetRequestArray; i++)
		{
			soap_serialize_PointerToSRMv2__TGetFileRequest(soap, ((SRMv2__ArrayOfTGetFileRequest*)this)->getRequestArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTGetFileRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTGetFileRequest*)this)->__sizegetRequestArray = 0;
	((SRMv2__ArrayOfTGetFileRequest*)this)->getRequestArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTGetFileRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTGetFileRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTGetFileRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTGetFileRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest), type);
	if (((SRMv2__ArrayOfTGetFileRequest*)a)->getRequestArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTGetFileRequest*)a)->__sizegetRequestArray; i++)
			soap_out_PointerToSRMv2__TGetFileRequest(soap, "getRequestArray", -1, ((SRMv2__ArrayOfTGetFileRequest*)a)->getRequestArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTGetFileRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTGetFileRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTGetFileRequest * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, SRMv2__ArrayOfTGetFileRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTGetFileRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTGetFileRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTGetFileRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTGetFileRequest * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, const char *tag, SRMv2__ArrayOfTGetFileRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTGetFileRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest, sizeof(SRMv2__ArrayOfTGetFileRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTGetFileRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_getRequestArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getRequestArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TGetFileRequest **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTGetFileRequest*)a)->__sizegetRequestArray = 0; !soap_element_begin_in(soap, "getRequestArray", 1); ((SRMv2__ArrayOfTGetFileRequest*)a)->__sizegetRequestArray++)
				{	p = (SRMv2__TGetFileRequest **)soap_push_block(soap, sizeof(SRMv2__TGetFileRequest *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TGetFileRequest(soap, "getRequestArray", p, "SRMv2:TGetFileRequest"))
						break;
					soap_flag_getRequestArray1 = 0;
				}
				((SRMv2__ArrayOfTGetFileRequest*)a)->getRequestArray = (SRMv2__TGetFileRequest **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_getRequestArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTGetFileRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest, 0, sizeof(SRMv2__ArrayOfTGetFileRequest), 0, soap_copy_SRMv2__ArrayOfTGetFileRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTGetFileRequest * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTGetFileRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, SRMv2__ArrayOfTGetFileRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTGetFileRequest * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTGetFileRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTGetFileRequest;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTGetFileRequest);
		((SRMv2__ArrayOfTGetFileRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTGetFileRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTGetFileRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTGetFileRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTGetFileRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTGetFileRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTGetFileRequest %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTGetFileRequest*)p = *(SRMv2__ArrayOfTGetFileRequest*)q;
}

void SRMv2__TGetFileRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TDirOption(soap, &((SRMv2__TGetFileRequest*)this)->dirOption);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__TGetFileRequest*)this)->fileStorageType);
	soap_serialize_PointerToSRMv2__TSURLInfo(soap, &((SRMv2__TGetFileRequest*)this)->fromSURLInfo);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TGetFileRequest*)this)->lifetime);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__TGetFileRequest*)this)->spaceToken);
	/* transient soap skipped */
}

void SRMv2__TGetFileRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TGetFileRequest*)this)->dirOption = NULL;
	((SRMv2__TGetFileRequest*)this)->fileStorageType = NULL;
	((SRMv2__TGetFileRequest*)this)->fromSURLInfo = NULL;
	((SRMv2__TGetFileRequest*)this)->lifetime = NULL;
	((SRMv2__TGetFileRequest*)this)->spaceToken = NULL;
	/* transient soap skipped */
}

int SRMv2__TGetFileRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TGetFileRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TGetFileRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TGetFileRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TGetFileRequest(struct soap *soap, const char *tag, int id, const SRMv2__TGetFileRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TGetFileRequest), type);
	soap_out_PointerToSRMv2__TDirOption(soap, "dirOption", -1, &(((SRMv2__TGetFileRequest*)a)->dirOption), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", -1, &(((SRMv2__TGetFileRequest*)a)->fileStorageType), "");
	soap_out_PointerToSRMv2__TSURLInfo(soap, "fromSURLInfo", -1, &(((SRMv2__TGetFileRequest*)a)->fromSURLInfo), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetime", -1, &(((SRMv2__TGetFileRequest*)a)->lifetime), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__TGetFileRequest*)a)->spaceToken), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TGetFileRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TGetFileRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TGetFileRequest * SOAP_FMAC4 soap_get_SRMv2__TGetFileRequest(struct soap *soap, SRMv2__TGetFileRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TGetFileRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TGetFileRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TGetFileRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TGetFileRequest * SOAP_FMAC4 soap_in_SRMv2__TGetFileRequest(struct soap *soap, const char *tag, SRMv2__TGetFileRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TGetFileRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TGetFileRequest, sizeof(SRMv2__TGetFileRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TGetFileRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TGetFileRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_dirOption1 = 1, soap_flag_fileStorageType1 = 1, soap_flag_fromSURLInfo1 = 1, soap_flag_lifetime1 = 1, soap_flag_spaceToken1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_dirOption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TDirOption(soap, "dirOption", &(((SRMv2__TGetFileRequest*)a)->dirOption), "SRMv2:TDirOption"))
				{	soap_flag_dirOption1--;
					continue;
				}
			if (soap_flag_fileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", &(((SRMv2__TGetFileRequest*)a)->fileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_fileStorageType1--;
					continue;
				}
			if (soap_flag_fromSURLInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURLInfo(soap, "fromSURLInfo", &(((SRMv2__TGetFileRequest*)a)->fromSURLInfo), "SRMv2:TSURLInfo"))
				{	soap_flag_fromSURLInfo1--;
					continue;
				}
			if (soap_flag_lifetime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetime", &(((SRMv2__TGetFileRequest*)a)->lifetime), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetime1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__TGetFileRequest*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fromSURLInfo1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TGetFileRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TGetFileRequest, 0, sizeof(SRMv2__TGetFileRequest), 0, soap_copy_SRMv2__TGetFileRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TGetFileRequest * SOAP_FMAC6 soap_new_SRMv2__TGetFileRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TGetFileRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TGetFileRequest(struct soap *soap, SRMv2__TGetFileRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TGetFileRequest * SOAP_FMAC4 soap_instantiate_SRMv2__TGetFileRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TGetFileRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TGetFileRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TGetFileRequest;
		if (size)
			*size = sizeof(SRMv2__TGetFileRequest);
		((SRMv2__TGetFileRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TGetFileRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__TGetFileRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__TGetFileRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TGetFileRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TGetFileRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TGetFileRequest %p -> %p\n", q, p));
	*(SRMv2__TGetFileRequest*)p = *(SRMv2__TGetFileRequest*)q;
}

void SRMv2__ArrayOfTSURLInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSURLInfo*)this)->surlInfoArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLInfo*)this)->__sizesurlInfoArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSURLInfo(soap, ((SRMv2__ArrayOfTSURLInfo*)this)->surlInfoArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSURLInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSURLInfo*)this)->__sizesurlInfoArray = 0;
	((SRMv2__ArrayOfTSURLInfo*)this)->surlInfoArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSURLInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSURLInfo);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSURLInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSURLInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSURLInfo(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSURLInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLInfo), type);
	if (((SRMv2__ArrayOfTSURLInfo*)a)->surlInfoArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLInfo*)a)->__sizesurlInfoArray; i++)
			soap_out_PointerToSRMv2__TSURLInfo(soap, "surlInfoArray", -1, ((SRMv2__ArrayOfTSURLInfo*)a)->surlInfoArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSURLInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSURLInfo(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLInfo * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSURLInfo(struct soap *soap, SRMv2__ArrayOfTSURLInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSURLInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSURLInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSURLInfo(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLInfo * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSURLInfo(struct soap *soap, const char *tag, SRMv2__ArrayOfTSURLInfo *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSURLInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLInfo, sizeof(SRMv2__ArrayOfTSURLInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSURLInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSURLInfo *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surlInfoArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surlInfoArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSURLInfo **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSURLInfo*)a)->__sizesurlInfoArray = 0; !soap_element_begin_in(soap, "surlInfoArray", 1); ((SRMv2__ArrayOfTSURLInfo*)a)->__sizesurlInfoArray++)
				{	p = (SRMv2__TSURLInfo **)soap_push_block(soap, sizeof(SRMv2__TSURLInfo *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSURLInfo(soap, "surlInfoArray", p, "SRMv2:TSURLInfo"))
						break;
					soap_flag_surlInfoArray1 = 0;
				}
				((SRMv2__ArrayOfTSURLInfo*)a)->surlInfoArray = (SRMv2__TSURLInfo **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlInfoArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSURLInfo *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSURLInfo, 0, sizeof(SRMv2__ArrayOfTSURLInfo), 0, soap_copy_SRMv2__ArrayOfTSURLInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSURLInfo * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSURLInfo(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSURLInfo(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSURLInfo(struct soap *soap, SRMv2__ArrayOfTSURLInfo *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLInfo * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSURLInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSURLInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSURLInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLInfo;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSURLInfo);
		((SRMv2__ArrayOfTSURLInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLInfo[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSURLInfo);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSURLInfo*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTSURLInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTSURLInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTSURLInfo %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTSURLInfo*)p = *(SRMv2__ArrayOfTSURLInfo*)q;
}

void SRMv2__TSURLInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TSURLInfo*)this)->SURLOrStFN);
	soap_serialize_PointerToSRMv2__TStorageSystemInfo(soap, &((SRMv2__TSURLInfo*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__TSURLInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TSURLInfo*)this)->SURLOrStFN = NULL;
	((SRMv2__TSURLInfo*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__TSURLInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSURLInfo);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSURLInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSURLInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSURLInfo(struct soap *soap, const char *tag, int id, const SRMv2__TSURLInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSURLInfo), type);
	soap_out_PointerToSRMv2__TSURL(soap, "SURLOrStFN", -1, &(((SRMv2__TSURLInfo*)a)->SURLOrStFN), "");
	soap_out_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", -1, &(((SRMv2__TSURLInfo*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSURLInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSURLInfo(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSURLInfo * SOAP_FMAC4 soap_get_SRMv2__TSURLInfo(struct soap *soap, SRMv2__TSURLInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSURLInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSURLInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSURLInfo(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSURLInfo * SOAP_FMAC4 soap_in_SRMv2__TSURLInfo(struct soap *soap, const char *tag, SRMv2__TSURLInfo *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSURLInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSURLInfo, sizeof(SRMv2__TSURLInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSURLInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSURLInfo *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SURLOrStFN1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SURLOrStFN1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "SURLOrStFN", &(((SRMv2__TSURLInfo*)a)->SURLOrStFN), "SRMv2:TSURL"))
				{	soap_flag_SURLOrStFN1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TStorageSystemInfo(soap, "storageSystemInfo", &(((SRMv2__TSURLInfo*)a)->storageSystemInfo), "SRMv2:TStorageSystemInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SURLOrStFN1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSURLInfo *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSURLInfo, 0, sizeof(SRMv2__TSURLInfo), 0, soap_copy_SRMv2__TSURLInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSURLInfo * SOAP_FMAC6 soap_new_SRMv2__TSURLInfo(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSURLInfo(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSURLInfo(struct soap *soap, SRMv2__TSURLInfo *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSURLInfo * SOAP_FMAC4 soap_instantiate_SRMv2__TSURLInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSURLInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSURLInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSURLInfo;
		if (size)
			*size = sizeof(SRMv2__TSURLInfo);
		((SRMv2__TSURLInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSURLInfo[n];
		if (size)
			*size = n * sizeof(SRMv2__TSURLInfo);
		for (int i = 0; i < n; i++)
			((SRMv2__TSURLInfo*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSURLInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSURLInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSURLInfo %p -> %p\n", q, p));
	*(SRMv2__TSURLInfo*)p = *(SRMv2__TSURLInfo*)q;
}

void SRMv2__TDirOption::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTobool(soap, &((SRMv2__TDirOption*)this)->allLevelRecursive);
	soap_embedded(soap, &((SRMv2__TDirOption*)this)->isSourceADirectory, SOAP_TYPE_bool);
	soap_embedded(soap, &((SRMv2__TDirOption*)this)->numOfLevels, SOAP_TYPE_int);
	/* transient soap skipped */
}

void SRMv2__TDirOption::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TDirOption*)this)->allLevelRecursive = NULL;
	soap_default_bool(soap, &((SRMv2__TDirOption*)this)->isSourceADirectory);
	soap_default_int(soap, &((SRMv2__TDirOption*)this)->numOfLevels);
	/* transient soap skipped */
}

int SRMv2__TDirOption::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TDirOption);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TDirOption::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TDirOption(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TDirOption(struct soap *soap, const char *tag, int id, const SRMv2__TDirOption *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TDirOption), type);
	soap_out_PointerTobool(soap, "allLevelRecursive", -1, &(((SRMv2__TDirOption*)a)->allLevelRecursive), "");
	soap_out_bool(soap, "isSourceADirectory", -1, &(((SRMv2__TDirOption*)a)->isSourceADirectory), "");
	soap_out_int(soap, "numOfLevels", -1, &(((SRMv2__TDirOption*)a)->numOfLevels), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TDirOption::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TDirOption(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TDirOption * SOAP_FMAC4 soap_get_SRMv2__TDirOption(struct soap *soap, SRMv2__TDirOption *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TDirOption(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TDirOption::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TDirOption(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TDirOption * SOAP_FMAC4 soap_in_SRMv2__TDirOption(struct soap *soap, const char *tag, SRMv2__TDirOption *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TDirOption *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TDirOption, sizeof(SRMv2__TDirOption), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TDirOption)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TDirOption *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_allLevelRecursive1 = 1, soap_flag_isSourceADirectory1 = 1, soap_flag_numOfLevels1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_allLevelRecursive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "allLevelRecursive", &(((SRMv2__TDirOption*)a)->allLevelRecursive), "xsd:boolean"))
				{	soap_flag_allLevelRecursive1--;
					continue;
				}
			if (soap_flag_isSourceADirectory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isSourceADirectory", &(((SRMv2__TDirOption*)a)->isSourceADirectory), "xsd:boolean"))
				{	soap_flag_isSourceADirectory1--;
					continue;
				}
			if (soap_flag_numOfLevels1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "numOfLevels", &(((SRMv2__TDirOption*)a)->numOfLevels), "xsd:int"))
				{	soap_flag_numOfLevels1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_isSourceADirectory1 > 0 || soap_flag_numOfLevels1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TDirOption *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TDirOption, 0, sizeof(SRMv2__TDirOption), 0, soap_copy_SRMv2__TDirOption);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TDirOption * SOAP_FMAC6 soap_new_SRMv2__TDirOption(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TDirOption(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TDirOption(struct soap *soap, SRMv2__TDirOption *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TDirOption * SOAP_FMAC4 soap_instantiate_SRMv2__TDirOption(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TDirOption(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TDirOption, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TDirOption;
		if (size)
			*size = sizeof(SRMv2__TDirOption);
		((SRMv2__TDirOption*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TDirOption[n];
		if (size)
			*size = n * sizeof(SRMv2__TDirOption);
		for (int i = 0; i < n; i++)
			((SRMv2__TDirOption*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TDirOption*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TDirOption(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TDirOption %p -> %p\n", q, p));
	*(SRMv2__TDirOption*)p = *(SRMv2__TDirOption*)q;
}

void SRMv2__TStorageSystemInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TStorageSystemInfo*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TStorageSystemInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TStorageSystemInfo*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TStorageSystemInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TStorageSystemInfo);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TStorageSystemInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TStorageSystemInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TStorageSystemInfo(struct soap *soap, const char *tag, int id, const SRMv2__TStorageSystemInfo *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TStorageSystemInfo), type);
	soap_out_string(soap, "value", -1, &(((SRMv2__TStorageSystemInfo*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TStorageSystemInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TStorageSystemInfo(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TStorageSystemInfo * SOAP_FMAC4 soap_get_SRMv2__TStorageSystemInfo(struct soap *soap, SRMv2__TStorageSystemInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TStorageSystemInfo(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TStorageSystemInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TStorageSystemInfo(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TStorageSystemInfo * SOAP_FMAC4 soap_in_SRMv2__TStorageSystemInfo(struct soap *soap, const char *tag, SRMv2__TStorageSystemInfo *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TStorageSystemInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TStorageSystemInfo, sizeof(SRMv2__TStorageSystemInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TStorageSystemInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TStorageSystemInfo *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &(((SRMv2__TStorageSystemInfo*)a)->value), "xsd:string"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TStorageSystemInfo *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TStorageSystemInfo, 0, sizeof(SRMv2__TStorageSystemInfo), 0, soap_copy_SRMv2__TStorageSystemInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TStorageSystemInfo * SOAP_FMAC6 soap_new_SRMv2__TStorageSystemInfo(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TStorageSystemInfo(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TStorageSystemInfo(struct soap *soap, SRMv2__TStorageSystemInfo *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TStorageSystemInfo * SOAP_FMAC4 soap_instantiate_SRMv2__TStorageSystemInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TStorageSystemInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TStorageSystemInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TStorageSystemInfo;
		if (size)
			*size = sizeof(SRMv2__TStorageSystemInfo);
		((SRMv2__TStorageSystemInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TStorageSystemInfo[n];
		if (size)
			*size = n * sizeof(SRMv2__TStorageSystemInfo);
		for (int i = 0; i < n; i++)
			((SRMv2__TStorageSystemInfo*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TStorageSystemInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TStorageSystemInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TStorageSystemInfo %p -> %p\n", q, p));
	*(SRMv2__TStorageSystemInfo*)p = *(SRMv2__TStorageSystemInfo*)q;
}

void SRMv2__ArrayOfTMetaDataSpace::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTMetaDataSpace*)this)->spaceDetailArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTMetaDataSpace*)this)->__sizespaceDetailArray; i++)
		{
			soap_serialize_PointerToSRMv2__TMetaDataSpace(soap, ((SRMv2__ArrayOfTMetaDataSpace*)this)->spaceDetailArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTMetaDataSpace::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTMetaDataSpace*)this)->__sizespaceDetailArray = 0;
	((SRMv2__ArrayOfTMetaDataSpace*)this)->spaceDetailArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTMetaDataSpace::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTMetaDataSpace::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTMetaDataSpace(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTMetaDataSpace *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace), type);
	if (((SRMv2__ArrayOfTMetaDataSpace*)a)->spaceDetailArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTMetaDataSpace*)a)->__sizespaceDetailArray; i++)
			soap_out_PointerToSRMv2__TMetaDataSpace(soap, "spaceDetailArray", -1, ((SRMv2__ArrayOfTMetaDataSpace*)a)->spaceDetailArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTMetaDataSpace::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTMetaDataSpace(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTMetaDataSpace * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, SRMv2__ArrayOfTMetaDataSpace *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTMetaDataSpace(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTMetaDataSpace::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTMetaDataSpace(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTMetaDataSpace * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, const char *tag, SRMv2__ArrayOfTMetaDataSpace *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTMetaDataSpace *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace, sizeof(SRMv2__ArrayOfTMetaDataSpace), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTMetaDataSpace *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_spaceDetailArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_spaceDetailArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TMetaDataSpace **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTMetaDataSpace*)a)->__sizespaceDetailArray = 0; !soap_element_begin_in(soap, "spaceDetailArray", 1); ((SRMv2__ArrayOfTMetaDataSpace*)a)->__sizespaceDetailArray++)
				{	p = (SRMv2__TMetaDataSpace **)soap_push_block(soap, sizeof(SRMv2__TMetaDataSpace *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TMetaDataSpace(soap, "spaceDetailArray", p, "SRMv2:TMetaDataSpace"))
						break;
					soap_flag_spaceDetailArray1 = 0;
				}
				((SRMv2__ArrayOfTMetaDataSpace*)a)->spaceDetailArray = (SRMv2__TMetaDataSpace **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_spaceDetailArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTMetaDataSpace *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace, 0, sizeof(SRMv2__ArrayOfTMetaDataSpace), 0, soap_copy_SRMv2__ArrayOfTMetaDataSpace);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTMetaDataSpace * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTMetaDataSpace(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, SRMv2__ArrayOfTMetaDataSpace *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTMetaDataSpace * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTMetaDataSpace(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTMetaDataSpace;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTMetaDataSpace);
		((SRMv2__ArrayOfTMetaDataSpace*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTMetaDataSpace[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTMetaDataSpace);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTMetaDataSpace*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTMetaDataSpace*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTMetaDataSpace(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTMetaDataSpace %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTMetaDataSpace*)p = *(SRMv2__ArrayOfTMetaDataSpace*)q;
}

void SRMv2__TMetaDataSpace::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TSpaceType(soap, &((SRMv2__TMetaDataSpace*)this)->type);
	soap_serialize_PointerToSRMv2__TSpaceToken(soap, &((SRMv2__TMetaDataSpace*)this)->spaceToken);
	soap_embedded(soap, &((SRMv2__TMetaDataSpace*)this)->isValid, SOAP_TYPE_bool);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__TMetaDataSpace*)this)->owner);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TMetaDataSpace*)this)->totalSize);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TMetaDataSpace*)this)->guaranteedSize);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TMetaDataSpace*)this)->unusedSize);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TMetaDataSpace*)this)->lifetimeAssigned);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TMetaDataSpace*)this)->lifetimeLeft);
	/* transient soap skipped */
}

void SRMv2__TMetaDataSpace::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TMetaDataSpace*)this)->type = NULL;
	((SRMv2__TMetaDataSpace*)this)->spaceToken = NULL;
	soap_default_bool(soap, &((SRMv2__TMetaDataSpace*)this)->isValid);
	((SRMv2__TMetaDataSpace*)this)->owner = NULL;
	((SRMv2__TMetaDataSpace*)this)->totalSize = NULL;
	((SRMv2__TMetaDataSpace*)this)->guaranteedSize = NULL;
	((SRMv2__TMetaDataSpace*)this)->unusedSize = NULL;
	((SRMv2__TMetaDataSpace*)this)->lifetimeAssigned = NULL;
	((SRMv2__TMetaDataSpace*)this)->lifetimeLeft = NULL;
	/* transient soap skipped */
}

int SRMv2__TMetaDataSpace::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TMetaDataSpace);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TMetaDataSpace::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TMetaDataSpace(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TMetaDataSpace(struct soap *soap, const char *tag, int id, const SRMv2__TMetaDataSpace *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TMetaDataSpace), type);
	soap_out_PointerToSRMv2__TSpaceType(soap, "type", -1, &(((SRMv2__TMetaDataSpace*)a)->type), "");
	soap_out_PointerToSRMv2__TSpaceToken(soap, "spaceToken", -1, &(((SRMv2__TMetaDataSpace*)a)->spaceToken), "");
	soap_out_bool(soap, "isValid", -1, &(((SRMv2__TMetaDataSpace*)a)->isValid), "");
	soap_out_PointerToSRMv2__TUserID(soap, "owner", -1, &(((SRMv2__TMetaDataSpace*)a)->owner), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "totalSize", -1, &(((SRMv2__TMetaDataSpace*)a)->totalSize), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "guaranteedSize", -1, &(((SRMv2__TMetaDataSpace*)a)->guaranteedSize), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "unusedSize", -1, &(((SRMv2__TMetaDataSpace*)a)->unusedSize), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeAssigned", -1, &(((SRMv2__TMetaDataSpace*)a)->lifetimeAssigned), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeLeft", -1, &(((SRMv2__TMetaDataSpace*)a)->lifetimeLeft), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TMetaDataSpace::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TMetaDataSpace(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TMetaDataSpace * SOAP_FMAC4 soap_get_SRMv2__TMetaDataSpace(struct soap *soap, SRMv2__TMetaDataSpace *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TMetaDataSpace(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TMetaDataSpace::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TMetaDataSpace(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TMetaDataSpace * SOAP_FMAC4 soap_in_SRMv2__TMetaDataSpace(struct soap *soap, const char *tag, SRMv2__TMetaDataSpace *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TMetaDataSpace *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TMetaDataSpace, sizeof(SRMv2__TMetaDataSpace), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TMetaDataSpace)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TMetaDataSpace *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_type1 = 1, soap_flag_spaceToken1 = 1, soap_flag_isValid1 = 1, soap_flag_owner1 = 1, soap_flag_totalSize1 = 1, soap_flag_guaranteedSize1 = 1, soap_flag_unusedSize1 = 1, soap_flag_lifetimeAssigned1 = 1, soap_flag_lifetimeLeft1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceType(soap, "type", &(((SRMv2__TMetaDataSpace*)a)->type), "SRMv2:TSpaceType"))
				{	soap_flag_type1--;
					continue;
				}
			if (soap_flag_spaceToken1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSpaceToken(soap, "spaceToken", &(((SRMv2__TMetaDataSpace*)a)->spaceToken), "SRMv2:TSpaceToken"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_isValid1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isValid", &(((SRMv2__TMetaDataSpace*)a)->isValid), "xsd:boolean"))
				{	soap_flag_isValid1--;
					continue;
				}
			if (soap_flag_owner1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "owner", &(((SRMv2__TMetaDataSpace*)a)->owner), "SRMv2:TUserID"))
				{	soap_flag_owner1--;
					continue;
				}
			if (soap_flag_totalSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "totalSize", &(((SRMv2__TMetaDataSpace*)a)->totalSize), "SRMv2:TSizeInBytes"))
				{	soap_flag_totalSize1--;
					continue;
				}
			if (soap_flag_guaranteedSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "guaranteedSize", &(((SRMv2__TMetaDataSpace*)a)->guaranteedSize), "SRMv2:TSizeInBytes"))
				{	soap_flag_guaranteedSize1--;
					continue;
				}
			if (soap_flag_unusedSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "unusedSize", &(((SRMv2__TMetaDataSpace*)a)->unusedSize), "SRMv2:TSizeInBytes"))
				{	soap_flag_unusedSize1--;
					continue;
				}
			if (soap_flag_lifetimeAssigned1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeAssigned", &(((SRMv2__TMetaDataSpace*)a)->lifetimeAssigned), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeAssigned1--;
					continue;
				}
			if (soap_flag_lifetimeLeft1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeLeft", &(((SRMv2__TMetaDataSpace*)a)->lifetimeLeft), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeLeft1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0 || soap_flag_isValid1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TMetaDataSpace *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TMetaDataSpace, 0, sizeof(SRMv2__TMetaDataSpace), 0, soap_copy_SRMv2__TMetaDataSpace);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TMetaDataSpace * SOAP_FMAC6 soap_new_SRMv2__TMetaDataSpace(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TMetaDataSpace(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TMetaDataSpace(struct soap *soap, SRMv2__TMetaDataSpace *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TMetaDataSpace * SOAP_FMAC4 soap_instantiate_SRMv2__TMetaDataSpace(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TMetaDataSpace(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TMetaDataSpace, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TMetaDataSpace;
		if (size)
			*size = sizeof(SRMv2__TMetaDataSpace);
		((SRMv2__TMetaDataSpace*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TMetaDataSpace[n];
		if (size)
			*size = n * sizeof(SRMv2__TMetaDataSpace);
		for (int i = 0; i < n; i++)
			((SRMv2__TMetaDataSpace*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TMetaDataSpace*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TMetaDataSpace(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TMetaDataSpace %p -> %p\n", q, p));
	*(SRMv2__TMetaDataSpace*)p = *(SRMv2__TMetaDataSpace*)q;
}

void SRMv2__ArrayOfTMetaDataPathDetail::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTMetaDataPathDetail*)this)->pathDetailArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTMetaDataPathDetail*)this)->__sizepathDetailArray; i++)
		{
			soap_serialize_PointerToSRMv2__TMetaDataPathDetail(soap, ((SRMv2__ArrayOfTMetaDataPathDetail*)this)->pathDetailArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTMetaDataPathDetail::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTMetaDataPathDetail*)this)->__sizepathDetailArray = 0;
	((SRMv2__ArrayOfTMetaDataPathDetail*)this)->pathDetailArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTMetaDataPathDetail::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTMetaDataPathDetail::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTMetaDataPathDetail(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTMetaDataPathDetail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail), type);
	if (((SRMv2__ArrayOfTMetaDataPathDetail*)a)->pathDetailArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTMetaDataPathDetail*)a)->__sizepathDetailArray; i++)
			soap_out_PointerToSRMv2__TMetaDataPathDetail(soap, "pathDetailArray", -1, ((SRMv2__ArrayOfTMetaDataPathDetail*)a)->pathDetailArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTMetaDataPathDetail::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTMetaDataPathDetail(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTMetaDataPathDetail * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, SRMv2__ArrayOfTMetaDataPathDetail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTMetaDataPathDetail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTMetaDataPathDetail::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTMetaDataPathDetail(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTMetaDataPathDetail * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, const char *tag, SRMv2__ArrayOfTMetaDataPathDetail *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTMetaDataPathDetail *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail, sizeof(SRMv2__ArrayOfTMetaDataPathDetail), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTMetaDataPathDetail *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_pathDetailArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_pathDetailArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TMetaDataPathDetail **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTMetaDataPathDetail*)a)->__sizepathDetailArray = 0; !soap_element_begin_in(soap, "pathDetailArray", 1); ((SRMv2__ArrayOfTMetaDataPathDetail*)a)->__sizepathDetailArray++)
				{	p = (SRMv2__TMetaDataPathDetail **)soap_push_block(soap, sizeof(SRMv2__TMetaDataPathDetail *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TMetaDataPathDetail(soap, "pathDetailArray", p, "SRMv2:TMetaDataPathDetail"))
						break;
					soap_flag_pathDetailArray1 = 0;
				}
				((SRMv2__ArrayOfTMetaDataPathDetail*)a)->pathDetailArray = (SRMv2__TMetaDataPathDetail **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_pathDetailArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTMetaDataPathDetail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail, 0, sizeof(SRMv2__ArrayOfTMetaDataPathDetail), 0, soap_copy_SRMv2__ArrayOfTMetaDataPathDetail);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTMetaDataPathDetail * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTMetaDataPathDetail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, SRMv2__ArrayOfTMetaDataPathDetail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTMetaDataPathDetail * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTMetaDataPathDetail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTMetaDataPathDetail;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTMetaDataPathDetail);
		((SRMv2__ArrayOfTMetaDataPathDetail*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTMetaDataPathDetail[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTMetaDataPathDetail);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTMetaDataPathDetail*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTMetaDataPathDetail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTMetaDataPathDetail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTMetaDataPathDetail %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTMetaDataPathDetail*)p = *(SRMv2__ArrayOfTMetaDataPathDetail*)q;
}

void SRMv2__TMetaDataPathDetail::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TMetaDataPathDetail*)this)->path);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TMetaDataPathDetail*)this)->status);
	soap_serialize_PointerToSRMv2__TSizeInBytes(soap, &((SRMv2__TMetaDataPathDetail*)this)->size);
	soap_serialize_PointerToSRMv2__TOwnerPermission(soap, &((SRMv2__TMetaDataPathDetail*)this)->ownerPermission);
	soap_serialize_PointerToSRMv2__ArrayOfTUserPermission(soap, &((SRMv2__TMetaDataPathDetail*)this)->userPermissions);
	soap_serialize_PointerToSRMv2__ArrayOfTGroupPermission(soap, &((SRMv2__TMetaDataPathDetail*)this)->groupPermissions);
	soap_serialize_PointerToSRMv2__TOtherPermission(soap, &((SRMv2__TMetaDataPathDetail*)this)->otherPermission);
	soap_serialize_PointerToSRMv2__TGMTTime(soap, &((SRMv2__TMetaDataPathDetail*)this)->createdAtTime);
	soap_serialize_PointerToSRMv2__TGMTTime(soap, &((SRMv2__TMetaDataPathDetail*)this)->lastModificationTime);
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__TMetaDataPathDetail*)this)->owner);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__TMetaDataPathDetail*)this)->fileStorageType);
	soap_serialize_PointerToSRMv2__TFileType(soap, &((SRMv2__TMetaDataPathDetail*)this)->type);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TMetaDataPathDetail*)this)->lifetimeAssigned);
	soap_serialize_PointerToSRMv2__TLifeTimeInSeconds(soap, &((SRMv2__TMetaDataPathDetail*)this)->lifetimeLeft);
	soap_serialize_PointerToSRMv2__TCheckSumType(soap, &((SRMv2__TMetaDataPathDetail*)this)->checkSumType);
	soap_serialize_PointerToSRMv2__TCheckSumValue(soap, &((SRMv2__TMetaDataPathDetail*)this)->checkSumValue);
	soap_serialize_PointerToSRMv2__TSURL(soap, &((SRMv2__TMetaDataPathDetail*)this)->originalSURL);
	soap_serialize_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, &((SRMv2__TMetaDataPathDetail*)this)->subPaths);
	/* transient soap skipped */
}

void SRMv2__TMetaDataPathDetail::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TMetaDataPathDetail*)this)->path);
	((SRMv2__TMetaDataPathDetail*)this)->status = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->size = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->ownerPermission = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->userPermissions = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->groupPermissions = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->otherPermission = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->createdAtTime = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->lastModificationTime = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->owner = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->fileStorageType = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->type = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->lifetimeAssigned = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->lifetimeLeft = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->checkSumType = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->checkSumValue = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->originalSURL = NULL;
	((SRMv2__TMetaDataPathDetail*)this)->subPaths = NULL;
	/* transient soap skipped */
}

int SRMv2__TMetaDataPathDetail::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TMetaDataPathDetail);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TMetaDataPathDetail::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TMetaDataPathDetail(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TMetaDataPathDetail(struct soap *soap, const char *tag, int id, const SRMv2__TMetaDataPathDetail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TMetaDataPathDetail), type);
	soap_out_string(soap, "path", -1, &(((SRMv2__TMetaDataPathDetail*)a)->path), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TMetaDataPathDetail*)a)->status), "");
	soap_out_PointerToSRMv2__TSizeInBytes(soap, "size", -1, &(((SRMv2__TMetaDataPathDetail*)a)->size), "");
	soap_out_PointerToSRMv2__TOwnerPermission(soap, "ownerPermission", -1, &(((SRMv2__TMetaDataPathDetail*)a)->ownerPermission), "");
	soap_out_PointerToSRMv2__ArrayOfTUserPermission(soap, "userPermissions", -1, &(((SRMv2__TMetaDataPathDetail*)a)->userPermissions), "");
	soap_out_PointerToSRMv2__ArrayOfTGroupPermission(soap, "groupPermissions", -1, &(((SRMv2__TMetaDataPathDetail*)a)->groupPermissions), "");
	soap_out_PointerToSRMv2__TOtherPermission(soap, "otherPermission", -1, &(((SRMv2__TMetaDataPathDetail*)a)->otherPermission), "");
	soap_out_PointerToSRMv2__TGMTTime(soap, "createdAtTime", -1, &(((SRMv2__TMetaDataPathDetail*)a)->createdAtTime), "");
	soap_out_PointerToSRMv2__TGMTTime(soap, "lastModificationTime", -1, &(((SRMv2__TMetaDataPathDetail*)a)->lastModificationTime), "");
	soap_out_PointerToSRMv2__TUserID(soap, "owner", -1, &(((SRMv2__TMetaDataPathDetail*)a)->owner), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", -1, &(((SRMv2__TMetaDataPathDetail*)a)->fileStorageType), "");
	soap_out_PointerToSRMv2__TFileType(soap, "type", -1, &(((SRMv2__TMetaDataPathDetail*)a)->type), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeAssigned", -1, &(((SRMv2__TMetaDataPathDetail*)a)->lifetimeAssigned), "");
	soap_out_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeLeft", -1, &(((SRMv2__TMetaDataPathDetail*)a)->lifetimeLeft), "");
	soap_out_PointerToSRMv2__TCheckSumType(soap, "checkSumType", -1, &(((SRMv2__TMetaDataPathDetail*)a)->checkSumType), "");
	soap_out_PointerToSRMv2__TCheckSumValue(soap, "checkSumValue", -1, &(((SRMv2__TMetaDataPathDetail*)a)->checkSumValue), "");
	soap_out_PointerToSRMv2__TSURL(soap, "originalSURL", -1, &(((SRMv2__TMetaDataPathDetail*)a)->originalSURL), "");
	soap_out_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "subPaths", -1, &(((SRMv2__TMetaDataPathDetail*)a)->subPaths), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TMetaDataPathDetail::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TMetaDataPathDetail(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TMetaDataPathDetail * SOAP_FMAC4 soap_get_SRMv2__TMetaDataPathDetail(struct soap *soap, SRMv2__TMetaDataPathDetail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TMetaDataPathDetail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TMetaDataPathDetail::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TMetaDataPathDetail(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TMetaDataPathDetail * SOAP_FMAC4 soap_in_SRMv2__TMetaDataPathDetail(struct soap *soap, const char *tag, SRMv2__TMetaDataPathDetail *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TMetaDataPathDetail *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TMetaDataPathDetail, sizeof(SRMv2__TMetaDataPathDetail), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TMetaDataPathDetail)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TMetaDataPathDetail *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_path1 = 1, soap_flag_status1 = 1, soap_flag_size1 = 1, soap_flag_ownerPermission1 = 1, soap_flag_userPermissions1 = 1, soap_flag_groupPermissions1 = 1, soap_flag_otherPermission1 = 1, soap_flag_createdAtTime1 = 1, soap_flag_lastModificationTime1 = 1, soap_flag_owner1 = 1, soap_flag_fileStorageType1 = 1, soap_flag_type1 = 1, soap_flag_lifetimeAssigned1 = 1, soap_flag_lifetimeLeft1 = 1, soap_flag_checkSumType1 = 1, soap_flag_checkSumValue1 = 1, soap_flag_originalSURL1 = 1, soap_flag_subPaths1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_path1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "path", &(((SRMv2__TMetaDataPathDetail*)a)->path), "xsd:string"))
				{	soap_flag_path1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TMetaDataPathDetail*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_size1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSizeInBytes(soap, "size", &(((SRMv2__TMetaDataPathDetail*)a)->size), "SRMv2:TSizeInBytes"))
				{	soap_flag_size1--;
					continue;
				}
			if (soap_flag_ownerPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOwnerPermission(soap, "ownerPermission", &(((SRMv2__TMetaDataPathDetail*)a)->ownerPermission), "SRMv2:TOwnerPermission"))
				{	soap_flag_ownerPermission1--;
					continue;
				}
			if (soap_flag_userPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTUserPermission(soap, "userPermissions", &(((SRMv2__TMetaDataPathDetail*)a)->userPermissions), "SRMv2:ArrayOfTUserPermission"))
				{	soap_flag_userPermissions1--;
					continue;
				}
			if (soap_flag_groupPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGroupPermission(soap, "groupPermissions", &(((SRMv2__TMetaDataPathDetail*)a)->groupPermissions), "SRMv2:ArrayOfTGroupPermission"))
				{	soap_flag_groupPermissions1--;
					continue;
				}
			if (soap_flag_otherPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOtherPermission(soap, "otherPermission", &(((SRMv2__TMetaDataPathDetail*)a)->otherPermission), "SRMv2:TOtherPermission"))
				{	soap_flag_otherPermission1--;
					continue;
				}
			if (soap_flag_createdAtTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TGMTTime(soap, "createdAtTime", &(((SRMv2__TMetaDataPathDetail*)a)->createdAtTime), "SRMv2:TGMTTime"))
				{	soap_flag_createdAtTime1--;
					continue;
				}
			if (soap_flag_lastModificationTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TGMTTime(soap, "lastModificationTime", &(((SRMv2__TMetaDataPathDetail*)a)->lastModificationTime), "SRMv2:TGMTTime"))
				{	soap_flag_lastModificationTime1--;
					continue;
				}
			if (soap_flag_owner1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "owner", &(((SRMv2__TMetaDataPathDetail*)a)->owner), "SRMv2:TUserID"))
				{	soap_flag_owner1--;
					continue;
				}
			if (soap_flag_fileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", &(((SRMv2__TMetaDataPathDetail*)a)->fileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_fileStorageType1--;
					continue;
				}
			if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileType(soap, "type", &(((SRMv2__TMetaDataPathDetail*)a)->type), "SRMv2:TFileType"))
				{	soap_flag_type1--;
					continue;
				}
			if (soap_flag_lifetimeAssigned1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeAssigned", &(((SRMv2__TMetaDataPathDetail*)a)->lifetimeAssigned), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeAssigned1--;
					continue;
				}
			if (soap_flag_lifetimeLeft1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TLifeTimeInSeconds(soap, "lifetimeLeft", &(((SRMv2__TMetaDataPathDetail*)a)->lifetimeLeft), "SRMv2:TLifeTimeInSeconds"))
				{	soap_flag_lifetimeLeft1--;
					continue;
				}
			if (soap_flag_checkSumType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TCheckSumType(soap, "checkSumType", &(((SRMv2__TMetaDataPathDetail*)a)->checkSumType), "SRMv2:TCheckSumType"))
				{	soap_flag_checkSumType1--;
					continue;
				}
			if (soap_flag_checkSumValue1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TCheckSumValue(soap, "checkSumValue", &(((SRMv2__TMetaDataPathDetail*)a)->checkSumValue), "SRMv2:TCheckSumValue"))
				{	soap_flag_checkSumValue1--;
					continue;
				}
			if (soap_flag_originalSURL1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TSURL(soap, "originalSURL", &(((SRMv2__TMetaDataPathDetail*)a)->originalSURL), "SRMv2:TSURL"))
				{	soap_flag_originalSURL1--;
					continue;
				}
			if (soap_flag_subPaths1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "subPaths", &(((SRMv2__TMetaDataPathDetail*)a)->subPaths), "SRMv2:ArrayOfTMetaDataPathDetail"))
				{	soap_flag_subPaths1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_path1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TMetaDataPathDetail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TMetaDataPathDetail, 0, sizeof(SRMv2__TMetaDataPathDetail), 0, soap_copy_SRMv2__TMetaDataPathDetail);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TMetaDataPathDetail * SOAP_FMAC6 soap_new_SRMv2__TMetaDataPathDetail(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TMetaDataPathDetail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TMetaDataPathDetail(struct soap *soap, SRMv2__TMetaDataPathDetail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TMetaDataPathDetail * SOAP_FMAC4 soap_instantiate_SRMv2__TMetaDataPathDetail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TMetaDataPathDetail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TMetaDataPathDetail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TMetaDataPathDetail;
		if (size)
			*size = sizeof(SRMv2__TMetaDataPathDetail);
		((SRMv2__TMetaDataPathDetail*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TMetaDataPathDetail[n];
		if (size)
			*size = n * sizeof(SRMv2__TMetaDataPathDetail);
		for (int i = 0; i < n; i++)
			((SRMv2__TMetaDataPathDetail*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TMetaDataPathDetail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TMetaDataPathDetail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TMetaDataPathDetail %p -> %p\n", q, p));
	*(SRMv2__TMetaDataPathDetail*)p = *(SRMv2__TMetaDataPathDetail*)q;
}

void SRMv2__TTURL::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &((SRMv2__TTURL*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TTURL::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((SRMv2__TTURL*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TTURL::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TTURL);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TTURL::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TTURL(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TTURL(struct soap *soap, const char *tag, int id, const SRMv2__TTURL *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TTURL), type);
	soap_out_xsd__anyURI(soap, "value", -1, &(((SRMv2__TTURL*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TTURL::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TTURL(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TTURL * SOAP_FMAC4 soap_get_SRMv2__TTURL(struct soap *soap, SRMv2__TTURL *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TTURL(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TTURL::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TTURL(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TTURL * SOAP_FMAC4 soap_in_SRMv2__TTURL(struct soap *soap, const char *tag, SRMv2__TTURL *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TTURL *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TTURL, sizeof(SRMv2__TTURL), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TTURL)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TTURL *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "value", &(((SRMv2__TTURL*)a)->value), "xsd:anyURI"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TTURL *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TTURL, 0, sizeof(SRMv2__TTURL), 0, soap_copy_SRMv2__TTURL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TTURL * SOAP_FMAC6 soap_new_SRMv2__TTURL(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TTURL(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TTURL(struct soap *soap, SRMv2__TTURL *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TTURL * SOAP_FMAC4 soap_instantiate_SRMv2__TTURL(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TTURL(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TTURL, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TTURL;
		if (size)
			*size = sizeof(SRMv2__TTURL);
		((SRMv2__TTURL*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TTURL[n];
		if (size)
			*size = n * sizeof(SRMv2__TTURL);
		for (int i = 0; i < n; i++)
			((SRMv2__TTURL*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TTURL*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TTURL(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TTURL %p -> %p\n", q, p));
	*(SRMv2__TTURL*)p = *(SRMv2__TTURL*)q;
}

void SRMv2__TSURL::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &((SRMv2__TSURL*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TSURL::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((SRMv2__TSURL*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TSURL::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSURL);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSURL::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSURL(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSURL(struct soap *soap, const char *tag, int id, const SRMv2__TSURL *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSURL), type);
	soap_out_xsd__anyURI(soap, "value", -1, &(((SRMv2__TSURL*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSURL::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSURL(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSURL * SOAP_FMAC4 soap_get_SRMv2__TSURL(struct soap *soap, SRMv2__TSURL *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSURL(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSURL::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSURL(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSURL * SOAP_FMAC4 soap_in_SRMv2__TSURL(struct soap *soap, const char *tag, SRMv2__TSURL *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSURL *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSURL, sizeof(SRMv2__TSURL), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSURL)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSURL *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "value", &(((SRMv2__TSURL*)a)->value), "xsd:anyURI"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSURL *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSURL, 0, sizeof(SRMv2__TSURL), 0, soap_copy_SRMv2__TSURL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSURL * SOAP_FMAC6 soap_new_SRMv2__TSURL(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSURL(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSURL(struct soap *soap, SRMv2__TSURL *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSURL * SOAP_FMAC4 soap_instantiate_SRMv2__TSURL(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSURL(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSURL, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSURL;
		if (size)
			*size = sizeof(SRMv2__TSURL);
		((SRMv2__TSURL*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSURL[n];
		if (size)
			*size = n * sizeof(SRMv2__TSURL);
		for (int i = 0; i < n; i++)
			((SRMv2__TSURL*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSURL*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSURL(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSURL %p -> %p\n", q, p));
	*(SRMv2__TSURL*)p = *(SRMv2__TSURL*)q;
}

void SRMv2__TLifeTimeInSeconds::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void SRMv2__TLifeTimeInSeconds::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_LONG64(soap, &((SRMv2__TLifeTimeInSeconds*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TLifeTimeInSeconds::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TLifeTimeInSeconds);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TLifeTimeInSeconds::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TLifeTimeInSeconds(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TLifeTimeInSeconds(struct soap *soap, const char *tag, int id, const SRMv2__TLifeTimeInSeconds *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TLifeTimeInSeconds), type);
	soap_out_LONG64(soap, "value", -1, &(((SRMv2__TLifeTimeInSeconds*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TLifeTimeInSeconds::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TLifeTimeInSeconds(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TLifeTimeInSeconds * SOAP_FMAC4 soap_get_SRMv2__TLifeTimeInSeconds(struct soap *soap, SRMv2__TLifeTimeInSeconds *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TLifeTimeInSeconds(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TLifeTimeInSeconds::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TLifeTimeInSeconds(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TLifeTimeInSeconds * SOAP_FMAC4 soap_in_SRMv2__TLifeTimeInSeconds(struct soap *soap, const char *tag, SRMv2__TLifeTimeInSeconds *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TLifeTimeInSeconds *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TLifeTimeInSeconds, sizeof(SRMv2__TLifeTimeInSeconds), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TLifeTimeInSeconds)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TLifeTimeInSeconds *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "value", &(((SRMv2__TLifeTimeInSeconds*)a)->value), "xsd:long"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TLifeTimeInSeconds *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TLifeTimeInSeconds, 0, sizeof(SRMv2__TLifeTimeInSeconds), 0, soap_copy_SRMv2__TLifeTimeInSeconds);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TLifeTimeInSeconds * SOAP_FMAC6 soap_new_SRMv2__TLifeTimeInSeconds(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TLifeTimeInSeconds(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TLifeTimeInSeconds(struct soap *soap, SRMv2__TLifeTimeInSeconds *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TLifeTimeInSeconds * SOAP_FMAC4 soap_instantiate_SRMv2__TLifeTimeInSeconds(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TLifeTimeInSeconds(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TLifeTimeInSeconds, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TLifeTimeInSeconds;
		if (size)
			*size = sizeof(SRMv2__TLifeTimeInSeconds);
		((SRMv2__TLifeTimeInSeconds*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TLifeTimeInSeconds[n];
		if (size)
			*size = n * sizeof(SRMv2__TLifeTimeInSeconds);
		for (int i = 0; i < n; i++)
			((SRMv2__TLifeTimeInSeconds*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TLifeTimeInSeconds*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TLifeTimeInSeconds(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TLifeTimeInSeconds %p -> %p\n", q, p));
	*(SRMv2__TLifeTimeInSeconds*)p = *(SRMv2__TLifeTimeInSeconds*)q;
}

void SRMv2__TGMTTime::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void SRMv2__TGMTTime::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_time(soap, &((SRMv2__TGMTTime*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TGMTTime::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TGMTTime);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TGMTTime::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TGMTTime(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TGMTTime(struct soap *soap, const char *tag, int id, const SRMv2__TGMTTime *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TGMTTime), type);
	soap_out_time(soap, "value", -1, &(((SRMv2__TGMTTime*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TGMTTime::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TGMTTime(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TGMTTime * SOAP_FMAC4 soap_get_SRMv2__TGMTTime(struct soap *soap, SRMv2__TGMTTime *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TGMTTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TGMTTime::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TGMTTime(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TGMTTime * SOAP_FMAC4 soap_in_SRMv2__TGMTTime(struct soap *soap, const char *tag, SRMv2__TGMTTime *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TGMTTime *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TGMTTime, sizeof(SRMv2__TGMTTime), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TGMTTime)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TGMTTime *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_time(soap, "value", &(((SRMv2__TGMTTime*)a)->value), "xsd:dateTime"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TGMTTime *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TGMTTime, 0, sizeof(SRMv2__TGMTTime), 0, soap_copy_SRMv2__TGMTTime);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TGMTTime * SOAP_FMAC6 soap_new_SRMv2__TGMTTime(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TGMTTime(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TGMTTime(struct soap *soap, SRMv2__TGMTTime *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TGMTTime * SOAP_FMAC4 soap_instantiate_SRMv2__TGMTTime(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TGMTTime(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TGMTTime, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TGMTTime;
		if (size)
			*size = sizeof(SRMv2__TGMTTime);
		((SRMv2__TGMTTime*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TGMTTime[n];
		if (size)
			*size = n * sizeof(SRMv2__TGMTTime);
		for (int i = 0; i < n; i++)
			((SRMv2__TGMTTime*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TGMTTime*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TGMTTime(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TGMTTime %p -> %p\n", q, p));
	*(SRMv2__TGMTTime*)p = *(SRMv2__TGMTTime*)q;
}

void SRMv2__TSizeInBytes::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void SRMv2__TSizeInBytes::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_LONG64(soap, &((SRMv2__TSizeInBytes*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TSizeInBytes::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSizeInBytes);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSizeInBytes::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSizeInBytes(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSizeInBytes(struct soap *soap, const char *tag, int id, const SRMv2__TSizeInBytes *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSizeInBytes), type);
	soap_out_LONG64(soap, "value", -1, &(((SRMv2__TSizeInBytes*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSizeInBytes::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSizeInBytes(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSizeInBytes * SOAP_FMAC4 soap_get_SRMv2__TSizeInBytes(struct soap *soap, SRMv2__TSizeInBytes *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSizeInBytes(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSizeInBytes::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSizeInBytes(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSizeInBytes * SOAP_FMAC4 soap_in_SRMv2__TSizeInBytes(struct soap *soap, const char *tag, SRMv2__TSizeInBytes *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSizeInBytes *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSizeInBytes, sizeof(SRMv2__TSizeInBytes), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSizeInBytes)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSizeInBytes *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "value", &(((SRMv2__TSizeInBytes*)a)->value), "xsd:long"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSizeInBytes *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSizeInBytes, 0, sizeof(SRMv2__TSizeInBytes), 0, soap_copy_SRMv2__TSizeInBytes);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSizeInBytes * SOAP_FMAC6 soap_new_SRMv2__TSizeInBytes(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSizeInBytes(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSizeInBytes(struct soap *soap, SRMv2__TSizeInBytes *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSizeInBytes * SOAP_FMAC4 soap_instantiate_SRMv2__TSizeInBytes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSizeInBytes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSizeInBytes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSizeInBytes;
		if (size)
			*size = sizeof(SRMv2__TSizeInBytes);
		((SRMv2__TSizeInBytes*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSizeInBytes[n];
		if (size)
			*size = n * sizeof(SRMv2__TSizeInBytes);
		for (int i = 0; i < n; i++)
			((SRMv2__TSizeInBytes*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSizeInBytes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSizeInBytes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSizeInBytes %p -> %p\n", q, p));
	*(SRMv2__TSizeInBytes*)p = *(SRMv2__TSizeInBytes*)q;
}

void SRMv2__TCheckSumValue::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TCheckSumValue*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TCheckSumValue::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TCheckSumValue*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TCheckSumValue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TCheckSumValue);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TCheckSumValue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TCheckSumValue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TCheckSumValue(struct soap *soap, const char *tag, int id, const SRMv2__TCheckSumValue *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TCheckSumValue), type);
	soap_out_string(soap, "value", -1, &(((SRMv2__TCheckSumValue*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TCheckSumValue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TCheckSumValue(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TCheckSumValue * SOAP_FMAC4 soap_get_SRMv2__TCheckSumValue(struct soap *soap, SRMv2__TCheckSumValue *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TCheckSumValue(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TCheckSumValue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TCheckSumValue(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TCheckSumValue * SOAP_FMAC4 soap_in_SRMv2__TCheckSumValue(struct soap *soap, const char *tag, SRMv2__TCheckSumValue *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TCheckSumValue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TCheckSumValue, sizeof(SRMv2__TCheckSumValue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TCheckSumValue)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TCheckSumValue *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &(((SRMv2__TCheckSumValue*)a)->value), "xsd:string"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TCheckSumValue *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TCheckSumValue, 0, sizeof(SRMv2__TCheckSumValue), 0, soap_copy_SRMv2__TCheckSumValue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TCheckSumValue * SOAP_FMAC6 soap_new_SRMv2__TCheckSumValue(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TCheckSumValue(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TCheckSumValue(struct soap *soap, SRMv2__TCheckSumValue *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TCheckSumValue * SOAP_FMAC4 soap_instantiate_SRMv2__TCheckSumValue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TCheckSumValue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TCheckSumValue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TCheckSumValue;
		if (size)
			*size = sizeof(SRMv2__TCheckSumValue);
		((SRMv2__TCheckSumValue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TCheckSumValue[n];
		if (size)
			*size = n * sizeof(SRMv2__TCheckSumValue);
		for (int i = 0; i < n; i++)
			((SRMv2__TCheckSumValue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TCheckSumValue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TCheckSumValue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TCheckSumValue %p -> %p\n", q, p));
	*(SRMv2__TCheckSumValue*)p = *(SRMv2__TCheckSumValue*)q;
}

void SRMv2__TCheckSumType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TCheckSumType*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TCheckSumType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TCheckSumType*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TCheckSumType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TCheckSumType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TCheckSumType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TCheckSumType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TCheckSumType(struct soap *soap, const char *tag, int id, const SRMv2__TCheckSumType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TCheckSumType), type);
	soap_out_string(soap, "value", -1, &(((SRMv2__TCheckSumType*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TCheckSumType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TCheckSumType(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TCheckSumType * SOAP_FMAC4 soap_get_SRMv2__TCheckSumType(struct soap *soap, SRMv2__TCheckSumType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TCheckSumType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TCheckSumType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TCheckSumType(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TCheckSumType * SOAP_FMAC4 soap_in_SRMv2__TCheckSumType(struct soap *soap, const char *tag, SRMv2__TCheckSumType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TCheckSumType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TCheckSumType, sizeof(SRMv2__TCheckSumType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TCheckSumType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TCheckSumType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &(((SRMv2__TCheckSumType*)a)->value), "xsd:string"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TCheckSumType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TCheckSumType, 0, sizeof(SRMv2__TCheckSumType), 0, soap_copy_SRMv2__TCheckSumType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TCheckSumType * SOAP_FMAC6 soap_new_SRMv2__TCheckSumType(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TCheckSumType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TCheckSumType(struct soap *soap, SRMv2__TCheckSumType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TCheckSumType * SOAP_FMAC4 soap_instantiate_SRMv2__TCheckSumType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TCheckSumType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TCheckSumType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TCheckSumType;
		if (size)
			*size = sizeof(SRMv2__TCheckSumType);
		((SRMv2__TCheckSumType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TCheckSumType[n];
		if (size)
			*size = n * sizeof(SRMv2__TCheckSumType);
		for (int i = 0; i < n; i++)
			((SRMv2__TCheckSumType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TCheckSumType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TCheckSumType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TCheckSumType %p -> %p\n", q, p));
	*(SRMv2__TCheckSumType*)p = *(SRMv2__TCheckSumType*)q;
}

void SRMv2__TOtherPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void SRMv2__TOtherPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_SRMv2__TPermissionMode(soap, &((SRMv2__TOtherPermission*)this)->mode);
	/* transient soap skipped */
}

int SRMv2__TOtherPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TOtherPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TOtherPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TOtherPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TOtherPermission(struct soap *soap, const char *tag, int id, const SRMv2__TOtherPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TOtherPermission), type);
	soap_out_SRMv2__TPermissionMode(soap, "mode", -1, &(((SRMv2__TOtherPermission*)a)->mode), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TOtherPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TOtherPermission(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TOtherPermission * SOAP_FMAC4 soap_get_SRMv2__TOtherPermission(struct soap *soap, SRMv2__TOtherPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TOtherPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TOtherPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TOtherPermission(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TOtherPermission * SOAP_FMAC4 soap_in_SRMv2__TOtherPermission(struct soap *soap, const char *tag, SRMv2__TOtherPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TOtherPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TOtherPermission, sizeof(SRMv2__TOtherPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TOtherPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TOtherPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_mode1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TPermissionMode(soap, "mode", &(((SRMv2__TOtherPermission*)a)->mode), "SRMv2:TPermissionMode"))
				{	soap_flag_mode1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_mode1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TOtherPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TOtherPermission, 0, sizeof(SRMv2__TOtherPermission), 0, soap_copy_SRMv2__TOtherPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TOtherPermission * SOAP_FMAC6 soap_new_SRMv2__TOtherPermission(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TOtherPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TOtherPermission(struct soap *soap, SRMv2__TOtherPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TOtherPermission * SOAP_FMAC4 soap_instantiate_SRMv2__TOtherPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TOtherPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TOtherPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TOtherPermission;
		if (size)
			*size = sizeof(SRMv2__TOtherPermission);
		((SRMv2__TOtherPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TOtherPermission[n];
		if (size)
			*size = n * sizeof(SRMv2__TOtherPermission);
		for (int i = 0; i < n; i++)
			((SRMv2__TOtherPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TOtherPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TOtherPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TOtherPermission %p -> %p\n", q, p));
	*(SRMv2__TOtherPermission*)p = *(SRMv2__TOtherPermission*)q;
}

void SRMv2__ArrayOfTGroupPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTGroupPermission*)this)->groupPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTGroupPermission*)this)->__sizegroupPermissionArray; i++)
		{
			soap_serialize_PointerToSRMv2__TGroupPermission(soap, ((SRMv2__ArrayOfTGroupPermission*)this)->groupPermissionArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTGroupPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTGroupPermission*)this)->__sizegroupPermissionArray = 0;
	((SRMv2__ArrayOfTGroupPermission*)this)->groupPermissionArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTGroupPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTGroupPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTGroupPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTGroupPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTGroupPermission(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTGroupPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTGroupPermission), type);
	if (((SRMv2__ArrayOfTGroupPermission*)a)->groupPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTGroupPermission*)a)->__sizegroupPermissionArray; i++)
			soap_out_PointerToSRMv2__TGroupPermission(soap, "groupPermissionArray", -1, ((SRMv2__ArrayOfTGroupPermission*)a)->groupPermissionArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTGroupPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTGroupPermission(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTGroupPermission * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTGroupPermission(struct soap *soap, SRMv2__ArrayOfTGroupPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTGroupPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTGroupPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTGroupPermission(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTGroupPermission * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTGroupPermission(struct soap *soap, const char *tag, SRMv2__ArrayOfTGroupPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTGroupPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTGroupPermission, sizeof(SRMv2__ArrayOfTGroupPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTGroupPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTGroupPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_groupPermissionArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_groupPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TGroupPermission **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTGroupPermission*)a)->__sizegroupPermissionArray = 0; !soap_element_begin_in(soap, "groupPermissionArray", 1); ((SRMv2__ArrayOfTGroupPermission*)a)->__sizegroupPermissionArray++)
				{	p = (SRMv2__TGroupPermission **)soap_push_block(soap, sizeof(SRMv2__TGroupPermission *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TGroupPermission(soap, "groupPermissionArray", p, "SRMv2:TGroupPermission"))
						break;
					soap_flag_groupPermissionArray1 = 0;
				}
				((SRMv2__ArrayOfTGroupPermission*)a)->groupPermissionArray = (SRMv2__TGroupPermission **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_groupPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTGroupPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTGroupPermission, 0, sizeof(SRMv2__ArrayOfTGroupPermission), 0, soap_copy_SRMv2__ArrayOfTGroupPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTGroupPermission * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTGroupPermission(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTGroupPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTGroupPermission(struct soap *soap, SRMv2__ArrayOfTGroupPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTGroupPermission * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTGroupPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTGroupPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTGroupPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTGroupPermission;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTGroupPermission);
		((SRMv2__ArrayOfTGroupPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTGroupPermission[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTGroupPermission);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTGroupPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTGroupPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTGroupPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTGroupPermission %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTGroupPermission*)p = *(SRMv2__ArrayOfTGroupPermission*)q;
}

void SRMv2__TGroupPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TGroupID(soap, &((SRMv2__TGroupPermission*)this)->groupID);
	/* transient soap skipped */
}

void SRMv2__TGroupPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__TGroupPermission*)this)->groupID = NULL;
	soap_default_SRMv2__TPermissionMode(soap, &((SRMv2__TGroupPermission*)this)->mode);
	/* transient soap skipped */
}

int SRMv2__TGroupPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TGroupPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TGroupPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TGroupPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TGroupPermission(struct soap *soap, const char *tag, int id, const SRMv2__TGroupPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TGroupPermission), type);
	soap_out_PointerToSRMv2__TGroupID(soap, "groupID", -1, &(((SRMv2__TGroupPermission*)a)->groupID), "");
	soap_out_SRMv2__TPermissionMode(soap, "mode", -1, &(((SRMv2__TGroupPermission*)a)->mode), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TGroupPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TGroupPermission(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TGroupPermission * SOAP_FMAC4 soap_get_SRMv2__TGroupPermission(struct soap *soap, SRMv2__TGroupPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TGroupPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TGroupPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TGroupPermission(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TGroupPermission * SOAP_FMAC4 soap_in_SRMv2__TGroupPermission(struct soap *soap, const char *tag, SRMv2__TGroupPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TGroupPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TGroupPermission, sizeof(SRMv2__TGroupPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TGroupPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TGroupPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_groupID1 = 1, soap_flag_mode1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_groupID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TGroupID(soap, "groupID", &(((SRMv2__TGroupPermission*)a)->groupID), "SRMv2:TGroupID"))
				{	soap_flag_groupID1--;
					continue;
				}
			if (soap_flag_mode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TPermissionMode(soap, "mode", &(((SRMv2__TGroupPermission*)a)->mode), "SRMv2:TPermissionMode"))
				{	soap_flag_mode1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_groupID1 > 0 || soap_flag_mode1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TGroupPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TGroupPermission, 0, sizeof(SRMv2__TGroupPermission), 0, soap_copy_SRMv2__TGroupPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TGroupPermission * SOAP_FMAC6 soap_new_SRMv2__TGroupPermission(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TGroupPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TGroupPermission(struct soap *soap, SRMv2__TGroupPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TGroupPermission * SOAP_FMAC4 soap_instantiate_SRMv2__TGroupPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TGroupPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TGroupPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TGroupPermission;
		if (size)
			*size = sizeof(SRMv2__TGroupPermission);
		((SRMv2__TGroupPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TGroupPermission[n];
		if (size)
			*size = n * sizeof(SRMv2__TGroupPermission);
		for (int i = 0; i < n; i++)
			((SRMv2__TGroupPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TGroupPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TGroupPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TGroupPermission %p -> %p\n", q, p));
	*(SRMv2__TGroupPermission*)p = *(SRMv2__TGroupPermission*)q;
}

void SRMv2__ArrayOfTUserPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTUserPermission*)this)->userPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTUserPermission*)this)->__sizeuserPermissionArray; i++)
		{
			soap_serialize_PointerToSRMv2__TUserPermission(soap, ((SRMv2__ArrayOfTUserPermission*)this)->userPermissionArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTUserPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTUserPermission*)this)->__sizeuserPermissionArray = 0;
	((SRMv2__ArrayOfTUserPermission*)this)->userPermissionArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTUserPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTUserPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTUserPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTUserPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTUserPermission(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTUserPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTUserPermission), type);
	if (((SRMv2__ArrayOfTUserPermission*)a)->userPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTUserPermission*)a)->__sizeuserPermissionArray; i++)
			soap_out_PointerToSRMv2__TUserPermission(soap, "userPermissionArray", -1, ((SRMv2__ArrayOfTUserPermission*)a)->userPermissionArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTUserPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTUserPermission(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTUserPermission * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTUserPermission(struct soap *soap, SRMv2__ArrayOfTUserPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTUserPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTUserPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTUserPermission(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTUserPermission * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTUserPermission(struct soap *soap, const char *tag, SRMv2__ArrayOfTUserPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTUserPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTUserPermission, sizeof(SRMv2__ArrayOfTUserPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTUserPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTUserPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userPermissionArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TUserPermission **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTUserPermission*)a)->__sizeuserPermissionArray = 0; !soap_element_begin_in(soap, "userPermissionArray", 1); ((SRMv2__ArrayOfTUserPermission*)a)->__sizeuserPermissionArray++)
				{	p = (SRMv2__TUserPermission **)soap_push_block(soap, sizeof(SRMv2__TUserPermission *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TUserPermission(soap, "userPermissionArray", p, "SRMv2:TUserPermission"))
						break;
					soap_flag_userPermissionArray1 = 0;
				}
				((SRMv2__ArrayOfTUserPermission*)a)->userPermissionArray = (SRMv2__TUserPermission **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_userPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTUserPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTUserPermission, 0, sizeof(SRMv2__ArrayOfTUserPermission), 0, soap_copy_SRMv2__ArrayOfTUserPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTUserPermission * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTUserPermission(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTUserPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTUserPermission(struct soap *soap, SRMv2__ArrayOfTUserPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTUserPermission * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTUserPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTUserPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTUserPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTUserPermission;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTUserPermission);
		((SRMv2__ArrayOfTUserPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTUserPermission[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTUserPermission);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTUserPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTUserPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTUserPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTUserPermission %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTUserPermission*)p = *(SRMv2__ArrayOfTUserPermission*)q;
}

void SRMv2__TUserPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TUserID(soap, &((SRMv2__TUserPermission*)this)->userID);
	/* transient soap skipped */
}

void SRMv2__TUserPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_SRMv2__TPermissionMode(soap, &((SRMv2__TUserPermission*)this)->mode);
	((SRMv2__TUserPermission*)this)->userID = NULL;
	/* transient soap skipped */
}

int SRMv2__TUserPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TUserPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TUserPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TUserPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TUserPermission(struct soap *soap, const char *tag, int id, const SRMv2__TUserPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TUserPermission), type);
	soap_out_SRMv2__TPermissionMode(soap, "mode", -1, &(((SRMv2__TUserPermission*)a)->mode), "");
	soap_out_PointerToSRMv2__TUserID(soap, "userID", -1, &(((SRMv2__TUserPermission*)a)->userID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TUserPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TUserPermission(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TUserPermission * SOAP_FMAC4 soap_get_SRMv2__TUserPermission(struct soap *soap, SRMv2__TUserPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TUserPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TUserPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TUserPermission(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TUserPermission * SOAP_FMAC4 soap_in_SRMv2__TUserPermission(struct soap *soap, const char *tag, SRMv2__TUserPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TUserPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TUserPermission, sizeof(SRMv2__TUserPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TUserPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TUserPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_mode1 = 1, soap_flag_userID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TPermissionMode(soap, "mode", &(((SRMv2__TUserPermission*)a)->mode), "SRMv2:TPermissionMode"))
				{	soap_flag_mode1--;
					continue;
				}
			if (soap_flag_userID1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TUserID(soap, "userID", &(((SRMv2__TUserPermission*)a)->userID), "SRMv2:TUserID"))
				{	soap_flag_userID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_mode1 > 0 || soap_flag_userID1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TUserPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TUserPermission, 0, sizeof(SRMv2__TUserPermission), 0, soap_copy_SRMv2__TUserPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TUserPermission * SOAP_FMAC6 soap_new_SRMv2__TUserPermission(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TUserPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TUserPermission(struct soap *soap, SRMv2__TUserPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TUserPermission * SOAP_FMAC4 soap_instantiate_SRMv2__TUserPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TUserPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TUserPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TUserPermission;
		if (size)
			*size = sizeof(SRMv2__TUserPermission);
		((SRMv2__TUserPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TUserPermission[n];
		if (size)
			*size = n * sizeof(SRMv2__TUserPermission);
		for (int i = 0; i < n; i++)
			((SRMv2__TUserPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TUserPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TUserPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TUserPermission %p -> %p\n", q, p));
	*(SRMv2__TUserPermission*)p = *(SRMv2__TUserPermission*)q;
}

void SRMv2__TOwnerPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void SRMv2__TOwnerPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_SRMv2__TPermissionMode(soap, &((SRMv2__TOwnerPermission*)this)->mode);
	/* transient soap skipped */
}

int SRMv2__TOwnerPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TOwnerPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TOwnerPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TOwnerPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TOwnerPermission(struct soap *soap, const char *tag, int id, const SRMv2__TOwnerPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TOwnerPermission), type);
	soap_out_SRMv2__TPermissionMode(soap, "mode", -1, &(((SRMv2__TOwnerPermission*)a)->mode), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TOwnerPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TOwnerPermission(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TOwnerPermission * SOAP_FMAC4 soap_get_SRMv2__TOwnerPermission(struct soap *soap, SRMv2__TOwnerPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TOwnerPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TOwnerPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TOwnerPermission(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TOwnerPermission * SOAP_FMAC4 soap_in_SRMv2__TOwnerPermission(struct soap *soap, const char *tag, SRMv2__TOwnerPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TOwnerPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TOwnerPermission, sizeof(SRMv2__TOwnerPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TOwnerPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TOwnerPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_mode1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TPermissionMode(soap, "mode", &(((SRMv2__TOwnerPermission*)a)->mode), "SRMv2:TPermissionMode"))
				{	soap_flag_mode1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_mode1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TOwnerPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TOwnerPermission, 0, sizeof(SRMv2__TOwnerPermission), 0, soap_copy_SRMv2__TOwnerPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TOwnerPermission * SOAP_FMAC6 soap_new_SRMv2__TOwnerPermission(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TOwnerPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TOwnerPermission(struct soap *soap, SRMv2__TOwnerPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TOwnerPermission * SOAP_FMAC4 soap_instantiate_SRMv2__TOwnerPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TOwnerPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TOwnerPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TOwnerPermission;
		if (size)
			*size = sizeof(SRMv2__TOwnerPermission);
		((SRMv2__TOwnerPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TOwnerPermission[n];
		if (size)
			*size = n * sizeof(SRMv2__TOwnerPermission);
		for (int i = 0; i < n; i++)
			((SRMv2__TOwnerPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TOwnerPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TOwnerPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TOwnerPermission %p -> %p\n", q, p));
	*(SRMv2__TOwnerPermission*)p = *(SRMv2__TOwnerPermission*)q;
}

void SRMv2__TGroupID::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TGroupID*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TGroupID::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TGroupID*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TGroupID::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TGroupID);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TGroupID::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TGroupID(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TGroupID(struct soap *soap, const char *tag, int id, const SRMv2__TGroupID *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TGroupID), type);
	soap_out_string(soap, "value", -1, &(((SRMv2__TGroupID*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TGroupID::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TGroupID(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TGroupID * SOAP_FMAC4 soap_get_SRMv2__TGroupID(struct soap *soap, SRMv2__TGroupID *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TGroupID(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TGroupID::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TGroupID(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TGroupID * SOAP_FMAC4 soap_in_SRMv2__TGroupID(struct soap *soap, const char *tag, SRMv2__TGroupID *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TGroupID *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TGroupID, sizeof(SRMv2__TGroupID), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TGroupID)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TGroupID *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &(((SRMv2__TGroupID*)a)->value), "xsd:string"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TGroupID *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TGroupID, 0, sizeof(SRMv2__TGroupID), 0, soap_copy_SRMv2__TGroupID);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TGroupID * SOAP_FMAC6 soap_new_SRMv2__TGroupID(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TGroupID(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TGroupID(struct soap *soap, SRMv2__TGroupID *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TGroupID * SOAP_FMAC4 soap_instantiate_SRMv2__TGroupID(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TGroupID(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TGroupID, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TGroupID;
		if (size)
			*size = sizeof(SRMv2__TGroupID);
		((SRMv2__TGroupID*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TGroupID[n];
		if (size)
			*size = n * sizeof(SRMv2__TGroupID);
		for (int i = 0; i < n; i++)
			((SRMv2__TGroupID*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TGroupID*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TGroupID(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TGroupID %p -> %p\n", q, p));
	*(SRMv2__TGroupID*)p = *(SRMv2__TGroupID*)q;
}

void SRMv2__TUserID::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TUserID*)this)->value);
	/* transient soap skipped */
}

void SRMv2__TUserID::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TUserID*)this)->value);
	/* transient soap skipped */
}

int SRMv2__TUserID::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TUserID);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TUserID::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TUserID(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TUserID(struct soap *soap, const char *tag, int id, const SRMv2__TUserID *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TUserID), type);
	soap_out_string(soap, "value", -1, &(((SRMv2__TUserID*)a)->value), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TUserID::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TUserID(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TUserID * SOAP_FMAC4 soap_get_SRMv2__TUserID(struct soap *soap, SRMv2__TUserID *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TUserID(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TUserID::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TUserID(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TUserID * SOAP_FMAC4 soap_in_SRMv2__TUserID(struct soap *soap, const char *tag, SRMv2__TUserID *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TUserID *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TUserID, sizeof(SRMv2__TUserID), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TUserID)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TUserID *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_value1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &(((SRMv2__TUserID*)a)->value), "xsd:string"))
				{	soap_flag_value1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_value1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TUserID *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TUserID, 0, sizeof(SRMv2__TUserID), 0, soap_copy_SRMv2__TUserID);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TUserID * SOAP_FMAC6 soap_new_SRMv2__TUserID(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TUserID(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TUserID(struct soap *soap, SRMv2__TUserID *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TUserID * SOAP_FMAC4 soap_instantiate_SRMv2__TUserID(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TUserID(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TUserID, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TUserID;
		if (size)
			*size = sizeof(SRMv2__TUserID);
		((SRMv2__TUserID*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TUserID[n];
		if (size)
			*size = n * sizeof(SRMv2__TUserID);
		for (int i = 0; i < n; i++)
			((SRMv2__TUserID*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TUserID*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TUserID(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TUserID %p -> %p\n", q, p));
	*(SRMv2__TUserID*)p = *(SRMv2__TUserID*)q;
}

void SRMv2__ArrayOfTSpaceToken::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSpaceToken*)this)->tokenArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSpaceToken*)this)->__sizetokenArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSpaceToken(soap, ((SRMv2__ArrayOfTSpaceToken*)this)->tokenArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSpaceToken::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSpaceToken*)this)->__sizetokenArray = 0;
	((SRMv2__ArrayOfTSpaceToken*)this)->tokenArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSpaceToken::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSpaceToken);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSpaceToken::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSpaceToken(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSpaceToken(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSpaceToken *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSpaceToken), type);
	if (((SRMv2__ArrayOfTSpaceToken*)a)->tokenArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSpaceToken*)a)->__sizetokenArray; i++)
			soap_out_PointerToSRMv2__TSpaceToken(soap, "tokenArray", -1, ((SRMv2__ArrayOfTSpaceToken*)a)->tokenArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSpaceToken::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSpaceToken(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSpaceToken * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSpaceToken(struct soap *soap, SRMv2__ArrayOfTSpaceToken *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSpaceToken(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSpaceToken::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSpaceToken(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSpaceToken * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSpaceToken(struct soap *soap, const char *tag, SRMv2__ArrayOfTSpaceToken *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSpaceToken *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSpaceToken, sizeof(SRMv2__ArrayOfTSpaceToken), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSpaceToken)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSpaceToken *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_tokenArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tokenArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSpaceToken **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSpaceToken*)a)->__sizetokenArray = 0; !soap_element_begin_in(soap, "tokenArray", 1); ((SRMv2__ArrayOfTSpaceToken*)a)->__sizetokenArray++)
				{	p = (SRMv2__TSpaceToken **)soap_push_block(soap, sizeof(SRMv2__TSpaceToken *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSpaceToken(soap, "tokenArray", p, "SRMv2:TSpaceToken"))
						break;
					soap_flag_tokenArray1 = 0;
				}
				((SRMv2__ArrayOfTSpaceToken*)a)->tokenArray = (SRMv2__TSpaceToken **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_tokenArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSpaceToken *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSpaceToken, 0, sizeof(SRMv2__ArrayOfTSpaceToken), 0, soap_copy_SRMv2__ArrayOfTSpaceToken);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSpaceToken * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSpaceToken(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSpaceToken(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSpaceToken(struct soap *soap, SRMv2__ArrayOfTSpaceToken *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSpaceToken * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSpaceToken(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSpaceToken(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSpaceToken, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSpaceToken;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSpaceToken);
		((SRMv2__ArrayOfTSpaceToken*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSpaceToken[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSpaceToken);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSpaceToken*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n