/* srm2_soapServer.cpp
   Generated by gSOAP 2.7.8a from srm2_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
#include "srm2_soapH.h"

SOAP_SOURCE_STAMP("@(#) srm2_soapServer.cpp ver 2.7.8a 2009-04-06 10:50:17 GMT")


SOAP_FMAC5 int SOAP_FMAC6 srm2_soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || srm2_soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 srm2_soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmReserveSpace"))
		return soap_serve_SRMv2__srmReserveSpace(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmReleaseSpace"))
		return soap_serve_SRMv2__srmReleaseSpace(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmUpdateSpace"))
		return soap_serve_SRMv2__srmUpdateSpace(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmCompactSpace"))
		return soap_serve_SRMv2__srmCompactSpace(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmGetSpaceMetaData"))
		return soap_serve_SRMv2__srmGetSpaceMetaData(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmChangeFileStorageType"))
		return soap_serve_SRMv2__srmChangeFileStorageType(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmGetSpaceToken"))
		return soap_serve_SRMv2__srmGetSpaceToken(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmSetPermission"))
		return soap_serve_SRMv2__srmSetPermission(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmReassignToUser"))
		return soap_serve_SRMv2__srmReassignToUser(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmCheckPermission"))
		return soap_serve_SRMv2__srmCheckPermission(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmMkdir"))
		return soap_serve_SRMv2__srmMkdir(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmRmdir"))
		return soap_serve_SRMv2__srmRmdir(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmRm"))
		return soap_serve_SRMv2__srmRm(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmLs"))
		return soap_serve_SRMv2__srmLs(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmMv"))
		return soap_serve_SRMv2__srmMv(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmPrepareToGet"))
		return soap_serve_SRMv2__srmPrepareToGet(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmPrepareToPut"))
		return soap_serve_SRMv2__srmPrepareToPut(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmCopy"))
		return soap_serve_SRMv2__srmCopy(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmRemoveFiles"))
		return soap_serve_SRMv2__srmRemoveFiles(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmReleaseFiles"))
		return soap_serve_SRMv2__srmReleaseFiles(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmPutDone"))
		return soap_serve_SRMv2__srmPutDone(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmAbortRequest"))
		return soap_serve_SRMv2__srmAbortRequest(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmAbortFiles"))
		return soap_serve_SRMv2__srmAbortFiles(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmSuspendRequest"))
		return soap_serve_SRMv2__srmSuspendRequest(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmResumeRequest"))
		return soap_serve_SRMv2__srmResumeRequest(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmStatusOfGetRequest"))
		return soap_serve_SRMv2__srmStatusOfGetRequest(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmStatusOfPutRequest"))
		return soap_serve_SRMv2__srmStatusOfPutRequest(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmStatusOfCopyRequest"))
		return soap_serve_SRMv2__srmStatusOfCopyRequest(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmGetRequestSummary"))
		return soap_serve_SRMv2__srmGetRequestSummary(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmExtendFileLifeTime"))
		return soap_serve_SRMv2__srmExtendFileLifeTime(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv2:srmGetRequestID"))
		return soap_serve_SRMv2__srmGetRequestID(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmReserveSpace(struct soap *soap)
{	struct SRMv2__srmReserveSpace soap_tmp_SRMv2__srmReserveSpace;
	struct SRMv2__srmReserveSpaceResponse_ _param_1;
	soap_default_SRMv2__srmReserveSpaceResponse_(soap, &_param_1);
	soap_default_SRMv2__srmReserveSpace(soap, &soap_tmp_SRMv2__srmReserveSpace);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmReserveSpace(soap, &soap_tmp_SRMv2__srmReserveSpace, "SRMv2:srmReserveSpace", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmReserveSpace(soap, soap_tmp_SRMv2__srmReserveSpace.srmReserveSpaceRequest, _param_1);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmReserveSpaceResponse_(soap, &_param_1);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmReserveSpaceResponse_(soap, &_param_1, "SRMv2:srmReserveSpaceResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmReserveSpaceResponse_(soap, &_param_1, "SRMv2:srmReserveSpaceResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmReleaseSpace(struct soap *soap)
{	struct SRMv2__srmReleaseSpace soap_tmp_SRMv2__srmReleaseSpace;
	struct SRMv2__srmReleaseSpaceResponse_ _param_2;
	soap_default_SRMv2__srmReleaseSpaceResponse_(soap, &_param_2);
	soap_default_SRMv2__srmReleaseSpace(soap, &soap_tmp_SRMv2__srmReleaseSpace);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmReleaseSpace(soap, &soap_tmp_SRMv2__srmReleaseSpace, "SRMv2:srmReleaseSpace", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmReleaseSpace(soap, soap_tmp_SRMv2__srmReleaseSpace.srmReleaseSpaceRequest, _param_2);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmReleaseSpaceResponse_(soap, &_param_2);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmReleaseSpaceResponse_(soap, &_param_2, "SRMv2:srmReleaseSpaceResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmReleaseSpaceResponse_(soap, &_param_2, "SRMv2:srmReleaseSpaceResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmUpdateSpace(struct soap *soap)
{	struct SRMv2__srmUpdateSpace soap_tmp_SRMv2__srmUpdateSpace;
	struct SRMv2__srmUpdateSpaceResponse_ _param_3;
	soap_default_SRMv2__srmUpdateSpaceResponse_(soap, &_param_3);
	soap_default_SRMv2__srmUpdateSpace(soap, &soap_tmp_SRMv2__srmUpdateSpace);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmUpdateSpace(soap, &soap_tmp_SRMv2__srmUpdateSpace, "SRMv2:srmUpdateSpace", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmUpdateSpace(soap, soap_tmp_SRMv2__srmUpdateSpace.srmUpdateSpaceRequest, _param_3);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmUpdateSpaceResponse_(soap, &_param_3);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmUpdateSpaceResponse_(soap, &_param_3, "SRMv2:srmUpdateSpaceResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmUpdateSpaceResponse_(soap, &_param_3, "SRMv2:srmUpdateSpaceResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmCompactSpace(struct soap *soap)
{	struct SRMv2__srmCompactSpace soap_tmp_SRMv2__srmCompactSpace;
	struct SRMv2__srmCompactSpaceResponse_ _param_4;
	soap_default_SRMv2__srmCompactSpaceResponse_(soap, &_param_4);
	soap_default_SRMv2__srmCompactSpace(soap, &soap_tmp_SRMv2__srmCompactSpace);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmCompactSpace(soap, &soap_tmp_SRMv2__srmCompactSpace, "SRMv2:srmCompactSpace", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmCompactSpace(soap, soap_tmp_SRMv2__srmCompactSpace.srmCompactSpaceRequest, _param_4);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmCompactSpaceResponse_(soap, &_param_4);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmCompactSpaceResponse_(soap, &_param_4, "SRMv2:srmCompactSpaceResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmCompactSpaceResponse_(soap, &_param_4, "SRMv2:srmCompactSpaceResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmGetSpaceMetaData(struct soap *soap)
{	struct SRMv2__srmGetSpaceMetaData soap_tmp_SRMv2__srmGetSpaceMetaData;
	struct SRMv2__srmGetSpaceMetaDataResponse_ _param_5;
	soap_default_SRMv2__srmGetSpaceMetaDataResponse_(soap, &_param_5);
	soap_default_SRMv2__srmGetSpaceMetaData(soap, &soap_tmp_SRMv2__srmGetSpaceMetaData);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmGetSpaceMetaData(soap, &soap_tmp_SRMv2__srmGetSpaceMetaData, "SRMv2:srmGetSpaceMetaData", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmGetSpaceMetaData(soap, soap_tmp_SRMv2__srmGetSpaceMetaData.srmGetSpaceMetaDataRequest, _param_5);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmGetSpaceMetaDataResponse_(soap, &_param_5);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmGetSpaceMetaDataResponse_(soap, &_param_5, "SRMv2:srmGetSpaceMetaDataResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmGetSpaceMetaDataResponse_(soap, &_param_5, "SRMv2:srmGetSpaceMetaDataResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmChangeFileStorageType(struct soap *soap)
{	struct SRMv2__srmChangeFileStorageType soap_tmp_SRMv2__srmChangeFileStorageType;
	struct SRMv2__srmChangeFileStorageTypeResponse_ _param_6;
	soap_default_SRMv2__srmChangeFileStorageTypeResponse_(soap, &_param_6);
	soap_default_SRMv2__srmChangeFileStorageType(soap, &soap_tmp_SRMv2__srmChangeFileStorageType);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmChangeFileStorageType(soap, &soap_tmp_SRMv2__srmChangeFileStorageType, "SRMv2:srmChangeFileStorageType", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmChangeFileStorageType(soap, soap_tmp_SRMv2__srmChangeFileStorageType.srmChangeFileStorageTypeRequest, _param_6);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmChangeFileStorageTypeResponse_(soap, &_param_6);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmChangeFileStorageTypeResponse_(soap, &_param_6, "SRMv2:srmChangeFileStorageTypeResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmChangeFileStorageTypeResponse_(soap, &_param_6, "SRMv2:srmChangeFileStorageTypeResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmGetSpaceToken(struct soap *soap)
{	struct SRMv2__srmGetSpaceToken soap_tmp_SRMv2__srmGetSpaceToken;
	struct SRMv2__srmGetSpaceTokenResponse_ _param_7;
	soap_default_SRMv2__srmGetSpaceTokenResponse_(soap, &_param_7);
	soap_default_SRMv2__srmGetSpaceToken(soap, &soap_tmp_SRMv2__srmGetSpaceToken);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmGetSpaceToken(soap, &soap_tmp_SRMv2__srmGetSpaceToken, "SRMv2:srmGetSpaceToken", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmGetSpaceToken(soap, soap_tmp_SRMv2__srmGetSpaceToken.srmGetSpaceTokenRequest, _param_7);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmGetSpaceTokenResponse_(soap, &_param_7);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmGetSpaceTokenResponse_(soap, &_param_7, "SRMv2:srmGetSpaceTokenResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmGetSpaceTokenResponse_(soap, &_param_7, "SRMv2:srmGetSpaceTokenResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmSetPermission(struct soap *soap)
{	struct SRMv2__srmSetPermission soap_tmp_SRMv2__srmSetPermission;
	struct SRMv2__srmSetPermissionResponse_ _param_8;
	soap_default_SRMv2__srmSetPermissionResponse_(soap, &_param_8);
	soap_default_SRMv2__srmSetPermission(soap, &soap_tmp_SRMv2__srmSetPermission);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmSetPermission(soap, &soap_tmp_SRMv2__srmSetPermission, "SRMv2:srmSetPermission", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmSetPermission(soap, soap_tmp_SRMv2__srmSetPermission.srmSetPermissionRequest, _param_8);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmSetPermissionResponse_(soap, &_param_8);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmSetPermissionResponse_(soap, &_param_8, "SRMv2:srmSetPermissionResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmSetPermissionResponse_(soap, &_param_8, "SRMv2:srmSetPermissionResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmReassignToUser(struct soap *soap)
{	struct SRMv2__srmReassignToUser soap_tmp_SRMv2__srmReassignToUser;
	struct SRMv2__srmReassignToUserResponse_ _param_9;
	soap_default_SRMv2__srmReassignToUserResponse_(soap, &_param_9);
	soap_default_SRMv2__srmReassignToUser(soap, &soap_tmp_SRMv2__srmReassignToUser);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmReassignToUser(soap, &soap_tmp_SRMv2__srmReassignToUser, "SRMv2:srmReassignToUser", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmReassignToUser(soap, soap_tmp_SRMv2__srmReassignToUser.srmReassignToUserRequest, _param_9);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmReassignToUserResponse_(soap, &_param_9);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmReassignToUserResponse_(soap, &_param_9, "SRMv2:srmReassignToUserResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmReassignToUserResponse_(soap, &_param_9, "SRMv2:srmReassignToUserResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmCheckPermission(struct soap *soap)
{	struct SRMv2__srmCheckPermission soap_tmp_SRMv2__srmCheckPermission;
	struct SRMv2__srmCheckPermissionResponse_ _param_10;
	soap_default_SRMv2__srmCheckPermissionResponse_(soap, &_param_10);
	soap_default_SRMv2__srmCheckPermission(soap, &soap_tmp_SRMv2__srmCheckPermission);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmCheckPermission(soap, &soap_tmp_SRMv2__srmCheckPermission, "SRMv2:srmCheckPermission", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmCheckPermission(soap, soap_tmp_SRMv2__srmCheckPermission.srmCheckPermissionRequest, _param_10);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmCheckPermissionResponse_(soap, &_param_10);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmCheckPermissionResponse_(soap, &_param_10, "SRMv2:srmCheckPermissionResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmCheckPermissionResponse_(soap, &_param_10, "SRMv2:srmCheckPermissionResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmMkdir(struct soap *soap)
{	struct SRMv2__srmMkdir soap_tmp_SRMv2__srmMkdir;
	struct SRMv2__srmMkdirResponse_ _param_11;
	soap_default_SRMv2__srmMkdirResponse_(soap, &_param_11);
	soap_default_SRMv2__srmMkdir(soap, &soap_tmp_SRMv2__srmMkdir);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmMkdir(soap, &soap_tmp_SRMv2__srmMkdir, "SRMv2:srmMkdir", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmMkdir(soap, soap_tmp_SRMv2__srmMkdir.srmMkdirRequest, _param_11);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmMkdirResponse_(soap, &_param_11);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmMkdirResponse_(soap, &_param_11, "SRMv2:srmMkdirResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmMkdirResponse_(soap, &_param_11, "SRMv2:srmMkdirResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmRmdir(struct soap *soap)
{	struct SRMv2__srmRmdir soap_tmp_SRMv2__srmRmdir;
	struct SRMv2__srmRmdirResponse_ _param_12;
	soap_default_SRMv2__srmRmdirResponse_(soap, &_param_12);
	soap_default_SRMv2__srmRmdir(soap, &soap_tmp_SRMv2__srmRmdir);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmRmdir(soap, &soap_tmp_SRMv2__srmRmdir, "SRMv2:srmRmdir", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmRmdir(soap, soap_tmp_SRMv2__srmRmdir.srmRmdirRequest, _param_12);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmRmdirResponse_(soap, &_param_12);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmRmdirResponse_(soap, &_param_12, "SRMv2:srmRmdirResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmRmdirResponse_(soap, &_param_12, "SRMv2:srmRmdirResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmRm(struct soap *soap)
{	struct SRMv2__srmRm soap_tmp_SRMv2__srmRm;
	struct SRMv2__srmRmResponse_ _param_13;
	soap_default_SRMv2__srmRmResponse_(soap, &_param_13);
	soap_default_SRMv2__srmRm(soap, &soap_tmp_SRMv2__srmRm);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmRm(soap, &soap_tmp_SRMv2__srmRm, "SRMv2:srmRm", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmRm(soap, soap_tmp_SRMv2__srmRm.srmRmRequest, _param_13);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmRmResponse_(soap, &_param_13);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmRmResponse_(soap, &_param_13, "SRMv2:srmRmResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmRmResponse_(soap, &_param_13, "SRMv2:srmRmResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmLs(struct soap *soap)
{	struct SRMv2__srmLs soap_tmp_SRMv2__srmLs;
	struct SRMv2__srmLsResponse_ _param_14;
	soap_default_SRMv2__srmLsResponse_(soap, &_param_14);
	soap_default_SRMv2__srmLs(soap, &soap_tmp_SRMv2__srmLs);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmLs(soap, &soap_tmp_SRMv2__srmLs, "SRMv2:srmLs", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmLs(soap, soap_tmp_SRMv2__srmLs.srmLsRequest, _param_14);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmLsResponse_(soap, &_param_14);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmLsResponse_(soap, &_param_14, "SRMv2:srmLsResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmLsResponse_(soap, &_param_14, "SRMv2:srmLsResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmMv(struct soap *soap)
{	struct SRMv2__srmMv soap_tmp_SRMv2__srmMv;
	struct SRMv2__srmMvResponse_ _param_15;
	soap_default_SRMv2__srmMvResponse_(soap, &_param_15);
	soap_default_SRMv2__srmMv(soap, &soap_tmp_SRMv2__srmMv);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmMv(soap, &soap_tmp_SRMv2__srmMv, "SRMv2:srmMv", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmMv(soap, soap_tmp_SRMv2__srmMv.srmMvRequest, _param_15);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmMvResponse_(soap, &_param_15);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmMvResponse_(soap, &_param_15, "SRMv2:srmMvResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmMvResponse_(soap, &_param_15, "SRMv2:srmMvResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmPrepareToGet(struct soap *soap)
{	struct SRMv2__srmPrepareToGet soap_tmp_SRMv2__srmPrepareToGet;
	struct SRMv2__srmPrepareToGetResponse_ _param_16;
	soap_default_SRMv2__srmPrepareToGetResponse_(soap, &_param_16);
	soap_default_SRMv2__srmPrepareToGet(soap, &soap_tmp_SRMv2__srmPrepareToGet);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmPrepareToGet(soap, &soap_tmp_SRMv2__srmPrepareToGet, "SRMv2:srmPrepareToGet", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmPrepareToGet(soap, soap_tmp_SRMv2__srmPrepareToGet.srmPrepareToGetRequest, _param_16);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmPrepareToGetResponse_(soap, &_param_16);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmPrepareToGetResponse_(soap, &_param_16, "SRMv2:srmPrepareToGetResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmPrepareToGetResponse_(soap, &_param_16, "SRMv2:srmPrepareToGetResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmPrepareToPut(struct soap *soap)
{	struct SRMv2__srmPrepareToPut soap_tmp_SRMv2__srmPrepareToPut;
	struct SRMv2__srmPrepareToPutResponse_ _param_17;
	soap_default_SRMv2__srmPrepareToPutResponse_(soap, &_param_17);
	soap_default_SRMv2__srmPrepareToPut(soap, &soap_tmp_SRMv2__srmPrepareToPut);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmPrepareToPut(soap, &soap_tmp_SRMv2__srmPrepareToPut, "SRMv2:srmPrepareToPut", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmPrepareToPut(soap, soap_tmp_SRMv2__srmPrepareToPut.srmPrepareToPutRequest, _param_17);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmPrepareToPutResponse_(soap, &_param_17);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmPrepareToPutResponse_(soap, &_param_17, "SRMv2:srmPrepareToPutResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmPrepareToPutResponse_(soap, &_param_17, "SRMv2:srmPrepareToPutResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmCopy(struct soap *soap)
{	struct SRMv2__srmCopy soap_tmp_SRMv2__srmCopy;
	struct SRMv2__srmCopyResponse_ _param_18;
	soap_default_SRMv2__srmCopyResponse_(soap, &_param_18);
	soap_default_SRMv2__srmCopy(soap, &soap_tmp_SRMv2__srmCopy);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmCopy(soap, &soap_tmp_SRMv2__srmCopy, "SRMv2:srmCopy", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmCopy(soap, soap_tmp_SRMv2__srmCopy.srmCopyRequest, _param_18);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmCopyResponse_(soap, &_param_18);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmCopyResponse_(soap, &_param_18, "SRMv2:srmCopyResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmCopyResponse_(soap, &_param_18, "SRMv2:srmCopyResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmRemoveFiles(struct soap *soap)
{	struct SRMv2__srmRemoveFiles soap_tmp_SRMv2__srmRemoveFiles;
	struct SRMv2__srmRemoveFilesResponse_ _param_19;
	soap_default_SRMv2__srmRemoveFilesResponse_(soap, &_param_19);
	soap_default_SRMv2__srmRemoveFiles(soap, &soap_tmp_SRMv2__srmRemoveFiles);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmRemoveFiles(soap, &soap_tmp_SRMv2__srmRemoveFiles, "SRMv2:srmRemoveFiles", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmRemoveFiles(soap, soap_tmp_SRMv2__srmRemoveFiles.srmRemoveFilesRequest, _param_19);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmRemoveFilesResponse_(soap, &_param_19);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmRemoveFilesResponse_(soap, &_param_19, "SRMv2:srmRemoveFilesResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmRemoveFilesResponse_(soap, &_param_19, "SRMv2:srmRemoveFilesResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmReleaseFiles(struct soap *soap)
{	struct SRMv2__srmReleaseFiles soap_tmp_SRMv2__srmReleaseFiles;
	struct SRMv2__srmReleaseFilesResponse_ _param_20;
	soap_default_SRMv2__srmReleaseFilesResponse_(soap, &_param_20);
	soap_default_SRMv2__srmReleaseFiles(soap, &soap_tmp_SRMv2__srmReleaseFiles);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmReleaseFiles(soap, &soap_tmp_SRMv2__srmReleaseFiles, "SRMv2:srmReleaseFiles", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmReleaseFiles(soap, soap_tmp_SRMv2__srmReleaseFiles.srmReleaseFilesRequest, _param_20);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmReleaseFilesResponse_(soap, &_param_20);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmReleaseFilesResponse_(soap, &_param_20, "SRMv2:srmReleaseFilesResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmReleaseFilesResponse_(soap, &_param_20, "SRMv2:srmReleaseFilesResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmPutDone(struct soap *soap)
{	struct SRMv2__srmPutDone soap_tmp_SRMv2__srmPutDone;
	struct SRMv2__srmPutDoneResponse_ _param_21;
	soap_default_SRMv2__srmPutDoneResponse_(soap, &_param_21);
	soap_default_SRMv2__srmPutDone(soap, &soap_tmp_SRMv2__srmPutDone);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmPutDone(soap, &soap_tmp_SRMv2__srmPutDone, "SRMv2:srmPutDone", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmPutDone(soap, soap_tmp_SRMv2__srmPutDone.srmPutDoneRequest, _param_21);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmPutDoneResponse_(soap, &_param_21);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmPutDoneResponse_(soap, &_param_21, "SRMv2:srmPutDoneResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmPutDoneResponse_(soap, &_param_21, "SRMv2:srmPutDoneResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmAbortRequest(struct soap *soap)
{	struct SRMv2__srmAbortRequest soap_tmp_SRMv2__srmAbortRequest;
	struct SRMv2__srmAbortRequestResponse_ _param_22;
	soap_default_SRMv2__srmAbortRequestResponse_(soap, &_param_22);
	soap_default_SRMv2__srmAbortRequest(soap, &soap_tmp_SRMv2__srmAbortRequest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmAbortRequest(soap, &soap_tmp_SRMv2__srmAbortRequest, "SRMv2:srmAbortRequest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmAbortRequest(soap, soap_tmp_SRMv2__srmAbortRequest.srmAbortRequestRequest, _param_22);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmAbortRequestResponse_(soap, &_param_22);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmAbortRequestResponse_(soap, &_param_22, "SRMv2:srmAbortRequestResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmAbortRequestResponse_(soap, &_param_22, "SRMv2:srmAbortRequestResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmAbortFiles(struct soap *soap)
{	struct SRMv2__srmAbortFiles soap_tmp_SRMv2__srmAbortFiles;
	struct SRMv2__srmAbortFilesResponse_ _param_23;
	soap_default_SRMv2__srmAbortFilesResponse_(soap, &_param_23);
	soap_default_SRMv2__srmAbortFiles(soap, &soap_tmp_SRMv2__srmAbortFiles);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmAbortFiles(soap, &soap_tmp_SRMv2__srmAbortFiles, "SRMv2:srmAbortFiles", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmAbortFiles(soap, soap_tmp_SRMv2__srmAbortFiles.srmAbortFilesRequest, _param_23);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmAbortFilesResponse_(soap, &_param_23);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmAbortFilesResponse_(soap, &_param_23, "SRMv2:srmAbortFilesResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmAbortFilesResponse_(soap, &_param_23, "SRMv2:srmAbortFilesResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmSuspendRequest(struct soap *soap)
{	struct SRMv2__srmSuspendRequest soap_tmp_SRMv2__srmSuspendRequest;
	struct SRMv2__srmSuspendRequestResponse_ _param_24;
	soap_default_SRMv2__srmSuspendRequestResponse_(soap, &_param_24);
	soap_default_SRMv2__srmSuspendRequest(soap, &soap_tmp_SRMv2__srmSuspendRequest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmSuspendRequest(soap, &soap_tmp_SRMv2__srmSuspendRequest, "SRMv2:srmSuspendRequest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmSuspendRequest(soap, soap_tmp_SRMv2__srmSuspendRequest.srmSuspendRequestRequest, _param_24);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmSuspendRequestResponse_(soap, &_param_24);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmSuspendRequestResponse_(soap, &_param_24, "SRMv2:srmSuspendRequestResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmSuspendRequestResponse_(soap, &_param_24, "SRMv2:srmSuspendRequestResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmResumeRequest(struct soap *soap)
{	struct SRMv2__srmResumeRequest soap_tmp_SRMv2__srmResumeRequest;
	struct SRMv2__srmResumeRequestResponse_ _param_25;
	soap_default_SRMv2__srmResumeRequestResponse_(soap, &_param_25);
	soap_default_SRMv2__srmResumeRequest(soap, &soap_tmp_SRMv2__srmResumeRequest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmResumeRequest(soap, &soap_tmp_SRMv2__srmResumeRequest, "SRMv2:srmResumeRequest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmResumeRequest(soap, soap_tmp_SRMv2__srmResumeRequest.srmResumeRequestRequest, _param_25);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmResumeRequestResponse_(soap, &_param_25);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmResumeRequestResponse_(soap, &_param_25, "SRMv2:srmResumeRequestResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmResumeRequestResponse_(soap, &_param_25, "SRMv2:srmResumeRequestResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmStatusOfGetRequest(struct soap *soap)
{	struct SRMv2__srmStatusOfGetRequest soap_tmp_SRMv2__srmStatusOfGetRequest;
	struct SRMv2__srmStatusOfGetRequestResponse_ _param_26;
	soap_default_SRMv2__srmStatusOfGetRequestResponse_(soap, &_param_26);
	soap_default_SRMv2__srmStatusOfGetRequest(soap, &soap_tmp_SRMv2__srmStatusOfGetRequest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmStatusOfGetRequest(soap, &soap_tmp_SRMv2__srmStatusOfGetRequest, "SRMv2:srmStatusOfGetRequest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmStatusOfGetRequest(soap, soap_tmp_SRMv2__srmStatusOfGetRequest.srmStatusOfGetRequestRequest, _param_26);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmStatusOfGetRequestResponse_(soap, &_param_26);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmStatusOfGetRequestResponse_(soap, &_param_26, "SRMv2:srmStatusOfGetRequestResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmStatusOfGetRequestResponse_(soap, &_param_26, "SRMv2:srmStatusOfGetRequestResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmStatusOfPutRequest(struct soap *soap)
{	struct SRMv2__srmStatusOfPutRequest soap_tmp_SRMv2__srmStatusOfPutRequest;
	struct SRMv2__srmStatusOfPutRequestResponse_ _param_27;
	soap_default_SRMv2__srmStatusOfPutRequestResponse_(soap, &_param_27);
	soap_default_SRMv2__srmStatusOfPutRequest(soap, &soap_tmp_SRMv2__srmStatusOfPutRequest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmStatusOfPutRequest(soap, &soap_tmp_SRMv2__srmStatusOfPutRequest, "SRMv2:srmStatusOfPutRequest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmStatusOfPutRequest(soap, soap_tmp_SRMv2__srmStatusOfPutRequest.srmStatusOfPutRequestRequest, _param_27);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmStatusOfPutRequestResponse_(soap, &_param_27);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmStatusOfPutRequestResponse_(soap, &_param_27, "SRMv2:srmStatusOfPutRequestResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmStatusOfPutRequestResponse_(soap, &_param_27, "SRMv2:srmStatusOfPutRequestResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmStatusOfCopyRequest(struct soap *soap)
{	struct SRMv2__srmStatusOfCopyRequest soap_tmp_SRMv2__srmStatusOfCopyRequest;
	struct SRMv2__srmStatusOfCopyRequestResponse_ _param_28;
	soap_default_SRMv2__srmStatusOfCopyRequestResponse_(soap, &_param_28);
	soap_default_SRMv2__srmStatusOfCopyRequest(soap, &soap_tmp_SRMv2__srmStatusOfCopyRequest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmStatusOfCopyRequest(soap, &soap_tmp_SRMv2__srmStatusOfCopyRequest, "SRMv2:srmStatusOfCopyRequest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmStatusOfCopyRequest(soap, soap_tmp_SRMv2__srmStatusOfCopyRequest.srmStatusOfCopyRequestRequest, _param_28);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmStatusOfCopyRequestResponse_(soap, &_param_28);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmStatusOfCopyRequestResponse_(soap, &_param_28, "SRMv2:srmStatusOfCopyRequestResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmStatusOfCopyRequestResponse_(soap, &_param_28, "SRMv2:srmStatusOfCopyRequestResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmGetRequestSummary(struct soap *soap)
{	struct SRMv2__srmGetRequestSummary soap_tmp_SRMv2__srmGetRequestSummary;
	struct SRMv2__srmGetRequestSummaryResponse_ _param_29;
	soap_default_SRMv2__srmGetRequestSummaryResponse_(soap, &_param_29);
	soap_default_SRMv2__srmGetRequestSummary(soap, &soap_tmp_SRMv2__srmGetRequestSummary);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmGetRequestSummary(soap, &soap_tmp_SRMv2__srmGetRequestSummary, "SRMv2:srmGetRequestSummary", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmGetRequestSummary(soap, soap_tmp_SRMv2__srmGetRequestSummary.srmGetRequestSummaryRequest, _param_29);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmGetRequestSummaryResponse_(soap, &_param_29);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmGetRequestSummaryResponse_(soap, &_param_29, "SRMv2:srmGetRequestSummaryResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmGetRequestSummaryResponse_(soap, &_param_29, "SRMv2:srmGetRequestSummaryResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmExtendFileLifeTime(struct soap *soap)
{	struct SRMv2__srmExtendFileLifeTime soap_tmp_SRMv2__srmExtendFileLifeTime;
	struct SRMv2__srmExtendFileLifeTimeResponse_ _param_30;
	soap_default_SRMv2__srmExtendFileLifeTimeResponse_(soap, &_param_30);
	soap_default_SRMv2__srmExtendFileLifeTime(soap, &soap_tmp_SRMv2__srmExtendFileLifeTime);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmExtendFileLifeTime(soap, &soap_tmp_SRMv2__srmExtendFileLifeTime, "SRMv2:srmExtendFileLifeTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmExtendFileLifeTime(soap, soap_tmp_SRMv2__srmExtendFileLifeTime.srmExtendFileLifeTimeRequest, _param_30);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmExtendFileLifeTimeResponse_(soap, &_param_30);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmExtendFileLifeTimeResponse_(soap, &_param_30, "SRMv2:srmExtendFileLifeTimeResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmExtendFileLifeTimeResponse_(soap, &_param_30, "SRMv2:srmExtendFileLifeTimeResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv2__srmGetRequestID(struct soap *soap)
{	struct SRMv2__srmGetRequestID soap_tmp_SRMv2__srmGetRequestID;
	struct SRMv2__srmGetRequestIDResponse_ _param_31;
	soap_default_SRMv2__srmGetRequestIDResponse_(soap, &_param_31);
	soap_default_SRMv2__srmGetRequestID(soap, &soap_tmp_SRMv2__srmGetRequestID);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv2__srmGetRequestID(soap, &soap_tmp_SRMv2__srmGetRequestID, "SRMv2:srmGetRequestID", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv2__srmGetRequestID(soap, soap_tmp_SRMv2__srmGetRequestID.srmGetRequestIDRequest, _param_31);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv2__srmGetRequestIDResponse_(soap, &_param_31);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv2__srmGetRequestIDResponse_(soap, &_param_31, "SRMv2:srmGetRequestIDResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv2__srmGetRequestIDResponse_(soap, &_param_31, "SRMv2:srmGetRequestIDResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

/* End of srm2_soapServer.cpp */
