#include "../../std.h"

#include <string>

#include <arc/url.h>
#include "../se/files.h"
#include "srm_url.h"
#include "srm1_soapH.h"
#include "../../misc/log_time.h"
#include "../server/httpsd.h"

#include "srm_utils.h"

int requestId = 0;

SRMv1Type__RequestStatus* soap_error_SRMv1Type__RequestStatus(struct soap *sp,int n,const char* reason) {
  SRMv1Type__RequestStatus* r=soap_new_SRMv1Type__RequestStatus(sp,-1);
  if(r == NULL) return NULL;
  r->soap_default(sp);
  time_t* t = (time_t*)soap_malloc(sp,sizeof(time_t)); if(t) time(t);
  r->requestId=requestId++;
  r->state ="Failed";
  r->submitTime=t;
  r->startTime=t;
  r->finishTime=t;
  r->estTimeToStart=0;
  if(reason) {
    r->errorMessage=(char*)reason;
  } else {
    r->errorMessage="Method not supported"; 
  };
  r->retryDeltaTime=0;
  r->fileStatuses=NULL;
  if(n<=0) return r;
  r->fileStatuses=soap_new_ArrayOfRequestFileStatus(sp,-1);
  if(r->fileStatuses == NULL) return NULL;
  r->fileStatuses->soap_default(sp);
  r->fileStatuses->__size=0;
  r->fileStatuses->__ptr=(SRMv1Type__RequestFileStatus**)soap_malloc(sp,sizeof(SRMv1Type__RequestFileStatus*)*n);
  if(r->fileStatuses->__ptr == NULL) {
    return NULL;
  };
  r->fileStatuses->__size=n;
  for(int i=0;i<n;i++) {
  //  r->fileStatuses->__ptr[i]=soap_new_SRMv1Type__RequestFileStatus(sp,-1);
    r->fileStatuses->__ptr[i]=NULL;
  };
  return r;
}

void convert_checksum(struct soap *sp,const std::string& checksum,char** checksumType,char** checksumValue) {
  if(checksum.length() == 0) {
    (*checksumValue)=NULL;
    (*checksumType)=NULL;
    return;
  };
  std::string::size_type p = checksum.find(':');
  if(p != std::string::npos) {
    (*checksumType)=(char*)soap_malloc(sp,(p+1)*sizeof(char));
    if(*checksumType) {
      memcpy(*checksumType,checksum.c_str(),p);
      (*checksumType)[p]=0;
    };
    ++p;
    for(;checksum[p];++p) { if(!isspace(checksum[p])) break; };
    (*checksumValue)=soap_strdup(sp,checksum.c_str()+p);
  } else {
    (*checksumValue)=soap_strdup(sp,checksum.c_str());
    (*checksumType)="cksum";
  };
}

SEFiles::iterator find_file(const std::string& id,SEFiles* files,AuthUser& identity,int acl_mask) {
  SEFiles::iterator f = files->begin();
  for(;f!=files->end();++f) {
    odlog(DEBUG)<<"file: "<<f->id()<<std::endl;
    if(id == f->id()) {
      odlog(VERBOSE)<<"matched"<<std::endl;
      if((f->state_file()==FILE_STATE_COMPLETE) ||
         (f->state_file()==FILE_STATE_VALID)) {
        odlog(VERBOSE)<<"complete"<<std::endl;
        if((!acl_mask) || (f->check_acl(identity) & acl_mask)) {
          odlog(VERBOSE)<<"allowed"<<std::endl;
        } else {
          f=files->end();
        };
      } else {
        f=files->end();
      };
      break; // file found
    };
  };
  return f;
}

SEFiles::iterator get_file(struct soap *sp,const std::string& id,SEFiles* files,SRMv1Type__RequestFileStatus *f_status,AuthUser& identity,int acl_mask) {
  SEFiles::iterator f = files->begin();
  odlog(VERBOSE)<<"get_file: id: "<<id<<std::endl;
  for(;f!=files->end();++f) {
    odlog(DEBUG)<<"file: "<<f->id()<<std::endl;
    if(id == f->id()) {
      odlog(VERBOSE)<<"matched"<<std::endl;
      if((f->state_file()==FILE_STATE_COMPLETE) ||
         (f->state_file()==FILE_STATE_VALID)) {
        odlog(VERBOSE)<<"complete"<<std::endl;
        if((!acl_mask) || (f->check_acl(identity) & acl_mask)) {
          odlog(VERBOSE)<<"allowed"<<std::endl;
          // Prepare answer about this file
          f_status->size=f->size();
          convert_checksum(sp,f->checksum(),
              &(f_status->checksumType),&(f_status->checksumValue));
          f_status->isPinned=(f->pinned() > 0);
          f_status->isPermanent=true;
          f_status->isCached=true;
          f_status->estSecondsToStart=0;
          f_status->state="ready";
          f_status->sourceFilename=NULL;
          f_status->destFilename=NULL;
          f_status->queueOrder=0;
          f_status->owner=NULL;
          f_status->group=NULL;
          f_status->permMode=0;
        } else {
          f=files->end();
        };
      } else {
        f=files->end();
      };
      break; // file found
    };
  };
  if(f==files->end()) { // file not found
    f_status->size=0;
    f_status->checksumValue=NULL;
    f_status->checksumType=NULL;
    f_status->isPinned=false;
    f_status->isPermanent=false;
    f_status->isCached=false;
    f_status->estSecondsToStart=0;
    f_status->state="Failed";
    f_status->sourceFilename=NULL;
    f_status->destFilename=NULL;
    f_status->queueOrder=0;
    f_status->owner=NULL;
    f_status->group=NULL;
    f_status->permMode=0;
  };
  return f;
}

std::string get_ID_from_TURL(const char* turl,const char* service) {
  try {
    URL u_f(turl);
    URL u_s(service);
    if(strncmp(u_f.Path().c_str(),u_s.Path().c_str(),u_s.Path().length())!=0) 
                                                                  return "";
    std::string id(u_f.Path().c_str()+u_s.Path().length());
    return id;
  } catch (std::exception e) {
    return "";
  };
}

std::string get_ID_from_SURL(const char* surl,const char* service,bool* isshort) {
  SRM_URL u(surl);
  std::string id = u.FileName();
  if(isshort) (*isshort)=u.Short();
  return id;
}


std::string strip_SURL_to_ID(const char* surl,const char* service,bool* isshort) {
  if(isshort) (*isshort)=false;
  if(strncmp("srm://",surl,6) != 0) return std::string(surl);
  SRM_URL u(surl);
  std::string id = u.FileName();
  if(isshort) (*isshort)=u.Short();
  return id;
}


bool array_is_empty(ArrayOfstring* a) {
  if(a == NULL) return true;
  if(a->__ptr == NULL) return true;
  if(a->__size == 0) return true;
  return false;
}

bool array_is_empty(ArrayOflong* a) {
  if(a == NULL) return true;
  if(a->__ptr == NULL) return true;
  if(a->__size == 0) return true;
  return false;
}


bool array_is_empty(ArrayOfboolean* a) {
  if(a == NULL) return true;
  if(a->__ptr == NULL) return true;
  if(a->__size == 0) return true;
  return false;
}

const char* check_protocols(ArrayOfstring* Protocols) {
  // Look for supported protocols
  if((Protocols == NULL) ||
     (Protocols->__ptr == NULL) ||
     (Protocols->__size == 0)) {
    return NULL;
  };
  char const * const * proto = Protocols->__ptr;
  int n = Protocols->__size;
  for(;n>0;--n,++proto) {
    if(proto == NULL) continue;
    if((strcasecmp(*proto,"https") == 0) && (base_url_by_type("ssl") != NULL))
      break;
    if((strcasecmp(*proto,"httpg") == 0) && (
       (base_url_by_type("gsi") != NULL) ||
       (base_url_by_type("gssapi") != NULL) ))
      break;
    if((strcasecmp(*proto,"http") == 0) && (base_url_by_type("plain") != NULL))
      break;
  };
  if(n <= 0) return NULL;
  return *proto;
}

void get_protocols(ArrayOfstring* Protocols) {
  static char const* supported_protocols[3] = { NULL, NULL, NULL };
  int supported_protocols_size = 0;
  if(supported_protocols_size == 0) {
    int n = 0;
    if(base_url_by_type("ssl") != NULL) supported_protocols[n++]="https";
    if((base_url_by_type("gsi") != NULL) ||
       (base_url_by_type("gssapi") != NULL)) {
      supported_protocols[n++]="httpg";
    };
    if(base_url_by_type("plain") != NULL) supported_protocols[n++]="http";
    supported_protocols_size=n;
  };
  Protocols->__ptr=(char**)supported_protocols;
  Protocols->__size=supported_protocols_size;
}


std::string make_SURL(const std::string& service_url,const std::string& id) {
  std::string url = service_url + "?SFN=" + id;
  url.replace(0,5,"srm");
  return url;
}

std::string make_SURL_short(const std::string& service_url,const std::string& id) {
  std::string url = service_url;
  std::string::size_type p = url.find('/',8); // skip httpg://
  if(p == std::string::npos) {
    url+="/";
  } else {
    url.resize(p+1);
  };
  url+=id;
  url.replace(0,5,"srm");
  return url;
}

std::string make_TURL(const std::string& service_url,const std::string& id) {
  std::string url = service_url + "/" + id;
  return url;
}

