/* srm1_soapC.cpp
   Generated by gSOAP 2.7.8a from srm1_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "srm1_soapH.h"

SOAP_SOURCE_STAMP("@(#) srm1_soapC.cpp ver 2.7.8a 2009-04-06 10:52:21 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_ArrayOfboolean:
		return soap_in_ArrayOfboolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_ArrayOflong:
		return soap_in_ArrayOflong(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_ArrayOfstring:
		return soap_in_ArrayOfstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ArrayOfFileMetaData:
		return soap_in_ArrayOfFileMetaData(soap, NULL, NULL, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_SRMv1Type__FileMetaData:
		return soap_in_SRMv1Type__FileMetaData(soap, NULL, NULL, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_ArrayOfRequestFileStatus:
		return soap_in_ArrayOfRequestFileStatus(soap, NULL, NULL, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_SRMv1Type__RequestFileStatus:
		return soap_in_SRMv1Type__RequestFileStatus(soap, NULL, NULL, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_SRMv1Type__RequestStatus:
		return soap_in_SRMv1Type__RequestStatus(soap, NULL, NULL, "SRMv1Type:RequestStatus");
	case SOAP_TYPE_SRMv1Meth__getProtocols:
		return soap_in_SRMv1Meth__getProtocols(soap, NULL, NULL, "SRMv1Meth:getProtocols");
	case SOAP_TYPE_SRMv1Meth__getProtocolsResponse:
		return soap_in_SRMv1Meth__getProtocolsResponse(soap, NULL, NULL, "SRMv1Meth:getProtocolsResponse");
	case SOAP_TYPE_SRMv1Meth__advisoryDelete:
		return soap_in_SRMv1Meth__advisoryDelete(soap, NULL, NULL, "SRMv1Meth:advisoryDelete");
	case SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse:
		return soap_in_SRMv1Meth__advisoryDeleteResponse(soap, NULL, NULL, "SRMv1Meth:advisoryDeleteResponse");
	case SOAP_TYPE_SRMv1Meth__getEstPutTime:
		return soap_in_SRMv1Meth__getEstPutTime(soap, NULL, NULL, "SRMv1Meth:getEstPutTime");
	case SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse:
		return soap_in_SRMv1Meth__getEstPutTimeResponse(soap, NULL, NULL, "SRMv1Meth:getEstPutTimeResponse");
	case SOAP_TYPE_SRMv1Meth__getEstGetTime:
		return soap_in_SRMv1Meth__getEstGetTime(soap, NULL, NULL, "SRMv1Meth:getEstGetTime");
	case SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse:
		return soap_in_SRMv1Meth__getEstGetTimeResponse(soap, NULL, NULL, "SRMv1Meth:getEstGetTimeResponse");
	case SOAP_TYPE_SRMv1Meth__mkPermanent:
		return soap_in_SRMv1Meth__mkPermanent(soap, NULL, NULL, "SRMv1Meth:mkPermanent");
	case SOAP_TYPE_SRMv1Meth__mkPermanentResponse:
		return soap_in_SRMv1Meth__mkPermanentResponse(soap, NULL, NULL, "SRMv1Meth:mkPermanentResponse");
	case SOAP_TYPE_SRMv1Meth__getFileMetaData:
		return soap_in_SRMv1Meth__getFileMetaData(soap, NULL, NULL, "SRMv1Meth:getFileMetaData");
	case SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse:
		return soap_in_SRMv1Meth__getFileMetaDataResponse(soap, NULL, NULL, "SRMv1Meth:getFileMetaDataResponse");
	case SOAP_TYPE_SRMv1Meth__getRequestStatus:
		return soap_in_SRMv1Meth__getRequestStatus(soap, NULL, NULL, "SRMv1Meth:getRequestStatus");
	case SOAP_TYPE_SRMv1Meth__getRequestStatusResponse:
		return soap_in_SRMv1Meth__getRequestStatusResponse(soap, NULL, NULL, "SRMv1Meth:getRequestStatusResponse");
	case SOAP_TYPE_SRMv1Meth__setFileStatus:
		return soap_in_SRMv1Meth__setFileStatus(soap, NULL, NULL, "SRMv1Meth:setFileStatus");
	case SOAP_TYPE_SRMv1Meth__setFileStatusResponse:
		return soap_in_SRMv1Meth__setFileStatusResponse(soap, NULL, NULL, "SRMv1Meth:setFileStatusResponse");
	case SOAP_TYPE_SRMv1Meth__unPin:
		return soap_in_SRMv1Meth__unPin(soap, NULL, NULL, "SRMv1Meth:unPin");
	case SOAP_TYPE_SRMv1Meth__unPinResponse:
		return soap_in_SRMv1Meth__unPinResponse(soap, NULL, NULL, "SRMv1Meth:unPinResponse");
	case SOAP_TYPE_SRMv1Meth__pin:
		return soap_in_SRMv1Meth__pin(soap, NULL, NULL, "SRMv1Meth:pin");
	case SOAP_TYPE_SRMv1Meth__pinResponse:
		return soap_in_SRMv1Meth__pinResponse(soap, NULL, NULL, "SRMv1Meth:pinResponse");
	case SOAP_TYPE_SRMv1Meth__ping:
		return soap_in_SRMv1Meth__ping(soap, NULL, NULL, "SRMv1Meth:ping");
	case SOAP_TYPE_SRMv1Meth__pingResponse:
		return soap_in_SRMv1Meth__pingResponse(soap, NULL, NULL, "SRMv1Meth:pingResponse");
	case SOAP_TYPE_SRMv1Meth__copy:
		return soap_in_SRMv1Meth__copy(soap, NULL, NULL, "SRMv1Meth:copy");
	case SOAP_TYPE_SRMv1Meth__copyResponse:
		return soap_in_SRMv1Meth__copyResponse(soap, NULL, NULL, "SRMv1Meth:copyResponse");
	case SOAP_TYPE_SRMv1Meth__get:
		return soap_in_SRMv1Meth__get(soap, NULL, NULL, "SRMv1Meth:get");
	case SOAP_TYPE_SRMv1Meth__getResponse:
		return soap_in_SRMv1Meth__getResponse(soap, NULL, NULL, "SRMv1Meth:getResponse");
	case SOAP_TYPE_SRMv1Meth__put:
		return soap_in_SRMv1Meth__put(soap, NULL, NULL, "SRMv1Meth:put");
	case SOAP_TYPE_SRMv1Meth__putResponse:
		return soap_in_SRMv1Meth__putResponse(soap, NULL, NULL, "SRMv1Meth:putResponse");
	case SOAP_TYPE_PointerToArrayOfFileMetaData:
		return soap_in_PointerToArrayOfFileMetaData(soap, NULL, NULL, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_PointerToArrayOfboolean:
		return soap_in_PointerToArrayOfboolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerToArrayOflong:
		return soap_in_PointerToArrayOflong(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_PointerToArrayOfstring:
		return soap_in_PointerToArrayOfstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToSRMv1Type__RequestStatus:
		return soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, NULL, "SRMv1Type:RequestStatus");
	case SOAP_TYPE_PointerTobool:
		return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerToLONG64:
		return soap_in_PointerToLONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToPointerToSRMv1Type__FileMetaData:
		return soap_in_PointerToPointerToSRMv1Type__FileMetaData(soap, NULL, NULL, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_PointerToSRMv1Type__FileMetaData:
		return soap_in_PointerToSRMv1Type__FileMetaData(soap, NULL, NULL, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_PointerToPointerToSRMv1Type__RequestFileStatus:
		return soap_in_PointerToPointerToSRMv1Type__RequestFileStatus(soap, NULL, NULL, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus:
		return soap_in_PointerToSRMv1Type__RequestFileStatus(soap, NULL, NULL, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_PointerToArrayOfRequestFileStatus:
		return soap_in_PointerToArrayOfRequestFileStatus(soap, NULL, NULL, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_PointerTotime:
		return soap_in_PointerTotime(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:boolean"))
		{	*type = SOAP_TYPE_ArrayOfboolean;
			return soap_in_ArrayOfboolean(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:long"))
		{	*type = SOAP_TYPE_ArrayOflong;
			return soap_in_ArrayOflong(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOfstring;
			return soap_in_ArrayOfstring(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "SRMv1Type:FileMetaData"))
		{	*type = SOAP_TYPE_ArrayOfFileMetaData;
			return soap_in_ArrayOfFileMetaData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Type:FileMetaData"))
		{	*type = SOAP_TYPE_SRMv1Type__FileMetaData;
			return soap_in_SRMv1Type__FileMetaData(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "SRMv1Type:RequestFileStatus"))
		{	*type = SOAP_TYPE_ArrayOfRequestFileStatus;
			return soap_in_ArrayOfRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Type:RequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv1Type__RequestFileStatus;
			return soap_in_SRMv1Type__RequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Type:RequestStatus"))
		{	*type = SOAP_TYPE_SRMv1Type__RequestStatus;
			return soap_in_SRMv1Type__RequestStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getProtocols"))
		{	*type = SOAP_TYPE_SRMv1Meth__getProtocols;
			return soap_in_SRMv1Meth__getProtocols(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getProtocolsResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__getProtocolsResponse;
			return soap_in_SRMv1Meth__getProtocolsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:advisoryDelete"))
		{	*type = SOAP_TYPE_SRMv1Meth__advisoryDelete;
			return soap_in_SRMv1Meth__advisoryDelete(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:advisoryDeleteResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse;
			return soap_in_SRMv1Meth__advisoryDeleteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getEstPutTime"))
		{	*type = SOAP_TYPE_SRMv1Meth__getEstPutTime;
			return soap_in_SRMv1Meth__getEstPutTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getEstPutTimeResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse;
			return soap_in_SRMv1Meth__getEstPutTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getEstGetTime"))
		{	*type = SOAP_TYPE_SRMv1Meth__getEstGetTime;
			return soap_in_SRMv1Meth__getEstGetTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getEstGetTimeResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse;
			return soap_in_SRMv1Meth__getEstGetTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:mkPermanent"))
		{	*type = SOAP_TYPE_SRMv1Meth__mkPermanent;
			return soap_in_SRMv1Meth__mkPermanent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:mkPermanentResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__mkPermanentResponse;
			return soap_in_SRMv1Meth__mkPermanentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getFileMetaData"))
		{	*type = SOAP_TYPE_SRMv1Meth__getFileMetaData;
			return soap_in_SRMv1Meth__getFileMetaData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getFileMetaDataResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse;
			return soap_in_SRMv1Meth__getFileMetaDataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getRequestStatus"))
		{	*type = SOAP_TYPE_SRMv1Meth__getRequestStatus;
			return soap_in_SRMv1Meth__getRequestStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getRequestStatusResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__getRequestStatusResponse;
			return soap_in_SRMv1Meth__getRequestStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:setFileStatus"))
		{	*type = SOAP_TYPE_SRMv1Meth__setFileStatus;
			return soap_in_SRMv1Meth__setFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:setFileStatusResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__setFileStatusResponse;
			return soap_in_SRMv1Meth__setFileStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:unPin"))
		{	*type = SOAP_TYPE_SRMv1Meth__unPin;
			return soap_in_SRMv1Meth__unPin(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:unPinResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__unPinResponse;
			return soap_in_SRMv1Meth__unPinResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:pin"))
		{	*type = SOAP_TYPE_SRMv1Meth__pin;
			return soap_in_SRMv1Meth__pin(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:pinResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__pinResponse;
			return soap_in_SRMv1Meth__pinResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:ping"))
		{	*type = SOAP_TYPE_SRMv1Meth__ping;
			return soap_in_SRMv1Meth__ping(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:pingResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__pingResponse;
			return soap_in_SRMv1Meth__pingResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:copy"))
		{	*type = SOAP_TYPE_SRMv1Meth__copy;
			return soap_in_SRMv1Meth__copy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:copyResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__copyResponse;
			return soap_in_SRMv1Meth__copyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:get"))
		{	*type = SOAP_TYPE_SRMv1Meth__get;
			return soap_in_SRMv1Meth__get(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:getResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__getResponse;
			return soap_in_SRMv1Meth__getResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:put"))
		{	*type = SOAP_TYPE_SRMv1Meth__put;
			return soap_in_SRMv1Meth__put(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv1Meth:putResponse"))
		{	*type = SOAP_TYPE_SRMv1Meth__putResponse;
			return soap_in_SRMv1Meth__putResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "SOAP-ENC:arrayType"))
		{	char **s;
			*type = SOAP_TYPE__SOAP_ENC__arrayType;
			s = soap_in__SOAP_ENC__arrayType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_ArrayOfboolean:
		return ((ArrayOfboolean *)ptr)->soap_out(soap, tag, id, "xsd:boolean");
	case SOAP_TYPE_ArrayOflong:
		return ((ArrayOflong *)ptr)->soap_out(soap, tag, id, "xsd:long");
	case SOAP_TYPE_ArrayOfstring:
		return ((ArrayOfstring *)ptr)->soap_out(soap, tag, id, "xsd:string");
	case SOAP_TYPE_ArrayOfFileMetaData:
		return ((ArrayOfFileMetaData *)ptr)->soap_out(soap, tag, id, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_SRMv1Type__FileMetaData:
		return ((SRMv1Type__FileMetaData *)ptr)->soap_out(soap, tag, id, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_ArrayOfRequestFileStatus:
		return ((ArrayOfRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_SRMv1Type__RequestFileStatus:
		return ((SRMv1Type__RequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_SRMv1Type__RequestStatus:
		return ((SRMv1Type__RequestStatus *)ptr)->soap_out(soap, tag, id, "SRMv1Type:RequestStatus");
	case SOAP_TYPE_SRMv1Meth__getProtocols:
		return soap_out_SRMv1Meth__getProtocols(soap, tag, id, (const struct SRMv1Meth__getProtocols *)ptr, "SRMv1Meth:getProtocols");
	case SOAP_TYPE_SRMv1Meth__getProtocolsResponse:
		return soap_out_SRMv1Meth__getProtocolsResponse(soap, tag, id, (const struct SRMv1Meth__getProtocolsResponse *)ptr, "SRMv1Meth:getProtocolsResponse");
	case SOAP_TYPE_SRMv1Meth__advisoryDelete:
		return soap_out_SRMv1Meth__advisoryDelete(soap, tag, id, (const struct SRMv1Meth__advisoryDelete *)ptr, "SRMv1Meth:advisoryDelete");
	case SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse:
		return soap_out_SRMv1Meth__advisoryDeleteResponse(soap, tag, id, (const struct SRMv1Meth__advisoryDeleteResponse *)ptr, "SRMv1Meth:advisoryDeleteResponse");
	case SOAP_TYPE_SRMv1Meth__getEstPutTime:
		return soap_out_SRMv1Meth__getEstPutTime(soap, tag, id, (const struct SRMv1Meth__getEstPutTime *)ptr, "SRMv1Meth:getEstPutTime");
	case SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse:
		return soap_out_SRMv1Meth__getEstPutTimeResponse(soap, tag, id, (const struct SRMv1Meth__getEstPutTimeResponse *)ptr, "SRMv1Meth:getEstPutTimeResponse");
	case SOAP_TYPE_SRMv1Meth__getEstGetTime:
		return soap_out_SRMv1Meth__getEstGetTime(soap, tag, id, (const struct SRMv1Meth__getEstGetTime *)ptr, "SRMv1Meth:getEstGetTime");
	case SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse:
		return soap_out_SRMv1Meth__getEstGetTimeResponse(soap, tag, id, (const struct SRMv1Meth__getEstGetTimeResponse *)ptr, "SRMv1Meth:getEstGetTimeResponse");
	case SOAP_TYPE_SRMv1Meth__mkPermanent:
		return soap_out_SRMv1Meth__mkPermanent(soap, tag, id, (const struct SRMv1Meth__mkPermanent *)ptr, "SRMv1Meth:mkPermanent");
	case SOAP_TYPE_SRMv1Meth__mkPermanentResponse:
		return soap_out_SRMv1Meth__mkPermanentResponse(soap, tag, id, (const struct SRMv1Meth__mkPermanentResponse *)ptr, "SRMv1Meth:mkPermanentResponse");
	case SOAP_TYPE_SRMv1Meth__getFileMetaData:
		return soap_out_SRMv1Meth__getFileMetaData(soap, tag, id, (const struct SRMv1Meth__getFileMetaData *)ptr, "SRMv1Meth:getFileMetaData");
	case SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse:
		return soap_out_SRMv1Meth__getFileMetaDataResponse(soap, tag, id, (const struct SRMv1Meth__getFileMetaDataResponse *)ptr, "SRMv1Meth:getFileMetaDataResponse");
	case SOAP_TYPE_SRMv1Meth__getRequestStatus:
		return soap_out_SRMv1Meth__getRequestStatus(soap, tag, id, (const struct SRMv1Meth__getRequestStatus *)ptr, "SRMv1Meth:getRequestStatus");
	case SOAP_TYPE_SRMv1Meth__getRequestStatusResponse:
		return soap_out_SRMv1Meth__getRequestStatusResponse(soap, tag, id, (const struct SRMv1Meth__getRequestStatusResponse *)ptr, "SRMv1Meth:getRequestStatusResponse");
	case SOAP_TYPE_SRMv1Meth__setFileStatus:
		return soap_out_SRMv1Meth__setFileStatus(soap, tag, id, (const struct SRMv1Meth__setFileStatus *)ptr, "SRMv1Meth:setFileStatus");
	case SOAP_TYPE_SRMv1Meth__setFileStatusResponse:
		return soap_out_SRMv1Meth__setFileStatusResponse(soap, tag, id, (const struct SRMv1Meth__setFileStatusResponse *)ptr, "SRMv1Meth:setFileStatusResponse");
	case SOAP_TYPE_SRMv1Meth__unPin:
		return soap_out_SRMv1Meth__unPin(soap, tag, id, (const struct SRMv1Meth__unPin *)ptr, "SRMv1Meth:unPin");
	case SOAP_TYPE_SRMv1Meth__unPinResponse:
		return soap_out_SRMv1Meth__unPinResponse(soap, tag, id, (const struct SRMv1Meth__unPinResponse *)ptr, "SRMv1Meth:unPinResponse");
	case SOAP_TYPE_SRMv1Meth__pin:
		return soap_out_SRMv1Meth__pin(soap, tag, id, (const struct SRMv1Meth__pin *)ptr, "SRMv1Meth:pin");
	case SOAP_TYPE_SRMv1Meth__pinResponse:
		return soap_out_SRMv1Meth__pinResponse(soap, tag, id, (const struct SRMv1Meth__pinResponse *)ptr, "SRMv1Meth:pinResponse");
	case SOAP_TYPE_SRMv1Meth__ping:
		return soap_out_SRMv1Meth__ping(soap, tag, id, (const struct SRMv1Meth__ping *)ptr, "SRMv1Meth:ping");
	case SOAP_TYPE_SRMv1Meth__pingResponse:
		return soap_out_SRMv1Meth__pingResponse(soap, tag, id, (const struct SRMv1Meth__pingResponse *)ptr, "SRMv1Meth:pingResponse");
	case SOAP_TYPE_SRMv1Meth__copy:
		return soap_out_SRMv1Meth__copy(soap, tag, id, (const struct SRMv1Meth__copy *)ptr, "SRMv1Meth:copy");
	case SOAP_TYPE_SRMv1Meth__copyResponse:
		return soap_out_SRMv1Meth__copyResponse(soap, tag, id, (const struct SRMv1Meth__copyResponse *)ptr, "SRMv1Meth:copyResponse");
	case SOAP_TYPE_SRMv1Meth__get:
		return soap_out_SRMv1Meth__get(soap, tag, id, (const struct SRMv1Meth__get *)ptr, "SRMv1Meth:get");
	case SOAP_TYPE_SRMv1Meth__getResponse:
		return soap_out_SRMv1Meth__getResponse(soap, tag, id, (const struct SRMv1Meth__getResponse *)ptr, "SRMv1Meth:getResponse");
	case SOAP_TYPE_SRMv1Meth__put:
		return soap_out_SRMv1Meth__put(soap, tag, id, (const struct SRMv1Meth__put *)ptr, "SRMv1Meth:put");
	case SOAP_TYPE_SRMv1Meth__putResponse:
		return soap_out_SRMv1Meth__putResponse(soap, tag, id, (const struct SRMv1Meth__putResponse *)ptr, "SRMv1Meth:putResponse");
	case SOAP_TYPE_PointerToArrayOfFileMetaData:
		return soap_out_PointerToArrayOfFileMetaData(soap, tag, id, (ArrayOfFileMetaData *const*)ptr, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_PointerToArrayOfboolean:
		return soap_out_PointerToArrayOfboolean(soap, tag, id, (ArrayOfboolean *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerToArrayOflong:
		return soap_out_PointerToArrayOflong(soap, tag, id, (ArrayOflong *const*)ptr, "xsd:long");
	case SOAP_TYPE_PointerToArrayOfstring:
		return soap_out_PointerToArrayOfstring(soap, tag, id, (ArrayOfstring *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToSRMv1Type__RequestStatus:
		return soap_out_PointerToSRMv1Type__RequestStatus(soap, tag, id, (SRMv1Type__RequestStatus *const*)ptr, "SRMv1Type:RequestStatus");
	case SOAP_TYPE_PointerTobool:
		return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerToLONG64:
		return soap_out_PointerToLONG64(soap, tag, id, (LONG64 *const*)ptr, "xsd:long");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToPointerToSRMv1Type__FileMetaData:
		return soap_out_PointerToPointerToSRMv1Type__FileMetaData(soap, tag, id, (SRMv1Type__FileMetaData **const*)ptr, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_PointerToSRMv1Type__FileMetaData:
		return soap_out_PointerToSRMv1Type__FileMetaData(soap, tag, id, (SRMv1Type__FileMetaData *const*)ptr, "SRMv1Type:FileMetaData");
	case SOAP_TYPE_PointerToPointerToSRMv1Type__RequestFileStatus:
		return soap_out_PointerToPointerToSRMv1Type__RequestFileStatus(soap, tag, id, (SRMv1Type__RequestFileStatus **const*)ptr, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus:
		return soap_out_PointerToSRMv1Type__RequestFileStatus(soap, tag, id, (SRMv1Type__RequestFileStatus *const*)ptr, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_PointerToArrayOfRequestFileStatus:
		return soap_out_PointerToArrayOfRequestFileStatus(soap, tag, id, (ArrayOfRequestFileStatus *const*)ptr, "SRMv1Type:RequestFileStatus");
	case SOAP_TYPE_PointerTotime:
		return soap_out_PointerTotime(soap, tag, id, (time_t *const*)ptr, "xsd:dateTime");
	case SOAP_TYPE__SOAP_ENC__arrayType:
		return soap_out_string(soap, "SOAP-ENC:arrayType", id, (char**)&ptr, NULL);
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ArrayOfboolean:
		((ArrayOfboolean *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOflong:
		((ArrayOflong *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOfstring:
		((ArrayOfstring *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOfFileMetaData:
		((ArrayOfFileMetaData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv1Type__FileMetaData:
		((SRMv1Type__FileMetaData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOfRequestFileStatus:
		((ArrayOfRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv1Type__RequestFileStatus:
		((SRMv1Type__RequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv1Type__RequestStatus:
		((SRMv1Type__RequestStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv1Meth__getProtocols:
		soap_serialize_SRMv1Meth__getProtocols(soap, (const struct SRMv1Meth__getProtocols *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getProtocolsResponse:
		soap_serialize_SRMv1Meth__getProtocolsResponse(soap, (const struct SRMv1Meth__getProtocolsResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__advisoryDelete:
		soap_serialize_SRMv1Meth__advisoryDelete(soap, (const struct SRMv1Meth__advisoryDelete *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse:
		soap_serialize_SRMv1Meth__advisoryDeleteResponse(soap, (const struct SRMv1Meth__advisoryDeleteResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getEstPutTime:
		soap_serialize_SRMv1Meth__getEstPutTime(soap, (const struct SRMv1Meth__getEstPutTime *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse:
		soap_serialize_SRMv1Meth__getEstPutTimeResponse(soap, (const struct SRMv1Meth__getEstPutTimeResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getEstGetTime:
		soap_serialize_SRMv1Meth__getEstGetTime(soap, (const struct SRMv1Meth__getEstGetTime *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse:
		soap_serialize_SRMv1Meth__getEstGetTimeResponse(soap, (const struct SRMv1Meth__getEstGetTimeResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__mkPermanent:
		soap_serialize_SRMv1Meth__mkPermanent(soap, (const struct SRMv1Meth__mkPermanent *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__mkPermanentResponse:
		soap_serialize_SRMv1Meth__mkPermanentResponse(soap, (const struct SRMv1Meth__mkPermanentResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getFileMetaData:
		soap_serialize_SRMv1Meth__getFileMetaData(soap, (const struct SRMv1Meth__getFileMetaData *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse:
		soap_serialize_SRMv1Meth__getFileMetaDataResponse(soap, (const struct SRMv1Meth__getFileMetaDataResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getRequestStatus:
		soap_serialize_SRMv1Meth__getRequestStatus(soap, (const struct SRMv1Meth__getRequestStatus *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getRequestStatusResponse:
		soap_serialize_SRMv1Meth__getRequestStatusResponse(soap, (const struct SRMv1Meth__getRequestStatusResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__setFileStatus:
		soap_serialize_SRMv1Meth__setFileStatus(soap, (const struct SRMv1Meth__setFileStatus *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__setFileStatusResponse:
		soap_serialize_SRMv1Meth__setFileStatusResponse(soap, (const struct SRMv1Meth__setFileStatusResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__unPin:
		soap_serialize_SRMv1Meth__unPin(soap, (const struct SRMv1Meth__unPin *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__unPinResponse:
		soap_serialize_SRMv1Meth__unPinResponse(soap, (const struct SRMv1Meth__unPinResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__pin:
		soap_serialize_SRMv1Meth__pin(soap, (const struct SRMv1Meth__pin *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__pinResponse:
		soap_serialize_SRMv1Meth__pinResponse(soap, (const struct SRMv1Meth__pinResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__ping:
		soap_serialize_SRMv1Meth__ping(soap, (const struct SRMv1Meth__ping *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__pingResponse:
		soap_serialize_SRMv1Meth__pingResponse(soap, (const struct SRMv1Meth__pingResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__copy:
		soap_serialize_SRMv1Meth__copy(soap, (const struct SRMv1Meth__copy *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__copyResponse:
		soap_serialize_SRMv1Meth__copyResponse(soap, (const struct SRMv1Meth__copyResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__get:
		soap_serialize_SRMv1Meth__get(soap, (const struct SRMv1Meth__get *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__getResponse:
		soap_serialize_SRMv1Meth__getResponse(soap, (const struct SRMv1Meth__getResponse *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__put:
		soap_serialize_SRMv1Meth__put(soap, (const struct SRMv1Meth__put *)ptr);
		break;
	case SOAP_TYPE_SRMv1Meth__putResponse:
		soap_serialize_SRMv1Meth__putResponse(soap, (const struct SRMv1Meth__putResponse *)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOfFileMetaData:
		soap_serialize_PointerToArrayOfFileMetaData(soap, (ArrayOfFileMetaData *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOfboolean:
		soap_serialize_PointerToArrayOfboolean(soap, (ArrayOfboolean *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOflong:
		soap_serialize_PointerToArrayOflong(soap, (ArrayOflong *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOfstring:
		soap_serialize_PointerToArrayOfstring(soap, (ArrayOfstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv1Type__RequestStatus:
		soap_serialize_PointerToSRMv1Type__RequestStatus(soap, (SRMv1Type__RequestStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTobool:
		soap_serialize_PointerTobool(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerToLONG64:
		soap_serialize_PointerToLONG64(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv1Type__FileMetaData:
		soap_serialize_PointerToPointerToSRMv1Type__FileMetaData(soap, (SRMv1Type__FileMetaData **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv1Type__FileMetaData:
		soap_serialize_PointerToSRMv1Type__FileMetaData(soap, (SRMv1Type__FileMetaData *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv1Type__RequestFileStatus:
		soap_serialize_PointerToPointerToSRMv1Type__RequestFileStatus(soap, (SRMv1Type__RequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus:
		soap_serialize_PointerToSRMv1Type__RequestFileStatus(soap, (SRMv1Type__RequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOfRequestFileStatus:
		soap_serialize_PointerToArrayOfRequestFileStatus(soap, (ArrayOfRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotime:
		soap_serialize_PointerTotime(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE__SOAP_ENC__arrayType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_SRMv1Type__RequestStatus:
		return (void*)soap_instantiate_SRMv1Type__RequestStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Type__FileMetaData:
		return (void*)soap_instantiate_SRMv1Type__FileMetaData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Type__RequestFileStatus:
		return (void*)soap_instantiate_SRMv1Type__RequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfRequestFileStatus:
		return (void*)soap_instantiate_ArrayOfRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfFileMetaData:
		return (void*)soap_instantiate_ArrayOfFileMetaData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfstring:
		return (void*)soap_instantiate_ArrayOfstring(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOflong:
		return (void*)soap_instantiate_ArrayOflong(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfboolean:
		return (void*)soap_instantiate_ArrayOfboolean(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__putResponse:
		return (void*)soap_instantiate_SRMv1Meth__putResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__put:
		return (void*)soap_instantiate_SRMv1Meth__put(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getResponse:
		return (void*)soap_instantiate_SRMv1Meth__getResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__get:
		return (void*)soap_instantiate_SRMv1Meth__get(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__copyResponse:
		return (void*)soap_instantiate_SRMv1Meth__copyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__copy:
		return (void*)soap_instantiate_SRMv1Meth__copy(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__pingResponse:
		return (void*)soap_instantiate_SRMv1Meth__pingResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__ping:
		return (void*)soap_instantiate_SRMv1Meth__ping(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__pinResponse:
		return (void*)soap_instantiate_SRMv1Meth__pinResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__pin:
		return (void*)soap_instantiate_SRMv1Meth__pin(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__unPinResponse:
		return (void*)soap_instantiate_SRMv1Meth__unPinResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__unPin:
		return (void*)soap_instantiate_SRMv1Meth__unPin(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__setFileStatusResponse:
		return (void*)soap_instantiate_SRMv1Meth__setFileStatusResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__setFileStatus:
		return (void*)soap_instantiate_SRMv1Meth__setFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getRequestStatusResponse:
		return (void*)soap_instantiate_SRMv1Meth__getRequestStatusResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getRequestStatus:
		return (void*)soap_instantiate_SRMv1Meth__getRequestStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse:
		return (void*)soap_instantiate_SRMv1Meth__getFileMetaDataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getFileMetaData:
		return (void*)soap_instantiate_SRMv1Meth__getFileMetaData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__mkPermanentResponse:
		return (void*)soap_instantiate_SRMv1Meth__mkPermanentResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__mkPermanent:
		return (void*)soap_instantiate_SRMv1Meth__mkPermanent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse:
		return (void*)soap_instantiate_SRMv1Meth__getEstGetTimeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getEstGetTime:
		return (void*)soap_instantiate_SRMv1Meth__getEstGetTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse:
		return (void*)soap_instantiate_SRMv1Meth__getEstPutTimeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getEstPutTime:
		return (void*)soap_instantiate_SRMv1Meth__getEstPutTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse:
		return (void*)soap_instantiate_SRMv1Meth__advisoryDeleteResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__advisoryDelete:
		return (void*)soap_instantiate_SRMv1Meth__advisoryDelete(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getProtocolsResponse:
		return (void*)soap_instantiate_SRMv1Meth__getProtocolsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv1Meth__getProtocols:
		return (void*)soap_instantiate_SRMv1Meth__getProtocols(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_SRMv1Type__RequestStatus:
		if (p->size < 0)
			delete (SRMv1Type__RequestStatus*)p->ptr;
		else
			delete[] (SRMv1Type__RequestStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Type__FileMetaData:
		if (p->size < 0)
			delete (SRMv1Type__FileMetaData*)p->ptr;
		else
			delete[] (SRMv1Type__FileMetaData*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Type__RequestFileStatus:
		if (p->size < 0)
			delete (SRMv1Type__RequestFileStatus*)p->ptr;
		else
			delete[] (SRMv1Type__RequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfRequestFileStatus:
		if (p->size < 0)
			delete (ArrayOfRequestFileStatus*)p->ptr;
		else
			delete[] (ArrayOfRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfFileMetaData:
		if (p->size < 0)
			delete (ArrayOfFileMetaData*)p->ptr;
		else
			delete[] (ArrayOfFileMetaData*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfstring:
		if (p->size < 0)
			delete (ArrayOfstring*)p->ptr;
		else
			delete[] (ArrayOfstring*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOflong:
		if (p->size < 0)
			delete (ArrayOflong*)p->ptr;
		else
			delete[] (ArrayOflong*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfboolean:
		if (p->size < 0)
			delete (ArrayOfboolean*)p->ptr;
		else
			delete[] (ArrayOfboolean*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__putResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__putResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__putResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__put:
		if (p->size < 0)
			delete (struct SRMv1Meth__put*)p->ptr;
		else
			delete[] (struct SRMv1Meth__put*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__getResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__get:
		if (p->size < 0)
			delete (struct SRMv1Meth__get*)p->ptr;
		else
			delete[] (struct SRMv1Meth__get*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__copyResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__copyResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__copyResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__copy:
		if (p->size < 0)
			delete (struct SRMv1Meth__copy*)p->ptr;
		else
			delete[] (struct SRMv1Meth__copy*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__pingResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__pingResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__pingResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__ping:
		if (p->size < 0)
			delete (struct SRMv1Meth__ping*)p->ptr;
		else
			delete[] (struct SRMv1Meth__ping*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__pinResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__pinResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__pinResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__pin:
		if (p->size < 0)
			delete (struct SRMv1Meth__pin*)p->ptr;
		else
			delete[] (struct SRMv1Meth__pin*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__unPinResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__unPinResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__unPinResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__unPin:
		if (p->size < 0)
			delete (struct SRMv1Meth__unPin*)p->ptr;
		else
			delete[] (struct SRMv1Meth__unPin*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__setFileStatusResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__setFileStatusResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__setFileStatusResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__setFileStatus:
		if (p->size < 0)
			delete (struct SRMv1Meth__setFileStatus*)p->ptr;
		else
			delete[] (struct SRMv1Meth__setFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getRequestStatusResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__getRequestStatusResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getRequestStatusResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getRequestStatus:
		if (p->size < 0)
			delete (struct SRMv1Meth__getRequestStatus*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getRequestStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__getFileMetaDataResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getFileMetaDataResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getFileMetaData:
		if (p->size < 0)
			delete (struct SRMv1Meth__getFileMetaData*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getFileMetaData*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__mkPermanentResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__mkPermanentResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__mkPermanentResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__mkPermanent:
		if (p->size < 0)
			delete (struct SRMv1Meth__mkPermanent*)p->ptr;
		else
			delete[] (struct SRMv1Meth__mkPermanent*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__getEstGetTimeResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getEstGetTimeResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getEstGetTime:
		if (p->size < 0)
			delete (struct SRMv1Meth__getEstGetTime*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getEstGetTime*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__getEstPutTimeResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getEstPutTimeResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getEstPutTime:
		if (p->size < 0)
			delete (struct SRMv1Meth__getEstPutTime*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getEstPutTime*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__advisoryDeleteResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__advisoryDeleteResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__advisoryDelete:
		if (p->size < 0)
			delete (struct SRMv1Meth__advisoryDelete*)p->ptr;
		else
			delete[] (struct SRMv1Meth__advisoryDelete*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getProtocolsResponse:
		if (p->size < 0)
			delete (struct SRMv1Meth__getProtocolsResponse*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getProtocolsResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv1Meth__getProtocols:
		if (p->size < 0)
			delete (struct SRMv1Meth__getProtocols*)p->ptr;
		else
			delete[] (struct SRMv1Meth__getProtocols*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_code_str(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

void ArrayOfboolean::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOfboolean))
		for (int i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE_bool);
		}
}

void ArrayOfboolean::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOfboolean::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOfboolean);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOfboolean::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOfboolean(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfboolean(struct soap *soap, const char *tag, int id, const ArrayOfboolean *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:boolean", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfboolean);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_bool(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOfboolean::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOfboolean(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOfboolean * SOAP_FMAC4 soap_get_ArrayOfboolean(struct soap *soap, ArrayOfboolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfboolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOfboolean::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOfboolean(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOfboolean * SOAP_FMAC4 soap_in_ArrayOfboolean(struct soap *soap, const char *tag, ArrayOfboolean *a, const char *type)
{	int i, j;
	bool *p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOfboolean *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfboolean, sizeof(ArrayOfboolean), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (bool *)soap_malloc(soap, sizeof(bool) * a->__size);
			for (i = 0; i < a->__size; i++)
				soap_default_bool(soap, a->__ptr+i);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_bool(soap, NULL, a->__ptr + i, "xsd:boolean"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (bool *)soap_push_block(soap, sizeof(bool));
				if (!p)
					return NULL;
				soap_default_bool(soap, p);
				if (!soap_in_bool(soap, NULL, p, "xsd:boolean"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (bool *)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOfboolean *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOfboolean, 0, sizeof(ArrayOfboolean), 0, soap_copy_ArrayOfboolean);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOfboolean * SOAP_FMAC6 soap_new_ArrayOfboolean(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfboolean(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfboolean(struct soap *soap, ArrayOfboolean *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOfboolean * SOAP_FMAC4 soap_instantiate_ArrayOfboolean(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfboolean(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfboolean, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOfboolean;
		if (size)
			*size = sizeof(ArrayOfboolean);
		((ArrayOfboolean*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOfboolean[n];
		if (size)
			*size = n * sizeof(ArrayOfboolean);
		for (int i = 0; i < n; i++)
			((ArrayOfboolean*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOfboolean*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfboolean(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOfboolean %p -> %p\n", q, p));
	*(ArrayOfboolean*)p = *(ArrayOfboolean*)q;
}

void ArrayOflong::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOflong))
		for (int i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE_LONG64);
		}
}

void ArrayOflong::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOflong::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOflong);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOflong::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOflong(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOflong(struct soap *soap, const char *tag, int id, const ArrayOflong *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:long", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOflong);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_LONG64(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOflong::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOflong(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOflong * SOAP_FMAC4 soap_get_ArrayOflong(struct soap *soap, ArrayOflong *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOflong(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOflong::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOflong(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOflong * SOAP_FMAC4 soap_in_ArrayOflong(struct soap *soap, const char *tag, ArrayOflong *a, const char *type)
{	int i, j;
	LONG64 *p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOflong *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOflong, sizeof(ArrayOflong), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (LONG64 *)soap_malloc(soap, sizeof(LONG64) * a->__size);
			for (i = 0; i < a->__size; i++)
				soap_default_LONG64(soap, a->__ptr+i);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_LONG64(soap, NULL, a->__ptr + i, "xsd:long"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (LONG64 *)soap_push_block(soap, sizeof(LONG64));
				if (!p)
					return NULL;
				soap_default_LONG64(soap, p);
				if (!soap_in_LONG64(soap, NULL, p, "xsd:long"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (LONG64 *)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOflong *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOflong, 0, sizeof(ArrayOflong), 0, soap_copy_ArrayOflong);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOflong * SOAP_FMAC6 soap_new_ArrayOflong(struct soap *soap, int n)
{	return soap_instantiate_ArrayOflong(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOflong(struct soap *soap, ArrayOflong *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOflong * SOAP_FMAC4 soap_instantiate_ArrayOflong(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOflong(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOflong, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOflong;
		if (size)
			*size = sizeof(ArrayOflong);
		((ArrayOflong*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOflong[n];
		if (size)
			*size = n * sizeof(ArrayOflong);
		for (int i = 0; i < n; i++)
			((ArrayOflong*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOflong*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOflong(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOflong %p -> %p\n", q, p));
	*(ArrayOflong*)p = *(ArrayOflong*)q;
}

void ArrayOfstring::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOfstring))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_string(soap, this->__ptr + i);
		}
}

void ArrayOfstring::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOfstring::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOfstring);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOfstring::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOfstring(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfstring(struct soap *soap, const char *tag, int id, const ArrayOfstring *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:string", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfstring);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOfstring::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOfstring(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOfstring * SOAP_FMAC4 soap_get_ArrayOfstring(struct soap *soap, ArrayOfstring *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfstring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOfstring::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOfstring(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOfstring * SOAP_FMAC4 soap_in_ArrayOfstring(struct soap *soap, const char *tag, ArrayOfstring *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOfstring *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfstring, sizeof(ArrayOfstring), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOfstring *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOfstring, 0, sizeof(ArrayOfstring), 0, soap_copy_ArrayOfstring);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOfstring * SOAP_FMAC6 soap_new_ArrayOfstring(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfstring(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfstring(struct soap *soap, ArrayOfstring *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOfstring * SOAP_FMAC4 soap_instantiate_ArrayOfstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfstring, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOfstring;
		if (size)
			*size = sizeof(ArrayOfstring);
		((ArrayOfstring*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOfstring[n];
		if (size)
			*size = n * sizeof(ArrayOfstring);
		for (int i = 0; i < n; i++)
			((ArrayOfstring*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOfstring*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOfstring %p -> %p\n", q, p));
	*(ArrayOfstring*)p = *(ArrayOfstring*)q;
}

void ArrayOfFileMetaData::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOfFileMetaData))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToSRMv1Type__FileMetaData(soap, this->__ptr + i);
		}
}

void ArrayOfFileMetaData::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOfFileMetaData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOfFileMetaData);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOfFileMetaData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOfFileMetaData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfFileMetaData(struct soap *soap, const char *tag, int id, const ArrayOfFileMetaData *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "SRMv1Type:FileMetaData", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfFileMetaData);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToSRMv1Type__FileMetaData(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOfFileMetaData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOfFileMetaData(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOfFileMetaData * SOAP_FMAC4 soap_get_ArrayOfFileMetaData(struct soap *soap, ArrayOfFileMetaData *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfFileMetaData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOfFileMetaData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOfFileMetaData(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOfFileMetaData * SOAP_FMAC4 soap_in_ArrayOfFileMetaData(struct soap *soap, const char *tag, ArrayOfFileMetaData *a, const char *type)
{	int i, j;
	SRMv1Type__FileMetaData **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOfFileMetaData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfFileMetaData, sizeof(ArrayOfFileMetaData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (SRMv1Type__FileMetaData **)soap_malloc(soap, sizeof(SRMv1Type__FileMetaData *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToSRMv1Type__FileMetaData(soap, NULL, a->__ptr + i, "SRMv1Type:FileMetaData"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (SRMv1Type__FileMetaData **)soap_push_block(soap, sizeof(SRMv1Type__FileMetaData *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToSRMv1Type__FileMetaData(soap, NULL, p, "SRMv1Type:FileMetaData"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (SRMv1Type__FileMetaData **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOfFileMetaData *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOfFileMetaData, 0, sizeof(ArrayOfFileMetaData), 0, soap_copy_ArrayOfFileMetaData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOfFileMetaData * SOAP_FMAC6 soap_new_ArrayOfFileMetaData(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfFileMetaData(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfFileMetaData(struct soap *soap, ArrayOfFileMetaData *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOfFileMetaData * SOAP_FMAC4 soap_instantiate_ArrayOfFileMetaData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfFileMetaData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfFileMetaData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOfFileMetaData;
		if (size)
			*size = sizeof(ArrayOfFileMetaData);
		((ArrayOfFileMetaData*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOfFileMetaData[n];
		if (size)
			*size = n * sizeof(ArrayOfFileMetaData);
		for (int i = 0; i < n; i++)
			((ArrayOfFileMetaData*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOfFileMetaData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfFileMetaData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOfFileMetaData %p -> %p\n", q, p));
	*(ArrayOfFileMetaData*)p = *(ArrayOfFileMetaData*)q;
}

void SRMv1Type__FileMetaData::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->SURL);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->size, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->owner);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->group);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumType);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumValue);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->isPinned, SOAP_TYPE_bool);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->isPermanent, SOAP_TYPE_bool);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->isCached, SOAP_TYPE_bool);
	/* transient soap skipped */
}

void SRMv1Type__FileMetaData::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->SURL);
	soap_default_LONG64(soap, &((SRMv1Type__FileMetaData*)this)->size);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->owner);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->group);
	soap_default_int(soap, &((SRMv1Type__FileMetaData*)this)->permMode);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumType);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumValue);
	soap_default_bool(soap, &((SRMv1Type__FileMetaData*)this)->isPinned);
	soap_default_bool(soap, &((SRMv1Type__FileMetaData*)this)->isPermanent);
	soap_default_bool(soap, &((SRMv1Type__FileMetaData*)this)->isCached);
	/* transient soap skipped */
}

int SRMv1Type__FileMetaData::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv1Type__FileMetaData);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv1Type__FileMetaData::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv1Type__FileMetaData(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Type__FileMetaData(struct soap *soap, const char *tag, int id, const SRMv1Type__FileMetaData *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Type__FileMetaData), type);
	soap_out_string(soap, "SURL", -1, &(((SRMv1Type__FileMetaData*)a)->SURL), "");
	soap_out_LONG64(soap, "size", -1, &(((SRMv1Type__FileMetaData*)a)->size), "");
	soap_out_string(soap, "owner", -1, &(((SRMv1Type__FileMetaData*)a)->owner), "");
	soap_out_string(soap, "group", -1, &(((SRMv1Type__FileMetaData*)a)->group), "");
	soap_out_int(soap, "permMode", -1, &(((SRMv1Type__FileMetaData*)a)->permMode), "");
	soap_out_string(soap, "checksumType", -1, &(((SRMv1Type__FileMetaData*)a)->checksumType), "");
	soap_out_string(soap, "checksumValue", -1, &(((SRMv1Type__FileMetaData*)a)->checksumValue), "");
	soap_out_bool(soap, "isPinned", -1, &(((SRMv1Type__FileMetaData*)a)->isPinned), "");
	soap_out_bool(soap, "isPermanent", -1, &(((SRMv1Type__FileMetaData*)a)->isPermanent), "");
	soap_out_bool(soap, "isCached", -1, &(((SRMv1Type__FileMetaData*)a)->isCached), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv1Type__FileMetaData::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv1Type__FileMetaData(soap, this, tag, type);
}

SOAP_FMAC3 SRMv1Type__FileMetaData * SOAP_FMAC4 soap_get_SRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Type__FileMetaData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv1Type__FileMetaData::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv1Type__FileMetaData(soap, tag, this, type);
}

SOAP_FMAC3 SRMv1Type__FileMetaData * SOAP_FMAC4 soap_in_SRMv1Type__FileMetaData(struct soap *soap, const char *tag, SRMv1Type__FileMetaData *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv1Type__FileMetaData *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Type__FileMetaData, sizeof(SRMv1Type__FileMetaData), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv1Type__FileMetaData)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv1Type__FileMetaData *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SURL1 = 1, soap_flag_size1 = 1, soap_flag_owner1 = 1, soap_flag_group1 = 1, soap_flag_permMode1 = 1, soap_flag_checksumType1 = 1, soap_flag_checksumValue1 = 1, soap_flag_isPinned1 = 1, soap_flag_isPermanent1 = 1, soap_flag_isCached1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SURL", &(((SRMv1Type__FileMetaData*)a)->SURL), "xsd:string"))
				{	soap_flag_SURL1--;
					continue;
				}
			if (soap_flag_size1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "size", &(((SRMv1Type__FileMetaData*)a)->size), "xsd:long"))
				{	soap_flag_size1--;
					continue;
				}
			if (soap_flag_owner1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "owner", &(((SRMv1Type__FileMetaData*)a)->owner), "xsd:string"))
				{	soap_flag_owner1--;
					continue;
				}
			if (soap_flag_group1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "group", &(((SRMv1Type__FileMetaData*)a)->group), "xsd:string"))
				{	soap_flag_group1--;
					continue;
				}
			if (soap_flag_permMode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "permMode", &(((SRMv1Type__FileMetaData*)a)->permMode), "xsd:int"))
				{	soap_flag_permMode1--;
					continue;
				}
			if (soap_flag_checksumType1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "checksumType", &(((SRMv1Type__FileMetaData*)a)->checksumType), "xsd:string"))
				{	soap_flag_checksumType1--;
					continue;
				}
			if (soap_flag_checksumValue1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "checksumValue", &(((SRMv1Type__FileMetaData*)a)->checksumValue), "xsd:string"))
				{	soap_flag_checksumValue1--;
					continue;
				}
			if (soap_flag_isPinned1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isPinned", &(((SRMv1Type__FileMetaData*)a)->isPinned), "xsd:boolean"))
				{	soap_flag_isPinned1--;
					continue;
				}
			if (soap_flag_isPermanent1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isPermanent", &(((SRMv1Type__FileMetaData*)a)->isPermanent), "xsd:boolean"))
				{	soap_flag_isPermanent1--;
					continue;
				}
			if (soap_flag_isCached1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isCached", &(((SRMv1Type__FileMetaData*)a)->isCached), "xsd:boolean"))
				{	soap_flag_isCached1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_size1 > 0 || soap_flag_permMode1 > 0 || soap_flag_isPinned1 > 0 || soap_flag_isPermanent1 > 0 || soap_flag_isCached1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv1Type__FileMetaData *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Type__FileMetaData, 0, sizeof(SRMv1Type__FileMetaData), 0, soap_copy_SRMv1Type__FileMetaData);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv1Type__FileMetaData * SOAP_FMAC6 soap_new_SRMv1Type__FileMetaData(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Type__FileMetaData(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv1Type__FileMetaData * SOAP_FMAC4 soap_instantiate_SRMv1Type__FileMetaData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Type__FileMetaData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Type__FileMetaData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "SRMv1Type:RequestFileStatus"))
	{	cp->type = SOAP_TYPE_SRMv1Type__RequestFileStatus;
		if (n < 0)
		{	cp->ptr = (void*)new SRMv1Type__RequestFileStatus;
			if (size)
				*size = sizeof(SRMv1Type__RequestFileStatus);
			((SRMv1Type__RequestFileStatus*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new SRMv1Type__RequestFileStatus[n];
			if (size)
				*size = n * sizeof(SRMv1Type__RequestFileStatus);
			for (int i = 0; i < n; i++)
				((SRMv1Type__RequestFileStatus*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (SRMv1Type__RequestFileStatus*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new SRMv1Type__FileMetaData;
		if (size)
			*size = sizeof(SRMv1Type__FileMetaData);
		((SRMv1Type__FileMetaData*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv1Type__FileMetaData[n];
		if (size)
			*size = n * sizeof(SRMv1Type__FileMetaData);
		for (int i = 0; i < n; i++)
			((SRMv1Type__FileMetaData*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv1Type__FileMetaData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Type__FileMetaData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv1Type__FileMetaData %p -> %p\n", q, p));
	*(SRMv1Type__FileMetaData*)p = *(SRMv1Type__FileMetaData*)q;
}

void ArrayOfRequestFileStatus::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOfRequestFileStatus))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToSRMv1Type__RequestFileStatus(soap, this->__ptr + i);
		}
}

void ArrayOfRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOfRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOfRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOfRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOfRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfRequestFileStatus(struct soap *soap, const char *tag, int id, const ArrayOfRequestFileStatus *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "SRMv1Type:RequestFileStatus", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfRequestFileStatus);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToSRMv1Type__RequestFileStatus(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOfRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOfRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOfRequestFileStatus * SOAP_FMAC4 soap_get_ArrayOfRequestFileStatus(struct soap *soap, ArrayOfRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOfRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOfRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOfRequestFileStatus * SOAP_FMAC4 soap_in_ArrayOfRequestFileStatus(struct soap *soap, const char *tag, ArrayOfRequestFileStatus *a, const char *type)
{	int i, j;
	SRMv1Type__RequestFileStatus **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOfRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfRequestFileStatus, sizeof(ArrayOfRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (SRMv1Type__RequestFileStatus **)soap_malloc(soap, sizeof(SRMv1Type__RequestFileStatus *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToSRMv1Type__RequestFileStatus(soap, NULL, a->__ptr + i, "SRMv1Type:RequestFileStatus"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (SRMv1Type__RequestFileStatus **)soap_push_block(soap, sizeof(SRMv1Type__RequestFileStatus *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToSRMv1Type__RequestFileStatus(soap, NULL, p, "SRMv1Type:RequestFileStatus"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (SRMv1Type__RequestFileStatus **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOfRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOfRequestFileStatus, 0, sizeof(ArrayOfRequestFileStatus), 0, soap_copy_ArrayOfRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOfRequestFileStatus * SOAP_FMAC6 soap_new_ArrayOfRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfRequestFileStatus(struct soap *soap, ArrayOfRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOfRequestFileStatus * SOAP_FMAC4 soap_instantiate_ArrayOfRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOfRequestFileStatus;
		if (size)
			*size = sizeof(ArrayOfRequestFileStatus);
		((ArrayOfRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOfRequestFileStatus[n];
		if (size)
			*size = n * sizeof(ArrayOfRequestFileStatus);
		for (int i = 0; i < n; i++)
			((ArrayOfRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOfRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOfRequestFileStatus %p -> %p\n", q, p));
	*(ArrayOfRequestFileStatus*)p = *(ArrayOfRequestFileStatus*)q;
}

void SRMv1Type__RequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv1Type__RequestFileStatus*)this)->state);
	soap_serialize_string(soap, &((SRMv1Type__RequestFileStatus*)this)->TURL);
	soap_serialize_string(soap, &((SRMv1Type__RequestFileStatus*)this)->sourceFilename);
	soap_serialize_string(soap, &((SRMv1Type__RequestFileStatus*)this)->destFilename);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->SURL);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->size, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->owner);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->group);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumType);
	soap_serialize_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumValue);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->isPinned, SOAP_TYPE_bool);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->isPermanent, SOAP_TYPE_bool);
	soap_embedded(soap, &((SRMv1Type__FileMetaData*)this)->isCached, SOAP_TYPE_bool);
	/* transient soap skipped */
}

void SRMv1Type__RequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv1Type__RequestFileStatus*)this)->state);
	soap_default_int(soap, &((SRMv1Type__RequestFileStatus*)this)->fileId);
	soap_default_string(soap, &((SRMv1Type__RequestFileStatus*)this)->TURL);
	soap_default_int(soap, &((SRMv1Type__RequestFileStatus*)this)->estSecondsToStart);
	soap_default_string(soap, &((SRMv1Type__RequestFileStatus*)this)->sourceFilename);
	soap_default_string(soap, &((SRMv1Type__RequestFileStatus*)this)->destFilename);
	soap_default_int(soap, &((SRMv1Type__RequestFileStatus*)this)->queueOrder);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->SURL);
	soap_default_LONG64(soap, &((SRMv1Type__FileMetaData*)this)->size);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->owner);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->group);
	soap_default_int(soap, &((SRMv1Type__FileMetaData*)this)->permMode);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumType);
	soap_default_string(soap, &((SRMv1Type__FileMetaData*)this)->checksumValue);
	soap_default_bool(soap, &((SRMv1Type__FileMetaData*)this)->isPinned);
	soap_default_bool(soap, &((SRMv1Type__FileMetaData*)this)->isPermanent);
	soap_default_bool(soap, &((SRMv1Type__FileMetaData*)this)->isCached);
	/* transient soap skipped */
}

int SRMv1Type__RequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv1Type__RequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv1Type__RequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv1Type__RequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Type__RequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv1Type__RequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Type__RequestFileStatus), "SRMv1Type:RequestFileStatus");
	soap_out_string(soap, "SURL", -1, &(((SRMv1Type__FileMetaData*)a)->SURL), "");
	soap_out_LONG64(soap, "size", -1, &(((SRMv1Type__FileMetaData*)a)->size), "");
	soap_out_string(soap, "owner", -1, &(((SRMv1Type__FileMetaData*)a)->owner), "");
	soap_out_string(soap, "group", -1, &(((SRMv1Type__FileMetaData*)a)->group), "");
	soap_out_int(soap, "permMode", -1, &(((SRMv1Type__FileMetaData*)a)->permMode), "");
	soap_out_string(soap, "checksumType", -1, &(((SRMv1Type__FileMetaData*)a)->checksumType), "");
	soap_out_string(soap, "checksumValue", -1, &(((SRMv1Type__FileMetaData*)a)->checksumValue), "");
	soap_out_bool(soap, "isPinned", -1, &(((SRMv1Type__FileMetaData*)a)->isPinned), "");
	soap_out_bool(soap, "isPermanent", -1, &(((SRMv1Type__FileMetaData*)a)->isPermanent), "");
	soap_out_bool(soap, "isCached", -1, &(((SRMv1Type__FileMetaData*)a)->isCached), "");
	/* transient soap skipped */
	soap_out_string(soap, "state", -1, &(((SRMv1Type__RequestFileStatus*)a)->state), "");
	soap_out_int(soap, "fileId", -1, &(((SRMv1Type__RequestFileStatus*)a)->fileId), "");
	soap_out_string(soap, "TURL", -1, &(((SRMv1Type__RequestFileStatus*)a)->TURL), "");
	soap_out_int(soap, "estSecondsToStart", -1, &(((SRMv1Type__RequestFileStatus*)a)->estSecondsToStart), "");
	soap_out_string(soap, "sourceFilename", -1, &(((SRMv1Type__RequestFileStatus*)a)->sourceFilename), "");
	soap_out_string(soap, "destFilename", -1, &(((SRMv1Type__RequestFileStatus*)a)->destFilename), "");
	soap_out_int(soap, "queueOrder", -1, &(((SRMv1Type__RequestFileStatus*)a)->queueOrder), "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv1Type__RequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv1Type__RequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus * SOAP_FMAC4 soap_get_SRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Type__RequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv1Type__RequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv1Type__RequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus * SOAP_FMAC4 soap_in_SRMv1Type__RequestFileStatus(struct soap *soap, const char *tag, SRMv1Type__RequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv1Type__RequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Type__RequestFileStatus, sizeof(SRMv1Type__RequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv1Type__RequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv1Type__RequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_SURL2 = 1, soap_flag_size2 = 1, soap_flag_owner2 = 1, soap_flag_group2 = 1, soap_flag_permMode2 = 1, soap_flag_checksumType2 = 1, soap_flag_checksumValue2 = 1, soap_flag_isPinned2 = 1, soap_flag_isPermanent2 = 1, soap_flag_isCached2 = 1, soap_flag_state1 = 1, soap_flag_fileId1 = 1, soap_flag_TURL1 = 1, soap_flag_estSecondsToStart1 = 1, soap_flag_sourceFilename1 = 1, soap_flag_destFilename1 = 1, soap_flag_queueOrder1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SURL2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SURL", &(((SRMv1Type__FileMetaData*)a)->SURL), "xsd:string"))
				{	soap_flag_SURL2--;
					continue;
				}
			if (soap_flag_size2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "size", &(((SRMv1Type__FileMetaData*)a)->size), "xsd:long"))
				{	soap_flag_size2--;
					continue;
				}
			if (soap_flag_owner2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "owner", &(((SRMv1Type__FileMetaData*)a)->owner), "xsd:string"))
				{	soap_flag_owner2--;
					continue;
				}
			if (soap_flag_group2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "group", &(((SRMv1Type__FileMetaData*)a)->group), "xsd:string"))
				{	soap_flag_group2--;
					continue;
				}
			if (soap_flag_permMode2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "permMode", &(((SRMv1Type__FileMetaData*)a)->permMode), "xsd:int"))
				{	soap_flag_permMode2--;
					continue;
				}
			if (soap_flag_checksumType2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "checksumType", &(((SRMv1Type__FileMetaData*)a)->checksumType), "xsd:string"))
				{	soap_flag_checksumType2--;
					continue;
				}
			if (soap_flag_checksumValue2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "checksumValue", &(((SRMv1Type__FileMetaData*)a)->checksumValue), "xsd:string"))
				{	soap_flag_checksumValue2--;
					continue;
				}
			if (soap_flag_isPinned2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isPinned", &(((SRMv1Type__FileMetaData*)a)->isPinned), "xsd:boolean"))
				{	soap_flag_isPinned2--;
					continue;
				}
			if (soap_flag_isPermanent2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isPermanent", &(((SRMv1Type__FileMetaData*)a)->isPermanent), "xsd:boolean"))
				{	soap_flag_isPermanent2--;
					continue;
				}
			if (soap_flag_isCached2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "isCached", &(((SRMv1Type__FileMetaData*)a)->isCached), "xsd:boolean"))
				{	soap_flag_isCached2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_state1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "state", &(((SRMv1Type__RequestFileStatus*)a)->state), "xsd:string"))
				{	soap_flag_state1--;
					continue;
				}
			if (soap_flag_fileId1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "fileId", &(((SRMv1Type__RequestFileStatus*)a)->fileId), "xsd:int"))
				{	soap_flag_fileId1--;
					continue;
				}
			if (soap_flag_TURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "TURL", &(((SRMv1Type__RequestFileStatus*)a)->TURL), "xsd:string"))
				{	soap_flag_TURL1--;
					continue;
				}
			if (soap_flag_estSecondsToStart1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "estSecondsToStart", &(((SRMv1Type__RequestFileStatus*)a)->estSecondsToStart), "xsd:int"))
				{	soap_flag_estSecondsToStart1--;
					continue;
				}
			if (soap_flag_sourceFilename1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "sourceFilename", &(((SRMv1Type__RequestFileStatus*)a)->sourceFilename), "xsd:string"))
				{	soap_flag_sourceFilename1--;
					continue;
				}
			if (soap_flag_destFilename1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "destFilename", &(((SRMv1Type__RequestFileStatus*)a)->destFilename), "xsd:string"))
				{	soap_flag_destFilename1--;
					continue;
				}
			if (soap_flag_queueOrder1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "queueOrder", &(((SRMv1Type__RequestFileStatus*)a)->queueOrder), "xsd:int"))
				{	soap_flag_queueOrder1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_size2 > 0 || soap_flag_permMode2 > 0 || soap_flag_isPinned2 > 0 || soap_flag_isPermanent2 > 0 || soap_flag_isCached2 > 0 || soap_flag_fileId1 > 0 || soap_flag_estSecondsToStart1 > 0 || soap_flag_queueOrder1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv1Type__RequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Type__RequestFileStatus, 0, sizeof(SRMv1Type__RequestFileStatus), 0, soap_copy_SRMv1Type__RequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv1Type__RequestFileStatus * SOAP_FMAC6 soap_new_SRMv1Type__RequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Type__RequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv1Type__RequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Type__RequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Type__RequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv1Type__RequestFileStatus;
		if (size)
			*size = sizeof(SRMv1Type__RequestFileStatus);
		((SRMv1Type__RequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv1Type__RequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv1Type__RequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv1Type__RequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv1Type__RequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Type__RequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv1Type__RequestFileStatus %p -> %p\n", q, p));
	*(SRMv1Type__RequestFileStatus*)p = *(SRMv1Type__RequestFileStatus*)q;
}

void SRMv1Type__RequestStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv1Type__RequestStatus*)this)->type);
	soap_serialize_string(soap, &((SRMv1Type__RequestStatus*)this)->state);
	soap_serialize_PointerTotime(soap, &((SRMv1Type__RequestStatus*)this)->submitTime);
	soap_serialize_PointerTotime(soap, &((SRMv1Type__RequestStatus*)this)->startTime);
	soap_serialize_PointerTotime(soap, &((SRMv1Type__RequestStatus*)this)->finishTime);
	soap_serialize_PointerToArrayOfRequestFileStatus(soap, &((SRMv1Type__RequestStatus*)this)->fileStatuses);
	soap_serialize_string(soap, &((SRMv1Type__RequestStatus*)this)->errorMessage);
	/* transient soap skipped */
}

void SRMv1Type__RequestStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((SRMv1Type__RequestStatus*)this)->requestId);
	soap_default_string(soap, &((SRMv1Type__RequestStatus*)this)->type);
	soap_default_string(soap, &((SRMv1Type__RequestStatus*)this)->state);
	((SRMv1Type__RequestStatus*)this)->submitTime = NULL;
	((SRMv1Type__RequestStatus*)this)->startTime = NULL;
	((SRMv1Type__RequestStatus*)this)->finishTime = NULL;
	soap_default_int(soap, &((SRMv1Type__RequestStatus*)this)->estTimeToStart);
	((SRMv1Type__RequestStatus*)this)->fileStatuses = NULL;
	soap_default_string(soap, &((SRMv1Type__RequestStatus*)this)->errorMessage);
	soap_default_int(soap, &((SRMv1Type__RequestStatus*)this)->retryDeltaTime);
	/* transient soap skipped */
}

int SRMv1Type__RequestStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv1Type__RequestStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv1Type__RequestStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv1Type__RequestStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Type__RequestStatus(struct soap *soap, const char *tag, int id, const SRMv1Type__RequestStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Type__RequestStatus), type);
	soap_out_int(soap, "requestId", -1, &(((SRMv1Type__RequestStatus*)a)->requestId), "");
	soap_out_string(soap, "type", -1, &(((SRMv1Type__RequestStatus*)a)->type), "");
	soap_out_string(soap, "state", -1, &(((SRMv1Type__RequestStatus*)a)->state), "");
	soap_out_PointerTotime(soap, "submitTime", -1, &(((SRMv1Type__RequestStatus*)a)->submitTime), "");
	soap_out_PointerTotime(soap, "startTime", -1, &(((SRMv1Type__RequestStatus*)a)->startTime), "");
	soap_out_PointerTotime(soap, "finishTime", -1, &(((SRMv1Type__RequestStatus*)a)->finishTime), "");
	soap_out_int(soap, "estTimeToStart", -1, &(((SRMv1Type__RequestStatus*)a)->estTimeToStart), "");
	soap_out_PointerToArrayOfRequestFileStatus(soap, "fileStatuses", -1, &(((SRMv1Type__RequestStatus*)a)->fileStatuses), "");
	soap_out_string(soap, "errorMessage", -1, &(((SRMv1Type__RequestStatus*)a)->errorMessage), "");
	soap_out_int(soap, "retryDeltaTime", -1, &(((SRMv1Type__RequestStatus*)a)->retryDeltaTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv1Type__RequestStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv1Type__RequestStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv1Type__RequestStatus * SOAP_FMAC4 soap_get_SRMv1Type__RequestStatus(struct soap *soap, SRMv1Type__RequestStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Type__RequestStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv1Type__RequestStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv1Type__RequestStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv1Type__RequestStatus * SOAP_FMAC4 soap_in_SRMv1Type__RequestStatus(struct soap *soap, const char *tag, SRMv1Type__RequestStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv1Type__RequestStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Type__RequestStatus, sizeof(SRMv1Type__RequestStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv1Type__RequestStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv1Type__RequestStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestId1 = 1, soap_flag_type1 = 1, soap_flag_state1 = 1, soap_flag_submitTime1 = 1, soap_flag_startTime1 = 1, soap_flag_finishTime1 = 1, soap_flag_estTimeToStart1 = 1, soap_flag_fileStatuses1 = 1, soap_flag_errorMessage1 = 1, soap_flag_retryDeltaTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestId1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "requestId", &(((SRMv1Type__RequestStatus*)a)->requestId), "xsd:int"))
				{	soap_flag_requestId1--;
					continue;
				}
			if (soap_flag_type1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(((SRMv1Type__RequestStatus*)a)->type), "xsd:string"))
				{	soap_flag_type1--;
					continue;
				}
			if (soap_flag_state1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "state", &(((SRMv1Type__RequestStatus*)a)->state), "xsd:string"))
				{	soap_flag_state1--;
					continue;
				}
			if (soap_flag_submitTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "submitTime", &(((SRMv1Type__RequestStatus*)a)->submitTime), "xsd:dateTime"))
				{	soap_flag_submitTime1--;
					continue;
				}
			if (soap_flag_startTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "startTime", &(((SRMv1Type__RequestStatus*)a)->startTime), "xsd:dateTime"))
				{	soap_flag_startTime1--;
					continue;
				}
			if (soap_flag_finishTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "finishTime", &(((SRMv1Type__RequestStatus*)a)->finishTime), "xsd:dateTime"))
				{	soap_flag_finishTime1--;
					continue;
				}
			if (soap_flag_estTimeToStart1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "estTimeToStart", &(((SRMv1Type__RequestStatus*)a)->estTimeToStart), "xsd:int"))
				{	soap_flag_estTimeToStart1--;
					continue;
				}
			if (soap_flag_fileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfRequestFileStatus(soap, "fileStatuses", &(((SRMv1Type__RequestStatus*)a)->fileStatuses), "SRMv1Type:RequestFileStatus"))
				{	soap_flag_fileStatuses1--;
					continue;
				}
			if (soap_flag_errorMessage1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "errorMessage", &(((SRMv1Type__RequestStatus*)a)->errorMessage), "xsd:string"))
				{	soap_flag_errorMessage1--;
					continue;
				}
			if (soap_flag_retryDeltaTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "retryDeltaTime", &(((SRMv1Type__RequestStatus*)a)->retryDeltaTime), "xsd:int"))
				{	soap_flag_retryDeltaTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestId1 > 0 || soap_flag_estTimeToStart1 > 0 || soap_flag_retryDeltaTime1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv1Type__RequestStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Type__RequestStatus, 0, sizeof(SRMv1Type__RequestStatus), 0, soap_copy_SRMv1Type__RequestStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv1Type__RequestStatus * SOAP_FMAC6 soap_new_SRMv1Type__RequestStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Type__RequestStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Type__RequestStatus(struct soap *soap, SRMv1Type__RequestStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv1Type__RequestStatus * SOAP_FMAC4 soap_instantiate_SRMv1Type__RequestStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Type__RequestStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Type__RequestStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv1Type__RequestStatus;
		if (size)
			*size = sizeof(SRMv1Type__RequestStatus);
		((SRMv1Type__RequestStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv1Type__RequestStatus[n];
		if (size)
			*size = n * sizeof(SRMv1Type__RequestStatus);
		for (int i = 0; i < n; i++)
			((SRMv1Type__RequestStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv1Type__RequestStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Type__RequestStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv1Type__RequestStatus %p -> %p\n", q, p));
	*(SRMv1Type__RequestStatus*)p = *(SRMv1Type__RequestStatus*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getProtocols(struct soap *soap, const struct SRMv1Meth__getProtocols *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getProtocols(struct soap *soap, struct SRMv1Meth__getProtocols *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getProtocols(struct soap *soap, const struct SRMv1Meth__getProtocols *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getProtocols);
	if (soap_out_SRMv1Meth__getProtocols(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getProtocols(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getProtocols *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getProtocols), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getProtocols * SOAP_FMAC4 soap_get_SRMv1Meth__getProtocols(struct soap *soap, struct SRMv1Meth__getProtocols *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getProtocols(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getProtocols * SOAP_FMAC4 soap_in_SRMv1Meth__getProtocols(struct soap *soap, const char *tag, struct SRMv1Meth__getProtocols *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getProtocols *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getProtocols, sizeof(struct SRMv1Meth__getProtocols), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getProtocols(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getProtocols *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getProtocols, 0, sizeof(struct SRMv1Meth__getProtocols), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getProtocols * SOAP_FMAC6 soap_new_SRMv1Meth__getProtocols(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getProtocols(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getProtocols(struct soap *soap, struct SRMv1Meth__getProtocols *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getProtocols * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getProtocols(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getProtocols(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getProtocols, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getProtocols;
		if (size)
			*size = sizeof(struct SRMv1Meth__getProtocols);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getProtocols[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getProtocols);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getProtocols*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getProtocols(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getProtocols %p -> %p\n", q, p));
	*(struct SRMv1Meth__getProtocols*)p = *(struct SRMv1Meth__getProtocols*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getProtocolsResponse(struct soap *soap, const struct SRMv1Meth__getProtocolsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getProtocolsResponse(struct soap *soap, struct SRMv1Meth__getProtocolsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getProtocolsResponse(struct soap *soap, const struct SRMv1Meth__getProtocolsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getProtocolsResponse);
	if (soap_out_SRMv1Meth__getProtocolsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getProtocolsResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getProtocolsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getProtocolsResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToArrayOfstring(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getProtocolsResponse * SOAP_FMAC4 soap_get_SRMv1Meth__getProtocolsResponse(struct soap *soap, struct SRMv1Meth__getProtocolsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getProtocolsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getProtocolsResponse * SOAP_FMAC4 soap_in_SRMv1Meth__getProtocolsResponse(struct soap *soap, const char *tag, struct SRMv1Meth__getProtocolsResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getProtocolsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getProtocolsResponse, sizeof(struct SRMv1Meth__getProtocolsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getProtocolsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_Result, "xsd:string"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getProtocolsResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getProtocolsResponse, 0, sizeof(struct SRMv1Meth__getProtocolsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getProtocolsResponse * SOAP_FMAC6 soap_new_SRMv1Meth__getProtocolsResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getProtocolsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getProtocolsResponse(struct soap *soap, struct SRMv1Meth__getProtocolsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getProtocolsResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getProtocolsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getProtocolsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getProtocolsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getProtocolsResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__getProtocolsResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getProtocolsResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getProtocolsResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getProtocolsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getProtocolsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getProtocolsResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__getProtocolsResponse*)p = *(struct SRMv1Meth__getProtocolsResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__advisoryDelete(struct soap *soap, const struct SRMv1Meth__advisoryDelete *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__advisoryDelete(struct soap *soap, struct SRMv1Meth__advisoryDelete *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__advisoryDelete(struct soap *soap, const struct SRMv1Meth__advisoryDelete *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__advisoryDelete);
	if (soap_out_SRMv1Meth__advisoryDelete(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__advisoryDelete(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__advisoryDelete *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__advisoryDelete), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__advisoryDelete * SOAP_FMAC4 soap_get_SRMv1Meth__advisoryDelete(struct soap *soap, struct SRMv1Meth__advisoryDelete *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__advisoryDelete(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__advisoryDelete * SOAP_FMAC4 soap_in_SRMv1Meth__advisoryDelete(struct soap *soap, const char *tag, struct SRMv1Meth__advisoryDelete *a, const char *type)
{
	short soap_flag__arg0 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__advisoryDelete *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__advisoryDelete, sizeof(struct SRMv1Meth__advisoryDelete), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__advisoryDelete(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__advisoryDelete *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__advisoryDelete, 0, sizeof(struct SRMv1Meth__advisoryDelete), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__advisoryDelete * SOAP_FMAC6 soap_new_SRMv1Meth__advisoryDelete(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__advisoryDelete(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__advisoryDelete(struct soap *soap, struct SRMv1Meth__advisoryDelete *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__advisoryDelete * SOAP_FMAC4 soap_instantiate_SRMv1Meth__advisoryDelete(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__advisoryDelete(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__advisoryDelete, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__advisoryDelete;
		if (size)
			*size = sizeof(struct SRMv1Meth__advisoryDelete);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__advisoryDelete[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__advisoryDelete);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__advisoryDelete*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__advisoryDelete(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__advisoryDelete %p -> %p\n", q, p));
	*(struct SRMv1Meth__advisoryDelete*)p = *(struct SRMv1Meth__advisoryDelete*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, const struct SRMv1Meth__advisoryDeleteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, struct SRMv1Meth__advisoryDeleteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, const struct SRMv1Meth__advisoryDeleteResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse);
	if (soap_out_SRMv1Meth__advisoryDeleteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__advisoryDeleteResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__advisoryDeleteResponse * SOAP_FMAC4 soap_get_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, struct SRMv1Meth__advisoryDeleteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__advisoryDeleteResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__advisoryDeleteResponse * SOAP_FMAC4 soap_in_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, const char *tag, struct SRMv1Meth__advisoryDeleteResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__advisoryDeleteResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse, sizeof(struct SRMv1Meth__advisoryDeleteResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__advisoryDeleteResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__advisoryDeleteResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse, 0, sizeof(struct SRMv1Meth__advisoryDeleteResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__advisoryDeleteResponse * SOAP_FMAC6 soap_new_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__advisoryDeleteResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, struct SRMv1Meth__advisoryDeleteResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__advisoryDeleteResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__advisoryDeleteResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__advisoryDeleteResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__advisoryDeleteResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__advisoryDeleteResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__advisoryDeleteResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__advisoryDeleteResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__advisoryDeleteResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__advisoryDeleteResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__advisoryDeleteResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__advisoryDeleteResponse*)p = *(struct SRMv1Meth__advisoryDeleteResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getEstPutTime(struct soap *soap, const struct SRMv1Meth__getEstPutTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg1);
	soap_serialize_PointerToArrayOflong(soap, &a->_arg2);
	soap_serialize_PointerToArrayOfboolean(soap, &a->_arg3);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg4);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getEstPutTime(struct soap *soap, struct SRMv1Meth__getEstPutTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
	a->_arg1 = NULL;
	a->_arg2 = NULL;
	a->_arg3 = NULL;
	a->_arg4 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getEstPutTime(struct soap *soap, const struct SRMv1Meth__getEstPutTime *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getEstPutTime);
	if (soap_out_SRMv1Meth__getEstPutTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getEstPutTime(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getEstPutTime *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getEstPutTime), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_out_PointerToArrayOfstring(soap, "arg1", -1, &a->_arg1, "");
	soap_out_PointerToArrayOflong(soap, "arg2", -1, &a->_arg2, "");
	soap_out_PointerToArrayOfboolean(soap, "arg3", -1, &a->_arg3, "");
	soap_out_PointerToArrayOfstring(soap, "arg4", -1, &a->_arg4, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getEstPutTime * SOAP_FMAC4 soap_get_SRMv1Meth__getEstPutTime(struct soap *soap, struct SRMv1Meth__getEstPutTime *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getEstPutTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getEstPutTime * SOAP_FMAC4 soap_in_SRMv1Meth__getEstPutTime(struct soap *soap, const char *tag, struct SRMv1Meth__getEstPutTime *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1, soap_flag__arg2 = 1, soap_flag__arg3 = 1, soap_flag__arg4 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getEstPutTime *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getEstPutTime, sizeof(struct SRMv1Meth__getEstPutTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getEstPutTime(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg1, "xsd:string"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap_flag__arg2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOflong(soap, NULL, &a->_arg2, "xsd:long"))
				{	soap_flag__arg2--;
					continue;
				}
			if (soap_flag__arg3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfboolean(soap, NULL, &a->_arg3, "xsd:boolean"))
				{	soap_flag__arg3--;
					continue;
				}
			if (soap_flag__arg4 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg4, "xsd:string"))
				{	soap_flag__arg4--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getEstPutTime *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getEstPutTime, 0, sizeof(struct SRMv1Meth__getEstPutTime), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getEstPutTime * SOAP_FMAC6 soap_new_SRMv1Meth__getEstPutTime(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getEstPutTime(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getEstPutTime(struct soap *soap, struct SRMv1Meth__getEstPutTime *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getEstPutTime * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getEstPutTime(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getEstPutTime(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getEstPutTime, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstPutTime;
		if (size)
			*size = sizeof(struct SRMv1Meth__getEstPutTime);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstPutTime[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getEstPutTime);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getEstPutTime*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getEstPutTime(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getEstPutTime %p -> %p\n", q, p));
	*(struct SRMv1Meth__getEstPutTime*)p = *(struct SRMv1Meth__getEstPutTime*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, const struct SRMv1Meth__getEstPutTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, struct SRMv1Meth__getEstPutTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, const struct SRMv1Meth__getEstPutTimeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse);
	if (soap_out_SRMv1Meth__getEstPutTimeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getEstPutTimeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getEstPutTimeResponse * SOAP_FMAC4 soap_get_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, struct SRMv1Meth__getEstPutTimeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getEstPutTimeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getEstPutTimeResponse * SOAP_FMAC4 soap_in_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, const char *tag, struct SRMv1Meth__getEstPutTimeResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getEstPutTimeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse, sizeof(struct SRMv1Meth__getEstPutTimeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getEstPutTimeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getEstPutTimeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse, 0, sizeof(struct SRMv1Meth__getEstPutTimeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getEstPutTimeResponse * SOAP_FMAC6 soap_new_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getEstPutTimeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, struct SRMv1Meth__getEstPutTimeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getEstPutTimeResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getEstPutTimeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getEstPutTimeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstPutTimeResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__getEstPutTimeResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstPutTimeResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getEstPutTimeResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getEstPutTimeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getEstPutTimeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getEstPutTimeResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__getEstPutTimeResponse*)p = *(struct SRMv1Meth__getEstPutTimeResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getEstGetTime(struct soap *soap, const struct SRMv1Meth__getEstGetTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getEstGetTime(struct soap *soap, struct SRMv1Meth__getEstGetTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
	a->_arg1 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getEstGetTime(struct soap *soap, const struct SRMv1Meth__getEstGetTime *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getEstGetTime);
	if (soap_out_SRMv1Meth__getEstGetTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getEstGetTime(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getEstGetTime *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getEstGetTime), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_out_PointerToArrayOfstring(soap, "arg1", -1, &a->_arg1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getEstGetTime * SOAP_FMAC4 soap_get_SRMv1Meth__getEstGetTime(struct soap *soap, struct SRMv1Meth__getEstGetTime *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getEstGetTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getEstGetTime * SOAP_FMAC4 soap_in_SRMv1Meth__getEstGetTime(struct soap *soap, const char *tag, struct SRMv1Meth__getEstGetTime *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getEstGetTime *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getEstGetTime, sizeof(struct SRMv1Meth__getEstGetTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getEstGetTime(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg1, "xsd:string"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getEstGetTime *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getEstGetTime, 0, sizeof(struct SRMv1Meth__getEstGetTime), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getEstGetTime * SOAP_FMAC6 soap_new_SRMv1Meth__getEstGetTime(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getEstGetTime(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getEstGetTime(struct soap *soap, struct SRMv1Meth__getEstGetTime *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getEstGetTime * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getEstGetTime(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getEstGetTime(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getEstGetTime, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstGetTime;
		if (size)
			*size = sizeof(struct SRMv1Meth__getEstGetTime);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstGetTime[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getEstGetTime);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getEstGetTime*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getEstGetTime(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getEstGetTime %p -> %p\n", q, p));
	*(struct SRMv1Meth__getEstGetTime*)p = *(struct SRMv1Meth__getEstGetTime*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, const struct SRMv1Meth__getEstGetTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, struct SRMv1Meth__getEstGetTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, const struct SRMv1Meth__getEstGetTimeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse);
	if (soap_out_SRMv1Meth__getEstGetTimeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getEstGetTimeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getEstGetTimeResponse * SOAP_FMAC4 soap_get_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, struct SRMv1Meth__getEstGetTimeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getEstGetTimeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getEstGetTimeResponse * SOAP_FMAC4 soap_in_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, const char *tag, struct SRMv1Meth__getEstGetTimeResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getEstGetTimeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse, sizeof(struct SRMv1Meth__getEstGetTimeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getEstGetTimeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getEstGetTimeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse, 0, sizeof(struct SRMv1Meth__getEstGetTimeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getEstGetTimeResponse * SOAP_FMAC6 soap_new_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getEstGetTimeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, struct SRMv1Meth__getEstGetTimeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getEstGetTimeResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getEstGetTimeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getEstGetTimeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstGetTimeResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__getEstGetTimeResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getEstGetTimeResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getEstGetTimeResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getEstGetTimeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getEstGetTimeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getEstGetTimeResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__getEstGetTimeResponse*)p = *(struct SRMv1Meth__getEstGetTimeResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__mkPermanent(struct soap *soap, const struct SRMv1Meth__mkPermanent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__mkPermanent(struct soap *soap, struct SRMv1Meth__mkPermanent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__mkPermanent(struct soap *soap, const struct SRMv1Meth__mkPermanent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__mkPermanent);
	if (soap_out_SRMv1Meth__mkPermanent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__mkPermanent(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__mkPermanent *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__mkPermanent), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__mkPermanent * SOAP_FMAC4 soap_get_SRMv1Meth__mkPermanent(struct soap *soap, struct SRMv1Meth__mkPermanent *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__mkPermanent(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__mkPermanent * SOAP_FMAC4 soap_in_SRMv1Meth__mkPermanent(struct soap *soap, const char *tag, struct SRMv1Meth__mkPermanent *a, const char *type)
{
	short soap_flag__arg0 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__mkPermanent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__mkPermanent, sizeof(struct SRMv1Meth__mkPermanent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__mkPermanent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__mkPermanent *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__mkPermanent, 0, sizeof(struct SRMv1Meth__mkPermanent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__mkPermanent * SOAP_FMAC6 soap_new_SRMv1Meth__mkPermanent(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__mkPermanent(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__mkPermanent(struct soap *soap, struct SRMv1Meth__mkPermanent *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__mkPermanent * SOAP_FMAC4 soap_instantiate_SRMv1Meth__mkPermanent(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__mkPermanent(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__mkPermanent, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__mkPermanent;
		if (size)
			*size = sizeof(struct SRMv1Meth__mkPermanent);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__mkPermanent[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__mkPermanent);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__mkPermanent*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__mkPermanent(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__mkPermanent %p -> %p\n", q, p));
	*(struct SRMv1Meth__mkPermanent*)p = *(struct SRMv1Meth__mkPermanent*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__mkPermanentResponse(struct soap *soap, const struct SRMv1Meth__mkPermanentResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__mkPermanentResponse(struct soap *soap, struct SRMv1Meth__mkPermanentResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__mkPermanentResponse(struct soap *soap, const struct SRMv1Meth__mkPermanentResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__mkPermanentResponse);
	if (soap_out_SRMv1Meth__mkPermanentResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__mkPermanentResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__mkPermanentResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__mkPermanentResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__mkPermanentResponse * SOAP_FMAC4 soap_get_SRMv1Meth__mkPermanentResponse(struct soap *soap, struct SRMv1Meth__mkPermanentResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__mkPermanentResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__mkPermanentResponse * SOAP_FMAC4 soap_in_SRMv1Meth__mkPermanentResponse(struct soap *soap, const char *tag, struct SRMv1Meth__mkPermanentResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__mkPermanentResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__mkPermanentResponse, sizeof(struct SRMv1Meth__mkPermanentResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__mkPermanentResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__mkPermanentResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__mkPermanentResponse, 0, sizeof(struct SRMv1Meth__mkPermanentResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__mkPermanentResponse * SOAP_FMAC6 soap_new_SRMv1Meth__mkPermanentResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__mkPermanentResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__mkPermanentResponse(struct soap *soap, struct SRMv1Meth__mkPermanentResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__mkPermanentResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__mkPermanentResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__mkPermanentResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__mkPermanentResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__mkPermanentResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__mkPermanentResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__mkPermanentResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__mkPermanentResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__mkPermanentResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__mkPermanentResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__mkPermanentResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__mkPermanentResponse*)p = *(struct SRMv1Meth__mkPermanentResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getFileMetaData(struct soap *soap, const struct SRMv1Meth__getFileMetaData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getFileMetaData(struct soap *soap, struct SRMv1Meth__getFileMetaData *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getFileMetaData(struct soap *soap, const struct SRMv1Meth__getFileMetaData *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getFileMetaData);
	if (soap_out_SRMv1Meth__getFileMetaData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getFileMetaData(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getFileMetaData *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getFileMetaData), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getFileMetaData * SOAP_FMAC4 soap_get_SRMv1Meth__getFileMetaData(struct soap *soap, struct SRMv1Meth__getFileMetaData *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getFileMetaData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getFileMetaData * SOAP_FMAC4 soap_in_SRMv1Meth__getFileMetaData(struct soap *soap, const char *tag, struct SRMv1Meth__getFileMetaData *a, const char *type)
{
	short soap_flag__arg0 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getFileMetaData *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getFileMetaData, sizeof(struct SRMv1Meth__getFileMetaData), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getFileMetaData(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getFileMetaData *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getFileMetaData, 0, sizeof(struct SRMv1Meth__getFileMetaData), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getFileMetaData * SOAP_FMAC6 soap_new_SRMv1Meth__getFileMetaData(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getFileMetaData(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getFileMetaData(struct soap *soap, struct SRMv1Meth__getFileMetaData *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getFileMetaData * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getFileMetaData(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getFileMetaData(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getFileMetaData, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getFileMetaData;
		if (size)
			*size = sizeof(struct SRMv1Meth__getFileMetaData);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getFileMetaData[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getFileMetaData);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getFileMetaData*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getFileMetaData(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getFileMetaData %p -> %p\n", q, p));
	*(struct SRMv1Meth__getFileMetaData*)p = *(struct SRMv1Meth__getFileMetaData*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, const struct SRMv1Meth__getFileMetaDataResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfFileMetaData(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, struct SRMv1Meth__getFileMetaDataResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, const struct SRMv1Meth__getFileMetaDataResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse);
	if (soap_out_SRMv1Meth__getFileMetaDataResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getFileMetaDataResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToArrayOfFileMetaData(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getFileMetaDataResponse * SOAP_FMAC4 soap_get_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, struct SRMv1Meth__getFileMetaDataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getFileMetaDataResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getFileMetaDataResponse * SOAP_FMAC4 soap_in_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, const char *tag, struct SRMv1Meth__getFileMetaDataResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getFileMetaDataResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse, sizeof(struct SRMv1Meth__getFileMetaDataResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getFileMetaDataResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfFileMetaData(soap, NULL, &a->_Result, "SRMv1Type:FileMetaData"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getFileMetaDataResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse, 0, sizeof(struct SRMv1Meth__getFileMetaDataResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getFileMetaDataResponse * SOAP_FMAC6 soap_new_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getFileMetaDataResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, struct SRMv1Meth__getFileMetaDataResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getFileMetaDataResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getFileMetaDataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getFileMetaDataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getFileMetaDataResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__getFileMetaDataResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getFileMetaDataResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getFileMetaDataResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getFileMetaDataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getFileMetaDataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getFileMetaDataResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__getFileMetaDataResponse*)p = *(struct SRMv1Meth__getFileMetaDataResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getRequestStatus(struct soap *soap, const struct SRMv1Meth__getRequestStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getRequestStatus(struct soap *soap, struct SRMv1Meth__getRequestStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->_arg0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getRequestStatus(struct soap *soap, const struct SRMv1Meth__getRequestStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getRequestStatus);
	if (soap_out_SRMv1Meth__getRequestStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getRequestStatus(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getRequestStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getRequestStatus), type);
	soap_out_int(soap, "arg0", -1, &a->_arg0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getRequestStatus * SOAP_FMAC4 soap_get_SRMv1Meth__getRequestStatus(struct soap *soap, struct SRMv1Meth__getRequestStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getRequestStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getRequestStatus * SOAP_FMAC4 soap_in_SRMv1Meth__getRequestStatus(struct soap *soap, const char *tag, struct SRMv1Meth__getRequestStatus *a, const char *type)
{
	short soap_flag__arg0 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getRequestStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getRequestStatus, sizeof(struct SRMv1Meth__getRequestStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getRequestStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_arg0, "xsd:int"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__arg0 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getRequestStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getRequestStatus, 0, sizeof(struct SRMv1Meth__getRequestStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getRequestStatus * SOAP_FMAC6 soap_new_SRMv1Meth__getRequestStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getRequestStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getRequestStatus(struct soap *soap, struct SRMv1Meth__getRequestStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getRequestStatus * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getRequestStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getRequestStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getRequestStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getRequestStatus;
		if (size)
			*size = sizeof(struct SRMv1Meth__getRequestStatus);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getRequestStatus[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getRequestStatus);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getRequestStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getRequestStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getRequestStatus %p -> %p\n", q, p));
	*(struct SRMv1Meth__getRequestStatus*)p = *(struct SRMv1Meth__getRequestStatus*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getRequestStatusResponse(struct soap *soap, const struct SRMv1Meth__getRequestStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getRequestStatusResponse(struct soap *soap, struct SRMv1Meth__getRequestStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getRequestStatusResponse(struct soap *soap, const struct SRMv1Meth__getRequestStatusResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getRequestStatusResponse);
	if (soap_out_SRMv1Meth__getRequestStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getRequestStatusResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getRequestStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getRequestStatusResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getRequestStatusResponse * SOAP_FMAC4 soap_get_SRMv1Meth__getRequestStatusResponse(struct soap *soap, struct SRMv1Meth__getRequestStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getRequestStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getRequestStatusResponse * SOAP_FMAC4 soap_in_SRMv1Meth__getRequestStatusResponse(struct soap *soap, const char *tag, struct SRMv1Meth__getRequestStatusResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getRequestStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getRequestStatusResponse, sizeof(struct SRMv1Meth__getRequestStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getRequestStatusResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getRequestStatusResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getRequestStatusResponse, 0, sizeof(struct SRMv1Meth__getRequestStatusResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getRequestStatusResponse * SOAP_FMAC6 soap_new_SRMv1Meth__getRequestStatusResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getRequestStatusResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getRequestStatusResponse(struct soap *soap, struct SRMv1Meth__getRequestStatusResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getRequestStatusResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getRequestStatusResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getRequestStatusResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getRequestStatusResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getRequestStatusResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__getRequestStatusResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getRequestStatusResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getRequestStatusResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getRequestStatusResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getRequestStatusResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getRequestStatusResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__getRequestStatusResponse*)p = *(struct SRMv1Meth__getRequestStatusResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__setFileStatus(struct soap *soap, const struct SRMv1Meth__setFileStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_arg2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__setFileStatus(struct soap *soap, struct SRMv1Meth__setFileStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->_arg0);
	soap_default_int(soap, &a->_arg1);
	soap_default_string(soap, &a->_arg2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__setFileStatus(struct soap *soap, const struct SRMv1Meth__setFileStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__setFileStatus);
	if (soap_out_SRMv1Meth__setFileStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__setFileStatus(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__setFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__setFileStatus), type);
	soap_out_int(soap, "arg0", -1, &a->_arg0, "");
	soap_out_int(soap, "arg1", -1, &a->_arg1, "");
	soap_out_string(soap, "arg2", -1, &a->_arg2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__setFileStatus * SOAP_FMAC4 soap_get_SRMv1Meth__setFileStatus(struct soap *soap, struct SRMv1Meth__setFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__setFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__setFileStatus * SOAP_FMAC4 soap_in_SRMv1Meth__setFileStatus(struct soap *soap, const char *tag, struct SRMv1Meth__setFileStatus *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1, soap_flag__arg2 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__setFileStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__setFileStatus, sizeof(struct SRMv1Meth__setFileStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__setFileStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_arg0, "xsd:int"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_arg1, "xsd:int"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap_flag__arg2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_arg2, "xsd:string"))
				{	soap_flag__arg2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__arg0 > 0 || soap_flag__arg1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__setFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__setFileStatus, 0, sizeof(struct SRMv1Meth__setFileStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__setFileStatus * SOAP_FMAC6 soap_new_SRMv1Meth__setFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__setFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__setFileStatus(struct soap *soap, struct SRMv1Meth__setFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__setFileStatus * SOAP_FMAC4 soap_instantiate_SRMv1Meth__setFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__setFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__setFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__setFileStatus;
		if (size)
			*size = sizeof(struct SRMv1Meth__setFileStatus);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__setFileStatus[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__setFileStatus);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__setFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__setFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__setFileStatus %p -> %p\n", q, p));
	*(struct SRMv1Meth__setFileStatus*)p = *(struct SRMv1Meth__setFileStatus*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__setFileStatusResponse(struct soap *soap, const struct SRMv1Meth__setFileStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__setFileStatusResponse(struct soap *soap, struct SRMv1Meth__setFileStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__setFileStatusResponse(struct soap *soap, const struct SRMv1Meth__setFileStatusResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__setFileStatusResponse);
	if (soap_out_SRMv1Meth__setFileStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__setFileStatusResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__setFileStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__setFileStatusResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__setFileStatusResponse * SOAP_FMAC4 soap_get_SRMv1Meth__setFileStatusResponse(struct soap *soap, struct SRMv1Meth__setFileStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__setFileStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__setFileStatusResponse * SOAP_FMAC4 soap_in_SRMv1Meth__setFileStatusResponse(struct soap *soap, const char *tag, struct SRMv1Meth__setFileStatusResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__setFileStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__setFileStatusResponse, sizeof(struct SRMv1Meth__setFileStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__setFileStatusResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__setFileStatusResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__setFileStatusResponse, 0, sizeof(struct SRMv1Meth__setFileStatusResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__setFileStatusResponse * SOAP_FMAC6 soap_new_SRMv1Meth__setFileStatusResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__setFileStatusResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__setFileStatusResponse(struct soap *soap, struct SRMv1Meth__setFileStatusResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__setFileStatusResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__setFileStatusResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__setFileStatusResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__setFileStatusResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__setFileStatusResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__setFileStatusResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__setFileStatusResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__setFileStatusResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__setFileStatusResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__setFileStatusResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__setFileStatusResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__setFileStatusResponse*)p = *(struct SRMv1Meth__setFileStatusResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__unPin(struct soap *soap, const struct SRMv1Meth__unPin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__unPin(struct soap *soap, struct SRMv1Meth__unPin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
	soap_default_int(soap, &a->_arg1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__unPin(struct soap *soap, const struct SRMv1Meth__unPin *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__unPin);
	if (soap_out_SRMv1Meth__unPin(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__unPin(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__unPin *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__unPin), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_out_int(soap, "arg1", -1, &a->_arg1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__unPin * SOAP_FMAC4 soap_get_SRMv1Meth__unPin(struct soap *soap, struct SRMv1Meth__unPin *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__unPin(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__unPin * SOAP_FMAC4 soap_in_SRMv1Meth__unPin(struct soap *soap, const char *tag, struct SRMv1Meth__unPin *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__unPin *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__unPin, sizeof(struct SRMv1Meth__unPin), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__unPin(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_arg1, "xsd:int"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__arg1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__unPin *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__unPin, 0, sizeof(struct SRMv1Meth__unPin), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__unPin * SOAP_FMAC6 soap_new_SRMv1Meth__unPin(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__unPin(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__unPin(struct soap *soap, struct SRMv1Meth__unPin *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__unPin * SOAP_FMAC4 soap_instantiate_SRMv1Meth__unPin(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__unPin(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__unPin, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__unPin;
		if (size)
			*size = sizeof(struct SRMv1Meth__unPin);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__unPin[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__unPin);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__unPin*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__unPin(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__unPin %p -> %p\n", q, p));
	*(struct SRMv1Meth__unPin*)p = *(struct SRMv1Meth__unPin*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__unPinResponse(struct soap *soap, const struct SRMv1Meth__unPinResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__unPinResponse(struct soap *soap, struct SRMv1Meth__unPinResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__unPinResponse(struct soap *soap, const struct SRMv1Meth__unPinResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__unPinResponse);
	if (soap_out_SRMv1Meth__unPinResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__unPinResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__unPinResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__unPinResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__unPinResponse * SOAP_FMAC4 soap_get_SRMv1Meth__unPinResponse(struct soap *soap, struct SRMv1Meth__unPinResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__unPinResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__unPinResponse * SOAP_FMAC4 soap_in_SRMv1Meth__unPinResponse(struct soap *soap, const char *tag, struct SRMv1Meth__unPinResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__unPinResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__unPinResponse, sizeof(struct SRMv1Meth__unPinResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__unPinResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__unPinResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__unPinResponse, 0, sizeof(struct SRMv1Meth__unPinResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__unPinResponse * SOAP_FMAC6 soap_new_SRMv1Meth__unPinResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__unPinResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__unPinResponse(struct soap *soap, struct SRMv1Meth__unPinResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__unPinResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__unPinResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__unPinResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__unPinResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__unPinResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__unPinResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__unPinResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__unPinResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__unPinResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__unPinResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__unPinResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__unPinResponse*)p = *(struct SRMv1Meth__unPinResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__pin(struct soap *soap, const struct SRMv1Meth__pin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__pin(struct soap *soap, struct SRMv1Meth__pin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__pin(struct soap *soap, const struct SRMv1Meth__pin *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__pin);
	if (soap_out_SRMv1Meth__pin(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__pin(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__pin *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__pin), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__pin * SOAP_FMAC4 soap_get_SRMv1Meth__pin(struct soap *soap, struct SRMv1Meth__pin *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__pin(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__pin * SOAP_FMAC4 soap_in_SRMv1Meth__pin(struct soap *soap, const char *tag, struct SRMv1Meth__pin *a, const char *type)
{
	short soap_flag__arg0 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__pin *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__pin, sizeof(struct SRMv1Meth__pin), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__pin(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__pin *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__pin, 0, sizeof(struct SRMv1Meth__pin), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__pin * SOAP_FMAC6 soap_new_SRMv1Meth__pin(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__pin(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__pin(struct soap *soap, struct SRMv1Meth__pin *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__pin * SOAP_FMAC4 soap_instantiate_SRMv1Meth__pin(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__pin(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__pin, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__pin;
		if (size)
			*size = sizeof(struct SRMv1Meth__pin);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__pin[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__pin);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__pin*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__pin(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__pin %p -> %p\n", q, p));
	*(struct SRMv1Meth__pin*)p = *(struct SRMv1Meth__pin*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__pinResponse(struct soap *soap, const struct SRMv1Meth__pinResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__pinResponse(struct soap *soap, struct SRMv1Meth__pinResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__pinResponse(struct soap *soap, const struct SRMv1Meth__pinResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__pinResponse);
	if (soap_out_SRMv1Meth__pinResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__pinResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__pinResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__pinResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__pinResponse * SOAP_FMAC4 soap_get_SRMv1Meth__pinResponse(struct soap *soap, struct SRMv1Meth__pinResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__pinResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__pinResponse * SOAP_FMAC4 soap_in_SRMv1Meth__pinResponse(struct soap *soap, const char *tag, struct SRMv1Meth__pinResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__pinResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__pinResponse, sizeof(struct SRMv1Meth__pinResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__pinResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__pinResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__pinResponse, 0, sizeof(struct SRMv1Meth__pinResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__pinResponse * SOAP_FMAC6 soap_new_SRMv1Meth__pinResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__pinResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__pinResponse(struct soap *soap, struct SRMv1Meth__pinResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__pinResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__pinResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__pinResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__pinResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__pinResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__pinResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__pinResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__pinResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__pinResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__pinResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__pinResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__pinResponse*)p = *(struct SRMv1Meth__pinResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__ping(struct soap *soap, const struct SRMv1Meth__ping *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__ping(struct soap *soap, struct SRMv1Meth__ping *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__ping(struct soap *soap, const struct SRMv1Meth__ping *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__ping);
	if (soap_out_SRMv1Meth__ping(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__ping(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__ping *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__ping), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__ping * SOAP_FMAC4 soap_get_SRMv1Meth__ping(struct soap *soap, struct SRMv1Meth__ping *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__ping(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__ping * SOAP_FMAC4 soap_in_SRMv1Meth__ping(struct soap *soap, const char *tag, struct SRMv1Meth__ping *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__ping *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__ping, sizeof(struct SRMv1Meth__ping), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__ping(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__ping *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__ping, 0, sizeof(struct SRMv1Meth__ping), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__ping * SOAP_FMAC6 soap_new_SRMv1Meth__ping(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__ping(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__ping(struct soap *soap, struct SRMv1Meth__ping *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__ping * SOAP_FMAC4 soap_instantiate_SRMv1Meth__ping(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__ping(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__ping, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__ping;
		if (size)
			*size = sizeof(struct SRMv1Meth__ping);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__ping[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__ping);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__ping*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__ping(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__ping %p -> %p\n", q, p));
	*(struct SRMv1Meth__ping*)p = *(struct SRMv1Meth__ping*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__pingResponse(struct soap *soap, const struct SRMv1Meth__pingResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_Result, SOAP_TYPE_bool);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__pingResponse(struct soap *soap, struct SRMv1Meth__pingResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_bool(soap, &a->_Result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__pingResponse(struct soap *soap, const struct SRMv1Meth__pingResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__pingResponse);
	if (soap_out_SRMv1Meth__pingResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__pingResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__pingResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__pingResponse), type);
	soap_element_result(soap, "Result");
	soap_out_bool(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__pingResponse * SOAP_FMAC4 soap_get_SRMv1Meth__pingResponse(struct soap *soap, struct SRMv1Meth__pingResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__pingResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__pingResponse * SOAP_FMAC4 soap_in_SRMv1Meth__pingResponse(struct soap *soap, const char *tag, struct SRMv1Meth__pingResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__pingResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__pingResponse, sizeof(struct SRMv1Meth__pingResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__pingResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_Result, "xsd:boolean"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__Result > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__pingResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__pingResponse, 0, sizeof(struct SRMv1Meth__pingResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__pingResponse * SOAP_FMAC6 soap_new_SRMv1Meth__pingResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__pingResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__pingResponse(struct soap *soap, struct SRMv1Meth__pingResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__pingResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__pingResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__pingResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__pingResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__pingResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__pingResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__pingResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__pingResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__pingResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__pingResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__pingResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__pingResponse*)p = *(struct SRMv1Meth__pingResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__copy(struct soap *soap, const struct SRMv1Meth__copy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg1);
	soap_serialize_PointerToArrayOfboolean(soap, &a->_arg2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__copy(struct soap *soap, struct SRMv1Meth__copy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
	a->_arg1 = NULL;
	a->_arg2 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__copy(struct soap *soap, const struct SRMv1Meth__copy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__copy);
	if (soap_out_SRMv1Meth__copy(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__copy(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__copy *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__copy), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_out_PointerToArrayOfstring(soap, "arg1", -1, &a->_arg1, "");
	soap_out_PointerToArrayOfboolean(soap, "arg2", -1, &a->_arg2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__copy * SOAP_FMAC4 soap_get_SRMv1Meth__copy(struct soap *soap, struct SRMv1Meth__copy *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__copy(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__copy * SOAP_FMAC4 soap_in_SRMv1Meth__copy(struct soap *soap, const char *tag, struct SRMv1Meth__copy *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1, soap_flag__arg2 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__copy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__copy, sizeof(struct SRMv1Meth__copy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__copy(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg1, "xsd:string"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap_flag__arg2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfboolean(soap, NULL, &a->_arg2, "xsd:boolean"))
				{	soap_flag__arg2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__copy *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__copy, 0, sizeof(struct SRMv1Meth__copy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__copy * SOAP_FMAC6 soap_new_SRMv1Meth__copy(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__copy(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__copy(struct soap *soap, struct SRMv1Meth__copy *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__copy * SOAP_FMAC4 soap_instantiate_SRMv1Meth__copy(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__copy(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__copy, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__copy;
		if (size)
			*size = sizeof(struct SRMv1Meth__copy);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__copy[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__copy);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__copy*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__copy(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__copy %p -> %p\n", q, p));
	*(struct SRMv1Meth__copy*)p = *(struct SRMv1Meth__copy*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__copyResponse(struct soap *soap, const struct SRMv1Meth__copyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__copyResponse(struct soap *soap, struct SRMv1Meth__copyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__copyResponse(struct soap *soap, const struct SRMv1Meth__copyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__copyResponse);
	if (soap_out_SRMv1Meth__copyResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__copyResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__copyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__copyResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__copyResponse * SOAP_FMAC4 soap_get_SRMv1Meth__copyResponse(struct soap *soap, struct SRMv1Meth__copyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__copyResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__copyResponse * SOAP_FMAC4 soap_in_SRMv1Meth__copyResponse(struct soap *soap, const char *tag, struct SRMv1Meth__copyResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__copyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__copyResponse, sizeof(struct SRMv1Meth__copyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__copyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__copyResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__copyResponse, 0, sizeof(struct SRMv1Meth__copyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__copyResponse * SOAP_FMAC6 soap_new_SRMv1Meth__copyResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__copyResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__copyResponse(struct soap *soap, struct SRMv1Meth__copyResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__copyResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__copyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__copyResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__copyResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__copyResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__copyResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__copyResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__copyResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__copyResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__copyResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__copyResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__copyResponse*)p = *(struct SRMv1Meth__copyResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__get(struct soap *soap, const struct SRMv1Meth__get *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__get(struct soap *soap, struct SRMv1Meth__get *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
	a->_arg1 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__get(struct soap *soap, const struct SRMv1Meth__get *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__get);
	if (soap_out_SRMv1Meth__get(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__get(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__get *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__get), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_out_PointerToArrayOfstring(soap, "arg1", -1, &a->_arg1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__get * SOAP_FMAC4 soap_get_SRMv1Meth__get(struct soap *soap, struct SRMv1Meth__get *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__get(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__get * SOAP_FMAC4 soap_in_SRMv1Meth__get(struct soap *soap, const char *tag, struct SRMv1Meth__get *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__get *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__get, sizeof(struct SRMv1Meth__get), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__get(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg1, "xsd:string"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__get *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__get, 0, sizeof(struct SRMv1Meth__get), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__get * SOAP_FMAC6 soap_new_SRMv1Meth__get(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__get(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__get(struct soap *soap, struct SRMv1Meth__get *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__get * SOAP_FMAC4 soap_instantiate_SRMv1Meth__get(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__get(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__get, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__get;
		if (size)
			*size = sizeof(struct SRMv1Meth__get);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__get[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__get);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__get*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__get(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__get %p -> %p\n", q, p));
	*(struct SRMv1Meth__get*)p = *(struct SRMv1Meth__get*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__getResponse(struct soap *soap, const struct SRMv1Meth__getResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__getResponse(struct soap *soap, struct SRMv1Meth__getResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__getResponse(struct soap *soap, const struct SRMv1Meth__getResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__getResponse);
	if (soap_out_SRMv1Meth__getResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__getResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__getResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__getResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__getResponse * SOAP_FMAC4 soap_get_SRMv1Meth__getResponse(struct soap *soap, struct SRMv1Meth__getResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__getResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__getResponse * SOAP_FMAC4 soap_in_SRMv1Meth__getResponse(struct soap *soap, const char *tag, struct SRMv1Meth__getResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__getResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__getResponse, sizeof(struct SRMv1Meth__getResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__getResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__getResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__getResponse, 0, sizeof(struct SRMv1Meth__getResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__getResponse * SOAP_FMAC6 soap_new_SRMv1Meth__getResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__getResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__getResponse(struct soap *soap, struct SRMv1Meth__getResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__getResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__getResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__getResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__getResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__getResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__getResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__getResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__getResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__getResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__getResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__getResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__getResponse*)p = *(struct SRMv1Meth__getResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__put(struct soap *soap, const struct SRMv1Meth__put *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg0);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg1);
	soap_serialize_PointerToArrayOflong(soap, &a->_arg2);
	soap_serialize_PointerToArrayOfboolean(soap, &a->_arg3);
	soap_serialize_PointerToArrayOfstring(soap, &a->_arg4);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__put(struct soap *soap, struct SRMv1Meth__put *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_arg0 = NULL;
	a->_arg1 = NULL;
	a->_arg2 = NULL;
	a->_arg3 = NULL;
	a->_arg4 = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__put(struct soap *soap, const struct SRMv1Meth__put *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__put);
	if (soap_out_SRMv1Meth__put(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__put(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__put *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__put), type);
	soap_out_PointerToArrayOfstring(soap, "arg0", -1, &a->_arg0, "");
	soap_out_PointerToArrayOfstring(soap, "arg1", -1, &a->_arg1, "");
	soap_out_PointerToArrayOflong(soap, "arg2", -1, &a->_arg2, "");
	soap_out_PointerToArrayOfboolean(soap, "arg3", -1, &a->_arg3, "");
	soap_out_PointerToArrayOfstring(soap, "arg4", -1, &a->_arg4, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__put * SOAP_FMAC4 soap_get_SRMv1Meth__put(struct soap *soap, struct SRMv1Meth__put *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__put(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__put * SOAP_FMAC4 soap_in_SRMv1Meth__put(struct soap *soap, const char *tag, struct SRMv1Meth__put *a, const char *type)
{
	short soap_flag__arg0 = 1, soap_flag__arg1 = 1, soap_flag__arg2 = 1, soap_flag__arg3 = 1, soap_flag__arg4 = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__put *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__put, sizeof(struct SRMv1Meth__put), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__put(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__arg0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg0, "xsd:string"))
				{	soap_flag__arg0--;
					continue;
				}
			if (soap_flag__arg1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg1, "xsd:string"))
				{	soap_flag__arg1--;
					continue;
				}
			if (soap_flag__arg2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOflong(soap, NULL, &a->_arg2, "xsd:long"))
				{	soap_flag__arg2--;
					continue;
				}
			if (soap_flag__arg3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfboolean(soap, NULL, &a->_arg3, "xsd:boolean"))
				{	soap_flag__arg3--;
					continue;
				}
			if (soap_flag__arg4 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOfstring(soap, NULL, &a->_arg4, "xsd:string"))
				{	soap_flag__arg4--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__put *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__put, 0, sizeof(struct SRMv1Meth__put), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__put * SOAP_FMAC6 soap_new_SRMv1Meth__put(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__put(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__put(struct soap *soap, struct SRMv1Meth__put *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__put * SOAP_FMAC4 soap_instantiate_SRMv1Meth__put(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__put(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__put, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__put;
		if (size)
			*size = sizeof(struct SRMv1Meth__put);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__put[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__put);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__put*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__put(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__put %p -> %p\n", q, p));
	*(struct SRMv1Meth__put*)p = *(struct SRMv1Meth__put*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SRMv1Meth__putResponse(struct soap *soap, const struct SRMv1Meth__putResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv1Type__RequestStatus(soap, &a->_Result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv1Meth__putResponse(struct soap *soap, struct SRMv1Meth__putResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_Result = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv1Meth__putResponse(struct soap *soap, const struct SRMv1Meth__putResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv1Meth__putResponse);
	if (soap_out_SRMv1Meth__putResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv1Meth__putResponse(struct soap *soap, const char *tag, int id, const struct SRMv1Meth__putResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv1Meth__putResponse), type);
	if (a->_Result)
		soap_element_result(soap, "Result");
	soap_out_PointerToSRMv1Type__RequestStatus(soap, "Result", -1, &a->_Result, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SRMv1Meth__putResponse * SOAP_FMAC4 soap_get_SRMv1Meth__putResponse(struct soap *soap, struct SRMv1Meth__putResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv1Meth__putResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SRMv1Meth__putResponse * SOAP_FMAC4 soap_in_SRMv1Meth__putResponse(struct soap *soap, const char *tag, struct SRMv1Meth__putResponse *a, const char *type)
{
	short soap_flag__Result = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SRMv1Meth__putResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv1Meth__putResponse, sizeof(struct SRMv1Meth__putResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SRMv1Meth__putResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__Result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv1Type__RequestStatus(soap, NULL, &a->_Result, "SRMv1Type:RequestStatus"))
				{	soap_flag__Result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SRMv1Meth__putResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv1Meth__putResponse, 0, sizeof(struct SRMv1Meth__putResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SRMv1Meth__putResponse * SOAP_FMAC6 soap_new_SRMv1Meth__putResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv1Meth__putResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv1Meth__putResponse(struct soap *soap, struct SRMv1Meth__putResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SRMv1Meth__putResponse * SOAP_FMAC4 soap_instantiate_SRMv1Meth__putResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv1Meth__putResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv1Meth__putResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SRMv1Meth__putResponse;
		if (size)
			*size = sizeof(struct SRMv1Meth__putResponse);
	}
	else
	{	cp->ptr = (void*)new struct SRMv1Meth__putResponse[n];
		if (size)
			*size = n * sizeof(struct SRMv1Meth__putResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SRMv1Meth__putResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv1Meth__putResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SRMv1Meth__putResponse %p -> %p\n", q, p));
	*(struct SRMv1Meth__putResponse*)p = *(struct SRMv1Meth__putResponse*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOfFileMetaData(struct soap *soap, ArrayOfFileMetaData *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOfFileMetaData(struct soap *soap, ArrayOfFileMetaData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOfFileMetaData);
	if (soap_out_PointerToArrayOfFileMetaData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOfFileMetaData(struct soap *soap, const char *tag, int id, ArrayOfFileMetaData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOfFileMetaData);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOfFileMetaData ** SOAP_FMAC4 soap_get_PointerToArrayOfFileMetaData(struct soap *soap, ArrayOfFileMetaData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOfFileMetaData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOfFileMetaData ** SOAP_FMAC4 soap_in_PointerToArrayOfFileMetaData(struct soap *soap, const char *tag, ArrayOfFileMetaData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOfFileMetaData **)soap_malloc(soap, sizeof(ArrayOfFileMetaData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOfFileMetaData *)soap_instantiate_ArrayOfFileMetaData(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOfFileMetaData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOfFileMetaData, sizeof(ArrayOfFileMetaData), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOfboolean(struct soap *soap, ArrayOfboolean *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOfboolean(struct soap *soap, ArrayOfboolean *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOfboolean);
	if (soap_out_PointerToArrayOfboolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOfboolean(struct soap *soap, const char *tag, int id, ArrayOfboolean *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOfboolean);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOfboolean ** SOAP_FMAC4 soap_get_PointerToArrayOfboolean(struct soap *soap, ArrayOfboolean **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOfboolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOfboolean ** SOAP_FMAC4 soap_in_PointerToArrayOfboolean(struct soap *soap, const char *tag, ArrayOfboolean **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOfboolean **)soap_malloc(soap, sizeof(ArrayOfboolean *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOfboolean *)soap_instantiate_ArrayOfboolean(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOfboolean **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOfboolean, sizeof(ArrayOfboolean), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOflong(struct soap *soap, ArrayOflong *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOflong(struct soap *soap, ArrayOflong *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOflong);
	if (soap_out_PointerToArrayOflong(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOflong(struct soap *soap, const char *tag, int id, ArrayOflong *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOflong);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOflong ** SOAP_FMAC4 soap_get_PointerToArrayOflong(struct soap *soap, ArrayOflong **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOflong(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOflong ** SOAP_FMAC4 soap_in_PointerToArrayOflong(struct soap *soap, const char *tag, ArrayOflong **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOflong **)soap_malloc(soap, sizeof(ArrayOflong *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOflong *)soap_instantiate_ArrayOflong(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOflong **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOflong, sizeof(ArrayOflong), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOfstring(struct soap *soap, ArrayOfstring *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOfstring(struct soap *soap, ArrayOfstring *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOfstring);
	if (soap_out_PointerToArrayOfstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOfstring(struct soap *soap, const char *tag, int id, ArrayOfstring *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOfstring);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOfstring ** SOAP_FMAC4 soap_get_PointerToArrayOfstring(struct soap *soap, ArrayOfstring **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOfstring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOfstring ** SOAP_FMAC4 soap_in_PointerToArrayOfstring(struct soap *soap, const char *tag, ArrayOfstring **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOfstring **)soap_malloc(soap, sizeof(ArrayOfstring *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOfstring *)soap_instantiate_ArrayOfstring(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOfstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOfstring, sizeof(ArrayOfstring), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSRMv1Type__RequestStatus(struct soap *soap, SRMv1Type__RequestStatus *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SRMv1Type__RequestStatus))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSRMv1Type__RequestStatus(struct soap *soap, SRMv1Type__RequestStatus *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSRMv1Type__RequestStatus);
	if (soap_out_PointerToSRMv1Type__RequestStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSRMv1Type__RequestStatus(struct soap *soap, const char *tag, int id, SRMv1Type__RequestStatus *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SRMv1Type__RequestStatus);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 SRMv1Type__RequestStatus ** SOAP_FMAC4 soap_get_PointerToSRMv1Type__RequestStatus(struct soap *soap, SRMv1Type__RequestStatus **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSRMv1Type__RequestStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 SRMv1Type__RequestStatus ** SOAP_FMAC4 soap_in_PointerToSRMv1Type__RequestStatus(struct soap *soap, const char *tag, SRMv1Type__RequestStatus **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (SRMv1Type__RequestStatus **)soap_malloc(soap, sizeof(SRMv1Type__RequestStatus *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (SRMv1Type__RequestStatus *)soap_instantiate_SRMv1Type__RequestStatus(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (SRMv1Type__RequestStatus **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SRMv1Type__RequestStatus, sizeof(SRMv1Type__RequestStatus), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTobool(struct soap *soap, bool *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_bool);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTobool(struct soap *soap, bool *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTobool);
	if (soap_out_PointerTobool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTobool(struct soap *soap, const char *tag, int id, bool *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_bool);
	if (id < 0)
		return soap->error;
	return soap_out_bool(soap, tag, id, *a, type);
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_get_PointerTobool(struct soap *soap, bool **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTobool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_in_PointerTobool(struct soap *soap, const char *tag, bool **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (bool **)soap_malloc(soap, sizeof(bool *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_bool(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (bool **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_bool, sizeof(bool), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToLONG64(struct soap *soap, LONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToLONG64(struct soap *soap, LONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToLONG64);
	if (soap_out_PointerToLONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToLONG64(struct soap *soap, const char *tag, int id, LONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_LONG64);
	if (id < 0)
		return soap->error;
	return soap_out_LONG64(soap, tag, id, *a, type);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_get_PointerToLONG64(struct soap *soap, LONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToLONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_in_PointerToLONG64(struct soap *soap, const char *tag, LONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (LONG64 **)soap_malloc(soap, sizeof(LONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_LONG64(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (LONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_LONG64, sizeof(LONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostring(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_string))
		soap_serialize_string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostring(struct soap *soap, char **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostring);
	if (soap_out_PointerTostring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostring(struct soap *soap, const char *tag, int id, char **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_string);
	if (id < 0)
		return soap->error;
	return soap_out_string(soap, tag, id, *a, type);
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_get_PointerTostring(struct soap *soap, char ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_in_PointerTostring(struct soap *soap, const char *tag, char ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (char ***)soap_malloc(soap, sizeof(char **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (char ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_string, sizeof(char *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToSRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToSRMv1Type__FileMetaData))
		soap_serialize_PointerToSRMv1Type__FileMetaData(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToSRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToSRMv1Type__FileMetaData);
	if (soap_out_PointerToPointerToSRMv1Type__FileMetaData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToSRMv1Type__FileMetaData(struct soap *soap, const char *tag, int id, SRMv1Type__FileMetaData **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToSRMv1Type__FileMetaData);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToSRMv1Type__FileMetaData(soap, tag, id, *a, type);
}

SOAP_FMAC3 SRMv1Type__FileMetaData *** SOAP_FMAC4 soap_get_PointerToPointerToSRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToSRMv1Type__FileMetaData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 SRMv1Type__FileMetaData *** SOAP_FMAC4 soap_in_PointerToPointerToSRMv1Type__FileMetaData(struct soap *soap, const char *tag, SRMv1Type__FileMetaData ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (SRMv1Type__FileMetaData ***)soap_malloc(soap, sizeof(SRMv1Type__FileMetaData **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToSRMv1Type__FileMetaData(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (SRMv1Type__FileMetaData ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToSRMv1Type__FileMetaData, sizeof(SRMv1Type__FileMetaData *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SRMv1Type__FileMetaData))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSRMv1Type__FileMetaData);
	if (soap_out_PointerToSRMv1Type__FileMetaData(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSRMv1Type__FileMetaData(struct soap *soap, const char *tag, int id, SRMv1Type__FileMetaData *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SRMv1Type__FileMetaData);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 SRMv1Type__FileMetaData ** SOAP_FMAC4 soap_get_PointerToSRMv1Type__FileMetaData(struct soap *soap, SRMv1Type__FileMetaData **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSRMv1Type__FileMetaData(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 SRMv1Type__FileMetaData ** SOAP_FMAC4 soap_in_PointerToSRMv1Type__FileMetaData(struct soap *soap, const char *tag, SRMv1Type__FileMetaData **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (SRMv1Type__FileMetaData **)soap_malloc(soap, sizeof(SRMv1Type__FileMetaData *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (SRMv1Type__FileMetaData *)soap_instantiate_SRMv1Type__FileMetaData(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (SRMv1Type__FileMetaData **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SRMv1Type__FileMetaData, sizeof(SRMv1Type__FileMetaData), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToSRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus))
		soap_serialize_PointerToSRMv1Type__RequestFileStatus(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToSRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToSRMv1Type__RequestFileStatus);
	if (soap_out_PointerToPointerToSRMv1Type__RequestFileStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToSRMv1Type__RequestFileStatus(struct soap *soap, const char *tag, int id, SRMv1Type__RequestFileStatus **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToSRMv1Type__RequestFileStatus(soap, tag, id, *a, type);
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus *** SOAP_FMAC4 soap_get_PointerToPointerToSRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToSRMv1Type__RequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus *** SOAP_FMAC4 soap_in_PointerToPointerToSRMv1Type__RequestFileStatus(struct soap *soap, const char *tag, SRMv1Type__RequestFileStatus ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (SRMv1Type__RequestFileStatus ***)soap_malloc(soap, sizeof(SRMv1Type__RequestFileStatus **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToSRMv1Type__RequestFileStatus(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (SRMv1Type__RequestFileStatus ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus, sizeof(SRMv1Type__RequestFileStatus *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SRMv1Type__RequestFileStatus))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSRMv1Type__RequestFileStatus);
	if (soap_out_PointerToSRMv1Type__RequestFileStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSRMv1Type__RequestFileStatus(struct soap *soap, const char *tag, int id, SRMv1Type__RequestFileStatus *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SRMv1Type__RequestFileStatus);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus ** SOAP_FMAC4 soap_get_PointerToSRMv1Type__RequestFileStatus(struct soap *soap, SRMv1Type__RequestFileStatus **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSRMv1Type__RequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 SRMv1Type__RequestFileStatus ** SOAP_FMAC4 soap_in_PointerToSRMv1Type__RequestFileStatus(struct soap *soap, const char *tag, SRMv1Type__RequestFileStatus **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (SRMv1Type__RequestFileStatus **)soap_malloc(soap, sizeof(SRMv1Type__RequestFileStatus *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (SRMv1Type__RequestFileStatus *)soap_instantiate_SRMv1Type__RequestFileStatus(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (SRMv1Type__RequestFileStatus **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SRMv1Type__RequestFileStatus, sizeof(SRMv1Type__RequestFileStatus), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOfRequestFileStatus(struct soap *soap, ArrayOfRequestFileStatus *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOfRequestFileStatus(struct soap *soap, ArrayOfRequestFileStatus *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOfRequestFileStatus);
	if (soap_out_PointerToArrayOfRequestFileStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOfRequestFileStatus(struct soap *soap, const char *tag, int id, ArrayOfRequestFileStatus *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOfRequestFileStatus);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOfRequestFileStatus ** SOAP_FMAC4 soap_get_PointerToArrayOfRequestFileStatus(struct soap *soap, ArrayOfRequestFileStatus **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOfRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOfRequestFileStatus ** SOAP_FMAC4 soap_in_PointerToArrayOfRequestFileStatus(struct soap *soap, const char *tag, ArrayOfRequestFileStatus **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOfRequestFileStatus **)soap_malloc(soap, sizeof(ArrayOfRequestFileStatus *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOfRequestFileStatus *)soap_instantiate_ArrayOfRequestFileStatus(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOfRequestFileStatus **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOfRequestFileStatus, sizeof(ArrayOfRequestFileStatus), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTotime(struct soap *soap, time_t *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_time);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTotime(struct soap *soap, time_t *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTotime);
	if (soap_out_PointerTotime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTotime(struct soap *soap, const char *tag, int id, time_t *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_time);
	if (id < 0)
		return soap->error;
	return soap_out_time(soap, tag, id, *a, type);
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_get_PointerTotime(struct soap *soap, time_t **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTotime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_in_PointerTotime(struct soap *soap, const char *tag, time_t **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (time_t **)soap_malloc(soap, sizeof(time_t *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_time(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (time_t **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_time, sizeof(time_t), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__SOAP_ENC__arrayType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__SOAP_ENC__arrayType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__SOAP_ENC__arrayType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__SOAP_ENC__arrayType);
	if (soap_out__SOAP_ENC__arrayType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__SOAP_ENC__arrayType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__SOAP_ENC__arrayType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__SOAP_ENC__arrayType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__SOAP_ENC__arrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__SOAP_ENC__arrayType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__SOAP_ENC__arrayType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

/* End of srm1_soapC.cpp */
