#include "srm_file_metadata.h"

#include "srm1_soapH.h"
#include "srm2_soapH.h"


SRMFileMetaData::SRMFileMetaData(const SRMv1Type__FileMetaData* metadata) {
  if(metadata == NULL) return;
  size=metadata->size;
  if(metadata->owner) owner=metadata->owner;
  if(metadata->group) group=metadata->group;
  permMode=metadata->permMode;
  if(metadata->checksumType) checksumType=metadata->checksumType;
  if(metadata->checksumValue) checksumValue=metadata->checksumValue;
  isPinned=metadata->isPinned;
  isPermanent=metadata->isPermanent;
  isCached=metadata->isPermanent;
}

SRMFileMetaData::SRMFileMetaData(void):size(0),permMode(0),isPinned(false),isPermanent(false),isCached(false) {
}

SRMv1Type__FileMetaData* SRMFileMetaData::V1(struct soap* soap) const {
  SRMv1Type__FileMetaData* metadata = NULL;
  if(soap == NULL) return NULL;
  metadata=soap_new_SRMv1Type__FileMetaData(soap,-1);
  if(metadata == NULL) return NULL;
  metadata->soap_default(soap);
  metadata->size=size;
  if(!owner.empty()) metadata->owner=soap_strdup(soap,owner.c_str());
  if(!group.empty()) metadata->group=soap_strdup(soap,group.c_str());
  metadata->permMode=permMode;
  if(!checksumType.empty()) metadata->checksumType=soap_strdup(soap,checksumType.c_str());
  if(!checksumValue.empty()) metadata->checksumValue=soap_strdup(soap,checksumValue.c_str());
  return metadata;
}


