#include <string>
#include <iostream>

#include "../server/service_soap.h"
#include "srm_request.h"
#include "srm1_soapH.h"
#include "srm2_soapH.h"

HTTP_Service* srm_proxy_service_creator(HTTP_Connector& c,const char* uri,void* arg);
bool srm_proxy_service_configurator(std::istream& f,const char* uri,HTTP_Service_Properties &prop);

class HTTP_SRM_Proxy_Handle;
struct soap;
//class ArrayOfstring;
//class ArrayOfboolean;
//class ArrayOflong;
//struct SRMv1Meth__getResponse;
//struct SRMv1Meth__putResponse;
//class SRMv2__srmLsRequest;
//struct SRMv2__srmLsResponse_;
//class SRMv2__srmSetPermissionRequest;
//struct SRMv2__srmSetPermissionResponse_;

class HTTP_SRM_Proxy: public HTTP_ServiceAdv {
 friend int SRMv1Meth__get(struct soap*,ArrayOfstring*,ArrayOfstring*,
                     struct SRMv1Meth__getResponse&);
 friend int SRMv1Meth__put(struct soap*,ArrayOfstring*,ArrayOfstring*,
                     ArrayOflong*,ArrayOfboolean*,ArrayOfstring*,
                     struct SRMv1Meth__putResponse&);
 friend int SRMv1Meth__pin(struct soap*,ArrayOfstring*,
                     struct SRMv1Meth__pinResponse&);
 friend int SRMv1Meth__unPin(struct soap*,ArrayOfstring*,int,
                     struct SRMv1Meth__unPinResponse&);
 friend int SRMv1Meth__advisoryDelete(struct soap*,ArrayOfstring*,
                     struct SRMv1Meth__advisoryDeleteResponse&);
 friend int SRMv1Meth__getFileMetaData(struct soap*,ArrayOfstring*,
                     struct SRMv1Meth__getFileMetaDataResponse&);
 friend int SRMv1Meth__getProtocols(struct soap*,
                     struct SRMv1Meth__getProtocolsResponse&);
 friend int SRMv1Meth__mkPermanent(struct soap*,ArrayOfstring*,
                     struct SRMv1Meth__mkPermanentResponse&);
 friend int SRMv1Meth__getEstGetTime(struct soap*,ArrayOfstring*,ArrayOfstring*,
                     struct SRMv1Meth__getEstGetTimeResponse&);
 friend int SRMv1Meth__getEstPutTime(struct soap*,ArrayOfstring*,ArrayOfstring*,
                     ArrayOflong*,ArrayOfboolean*,ArrayOfstring*,
                     struct SRMv1Meth__getEstPutTimeResponse&);
 friend int SRMv1Meth__copy(struct soap*,ArrayOfstring*,ArrayOfstring*,
                     ArrayOfboolean*,struct SRMv1Meth__copyResponse&);
 friend int SRMv1Meth__setFileStatus(struct soap*,int,int,char*,
                     struct SRMv1Meth__setFileStatusResponse&);
 friend int SRMv1Meth__getRequestStatus(struct soap*,int,
                     struct SRMv1Meth__getRequestStatusResponse& r);
 //friend int SRMv2__srmLs(struct soap*,SRMv2__srmLsRequest*,
 //                    struct SRMv2__srmLsResponse_&);
 //friend int SRMv2__srmRm(struct soap*,SRMv2__srmRmRequest*,
 //                    struct SRMv2__srmRmResponse_&);
 //friend int SRMv2__srmSetPermission(struct soap*,
 //                    SRMv2__srmSetPermissionRequest*,
 //                    struct SRMv2__srmSetPermissionResponse_&);
 //friend int SRMv2__srmRmdir(struct soap* sp,
 //                    SRMv2__srmRmdirRequest *req,
 //                    struct SRMv2__srmRmdirResponse_ &resp);
 private:
  std::string service_url;
  SRMRequests* requests;
 public:
  HTTP_SRM_Proxy(HTTP_Connector *c,HTTP_SRM_Proxy_Handle* h);
  virtual ~HTTP_SRM_Proxy(void);
  virtual HTTP_Error get(const char* uri,int &keep_alive);
  virtual HTTP_Error put(const char* uri,int &keep_alive);
  virtual HTTP_Error post(const char* uri,int &keep_alive);
  virtual void soap_methods(void);
};
