#ifndef __ARC_SRM_REQUEST_H__
#define __ARC_SRM_REQUEST_H__

#include <string>
#include <list>
#include <stdsoap2.h>

#include "../../misc/safepointer.h"
#include "srm_url.h"
#include "srm_remote_request.h"
#include "srm_file.h"

class SRMRequests;
class SRMEndpoint;
class SRMFileMetaData;
class SRMFileStatus;

class SRMLocalRequest {
 friend class SRMRequests;
 friend class SRMRequest;
 private:
  std::list<SRMFile> files;
  std::list<SRMRemoteRequest> requests;
  std::string command;
  std::string id;
  SRMRequests& parent;
 public:
  SRMLocalRequest(SRMRequests& r):parent(r) { };
  ~SRMLocalRequest(void);
  void GetEndpoints(std::list<SRMEndpoint*> endpoints);
  void GetFiles(SRMEndpoint* endpoint,std::list<SRMFile*>& files);
  const SRMFile* GetFile(const std::string& requestid,const std::string& fileid);
  const std::list<SRMFile>& GetFiles(void) const { return files; };
  const SRMFile* GetFile(const std::string& id);
  const std::list<SRMRemoteRequest>& GetRequests(void) const { return requests; };
  const std::string& GetID(void) const { return id; };
  const std::string& GetCommand(void) const { return command; };
  bool FindFiles(bool delete_unknown = true);
};

class SRMRequest: private SafePointer<SRMLocalRequest> {
 public:
  SRMRequest(void) { };
  SRMRequest(SRMLocalRequest& lr):SafePointer<SRMLocalRequest>(&lr) { };
  SRMLocalRequest& operator*(void) const { return SafePointer<SRMLocalRequest>::operator*(); };
  SRMLocalRequest* operator->(void) const { return SafePointer<SRMLocalRequest>::operator->(); };
  operator bool(void) const { return SafePointer<SRMLocalRequest>::operator bool(); };
  // SRM Methods
  bool V1_get(std::list<std::string> protocols);
  bool V1_copy(void);
  void V1_ping(void);
  bool V1_pin(void);
  bool V1_unPin(void);
  bool V1_mkPermanent(void);
  bool V1_getEstGetTime(std::list<std::string> protocols);
  bool V1_getEstPutTime(std::list<std::string> protocols);
  bool V1_put(std::list<std::string> protocols);
  bool V1_setFileStatus(const std::string& fileid,const std::string& state);
  bool V1_getRequestStatus(void);
  bool V1_getProtocols(std::list<std::string>& protocols);
  bool V1_advisoryDelete(void);
  bool V1_getFileMetaData(void);
};

class SRMRequests {
 friend class SRMRequest;
 private:
  std::list<SRMEndpoint> endpoints;
  std::string path;
  // Store request locally.
  bool ForgetRequest(SRMRequest r);
  SRMRemoteRequest* FillFileRequest(SRMLocalRequest& req,const std::string file_request_id,const std::string file_request_url,const char* credentials = NULL);
 public:
  // Generate request based on information from client.
  // Use for simple methods and methods initiating requests.
  SRMRequest MakeRequest(const char* cmd,const std::list<std::string>& fileids,bool with_remote = false,const char* credentials = NULL);
  bool RememberRequest(SRMRequest r);
  bool RecallRequest(SRMRequest r,const char* credentials = NULL);
  // Obtain link to already generated request.
  SRMRequest GetRequest(const std::string& reqid,const char* credentials = NULL);
  void GetEndpoints(const std::string& fileid,std::list<SRMEndpoint*> endpoints);
  //SRMEndpoint* GetEndpoint(const std::string& url);
 public:
  SRMRequests(const char* path);
  void AddEndpoint(const SRMEndpoint& endpoint) { endpoints.push_back(endpoint); };
  void Path(const char* path_) { path=path_; };
};

#endif // __ARC_SRM_REQUEST_H__
