/* fireman_soapC.cpp
   Generated by gSOAP 2.7.8a from fireman_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "fireman_soapH.h"

SOAP_SOURCE_STAMP("@(#) fireman_soapC.cpp ver 2.7.8a 2009-04-06 10:46:43 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_glite__StringBoolean:
		return soap_in_glite__StringBoolean(soap, NULL, NULL, "glite:StringBoolean");
	case SOAP_TYPE_glite__Attribute:
		return soap_in_glite__Attribute(soap, NULL, NULL, "glite:Attribute");
	case SOAP_TYPE_glite__PermissionEntry:
		return soap_in_glite__PermissionEntry(soap, NULL, NULL, "glite:PermissionEntry");
	case SOAP_TYPE_glite__FCEntry:
		return soap_in_glite__FCEntry(soap, NULL, NULL, "glite:FCEntry");
	case SOAP_TYPE_glite__StringPair:
		return soap_in_glite__StringPair(soap, NULL, NULL, "glite:StringPair");
	case SOAP_TYPE_glite__ExistsException:
		return soap_in_glite__ExistsException(soap, NULL, NULL, "glite:ExistsException");
	case SOAP_TYPE_glite__FRCEntry:
		return soap_in_glite__FRCEntry(soap, NULL, NULL, "glite:FRCEntry");
	case SOAP_TYPE_glite__LFNStat:
		return soap_in_glite__LFNStat(soap, NULL, NULL, "glite:LFNStat");
	case SOAP_TYPE_glite__RCEntry:
		return soap_in_glite__RCEntry(soap, NULL, NULL, "glite:RCEntry");
	case SOAP_TYPE_glite__SURLEntry:
		return soap_in_glite__SURLEntry(soap, NULL, NULL, "glite:SURLEntry");
	case SOAP_TYPE_glite__Permission:
		return soap_in_glite__Permission(soap, NULL, NULL, "glite:Permission");
	case SOAP_TYPE_glite__ACLEntry:
		return soap_in_glite__ACLEntry(soap, NULL, NULL, "glite:ACLEntry");
	case SOAP_TYPE_glite__BasicPermission:
		return soap_in_glite__BasicPermission(soap, NULL, NULL, "glite:BasicPermission");
	case SOAP_TYPE_glite__Perm:
		return soap_in_glite__Perm(soap, NULL, NULL, "glite:Perm");
	case SOAP_TYPE_glite__GUIDStat:
		return soap_in_glite__GUIDStat(soap, NULL, NULL, "glite:GUIDStat");
	case SOAP_TYPE_glite__Stat:
		return soap_in_glite__Stat(soap, NULL, NULL, "glite:Stat");
	case SOAP_TYPE_glite__InvalidArgumentException:
		return soap_in_glite__InvalidArgumentException(soap, NULL, NULL, "glite:InvalidArgumentException");
	case SOAP_TYPE_glite__NotExistsException:
		return soap_in_glite__NotExistsException(soap, NULL, NULL, "glite:NotExistsException");
	case SOAP_TYPE_glite__AuthorizationException:
		return soap_in_glite__AuthorizationException(soap, NULL, NULL, "glite:AuthorizationException");
	case SOAP_TYPE_glite__InternalException:
		return soap_in_glite__InternalException(soap, NULL, NULL, "glite:InternalException");
	case SOAP_TYPE_glite__CatalogException:
		return soap_in_glite__CatalogException(soap, NULL, NULL, "glite:CatalogException");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean:
		return soap_in_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, NULL, NULL, "glite:StringBoolean");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat:
		return soap_in_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, NULL, NULL, "glite:GUIDStat");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry:
		return soap_in_ArrayOf_USCOREtns1_USCORERCEntry(soap, NULL, NULL, "glite:RCEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute:
		return soap_in_ArrayOf_USCOREtns1_USCOREAttribute(soap, NULL, NULL, "glite:Attribute");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry:
		return soap_in_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, NULL, NULL, "glite:PermissionEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry:
		return soap_in_ArrayOf_USCOREtns1_USCOREFCEntry(soap, NULL, NULL, "glite:FCEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry:
		return soap_in_ArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, NULL, "glite:SURLEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat:
		return soap_in_ArrayOf_USCOREtns1_USCOREStat(soap, NULL, NULL, "glite:Stat");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair:
		return soap_in_ArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, NULL, "glite:StringPair");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry:
		return soap_in_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, NULL, NULL, "glite:FRCEntry");
	case SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring:
		return soap_in_ArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_fireman__getDefaultGlobalPermission:
		return soap_in_fireman__getDefaultGlobalPermission(soap, NULL, NULL, "fireman:getDefaultGlobalPermission");
	case SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse:
		return soap_in_fireman__getDefaultGlobalPermissionResponse(soap, NULL, NULL, "fireman:getDefaultGlobalPermissionResponse");
	case SOAP_TYPE_fireman__getDefaultPrincipalPermission:
		return soap_in_fireman__getDefaultPrincipalPermission(soap, NULL, NULL, "fireman:getDefaultPrincipalPermission");
	case SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse:
		return soap_in_fireman__getDefaultPrincipalPermissionResponse(soap, NULL, NULL, "fireman:getDefaultPrincipalPermissionResponse");
	case SOAP_TYPE_fireman__getSurlStat:
		return soap_in_fireman__getSurlStat(soap, NULL, NULL, "fireman:getSurlStat");
	case SOAP_TYPE_fireman__getSurlStatResponse:
		return soap_in_fireman__getSurlStatResponse(soap, NULL, NULL, "fireman:getSurlStatResponse");
	case SOAP_TYPE_fireman__getGuidStat:
		return soap_in_fireman__getGuidStat(soap, NULL, NULL, "fireman:getGuidStat");
	case SOAP_TYPE_fireman__getGuidStatResponse:
		return soap_in_fireman__getGuidStatResponse(soap, NULL, NULL, "fireman:getGuidStatResponse");
	case SOAP_TYPE_fireman__hasGuid:
		return soap_in_fireman__hasGuid(soap, NULL, NULL, "fireman:hasGuid");
	case SOAP_TYPE_fireman__hasGuidResponse:
		return soap_in_fireman__hasGuidResponse(soap, NULL, NULL, "fireman:hasGuidResponse");
	case SOAP_TYPE_fireman__listReplicasByGuid:
		return soap_in_fireman__listReplicasByGuid(soap, NULL, NULL, "fireman:listReplicasByGuid");
	case SOAP_TYPE_fireman__listReplicasByGuidResponse:
		return soap_in_fireman__listReplicasByGuidResponse(soap, NULL, NULL, "fireman:listReplicasByGuidResponse");
	case SOAP_TYPE_fireman__listSurlsByGuid:
		return soap_in_fireman__listSurlsByGuid(soap, NULL, NULL, "fireman:listSurlsByGuid");
	case SOAP_TYPE_fireman__listSurlsByGuidResponse:
		return soap_in_fireman__listSurlsByGuidResponse(soap, NULL, NULL, "fireman:listSurlsByGuidResponse");
	case SOAP_TYPE_fireman__getMasterReplica:
		return soap_in_fireman__getMasterReplica(soap, NULL, NULL, "fireman:getMasterReplica");
	case SOAP_TYPE_fireman__getMasterReplicaResponse:
		return soap_in_fireman__getMasterReplicaResponse(soap, NULL, NULL, "fireman:getMasterReplicaResponse");
	case SOAP_TYPE_fireman__getGuidForSurl:
		return soap_in_fireman__getGuidForSurl(soap, NULL, NULL, "fireman:getGuidForSurl");
	case SOAP_TYPE_fireman__getGuidForSurlResponse:
		return soap_in_fireman__getGuidForSurlResponse(soap, NULL, NULL, "fireman:getGuidForSurlResponse");
	case SOAP_TYPE_fireman__setDefaultGlobalPermission:
		return soap_in_fireman__setDefaultGlobalPermission(soap, NULL, NULL, "fireman:setDefaultGlobalPermission");
	case SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse:
		return soap_in_fireman__setDefaultGlobalPermissionResponse(soap, NULL, NULL, "fireman:setDefaultGlobalPermissionResponse");
	case SOAP_TYPE_fireman__setDefaultPrincipalPermission:
		return soap_in_fireman__setDefaultPrincipalPermission(soap, NULL, NULL, "fireman:setDefaultPrincipalPermission");
	case SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse:
		return soap_in_fireman__setDefaultPrincipalPermissionResponse(soap, NULL, NULL, "fireman:setDefaultPrincipalPermissionResponse");
	case SOAP_TYPE_fireman__removeGuid:
		return soap_in_fireman__removeGuid(soap, NULL, NULL, "fireman:removeGuid");
	case SOAP_TYPE_fireman__removeGuidResponse:
		return soap_in_fireman__removeGuidResponse(soap, NULL, NULL, "fireman:removeGuidResponse");
	case SOAP_TYPE_fireman__removeGuidReplica:
		return soap_in_fireman__removeGuidReplica(soap, NULL, NULL, "fireman:removeGuidReplica");
	case SOAP_TYPE_fireman__removeGuidReplicaResponse:
		return soap_in_fireman__removeGuidReplicaResponse(soap, NULL, NULL, "fireman:removeGuidReplicaResponse");
	case SOAP_TYPE_fireman__setMasterReplica:
		return soap_in_fireman__setMasterReplica(soap, NULL, NULL, "fireman:setMasterReplica");
	case SOAP_TYPE_fireman__setMasterReplicaResponse:
		return soap_in_fireman__setMasterReplicaResponse(soap, NULL, NULL, "fireman:setMasterReplicaResponse");
	case SOAP_TYPE_fireman__updateSurlStat:
		return soap_in_fireman__updateSurlStat(soap, NULL, NULL, "fireman:updateSurlStat");
	case SOAP_TYPE_fireman__updateSurlStatResponse:
		return soap_in_fireman__updateSurlStatResponse(soap, NULL, NULL, "fireman:updateSurlStatResponse");
	case SOAP_TYPE_fireman__updateGuidStat:
		return soap_in_fireman__updateGuidStat(soap, NULL, NULL, "fireman:updateGuidStat");
	case SOAP_TYPE_fireman__updateGuidStatResponse:
		return soap_in_fireman__updateGuidStatResponse(soap, NULL, NULL, "fireman:updateGuidStatResponse");
	case SOAP_TYPE_fireman__addGuidReplica:
		return soap_in_fireman__addGuidReplica(soap, NULL, NULL, "fireman:addGuidReplica");
	case SOAP_TYPE_fireman__addGuidReplicaResponse:
		return soap_in_fireman__addGuidReplicaResponse(soap, NULL, NULL, "fireman:addGuidReplicaResponse");
	case SOAP_TYPE_fireman__createGuid:
		return soap_in_fireman__createGuid(soap, NULL, NULL, "fireman:createGuid");
	case SOAP_TYPE_fireman__createGuidResponse:
		return soap_in_fireman__createGuidResponse(soap, NULL, NULL, "fireman:createGuidResponse");
	case SOAP_TYPE_fireman__updateStatus:
		return soap_in_fireman__updateStatus(soap, NULL, NULL, "fireman:updateStatus");
	case SOAP_TYPE_fireman__updateStatusResponse:
		return soap_in_fireman__updateStatusResponse(soap, NULL, NULL, "fireman:updateStatusResponse");
	case SOAP_TYPE_fireman__listAttributes:
		return soap_in_fireman__listAttributes(soap, NULL, NULL, "fireman:listAttributes");
	case SOAP_TYPE_fireman__listAttributesResponse:
		return soap_in_fireman__listAttributesResponse(soap, NULL, NULL, "fireman:listAttributesResponse");
	case SOAP_TYPE_fireman__clearAttributes:
		return soap_in_fireman__clearAttributes(soap, NULL, NULL, "fireman:clearAttributes");
	case SOAP_TYPE_fireman__clearAttributesResponse:
		return soap_in_fireman__clearAttributesResponse(soap, NULL, NULL, "fireman:clearAttributesResponse");
	case SOAP_TYPE_fireman__setAttributes:
		return soap_in_fireman__setAttributes(soap, NULL, NULL, "fireman:setAttributes");
	case SOAP_TYPE_fireman__setAttributesResponse:
		return soap_in_fireman__setAttributesResponse(soap, NULL, NULL, "fireman:setAttributesResponse");
	case SOAP_TYPE_fireman__query:
		return soap_in_fireman__query(soap, NULL, NULL, "fireman:query");
	case SOAP_TYPE_fireman__queryResponse:
		return soap_in_fireman__queryResponse(soap, NULL, NULL, "fireman:queryResponse");
	case SOAP_TYPE_fireman__getAttributes:
		return soap_in_fireman__getAttributes(soap, NULL, NULL, "fireman:getAttributes");
	case SOAP_TYPE_fireman__getAttributesResponse:
		return soap_in_fireman__getAttributesResponse(soap, NULL, NULL, "fireman:getAttributesResponse");
	case SOAP_TYPE_fireman__getServiceMetadata:
		return soap_in_fireman__getServiceMetadata(soap, NULL, NULL, "fireman:getServiceMetadata");
	case SOAP_TYPE_fireman__getServiceMetadataResponse:
		return soap_in_fireman__getServiceMetadataResponse(soap, NULL, NULL, "fireman:getServiceMetadataResponse");
	case SOAP_TYPE_fireman__getInterfaceVersion:
		return soap_in_fireman__getInterfaceVersion(soap, NULL, NULL, "fireman:getInterfaceVersion");
	case SOAP_TYPE_fireman__getInterfaceVersionResponse:
		return soap_in_fireman__getInterfaceVersionResponse(soap, NULL, NULL, "fireman:getInterfaceVersionResponse");
	case SOAP_TYPE_fireman__getSchemaVersion:
		return soap_in_fireman__getSchemaVersion(soap, NULL, NULL, "fireman:getSchemaVersion");
	case SOAP_TYPE_fireman__getSchemaVersionResponse:
		return soap_in_fireman__getSchemaVersionResponse(soap, NULL, NULL, "fireman:getSchemaVersionResponse");
	case SOAP_TYPE_fireman__getVersion:
		return soap_in_fireman__getVersion(soap, NULL, NULL, "fireman:getVersion");
	case SOAP_TYPE_fireman__getVersionResponse:
		return soap_in_fireman__getVersionResponse(soap, NULL, NULL, "fireman:getVersionResponse");
	case SOAP_TYPE_fireman__setPermission:
		return soap_in_fireman__setPermission(soap, NULL, NULL, "fireman:setPermission");
	case SOAP_TYPE_fireman__setPermissionResponse:
		return soap_in_fireman__setPermissionResponse(soap, NULL, NULL, "fireman:setPermissionResponse");
	case SOAP_TYPE_fireman__getPermission:
		return soap_in_fireman__getPermission(soap, NULL, NULL, "fireman:getPermission");
	case SOAP_TYPE_fireman__getPermissionResponse:
		return soap_in_fireman__getPermissionResponse(soap, NULL, NULL, "fireman:getPermissionResponse");
	case SOAP_TYPE_fireman__checkPermission:
		return soap_in_fireman__checkPermission(soap, NULL, NULL, "fireman:checkPermission");
	case SOAP_TYPE_fireman__checkPermissionResponse:
		return soap_in_fireman__checkPermissionResponse(soap, NULL, NULL, "fireman:checkPermissionResponse");
	case SOAP_TYPE_fireman__getFileCatalogEntry:
		return soap_in_fireman__getFileCatalogEntry(soap, NULL, NULL, "fireman:getFileCatalogEntry");
	case SOAP_TYPE_fireman__getFileCatalogEntryResponse:
		return soap_in_fireman__getFileCatalogEntryResponse(soap, NULL, NULL, "fireman:getFileCatalogEntryResponse");
	case SOAP_TYPE_fireman__getLfnForGuid:
		return soap_in_fireman__getLfnForGuid(soap, NULL, NULL, "fireman:getLfnForGuid");
	case SOAP_TYPE_fireman__getLfnForGuidResponse:
		return soap_in_fireman__getLfnForGuidResponse(soap, NULL, NULL, "fireman:getLfnForGuidResponse");
	case SOAP_TYPE_fireman__getGuidForLfn:
		return soap_in_fireman__getGuidForLfn(soap, NULL, NULL, "fireman:getGuidForLfn");
	case SOAP_TYPE_fireman__getGuidForLfnResponse:
		return soap_in_fireman__getGuidForLfnResponse(soap, NULL, NULL, "fireman:getGuidForLfnResponse");
	case SOAP_TYPE_fireman__readDir:
		return soap_in_fireman__readDir(soap, NULL, NULL, "fireman:readDir");
	case SOAP_TYPE_fireman__readDirResponse:
		return soap_in_fireman__readDirResponse(soap, NULL, NULL, "fireman:readDirResponse");
	case SOAP_TYPE_fireman__updateValidityTime:
		return soap_in_fireman__updateValidityTime(soap, NULL, NULL, "fireman:updateValidityTime");
	case SOAP_TYPE_fireman__updateValidityTimeResponse:
		return soap_in_fireman__updateValidityTimeResponse(soap, NULL, NULL, "fireman:updateValidityTimeResponse");
	case SOAP_TYPE_fireman__updateModifyTime:
		return soap_in_fireman__updateModifyTime(soap, NULL, NULL, "fireman:updateModifyTime");
	case SOAP_TYPE_fireman__updateModifyTimeResponse:
		return soap_in_fireman__updateModifyTimeResponse(soap, NULL, NULL, "fireman:updateModifyTimeResponse");
	case SOAP_TYPE_fireman__mv:
		return soap_in_fireman__mv(soap, NULL, NULL, "fireman:mv");
	case SOAP_TYPE_fireman__mvResponse:
		return soap_in_fireman__mvResponse(soap, NULL, NULL, "fireman:mvResponse");
	case SOAP_TYPE_fireman__unlink:
		return soap_in_fireman__unlink(soap, NULL, NULL, "fireman:unlink");
	case SOAP_TYPE_fireman__unlinkResponse:
		return soap_in_fireman__unlinkResponse(soap, NULL, NULL, "fireman:unlinkResponse");
	case SOAP_TYPE_fireman__createFile:
		return soap_in_fireman__createFile(soap, NULL, NULL, "fireman:createFile");
	case SOAP_TYPE_fireman__createFileResponse:
		return soap_in_fireman__createFileResponse(soap, NULL, NULL, "fireman:createFileResponse");
	case SOAP_TYPE_fireman__rmdir:
		return soap_in_fireman__rmdir(soap, NULL, NULL, "fireman:rmdir");
	case SOAP_TYPE_fireman__rmdirResponse:
		return soap_in_fireman__rmdirResponse(soap, NULL, NULL, "fireman:rmdirResponse");
	case SOAP_TYPE_fireman__symlink:
		return soap_in_fireman__symlink(soap, NULL, NULL, "fireman:symlink");
	case SOAP_TYPE_fireman__symlinkResponse:
		return soap_in_fireman__symlinkResponse(soap, NULL, NULL, "fireman:symlinkResponse");
	case SOAP_TYPE_fireman__locate:
		return soap_in_fireman__locate(soap, NULL, NULL, "fireman:locate");
	case SOAP_TYPE_fireman__locateResponse:
		return soap_in_fireman__locateResponse(soap, NULL, NULL, "fireman:locateResponse");
	case SOAP_TYPE_fireman__mkdir:
		return soap_in_fireman__mkdir(soap, NULL, NULL, "fireman:mkdir");
	case SOAP_TYPE_fireman__mkdirResponse:
		return soap_in_fireman__mkdirResponse(soap, NULL, NULL, "fireman:mkdirResponse");
	case SOAP_TYPE_fireman__associateDirWithSchema:
		return soap_in_fireman__associateDirWithSchema(soap, NULL, NULL, "fireman:associateDirWithSchema");
	case SOAP_TYPE_fireman__associateDirWithSchemaResponse:
		return soap_in_fireman__associateDirWithSchemaResponse(soap, NULL, NULL, "fireman:associateDirWithSchemaResponse");
	case SOAP_TYPE_fireman__removeReplica:
		return soap_in_fireman__removeReplica(soap, NULL, NULL, "fireman:removeReplica");
	case SOAP_TYPE_fireman__removeReplicaResponse:
		return soap_in_fireman__removeReplicaResponse(soap, NULL, NULL, "fireman:removeReplicaResponse");
	case SOAP_TYPE_fireman__addReplica:
		return soap_in_fireman__addReplica(soap, NULL, NULL, "fireman:addReplica");
	case SOAP_TYPE_fireman__addReplicaResponse:
		return soap_in_fireman__addReplicaResponse(soap, NULL, NULL, "fireman:addReplicaResponse");
	case SOAP_TYPE_fireman__getStat:
		return soap_in_fireman__getStat(soap, NULL, NULL, "fireman:getStat");
	case SOAP_TYPE_fireman__getStatResponse:
		return soap_in_fireman__getStatResponse(soap, NULL, NULL, "fireman:getStatResponse");
	case SOAP_TYPE_fireman__listLfn:
		return soap_in_fireman__listLfn(soap, NULL, NULL, "fireman:listLfn");
	case SOAP_TYPE_fireman__listLfnResponse:
		return soap_in_fireman__listLfnResponse(soap, NULL, NULL, "fireman:listLfnResponse");
	case SOAP_TYPE_fireman__listReplicas:
		return soap_in_fireman__listReplicas(soap, NULL, NULL, "fireman:listReplicas");
	case SOAP_TYPE_fireman__listReplicasResponse:
		return soap_in_fireman__listReplicasResponse(soap, NULL, NULL, "fireman:listReplicasResponse");
	case SOAP_TYPE_fireman__create:
		return soap_in_fireman__create(soap, NULL, NULL, "fireman:create");
	case SOAP_TYPE_fireman__createResponse:
		return soap_in_fireman__createResponse(soap, NULL, NULL, "fireman:createResponse");
	case SOAP_TYPE_fireman__remove:
		return soap_in_fireman__remove(soap, NULL, NULL, "fireman:remove");
	case SOAP_TYPE_fireman__removeResponse:
		return soap_in_fireman__removeResponse(soap, NULL, NULL, "fireman:removeResponse");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringBoolean:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, NULL, NULL, "glite:StringBoolean");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREGUIDStat:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, NULL, NULL, "glite:GUIDStat");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERCEntry:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, NULL, NULL, "glite:RCEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREAttribute:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, NULL, NULL, "glite:Attribute");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, NULL, NULL, "glite:PermissionEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFCEntry:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, NULL, NULL, "glite:FCEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORESURLEntry:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, NULL, "glite:SURLEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStat:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREStat(soap, NULL, NULL, "glite:Stat");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringPair:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, NULL, "glite:StringPair");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFRCEntry:
		return soap_in_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, NULL, NULL, "glite:FRCEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREsoapenc_USCOREstring:
		return soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToglite__NotExistsException:
		return soap_in_PointerToglite__NotExistsException(soap, NULL, NULL, "glite:NotExistsException");
	case SOAP_TYPE_PointerToglite__InvalidArgumentException:
		return soap_in_PointerToglite__InvalidArgumentException(soap, NULL, NULL, "glite:InvalidArgumentException");
	case SOAP_TYPE_PointerToglite__InternalException:
		return soap_in_PointerToglite__InternalException(soap, NULL, NULL, "glite:InternalException");
	case SOAP_TYPE_PointerToglite__ExistsException:
		return soap_in_PointerToglite__ExistsException(soap, NULL, NULL, "glite:ExistsException");
	case SOAP_TYPE_PointerToglite__AuthorizationException:
		return soap_in_PointerToglite__AuthorizationException(soap, NULL, NULL, "glite:AuthorizationException");
	case SOAP_TYPE_PointerToPointerToglite__ACLEntry:
		return soap_in_PointerToPointerToglite__ACLEntry(soap, NULL, NULL, "glite:ACLEntry");
	case SOAP_TYPE_PointerToglite__ACLEntry:
		return soap_in_PointerToglite__ACLEntry(soap, NULL, NULL, "glite:ACLEntry");
	case SOAP_TYPE_PointerToPointerToglite__StringBoolean:
		return soap_in_PointerToPointerToglite__StringBoolean(soap, NULL, NULL, "glite:StringBoolean");
	case SOAP_TYPE_PointerToglite__StringBoolean:
		return soap_in_PointerToglite__StringBoolean(soap, NULL, NULL, "glite:StringBoolean");
	case SOAP_TYPE_PointerToPointerToglite__GUIDStat:
		return soap_in_PointerToPointerToglite__GUIDStat(soap, NULL, NULL, "glite:GUIDStat");
	case SOAP_TYPE_PointerToPointerToglite__RCEntry:
		return soap_in_PointerToPointerToglite__RCEntry(soap, NULL, NULL, "glite:RCEntry");
	case SOAP_TYPE_PointerToglite__RCEntry:
		return soap_in_PointerToglite__RCEntry(soap, NULL, NULL, "glite:RCEntry");
	case SOAP_TYPE_PointerToPointerToglite__Attribute:
		return soap_in_PointerToPointerToglite__Attribute(soap, NULL, NULL, "glite:Attribute");
	case SOAP_TYPE_PointerToglite__Attribute:
		return soap_in_PointerToglite__Attribute(soap, NULL, NULL, "glite:Attribute");
	case SOAP_TYPE_PointerToPointerToglite__PermissionEntry:
		return soap_in_PointerToPointerToglite__PermissionEntry(soap, NULL, NULL, "glite:PermissionEntry");
	case SOAP_TYPE_PointerToglite__PermissionEntry:
		return soap_in_PointerToglite__PermissionEntry(soap, NULL, NULL, "glite:PermissionEntry");
	case SOAP_TYPE_PointerToPointerToglite__FCEntry:
		return soap_in_PointerToPointerToglite__FCEntry(soap, NULL, NULL, "glite:FCEntry");
	case SOAP_TYPE_PointerToglite__FCEntry:
		return soap_in_PointerToglite__FCEntry(soap, NULL, NULL, "glite:FCEntry");
	case SOAP_TYPE_PointerToPointerToglite__Stat:
		return soap_in_PointerToPointerToglite__Stat(soap, NULL, NULL, "glite:Stat");
	case SOAP_TYPE_PointerToglite__Stat:
		return soap_in_PointerToglite__Stat(soap, NULL, NULL, "glite:Stat");
	case SOAP_TYPE_PointerToPointerToglite__StringPair:
		return soap_in_PointerToPointerToglite__StringPair(soap, NULL, NULL, "glite:StringPair");
	case SOAP_TYPE_PointerToglite__StringPair:
		return soap_in_PointerToglite__StringPair(soap, NULL, NULL, "glite:StringPair");
	case SOAP_TYPE_PointerToPointerToglite__FRCEntry:
		return soap_in_PointerToPointerToglite__FRCEntry(soap, NULL, NULL, "glite:FRCEntry");
	case SOAP_TYPE_PointerToglite__FRCEntry:
		return soap_in_PointerToglite__FRCEntry(soap, NULL, NULL, "glite:FRCEntry");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToglite__LFNStat:
		return soap_in_PointerToglite__LFNStat(soap, NULL, NULL, "glite:LFNStat");
	case SOAP_TYPE_PointerToPointerToglite__SURLEntry:
		return soap_in_PointerToPointerToglite__SURLEntry(soap, NULL, NULL, "glite:SURLEntry");
	case SOAP_TYPE_PointerToglite__SURLEntry:
		return soap_in_PointerToglite__SURLEntry(soap, NULL, NULL, "glite:SURLEntry");
	case SOAP_TYPE_PointerToglite__Permission:
		return soap_in_PointerToglite__Permission(soap, NULL, NULL, "glite:Permission");
	case SOAP_TYPE_PointerToglite__GUIDStat:
		return soap_in_PointerToglite__GUIDStat(soap, NULL, NULL, "glite:GUIDStat");
	case SOAP_TYPE_PointerToglite__Perm:
		return soap_in_PointerToglite__Perm(soap, NULL, NULL, "glite:Perm");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:StringBoolean"))
		{	*type = SOAP_TYPE_glite__StringBoolean;
			return soap_in_glite__StringBoolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:Attribute"))
		{	*type = SOAP_TYPE_glite__Attribute;
			return soap_in_glite__Attribute(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:PermissionEntry"))
		{	*type = SOAP_TYPE_glite__PermissionEntry;
			return soap_in_glite__PermissionEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:FCEntry"))
		{	*type = SOAP_TYPE_glite__FCEntry;
			return soap_in_glite__FCEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:StringPair"))
		{	*type = SOAP_TYPE_glite__StringPair;
			return soap_in_glite__StringPair(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:ExistsException"))
		{	*type = SOAP_TYPE_glite__ExistsException;
			return soap_in_glite__ExistsException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:FRCEntry"))
		{	*type = SOAP_TYPE_glite__FRCEntry;
			return soap_in_glite__FRCEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:LFNStat"))
		{	*type = SOAP_TYPE_glite__LFNStat;
			return soap_in_glite__LFNStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:RCEntry"))
		{	*type = SOAP_TYPE_glite__RCEntry;
			return soap_in_glite__RCEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:SURLEntry"))
		{	*type = SOAP_TYPE_glite__SURLEntry;
			return soap_in_glite__SURLEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:Permission"))
		{	*type = SOAP_TYPE_glite__Permission;
			return soap_in_glite__Permission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:ACLEntry"))
		{	*type = SOAP_TYPE_glite__ACLEntry;
			return soap_in_glite__ACLEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:BasicPermission"))
		{	*type = SOAP_TYPE_glite__BasicPermission;
			return soap_in_glite__BasicPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:Perm"))
		{	*type = SOAP_TYPE_glite__Perm;
			return soap_in_glite__Perm(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:GUIDStat"))
		{	*type = SOAP_TYPE_glite__GUIDStat;
			return soap_in_glite__GUIDStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:Stat"))
		{	*type = SOAP_TYPE_glite__Stat;
			return soap_in_glite__Stat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:InvalidArgumentException"))
		{	*type = SOAP_TYPE_glite__InvalidArgumentException;
			return soap_in_glite__InvalidArgumentException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:NotExistsException"))
		{	*type = SOAP_TYPE_glite__NotExistsException;
			return soap_in_glite__NotExistsException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:AuthorizationException"))
		{	*type = SOAP_TYPE_glite__AuthorizationException;
			return soap_in_glite__AuthorizationException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:InternalException"))
		{	*type = SOAP_TYPE_glite__InternalException;
			return soap_in_glite__InternalException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "glite:CatalogException"))
		{	*type = SOAP_TYPE_glite__CatalogException;
			return soap_in_glite__CatalogException(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:StringBoolean"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean;
			return soap_in_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:GUIDStat"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat;
			return soap_in_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:RCEntry"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry;
			return soap_in_ArrayOf_USCOREtns1_USCORERCEntry(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:Attribute"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute;
			return soap_in_ArrayOf_USCOREtns1_USCOREAttribute(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:PermissionEntry"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry;
			return soap_in_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:FCEntry"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry;
			return soap_in_ArrayOf_USCOREtns1_USCOREFCEntry(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:SURLEntry"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry;
			return soap_in_ArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:Stat"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat;
			return soap_in_ArrayOf_USCOREtns1_USCOREStat(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:StringPair"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair;
			return soap_in_ArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "glite:FRCEntry"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry;
			return soap_in_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring;
			return soap_in_ArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getDefaultGlobalPermission"))
		{	*type = SOAP_TYPE_fireman__getDefaultGlobalPermission;
			return soap_in_fireman__getDefaultGlobalPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getDefaultGlobalPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse;
			return soap_in_fireman__getDefaultGlobalPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getDefaultPrincipalPermission"))
		{	*type = SOAP_TYPE_fireman__getDefaultPrincipalPermission;
			return soap_in_fireman__getDefaultPrincipalPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getDefaultPrincipalPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse;
			return soap_in_fireman__getDefaultPrincipalPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getSurlStat"))
		{	*type = SOAP_TYPE_fireman__getSurlStat;
			return soap_in_fireman__getSurlStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getSurlStatResponse"))
		{	*type = SOAP_TYPE_fireman__getSurlStatResponse;
			return soap_in_fireman__getSurlStatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getGuidStat"))
		{	*type = SOAP_TYPE_fireman__getGuidStat;
			return soap_in_fireman__getGuidStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getGuidStatResponse"))
		{	*type = SOAP_TYPE_fireman__getGuidStatResponse;
			return soap_in_fireman__getGuidStatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:hasGuid"))
		{	*type = SOAP_TYPE_fireman__hasGuid;
			return soap_in_fireman__hasGuid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:hasGuidResponse"))
		{	*type = SOAP_TYPE_fireman__hasGuidResponse;
			return soap_in_fireman__hasGuidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listReplicasByGuid"))
		{	*type = SOAP_TYPE_fireman__listReplicasByGuid;
			return soap_in_fireman__listReplicasByGuid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listReplicasByGuidResponse"))
		{	*type = SOAP_TYPE_fireman__listReplicasByGuidResponse;
			return soap_in_fireman__listReplicasByGuidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listSurlsByGuid"))
		{	*type = SOAP_TYPE_fireman__listSurlsByGuid;
			return soap_in_fireman__listSurlsByGuid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listSurlsByGuidResponse"))
		{	*type = SOAP_TYPE_fireman__listSurlsByGuidResponse;
			return soap_in_fireman__listSurlsByGuidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getMasterReplica"))
		{	*type = SOAP_TYPE_fireman__getMasterReplica;
			return soap_in_fireman__getMasterReplica(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getMasterReplicaResponse"))
		{	*type = SOAP_TYPE_fireman__getMasterReplicaResponse;
			return soap_in_fireman__getMasterReplicaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getGuidForSurl"))
		{	*type = SOAP_TYPE_fireman__getGuidForSurl;
			return soap_in_fireman__getGuidForSurl(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getGuidForSurlResponse"))
		{	*type = SOAP_TYPE_fireman__getGuidForSurlResponse;
			return soap_in_fireman__getGuidForSurlResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setDefaultGlobalPermission"))
		{	*type = SOAP_TYPE_fireman__setDefaultGlobalPermission;
			return soap_in_fireman__setDefaultGlobalPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setDefaultGlobalPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse;
			return soap_in_fireman__setDefaultGlobalPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setDefaultPrincipalPermission"))
		{	*type = SOAP_TYPE_fireman__setDefaultPrincipalPermission;
			return soap_in_fireman__setDefaultPrincipalPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setDefaultPrincipalPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse;
			return soap_in_fireman__setDefaultPrincipalPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeGuid"))
		{	*type = SOAP_TYPE_fireman__removeGuid;
			return soap_in_fireman__removeGuid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeGuidResponse"))
		{	*type = SOAP_TYPE_fireman__removeGuidResponse;
			return soap_in_fireman__removeGuidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeGuidReplica"))
		{	*type = SOAP_TYPE_fireman__removeGuidReplica;
			return soap_in_fireman__removeGuidReplica(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeGuidReplicaResponse"))
		{	*type = SOAP_TYPE_fireman__removeGuidReplicaResponse;
			return soap_in_fireman__removeGuidReplicaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setMasterReplica"))
		{	*type = SOAP_TYPE_fireman__setMasterReplica;
			return soap_in_fireman__setMasterReplica(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setMasterReplicaResponse"))
		{	*type = SOAP_TYPE_fireman__setMasterReplicaResponse;
			return soap_in_fireman__setMasterReplicaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateSurlStat"))
		{	*type = SOAP_TYPE_fireman__updateSurlStat;
			return soap_in_fireman__updateSurlStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateSurlStatResponse"))
		{	*type = SOAP_TYPE_fireman__updateSurlStatResponse;
			return soap_in_fireman__updateSurlStatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateGuidStat"))
		{	*type = SOAP_TYPE_fireman__updateGuidStat;
			return soap_in_fireman__updateGuidStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateGuidStatResponse"))
		{	*type = SOAP_TYPE_fireman__updateGuidStatResponse;
			return soap_in_fireman__updateGuidStatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:addGuidReplica"))
		{	*type = SOAP_TYPE_fireman__addGuidReplica;
			return soap_in_fireman__addGuidReplica(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:addGuidReplicaResponse"))
		{	*type = SOAP_TYPE_fireman__addGuidReplicaResponse;
			return soap_in_fireman__addGuidReplicaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:createGuid"))
		{	*type = SOAP_TYPE_fireman__createGuid;
			return soap_in_fireman__createGuid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:createGuidResponse"))
		{	*type = SOAP_TYPE_fireman__createGuidResponse;
			return soap_in_fireman__createGuidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateStatus"))
		{	*type = SOAP_TYPE_fireman__updateStatus;
			return soap_in_fireman__updateStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateStatusResponse"))
		{	*type = SOAP_TYPE_fireman__updateStatusResponse;
			return soap_in_fireman__updateStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listAttributes"))
		{	*type = SOAP_TYPE_fireman__listAttributes;
			return soap_in_fireman__listAttributes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listAttributesResponse"))
		{	*type = SOAP_TYPE_fireman__listAttributesResponse;
			return soap_in_fireman__listAttributesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:clearAttributes"))
		{	*type = SOAP_TYPE_fireman__clearAttributes;
			return soap_in_fireman__clearAttributes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:clearAttributesResponse"))
		{	*type = SOAP_TYPE_fireman__clearAttributesResponse;
			return soap_in_fireman__clearAttributesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setAttributes"))
		{	*type = SOAP_TYPE_fireman__setAttributes;
			return soap_in_fireman__setAttributes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setAttributesResponse"))
		{	*type = SOAP_TYPE_fireman__setAttributesResponse;
			return soap_in_fireman__setAttributesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:query"))
		{	*type = SOAP_TYPE_fireman__query;
			return soap_in_fireman__query(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:queryResponse"))
		{	*type = SOAP_TYPE_fireman__queryResponse;
			return soap_in_fireman__queryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getAttributes"))
		{	*type = SOAP_TYPE_fireman__getAttributes;
			return soap_in_fireman__getAttributes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getAttributesResponse"))
		{	*type = SOAP_TYPE_fireman__getAttributesResponse;
			return soap_in_fireman__getAttributesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getServiceMetadata"))
		{	*type = SOAP_TYPE_fireman__getServiceMetadata;
			return soap_in_fireman__getServiceMetadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getServiceMetadataResponse"))
		{	*type = SOAP_TYPE_fireman__getServiceMetadataResponse;
			return soap_in_fireman__getServiceMetadataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getInterfaceVersion"))
		{	*type = SOAP_TYPE_fireman__getInterfaceVersion;
			return soap_in_fireman__getInterfaceVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getInterfaceVersionResponse"))
		{	*type = SOAP_TYPE_fireman__getInterfaceVersionResponse;
			return soap_in_fireman__getInterfaceVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getSchemaVersion"))
		{	*type = SOAP_TYPE_fireman__getSchemaVersion;
			return soap_in_fireman__getSchemaVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getSchemaVersionResponse"))
		{	*type = SOAP_TYPE_fireman__getSchemaVersionResponse;
			return soap_in_fireman__getSchemaVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getVersion"))
		{	*type = SOAP_TYPE_fireman__getVersion;
			return soap_in_fireman__getVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getVersionResponse"))
		{	*type = SOAP_TYPE_fireman__getVersionResponse;
			return soap_in_fireman__getVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setPermission"))
		{	*type = SOAP_TYPE_fireman__setPermission;
			return soap_in_fireman__setPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:setPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__setPermissionResponse;
			return soap_in_fireman__setPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getPermission"))
		{	*type = SOAP_TYPE_fireman__getPermission;
			return soap_in_fireman__getPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__getPermissionResponse;
			return soap_in_fireman__getPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:checkPermission"))
		{	*type = SOAP_TYPE_fireman__checkPermission;
			return soap_in_fireman__checkPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:checkPermissionResponse"))
		{	*type = SOAP_TYPE_fireman__checkPermissionResponse;
			return soap_in_fireman__checkPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getFileCatalogEntry"))
		{	*type = SOAP_TYPE_fireman__getFileCatalogEntry;
			return soap_in_fireman__getFileCatalogEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getFileCatalogEntryResponse"))
		{	*type = SOAP_TYPE_fireman__getFileCatalogEntryResponse;
			return soap_in_fireman__getFileCatalogEntryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getLfnForGuid"))
		{	*type = SOAP_TYPE_fireman__getLfnForGuid;
			return soap_in_fireman__getLfnForGuid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getLfnForGuidResponse"))
		{	*type = SOAP_TYPE_fireman__getLfnForGuidResponse;
			return soap_in_fireman__getLfnForGuidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getGuidForLfn"))
		{	*type = SOAP_TYPE_fireman__getGuidForLfn;
			return soap_in_fireman__getGuidForLfn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getGuidForLfnResponse"))
		{	*type = SOAP_TYPE_fireman__getGuidForLfnResponse;
			return soap_in_fireman__getGuidForLfnResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:readDir"))
		{	*type = SOAP_TYPE_fireman__readDir;
			return soap_in_fireman__readDir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:readDirResponse"))
		{	*type = SOAP_TYPE_fireman__readDirResponse;
			return soap_in_fireman__readDirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateValidityTime"))
		{	*type = SOAP_TYPE_fireman__updateValidityTime;
			return soap_in_fireman__updateValidityTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateValidityTimeResponse"))
		{	*type = SOAP_TYPE_fireman__updateValidityTimeResponse;
			return soap_in_fireman__updateValidityTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateModifyTime"))
		{	*type = SOAP_TYPE_fireman__updateModifyTime;
			return soap_in_fireman__updateModifyTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:updateModifyTimeResponse"))
		{	*type = SOAP_TYPE_fireman__updateModifyTimeResponse;
			return soap_in_fireman__updateModifyTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:mv"))
		{	*type = SOAP_TYPE_fireman__mv;
			return soap_in_fireman__mv(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:mvResponse"))
		{	*type = SOAP_TYPE_fireman__mvResponse;
			return soap_in_fireman__mvResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:unlink"))
		{	*type = SOAP_TYPE_fireman__unlink;
			return soap_in_fireman__unlink(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:unlinkResponse"))
		{	*type = SOAP_TYPE_fireman__unlinkResponse;
			return soap_in_fireman__unlinkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:createFile"))
		{	*type = SOAP_TYPE_fireman__createFile;
			return soap_in_fireman__createFile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:createFileResponse"))
		{	*type = SOAP_TYPE_fireman__createFileResponse;
			return soap_in_fireman__createFileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:rmdir"))
		{	*type = SOAP_TYPE_fireman__rmdir;
			return soap_in_fireman__rmdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:rmdirResponse"))
		{	*type = SOAP_TYPE_fireman__rmdirResponse;
			return soap_in_fireman__rmdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:symlink"))
		{	*type = SOAP_TYPE_fireman__symlink;
			return soap_in_fireman__symlink(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:symlinkResponse"))
		{	*type = SOAP_TYPE_fireman__symlinkResponse;
			return soap_in_fireman__symlinkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:locate"))
		{	*type = SOAP_TYPE_fireman__locate;
			return soap_in_fireman__locate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:locateResponse"))
		{	*type = SOAP_TYPE_fireman__locateResponse;
			return soap_in_fireman__locateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:mkdir"))
		{	*type = SOAP_TYPE_fireman__mkdir;
			return soap_in_fireman__mkdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:mkdirResponse"))
		{	*type = SOAP_TYPE_fireman__mkdirResponse;
			return soap_in_fireman__mkdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:associateDirWithSchema"))
		{	*type = SOAP_TYPE_fireman__associateDirWithSchema;
			return soap_in_fireman__associateDirWithSchema(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:associateDirWithSchemaResponse"))
		{	*type = SOAP_TYPE_fireman__associateDirWithSchemaResponse;
			return soap_in_fireman__associateDirWithSchemaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeReplica"))
		{	*type = SOAP_TYPE_fireman__removeReplica;
			return soap_in_fireman__removeReplica(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeReplicaResponse"))
		{	*type = SOAP_TYPE_fireman__removeReplicaResponse;
			return soap_in_fireman__removeReplicaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:addReplica"))
		{	*type = SOAP_TYPE_fireman__addReplica;
			return soap_in_fireman__addReplica(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:addReplicaResponse"))
		{	*type = SOAP_TYPE_fireman__addReplicaResponse;
			return soap_in_fireman__addReplicaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getStat"))
		{	*type = SOAP_TYPE_fireman__getStat;
			return soap_in_fireman__getStat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:getStatResponse"))
		{	*type = SOAP_TYPE_fireman__getStatResponse;
			return soap_in_fireman__getStatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listLfn"))
		{	*type = SOAP_TYPE_fireman__listLfn;
			return soap_in_fireman__listLfn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listLfnResponse"))
		{	*type = SOAP_TYPE_fireman__listLfnResponse;
			return soap_in_fireman__listLfnResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listReplicas"))
		{	*type = SOAP_TYPE_fireman__listReplicas;
			return soap_in_fireman__listReplicas(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:listReplicasResponse"))
		{	*type = SOAP_TYPE_fireman__listReplicasResponse;
			return soap_in_fireman__listReplicasResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:create"))
		{	*type = SOAP_TYPE_fireman__create;
			return soap_in_fireman__create(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:createResponse"))
		{	*type = SOAP_TYPE_fireman__createResponse;
			return soap_in_fireman__createResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:remove"))
		{	*type = SOAP_TYPE_fireman__remove;
			return soap_in_fireman__remove(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "fireman:removeResponse"))
		{	*type = SOAP_TYPE_fireman__removeResponse;
			return soap_in_fireman__removeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "NotExistsException"))
		{	*type = SOAP_TYPE__NotExistsException;
			return soap_in__NotExistsException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "InvalidArgumentException"))
		{	*type = SOAP_TYPE__InvalidArgumentException;
			return soap_in__InvalidArgumentException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "InternalException"))
		{	*type = SOAP_TYPE__InternalException;
			return soap_in__InternalException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ExistsException"))
		{	*type = SOAP_TYPE__ExistsException;
			return soap_in__ExistsException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "AuthorizationException"))
		{	*type = SOAP_TYPE__AuthorizationException;
			return soap_in__AuthorizationException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SOAP-ENC:arrayType"))
		{	char **s;
			*type = SOAP_TYPE__SOAP_ENC__arrayType;
			s = soap_in__SOAP_ENC__arrayType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE__NotExistsException:
		return ((_NotExistsException *)ptr)->soap_out(soap, "NotExistsException", id, NULL);
	case SOAP_TYPE__InvalidArgumentException:
		return ((_InvalidArgumentException *)ptr)->soap_out(soap, "InvalidArgumentException", id, NULL);
	case SOAP_TYPE__InternalException:
		return ((_InternalException *)ptr)->soap_out(soap, "InternalException", id, NULL);
	case SOAP_TYPE__ExistsException:
		return ((_ExistsException *)ptr)->soap_out(soap, "ExistsException", id, NULL);
	case SOAP_TYPE__AuthorizationException:
		return ((_AuthorizationException *)ptr)->soap_out(soap, "AuthorizationException", id, NULL);
	case SOAP_TYPE_glite__StringBoolean:
		return ((glite__StringBoolean *)ptr)->soap_out(soap, tag, id, "glite:StringBoolean");
	case SOAP_TYPE_glite__Attribute:
		return ((glite__Attribute *)ptr)->soap_out(soap, tag, id, "glite:Attribute");
	case SOAP_TYPE_glite__PermissionEntry:
		return ((glite__PermissionEntry *)ptr)->soap_out(soap, tag, id, "glite:PermissionEntry");
	case SOAP_TYPE_glite__FCEntry:
		return ((glite__FCEntry *)ptr)->soap_out(soap, tag, id, "glite:FCEntry");
	case SOAP_TYPE_glite__StringPair:
		return ((glite__StringPair *)ptr)->soap_out(soap, tag, id, "glite:StringPair");
	case SOAP_TYPE_glite__ExistsException:
		return ((glite__ExistsException *)ptr)->soap_out(soap, tag, id, "glite:ExistsException");
	case SOAP_TYPE_glite__FRCEntry:
		return ((glite__FRCEntry *)ptr)->soap_out(soap, tag, id, "glite:FRCEntry");
	case SOAP_TYPE_glite__LFNStat:
		return ((glite__LFNStat *)ptr)->soap_out(soap, tag, id, "glite:LFNStat");
	case SOAP_TYPE_glite__RCEntry:
		return ((glite__RCEntry *)ptr)->soap_out(soap, tag, id, "glite:RCEntry");
	case SOAP_TYPE_glite__SURLEntry:
		return ((glite__SURLEntry *)ptr)->soap_out(soap, tag, id, "glite:SURLEntry");
	case SOAP_TYPE_glite__Permission:
		return ((glite__Permission *)ptr)->soap_out(soap, tag, id, "glite:Permission");
	case SOAP_TYPE_glite__ACLEntry:
		return ((glite__ACLEntry *)ptr)->soap_out(soap, tag, id, "glite:ACLEntry");
	case SOAP_TYPE_glite__BasicPermission:
		return ((glite__BasicPermission *)ptr)->soap_out(soap, tag, id, "glite:BasicPermission");
	case SOAP_TYPE_glite__Perm:
		return ((glite__Perm *)ptr)->soap_out(soap, tag, id, "glite:Perm");
	case SOAP_TYPE_glite__GUIDStat:
		return ((glite__GUIDStat *)ptr)->soap_out(soap, tag, id, "glite:GUIDStat");
	case SOAP_TYPE_glite__Stat:
		return ((glite__Stat *)ptr)->soap_out(soap, tag, id, "glite:Stat");
	case SOAP_TYPE_glite__InvalidArgumentException:
		return ((glite__InvalidArgumentException *)ptr)->soap_out(soap, tag, id, "glite:InvalidArgumentException");
	case SOAP_TYPE_glite__NotExistsException:
		return ((glite__NotExistsException *)ptr)->soap_out(soap, tag, id, "glite:NotExistsException");
	case SOAP_TYPE_glite__AuthorizationException:
		return ((glite__AuthorizationException *)ptr)->soap_out(soap, tag, id, "glite:AuthorizationException");
	case SOAP_TYPE_glite__InternalException:
		return ((glite__InternalException *)ptr)->soap_out(soap, tag, id, "glite:InternalException");
	case SOAP_TYPE_glite__CatalogException:
		return ((glite__CatalogException *)ptr)->soap_out(soap, tag, id, "glite:CatalogException");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean:
		return ((ArrayOf_USCOREtns1_USCOREStringBoolean *)ptr)->soap_out(soap, tag, id, "glite:StringBoolean");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat:
		return ((ArrayOf_USCOREtns1_USCOREGUIDStat *)ptr)->soap_out(soap, tag, id, "glite:GUIDStat");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry:
		return ((ArrayOf_USCOREtns1_USCORERCEntry *)ptr)->soap_out(soap, tag, id, "glite:RCEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute:
		return ((ArrayOf_USCOREtns1_USCOREAttribute *)ptr)->soap_out(soap, tag, id, "glite:Attribute");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry:
		return ((ArrayOf_USCOREtns1_USCOREPermissionEntry *)ptr)->soap_out(soap, tag, id, "glite:PermissionEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry:
		return ((ArrayOf_USCOREtns1_USCOREFCEntry *)ptr)->soap_out(soap, tag, id, "glite:FCEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry:
		return ((ArrayOf_USCOREtns1_USCORESURLEntry *)ptr)->soap_out(soap, tag, id, "glite:SURLEntry");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat:
		return ((ArrayOf_USCOREtns1_USCOREStat *)ptr)->soap_out(soap, tag, id, "glite:Stat");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair:
		return ((ArrayOf_USCOREtns1_USCOREStringPair *)ptr)->soap_out(soap, tag, id, "glite:StringPair");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry:
		return ((ArrayOf_USCOREtns1_USCOREFRCEntry *)ptr)->soap_out(soap, tag, id, "glite:FRCEntry");
	case SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring:
		return ((ArrayOf_USCOREsoapenc_USCOREstring *)ptr)->soap_out(soap, tag, id, "xsd:string");
	case SOAP_TYPE_fireman__getDefaultGlobalPermission:
		return soap_out_fireman__getDefaultGlobalPermission(soap, tag, id, (const struct fireman__getDefaultGlobalPermission *)ptr, "fireman:getDefaultGlobalPermission");
	case SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse:
		return soap_out_fireman__getDefaultGlobalPermissionResponse(soap, tag, id, (const struct fireman__getDefaultGlobalPermissionResponse *)ptr, "fireman:getDefaultGlobalPermissionResponse");
	case SOAP_TYPE_fireman__getDefaultPrincipalPermission:
		return soap_out_fireman__getDefaultPrincipalPermission(soap, tag, id, (const struct fireman__getDefaultPrincipalPermission *)ptr, "fireman:getDefaultPrincipalPermission");
	case SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse:
		return soap_out_fireman__getDefaultPrincipalPermissionResponse(soap, tag, id, (const struct fireman__getDefaultPrincipalPermissionResponse *)ptr, "fireman:getDefaultPrincipalPermissionResponse");
	case SOAP_TYPE_fireman__getSurlStat:
		return soap_out_fireman__getSurlStat(soap, tag, id, (const struct fireman__getSurlStat *)ptr, "fireman:getSurlStat");
	case SOAP_TYPE_fireman__getSurlStatResponse:
		return soap_out_fireman__getSurlStatResponse(soap, tag, id, (const struct fireman__getSurlStatResponse *)ptr, "fireman:getSurlStatResponse");
	case SOAP_TYPE_fireman__getGuidStat:
		return soap_out_fireman__getGuidStat(soap, tag, id, (const struct fireman__getGuidStat *)ptr, "fireman:getGuidStat");
	case SOAP_TYPE_fireman__getGuidStatResponse:
		return soap_out_fireman__getGuidStatResponse(soap, tag, id, (const struct fireman__getGuidStatResponse *)ptr, "fireman:getGuidStatResponse");
	case SOAP_TYPE_fireman__hasGuid:
		return soap_out_fireman__hasGuid(soap, tag, id, (const struct fireman__hasGuid *)ptr, "fireman:hasGuid");
	case SOAP_TYPE_fireman__hasGuidResponse:
		return soap_out_fireman__hasGuidResponse(soap, tag, id, (const struct fireman__hasGuidResponse *)ptr, "fireman:hasGuidResponse");
	case SOAP_TYPE_fireman__listReplicasByGuid:
		return soap_out_fireman__listReplicasByGuid(soap, tag, id, (const struct fireman__listReplicasByGuid *)ptr, "fireman:listReplicasByGuid");
	case SOAP_TYPE_fireman__listReplicasByGuidResponse:
		return soap_out_fireman__listReplicasByGuidResponse(soap, tag, id, (const struct fireman__listReplicasByGuidResponse *)ptr, "fireman:listReplicasByGuidResponse");
	case SOAP_TYPE_fireman__listSurlsByGuid:
		return soap_out_fireman__listSurlsByGuid(soap, tag, id, (const struct fireman__listSurlsByGuid *)ptr, "fireman:listSurlsByGuid");
	case SOAP_TYPE_fireman__listSurlsByGuidResponse:
		return soap_out_fireman__listSurlsByGuidResponse(soap, tag, id, (const struct fireman__listSurlsByGuidResponse *)ptr, "fireman:listSurlsByGuidResponse");
	case SOAP_TYPE_fireman__getMasterReplica:
		return soap_out_fireman__getMasterReplica(soap, tag, id, (const struct fireman__getMasterReplica *)ptr, "fireman:getMasterReplica");
	case SOAP_TYPE_fireman__getMasterReplicaResponse:
		return soap_out_fireman__getMasterReplicaResponse(soap, tag, id, (const struct fireman__getMasterReplicaResponse *)ptr, "fireman:getMasterReplicaResponse");
	case SOAP_TYPE_fireman__getGuidForSurl:
		return soap_out_fireman__getGuidForSurl(soap, tag, id, (const struct fireman__getGuidForSurl *)ptr, "fireman:getGuidForSurl");
	case SOAP_TYPE_fireman__getGuidForSurlResponse:
		return soap_out_fireman__getGuidForSurlResponse(soap, tag, id, (const struct fireman__getGuidForSurlResponse *)ptr, "fireman:getGuidForSurlResponse");
	case SOAP_TYPE_fireman__setDefaultGlobalPermission:
		return soap_out_fireman__setDefaultGlobalPermission(soap, tag, id, (const struct fireman__setDefaultGlobalPermission *)ptr, "fireman:setDefaultGlobalPermission");
	case SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse:
		return soap_out_fireman__setDefaultGlobalPermissionResponse(soap, tag, id, (const struct fireman__setDefaultGlobalPermissionResponse *)ptr, "fireman:setDefaultGlobalPermissionResponse");
	case SOAP_TYPE_fireman__setDefaultPrincipalPermission:
		return soap_out_fireman__setDefaultPrincipalPermission(soap, tag, id, (const struct fireman__setDefaultPrincipalPermission *)ptr, "fireman:setDefaultPrincipalPermission");
	case SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse:
		return soap_out_fireman__setDefaultPrincipalPermissionResponse(soap, tag, id, (const struct fireman__setDefaultPrincipalPermissionResponse *)ptr, "fireman:setDefaultPrincipalPermissionResponse");
	case SOAP_TYPE_fireman__removeGuid:
		return soap_out_fireman__removeGuid(soap, tag, id, (const struct fireman__removeGuid *)ptr, "fireman:removeGuid");
	case SOAP_TYPE_fireman__removeGuidResponse:
		return soap_out_fireman__removeGuidResponse(soap, tag, id, (const struct fireman__removeGuidResponse *)ptr, "fireman:removeGuidResponse");
	case SOAP_TYPE_fireman__removeGuidReplica:
		return soap_out_fireman__removeGuidReplica(soap, tag, id, (const struct fireman__removeGuidReplica *)ptr, "fireman:removeGuidReplica");
	case SOAP_TYPE_fireman__removeGuidReplicaResponse:
		return soap_out_fireman__removeGuidReplicaResponse(soap, tag, id, (const struct fireman__removeGuidReplicaResponse *)ptr, "fireman:removeGuidReplicaResponse");
	case SOAP_TYPE_fireman__setMasterReplica:
		return soap_out_fireman__setMasterReplica(soap, tag, id, (const struct fireman__setMasterReplica *)ptr, "fireman:setMasterReplica");
	case SOAP_TYPE_fireman__setMasterReplicaResponse:
		return soap_out_fireman__setMasterReplicaResponse(soap, tag, id, (const struct fireman__setMasterReplicaResponse *)ptr, "fireman:setMasterReplicaResponse");
	case SOAP_TYPE_fireman__updateSurlStat:
		return soap_out_fireman__updateSurlStat(soap, tag, id, (const struct fireman__updateSurlStat *)ptr, "fireman:updateSurlStat");
	case SOAP_TYPE_fireman__updateSurlStatResponse:
		return soap_out_fireman__updateSurlStatResponse(soap, tag, id, (const struct fireman__updateSurlStatResponse *)ptr, "fireman:updateSurlStatResponse");
	case SOAP_TYPE_fireman__updateGuidStat:
		return soap_out_fireman__updateGuidStat(soap, tag, id, (const struct fireman__updateGuidStat *)ptr, "fireman:updateGuidStat");
	case SOAP_TYPE_fireman__updateGuidStatResponse:
		return soap_out_fireman__updateGuidStatResponse(soap, tag, id, (const struct fireman__updateGuidStatResponse *)ptr, "fireman:updateGuidStatResponse");
	case SOAP_TYPE_fireman__addGuidReplica:
		return soap_out_fireman__addGuidReplica(soap, tag, id, (const struct fireman__addGuidReplica *)ptr, "fireman:addGuidReplica");
	case SOAP_TYPE_fireman__addGuidReplicaResponse:
		return soap_out_fireman__addGuidReplicaResponse(soap, tag, id, (const struct fireman__addGuidReplicaResponse *)ptr, "fireman:addGuidReplicaResponse");
	case SOAP_TYPE_fireman__createGuid:
		return soap_out_fireman__createGuid(soap, tag, id, (const struct fireman__createGuid *)ptr, "fireman:createGuid");
	case SOAP_TYPE_fireman__createGuidResponse:
		return soap_out_fireman__createGuidResponse(soap, tag, id, (const struct fireman__createGuidResponse *)ptr, "fireman:createGuidResponse");
	case SOAP_TYPE_fireman__updateStatus:
		return soap_out_fireman__updateStatus(soap, tag, id, (const struct fireman__updateStatus *)ptr, "fireman:updateStatus");
	case SOAP_TYPE_fireman__updateStatusResponse:
		return soap_out_fireman__updateStatusResponse(soap, tag, id, (const struct fireman__updateStatusResponse *)ptr, "fireman:updateStatusResponse");
	case SOAP_TYPE_fireman__listAttributes:
		return soap_out_fireman__listAttributes(soap, tag, id, (const struct fireman__listAttributes *)ptr, "fireman:listAttributes");
	case SOAP_TYPE_fireman__listAttributesResponse:
		return soap_out_fireman__listAttributesResponse(soap, tag, id, (const struct fireman__listAttributesResponse *)ptr, "fireman:listAttributesResponse");
	case SOAP_TYPE_fireman__clearAttributes:
		return soap_out_fireman__clearAttributes(soap, tag, id, (const struct fireman__clearAttributes *)ptr, "fireman:clearAttributes");
	case SOAP_TYPE_fireman__clearAttributesResponse:
		return soap_out_fireman__clearAttributesResponse(soap, tag, id, (const struct fireman__clearAttributesResponse *)ptr, "fireman:clearAttributesResponse");
	case SOAP_TYPE_fireman__setAttributes:
		return soap_out_fireman__setAttributes(soap, tag, id, (const struct fireman__setAttributes *)ptr, "fireman:setAttributes");
	case SOAP_TYPE_fireman__setAttributesResponse:
		return soap_out_fireman__setAttributesResponse(soap, tag, id, (const struct fireman__setAttributesResponse *)ptr, "fireman:setAttributesResponse");
	case SOAP_TYPE_fireman__query:
		return soap_out_fireman__query(soap, tag, id, (const struct fireman__query *)ptr, "fireman:query");
	case SOAP_TYPE_fireman__queryResponse:
		return soap_out_fireman__queryResponse(soap, tag, id, (const struct fireman__queryResponse *)ptr, "fireman:queryResponse");
	case SOAP_TYPE_fireman__getAttributes:
		return soap_out_fireman__getAttributes(soap, tag, id, (const struct fireman__getAttributes *)ptr, "fireman:getAttributes");
	case SOAP_TYPE_fireman__getAttributesResponse:
		return soap_out_fireman__getAttributesResponse(soap, tag, id, (const struct fireman__getAttributesResponse *)ptr, "fireman:getAttributesResponse");
	case SOAP_TYPE_fireman__getServiceMetadata:
		return soap_out_fireman__getServiceMetadata(soap, tag, id, (const struct fireman__getServiceMetadata *)ptr, "fireman:getServiceMetadata");
	case SOAP_TYPE_fireman__getServiceMetadataResponse:
		return soap_out_fireman__getServiceMetadataResponse(soap, tag, id, (const struct fireman__getServiceMetadataResponse *)ptr, "fireman:getServiceMetadataResponse");
	case SOAP_TYPE_fireman__getInterfaceVersion:
		return soap_out_fireman__getInterfaceVersion(soap, tag, id, (const struct fireman__getInterfaceVersion *)ptr, "fireman:getInterfaceVersion");
	case SOAP_TYPE_fireman__getInterfaceVersionResponse:
		return soap_out_fireman__getInterfaceVersionResponse(soap, tag, id, (const struct fireman__getInterfaceVersionResponse *)ptr, "fireman:getInterfaceVersionResponse");
	case SOAP_TYPE_fireman__getSchemaVersion:
		return soap_out_fireman__getSchemaVersion(soap, tag, id, (const struct fireman__getSchemaVersion *)ptr, "fireman:getSchemaVersion");
	case SOAP_TYPE_fireman__getSchemaVersionResponse:
		return soap_out_fireman__getSchemaVersionResponse(soap, tag, id, (const struct fireman__getSchemaVersionResponse *)ptr, "fireman:getSchemaVersionResponse");
	case SOAP_TYPE_fireman__getVersion:
		return soap_out_fireman__getVersion(soap, tag, id, (const struct fireman__getVersion *)ptr, "fireman:getVersion");
	case SOAP_TYPE_fireman__getVersionResponse:
		return soap_out_fireman__getVersionResponse(soap, tag, id, (const struct fireman__getVersionResponse *)ptr, "fireman:getVersionResponse");
	case SOAP_TYPE_fireman__setPermission:
		return soap_out_fireman__setPermission(soap, tag, id, (const struct fireman__setPermission *)ptr, "fireman:setPermission");
	case SOAP_TYPE_fireman__setPermissionResponse:
		return soap_out_fireman__setPermissionResponse(soap, tag, id, (const struct fireman__setPermissionResponse *)ptr, "fireman:setPermissionResponse");
	case SOAP_TYPE_fireman__getPermission:
		return soap_out_fireman__getPermission(soap, tag, id, (const struct fireman__getPermission *)ptr, "fireman:getPermission");
	case SOAP_TYPE_fireman__getPermissionResponse:
		return soap_out_fireman__getPermissionResponse(soap, tag, id, (const struct fireman__getPermissionResponse *)ptr, "fireman:getPermissionResponse");
	case SOAP_TYPE_fireman__checkPermission:
		return soap_out_fireman__checkPermission(soap, tag, id, (const struct fireman__checkPermission *)ptr, "fireman:checkPermission");
	case SOAP_TYPE_fireman__checkPermissionResponse:
		return soap_out_fireman__checkPermissionResponse(soap, tag, id, (const struct fireman__checkPermissionResponse *)ptr, "fireman:checkPermissionResponse");
	case SOAP_TYPE_fireman__getFileCatalogEntry:
		return soap_out_fireman__getFileCatalogEntry(soap, tag, id, (const struct fireman__getFileCatalogEntry *)ptr, "fireman:getFileCatalogEntry");
	case SOAP_TYPE_fireman__getFileCatalogEntryResponse:
		return soap_out_fireman__getFileCatalogEntryResponse(soap, tag, id, (const struct fireman__getFileCatalogEntryResponse *)ptr, "fireman:getFileCatalogEntryResponse");
	case SOAP_TYPE_fireman__getLfnForGuid:
		return soap_out_fireman__getLfnForGuid(soap, tag, id, (const struct fireman__getLfnForGuid *)ptr, "fireman:getLfnForGuid");
	case SOAP_TYPE_fireman__getLfnForGuidResponse:
		return soap_out_fireman__getLfnForGuidResponse(soap, tag, id, (const struct fireman__getLfnForGuidResponse *)ptr, "fireman:getLfnForGuidResponse");
	case SOAP_TYPE_fireman__getGuidForLfn:
		return soap_out_fireman__getGuidForLfn(soap, tag, id, (const struct fireman__getGuidForLfn *)ptr, "fireman:getGuidForLfn");
	case SOAP_TYPE_fireman__getGuidForLfnResponse:
		return soap_out_fireman__getGuidForLfnResponse(soap, tag, id, (const struct fireman__getGuidForLfnResponse *)ptr, "fireman:getGuidForLfnResponse");
	case SOAP_TYPE_fireman__readDir:
		return soap_out_fireman__readDir(soap, tag, id, (const struct fireman__readDir *)ptr, "fireman:readDir");
	case SOAP_TYPE_fireman__readDirResponse:
		return soap_out_fireman__readDirResponse(soap, tag, id, (const struct fireman__readDirResponse *)ptr, "fireman:readDirResponse");
	case SOAP_TYPE_fireman__updateValidityTime:
		return soap_out_fireman__updateValidityTime(soap, tag, id, (const struct fireman__updateValidityTime *)ptr, "fireman:updateValidityTime");
	case SOAP_TYPE_fireman__updateValidityTimeResponse:
		return soap_out_fireman__updateValidityTimeResponse(soap, tag, id, (const struct fireman__updateValidityTimeResponse *)ptr, "fireman:updateValidityTimeResponse");
	case SOAP_TYPE_fireman__updateModifyTime:
		return soap_out_fireman__updateModifyTime(soap, tag, id, (const struct fireman__updateModifyTime *)ptr, "fireman:updateModifyTime");
	case SOAP_TYPE_fireman__updateModifyTimeResponse:
		return soap_out_fireman__updateModifyTimeResponse(soap, tag, id, (const struct fireman__updateModifyTimeResponse *)ptr, "fireman:updateModifyTimeResponse");
	case SOAP_TYPE_fireman__mv:
		return soap_out_fireman__mv(soap, tag, id, (const struct fireman__mv *)ptr, "fireman:mv");
	case SOAP_TYPE_fireman__mvResponse:
		return soap_out_fireman__mvResponse(soap, tag, id, (const struct fireman__mvResponse *)ptr, "fireman:mvResponse");
	case SOAP_TYPE_fireman__unlink:
		return soap_out_fireman__unlink(soap, tag, id, (const struct fireman__unlink *)ptr, "fireman:unlink");
	case SOAP_TYPE_fireman__unlinkResponse:
		return soap_out_fireman__unlinkResponse(soap, tag, id, (const struct fireman__unlinkResponse *)ptr, "fireman:unlinkResponse");
	case SOAP_TYPE_fireman__createFile:
		return soap_out_fireman__createFile(soap, tag, id, (const struct fireman__createFile *)ptr, "fireman:createFile");
	case SOAP_TYPE_fireman__createFileResponse:
		return soap_out_fireman__createFileResponse(soap, tag, id, (const struct fireman__createFileResponse *)ptr, "fireman:createFileResponse");
	case SOAP_TYPE_fireman__rmdir:
		return soap_out_fireman__rmdir(soap, tag, id, (const struct fireman__rmdir *)ptr, "fireman:rmdir");
	case SOAP_TYPE_fireman__rmdirResponse:
		return soap_out_fireman__rmdirResponse(soap, tag, id, (const struct fireman__rmdirResponse *)ptr, "fireman:rmdirResponse");
	case SOAP_TYPE_fireman__symlink:
		return soap_out_fireman__symlink(soap, tag, id, (const struct fireman__symlink *)ptr, "fireman:symlink");
	case SOAP_TYPE_fireman__symlinkResponse:
		return soap_out_fireman__symlinkResponse(soap, tag, id, (const struct fireman__symlinkResponse *)ptr, "fireman:symlinkResponse");
	case SOAP_TYPE_fireman__locate:
		return soap_out_fireman__locate(soap, tag, id, (const struct fireman__locate *)ptr, "fireman:locate");
	case SOAP_TYPE_fireman__locateResponse:
		return soap_out_fireman__locateResponse(soap, tag, id, (const struct fireman__locateResponse *)ptr, "fireman:locateResponse");
	case SOAP_TYPE_fireman__mkdir:
		return soap_out_fireman__mkdir(soap, tag, id, (const struct fireman__mkdir *)ptr, "fireman:mkdir");
	case SOAP_TYPE_fireman__mkdirResponse:
		return soap_out_fireman__mkdirResponse(soap, tag, id, (const struct fireman__mkdirResponse *)ptr, "fireman:mkdirResponse");
	case SOAP_TYPE_fireman__associateDirWithSchema:
		return soap_out_fireman__associateDirWithSchema(soap, tag, id, (const struct fireman__associateDirWithSchema *)ptr, "fireman:associateDirWithSchema");
	case SOAP_TYPE_fireman__associateDirWithSchemaResponse:
		return soap_out_fireman__associateDirWithSchemaResponse(soap, tag, id, (const struct fireman__associateDirWithSchemaResponse *)ptr, "fireman:associateDirWithSchemaResponse");
	case SOAP_TYPE_fireman__removeReplica:
		return soap_out_fireman__removeReplica(soap, tag, id, (const struct fireman__removeReplica *)ptr, "fireman:removeReplica");
	case SOAP_TYPE_fireman__removeReplicaResponse:
		return soap_out_fireman__removeReplicaResponse(soap, tag, id, (const struct fireman__removeReplicaResponse *)ptr, "fireman:removeReplicaResponse");
	case SOAP_TYPE_fireman__addReplica:
		return soap_out_fireman__addReplica(soap, tag, id, (const struct fireman__addReplica *)ptr, "fireman:addReplica");
	case SOAP_TYPE_fireman__addReplicaResponse:
		return soap_out_fireman__addReplicaResponse(soap, tag, id, (const struct fireman__addReplicaResponse *)ptr, "fireman:addReplicaResponse");
	case SOAP_TYPE_fireman__getStat:
		return soap_out_fireman__getStat(soap, tag, id, (const struct fireman__getStat *)ptr, "fireman:getStat");
	case SOAP_TYPE_fireman__getStatResponse:
		return soap_out_fireman__getStatResponse(soap, tag, id, (const struct fireman__getStatResponse *)ptr, "fireman:getStatResponse");
	case SOAP_TYPE_fireman__listLfn:
		return soap_out_fireman__listLfn(soap, tag, id, (const struct fireman__listLfn *)ptr, "fireman:listLfn");
	case SOAP_TYPE_fireman__listLfnResponse:
		return soap_out_fireman__listLfnResponse(soap, tag, id, (const struct fireman__listLfnResponse *)ptr, "fireman:listLfnResponse");
	case SOAP_TYPE_fireman__listReplicas:
		return soap_out_fireman__listReplicas(soap, tag, id, (const struct fireman__listReplicas *)ptr, "fireman:listReplicas");
	case SOAP_TYPE_fireman__listReplicasResponse:
		return soap_out_fireman__listReplicasResponse(soap, tag, id, (const struct fireman__listReplicasResponse *)ptr, "fireman:listReplicasResponse");
	case SOAP_TYPE_fireman__create:
		return soap_out_fireman__create(soap, tag, id, (const struct fireman__create *)ptr, "fireman:create");
	case SOAP_TYPE_fireman__createResponse:
		return soap_out_fireman__createResponse(soap, tag, id, (const struct fireman__createResponse *)ptr, "fireman:createResponse");
	case SOAP_TYPE_fireman__remove:
		return soap_out_fireman__remove(soap, tag, id, (const struct fireman__remove *)ptr, "fireman:remove");
	case SOAP_TYPE_fireman__removeResponse:
		return soap_out_fireman__removeResponse(soap, tag, id, (const struct fireman__removeResponse *)ptr, "fireman:removeResponse");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringBoolean:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, tag, id, (ArrayOf_USCOREtns1_USCOREStringBoolean *const*)ptr, "glite:StringBoolean");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREGUIDStat:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, tag, id, (ArrayOf_USCOREtns1_USCOREGUIDStat *const*)ptr, "glite:GUIDStat");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERCEntry:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, tag, id, (ArrayOf_USCOREtns1_USCORERCEntry *const*)ptr, "glite:RCEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREAttribute:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, tag, id, (ArrayOf_USCOREtns1_USCOREAttribute *const*)ptr, "glite:Attribute");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, tag, id, (ArrayOf_USCOREtns1_USCOREPermissionEntry *const*)ptr, "glite:PermissionEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFCEntry:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, tag, id, (ArrayOf_USCOREtns1_USCOREFCEntry *const*)ptr, "glite:FCEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORESURLEntry:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, tag, id, (ArrayOf_USCOREtns1_USCORESURLEntry *const*)ptr, "glite:SURLEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStat:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREStat(soap, tag, id, (ArrayOf_USCOREtns1_USCOREStat *const*)ptr, "glite:Stat");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringPair:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, tag, id, (ArrayOf_USCOREtns1_USCOREStringPair *const*)ptr, "glite:StringPair");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFRCEntry:
		return soap_out_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, tag, id, (ArrayOf_USCOREtns1_USCOREFRCEntry *const*)ptr, "glite:FRCEntry");
	case SOAP_TYPE_PointerToArrayOf_USCOREsoapenc_USCOREstring:
		return soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, tag, id, (ArrayOf_USCOREsoapenc_USCOREstring *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToglite__NotExistsException:
		return soap_out_PointerToglite__NotExistsException(soap, tag, id, (glite__NotExistsException *const*)ptr, "glite:NotExistsException");
	case SOAP_TYPE_PointerToglite__InvalidArgumentException:
		return soap_out_PointerToglite__InvalidArgumentException(soap, tag, id, (glite__InvalidArgumentException *const*)ptr, "glite:InvalidArgumentException");
	case SOAP_TYPE_PointerToglite__InternalException:
		return soap_out_PointerToglite__InternalException(soap, tag, id, (glite__InternalException *const*)ptr, "glite:InternalException");
	case SOAP_TYPE_PointerToglite__ExistsException:
		return soap_out_PointerToglite__ExistsException(soap, tag, id, (glite__ExistsException *const*)ptr, "glite:ExistsException");
	case SOAP_TYPE_PointerToglite__AuthorizationException:
		return soap_out_PointerToglite__AuthorizationException(soap, tag, id, (glite__AuthorizationException *const*)ptr, "glite:AuthorizationException");
	case SOAP_TYPE_PointerToPointerToglite__ACLEntry:
		return soap_out_PointerToPointerToglite__ACLEntry(soap, tag, id, (glite__ACLEntry **const*)ptr, "glite:ACLEntry");
	case SOAP_TYPE_PointerToglite__ACLEntry:
		return soap_out_PointerToglite__ACLEntry(soap, tag, id, (glite__ACLEntry *const*)ptr, "glite:ACLEntry");
	case SOAP_TYPE_PointerToPointerToglite__StringBoolean:
		return soap_out_PointerToPointerToglite__StringBoolean(soap, tag, id, (glite__StringBoolean **const*)ptr, "glite:StringBoolean");
	case SOAP_TYPE_PointerToglite__StringBoolean:
		return soap_out_PointerToglite__StringBoolean(soap, tag, id, (glite__StringBoolean *const*)ptr, "glite:StringBoolean");
	case SOAP_TYPE_PointerToPointerToglite__GUIDStat:
		return soap_out_PointerToPointerToglite__GUIDStat(soap, tag, id, (glite__GUIDStat **const*)ptr, "glite:GUIDStat");
	case SOAP_TYPE_PointerToPointerToglite__RCEntry:
		return soap_out_PointerToPointerToglite__RCEntry(soap, tag, id, (glite__RCEntry **const*)ptr, "glite:RCEntry");
	case SOAP_TYPE_PointerToglite__RCEntry:
		return soap_out_PointerToglite__RCEntry(soap, tag, id, (glite__RCEntry *const*)ptr, "glite:RCEntry");
	case SOAP_TYPE_PointerToPointerToglite__Attribute:
		return soap_out_PointerToPointerToglite__Attribute(soap, tag, id, (glite__Attribute **const*)ptr, "glite:Attribute");
	case SOAP_TYPE_PointerToglite__Attribute:
		return soap_out_PointerToglite__Attribute(soap, tag, id, (glite__Attribute *const*)ptr, "glite:Attribute");
	case SOAP_TYPE_PointerToPointerToglite__PermissionEntry:
		return soap_out_PointerToPointerToglite__PermissionEntry(soap, tag, id, (glite__PermissionEntry **const*)ptr, "glite:PermissionEntry");
	case SOAP_TYPE_PointerToglite__PermissionEntry:
		return soap_out_PointerToglite__PermissionEntry(soap, tag, id, (glite__PermissionEntry *const*)ptr, "glite:PermissionEntry");
	case SOAP_TYPE_PointerToPointerToglite__FCEntry:
		return soap_out_PointerToPointerToglite__FCEntry(soap, tag, id, (glite__FCEntry **const*)ptr, "glite:FCEntry");
	case SOAP_TYPE_PointerToglite__FCEntry:
		return soap_out_PointerToglite__FCEntry(soap, tag, id, (glite__FCEntry *const*)ptr, "glite:FCEntry");
	case SOAP_TYPE_PointerToPointerToglite__Stat:
		return soap_out_PointerToPointerToglite__Stat(soap, tag, id, (glite__Stat **const*)ptr, "glite:Stat");
	case SOAP_TYPE_PointerToglite__Stat:
		return soap_out_PointerToglite__Stat(soap, tag, id, (glite__Stat *const*)ptr, "glite:Stat");
	case SOAP_TYPE_PointerToPointerToglite__StringPair:
		return soap_out_PointerToPointerToglite__StringPair(soap, tag, id, (glite__StringPair **const*)ptr, "glite:StringPair");
	case SOAP_TYPE_PointerToglite__StringPair:
		return soap_out_PointerToglite__StringPair(soap, tag, id, (glite__StringPair *const*)ptr, "glite:StringPair");
	case SOAP_TYPE_PointerToPointerToglite__FRCEntry:
		return soap_out_PointerToPointerToglite__FRCEntry(soap, tag, id, (glite__FRCEntry **const*)ptr, "glite:FRCEntry");
	case SOAP_TYPE_PointerToglite__FRCEntry:
		return soap_out_PointerToglite__FRCEntry(soap, tag, id, (glite__FRCEntry *const*)ptr, "glite:FRCEntry");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToglite__LFNStat:
		return soap_out_PointerToglite__LFNStat(soap, tag, id, (glite__LFNStat *const*)ptr, "glite:LFNStat");
	case SOAP_TYPE_PointerToPointerToglite__SURLEntry:
		return soap_out_PointerToPointerToglite__SURLEntry(soap, tag, id, (glite__SURLEntry **const*)ptr, "glite:SURLEntry");
	case SOAP_TYPE_PointerToglite__SURLEntry:
		return soap_out_PointerToglite__SURLEntry(soap, tag, id, (glite__SURLEntry *const*)ptr, "glite:SURLEntry");
	case SOAP_TYPE_PointerToglite__Permission:
		return soap_out_PointerToglite__Permission(soap, tag, id, (glite__Permission *const*)ptr, "glite:Permission");
	case SOAP_TYPE_PointerToglite__GUIDStat:
		return soap_out_PointerToglite__GUIDStat(soap, tag, id, (glite__GUIDStat *const*)ptr, "glite:GUIDStat");
	case SOAP_TYPE_PointerToglite__Perm:
		return soap_out_PointerToglite__Perm(soap, tag, id, (glite__Perm *const*)ptr, "glite:Perm");
	case SOAP_TYPE__SOAP_ENC__arrayType:
		return soap_out_string(soap, "SOAP-ENC:arrayType", id, (char**)&ptr, NULL);
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE__NotExistsException:
		((_NotExistsException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__InvalidArgumentException:
		((_InvalidArgumentException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__InternalException:
		((_InternalException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ExistsException:
		((_ExistsException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__AuthorizationException:
		((_AuthorizationException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__StringBoolean:
		((glite__StringBoolean *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__Attribute:
		((glite__Attribute *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__PermissionEntry:
		((glite__PermissionEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__FCEntry:
		((glite__FCEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__StringPair:
		((glite__StringPair *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__ExistsException:
		((glite__ExistsException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__FRCEntry:
		((glite__FRCEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__LFNStat:
		((glite__LFNStat *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__RCEntry:
		((glite__RCEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__SURLEntry:
		((glite__SURLEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__Permission:
		((glite__Permission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__ACLEntry:
		((glite__ACLEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__BasicPermission:
		((glite__BasicPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__Perm:
		((glite__Perm *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__GUIDStat:
		((glite__GUIDStat *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__Stat:
		((glite__Stat *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__InvalidArgumentException:
		((glite__InvalidArgumentException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__NotExistsException:
		((glite__NotExistsException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__AuthorizationException:
		((glite__AuthorizationException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__InternalException:
		((glite__InternalException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_glite__CatalogException:
		((glite__CatalogException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean:
		((ArrayOf_USCOREtns1_USCOREStringBoolean *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat:
		((ArrayOf_USCOREtns1_USCOREGUIDStat *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry:
		((ArrayOf_USCOREtns1_USCORERCEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute:
		((ArrayOf_USCOREtns1_USCOREAttribute *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry:
		((ArrayOf_USCOREtns1_USCOREPermissionEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry:
		((ArrayOf_USCOREtns1_USCOREFCEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry:
		((ArrayOf_USCOREtns1_USCORESURLEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat:
		((ArrayOf_USCOREtns1_USCOREStat *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair:
		((ArrayOf_USCOREtns1_USCOREStringPair *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry:
		((ArrayOf_USCOREtns1_USCOREFRCEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring:
		((ArrayOf_USCOREsoapenc_USCOREstring *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_fireman__getDefaultGlobalPermission:
		soap_serialize_fireman__getDefaultGlobalPermission(soap, (const struct fireman__getDefaultGlobalPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse:
		soap_serialize_fireman__getDefaultGlobalPermissionResponse(soap, (const struct fireman__getDefaultGlobalPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getDefaultPrincipalPermission:
		soap_serialize_fireman__getDefaultPrincipalPermission(soap, (const struct fireman__getDefaultPrincipalPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse:
		soap_serialize_fireman__getDefaultPrincipalPermissionResponse(soap, (const struct fireman__getDefaultPrincipalPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getSurlStat:
		soap_serialize_fireman__getSurlStat(soap, (const struct fireman__getSurlStat *)ptr);
		break;
	case SOAP_TYPE_fireman__getSurlStatResponse:
		soap_serialize_fireman__getSurlStatResponse(soap, (const struct fireman__getSurlStatResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getGuidStat:
		soap_serialize_fireman__getGuidStat(soap, (const struct fireman__getGuidStat *)ptr);
		break;
	case SOAP_TYPE_fireman__getGuidStatResponse:
		soap_serialize_fireman__getGuidStatResponse(soap, (const struct fireman__getGuidStatResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__hasGuid:
		soap_serialize_fireman__hasGuid(soap, (const struct fireman__hasGuid *)ptr);
		break;
	case SOAP_TYPE_fireman__hasGuidResponse:
		soap_serialize_fireman__hasGuidResponse(soap, (const struct fireman__hasGuidResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__listReplicasByGuid:
		soap_serialize_fireman__listReplicasByGuid(soap, (const struct fireman__listReplicasByGuid *)ptr);
		break;
	case SOAP_TYPE_fireman__listReplicasByGuidResponse:
		soap_serialize_fireman__listReplicasByGuidResponse(soap, (const struct fireman__listReplicasByGuidResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__listSurlsByGuid:
		soap_serialize_fireman__listSurlsByGuid(soap, (const struct fireman__listSurlsByGuid *)ptr);
		break;
	case SOAP_TYPE_fireman__listSurlsByGuidResponse:
		soap_serialize_fireman__listSurlsByGuidResponse(soap, (const struct fireman__listSurlsByGuidResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getMasterReplica:
		soap_serialize_fireman__getMasterReplica(soap, (const struct fireman__getMasterReplica *)ptr);
		break;
	case SOAP_TYPE_fireman__getMasterReplicaResponse:
		soap_serialize_fireman__getMasterReplicaResponse(soap, (const struct fireman__getMasterReplicaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getGuidForSurl:
		soap_serialize_fireman__getGuidForSurl(soap, (const struct fireman__getGuidForSurl *)ptr);
		break;
	case SOAP_TYPE_fireman__getGuidForSurlResponse:
		soap_serialize_fireman__getGuidForSurlResponse(soap, (const struct fireman__getGuidForSurlResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__setDefaultGlobalPermission:
		soap_serialize_fireman__setDefaultGlobalPermission(soap, (const struct fireman__setDefaultGlobalPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse:
		soap_serialize_fireman__setDefaultGlobalPermissionResponse(soap, (const struct fireman__setDefaultGlobalPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__setDefaultPrincipalPermission:
		soap_serialize_fireman__setDefaultPrincipalPermission(soap, (const struct fireman__setDefaultPrincipalPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse:
		soap_serialize_fireman__setDefaultPrincipalPermissionResponse(soap, (const struct fireman__setDefaultPrincipalPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__removeGuid:
		soap_serialize_fireman__removeGuid(soap, (const struct fireman__removeGuid *)ptr);
		break;
	case SOAP_TYPE_fireman__removeGuidResponse:
		soap_serialize_fireman__removeGuidResponse(soap, (const struct fireman__removeGuidResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__removeGuidReplica:
		soap_serialize_fireman__removeGuidReplica(soap, (const struct fireman__removeGuidReplica *)ptr);
		break;
	case SOAP_TYPE_fireman__removeGuidReplicaResponse:
		soap_serialize_fireman__removeGuidReplicaResponse(soap, (const struct fireman__removeGuidReplicaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__setMasterReplica:
		soap_serialize_fireman__setMasterReplica(soap, (const struct fireman__setMasterReplica *)ptr);
		break;
	case SOAP_TYPE_fireman__setMasterReplicaResponse:
		soap_serialize_fireman__setMasterReplicaResponse(soap, (const struct fireman__setMasterReplicaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__updateSurlStat:
		soap_serialize_fireman__updateSurlStat(soap, (const struct fireman__updateSurlStat *)ptr);
		break;
	case SOAP_TYPE_fireman__updateSurlStatResponse:
		soap_serialize_fireman__updateSurlStatResponse(soap, (const struct fireman__updateSurlStatResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__updateGuidStat:
		soap_serialize_fireman__updateGuidStat(soap, (const struct fireman__updateGuidStat *)ptr);
		break;
	case SOAP_TYPE_fireman__updateGuidStatResponse:
		soap_serialize_fireman__updateGuidStatResponse(soap, (const struct fireman__updateGuidStatResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__addGuidReplica:
		soap_serialize_fireman__addGuidReplica(soap, (const struct fireman__addGuidReplica *)ptr);
		break;
	case SOAP_TYPE_fireman__addGuidReplicaResponse:
		soap_serialize_fireman__addGuidReplicaResponse(soap, (const struct fireman__addGuidReplicaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__createGuid:
		soap_serialize_fireman__createGuid(soap, (const struct fireman__createGuid *)ptr);
		break;
	case SOAP_TYPE_fireman__createGuidResponse:
		soap_serialize_fireman__createGuidResponse(soap, (const struct fireman__createGuidResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__updateStatus:
		soap_serialize_fireman__updateStatus(soap, (const struct fireman__updateStatus *)ptr);
		break;
	case SOAP_TYPE_fireman__updateStatusResponse:
		soap_serialize_fireman__updateStatusResponse(soap, (const struct fireman__updateStatusResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__listAttributes:
		soap_serialize_fireman__listAttributes(soap, (const struct fireman__listAttributes *)ptr);
		break;
	case SOAP_TYPE_fireman__listAttributesResponse:
		soap_serialize_fireman__listAttributesResponse(soap, (const struct fireman__listAttributesResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__clearAttributes:
		soap_serialize_fireman__clearAttributes(soap, (const struct fireman__clearAttributes *)ptr);
		break;
	case SOAP_TYPE_fireman__clearAttributesResponse:
		soap_serialize_fireman__clearAttributesResponse(soap, (const struct fireman__clearAttributesResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__setAttributes:
		soap_serialize_fireman__setAttributes(soap, (const struct fireman__setAttributes *)ptr);
		break;
	case SOAP_TYPE_fireman__setAttributesResponse:
		soap_serialize_fireman__setAttributesResponse(soap, (const struct fireman__setAttributesResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__query:
		soap_serialize_fireman__query(soap, (const struct fireman__query *)ptr);
		break;
	case SOAP_TYPE_fireman__queryResponse:
		soap_serialize_fireman__queryResponse(soap, (const struct fireman__queryResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getAttributes:
		soap_serialize_fireman__getAttributes(soap, (const struct fireman__getAttributes *)ptr);
		break;
	case SOAP_TYPE_fireman__getAttributesResponse:
		soap_serialize_fireman__getAttributesResponse(soap, (const struct fireman__getAttributesResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getServiceMetadata:
		soap_serialize_fireman__getServiceMetadata(soap, (const struct fireman__getServiceMetadata *)ptr);
		break;
	case SOAP_TYPE_fireman__getServiceMetadataResponse:
		soap_serialize_fireman__getServiceMetadataResponse(soap, (const struct fireman__getServiceMetadataResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getInterfaceVersion:
		soap_serialize_fireman__getInterfaceVersion(soap, (const struct fireman__getInterfaceVersion *)ptr);
		break;
	case SOAP_TYPE_fireman__getInterfaceVersionResponse:
		soap_serialize_fireman__getInterfaceVersionResponse(soap, (const struct fireman__getInterfaceVersionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getSchemaVersion:
		soap_serialize_fireman__getSchemaVersion(soap, (const struct fireman__getSchemaVersion *)ptr);
		break;
	case SOAP_TYPE_fireman__getSchemaVersionResponse:
		soap_serialize_fireman__getSchemaVersionResponse(soap, (const struct fireman__getSchemaVersionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getVersion:
		soap_serialize_fireman__getVersion(soap, (const struct fireman__getVersion *)ptr);
		break;
	case SOAP_TYPE_fireman__getVersionResponse:
		soap_serialize_fireman__getVersionResponse(soap, (const struct fireman__getVersionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__setPermission:
		soap_serialize_fireman__setPermission(soap, (const struct fireman__setPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__setPermissionResponse:
		soap_serialize_fireman__setPermissionResponse(soap, (const struct fireman__setPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getPermission:
		soap_serialize_fireman__getPermission(soap, (const struct fireman__getPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__getPermissionResponse:
		soap_serialize_fireman__getPermissionResponse(soap, (const struct fireman__getPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__checkPermission:
		soap_serialize_fireman__checkPermission(soap, (const struct fireman__checkPermission *)ptr);
		break;
	case SOAP_TYPE_fireman__checkPermissionResponse:
		soap_serialize_fireman__checkPermissionResponse(soap, (const struct fireman__checkPermissionResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getFileCatalogEntry:
		soap_serialize_fireman__getFileCatalogEntry(soap, (const struct fireman__getFileCatalogEntry *)ptr);
		break;
	case SOAP_TYPE_fireman__getFileCatalogEntryResponse:
		soap_serialize_fireman__getFileCatalogEntryResponse(soap, (const struct fireman__getFileCatalogEntryResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getLfnForGuid:
		soap_serialize_fireman__getLfnForGuid(soap, (const struct fireman__getLfnForGuid *)ptr);
		break;
	case SOAP_TYPE_fireman__getLfnForGuidResponse:
		soap_serialize_fireman__getLfnForGuidResponse(soap, (const struct fireman__getLfnForGuidResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getGuidForLfn:
		soap_serialize_fireman__getGuidForLfn(soap, (const struct fireman__getGuidForLfn *)ptr);
		break;
	case SOAP_TYPE_fireman__getGuidForLfnResponse:
		soap_serialize_fireman__getGuidForLfnResponse(soap, (const struct fireman__getGuidForLfnResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__readDir:
		soap_serialize_fireman__readDir(soap, (const struct fireman__readDir *)ptr);
		break;
	case SOAP_TYPE_fireman__readDirResponse:
		soap_serialize_fireman__readDirResponse(soap, (const struct fireman__readDirResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__updateValidityTime:
		soap_serialize_fireman__updateValidityTime(soap, (const struct fireman__updateValidityTime *)ptr);
		break;
	case SOAP_TYPE_fireman__updateValidityTimeResponse:
		soap_serialize_fireman__updateValidityTimeResponse(soap, (const struct fireman__updateValidityTimeResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__updateModifyTime:
		soap_serialize_fireman__updateModifyTime(soap, (const struct fireman__updateModifyTime *)ptr);
		break;
	case SOAP_TYPE_fireman__updateModifyTimeResponse:
		soap_serialize_fireman__updateModifyTimeResponse(soap, (const struct fireman__updateModifyTimeResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__mv:
		soap_serialize_fireman__mv(soap, (const struct fireman__mv *)ptr);
		break;
	case SOAP_TYPE_fireman__mvResponse:
		soap_serialize_fireman__mvResponse(soap, (const struct fireman__mvResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__unlink:
		soap_serialize_fireman__unlink(soap, (const struct fireman__unlink *)ptr);
		break;
	case SOAP_TYPE_fireman__unlinkResponse:
		soap_serialize_fireman__unlinkResponse(soap, (const struct fireman__unlinkResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__createFile:
		soap_serialize_fireman__createFile(soap, (const struct fireman__createFile *)ptr);
		break;
	case SOAP_TYPE_fireman__createFileResponse:
		soap_serialize_fireman__createFileResponse(soap, (const struct fireman__createFileResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__rmdir:
		soap_serialize_fireman__rmdir(soap, (const struct fireman__rmdir *)ptr);
		break;
	case SOAP_TYPE_fireman__rmdirResponse:
		soap_serialize_fireman__rmdirResponse(soap, (const struct fireman__rmdirResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__symlink:
		soap_serialize_fireman__symlink(soap, (const struct fireman__symlink *)ptr);
		break;
	case SOAP_TYPE_fireman__symlinkResponse:
		soap_serialize_fireman__symlinkResponse(soap, (const struct fireman__symlinkResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__locate:
		soap_serialize_fireman__locate(soap, (const struct fireman__locate *)ptr);
		break;
	case SOAP_TYPE_fireman__locateResponse:
		soap_serialize_fireman__locateResponse(soap, (const struct fireman__locateResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__mkdir:
		soap_serialize_fireman__mkdir(soap, (const struct fireman__mkdir *)ptr);
		break;
	case SOAP_TYPE_fireman__mkdirResponse:
		soap_serialize_fireman__mkdirResponse(soap, (const struct fireman__mkdirResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__associateDirWithSchema:
		soap_serialize_fireman__associateDirWithSchema(soap, (const struct fireman__associateDirWithSchema *)ptr);
		break;
	case SOAP_TYPE_fireman__associateDirWithSchemaResponse:
		soap_serialize_fireman__associateDirWithSchemaResponse(soap, (const struct fireman__associateDirWithSchemaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__removeReplica:
		soap_serialize_fireman__removeReplica(soap, (const struct fireman__removeReplica *)ptr);
		break;
	case SOAP_TYPE_fireman__removeReplicaResponse:
		soap_serialize_fireman__removeReplicaResponse(soap, (const struct fireman__removeReplicaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__addReplica:
		soap_serialize_fireman__addReplica(soap, (const struct fireman__addReplica *)ptr);
		break;
	case SOAP_TYPE_fireman__addReplicaResponse:
		soap_serialize_fireman__addReplicaResponse(soap, (const struct fireman__addReplicaResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__getStat:
		soap_serialize_fireman__getStat(soap, (const struct fireman__getStat *)ptr);
		break;
	case SOAP_TYPE_fireman__getStatResponse:
		soap_serialize_fireman__getStatResponse(soap, (const struct fireman__getStatResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__listLfn:
		soap_serialize_fireman__listLfn(soap, (const struct fireman__listLfn *)ptr);
		break;
	case SOAP_TYPE_fireman__listLfnResponse:
		soap_serialize_fireman__listLfnResponse(soap, (const struct fireman__listLfnResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__listReplicas:
		soap_serialize_fireman__listReplicas(soap, (const struct fireman__listReplicas *)ptr);
		break;
	case SOAP_TYPE_fireman__listReplicasResponse:
		soap_serialize_fireman__listReplicasResponse(soap, (const struct fireman__listReplicasResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__create:
		soap_serialize_fireman__create(soap, (const struct fireman__create *)ptr);
		break;
	case SOAP_TYPE_fireman__createResponse:
		soap_serialize_fireman__createResponse(soap, (const struct fireman__createResponse *)ptr);
		break;
	case SOAP_TYPE_fireman__remove:
		soap_serialize_fireman__remove(soap, (const struct fireman__remove *)ptr);
		break;
	case SOAP_TYPE_fireman__removeResponse:
		soap_serialize_fireman__removeResponse(soap, (const struct fireman__removeResponse *)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringBoolean:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, (ArrayOf_USCOREtns1_USCOREStringBoolean *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREGUIDStat:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, (ArrayOf_USCOREtns1_USCOREGUIDStat *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERCEntry:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, (ArrayOf_USCOREtns1_USCORERCEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREAttribute:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, (ArrayOf_USCOREtns1_USCOREAttribute *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, (ArrayOf_USCOREtns1_USCOREPermissionEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFCEntry:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, (ArrayOf_USCOREtns1_USCOREFCEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORESURLEntry:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, (ArrayOf_USCOREtns1_USCORESURLEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStat:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStat(soap, (ArrayOf_USCOREtns1_USCOREStat *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringPair:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, (ArrayOf_USCOREtns1_USCOREStringPair *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFRCEntry:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, (ArrayOf_USCOREtns1_USCOREFRCEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREsoapenc_USCOREstring:
		soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, (ArrayOf_USCOREsoapenc_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__NotExistsException:
		soap_serialize_PointerToglite__NotExistsException(soap, (glite__NotExistsException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__InvalidArgumentException:
		soap_serialize_PointerToglite__InvalidArgumentException(soap, (glite__InvalidArgumentException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__InternalException:
		soap_serialize_PointerToglite__InternalException(soap, (glite__InternalException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__ExistsException:
		soap_serialize_PointerToglite__ExistsException(soap, (glite__ExistsException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__AuthorizationException:
		soap_serialize_PointerToglite__AuthorizationException(soap, (glite__AuthorizationException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__ACLEntry:
		soap_serialize_PointerToPointerToglite__ACLEntry(soap, (glite__ACLEntry **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__ACLEntry:
		soap_serialize_PointerToglite__ACLEntry(soap, (glite__ACLEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__StringBoolean:
		soap_serialize_PointerToPointerToglite__StringBoolean(soap, (glite__StringBoolean **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__StringBoolean:
		soap_serialize_PointerToglite__StringBoolean(soap, (glite__StringBoolean *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__GUIDStat:
		soap_serialize_PointerToPointerToglite__GUIDStat(soap, (glite__GUIDStat **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__RCEntry:
		soap_serialize_PointerToPointerToglite__RCEntry(soap, (glite__RCEntry **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__RCEntry:
		soap_serialize_PointerToglite__RCEntry(soap, (glite__RCEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__Attribute:
		soap_serialize_PointerToPointerToglite__Attribute(soap, (glite__Attribute **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__Attribute:
		soap_serialize_PointerToglite__Attribute(soap, (glite__Attribute *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__PermissionEntry:
		soap_serialize_PointerToPointerToglite__PermissionEntry(soap, (glite__PermissionEntry **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__PermissionEntry:
		soap_serialize_PointerToglite__PermissionEntry(soap, (glite__PermissionEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__FCEntry:
		soap_serialize_PointerToPointerToglite__FCEntry(soap, (glite__FCEntry **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__FCEntry:
		soap_serialize_PointerToglite__FCEntry(soap, (glite__FCEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__Stat:
		soap_serialize_PointerToPointerToglite__Stat(soap, (glite__Stat **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__Stat:
		soap_serialize_PointerToglite__Stat(soap, (glite__Stat *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__StringPair:
		soap_serialize_PointerToPointerToglite__StringPair(soap, (glite__StringPair **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__StringPair:
		soap_serialize_PointerToglite__StringPair(soap, (glite__StringPair *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__FRCEntry:
		soap_serialize_PointerToPointerToglite__FRCEntry(soap, (glite__FRCEntry **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__FRCEntry:
		soap_serialize_PointerToglite__FRCEntry(soap, (glite__FRCEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__LFNStat:
		soap_serialize_PointerToglite__LFNStat(soap, (glite__LFNStat *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToglite__SURLEntry:
		soap_serialize_PointerToPointerToglite__SURLEntry(soap, (glite__SURLEntry **const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__SURLEntry:
		soap_serialize_PointerToglite__SURLEntry(soap, (glite__SURLEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__Permission:
		soap_serialize_PointerToglite__Permission(soap, (glite__Permission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__GUIDStat:
		soap_serialize_PointerToglite__GUIDStat(soap, (glite__GUIDStat *const*)ptr);
		break;
	case SOAP_TYPE_PointerToglite__Perm:
		soap_serialize_PointerToglite__Perm(soap, (glite__Perm *const*)ptr);
		break;
	case SOAP_TYPE__SOAP_ENC__arrayType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_glite__CatalogException:
		return (void*)soap_instantiate_glite__CatalogException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__Stat:
		return (void*)soap_instantiate_glite__Stat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__Perm:
		return (void*)soap_instantiate_glite__Perm(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__BasicPermission:
		return (void*)soap_instantiate_glite__BasicPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__ACLEntry:
		return (void*)soap_instantiate_glite__ACLEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__SURLEntry:
		return (void*)soap_instantiate_glite__SURLEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__RCEntry:
		return (void*)soap_instantiate_glite__RCEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__StringPair:
		return (void*)soap_instantiate_glite__StringPair(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__FCEntry:
		return (void*)soap_instantiate_glite__FCEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__PermissionEntry:
		return (void*)soap_instantiate_glite__PermissionEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__Attribute:
		return (void*)soap_instantiate_glite__Attribute(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__StringBoolean:
		return (void*)soap_instantiate_glite__StringBoolean(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring:
		return (void*)soap_instantiate_ArrayOf_USCOREsoapenc_USCOREstring(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREStringPair(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORESURLEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREFCEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREAttribute(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERCEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__InternalException:
		return (void*)soap_instantiate_glite__InternalException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__AuthorizationException:
		return (void*)soap_instantiate_glite__AuthorizationException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__NotExistsException:
		return (void*)soap_instantiate_glite__NotExistsException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__InvalidArgumentException:
		return (void*)soap_instantiate_glite__InvalidArgumentException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__GUIDStat:
		return (void*)soap_instantiate_glite__GUIDStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__Permission:
		return (void*)soap_instantiate_glite__Permission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__LFNStat:
		return (void*)soap_instantiate_glite__LFNStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__FRCEntry:
		return (void*)soap_instantiate_glite__FRCEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_glite__ExistsException:
		return (void*)soap_instantiate_glite__ExistsException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__AuthorizationException:
		return (void*)soap_instantiate__AuthorizationException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ExistsException:
		return (void*)soap_instantiate__ExistsException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__InternalException:
		return (void*)soap_instantiate__InternalException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__InvalidArgumentException:
		return (void*)soap_instantiate__InvalidArgumentException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__NotExistsException:
		return (void*)soap_instantiate__NotExistsException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeResponse:
		return (void*)soap_instantiate_fireman__removeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__remove:
		return (void*)soap_instantiate_fireman__remove(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__createResponse:
		return (void*)soap_instantiate_fireman__createResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__create:
		return (void*)soap_instantiate_fireman__create(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listReplicasResponse:
		return (void*)soap_instantiate_fireman__listReplicasResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listReplicas:
		return (void*)soap_instantiate_fireman__listReplicas(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listLfnResponse:
		return (void*)soap_instantiate_fireman__listLfnResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listLfn:
		return (void*)soap_instantiate_fireman__listLfn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getStatResponse:
		return (void*)soap_instantiate_fireman__getStatResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getStat:
		return (void*)soap_instantiate_fireman__getStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__addReplicaResponse:
		return (void*)soap_instantiate_fireman__addReplicaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__addReplica:
		return (void*)soap_instantiate_fireman__addReplica(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeReplicaResponse:
		return (void*)soap_instantiate_fireman__removeReplicaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeReplica:
		return (void*)soap_instantiate_fireman__removeReplica(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__associateDirWithSchemaResponse:
		return (void*)soap_instantiate_fireman__associateDirWithSchemaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__associateDirWithSchema:
		return (void*)soap_instantiate_fireman__associateDirWithSchema(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__mkdirResponse:
		return (void*)soap_instantiate_fireman__mkdirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__mkdir:
		return (void*)soap_instantiate_fireman__mkdir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__locateResponse:
		return (void*)soap_instantiate_fireman__locateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__locate:
		return (void*)soap_instantiate_fireman__locate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__symlinkResponse:
		return (void*)soap_instantiate_fireman__symlinkResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__symlink:
		return (void*)soap_instantiate_fireman__symlink(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__rmdirResponse:
		return (void*)soap_instantiate_fireman__rmdirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__rmdir:
		return (void*)soap_instantiate_fireman__rmdir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__createFileResponse:
		return (void*)soap_instantiate_fireman__createFileResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__createFile:
		return (void*)soap_instantiate_fireman__createFile(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__unlinkResponse:
		return (void*)soap_instantiate_fireman__unlinkResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__unlink:
		return (void*)soap_instantiate_fireman__unlink(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__mvResponse:
		return (void*)soap_instantiate_fireman__mvResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__mv:
		return (void*)soap_instantiate_fireman__mv(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateModifyTimeResponse:
		return (void*)soap_instantiate_fireman__updateModifyTimeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateModifyTime:
		return (void*)soap_instantiate_fireman__updateModifyTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateValidityTimeResponse:
		return (void*)soap_instantiate_fireman__updateValidityTimeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateValidityTime:
		return (void*)soap_instantiate_fireman__updateValidityTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__readDirResponse:
		return (void*)soap_instantiate_fireman__readDirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__readDir:
		return (void*)soap_instantiate_fireman__readDir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getGuidForLfnResponse:
		return (void*)soap_instantiate_fireman__getGuidForLfnResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getGuidForLfn:
		return (void*)soap_instantiate_fireman__getGuidForLfn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getLfnForGuidResponse:
		return (void*)soap_instantiate_fireman__getLfnForGuidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getLfnForGuid:
		return (void*)soap_instantiate_fireman__getLfnForGuid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getFileCatalogEntryResponse:
		return (void*)soap_instantiate_fireman__getFileCatalogEntryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getFileCatalogEntry:
		return (void*)soap_instantiate_fireman__getFileCatalogEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__checkPermissionResponse:
		return (void*)soap_instantiate_fireman__checkPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__checkPermission:
		return (void*)soap_instantiate_fireman__checkPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getPermissionResponse:
		return (void*)soap_instantiate_fireman__getPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getPermission:
		return (void*)soap_instantiate_fireman__getPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setPermissionResponse:
		return (void*)soap_instantiate_fireman__setPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setPermission:
		return (void*)soap_instantiate_fireman__setPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getVersionResponse:
		return (void*)soap_instantiate_fireman__getVersionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getVersion:
		return (void*)soap_instantiate_fireman__getVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getSchemaVersionResponse:
		return (void*)soap_instantiate_fireman__getSchemaVersionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getSchemaVersion:
		return (void*)soap_instantiate_fireman__getSchemaVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getInterfaceVersionResponse:
		return (void*)soap_instantiate_fireman__getInterfaceVersionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getInterfaceVersion:
		return (void*)soap_instantiate_fireman__getInterfaceVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getServiceMetadataResponse:
		return (void*)soap_instantiate_fireman__getServiceMetadataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getServiceMetadata:
		return (void*)soap_instantiate_fireman__getServiceMetadata(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getAttributesResponse:
		return (void*)soap_instantiate_fireman__getAttributesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getAttributes:
		return (void*)soap_instantiate_fireman__getAttributes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__queryResponse:
		return (void*)soap_instantiate_fireman__queryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__query:
		return (void*)soap_instantiate_fireman__query(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setAttributesResponse:
		return (void*)soap_instantiate_fireman__setAttributesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setAttributes:
		return (void*)soap_instantiate_fireman__setAttributes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__clearAttributesResponse:
		return (void*)soap_instantiate_fireman__clearAttributesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__clearAttributes:
		return (void*)soap_instantiate_fireman__clearAttributes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listAttributesResponse:
		return (void*)soap_instantiate_fireman__listAttributesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listAttributes:
		return (void*)soap_instantiate_fireman__listAttributes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateStatusResponse:
		return (void*)soap_instantiate_fireman__updateStatusResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateStatus:
		return (void*)soap_instantiate_fireman__updateStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__createGuidResponse:
		return (void*)soap_instantiate_fireman__createGuidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__createGuid:
		return (void*)soap_instantiate_fireman__createGuid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__addGuidReplicaResponse:
		return (void*)soap_instantiate_fireman__addGuidReplicaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__addGuidReplica:
		return (void*)soap_instantiate_fireman__addGuidReplica(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateGuidStatResponse:
		return (void*)soap_instantiate_fireman__updateGuidStatResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateGuidStat:
		return (void*)soap_instantiate_fireman__updateGuidStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateSurlStatResponse:
		return (void*)soap_instantiate_fireman__updateSurlStatResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__updateSurlStat:
		return (void*)soap_instantiate_fireman__updateSurlStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setMasterReplicaResponse:
		return (void*)soap_instantiate_fireman__setMasterReplicaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setMasterReplica:
		return (void*)soap_instantiate_fireman__setMasterReplica(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeGuidReplicaResponse:
		return (void*)soap_instantiate_fireman__removeGuidReplicaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeGuidReplica:
		return (void*)soap_instantiate_fireman__removeGuidReplica(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeGuidResponse:
		return (void*)soap_instantiate_fireman__removeGuidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__removeGuid:
		return (void*)soap_instantiate_fireman__removeGuid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse:
		return (void*)soap_instantiate_fireman__setDefaultPrincipalPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setDefaultPrincipalPermission:
		return (void*)soap_instantiate_fireman__setDefaultPrincipalPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse:
		return (void*)soap_instantiate_fireman__setDefaultGlobalPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__setDefaultGlobalPermission:
		return (void*)soap_instantiate_fireman__setDefaultGlobalPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getGuidForSurlResponse:
		return (void*)soap_instantiate_fireman__getGuidForSurlResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getGuidForSurl:
		return (void*)soap_instantiate_fireman__getGuidForSurl(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getMasterReplicaResponse:
		return (void*)soap_instantiate_fireman__getMasterReplicaResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getMasterReplica:
		return (void*)soap_instantiate_fireman__getMasterReplica(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listSurlsByGuidResponse:
		return (void*)soap_instantiate_fireman__listSurlsByGuidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listSurlsByGuid:
		return (void*)soap_instantiate_fireman__listSurlsByGuid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listReplicasByGuidResponse:
		return (void*)soap_instantiate_fireman__listReplicasByGuidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__listReplicasByGuid:
		return (void*)soap_instantiate_fireman__listReplicasByGuid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__hasGuidResponse:
		return (void*)soap_instantiate_fireman__hasGuidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__hasGuid:
		return (void*)soap_instantiate_fireman__hasGuid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getGuidStatResponse:
		return (void*)soap_instantiate_fireman__getGuidStatResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getGuidStat:
		return (void*)soap_instantiate_fireman__getGuidStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getSurlStatResponse:
		return (void*)soap_instantiate_fireman__getSurlStatResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getSurlStat:
		return (void*)soap_instantiate_fireman__getSurlStat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse:
		return (void*)soap_instantiate_fireman__getDefaultPrincipalPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getDefaultPrincipalPermission:
		return (void*)soap_instantiate_fireman__getDefaultPrincipalPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse:
		return (void*)soap_instantiate_fireman__getDefaultGlobalPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_fireman__getDefaultGlobalPermission:
		return (void*)soap_instantiate_fireman__getDefaultGlobalPermission(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_glite__CatalogException:
		if (p->size < 0)
			delete (glite__CatalogException*)p->ptr;
		else
			delete[] (glite__CatalogException*)p->ptr;
		break;
	case SOAP_TYPE_glite__Stat:
		if (p->size < 0)
			delete (glite__Stat*)p->ptr;
		else
			delete[] (glite__Stat*)p->ptr;
		break;
	case SOAP_TYPE_glite__Perm:
		if (p->size < 0)
			delete (glite__Perm*)p->ptr;
		else
			delete[] (glite__Perm*)p->ptr;
		break;
	case SOAP_TYPE_glite__BasicPermission:
		if (p->size < 0)
			delete (glite__BasicPermission*)p->ptr;
		else
			delete[] (glite__BasicPermission*)p->ptr;
		break;
	case SOAP_TYPE_glite__ACLEntry:
		if (p->size < 0)
			delete (glite__ACLEntry*)p->ptr;
		else
			delete[] (glite__ACLEntry*)p->ptr;
		break;
	case SOAP_TYPE_glite__SURLEntry:
		if (p->size < 0)
			delete (glite__SURLEntry*)p->ptr;
		else
			delete[] (glite__SURLEntry*)p->ptr;
		break;
	case SOAP_TYPE_glite__RCEntry:
		if (p->size < 0)
			delete (glite__RCEntry*)p->ptr;
		else
			delete[] (glite__RCEntry*)p->ptr;
		break;
	case SOAP_TYPE_glite__StringPair:
		if (p->size < 0)
			delete (glite__StringPair*)p->ptr;
		else
			delete[] (glite__StringPair*)p->ptr;
		break;
	case SOAP_TYPE_glite__FCEntry:
		if (p->size < 0)
			delete (glite__FCEntry*)p->ptr;
		else
			delete[] (glite__FCEntry*)p->ptr;
		break;
	case SOAP_TYPE_glite__PermissionEntry:
		if (p->size < 0)
			delete (glite__PermissionEntry*)p->ptr;
		else
			delete[] (glite__PermissionEntry*)p->ptr;
		break;
	case SOAP_TYPE_glite__Attribute:
		if (p->size < 0)
			delete (glite__Attribute*)p->ptr;
		else
			delete[] (glite__Attribute*)p->ptr;
		break;
	case SOAP_TYPE_glite__StringBoolean:
		if (p->size < 0)
			delete (glite__StringBoolean*)p->ptr;
		else
			delete[] (glite__StringBoolean*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring:
		if (p->size < 0)
			delete (ArrayOf_USCOREsoapenc_USCOREstring*)p->ptr;
		else
			delete[] (ArrayOf_USCOREsoapenc_USCOREstring*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREFRCEntry*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREFRCEntry*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREStringPair*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREStringPair*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREStat*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREStat*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORESURLEntry*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORESURLEntry*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREFCEntry*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREFCEntry*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREPermissionEntry*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREPermissionEntry*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREAttribute*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREAttribute*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERCEntry*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERCEntry*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREGUIDStat*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREGUIDStat*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCOREStringBoolean*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCOREStringBoolean*)p->ptr;
		break;
	case SOAP_TYPE_glite__InternalException:
		if (p->size < 0)
			delete (glite__InternalException*)p->ptr;
		else
			delete[] (glite__InternalException*)p->ptr;
		break;
	case SOAP_TYPE_glite__AuthorizationException:
		if (p->size < 0)
			delete (glite__AuthorizationException*)p->ptr;
		else
			delete[] (glite__AuthorizationException*)p->ptr;
		break;
	case SOAP_TYPE_glite__NotExistsException:
		if (p->size < 0)
			delete (glite__NotExistsException*)p->ptr;
		else
			delete[] (glite__NotExistsException*)p->ptr;
		break;
	case SOAP_TYPE_glite__InvalidArgumentException:
		if (p->size < 0)
			delete (glite__InvalidArgumentException*)p->ptr;
		else
			delete[] (glite__InvalidArgumentException*)p->ptr;
		break;
	case SOAP_TYPE_glite__GUIDStat:
		if (p->size < 0)
			delete (glite__GUIDStat*)p->ptr;
		else
			delete[] (glite__GUIDStat*)p->ptr;
		break;
	case SOAP_TYPE_glite__Permission:
		if (p->size < 0)
			delete (glite__Permission*)p->ptr;
		else
			delete[] (glite__Permission*)p->ptr;
		break;
	case SOAP_TYPE_glite__LFNStat:
		if (p->size < 0)
			delete (glite__LFNStat*)p->ptr;
		else
			delete[] (glite__LFNStat*)p->ptr;
		break;
	case SOAP_TYPE_glite__FRCEntry:
		if (p->size < 0)
			delete (glite__FRCEntry*)p->ptr;
		else
			delete[] (glite__FRCEntry*)p->ptr;
		break;
	case SOAP_TYPE_glite__ExistsException:
		if (p->size < 0)
			delete (glite__ExistsException*)p->ptr;
		else
			delete[] (glite__ExistsException*)p->ptr;
		break;
	case SOAP_TYPE__AuthorizationException:
		if (p->size < 0)
			delete (_AuthorizationException*)p->ptr;
		else
			delete[] (_AuthorizationException*)p->ptr;
		break;
	case SOAP_TYPE__ExistsException:
		if (p->size < 0)
			delete (_ExistsException*)p->ptr;
		else
			delete[] (_ExistsException*)p->ptr;
		break;
	case SOAP_TYPE__InternalException:
		if (p->size < 0)
			delete (_InternalException*)p->ptr;
		else
			delete[] (_InternalException*)p->ptr;
		break;
	case SOAP_TYPE__InvalidArgumentException:
		if (p->size < 0)
			delete (_InvalidArgumentException*)p->ptr;
		else
			delete[] (_InvalidArgumentException*)p->ptr;
		break;
	case SOAP_TYPE__NotExistsException:
		if (p->size < 0)
			delete (_NotExistsException*)p->ptr;
		else
			delete[] (_NotExistsException*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeResponse:
		if (p->size < 0)
			delete (struct fireman__removeResponse*)p->ptr;
		else
			delete[] (struct fireman__removeResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__remove:
		if (p->size < 0)
			delete (struct fireman__remove*)p->ptr;
		else
			delete[] (struct fireman__remove*)p->ptr;
		break;
	case SOAP_TYPE_fireman__createResponse:
		if (p->size < 0)
			delete (struct fireman__createResponse*)p->ptr;
		else
			delete[] (struct fireman__createResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__create:
		if (p->size < 0)
			delete (struct fireman__create*)p->ptr;
		else
			delete[] (struct fireman__create*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listReplicasResponse:
		if (p->size < 0)
			delete (struct fireman__listReplicasResponse*)p->ptr;
		else
			delete[] (struct fireman__listReplicasResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listReplicas:
		if (p->size < 0)
			delete (struct fireman__listReplicas*)p->ptr;
		else
			delete[] (struct fireman__listReplicas*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listLfnResponse:
		if (p->size < 0)
			delete (struct fireman__listLfnResponse*)p->ptr;
		else
			delete[] (struct fireman__listLfnResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listLfn:
		if (p->size < 0)
			delete (struct fireman__listLfn*)p->ptr;
		else
			delete[] (struct fireman__listLfn*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getStatResponse:
		if (p->size < 0)
			delete (struct fireman__getStatResponse*)p->ptr;
		else
			delete[] (struct fireman__getStatResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getStat:
		if (p->size < 0)
			delete (struct fireman__getStat*)p->ptr;
		else
			delete[] (struct fireman__getStat*)p->ptr;
		break;
	case SOAP_TYPE_fireman__addReplicaResponse:
		if (p->size < 0)
			delete (struct fireman__addReplicaResponse*)p->ptr;
		else
			delete[] (struct fireman__addReplicaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__addReplica:
		if (p->size < 0)
			delete (struct fireman__addReplica*)p->ptr;
		else
			delete[] (struct fireman__addReplica*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeReplicaResponse:
		if (p->size < 0)
			delete (struct fireman__removeReplicaResponse*)p->ptr;
		else
			delete[] (struct fireman__removeReplicaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeReplica:
		if (p->size < 0)
			delete (struct fireman__removeReplica*)p->ptr;
		else
			delete[] (struct fireman__removeReplica*)p->ptr;
		break;
	case SOAP_TYPE_fireman__associateDirWithSchemaResponse:
		if (p->size < 0)
			delete (struct fireman__associateDirWithSchemaResponse*)p->ptr;
		else
			delete[] (struct fireman__associateDirWithSchemaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__associateDirWithSchema:
		if (p->size < 0)
			delete (struct fireman__associateDirWithSchema*)p->ptr;
		else
			delete[] (struct fireman__associateDirWithSchema*)p->ptr;
		break;
	case SOAP_TYPE_fireman__mkdirResponse:
		if (p->size < 0)
			delete (struct fireman__mkdirResponse*)p->ptr;
		else
			delete[] (struct fireman__mkdirResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__mkdir:
		if (p->size < 0)
			delete (struct fireman__mkdir*)p->ptr;
		else
			delete[] (struct fireman__mkdir*)p->ptr;
		break;
	case SOAP_TYPE_fireman__locateResponse:
		if (p->size < 0)
			delete (struct fireman__locateResponse*)p->ptr;
		else
			delete[] (struct fireman__locateResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__locate:
		if (p->size < 0)
			delete (struct fireman__locate*)p->ptr;
		else
			delete[] (struct fireman__locate*)p->ptr;
		break;
	case SOAP_TYPE_fireman__symlinkResponse:
		if (p->size < 0)
			delete (struct fireman__symlinkResponse*)p->ptr;
		else
			delete[] (struct fireman__symlinkResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__symlink:
		if (p->size < 0)
			delete (struct fireman__symlink*)p->ptr;
		else
			delete[] (struct fireman__symlink*)p->ptr;
		break;
	case SOAP_TYPE_fireman__rmdirResponse:
		if (p->size < 0)
			delete (struct fireman__rmdirResponse*)p->ptr;
		else
			delete[] (struct fireman__rmdirResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__rmdir:
		if (p->size < 0)
			delete (struct fireman__rmdir*)p->ptr;
		else
			delete[] (struct fireman__rmdir*)p->ptr;
		break;
	case SOAP_TYPE_fireman__createFileResponse:
		if (p->size < 0)
			delete (struct fireman__createFileResponse*)p->ptr;
		else
			delete[] (struct fireman__createFileResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__createFile:
		if (p->size < 0)
			delete (struct fireman__createFile*)p->ptr;
		else
			delete[] (struct fireman__createFile*)p->ptr;
		break;
	case SOAP_TYPE_fireman__unlinkResponse:
		if (p->size < 0)
			delete (struct fireman__unlinkResponse*)p->ptr;
		else
			delete[] (struct fireman__unlinkResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__unlink:
		if (p->size < 0)
			delete (struct fireman__unlink*)p->ptr;
		else
			delete[] (struct fireman__unlink*)p->ptr;
		break;
	case SOAP_TYPE_fireman__mvResponse:
		if (p->size < 0)
			delete (struct fireman__mvResponse*)p->ptr;
		else
			delete[] (struct fireman__mvResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__mv:
		if (p->size < 0)
			delete (struct fireman__mv*)p->ptr;
		else
			delete[] (struct fireman__mv*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateModifyTimeResponse:
		if (p->size < 0)
			delete (struct fireman__updateModifyTimeResponse*)p->ptr;
		else
			delete[] (struct fireman__updateModifyTimeResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateModifyTime:
		if (p->size < 0)
			delete (struct fireman__updateModifyTime*)p->ptr;
		else
			delete[] (struct fireman__updateModifyTime*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateValidityTimeResponse:
		if (p->size < 0)
			delete (struct fireman__updateValidityTimeResponse*)p->ptr;
		else
			delete[] (struct fireman__updateValidityTimeResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateValidityTime:
		if (p->size < 0)
			delete (struct fireman__updateValidityTime*)p->ptr;
		else
			delete[] (struct fireman__updateValidityTime*)p->ptr;
		break;
	case SOAP_TYPE_fireman__readDirResponse:
		if (p->size < 0)
			delete (struct fireman__readDirResponse*)p->ptr;
		else
			delete[] (struct fireman__readDirResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__readDir:
		if (p->size < 0)
			delete (struct fireman__readDir*)p->ptr;
		else
			delete[] (struct fireman__readDir*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getGuidForLfnResponse:
		if (p->size < 0)
			delete (struct fireman__getGuidForLfnResponse*)p->ptr;
		else
			delete[] (struct fireman__getGuidForLfnResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getGuidForLfn:
		if (p->size < 0)
			delete (struct fireman__getGuidForLfn*)p->ptr;
		else
			delete[] (struct fireman__getGuidForLfn*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getLfnForGuidResponse:
		if (p->size < 0)
			delete (struct fireman__getLfnForGuidResponse*)p->ptr;
		else
			delete[] (struct fireman__getLfnForGuidResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getLfnForGuid:
		if (p->size < 0)
			delete (struct fireman__getLfnForGuid*)p->ptr;
		else
			delete[] (struct fireman__getLfnForGuid*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getFileCatalogEntryResponse:
		if (p->size < 0)
			delete (struct fireman__getFileCatalogEntryResponse*)p->ptr;
		else
			delete[] (struct fireman__getFileCatalogEntryResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getFileCatalogEntry:
		if (p->size < 0)
			delete (struct fireman__getFileCatalogEntry*)p->ptr;
		else
			delete[] (struct fireman__getFileCatalogEntry*)p->ptr;
		break;
	case SOAP_TYPE_fireman__checkPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__checkPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__checkPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__checkPermission:
		if (p->size < 0)
			delete (struct fireman__checkPermission*)p->ptr;
		else
			delete[] (struct fireman__checkPermission*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__getPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__getPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getPermission:
		if (p->size < 0)
			delete (struct fireman__getPermission*)p->ptr;
		else
			delete[] (struct fireman__getPermission*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__setPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__setPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setPermission:
		if (p->size < 0)
			delete (struct fireman__setPermission*)p->ptr;
		else
			delete[] (struct fireman__setPermission*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getVersionResponse:
		if (p->size < 0)
			delete (struct fireman__getVersionResponse*)p->ptr;
		else
			delete[] (struct fireman__getVersionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getVersion:
		if (p->size < 0)
			delete (struct fireman__getVersion*)p->ptr;
		else
			delete[] (struct fireman__getVersion*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getSchemaVersionResponse:
		if (p->size < 0)
			delete (struct fireman__getSchemaVersionResponse*)p->ptr;
		else
			delete[] (struct fireman__getSchemaVersionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getSchemaVersion:
		if (p->size < 0)
			delete (struct fireman__getSchemaVersion*)p->ptr;
		else
			delete[] (struct fireman__getSchemaVersion*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getInterfaceVersionResponse:
		if (p->size < 0)
			delete (struct fireman__getInterfaceVersionResponse*)p->ptr;
		else
			delete[] (struct fireman__getInterfaceVersionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getInterfaceVersion:
		if (p->size < 0)
			delete (struct fireman__getInterfaceVersion*)p->ptr;
		else
			delete[] (struct fireman__getInterfaceVersion*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getServiceMetadataResponse:
		if (p->size < 0)
			delete (struct fireman__getServiceMetadataResponse*)p->ptr;
		else
			delete[] (struct fireman__getServiceMetadataResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getServiceMetadata:
		if (p->size < 0)
			delete (struct fireman__getServiceMetadata*)p->ptr;
		else
			delete[] (struct fireman__getServiceMetadata*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getAttributesResponse:
		if (p->size < 0)
			delete (struct fireman__getAttributesResponse*)p->ptr;
		else
			delete[] (struct fireman__getAttributesResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getAttributes:
		if (p->size < 0)
			delete (struct fireman__getAttributes*)p->ptr;
		else
			delete[] (struct fireman__getAttributes*)p->ptr;
		break;
	case SOAP_TYPE_fireman__queryResponse:
		if (p->size < 0)
			delete (struct fireman__queryResponse*)p->ptr;
		else
			delete[] (struct fireman__queryResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__query:
		if (p->size < 0)
			delete (struct fireman__query*)p->ptr;
		else
			delete[] (struct fireman__query*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setAttributesResponse:
		if (p->size < 0)
			delete (struct fireman__setAttributesResponse*)p->ptr;
		else
			delete[] (struct fireman__setAttributesResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setAttributes:
		if (p->size < 0)
			delete (struct fireman__setAttributes*)p->ptr;
		else
			delete[] (struct fireman__setAttributes*)p->ptr;
		break;
	case SOAP_TYPE_fireman__clearAttributesResponse:
		if (p->size < 0)
			delete (struct fireman__clearAttributesResponse*)p->ptr;
		else
			delete[] (struct fireman__clearAttributesResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__clearAttributes:
		if (p->size < 0)
			delete (struct fireman__clearAttributes*)p->ptr;
		else
			delete[] (struct fireman__clearAttributes*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listAttributesResponse:
		if (p->size < 0)
			delete (struct fireman__listAttributesResponse*)p->ptr;
		else
			delete[] (struct fireman__listAttributesResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listAttributes:
		if (p->size < 0)
			delete (struct fireman__listAttributes*)p->ptr;
		else
			delete[] (struct fireman__listAttributes*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateStatusResponse:
		if (p->size < 0)
			delete (struct fireman__updateStatusResponse*)p->ptr;
		else
			delete[] (struct fireman__updateStatusResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateStatus:
		if (p->size < 0)
			delete (struct fireman__updateStatus*)p->ptr;
		else
			delete[] (struct fireman__updateStatus*)p->ptr;
		break;
	case SOAP_TYPE_fireman__createGuidResponse:
		if (p->size < 0)
			delete (struct fireman__createGuidResponse*)p->ptr;
		else
			delete[] (struct fireman__createGuidResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__createGuid:
		if (p->size < 0)
			delete (struct fireman__createGuid*)p->ptr;
		else
			delete[] (struct fireman__createGuid*)p->ptr;
		break;
	case SOAP_TYPE_fireman__addGuidReplicaResponse:
		if (p->size < 0)
			delete (struct fireman__addGuidReplicaResponse*)p->ptr;
		else
			delete[] (struct fireman__addGuidReplicaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__addGuidReplica:
		if (p->size < 0)
			delete (struct fireman__addGuidReplica*)p->ptr;
		else
			delete[] (struct fireman__addGuidReplica*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateGuidStatResponse:
		if (p->size < 0)
			delete (struct fireman__updateGuidStatResponse*)p->ptr;
		else
			delete[] (struct fireman__updateGuidStatResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateGuidStat:
		if (p->size < 0)
			delete (struct fireman__updateGuidStat*)p->ptr;
		else
			delete[] (struct fireman__updateGuidStat*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateSurlStatResponse:
		if (p->size < 0)
			delete (struct fireman__updateSurlStatResponse*)p->ptr;
		else
			delete[] (struct fireman__updateSurlStatResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__updateSurlStat:
		if (p->size < 0)
			delete (struct fireman__updateSurlStat*)p->ptr;
		else
			delete[] (struct fireman__updateSurlStat*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setMasterReplicaResponse:
		if (p->size < 0)
			delete (struct fireman__setMasterReplicaResponse*)p->ptr;
		else
			delete[] (struct fireman__setMasterReplicaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setMasterReplica:
		if (p->size < 0)
			delete (struct fireman__setMasterReplica*)p->ptr;
		else
			delete[] (struct fireman__setMasterReplica*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeGuidReplicaResponse:
		if (p->size < 0)
			delete (struct fireman__removeGuidReplicaResponse*)p->ptr;
		else
			delete[] (struct fireman__removeGuidReplicaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeGuidReplica:
		if (p->size < 0)
			delete (struct fireman__removeGuidReplica*)p->ptr;
		else
			delete[] (struct fireman__removeGuidReplica*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeGuidResponse:
		if (p->size < 0)
			delete (struct fireman__removeGuidResponse*)p->ptr;
		else
			delete[] (struct fireman__removeGuidResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__removeGuid:
		if (p->size < 0)
			delete (struct fireman__removeGuid*)p->ptr;
		else
			delete[] (struct fireman__removeGuid*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__setDefaultPrincipalPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__setDefaultPrincipalPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setDefaultPrincipalPermission:
		if (p->size < 0)
			delete (struct fireman__setDefaultPrincipalPermission*)p->ptr;
		else
			delete[] (struct fireman__setDefaultPrincipalPermission*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__setDefaultGlobalPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__setDefaultGlobalPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__setDefaultGlobalPermission:
		if (p->size < 0)
			delete (struct fireman__setDefaultGlobalPermission*)p->ptr;
		else
			delete[] (struct fireman__setDefaultGlobalPermission*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getGuidForSurlResponse:
		if (p->size < 0)
			delete (struct fireman__getGuidForSurlResponse*)p->ptr;
		else
			delete[] (struct fireman__getGuidForSurlResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getGuidForSurl:
		if (p->size < 0)
			delete (struct fireman__getGuidForSurl*)p->ptr;
		else
			delete[] (struct fireman__getGuidForSurl*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getMasterReplicaResponse:
		if (p->size < 0)
			delete (struct fireman__getMasterReplicaResponse*)p->ptr;
		else
			delete[] (struct fireman__getMasterReplicaResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getMasterReplica:
		if (p->size < 0)
			delete (struct fireman__getMasterReplica*)p->ptr;
		else
			delete[] (struct fireman__getMasterReplica*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listSurlsByGuidResponse:
		if (p->size < 0)
			delete (struct fireman__listSurlsByGuidResponse*)p->ptr;
		else
			delete[] (struct fireman__listSurlsByGuidResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listSurlsByGuid:
		if (p->size < 0)
			delete (struct fireman__listSurlsByGuid*)p->ptr;
		else
			delete[] (struct fireman__listSurlsByGuid*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listReplicasByGuidResponse:
		if (p->size < 0)
			delete (struct fireman__listReplicasByGuidResponse*)p->ptr;
		else
			delete[] (struct fireman__listReplicasByGuidResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__listReplicasByGuid:
		if (p->size < 0)
			delete (struct fireman__listReplicasByGuid*)p->ptr;
		else
			delete[] (struct fireman__listReplicasByGuid*)p->ptr;
		break;
	case SOAP_TYPE_fireman__hasGuidResponse:
		if (p->size < 0)
			delete (struct fireman__hasGuidResponse*)p->ptr;
		else
			delete[] (struct fireman__hasGuidResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__hasGuid:
		if (p->size < 0)
			delete (struct fireman__hasGuid*)p->ptr;
		else
			delete[] (struct fireman__hasGuid*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getGuidStatResponse:
		if (p->size < 0)
			delete (struct fireman__getGuidStatResponse*)p->ptr;
		else
			delete[] (struct fireman__getGuidStatResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getGuidStat:
		if (p->size < 0)
			delete (struct fireman__getGuidStat*)p->ptr;
		else
			delete[] (struct fireman__getGuidStat*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getSurlStatResponse:
		if (p->size < 0)
			delete (struct fireman__getSurlStatResponse*)p->ptr;
		else
			delete[] (struct fireman__getSurlStatResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getSurlStat:
		if (p->size < 0)
			delete (struct fireman__getSurlStat*)p->ptr;
		else
			delete[] (struct fireman__getSurlStat*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__getDefaultPrincipalPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__getDefaultPrincipalPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getDefaultPrincipalPermission:
		if (p->size < 0)
			delete (struct fireman__getDefaultPrincipalPermission*)p->ptr;
		else
			delete[] (struct fireman__getDefaultPrincipalPermission*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse:
		if (p->size < 0)
			delete (struct fireman__getDefaultGlobalPermissionResponse*)p->ptr;
		else
			delete[] (struct fireman__getDefaultGlobalPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_fireman__getDefaultGlobalPermission:
		if (p->size < 0)
			delete (struct fireman__getDefaultGlobalPermission*)p->ptr;
		else
			delete[] (struct fireman__getDefaultGlobalPermission*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_code_str(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

void _NotExistsException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__NotExistsException(soap, &((_NotExistsException*)this)->fault);
	/* transient soap skipped */
}

void _NotExistsException::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_NotExistsException*)this)->fault = NULL;
	/* transient soap skipped */
}

int _NotExistsException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__NotExistsException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _NotExistsException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__NotExistsException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__NotExistsException(struct soap *soap, const char *tag, int id, const _NotExistsException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__NotExistsException), type);
	soap_out_PointerToglite__NotExistsException(soap, "fault", -1, &(((_NotExistsException*)a)->fault), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_NotExistsException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__NotExistsException(soap, this, tag, type);
}

SOAP_FMAC3 _NotExistsException * SOAP_FMAC4 soap_get__NotExistsException(struct soap *soap, _NotExistsException *p, const char *tag, const char *type)
{
	if ((p = soap_in__NotExistsException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_NotExistsException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__NotExistsException(soap, tag, this, type);
}

SOAP_FMAC3 _NotExistsException * SOAP_FMAC4 soap_in__NotExistsException(struct soap *soap, const char *tag, _NotExistsException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_NotExistsException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__NotExistsException, sizeof(_NotExistsException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__NotExistsException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_NotExistsException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__NotExistsException(soap, "fault", &(((_NotExistsException*)a)->fault), "glite:NotExistsException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_NotExistsException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__NotExistsException, 0, sizeof(_NotExistsException), 0, soap_copy__NotExistsException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _NotExistsException * SOAP_FMAC6 soap_new__NotExistsException(struct soap *soap, int n)
{	return soap_instantiate__NotExistsException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__NotExistsException(struct soap *soap, _NotExistsException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _NotExistsException * SOAP_FMAC4 soap_instantiate__NotExistsException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__NotExistsException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__NotExistsException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _NotExistsException;
		if (size)
			*size = sizeof(_NotExistsException);
		((_NotExistsException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _NotExistsException[n];
		if (size)
			*size = n * sizeof(_NotExistsException);
		for (int i = 0; i < n; i++)
			((_NotExistsException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_NotExistsException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__NotExistsException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _NotExistsException %p -> %p\n", q, p));
	*(_NotExistsException*)p = *(_NotExistsException*)q;
}

void _InvalidArgumentException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__InvalidArgumentException(soap, &((_InvalidArgumentException*)this)->fault);
	/* transient soap skipped */
}

void _InvalidArgumentException::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_InvalidArgumentException*)this)->fault = NULL;
	/* transient soap skipped */
}

int _InvalidArgumentException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__InvalidArgumentException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _InvalidArgumentException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__InvalidArgumentException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__InvalidArgumentException(struct soap *soap, const char *tag, int id, const _InvalidArgumentException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__InvalidArgumentException), type);
	soap_out_PointerToglite__InvalidArgumentException(soap, "fault", -1, &(((_InvalidArgumentException*)a)->fault), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_InvalidArgumentException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__InvalidArgumentException(soap, this, tag, type);
}

SOAP_FMAC3 _InvalidArgumentException * SOAP_FMAC4 soap_get__InvalidArgumentException(struct soap *soap, _InvalidArgumentException *p, const char *tag, const char *type)
{
	if ((p = soap_in__InvalidArgumentException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_InvalidArgumentException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__InvalidArgumentException(soap, tag, this, type);
}

SOAP_FMAC3 _InvalidArgumentException * SOAP_FMAC4 soap_in__InvalidArgumentException(struct soap *soap, const char *tag, _InvalidArgumentException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_InvalidArgumentException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__InvalidArgumentException, sizeof(_InvalidArgumentException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__InvalidArgumentException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_InvalidArgumentException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__InvalidArgumentException(soap, "fault", &(((_InvalidArgumentException*)a)->fault), "glite:InvalidArgumentException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_InvalidArgumentException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__InvalidArgumentException, 0, sizeof(_InvalidArgumentException), 0, soap_copy__InvalidArgumentException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _InvalidArgumentException * SOAP_FMAC6 soap_new__InvalidArgumentException(struct soap *soap, int n)
{	return soap_instantiate__InvalidArgumentException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__InvalidArgumentException(struct soap *soap, _InvalidArgumentException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _InvalidArgumentException * SOAP_FMAC4 soap_instantiate__InvalidArgumentException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__InvalidArgumentException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__InvalidArgumentException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _InvalidArgumentException;
		if (size)
			*size = sizeof(_InvalidArgumentException);
		((_InvalidArgumentException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _InvalidArgumentException[n];
		if (size)
			*size = n * sizeof(_InvalidArgumentException);
		for (int i = 0; i < n; i++)
			((_InvalidArgumentException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_InvalidArgumentException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__InvalidArgumentException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _InvalidArgumentException %p -> %p\n", q, p));
	*(_InvalidArgumentException*)p = *(_InvalidArgumentException*)q;
}

void _InternalException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__InternalException(soap, &((_InternalException*)this)->fault);
	/* transient soap skipped */
}

void _InternalException::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_InternalException*)this)->fault = NULL;
	/* transient soap skipped */
}

int _InternalException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__InternalException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _InternalException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__InternalException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__InternalException(struct soap *soap, const char *tag, int id, const _InternalException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__InternalException), type);
	soap_out_PointerToglite__InternalException(soap, "fault", -1, &(((_InternalException*)a)->fault), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_InternalException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__InternalException(soap, this, tag, type);
}

SOAP_FMAC3 _InternalException * SOAP_FMAC4 soap_get__InternalException(struct soap *soap, _InternalException *p, const char *tag, const char *type)
{
	if ((p = soap_in__InternalException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_InternalException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__InternalException(soap, tag, this, type);
}

SOAP_FMAC3 _InternalException * SOAP_FMAC4 soap_in__InternalException(struct soap *soap, const char *tag, _InternalException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_InternalException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__InternalException, sizeof(_InternalException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__InternalException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_InternalException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__InternalException(soap, "fault", &(((_InternalException*)a)->fault), "glite:InternalException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_InternalException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__InternalException, 0, sizeof(_InternalException), 0, soap_copy__InternalException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _InternalException * SOAP_FMAC6 soap_new__InternalException(struct soap *soap, int n)
{	return soap_instantiate__InternalException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__InternalException(struct soap *soap, _InternalException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _InternalException * SOAP_FMAC4 soap_instantiate__InternalException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__InternalException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__InternalException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _InternalException;
		if (size)
			*size = sizeof(_InternalException);
		((_InternalException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _InternalException[n];
		if (size)
			*size = n * sizeof(_InternalException);
		for (int i = 0; i < n; i++)
			((_InternalException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_InternalException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__InternalException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _InternalException %p -> %p\n", q, p));
	*(_InternalException*)p = *(_InternalException*)q;
}

void _ExistsException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__ExistsException(soap, &((_ExistsException*)this)->fault);
	/* transient soap skipped */
}

void _ExistsException::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ExistsException*)this)->fault = NULL;
	/* transient soap skipped */
}

int _ExistsException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ExistsException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ExistsException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ExistsException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ExistsException(struct soap *soap, const char *tag, int id, const _ExistsException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ExistsException), type);
	soap_out_PointerToglite__ExistsException(soap, "fault", -1, &(((_ExistsException*)a)->fault), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ExistsException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ExistsException(soap, this, tag, type);
}

SOAP_FMAC3 _ExistsException * SOAP_FMAC4 soap_get__ExistsException(struct soap *soap, _ExistsException *p, const char *tag, const char *type)
{
	if ((p = soap_in__ExistsException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ExistsException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ExistsException(soap, tag, this, type);
}

SOAP_FMAC3 _ExistsException * SOAP_FMAC4 soap_in__ExistsException(struct soap *soap, const char *tag, _ExistsException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ExistsException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ExistsException, sizeof(_ExistsException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ExistsException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ExistsException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__ExistsException(soap, "fault", &(((_ExistsException*)a)->fault), "glite:ExistsException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ExistsException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__ExistsException, 0, sizeof(_ExistsException), 0, soap_copy__ExistsException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ExistsException * SOAP_FMAC6 soap_new__ExistsException(struct soap *soap, int n)
{	return soap_instantiate__ExistsException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ExistsException(struct soap *soap, _ExistsException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _ExistsException * SOAP_FMAC4 soap_instantiate__ExistsException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ExistsException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ExistsException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ExistsException;
		if (size)
			*size = sizeof(_ExistsException);
		((_ExistsException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ExistsException[n];
		if (size)
			*size = n * sizeof(_ExistsException);
		for (int i = 0; i < n; i++)
			((_ExistsException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ExistsException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ExistsException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ExistsException %p -> %p\n", q, p));
	*(_ExistsException*)p = *(_ExistsException*)q;
}

void _AuthorizationException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__AuthorizationException(soap, &((_AuthorizationException*)this)->fault);
	/* transient soap skipped */
}

void _AuthorizationException::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_AuthorizationException*)this)->fault = NULL;
	/* transient soap skipped */
}

int _AuthorizationException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__AuthorizationException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _AuthorizationException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__AuthorizationException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__AuthorizationException(struct soap *soap, const char *tag, int id, const _AuthorizationException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__AuthorizationException), type);
	soap_out_PointerToglite__AuthorizationException(soap, "fault", -1, &(((_AuthorizationException*)a)->fault), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_AuthorizationException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__AuthorizationException(soap, this, tag, type);
}

SOAP_FMAC3 _AuthorizationException * SOAP_FMAC4 soap_get__AuthorizationException(struct soap *soap, _AuthorizationException *p, const char *tag, const char *type)
{
	if ((p = soap_in__AuthorizationException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_AuthorizationException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__AuthorizationException(soap, tag, this, type);
}

SOAP_FMAC3 _AuthorizationException * SOAP_FMAC4 soap_in__AuthorizationException(struct soap *soap, const char *tag, _AuthorizationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_AuthorizationException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__AuthorizationException, sizeof(_AuthorizationException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__AuthorizationException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_AuthorizationException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__AuthorizationException(soap, "fault", &(((_AuthorizationException*)a)->fault), "glite:AuthorizationException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_AuthorizationException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE__AuthorizationException, 0, sizeof(_AuthorizationException), 0, soap_copy__AuthorizationException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _AuthorizationException * SOAP_FMAC6 soap_new__AuthorizationException(struct soap *soap, int n)
{	return soap_instantiate__AuthorizationException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__AuthorizationException(struct soap *soap, _AuthorizationException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 _AuthorizationException * SOAP_FMAC4 soap_instantiate__AuthorizationException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__AuthorizationException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__AuthorizationException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _AuthorizationException;
		if (size)
			*size = sizeof(_AuthorizationException);
		((_AuthorizationException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _AuthorizationException[n];
		if (size)
			*size = n * sizeof(_AuthorizationException);
		for (int i = 0; i < n; i++)
			((_AuthorizationException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_AuthorizationException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__AuthorizationException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _AuthorizationException %p -> %p\n", q, p));
	*(_AuthorizationException*)p = *(_AuthorizationException*)q;
}

void glite__StringBoolean::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__StringBoolean*)this)->string);
	/* transient soap skipped */
}

void glite__StringBoolean::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__StringBoolean*)this)->string);
	soap_default_bool(soap, &((glite__StringBoolean*)this)->bool_);
	/* transient soap skipped */
}

int glite__StringBoolean::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__StringBoolean);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__StringBoolean::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__StringBoolean(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__StringBoolean(struct soap *soap, const char *tag, int id, const glite__StringBoolean *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__StringBoolean), type);
	soap_out_string(soap, "string", -1, &(((glite__StringBoolean*)a)->string), "");
	soap_out_bool(soap, "bool", -1, &(((glite__StringBoolean*)a)->bool_), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__StringBoolean::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__StringBoolean(soap, this, tag, type);
}

SOAP_FMAC3 glite__StringBoolean * SOAP_FMAC4 soap_get_glite__StringBoolean(struct soap *soap, glite__StringBoolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__StringBoolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__StringBoolean::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__StringBoolean(soap, tag, this, type);
}

SOAP_FMAC3 glite__StringBoolean * SOAP_FMAC4 soap_in_glite__StringBoolean(struct soap *soap, const char *tag, glite__StringBoolean *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__StringBoolean *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__StringBoolean, sizeof(glite__StringBoolean), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__StringBoolean)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__StringBoolean *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_string1 = 1, soap_flag_bool_1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_string1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "string", &(((glite__StringBoolean*)a)->string), "xsd:string"))
				{	soap_flag_string1--;
					continue;
				}
			if (soap_flag_bool_1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "bool", &(((glite__StringBoolean*)a)->bool_), "xsd:boolean"))
				{	soap_flag_bool_1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_bool_1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__StringBoolean *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__StringBoolean, 0, sizeof(glite__StringBoolean), 0, soap_copy_glite__StringBoolean);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__StringBoolean * SOAP_FMAC6 soap_new_glite__StringBoolean(struct soap *soap, int n)
{	return soap_instantiate_glite__StringBoolean(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__StringBoolean(struct soap *soap, glite__StringBoolean *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__StringBoolean * SOAP_FMAC4 soap_instantiate_glite__StringBoolean(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__StringBoolean(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__StringBoolean, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__StringBoolean;
		if (size)
			*size = sizeof(glite__StringBoolean);
		((glite__StringBoolean*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__StringBoolean[n];
		if (size)
			*size = n * sizeof(glite__StringBoolean);
		for (int i = 0; i < n; i++)
			((glite__StringBoolean*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__StringBoolean*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__StringBoolean(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__StringBoolean %p -> %p\n", q, p));
	*(glite__StringBoolean*)p = *(glite__StringBoolean*)q;
}

void glite__Attribute::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__Attribute*)this)->name);
	soap_serialize_string(soap, &((glite__Attribute*)this)->value);
	soap_serialize_string(soap, &((glite__Attribute*)this)->type);
	/* transient soap skipped */
}

void glite__Attribute::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__Attribute*)this)->name);
	soap_default_string(soap, &((glite__Attribute*)this)->value);
	soap_default_string(soap, &((glite__Attribute*)this)->type);
	/* transient soap skipped */
}

int glite__Attribute::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__Attribute);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__Attribute::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__Attribute(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__Attribute(struct soap *soap, const char *tag, int id, const glite__Attribute *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__Attribute), type);
	soap_out_string(soap, "name", -1, &(((glite__Attribute*)a)->name), "");
	soap_out_string(soap, "value", -1, &(((glite__Attribute*)a)->value), "");
	soap_out_string(soap, "type", -1, &(((glite__Attribute*)a)->type), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__Attribute::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__Attribute(soap, this, tag, type);
}

SOAP_FMAC3 glite__Attribute * SOAP_FMAC4 soap_get_glite__Attribute(struct soap *soap, glite__Attribute *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__Attribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__Attribute::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__Attribute(soap, tag, this, type);
}

SOAP_FMAC3 glite__Attribute * SOAP_FMAC4 soap_in_glite__Attribute(struct soap *soap, const char *tag, glite__Attribute *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__Attribute *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__Attribute, sizeof(glite__Attribute), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__Attribute)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__Attribute *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_name1 = 1, soap_flag_value1 = 1, soap_flag_type1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(((glite__Attribute*)a)->name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap_flag_value1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &(((glite__Attribute*)a)->value), "xsd:string"))
				{	soap_flag_value1--;
					continue;
				}
			if (soap_flag_type1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(((glite__Attribute*)a)->type), "xsd:string"))
				{	soap_flag_type1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__Attribute *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__Attribute, 0, sizeof(glite__Attribute), 0, soap_copy_glite__Attribute);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__Attribute * SOAP_FMAC6 soap_new_glite__Attribute(struct soap *soap, int n)
{	return soap_instantiate_glite__Attribute(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__Attribute(struct soap *soap, glite__Attribute *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__Attribute * SOAP_FMAC4 soap_instantiate_glite__Attribute(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__Attribute(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__Attribute, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__Attribute;
		if (size)
			*size = sizeof(glite__Attribute);
		((glite__Attribute*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__Attribute[n];
		if (size)
			*size = n * sizeof(glite__Attribute);
		for (int i = 0; i < n; i++)
			((glite__Attribute*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__Attribute*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__Attribute(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__Attribute %p -> %p\n", q, p));
	*(glite__Attribute*)p = *(glite__Attribute*)q;
}

void glite__PermissionEntry::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__PermissionEntry*)this)->item);
	soap_serialize_PointerToglite__Permission(soap, &((glite__PermissionEntry*)this)->permission);
	/* transient soap skipped */
}

void glite__PermissionEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__PermissionEntry*)this)->item);
	((glite__PermissionEntry*)this)->permission = NULL;
	/* transient soap skipped */
}

int glite__PermissionEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__PermissionEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__PermissionEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__PermissionEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__PermissionEntry(struct soap *soap, const char *tag, int id, const glite__PermissionEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__PermissionEntry), type);
	soap_out_string(soap, "item", -1, &(((glite__PermissionEntry*)a)->item), "");
	soap_out_PointerToglite__Permission(soap, "permission", -1, &(((glite__PermissionEntry*)a)->permission), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__PermissionEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__PermissionEntry(soap, this, tag, type);
}

SOAP_FMAC3 glite__PermissionEntry * SOAP_FMAC4 soap_get_glite__PermissionEntry(struct soap *soap, glite__PermissionEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__PermissionEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__PermissionEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__PermissionEntry(soap, tag, this, type);
}

SOAP_FMAC3 glite__PermissionEntry * SOAP_FMAC4 soap_in_glite__PermissionEntry(struct soap *soap, const char *tag, glite__PermissionEntry *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__PermissionEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__PermissionEntry, sizeof(glite__PermissionEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__PermissionEntry)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__PermissionEntry *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_item1 = 1, soap_flag_permission1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_item1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "item", &(((glite__PermissionEntry*)a)->item), "xsd:string"))
				{	soap_flag_item1--;
					continue;
				}
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, "permission", &(((glite__PermissionEntry*)a)->permission), "glite:Permission"))
				{	soap_flag_permission1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__PermissionEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__PermissionEntry, 0, sizeof(glite__PermissionEntry), 0, soap_copy_glite__PermissionEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__PermissionEntry * SOAP_FMAC6 soap_new_glite__PermissionEntry(struct soap *soap, int n)
{	return soap_instantiate_glite__PermissionEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__PermissionEntry(struct soap *soap, glite__PermissionEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__PermissionEntry * SOAP_FMAC4 soap_instantiate_glite__PermissionEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__PermissionEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__PermissionEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__PermissionEntry;
		if (size)
			*size = sizeof(glite__PermissionEntry);
		((glite__PermissionEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__PermissionEntry[n];
		if (size)
			*size = n * sizeof(glite__PermissionEntry);
		for (int i = 0; i < n; i++)
			((glite__PermissionEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__PermissionEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__PermissionEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__PermissionEntry %p -> %p\n", q, p));
	*(glite__PermissionEntry*)p = *(glite__PermissionEntry*)q;
}

void glite__FCEntry::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__FCEntry*)this)->lfn);
	soap_serialize_string(soap, &((glite__FCEntry*)this)->guid);
	soap_serialize_PointerToglite__Permission(soap, &((glite__FCEntry*)this)->permission);
	soap_serialize_PointerToglite__LFNStat(soap, &((glite__FCEntry*)this)->lfnStat);
	/* transient soap skipped */
}

void glite__FCEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__FCEntry*)this)->lfn);
	soap_default_string(soap, &((glite__FCEntry*)this)->guid);
	((glite__FCEntry*)this)->permission = NULL;
	((glite__FCEntry*)this)->lfnStat = NULL;
	/* transient soap skipped */
}

int glite__FCEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__FCEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__FCEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__FCEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__FCEntry(struct soap *soap, const char *tag, int id, const glite__FCEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__FCEntry), type);
	soap_out_string(soap, "lfn", -1, &(((glite__FCEntry*)a)->lfn), "");
	soap_out_string(soap, "guid", -1, &(((glite__FCEntry*)a)->guid), "");
	soap_out_PointerToglite__Permission(soap, "permission", -1, &(((glite__FCEntry*)a)->permission), "");
	soap_out_PointerToglite__LFNStat(soap, "lfnStat", -1, &(((glite__FCEntry*)a)->lfnStat), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__FCEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__FCEntry(soap, this, tag, type);
}

SOAP_FMAC3 glite__FCEntry * SOAP_FMAC4 soap_get_glite__FCEntry(struct soap *soap, glite__FCEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__FCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__FCEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__FCEntry(soap, tag, this, type);
}

SOAP_FMAC3 glite__FCEntry * SOAP_FMAC4 soap_in_glite__FCEntry(struct soap *soap, const char *tag, glite__FCEntry *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__FCEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__FCEntry, sizeof(glite__FCEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__FCEntry)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__FCEntry *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_lfn1 = 1, soap_flag_guid1 = 1, soap_flag_permission1 = 1, soap_flag_lfnStat1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lfn1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "lfn", &(((glite__FCEntry*)a)->lfn), "xsd:string"))
				{	soap_flag_lfn1--;
					continue;
				}
			if (soap_flag_guid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "guid", &(((glite__FCEntry*)a)->guid), "xsd:string"))
				{	soap_flag_guid1--;
					continue;
				}
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, "permission", &(((glite__FCEntry*)a)->permission), "glite:Permission"))
				{	soap_flag_permission1--;
					continue;
				}
			if (soap_flag_lfnStat1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__LFNStat(soap, "lfnStat", &(((glite__FCEntry*)a)->lfnStat), "glite:LFNStat"))
				{	soap_flag_lfnStat1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__FCEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__FCEntry, 0, sizeof(glite__FCEntry), 0, soap_copy_glite__FCEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__FCEntry * SOAP_FMAC6 soap_new_glite__FCEntry(struct soap *soap, int n)
{	return soap_instantiate_glite__FCEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__FCEntry(struct soap *soap, glite__FCEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__FCEntry * SOAP_FMAC4 soap_instantiate_glite__FCEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__FCEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__FCEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__FCEntry;
		if (size)
			*size = sizeof(glite__FCEntry);
		((glite__FCEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__FCEntry[n];
		if (size)
			*size = n * sizeof(glite__FCEntry);
		for (int i = 0; i < n; i++)
			((glite__FCEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__FCEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__FCEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__FCEntry %p -> %p\n", q, p));
	*(glite__FCEntry*)p = *(glite__FCEntry*)q;
}

void glite__StringPair::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__StringPair*)this)->string1);
	soap_serialize_string(soap, &((glite__StringPair*)this)->string2);
	/* transient soap skipped */
}

void glite__StringPair::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__StringPair*)this)->string1);
	soap_default_string(soap, &((glite__StringPair*)this)->string2);
	/* transient soap skipped */
}

int glite__StringPair::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__StringPair);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__StringPair::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__StringPair(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__StringPair(struct soap *soap, const char *tag, int id, const glite__StringPair *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__StringPair), type);
	soap_out_string(soap, "string1", -1, &(((glite__StringPair*)a)->string1), "");
	soap_out_string(soap, "string2", -1, &(((glite__StringPair*)a)->string2), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__StringPair::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__StringPair(soap, this, tag, type);
}

SOAP_FMAC3 glite__StringPair * SOAP_FMAC4 soap_get_glite__StringPair(struct soap *soap, glite__StringPair *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__StringPair(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__StringPair::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__StringPair(soap, tag, this, type);
}

SOAP_FMAC3 glite__StringPair * SOAP_FMAC4 soap_in_glite__StringPair(struct soap *soap, const char *tag, glite__StringPair *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__StringPair *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__StringPair, sizeof(glite__StringPair), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__StringPair)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__StringPair *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_string11 = 1, soap_flag_string21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_string11 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "string1", &(((glite__StringPair*)a)->string1), "xsd:string"))
				{	soap_flag_string11--;
					continue;
				}
			if (soap_flag_string21 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "string2", &(((glite__StringPair*)a)->string2), "xsd:string"))
				{	soap_flag_string21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__StringPair *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__StringPair, 0, sizeof(glite__StringPair), 0, soap_copy_glite__StringPair);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__StringPair * SOAP_FMAC6 soap_new_glite__StringPair(struct soap *soap, int n)
{	return soap_instantiate_glite__StringPair(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__StringPair(struct soap *soap, glite__StringPair *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__StringPair * SOAP_FMAC4 soap_instantiate_glite__StringPair(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__StringPair(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__StringPair, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__StringPair;
		if (size)
			*size = sizeof(glite__StringPair);
		((glite__StringPair*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__StringPair[n];
		if (size)
			*size = n * sizeof(glite__StringPair);
		for (int i = 0; i < n; i++)
			((glite__StringPair*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__StringPair*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__StringPair(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__StringPair %p -> %p\n", q, p));
	*(glite__StringPair*)p = *(glite__StringPair*)q;
}

void glite__ExistsException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

void glite__ExistsException::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

int glite__ExistsException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__ExistsException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__ExistsException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__ExistsException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__ExistsException(struct soap *soap, const char *tag, int id, const glite__ExistsException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__ExistsException), "glite:ExistsException");
	soap_out_string(soap, "message", -1, &(((glite__CatalogException*)a)->message), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__ExistsException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__ExistsException(soap, this, tag, type);
}

SOAP_FMAC3 glite__ExistsException * SOAP_FMAC4 soap_get_glite__ExistsException(struct soap *soap, glite__ExistsException *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__ExistsException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__ExistsException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__ExistsException(soap, tag, this, type);
}

SOAP_FMAC3 glite__ExistsException * SOAP_FMAC4 soap_in_glite__ExistsException(struct soap *soap, const char *tag, glite__ExistsException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__ExistsException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__ExistsException, sizeof(glite__ExistsException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__ExistsException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__ExistsException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_message2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_message2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "message", &(((glite__CatalogException*)a)->message), "xsd:string"))
				{	soap_flag_message2--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__ExistsException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__ExistsException, 0, sizeof(glite__ExistsException), 0, soap_copy_glite__ExistsException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__ExistsException * SOAP_FMAC6 soap_new_glite__ExistsException(struct soap *soap, int n)
{	return soap_instantiate_glite__ExistsException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__ExistsException(struct soap *soap, glite__ExistsException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__ExistsException * SOAP_FMAC4 soap_instantiate_glite__ExistsException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__ExistsException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__ExistsException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__ExistsException;
		if (size)
			*size = sizeof(glite__ExistsException);
		((glite__ExistsException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__ExistsException[n];
		if (size)
			*size = n * sizeof(glite__ExistsException);
		for (int i = 0; i < n; i++)
			((glite__ExistsException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__ExistsException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__ExistsException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__ExistsException %p -> %p\n", q, p));
	*(glite__ExistsException*)p = *(glite__ExistsException*)q;
}

void glite__FRCEntry::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__FRCEntry*)this)->lfn);
	soap_serialize_PointerToglite__LFNStat(soap, &((glite__FRCEntry*)this)->lfnStat);
	soap_serialize_string(soap, &((glite__RCEntry*)this)->guid);
	soap_serialize_PointerToglite__GUIDStat(soap, &((glite__RCEntry*)this)->GUIDStat);
	soap_serialize_PointerToglite__Permission(soap, &((glite__RCEntry*)this)->permission);
	if (((glite__RCEntry*)this)->surlStats)
	{	int i;
		for (i = 0; i < ((glite__RCEntry*)this)->__sizesurlStats; i++)
		{
			soap_serialize_PointerToglite__SURLEntry(soap, ((glite__RCEntry*)this)->surlStats + i);
		}
	}
	/* transient soap skipped */
}

void glite__FRCEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__FRCEntry*)this)->lfn);
	((glite__FRCEntry*)this)->lfnStat = NULL;
	soap_default_string(soap, &((glite__RCEntry*)this)->guid);
	((glite__RCEntry*)this)->GUIDStat = NULL;
	((glite__RCEntry*)this)->permission = NULL;
	((glite__RCEntry*)this)->__sizesurlStats = 0;
	((glite__RCEntry*)this)->surlStats = NULL;
	/* transient soap skipped */
}

int glite__FRCEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__FRCEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__FRCEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__FRCEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__FRCEntry(struct soap *soap, const char *tag, int id, const glite__FRCEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__FRCEntry), "glite:FRCEntry");
	soap_out_string(soap, "guid", -1, &(((glite__RCEntry*)a)->guid), "");
	soap_out_PointerToglite__GUIDStat(soap, "GUIDStat", -1, &(((glite__RCEntry*)a)->GUIDStat), "");
	soap_out_PointerToglite__Permission(soap, "permission", -1, &(((glite__RCEntry*)a)->permission), "");
	if (((glite__RCEntry*)a)->surlStats)
	{	int i;
		for (i = 0; i < ((glite__RCEntry*)a)->__sizesurlStats; i++)
			soap_out_PointerToglite__SURLEntry(soap, "surlStats", -1, ((glite__RCEntry*)a)->surlStats + i, "");
	}
	/* transient soap skipped */
	soap_out_string(soap, "lfn", -1, &(((glite__FRCEntry*)a)->lfn), "");
	soap_out_PointerToglite__LFNStat(soap, "lfnStat", -1, &(((glite__FRCEntry*)a)->lfnStat), "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__FRCEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__FRCEntry(soap, this, tag, type);
}

SOAP_FMAC3 glite__FRCEntry * SOAP_FMAC4 soap_get_glite__FRCEntry(struct soap *soap, glite__FRCEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__FRCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__FRCEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__FRCEntry(soap, tag, this, type);
}

SOAP_FMAC3 glite__FRCEntry * SOAP_FMAC4 soap_in_glite__FRCEntry(struct soap *soap, const char *tag, glite__FRCEntry *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__FRCEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__FRCEntry, sizeof(glite__FRCEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__FRCEntry)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__FRCEntry *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_guid2 = 1, soap_flag_GUIDStat2 = 1, soap_flag_permission2 = 1, soap_flag_surlStats2 = 1, soap_flag_lfn1 = 1, soap_flag_lfnStat1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_guid2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "guid", &(((glite__RCEntry*)a)->guid), "xsd:string"))
				{	soap_flag_guid2--;
					continue;
				}
			if (soap_flag_GUIDStat2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__GUIDStat(soap, "GUIDStat", &(((glite__RCEntry*)a)->GUIDStat), "glite:GUIDStat"))
				{	soap_flag_GUIDStat2--;
					continue;
				}
			if (soap_flag_permission2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, "permission", &(((glite__RCEntry*)a)->permission), "glite:Permission"))
				{	soap_flag_permission2--;
					continue;
				}
			if (soap_flag_surlStats2 && soap->error == SOAP_TAG_MISMATCH)
			{	glite__SURLEntry **p;
				soap_new_block(soap);
				for (((glite__RCEntry*)a)->__sizesurlStats = 0; !soap_element_begin_in(soap, "surlStats", 1); ((glite__RCEntry*)a)->__sizesurlStats++)
				{	p = (glite__SURLEntry **)soap_push_block(soap, sizeof(glite__SURLEntry *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToglite__SURLEntry(soap, "surlStats", p, "glite:SURLEntry"))
						break;
					soap_flag_surlStats2 = 0;
				}
				((glite__RCEntry*)a)->surlStats = (glite__SURLEntry **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlStats2 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap_flag_lfn1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "lfn", &(((glite__FRCEntry*)a)->lfn), "xsd:string"))
				{	soap_flag_lfn1--;
					continue;
				}
			if (soap_flag_lfnStat1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__LFNStat(soap, "lfnStat", &(((glite__FRCEntry*)a)->lfnStat), "glite:LFNStat"))
				{	soap_flag_lfnStat1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__FRCEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__FRCEntry, 0, sizeof(glite__FRCEntry), 0, soap_copy_glite__FRCEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__FRCEntry * SOAP_FMAC6 soap_new_glite__FRCEntry(struct soap *soap, int n)
{	return soap_instantiate_glite__FRCEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__FRCEntry(struct soap *soap, glite__FRCEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__FRCEntry * SOAP_FMAC4 soap_instantiate_glite__FRCEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__FRCEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__FRCEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__FRCEntry;
		if (size)
			*size = sizeof(glite__FRCEntry);
		((glite__FRCEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__FRCEntry[n];
		if (size)
			*size = n * sizeof(glite__FRCEntry);
		for (int i = 0; i < n; i++)
			((glite__FRCEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__FRCEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__FRCEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__FRCEntry %p -> %p\n", q, p));
	*(glite__FRCEntry*)p = *(glite__FRCEntry*)q;
}

void glite__LFNStat::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__LFNStat*)this)->data);
	/* transient soap skipped */
}

void glite__LFNStat::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((glite__LFNStat*)this)->type);
	soap_default_string(soap, &((glite__LFNStat*)this)->data);
	soap_default_LONG64(soap, &((glite__LFNStat*)this)->validityTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->modifyTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->creationTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->size);
	/* transient soap skipped */
}

int glite__LFNStat::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__LFNStat);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__LFNStat::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__LFNStat(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__LFNStat(struct soap *soap, const char *tag, int id, const glite__LFNStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__LFNStat), "glite:LFNStat");
	soap_out_LONG64(soap, "modifyTime", -1, &(((glite__Stat*)a)->modifyTime), "");
	soap_out_LONG64(soap, "creationTime", -1, &(((glite__Stat*)a)->creationTime), "");
	soap_out_LONG64(soap, "size", -1, &(((glite__Stat*)a)->size), "");
	/* transient soap skipped */
	soap_out_int(soap, "type", -1, &(((glite__LFNStat*)a)->type), "");
	soap_out_string(soap, "data", -1, &(((glite__LFNStat*)a)->data), "");
	soap_out_LONG64(soap, "validityTime", -1, &(((glite__LFNStat*)a)->validityTime), "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__LFNStat::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__LFNStat(soap, this, tag, type);
}

SOAP_FMAC3 glite__LFNStat * SOAP_FMAC4 soap_get_glite__LFNStat(struct soap *soap, glite__LFNStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__LFNStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__LFNStat::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__LFNStat(soap, tag, this, type);
}

SOAP_FMAC3 glite__LFNStat * SOAP_FMAC4 soap_in_glite__LFNStat(struct soap *soap, const char *tag, glite__LFNStat *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__LFNStat *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__LFNStat, sizeof(glite__LFNStat), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__LFNStat)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__LFNStat *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_modifyTime2 = 1, soap_flag_creationTime2 = 1, soap_flag_size2 = 1, soap_flag_type1 = 1, soap_flag_data1 = 1, soap_flag_validityTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_modifyTime2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "modifyTime", &(((glite__Stat*)a)->modifyTime), "xsd:long"))
				{	soap_flag_modifyTime2--;
					continue;
				}
			if (soap_flag_creationTime2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "creationTime", &(((glite__Stat*)a)->creationTime), "xsd:long"))
				{	soap_flag_creationTime2--;
					continue;
				}
			if (soap_flag_size2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "size", &(((glite__Stat*)a)->size), "xsd:long"))
				{	soap_flag_size2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "type", &(((glite__LFNStat*)a)->type), "xsd:int"))
				{	soap_flag_type1--;
					continue;
				}
			if (soap_flag_data1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "data", &(((glite__LFNStat*)a)->data), "xsd:string"))
				{	soap_flag_data1--;
					continue;
				}
			if (soap_flag_validityTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "validityTime", &(((glite__LFNStat*)a)->validityTime), "xsd:long"))
				{	soap_flag_validityTime1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_modifyTime2 > 0 || soap_flag_creationTime2 > 0 || soap_flag_size2 > 0 || soap_flag_type1 > 0 || soap_flag_validityTime1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__LFNStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__LFNStat, 0, sizeof(glite__LFNStat), 0, soap_copy_glite__LFNStat);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__LFNStat * SOAP_FMAC6 soap_new_glite__LFNStat(struct soap *soap, int n)
{	return soap_instantiate_glite__LFNStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__LFNStat(struct soap *soap, glite__LFNStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__LFNStat * SOAP_FMAC4 soap_instantiate_glite__LFNStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__LFNStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__LFNStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__LFNStat;
		if (size)
			*size = sizeof(glite__LFNStat);
		((glite__LFNStat*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__LFNStat[n];
		if (size)
			*size = n * sizeof(glite__LFNStat);
		for (int i = 0; i < n; i++)
			((glite__LFNStat*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__LFNStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__LFNStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__LFNStat %p -> %p\n", q, p));
	*(glite__LFNStat*)p = *(glite__LFNStat*)q;
}

void glite__RCEntry::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__RCEntry*)this)->guid);
	soap_serialize_PointerToglite__GUIDStat(soap, &((glite__RCEntry*)this)->GUIDStat);
	soap_serialize_PointerToglite__Permission(soap, &((glite__RCEntry*)this)->permission);
	if (((glite__RCEntry*)this)->surlStats)
	{	int i;
		for (i = 0; i < ((glite__RCEntry*)this)->__sizesurlStats; i++)
		{
			soap_serialize_PointerToglite__SURLEntry(soap, ((glite__RCEntry*)this)->surlStats + i);
		}
	}
	/* transient soap skipped */
}

void glite__RCEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__RCEntry*)this)->guid);
	((glite__RCEntry*)this)->GUIDStat = NULL;
	((glite__RCEntry*)this)->permission = NULL;
	((glite__RCEntry*)this)->__sizesurlStats = 0;
	((glite__RCEntry*)this)->surlStats = NULL;
	/* transient soap skipped */
}

int glite__RCEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__RCEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__RCEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__RCEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__RCEntry(struct soap *soap, const char *tag, int id, const glite__RCEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__RCEntry), type);
	soap_out_string(soap, "guid", -1, &(((glite__RCEntry*)a)->guid), "");
	soap_out_PointerToglite__GUIDStat(soap, "GUIDStat", -1, &(((glite__RCEntry*)a)->GUIDStat), "");
	soap_out_PointerToglite__Permission(soap, "permission", -1, &(((glite__RCEntry*)a)->permission), "");
	if (((glite__RCEntry*)a)->surlStats)
	{	int i;
		for (i = 0; i < ((glite__RCEntry*)a)->__sizesurlStats; i++)
			soap_out_PointerToglite__SURLEntry(soap, "surlStats", -1, ((glite__RCEntry*)a)->surlStats + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__RCEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__RCEntry(soap, this, tag, type);
}

SOAP_FMAC3 glite__RCEntry * SOAP_FMAC4 soap_get_glite__RCEntry(struct soap *soap, glite__RCEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__RCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__RCEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__RCEntry(soap, tag, this, type);
}

SOAP_FMAC3 glite__RCEntry * SOAP_FMAC4 soap_in_glite__RCEntry(struct soap *soap, const char *tag, glite__RCEntry *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__RCEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__RCEntry, sizeof(glite__RCEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__RCEntry)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__RCEntry *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_guid1 = 1, soap_flag_GUIDStat1 = 1, soap_flag_permission1 = 1, soap_flag_surlStats1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_guid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "guid", &(((glite__RCEntry*)a)->guid), "xsd:string"))
				{	soap_flag_guid1--;
					continue;
				}
			if (soap_flag_GUIDStat1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__GUIDStat(soap, "GUIDStat", &(((glite__RCEntry*)a)->GUIDStat), "glite:GUIDStat"))
				{	soap_flag_GUIDStat1--;
					continue;
				}
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, "permission", &(((glite__RCEntry*)a)->permission), "glite:Permission"))
				{	soap_flag_permission1--;
					continue;
				}
			if (soap_flag_surlStats1 && soap->error == SOAP_TAG_MISMATCH)
			{	glite__SURLEntry **p;
				soap_new_block(soap);
				for (((glite__RCEntry*)a)->__sizesurlStats = 0; !soap_element_begin_in(soap, "surlStats", 1); ((glite__RCEntry*)a)->__sizesurlStats++)
				{	p = (glite__SURLEntry **)soap_push_block(soap, sizeof(glite__SURLEntry *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToglite__SURLEntry(soap, "surlStats", p, "glite:SURLEntry"))
						break;
					soap_flag_surlStats1 = 0;
				}
				((glite__RCEntry*)a)->surlStats = (glite__SURLEntry **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlStats1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__RCEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__RCEntry, 0, sizeof(glite__RCEntry), 0, soap_copy_glite__RCEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__RCEntry * SOAP_FMAC6 soap_new_glite__RCEntry(struct soap *soap, int n)
{	return soap_instantiate_glite__RCEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__RCEntry(struct soap *soap, glite__RCEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__RCEntry * SOAP_FMAC4 soap_instantiate_glite__RCEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__RCEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__RCEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "glite:FRCEntry"))
	{	cp->type = SOAP_TYPE_glite__FRCEntry;
		if (n < 0)
		{	cp->ptr = (void*)new glite__FRCEntry;
			if (size)
				*size = sizeof(glite__FRCEntry);
			((glite__FRCEntry*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__FRCEntry[n];
			if (size)
				*size = n * sizeof(glite__FRCEntry);
			for (int i = 0; i < n; i++)
				((glite__FRCEntry*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__FRCEntry*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new glite__RCEntry;
		if (size)
			*size = sizeof(glite__RCEntry);
		((glite__RCEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__RCEntry[n];
		if (size)
			*size = n * sizeof(glite__RCEntry);
		for (int i = 0; i < n; i++)
			((glite__RCEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__RCEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__RCEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__RCEntry %p -> %p\n", q, p));
	*(glite__RCEntry*)p = *(glite__RCEntry*)q;
}

void glite__SURLEntry::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__SURLEntry*)this)->surl);
	/* transient soap skipped */
}

void glite__SURLEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &((glite__SURLEntry*)this)->masterReplica);
	soap_default_LONG64(soap, &((glite__SURLEntry*)this)->creationTime);
	soap_default_LONG64(soap, &((glite__SURLEntry*)this)->modifyTime);
	soap_default_string(soap, &((glite__SURLEntry*)this)->surl);
	/* transient soap skipped */
}

int glite__SURLEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__SURLEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__SURLEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__SURLEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__SURLEntry(struct soap *soap, const char *tag, int id, const glite__SURLEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__SURLEntry), type);
	soap_out_bool(soap, "masterReplica", -1, &(((glite__SURLEntry*)a)->masterReplica), "");
	soap_out_LONG64(soap, "creationTime", -1, &(((glite__SURLEntry*)a)->creationTime), "");
	soap_out_LONG64(soap, "modifyTime", -1, &(((glite__SURLEntry*)a)->modifyTime), "");
	soap_out_string(soap, "surl", -1, &(((glite__SURLEntry*)a)->surl), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__SURLEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__SURLEntry(soap, this, tag, type);
}

SOAP_FMAC3 glite__SURLEntry * SOAP_FMAC4 soap_get_glite__SURLEntry(struct soap *soap, glite__SURLEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__SURLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__SURLEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__SURLEntry(soap, tag, this, type);
}

SOAP_FMAC3 glite__SURLEntry * SOAP_FMAC4 soap_in_glite__SURLEntry(struct soap *soap, const char *tag, glite__SURLEntry *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__SURLEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__SURLEntry, sizeof(glite__SURLEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__SURLEntry)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__SURLEntry *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_masterReplica1 = 1, soap_flag_creationTime1 = 1, soap_flag_modifyTime1 = 1, soap_flag_surl1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_masterReplica1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "masterReplica", &(((glite__SURLEntry*)a)->masterReplica), "xsd:boolean"))
				{	soap_flag_masterReplica1--;
					continue;
				}
			if (soap_flag_creationTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "creationTime", &(((glite__SURLEntry*)a)->creationTime), "xsd:long"))
				{	soap_flag_creationTime1--;
					continue;
				}
			if (soap_flag_modifyTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "modifyTime", &(((glite__SURLEntry*)a)->modifyTime), "xsd:long"))
				{	soap_flag_modifyTime1--;
					continue;
				}
			if (soap_flag_surl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "surl", &(((glite__SURLEntry*)a)->surl), "xsd:string"))
				{	soap_flag_surl1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_masterReplica1 > 0 || soap_flag_creationTime1 > 0 || soap_flag_modifyTime1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__SURLEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__SURLEntry, 0, sizeof(glite__SURLEntry), 0, soap_copy_glite__SURLEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__SURLEntry * SOAP_FMAC6 soap_new_glite__SURLEntry(struct soap *soap, int n)
{	return soap_instantiate_glite__SURLEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__SURLEntry(struct soap *soap, glite__SURLEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__SURLEntry * SOAP_FMAC4 soap_instantiate_glite__SURLEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__SURLEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__SURLEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__SURLEntry;
		if (size)
			*size = sizeof(glite__SURLEntry);
		((glite__SURLEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__SURLEntry[n];
		if (size)
			*size = n * sizeof(glite__SURLEntry);
		for (int i = 0; i < n; i++)
			((glite__SURLEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__SURLEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__SURLEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__SURLEntry %p -> %p\n", q, p));
	*(glite__SURLEntry*)p = *(glite__SURLEntry*)q;
}

void glite__Permission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((glite__Permission*)this)->acl)
	{	int i;
		for (i = 0; i < ((glite__Permission*)this)->__sizeacl; i++)
		{
			soap_serialize_PointerToglite__ACLEntry(soap, ((glite__Permission*)this)->acl + i);
		}
	}
	soap_serialize_string(soap, &((glite__BasicPermission*)this)->userName);
	soap_serialize_string(soap, &((glite__BasicPermission*)this)->groupName);
	soap_serialize_PointerToglite__Perm(soap, &((glite__BasicPermission*)this)->userPerm);
	soap_serialize_PointerToglite__Perm(soap, &((glite__BasicPermission*)this)->groupPerm);
	soap_serialize_PointerToglite__Perm(soap, &((glite__BasicPermission*)this)->otherPerm);
	/* transient soap skipped */
}

void glite__Permission::soap_default(struct soap *soap)
{
	this->soap = soap;
	((glite__Permission*)this)->__sizeacl = 0;
	((glite__Permission*)this)->acl = NULL;
	soap_default_string(soap, &((glite__BasicPermission*)this)->userName);
	soap_default_string(soap, &((glite__BasicPermission*)this)->groupName);
	((glite__BasicPermission*)this)->userPerm = NULL;
	((glite__BasicPermission*)this)->groupPerm = NULL;
	((glite__BasicPermission*)this)->otherPerm = NULL;
	/* transient soap skipped */
}

int glite__Permission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__Permission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__Permission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__Permission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__Permission(struct soap *soap, const char *tag, int id, const glite__Permission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__Permission), "glite:Permission");
	soap_out_string(soap, "userName", -1, &(((glite__BasicPermission*)a)->userName), "");
	soap_out_string(soap, "groupName", -1, &(((glite__BasicPermission*)a)->groupName), "");
	soap_out_PointerToglite__Perm(soap, "userPerm", -1, &(((glite__BasicPermission*)a)->userPerm), "");
	soap_out_PointerToglite__Perm(soap, "groupPerm", -1, &(((glite__BasicPermission*)a)->groupPerm), "");
	soap_out_PointerToglite__Perm(soap, "otherPerm", -1, &(((glite__BasicPermission*)a)->otherPerm), "");
	/* transient soap skipped */
	if (((glite__Permission*)a)->acl)
	{	int i;
		for (i = 0; i < ((glite__Permission*)a)->__sizeacl; i++)
			soap_out_PointerToglite__ACLEntry(soap, "acl", -1, ((glite__Permission*)a)->acl + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__Permission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__Permission(soap, this, tag, type);
}

SOAP_FMAC3 glite__Permission * SOAP_FMAC4 soap_get_glite__Permission(struct soap *soap, glite__Permission *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__Permission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__Permission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__Permission(soap, tag, this, type);
}

SOAP_FMAC3 glite__Permission * SOAP_FMAC4 soap_in_glite__Permission(struct soap *soap, const char *tag, glite__Permission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__Permission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__Permission, sizeof(glite__Permission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__Permission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__Permission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userName2 = 1, soap_flag_groupName2 = 1, soap_flag_userPerm2 = 1, soap_flag_groupPerm2 = 1, soap_flag_otherPerm2 = 1, soap_flag_acl1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userName2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userName", &(((glite__BasicPermission*)a)->userName), "xsd:string"))
				{	soap_flag_userName2--;
					continue;
				}
			if (soap_flag_groupName2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "groupName", &(((glite__BasicPermission*)a)->groupName), "xsd:string"))
				{	soap_flag_groupName2--;
					continue;
				}
			if (soap_flag_userPerm2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "userPerm", &(((glite__BasicPermission*)a)->userPerm), "glite:Perm"))
				{	soap_flag_userPerm2--;
					continue;
				}
			if (soap_flag_groupPerm2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "groupPerm", &(((glite__BasicPermission*)a)->groupPerm), "glite:Perm"))
				{	soap_flag_groupPerm2--;
					continue;
				}
			if (soap_flag_otherPerm2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "otherPerm", &(((glite__BasicPermission*)a)->otherPerm), "glite:Perm"))
				{	soap_flag_otherPerm2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_acl1 && soap->error == SOAP_TAG_MISMATCH)
			{	glite__ACLEntry **p;
				soap_new_block(soap);
				for (((glite__Permission*)a)->__sizeacl = 0; !soap_element_begin_in(soap, "acl", 1); ((glite__Permission*)a)->__sizeacl++)
				{	p = (glite__ACLEntry **)soap_push_block(soap, sizeof(glite__ACLEntry *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToglite__ACLEntry(soap, "acl", p, "glite:ACLEntry"))
						break;
					soap_flag_acl1 = 0;
				}
				((glite__Permission*)a)->acl = (glite__ACLEntry **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_acl1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__Permission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__Permission, 0, sizeof(glite__Permission), 0, soap_copy_glite__Permission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__Permission * SOAP_FMAC6 soap_new_glite__Permission(struct soap *soap, int n)
{	return soap_instantiate_glite__Permission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__Permission(struct soap *soap, glite__Permission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__Permission * SOAP_FMAC4 soap_instantiate_glite__Permission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__Permission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__Permission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__Permission;
		if (size)
			*size = sizeof(glite__Permission);
		((glite__Permission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__Permission[n];
		if (size)
			*size = n * sizeof(glite__Permission);
		for (int i = 0; i < n; i++)
			((glite__Permission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__Permission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__Permission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__Permission %p -> %p\n", q, p));
	*(glite__Permission*)p = *(glite__Permission*)q;
}

void glite__ACLEntry::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__Perm(soap, &((glite__ACLEntry*)this)->principalPerm);
	soap_serialize_string(soap, &((glite__ACLEntry*)this)->principal);
	/* transient soap skipped */
}

void glite__ACLEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	((glite__ACLEntry*)this)->principalPerm = NULL;
	soap_default_string(soap, &((glite__ACLEntry*)this)->principal);
	/* transient soap skipped */
}

int glite__ACLEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__ACLEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__ACLEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__ACLEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__ACLEntry(struct soap *soap, const char *tag, int id, const glite__ACLEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__ACLEntry), type);
	soap_out_PointerToglite__Perm(soap, "principalPerm", -1, &(((glite__ACLEntry*)a)->principalPerm), "");
	soap_out_string(soap, "principal", -1, &(((glite__ACLEntry*)a)->principal), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__ACLEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__ACLEntry(soap, this, tag, type);
}

SOAP_FMAC3 glite__ACLEntry * SOAP_FMAC4 soap_get_glite__ACLEntry(struct soap *soap, glite__ACLEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__ACLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__ACLEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__ACLEntry(soap, tag, this, type);
}

SOAP_FMAC3 glite__ACLEntry * SOAP_FMAC4 soap_in_glite__ACLEntry(struct soap *soap, const char *tag, glite__ACLEntry *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__ACLEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__ACLEntry, sizeof(glite__ACLEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__ACLEntry)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__ACLEntry *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_principalPerm1 = 1, soap_flag_principal1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_principalPerm1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "principalPerm", &(((glite__ACLEntry*)a)->principalPerm), "glite:Perm"))
				{	soap_flag_principalPerm1--;
					continue;
				}
			if (soap_flag_principal1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "principal", &(((glite__ACLEntry*)a)->principal), "xsd:string"))
				{	soap_flag_principal1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__ACLEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__ACLEntry, 0, sizeof(glite__ACLEntry), 0, soap_copy_glite__ACLEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__ACLEntry * SOAP_FMAC6 soap_new_glite__ACLEntry(struct soap *soap, int n)
{	return soap_instantiate_glite__ACLEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__ACLEntry(struct soap *soap, glite__ACLEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__ACLEntry * SOAP_FMAC4 soap_instantiate_glite__ACLEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__ACLEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__ACLEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__ACLEntry;
		if (size)
			*size = sizeof(glite__ACLEntry);
		((glite__ACLEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__ACLEntry[n];
		if (size)
			*size = n * sizeof(glite__ACLEntry);
		for (int i = 0; i < n; i++)
			((glite__ACLEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__ACLEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__ACLEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__ACLEntry %p -> %p\n", q, p));
	*(glite__ACLEntry*)p = *(glite__ACLEntry*)q;
}

void glite__BasicPermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__BasicPermission*)this)->userName);
	soap_serialize_string(soap, &((glite__BasicPermission*)this)->groupName);
	soap_serialize_PointerToglite__Perm(soap, &((glite__BasicPermission*)this)->userPerm);
	soap_serialize_PointerToglite__Perm(soap, &((glite__BasicPermission*)this)->groupPerm);
	soap_serialize_PointerToglite__Perm(soap, &((glite__BasicPermission*)this)->otherPerm);
	/* transient soap skipped */
}

void glite__BasicPermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__BasicPermission*)this)->userName);
	soap_default_string(soap, &((glite__BasicPermission*)this)->groupName);
	((glite__BasicPermission*)this)->userPerm = NULL;
	((glite__BasicPermission*)this)->groupPerm = NULL;
	((glite__BasicPermission*)this)->otherPerm = NULL;
	/* transient soap skipped */
}

int glite__BasicPermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__BasicPermission);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__BasicPermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__BasicPermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__BasicPermission(struct soap *soap, const char *tag, int id, const glite__BasicPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__BasicPermission), type);
	soap_out_string(soap, "userName", -1, &(((glite__BasicPermission*)a)->userName), "");
	soap_out_string(soap, "groupName", -1, &(((glite__BasicPermission*)a)->groupName), "");
	soap_out_PointerToglite__Perm(soap, "userPerm", -1, &(((glite__BasicPermission*)a)->userPerm), "");
	soap_out_PointerToglite__Perm(soap, "groupPerm", -1, &(((glite__BasicPermission*)a)->groupPerm), "");
	soap_out_PointerToglite__Perm(soap, "otherPerm", -1, &(((glite__BasicPermission*)a)->otherPerm), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__BasicPermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__BasicPermission(soap, this, tag, type);
}

SOAP_FMAC3 glite__BasicPermission * SOAP_FMAC4 soap_get_glite__BasicPermission(struct soap *soap, glite__BasicPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__BasicPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__BasicPermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__BasicPermission(soap, tag, this, type);
}

SOAP_FMAC3 glite__BasicPermission * SOAP_FMAC4 soap_in_glite__BasicPermission(struct soap *soap, const char *tag, glite__BasicPermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__BasicPermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__BasicPermission, sizeof(glite__BasicPermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__BasicPermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__BasicPermission *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userName1 = 1, soap_flag_groupName1 = 1, soap_flag_userPerm1 = 1, soap_flag_groupPerm1 = 1, soap_flag_otherPerm1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userName", &(((glite__BasicPermission*)a)->userName), "xsd:string"))
				{	soap_flag_userName1--;
					continue;
				}
			if (soap_flag_groupName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "groupName", &(((glite__BasicPermission*)a)->groupName), "xsd:string"))
				{	soap_flag_groupName1--;
					continue;
				}
			if (soap_flag_userPerm1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "userPerm", &(((glite__BasicPermission*)a)->userPerm), "glite:Perm"))
				{	soap_flag_userPerm1--;
					continue;
				}
			if (soap_flag_groupPerm1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "groupPerm", &(((glite__BasicPermission*)a)->groupPerm), "glite:Perm"))
				{	soap_flag_groupPerm1--;
					continue;
				}
			if (soap_flag_otherPerm1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, "otherPerm", &(((glite__BasicPermission*)a)->otherPerm), "glite:Perm"))
				{	soap_flag_otherPerm1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__BasicPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__BasicPermission, 0, sizeof(glite__BasicPermission), 0, soap_copy_glite__BasicPermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__BasicPermission * SOAP_FMAC6 soap_new_glite__BasicPermission(struct soap *soap, int n)
{	return soap_instantiate_glite__BasicPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__BasicPermission(struct soap *soap, glite__BasicPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__BasicPermission * SOAP_FMAC4 soap_instantiate_glite__BasicPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__BasicPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__BasicPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "glite:Permission"))
	{	cp->type = SOAP_TYPE_glite__Permission;
		if (n < 0)
		{	cp->ptr = (void*)new glite__Permission;
			if (size)
				*size = sizeof(glite__Permission);
			((glite__Permission*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__Permission[n];
			if (size)
				*size = n * sizeof(glite__Permission);
			for (int i = 0; i < n; i++)
				((glite__Permission*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__Permission*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new glite__BasicPermission;
		if (size)
			*size = sizeof(glite__BasicPermission);
		((glite__BasicPermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__BasicPermission[n];
		if (size)
			*size = n * sizeof(glite__BasicPermission);
		for (int i = 0; i < n; i++)
			((glite__BasicPermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__BasicPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__BasicPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__BasicPermission %p -> %p\n", q, p));
	*(glite__BasicPermission*)p = *(glite__BasicPermission*)q;
}

void glite__Perm::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void glite__Perm::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &((glite__Perm*)this)->permission);
	soap_default_bool(soap, &((glite__Perm*)this)->remove);
	soap_default_bool(soap, &((glite__Perm*)this)->read);
	soap_default_bool(soap, &((glite__Perm*)this)->write);
	soap_default_bool(soap, &((glite__Perm*)this)->list);
	soap_default_bool(soap, &((glite__Perm*)this)->execute);
	soap_default_bool(soap, &((glite__Perm*)this)->getMetadata);
	soap_default_bool(soap, &((glite__Perm*)this)->setMetadata);
	/* transient soap skipped */
}

int glite__Perm::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__Perm);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__Perm::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__Perm(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__Perm(struct soap *soap, const char *tag, int id, const glite__Perm *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__Perm), type);
	soap_out_bool(soap, "permission", -1, &(((glite__Perm*)a)->permission), "");
	soap_out_bool(soap, "remove", -1, &(((glite__Perm*)a)->remove), "");
	soap_out_bool(soap, "read", -1, &(((glite__Perm*)a)->read), "");
	soap_out_bool(soap, "write", -1, &(((glite__Perm*)a)->write), "");
	soap_out_bool(soap, "list", -1, &(((glite__Perm*)a)->list), "");
	soap_out_bool(soap, "execute", -1, &(((glite__Perm*)a)->execute), "");
	soap_out_bool(soap, "getMetadata", -1, &(((glite__Perm*)a)->getMetadata), "");
	soap_out_bool(soap, "setMetadata", -1, &(((glite__Perm*)a)->setMetadata), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__Perm::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__Perm(soap, this, tag, type);
}

SOAP_FMAC3 glite__Perm * SOAP_FMAC4 soap_get_glite__Perm(struct soap *soap, glite__Perm *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__Perm(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__Perm::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__Perm(soap, tag, this, type);
}

SOAP_FMAC3 glite__Perm * SOAP_FMAC4 soap_in_glite__Perm(struct soap *soap, const char *tag, glite__Perm *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__Perm *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__Perm, sizeof(glite__Perm), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__Perm)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__Perm *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_permission1 = 1, soap_flag_remove1 = 1, soap_flag_read1 = 1, soap_flag_write1 = 1, soap_flag_list1 = 1, soap_flag_execute1 = 1, soap_flag_getMetadata1 = 1, soap_flag_setMetadata1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "permission", &(((glite__Perm*)a)->permission), "xsd:boolean"))
				{	soap_flag_permission1--;
					continue;
				}
			if (soap_flag_remove1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "remove", &(((glite__Perm*)a)->remove), "xsd:boolean"))
				{	soap_flag_remove1--;
					continue;
				}
			if (soap_flag_read1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "read", &(((glite__Perm*)a)->read), "xsd:boolean"))
				{	soap_flag_read1--;
					continue;
				}
			if (soap_flag_write1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "write", &(((glite__Perm*)a)->write), "xsd:boolean"))
				{	soap_flag_write1--;
					continue;
				}
			if (soap_flag_list1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "list", &(((glite__Perm*)a)->list), "xsd:boolean"))
				{	soap_flag_list1--;
					continue;
				}
			if (soap_flag_execute1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "execute", &(((glite__Perm*)a)->execute), "xsd:boolean"))
				{	soap_flag_execute1--;
					continue;
				}
			if (soap_flag_getMetadata1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "getMetadata", &(((glite__Perm*)a)->getMetadata), "xsd:boolean"))
				{	soap_flag_getMetadata1--;
					continue;
				}
			if (soap_flag_setMetadata1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "setMetadata", &(((glite__Perm*)a)->setMetadata), "xsd:boolean"))
				{	soap_flag_setMetadata1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_permission1 > 0 || soap_flag_remove1 > 0 || soap_flag_read1 > 0 || soap_flag_write1 > 0 || soap_flag_list1 > 0 || soap_flag_execute1 > 0 || soap_flag_getMetadata1 > 0 || soap_flag_setMetadata1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__Perm *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__Perm, 0, sizeof(glite__Perm), 0, soap_copy_glite__Perm);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__Perm * SOAP_FMAC6 soap_new_glite__Perm(struct soap *soap, int n)
{	return soap_instantiate_glite__Perm(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__Perm(struct soap *soap, glite__Perm *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__Perm * SOAP_FMAC4 soap_instantiate_glite__Perm(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__Perm(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__Perm, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__Perm;
		if (size)
			*size = sizeof(glite__Perm);
		((glite__Perm*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__Perm[n];
		if (size)
			*size = n * sizeof(glite__Perm);
		for (int i = 0; i < n; i++)
			((glite__Perm*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__Perm*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__Perm(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__Perm %p -> %p\n", q, p));
	*(glite__Perm*)p = *(glite__Perm*)q;
}

void glite__GUIDStat::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__GUIDStat*)this)->checksum);
	/* transient soap skipped */
}

void glite__GUIDStat::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &((glite__GUIDStat*)this)->status);
	soap_default_string(soap, &((glite__GUIDStat*)this)->checksum);
	soap_default_LONG64(soap, &((glite__Stat*)this)->modifyTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->creationTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->size);
	/* transient soap skipped */
}

int glite__GUIDStat::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__GUIDStat);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__GUIDStat::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__GUIDStat(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__GUIDStat(struct soap *soap, const char *tag, int id, const glite__GUIDStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__GUIDStat), "glite:GUIDStat");
	soap_out_LONG64(soap, "modifyTime", -1, &(((glite__Stat*)a)->modifyTime), "");
	soap_out_LONG64(soap, "creationTime", -1, &(((glite__Stat*)a)->creationTime), "");
	soap_out_LONG64(soap, "size", -1, &(((glite__Stat*)a)->size), "");
	/* transient soap skipped */
	soap_out_int(soap, "status", -1, &(((glite__GUIDStat*)a)->status), "");
	soap_out_string(soap, "checksum", -1, &(((glite__GUIDStat*)a)->checksum), "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__GUIDStat::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__GUIDStat(soap, this, tag, type);
}

SOAP_FMAC3 glite__GUIDStat * SOAP_FMAC4 soap_get_glite__GUIDStat(struct soap *soap, glite__GUIDStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__GUIDStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__GUIDStat::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__GUIDStat(soap, tag, this, type);
}

SOAP_FMAC3 glite__GUIDStat * SOAP_FMAC4 soap_in_glite__GUIDStat(struct soap *soap, const char *tag, glite__GUIDStat *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__GUIDStat *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__GUIDStat, sizeof(glite__GUIDStat), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__GUIDStat)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__GUIDStat *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_modifyTime2 = 1, soap_flag_creationTime2 = 1, soap_flag_size2 = 1, soap_flag_status1 = 1, soap_flag_checksum1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_modifyTime2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "modifyTime", &(((glite__Stat*)a)->modifyTime), "xsd:long"))
				{	soap_flag_modifyTime2--;
					continue;
				}
			if (soap_flag_creationTime2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "creationTime", &(((glite__Stat*)a)->creationTime), "xsd:long"))
				{	soap_flag_creationTime2--;
					continue;
				}
			if (soap_flag_size2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "size", &(((glite__Stat*)a)->size), "xsd:long"))
				{	soap_flag_size2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "status", &(((glite__GUIDStat*)a)->status), "xsd:int"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_checksum1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "checksum", &(((glite__GUIDStat*)a)->checksum), "xsd:string"))
				{	soap_flag_checksum1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_modifyTime2 > 0 || soap_flag_creationTime2 > 0 || soap_flag_size2 > 0 || soap_flag_status1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__GUIDStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__GUIDStat, 0, sizeof(glite__GUIDStat), 0, soap_copy_glite__GUIDStat);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__GUIDStat * SOAP_FMAC6 soap_new_glite__GUIDStat(struct soap *soap, int n)
{	return soap_instantiate_glite__GUIDStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__GUIDStat(struct soap *soap, glite__GUIDStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__GUIDStat * SOAP_FMAC4 soap_instantiate_glite__GUIDStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__GUIDStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__GUIDStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__GUIDStat;
		if (size)
			*size = sizeof(glite__GUIDStat);
		((glite__GUIDStat*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__GUIDStat[n];
		if (size)
			*size = n * sizeof(glite__GUIDStat);
		for (int i = 0; i < n; i++)
			((glite__GUIDStat*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__GUIDStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__GUIDStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__GUIDStat %p -> %p\n", q, p));
	*(glite__GUIDStat*)p = *(glite__GUIDStat*)q;
}

void glite__Stat::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void glite__Stat::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_LONG64(soap, &((glite__Stat*)this)->modifyTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->creationTime);
	soap_default_LONG64(soap, &((glite__Stat*)this)->size);
	/* transient soap skipped */
}

int glite__Stat::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__Stat);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__Stat::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__Stat(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__Stat(struct soap *soap, const char *tag, int id, const glite__Stat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__Stat), type);
	soap_out_LONG64(soap, "modifyTime", -1, &(((glite__Stat*)a)->modifyTime), "");
	soap_out_LONG64(soap, "creationTime", -1, &(((glite__Stat*)a)->creationTime), "");
	soap_out_LONG64(soap, "size", -1, &(((glite__Stat*)a)->size), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__Stat::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__Stat(soap, this, tag, type);
}

SOAP_FMAC3 glite__Stat * SOAP_FMAC4 soap_get_glite__Stat(struct soap *soap, glite__Stat *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__Stat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__Stat::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__Stat(soap, tag, this, type);
}

SOAP_FMAC3 glite__Stat * SOAP_FMAC4 soap_in_glite__Stat(struct soap *soap, const char *tag, glite__Stat *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__Stat *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__Stat, sizeof(glite__Stat), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__Stat)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__Stat *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_modifyTime1 = 1, soap_flag_creationTime1 = 1, soap_flag_size1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_modifyTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "modifyTime", &(((glite__Stat*)a)->modifyTime), "xsd:long"))
				{	soap_flag_modifyTime1--;
					continue;
				}
			if (soap_flag_creationTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "creationTime", &(((glite__Stat*)a)->creationTime), "xsd:long"))
				{	soap_flag_creationTime1--;
					continue;
				}
			if (soap_flag_size1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "size", &(((glite__Stat*)a)->size), "xsd:long"))
				{	soap_flag_size1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_modifyTime1 > 0 || soap_flag_creationTime1 > 0 || soap_flag_size1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__Stat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__Stat, 0, sizeof(glite__Stat), 0, soap_copy_glite__Stat);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__Stat * SOAP_FMAC6 soap_new_glite__Stat(struct soap *soap, int n)
{	return soap_instantiate_glite__Stat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__Stat(struct soap *soap, glite__Stat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__Stat * SOAP_FMAC4 soap_instantiate_glite__Stat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__Stat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__Stat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "glite:GUIDStat"))
	{	cp->type = SOAP_TYPE_glite__GUIDStat;
		if (n < 0)
		{	cp->ptr = (void*)new glite__GUIDStat;
			if (size)
				*size = sizeof(glite__GUIDStat);
			((glite__GUIDStat*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__GUIDStat[n];
			if (size)
				*size = n * sizeof(glite__GUIDStat);
			for (int i = 0; i < n; i++)
				((glite__GUIDStat*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__GUIDStat*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "glite:LFNStat"))
	{	cp->type = SOAP_TYPE_glite__LFNStat;
		if (n < 0)
		{	cp->ptr = (void*)new glite__LFNStat;
			if (size)
				*size = sizeof(glite__LFNStat);
			((glite__LFNStat*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__LFNStat[n];
			if (size)
				*size = n * sizeof(glite__LFNStat);
			for (int i = 0; i < n; i++)
				((glite__LFNStat*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__LFNStat*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new glite__Stat;
		if (size)
			*size = sizeof(glite__Stat);
		((glite__Stat*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__Stat[n];
		if (size)
			*size = n * sizeof(glite__Stat);
		for (int i = 0; i < n; i++)
			((glite__Stat*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__Stat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__Stat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__Stat %p -> %p\n", q, p));
	*(glite__Stat*)p = *(glite__Stat*)q;
}

void glite__InvalidArgumentException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

void glite__InvalidArgumentException::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

int glite__InvalidArgumentException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__InvalidArgumentException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__InvalidArgumentException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__InvalidArgumentException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__InvalidArgumentException(struct soap *soap, const char *tag, int id, const glite__InvalidArgumentException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__InvalidArgumentException), "glite:InvalidArgumentException");
	soap_out_string(soap, "message", -1, &(((glite__CatalogException*)a)->message), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__InvalidArgumentException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__InvalidArgumentException(soap, this, tag, type);
}

SOAP_FMAC3 glite__InvalidArgumentException * SOAP_FMAC4 soap_get_glite__InvalidArgumentException(struct soap *soap, glite__InvalidArgumentException *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__InvalidArgumentException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__InvalidArgumentException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__InvalidArgumentException(soap, tag, this, type);
}

SOAP_FMAC3 glite__InvalidArgumentException * SOAP_FMAC4 soap_in_glite__InvalidArgumentException(struct soap *soap, const char *tag, glite__InvalidArgumentException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__InvalidArgumentException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__InvalidArgumentException, sizeof(glite__InvalidArgumentException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__InvalidArgumentException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__InvalidArgumentException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_message2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_message2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "message", &(((glite__CatalogException*)a)->message), "xsd:string"))
				{	soap_flag_message2--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__InvalidArgumentException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__InvalidArgumentException, 0, sizeof(glite__InvalidArgumentException), 0, soap_copy_glite__InvalidArgumentException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__InvalidArgumentException * SOAP_FMAC6 soap_new_glite__InvalidArgumentException(struct soap *soap, int n)
{	return soap_instantiate_glite__InvalidArgumentException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__InvalidArgumentException(struct soap *soap, glite__InvalidArgumentException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__InvalidArgumentException * SOAP_FMAC4 soap_instantiate_glite__InvalidArgumentException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__InvalidArgumentException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__InvalidArgumentException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__InvalidArgumentException;
		if (size)
			*size = sizeof(glite__InvalidArgumentException);
		((glite__InvalidArgumentException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__InvalidArgumentException[n];
		if (size)
			*size = n * sizeof(glite__InvalidArgumentException);
		for (int i = 0; i < n; i++)
			((glite__InvalidArgumentException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__InvalidArgumentException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__InvalidArgumentException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__InvalidArgumentException %p -> %p\n", q, p));
	*(glite__InvalidArgumentException*)p = *(glite__InvalidArgumentException*)q;
}

void glite__NotExistsException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

void glite__NotExistsException::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

int glite__NotExistsException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__NotExistsException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__NotExistsException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__NotExistsException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__NotExistsException(struct soap *soap, const char *tag, int id, const glite__NotExistsException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__NotExistsException), "glite:NotExistsException");
	soap_out_string(soap, "message", -1, &(((glite__CatalogException*)a)->message), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__NotExistsException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__NotExistsException(soap, this, tag, type);
}

SOAP_FMAC3 glite__NotExistsException * SOAP_FMAC4 soap_get_glite__NotExistsException(struct soap *soap, glite__NotExistsException *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__NotExistsException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__NotExistsException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__NotExistsException(soap, tag, this, type);
}

SOAP_FMAC3 glite__NotExistsException * SOAP_FMAC4 soap_in_glite__NotExistsException(struct soap *soap, const char *tag, glite__NotExistsException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__NotExistsException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__NotExistsException, sizeof(glite__NotExistsException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__NotExistsException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__NotExistsException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_message2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_message2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "message", &(((glite__CatalogException*)a)->message), "xsd:string"))
				{	soap_flag_message2--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__NotExistsException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__NotExistsException, 0, sizeof(glite__NotExistsException), 0, soap_copy_glite__NotExistsException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__NotExistsException * SOAP_FMAC6 soap_new_glite__NotExistsException(struct soap *soap, int n)
{	return soap_instantiate_glite__NotExistsException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__NotExistsException(struct soap *soap, glite__NotExistsException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__NotExistsException * SOAP_FMAC4 soap_instantiate_glite__NotExistsException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__NotExistsException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__NotExistsException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__NotExistsException;
		if (size)
			*size = sizeof(glite__NotExistsException);
		((glite__NotExistsException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__NotExistsException[n];
		if (size)
			*size = n * sizeof(glite__NotExistsException);
		for (int i = 0; i < n; i++)
			((glite__NotExistsException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__NotExistsException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__NotExistsException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__NotExistsException %p -> %p\n", q, p));
	*(glite__NotExistsException*)p = *(glite__NotExistsException*)q;
}

void glite__AuthorizationException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

void glite__AuthorizationException::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

int glite__AuthorizationException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__AuthorizationException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__AuthorizationException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__AuthorizationException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__AuthorizationException(struct soap *soap, const char *tag, int id, const glite__AuthorizationException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__AuthorizationException), "glite:AuthorizationException");
	soap_out_string(soap, "message", -1, &(((glite__CatalogException*)a)->message), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__AuthorizationException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__AuthorizationException(soap, this, tag, type);
}

SOAP_FMAC3 glite__AuthorizationException * SOAP_FMAC4 soap_get_glite__AuthorizationException(struct soap *soap, glite__AuthorizationException *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__AuthorizationException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__AuthorizationException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__AuthorizationException(soap, tag, this, type);
}

SOAP_FMAC3 glite__AuthorizationException * SOAP_FMAC4 soap_in_glite__AuthorizationException(struct soap *soap, const char *tag, glite__AuthorizationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__AuthorizationException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__AuthorizationException, sizeof(glite__AuthorizationException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__AuthorizationException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__AuthorizationException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_message2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_message2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "message", &(((glite__CatalogException*)a)->message), "xsd:string"))
				{	soap_flag_message2--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__AuthorizationException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__AuthorizationException, 0, sizeof(glite__AuthorizationException), 0, soap_copy_glite__AuthorizationException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__AuthorizationException * SOAP_FMAC6 soap_new_glite__AuthorizationException(struct soap *soap, int n)
{	return soap_instantiate_glite__AuthorizationException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__AuthorizationException(struct soap *soap, glite__AuthorizationException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__AuthorizationException * SOAP_FMAC4 soap_instantiate_glite__AuthorizationException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__AuthorizationException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__AuthorizationException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__AuthorizationException;
		if (size)
			*size = sizeof(glite__AuthorizationException);
		((glite__AuthorizationException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__AuthorizationException[n];
		if (size)
			*size = n * sizeof(glite__AuthorizationException);
		for (int i = 0; i < n; i++)
			((glite__AuthorizationException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__AuthorizationException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__AuthorizationException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__AuthorizationException %p -> %p\n", q, p));
	*(glite__AuthorizationException*)p = *(glite__AuthorizationException*)q;
}

void glite__InternalException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

void glite__InternalException::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

int glite__InternalException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__InternalException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__InternalException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__InternalException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__InternalException(struct soap *soap, const char *tag, int id, const glite__InternalException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__InternalException), "glite:InternalException");
	soap_out_string(soap, "message", -1, &(((glite__CatalogException*)a)->message), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__InternalException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__InternalException(soap, this, tag, type);
}

SOAP_FMAC3 glite__InternalException * SOAP_FMAC4 soap_get_glite__InternalException(struct soap *soap, glite__InternalException *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__InternalException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__InternalException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__InternalException(soap, tag, this, type);
}

SOAP_FMAC3 glite__InternalException * SOAP_FMAC4 soap_in_glite__InternalException(struct soap *soap, const char *tag, glite__InternalException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__InternalException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__InternalException, sizeof(glite__InternalException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__InternalException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__InternalException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_message2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_message2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "message", &(((glite__CatalogException*)a)->message), "xsd:string"))
				{	soap_flag_message2--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__InternalException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__InternalException, 0, sizeof(glite__InternalException), 0, soap_copy_glite__InternalException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__InternalException * SOAP_FMAC6 soap_new_glite__InternalException(struct soap *soap, int n)
{	return soap_instantiate_glite__InternalException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__InternalException(struct soap *soap, glite__InternalException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__InternalException * SOAP_FMAC4 soap_instantiate_glite__InternalException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__InternalException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__InternalException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new glite__InternalException;
		if (size)
			*size = sizeof(glite__InternalException);
		((glite__InternalException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__InternalException[n];
		if (size)
			*size = n * sizeof(glite__InternalException);
		for (int i = 0; i < n; i++)
			((glite__InternalException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__InternalException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__InternalException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__InternalException %p -> %p\n", q, p));
	*(glite__InternalException*)p = *(glite__InternalException*)q;
}

void glite__CatalogException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

void glite__CatalogException::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((glite__CatalogException*)this)->message);
	/* transient soap skipped */
}

int glite__CatalogException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_glite__CatalogException);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int glite__CatalogException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_glite__CatalogException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_glite__CatalogException(struct soap *soap, const char *tag, int id, const glite__CatalogException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_glite__CatalogException), type);
	soap_out_string(soap, "message", -1, &(((glite__CatalogException*)a)->message), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *glite__CatalogException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_glite__CatalogException(soap, this, tag, type);
}

SOAP_FMAC3 glite__CatalogException * SOAP_FMAC4 soap_get_glite__CatalogException(struct soap *soap, glite__CatalogException *p, const char *tag, const char *type)
{
	if ((p = soap_in_glite__CatalogException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *glite__CatalogException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_glite__CatalogException(soap, tag, this, type);
}

SOAP_FMAC3 glite__CatalogException * SOAP_FMAC4 soap_in_glite__CatalogException(struct soap *soap, const char *tag, glite__CatalogException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (glite__CatalogException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_glite__CatalogException, sizeof(glite__CatalogException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_glite__CatalogException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (glite__CatalogException *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_message1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_message1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "message", &(((glite__CatalogException*)a)->message), "xsd:string"))
				{	soap_flag_message1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (glite__CatalogException *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_glite__CatalogException, 0, sizeof(glite__CatalogException), 0, soap_copy_glite__CatalogException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 glite__CatalogException * SOAP_FMAC6 soap_new_glite__CatalogException(struct soap *soap, int n)
{	return soap_instantiate_glite__CatalogException(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_glite__CatalogException(struct soap *soap, glite__CatalogException *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 glite__CatalogException * SOAP_FMAC4 soap_instantiate_glite__CatalogException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_glite__CatalogException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_glite__CatalogException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "glite:InternalException"))
	{	cp->type = SOAP_TYPE_glite__InternalException;
		if (n < 0)
		{	cp->ptr = (void*)new glite__InternalException;
			if (size)
				*size = sizeof(glite__InternalException);
			((glite__InternalException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__InternalException[n];
			if (size)
				*size = n * sizeof(glite__InternalException);
			for (int i = 0; i < n; i++)
				((glite__InternalException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__InternalException*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "glite:AuthorizationException"))
	{	cp->type = SOAP_TYPE_glite__AuthorizationException;
		if (n < 0)
		{	cp->ptr = (void*)new glite__AuthorizationException;
			if (size)
				*size = sizeof(glite__AuthorizationException);
			((glite__AuthorizationException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__AuthorizationException[n];
			if (size)
				*size = n * sizeof(glite__AuthorizationException);
			for (int i = 0; i < n; i++)
				((glite__AuthorizationException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__AuthorizationException*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "glite:NotExistsException"))
	{	cp->type = SOAP_TYPE_glite__NotExistsException;
		if (n < 0)
		{	cp->ptr = (void*)new glite__NotExistsException;
			if (size)
				*size = sizeof(glite__NotExistsException);
			((glite__NotExistsException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__NotExistsException[n];
			if (size)
				*size = n * sizeof(glite__NotExistsException);
			for (int i = 0; i < n; i++)
				((glite__NotExistsException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__NotExistsException*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "glite:InvalidArgumentException"))
	{	cp->type = SOAP_TYPE_glite__InvalidArgumentException;
		if (n < 0)
		{	cp->ptr = (void*)new glite__InvalidArgumentException;
			if (size)
				*size = sizeof(glite__InvalidArgumentException);
			((glite__InvalidArgumentException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__InvalidArgumentException[n];
			if (size)
				*size = n * sizeof(glite__InvalidArgumentException);
			for (int i = 0; i < n; i++)
				((glite__InvalidArgumentException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__InvalidArgumentException*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "glite:ExistsException"))
	{	cp->type = SOAP_TYPE_glite__ExistsException;
		if (n < 0)
		{	cp->ptr = (void*)new glite__ExistsException;
			if (size)
				*size = sizeof(glite__ExistsException);
			((glite__ExistsException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new glite__ExistsException[n];
			if (size)
				*size = n * sizeof(glite__ExistsException);
			for (int i = 0; i < n; i++)
				((glite__ExistsException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (glite__ExistsException*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new glite__CatalogException;
		if (size)
			*size = sizeof(glite__CatalogException);
		((glite__CatalogException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new glite__CatalogException[n];
		if (size)
			*size = n * sizeof(glite__CatalogException);
		for (int i = 0; i < n; i++)
			((glite__CatalogException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (glite__CatalogException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_glite__CatalogException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying glite__CatalogException %p -> %p\n", q, p));
	*(glite__CatalogException*)p = *(glite__CatalogException*)q;
}

void ArrayOf_USCOREtns1_USCOREStringBoolean::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__StringBoolean(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREStringBoolean::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREStringBoolean::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREStringBoolean::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREStringBoolean *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:StringBoolean", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__StringBoolean(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREStringBoolean::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringBoolean * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringBoolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREStringBoolean::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringBoolean * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREStringBoolean *a, const char *type)
{	int i, j;
	glite__StringBoolean **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREStringBoolean *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean, sizeof(ArrayOf_USCOREtns1_USCOREStringBoolean), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__StringBoolean **)soap_malloc(soap, sizeof(glite__StringBoolean *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__StringBoolean(soap, NULL, a->__ptr + i, "glite:StringBoolean"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__StringBoolean **)soap_push_block(soap, sizeof(glite__StringBoolean *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__StringBoolean(soap, NULL, p, "glite:StringBoolean"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__StringBoolean **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREStringBoolean *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean, 0, sizeof(ArrayOf_USCOREtns1_USCOREStringBoolean), 0, soap_copy_ArrayOf_USCOREtns1_USCOREStringBoolean);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREStringBoolean * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringBoolean *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringBoolean * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREStringBoolean(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREStringBoolean;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREStringBoolean);
		((ArrayOf_USCOREtns1_USCOREStringBoolean*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREStringBoolean[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREStringBoolean);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREStringBoolean*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREStringBoolean*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREStringBoolean %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREStringBoolean*)p = *(ArrayOf_USCOREtns1_USCOREStringBoolean*)q;
}

void ArrayOf_USCOREtns1_USCOREGUIDStat::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__GUIDStat(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREGUIDStat::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREGUIDStat::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREGUIDStat::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREGUIDStat *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:GUIDStat", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__GUIDStat(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREGUIDStat::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREGUIDStat * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREGUIDStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREGUIDStat::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREGUIDStat * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREGUIDStat *a, const char *type)
{	int i, j;
	glite__GUIDStat **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREGUIDStat *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat, sizeof(ArrayOf_USCOREtns1_USCOREGUIDStat), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__GUIDStat **)soap_malloc(soap, sizeof(glite__GUIDStat *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__GUIDStat(soap, NULL, a->__ptr + i, "glite:GUIDStat"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__GUIDStat **)soap_push_block(soap, sizeof(glite__GUIDStat *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__GUIDStat(soap, NULL, p, "glite:GUIDStat"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__GUIDStat **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREGUIDStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat, 0, sizeof(ArrayOf_USCOREtns1_USCOREGUIDStat), 0, soap_copy_ArrayOf_USCOREtns1_USCOREGUIDStat);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREGUIDStat * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREGUIDStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREGUIDStat * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREGUIDStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREGUIDStat;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREGUIDStat);
		((ArrayOf_USCOREtns1_USCOREGUIDStat*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREGUIDStat[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREGUIDStat);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREGUIDStat*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREGUIDStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREGUIDStat %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREGUIDStat*)p = *(ArrayOf_USCOREtns1_USCOREGUIDStat*)q;
}

void ArrayOf_USCOREtns1_USCORERCEntry::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__RCEntry(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCORERCEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCORERCEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCORERCEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERCEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERCEntry *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:RCEntry", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__RCEntry(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCORERCEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERCEntry(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERCEntry * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORERCEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCORERCEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERCEntry(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERCEntry * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERCEntry *a, const char *type)
{	int i, j;
	glite__RCEntry **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERCEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry, sizeof(ArrayOf_USCOREtns1_USCORERCEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__RCEntry **)soap_malloc(soap, sizeof(glite__RCEntry *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__RCEntry(soap, NULL, a->__ptr + i, "glite:RCEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__RCEntry **)soap_push_block(soap, sizeof(glite__RCEntry *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__RCEntry(soap, NULL, p, "glite:RCEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__RCEntry **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERCEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry, 0, sizeof(ArrayOf_USCOREtns1_USCORERCEntry), 0, soap_copy_ArrayOf_USCOREtns1_USCORERCEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCORERCEntry * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCORERCEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORERCEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERCEntry * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERCEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCORERCEntry;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERCEntry);
		((ArrayOf_USCOREtns1_USCORERCEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCORERCEntry[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERCEntry);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERCEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERCEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERCEntry %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERCEntry*)p = *(ArrayOf_USCOREtns1_USCORERCEntry*)q;
}

void ArrayOf_USCOREtns1_USCOREAttribute::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__Attribute(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREAttribute::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREAttribute::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREAttribute::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREAttribute(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREAttribute *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:Attribute", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__Attribute(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREAttribute::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREAttribute(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREAttribute * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, ArrayOf_USCOREtns1_USCOREAttribute *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREAttribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREAttribute::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREAttribute(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREAttribute * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREAttribute *a, const char *type)
{	int i, j;
	glite__Attribute **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREAttribute *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute, sizeof(ArrayOf_USCOREtns1_USCOREAttribute), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__Attribute **)soap_malloc(soap, sizeof(glite__Attribute *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__Attribute(soap, NULL, a->__ptr + i, "glite:Attribute"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__Attribute **)soap_push_block(soap, sizeof(glite__Attribute *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__Attribute(soap, NULL, p, "glite:Attribute"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__Attribute **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREAttribute *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute, 0, sizeof(ArrayOf_USCOREtns1_USCOREAttribute), 0, soap_copy_ArrayOf_USCOREtns1_USCOREAttribute);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREAttribute * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREAttribute(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, ArrayOf_USCOREtns1_USCOREAttribute *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREAttribute * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREAttribute(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREAttribute;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREAttribute);
		((ArrayOf_USCOREtns1_USCOREAttribute*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREAttribute[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREAttribute);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREAttribute*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREAttribute*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREAttribute %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREAttribute*)p = *(ArrayOf_USCOREtns1_USCOREAttribute*)q;
}

void ArrayOf_USCOREtns1_USCOREPermissionEntry::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__PermissionEntry(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREPermissionEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREPermissionEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREPermissionEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREPermissionEntry *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:PermissionEntry", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__PermissionEntry(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREPermissionEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREPermissionEntry * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREPermissionEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREPermissionEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREPermissionEntry * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREPermissionEntry *a, const char *type)
{	int i, j;
	glite__PermissionEntry **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREPermissionEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry, sizeof(ArrayOf_USCOREtns1_USCOREPermissionEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__PermissionEntry **)soap_malloc(soap, sizeof(glite__PermissionEntry *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__PermissionEntry(soap, NULL, a->__ptr + i, "glite:PermissionEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__PermissionEntry **)soap_push_block(soap, sizeof(glite__PermissionEntry *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__PermissionEntry(soap, NULL, p, "glite:PermissionEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__PermissionEntry **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREPermissionEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry, 0, sizeof(ArrayOf_USCOREtns1_USCOREPermissionEntry), 0, soap_copy_ArrayOf_USCOREtns1_USCOREPermissionEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREPermissionEntry * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREPermissionEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREPermissionEntry * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREPermissionEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREPermissionEntry;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREPermissionEntry);
		((ArrayOf_USCOREtns1_USCOREPermissionEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREPermissionEntry[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREPermissionEntry);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREPermissionEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREPermissionEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREPermissionEntry %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREPermissionEntry*)p = *(ArrayOf_USCOREtns1_USCOREPermissionEntry*)q;
}

void ArrayOf_USCOREtns1_USCOREFCEntry::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__FCEntry(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREFCEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREFCEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREFCEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREFCEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREFCEntry *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:FCEntry", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__FCEntry(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREFCEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREFCEntry(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFCEntry * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFCEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREFCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREFCEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREFCEntry(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFCEntry * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREFCEntry *a, const char *type)
{	int i, j;
	glite__FCEntry **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREFCEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry, sizeof(ArrayOf_USCOREtns1_USCOREFCEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__FCEntry **)soap_malloc(soap, sizeof(glite__FCEntry *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__FCEntry(soap, NULL, a->__ptr + i, "glite:FCEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__FCEntry **)soap_push_block(soap, sizeof(glite__FCEntry *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__FCEntry(soap, NULL, p, "glite:FCEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__FCEntry **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREFCEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry, 0, sizeof(ArrayOf_USCOREtns1_USCOREFCEntry), 0, soap_copy_ArrayOf_USCOREtns1_USCOREFCEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREFCEntry * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREFCEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFCEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFCEntry * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREFCEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREFCEntry;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREFCEntry);
		((ArrayOf_USCOREtns1_USCOREFCEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREFCEntry[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREFCEntry);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREFCEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREFCEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREFCEntry %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREFCEntry*)p = *(ArrayOf_USCOREtns1_USCOREFCEntry*)q;
}

void ArrayOf_USCOREtns1_USCORESURLEntry::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__SURLEntry(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCORESURLEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCORESURLEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCORESURLEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORESURLEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORESURLEntry *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:SURLEntry", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__SURLEntry(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCORESURLEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORESURLEntry(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORESURLEntry * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORESURLEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORESURLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCORESURLEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORESURLEntry(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORESURLEntry * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORESURLEntry *a, const char *type)
{	int i, j;
	glite__SURLEntry **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORESURLEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry, sizeof(ArrayOf_USCOREtns1_USCORESURLEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__SURLEntry **)soap_malloc(soap, sizeof(glite__SURLEntry *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__SURLEntry(soap, NULL, a->__ptr + i, "glite:SURLEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__SURLEntry **)soap_push_block(soap, sizeof(glite__SURLEntry *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__SURLEntry(soap, NULL, p, "glite:SURLEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__SURLEntry **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORESURLEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry, 0, sizeof(ArrayOf_USCOREtns1_USCORESURLEntry), 0, soap_copy_ArrayOf_USCOREtns1_USCORESURLEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCORESURLEntry * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCORESURLEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORESURLEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORESURLEntry * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORESURLEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCORESURLEntry;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORESURLEntry);
		((ArrayOf_USCOREtns1_USCORESURLEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCORESURLEntry[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORESURLEntry);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORESURLEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORESURLEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORESURLEntry %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORESURLEntry*)p = *(ArrayOf_USCOREtns1_USCORESURLEntry*)q;
}

void ArrayOf_USCOREtns1_USCOREStat::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__Stat(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREStat::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREStat::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREStat::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREStat(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREStat *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:Stat", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__Stat(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREStat::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREStat(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStat * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREStat::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREStat(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStat * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREStat *a, const char *type)
{	int i, j;
	glite__Stat **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREStat *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat, sizeof(ArrayOf_USCOREtns1_USCOREStat), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__Stat **)soap_malloc(soap, sizeof(glite__Stat *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__Stat(soap, NULL, a->__ptr + i, "glite:Stat"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__Stat **)soap_push_block(soap, sizeof(glite__Stat *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__Stat(soap, NULL, p, "glite:Stat"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__Stat **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat, 0, sizeof(ArrayOf_USCOREtns1_USCOREStat), 0, soap_copy_ArrayOf_USCOREtns1_USCOREStat);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREStat * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStat * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREStat;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREStat);
		((ArrayOf_USCOREtns1_USCOREStat*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREStat[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREStat);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREStat*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREStat %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREStat*)p = *(ArrayOf_USCOREtns1_USCOREStat*)q;
}

void ArrayOf_USCOREtns1_USCOREStringPair::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__StringPair(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREStringPair::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREStringPair::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREStringPair::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREStringPair(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREStringPair *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:StringPair", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__StringPair(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREStringPair::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREStringPair(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringPair * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringPair *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREStringPair(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREStringPair::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREStringPair(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringPair * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREStringPair *a, const char *type)
{	int i, j;
	glite__StringPair **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREStringPair *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair, sizeof(ArrayOf_USCOREtns1_USCOREStringPair), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__StringPair **)soap_malloc(soap, sizeof(glite__StringPair *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__StringPair(soap, NULL, a->__ptr + i, "glite:StringPair"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__StringPair **)soap_push_block(soap, sizeof(glite__StringPair *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__StringPair(soap, NULL, p, "glite:StringPair"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__StringPair **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREStringPair *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair, 0, sizeof(ArrayOf_USCOREtns1_USCOREStringPair), 0, soap_copy_ArrayOf_USCOREtns1_USCOREStringPair);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREStringPair * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREStringPair(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringPair *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringPair * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREStringPair(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREStringPair;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREStringPair);
		((ArrayOf_USCOREtns1_USCOREStringPair*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREStringPair[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREStringPair);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREStringPair*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREStringPair*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREStringPair %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREStringPair*)p = *(ArrayOf_USCOREtns1_USCOREStringPair*)q;
}

void ArrayOf_USCOREtns1_USCOREFRCEntry::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerToglite__FRCEntry(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREtns1_USCOREFRCEntry::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREtns1_USCOREFRCEntry::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREtns1_USCOREFRCEntry::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCOREFRCEntry *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "glite:FRCEntry", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToglite__FRCEntry(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREtns1_USCOREFRCEntry::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFRCEntry * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFRCEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREtns1_USCOREFRCEntry::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFRCEntry * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREFRCEntry *a, const char *type)
{	int i, j;
	glite__FRCEntry **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCOREFRCEntry *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry, sizeof(ArrayOf_USCOREtns1_USCOREFRCEntry), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (glite__FRCEntry **)soap_malloc(soap, sizeof(glite__FRCEntry *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToglite__FRCEntry(soap, NULL, a->__ptr + i, "glite:FRCEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (glite__FRCEntry **)soap_push_block(soap, sizeof(glite__FRCEntry *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToglite__FRCEntry(soap, NULL, p, "glite:FRCEntry"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (glite__FRCEntry **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREFRCEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry, 0, sizeof(ArrayOf_USCOREtns1_USCOREFRCEntry), 0, soap_copy_ArrayOf_USCOREtns1_USCOREFRCEntry);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREtns1_USCOREFRCEntry * SOAP_FMAC6 soap_new_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFRCEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFRCEntry * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCOREFRCEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREFRCEntry;
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCOREFRCEntry);
		((ArrayOf_USCOREtns1_USCOREFRCEntry*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREtns1_USCOREFRCEntry[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCOREFRCEntry);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCOREFRCEntry*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCOREFRCEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCOREFRCEntry %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCOREFRCEntry*)p = *(ArrayOf_USCOREtns1_USCOREFRCEntry*)q;
}

void ArrayOf_USCOREsoapenc_USCOREstring::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_string(soap, this->__ptr + i);
		}
}

void ArrayOf_USCOREsoapenc_USCOREstring::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

int ArrayOf_USCOREsoapenc_USCOREstring::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ArrayOf_USCOREsoapenc_USCOREstring::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREsoapenc_USCOREstring(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREsoapenc_USCOREstring *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:string", a->__size);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring);
	if (id < 0)
		return soap->error;
	soap_array_begin_out(soap, tag, id, t, NULL);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ArrayOf_USCOREsoapenc_USCOREstring::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREsoapenc_USCOREstring(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREsoapenc_USCOREstring * SOAP_FMAC4 soap_get_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, ArrayOf_USCOREsoapenc_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREsoapenc_USCOREstring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ArrayOf_USCOREsoapenc_USCOREstring::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREsoapenc_USCOREstring(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREsoapenc_USCOREstring * SOAP_FMAC4 soap_in_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, const char *tag, ArrayOf_USCOREsoapenc_USCOREstring *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREsoapenc_USCOREstring *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring, sizeof(ArrayOf_USCOREsoapenc_USCOREstring), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREsoapenc_USCOREstring *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring, 0, sizeof(ArrayOf_USCOREsoapenc_USCOREstring), 0, soap_copy_ArrayOf_USCOREsoapenc_USCOREstring);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ArrayOf_USCOREsoapenc_USCOREstring * SOAP_FMAC6 soap_new_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, int n)
{	return soap_instantiate_ArrayOf_USCOREsoapenc_USCOREstring(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, ArrayOf_USCOREsoapenc_USCOREstring *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 ArrayOf_USCOREsoapenc_USCOREstring * SOAP_FMAC4 soap_instantiate_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREsoapenc_USCOREstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ArrayOf_USCOREsoapenc_USCOREstring;
		if (size)
			*size = sizeof(ArrayOf_USCOREsoapenc_USCOREstring);
		((ArrayOf_USCOREsoapenc_USCOREstring*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ArrayOf_USCOREsoapenc_USCOREstring[n];
		if (size)
			*size = n * sizeof(ArrayOf_USCOREsoapenc_USCOREstring);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREsoapenc_USCOREstring*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREsoapenc_USCOREstring*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREsoapenc_USCOREstring %p -> %p\n", q, p));
	*(ArrayOf_USCOREsoapenc_USCOREstring*)p = *(ArrayOf_USCOREsoapenc_USCOREstring*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getDefaultGlobalPermission(struct soap *soap, const struct fireman__getDefaultGlobalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getDefaultGlobalPermission(struct soap *soap, struct fireman__getDefaultGlobalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getDefaultGlobalPermission(struct soap *soap, const struct fireman__getDefaultGlobalPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getDefaultGlobalPermission);
	if (soap_out_fireman__getDefaultGlobalPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getDefaultGlobalPermission(struct soap *soap, const char *tag, int id, const struct fireman__getDefaultGlobalPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getDefaultGlobalPermission), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getDefaultGlobalPermission * SOAP_FMAC4 soap_get_fireman__getDefaultGlobalPermission(struct soap *soap, struct fireman__getDefaultGlobalPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getDefaultGlobalPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getDefaultGlobalPermission * SOAP_FMAC4 soap_in_fireman__getDefaultGlobalPermission(struct soap *soap, const char *tag, struct fireman__getDefaultGlobalPermission *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getDefaultGlobalPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getDefaultGlobalPermission, sizeof(struct fireman__getDefaultGlobalPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getDefaultGlobalPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getDefaultGlobalPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getDefaultGlobalPermission, 0, sizeof(struct fireman__getDefaultGlobalPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getDefaultGlobalPermission * SOAP_FMAC6 soap_new_fireman__getDefaultGlobalPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__getDefaultGlobalPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getDefaultGlobalPermission(struct soap *soap, struct fireman__getDefaultGlobalPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getDefaultGlobalPermission * SOAP_FMAC4 soap_instantiate_fireman__getDefaultGlobalPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getDefaultGlobalPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getDefaultGlobalPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getDefaultGlobalPermission;
		if (size)
			*size = sizeof(struct fireman__getDefaultGlobalPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getDefaultGlobalPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__getDefaultGlobalPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getDefaultGlobalPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getDefaultGlobalPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getDefaultGlobalPermission %p -> %p\n", q, p));
	*(struct fireman__getDefaultGlobalPermission*)p = *(struct fireman__getDefaultGlobalPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, const struct fireman__getDefaultGlobalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__Permission(soap, &a->getDefaultGlobalPermissionReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, struct fireman__getDefaultGlobalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->getDefaultGlobalPermissionReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, const struct fireman__getDefaultGlobalPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse);
	if (soap_out_fireman__getDefaultGlobalPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__getDefaultGlobalPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse), type);
	if (a->getDefaultGlobalPermissionReturn)
		soap_element_result(soap, "getDefaultGlobalPermissionReturn");
	soap_out_PointerToglite__Permission(soap, "getDefaultGlobalPermissionReturn", -1, &a->getDefaultGlobalPermissionReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getDefaultGlobalPermissionResponse * SOAP_FMAC4 soap_get_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, struct fireman__getDefaultGlobalPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getDefaultGlobalPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getDefaultGlobalPermissionResponse * SOAP_FMAC4 soap_in_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, const char *tag, struct fireman__getDefaultGlobalPermissionResponse *a, const char *type)
{
	short soap_flag_getDefaultGlobalPermissionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getDefaultGlobalPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse, sizeof(struct fireman__getDefaultGlobalPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getDefaultGlobalPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getDefaultGlobalPermissionReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, "getDefaultGlobalPermissionReturn", &a->getDefaultGlobalPermissionReturn, "glite:Permission"))
				{	soap_flag_getDefaultGlobalPermissionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getDefaultGlobalPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse, 0, sizeof(struct fireman__getDefaultGlobalPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getDefaultGlobalPermissionResponse * SOAP_FMAC6 soap_new_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getDefaultGlobalPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, struct fireman__getDefaultGlobalPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getDefaultGlobalPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getDefaultGlobalPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getDefaultGlobalPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getDefaultGlobalPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__getDefaultGlobalPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getDefaultGlobalPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getDefaultGlobalPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getDefaultGlobalPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getDefaultGlobalPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getDefaultGlobalPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__getDefaultGlobalPermissionResponse*)p = *(struct fireman__getDefaultGlobalPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getDefaultPrincipalPermission(struct soap *soap, const struct fireman__getDefaultPrincipalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_principal);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getDefaultPrincipalPermission(struct soap *soap, struct fireman__getDefaultPrincipalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_principal);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getDefaultPrincipalPermission(struct soap *soap, const struct fireman__getDefaultPrincipalPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getDefaultPrincipalPermission);
	if (soap_out_fireman__getDefaultPrincipalPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getDefaultPrincipalPermission(struct soap *soap, const char *tag, int id, const struct fireman__getDefaultPrincipalPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getDefaultPrincipalPermission), type);
	soap_out_string(soap, "principal", -1, &a->_principal, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getDefaultPrincipalPermission * SOAP_FMAC4 soap_get_fireman__getDefaultPrincipalPermission(struct soap *soap, struct fireman__getDefaultPrincipalPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getDefaultPrincipalPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getDefaultPrincipalPermission * SOAP_FMAC4 soap_in_fireman__getDefaultPrincipalPermission(struct soap *soap, const char *tag, struct fireman__getDefaultPrincipalPermission *a, const char *type)
{
	short soap_flag__principal = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getDefaultPrincipalPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getDefaultPrincipalPermission, sizeof(struct fireman__getDefaultPrincipalPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getDefaultPrincipalPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__principal && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_principal, "xsd:string"))
				{	soap_flag__principal--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getDefaultPrincipalPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getDefaultPrincipalPermission, 0, sizeof(struct fireman__getDefaultPrincipalPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getDefaultPrincipalPermission * SOAP_FMAC6 soap_new_fireman__getDefaultPrincipalPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__getDefaultPrincipalPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getDefaultPrincipalPermission(struct soap *soap, struct fireman__getDefaultPrincipalPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getDefaultPrincipalPermission * SOAP_FMAC4 soap_instantiate_fireman__getDefaultPrincipalPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getDefaultPrincipalPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getDefaultPrincipalPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getDefaultPrincipalPermission;
		if (size)
			*size = sizeof(struct fireman__getDefaultPrincipalPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getDefaultPrincipalPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__getDefaultPrincipalPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getDefaultPrincipalPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getDefaultPrincipalPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getDefaultPrincipalPermission %p -> %p\n", q, p));
	*(struct fireman__getDefaultPrincipalPermission*)p = *(struct fireman__getDefaultPrincipalPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, const struct fireman__getDefaultPrincipalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__Permission(soap, &a->_getDefaultPrincipalPermissionReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, struct fireman__getDefaultPrincipalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getDefaultPrincipalPermissionReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, const struct fireman__getDefaultPrincipalPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse);
	if (soap_out_fireman__getDefaultPrincipalPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__getDefaultPrincipalPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse), type);
	if (a->_getDefaultPrincipalPermissionReturn)
		soap_element_result(soap, "getDefaultPrincipalPermissionReturn");
	soap_out_PointerToglite__Permission(soap, "getDefaultPrincipalPermissionReturn", -1, &a->_getDefaultPrincipalPermissionReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getDefaultPrincipalPermissionResponse * SOAP_FMAC4 soap_get_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, struct fireman__getDefaultPrincipalPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getDefaultPrincipalPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getDefaultPrincipalPermissionResponse * SOAP_FMAC4 soap_in_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, const char *tag, struct fireman__getDefaultPrincipalPermissionResponse *a, const char *type)
{
	short soap_flag__getDefaultPrincipalPermissionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getDefaultPrincipalPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse, sizeof(struct fireman__getDefaultPrincipalPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getDefaultPrincipalPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getDefaultPrincipalPermissionReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, NULL, &a->_getDefaultPrincipalPermissionReturn, "glite:Permission"))
				{	soap_flag__getDefaultPrincipalPermissionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getDefaultPrincipalPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse, 0, sizeof(struct fireman__getDefaultPrincipalPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getDefaultPrincipalPermissionResponse * SOAP_FMAC6 soap_new_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getDefaultPrincipalPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, struct fireman__getDefaultPrincipalPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getDefaultPrincipalPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getDefaultPrincipalPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getDefaultPrincipalPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getDefaultPrincipalPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__getDefaultPrincipalPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getDefaultPrincipalPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getDefaultPrincipalPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getDefaultPrincipalPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getDefaultPrincipalPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getDefaultPrincipalPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__getDefaultPrincipalPermissionResponse*)p = *(struct fireman__getDefaultPrincipalPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getSurlStat(struct soap *soap, const struct fireman__getSurlStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_surls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getSurlStat(struct soap *soap, struct fireman__getSurlStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_surls = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getSurlStat(struct soap *soap, const struct fireman__getSurlStat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getSurlStat);
	if (soap_out_fireman__getSurlStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getSurlStat(struct soap *soap, const char *tag, int id, const struct fireman__getSurlStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getSurlStat), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "surls", -1, &a->_surls, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getSurlStat * SOAP_FMAC4 soap_get_fireman__getSurlStat(struct soap *soap, struct fireman__getSurlStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getSurlStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getSurlStat * SOAP_FMAC4 soap_in_fireman__getSurlStat(struct soap *soap, const char *tag, struct fireman__getSurlStat *a, const char *type)
{
	short soap_flag__surls = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getSurlStat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getSurlStat, sizeof(struct fireman__getSurlStat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getSurlStat(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__surls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_surls, "xsd:string"))
				{	soap_flag__surls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getSurlStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getSurlStat, 0, sizeof(struct fireman__getSurlStat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getSurlStat * SOAP_FMAC6 soap_new_fireman__getSurlStat(struct soap *soap, int n)
{	return soap_instantiate_fireman__getSurlStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getSurlStat(struct soap *soap, struct fireman__getSurlStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getSurlStat * SOAP_FMAC4 soap_instantiate_fireman__getSurlStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getSurlStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getSurlStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getSurlStat;
		if (size)
			*size = sizeof(struct fireman__getSurlStat);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getSurlStat[n];
		if (size)
			*size = n * sizeof(struct fireman__getSurlStat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getSurlStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getSurlStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getSurlStat %p -> %p\n", q, p));
	*(struct fireman__getSurlStat*)p = *(struct fireman__getSurlStat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getSurlStatResponse(struct soap *soap, const struct fireman__getSurlStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, &a->_getSurlStatReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getSurlStatResponse(struct soap *soap, struct fireman__getSurlStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getSurlStatReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getSurlStatResponse(struct soap *soap, const struct fireman__getSurlStatResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getSurlStatResponse);
	if (soap_out_fireman__getSurlStatResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getSurlStatResponse(struct soap *soap, const char *tag, int id, const struct fireman__getSurlStatResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getSurlStatResponse), type);
	if (a->_getSurlStatReturn)
		soap_element_result(soap, "getSurlStatReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, "getSurlStatReturn", -1, &a->_getSurlStatReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getSurlStatResponse * SOAP_FMAC4 soap_get_fireman__getSurlStatResponse(struct soap *soap, struct fireman__getSurlStatResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getSurlStatResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getSurlStatResponse * SOAP_FMAC4 soap_in_fireman__getSurlStatResponse(struct soap *soap, const char *tag, struct fireman__getSurlStatResponse *a, const char *type)
{
	short soap_flag__getSurlStatReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getSurlStatResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getSurlStatResponse, sizeof(struct fireman__getSurlStatResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getSurlStatResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getSurlStatReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, &a->_getSurlStatReturn, "glite:SURLEntry"))
				{	soap_flag__getSurlStatReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getSurlStatResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getSurlStatResponse, 0, sizeof(struct fireman__getSurlStatResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getSurlStatResponse * SOAP_FMAC6 soap_new_fireman__getSurlStatResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getSurlStatResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getSurlStatResponse(struct soap *soap, struct fireman__getSurlStatResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getSurlStatResponse * SOAP_FMAC4 soap_instantiate_fireman__getSurlStatResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getSurlStatResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getSurlStatResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getSurlStatResponse;
		if (size)
			*size = sizeof(struct fireman__getSurlStatResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getSurlStatResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getSurlStatResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getSurlStatResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getSurlStatResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getSurlStatResponse %p -> %p\n", q, p));
	*(struct fireman__getSurlStatResponse*)p = *(struct fireman__getSurlStatResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getGuidStat(struct soap *soap, const struct fireman__getGuidStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getGuidStat(struct soap *soap, struct fireman__getGuidStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getGuidStat(struct soap *soap, const struct fireman__getGuidStat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getGuidStat);
	if (soap_out_fireman__getGuidStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getGuidStat(struct soap *soap, const char *tag, int id, const struct fireman__getGuidStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getGuidStat), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getGuidStat * SOAP_FMAC4 soap_get_fireman__getGuidStat(struct soap *soap, struct fireman__getGuidStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getGuidStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getGuidStat * SOAP_FMAC4 soap_in_fireman__getGuidStat(struct soap *soap, const char *tag, struct fireman__getGuidStat *a, const char *type)
{
	short soap_flag__guids = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getGuidStat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getGuidStat, sizeof(struct fireman__getGuidStat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getGuidStat(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getGuidStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getGuidStat, 0, sizeof(struct fireman__getGuidStat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getGuidStat * SOAP_FMAC6 soap_new_fireman__getGuidStat(struct soap *soap, int n)
{	return soap_instantiate_fireman__getGuidStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getGuidStat(struct soap *soap, struct fireman__getGuidStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getGuidStat * SOAP_FMAC4 soap_instantiate_fireman__getGuidStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getGuidStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getGuidStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getGuidStat;
		if (size)
			*size = sizeof(struct fireman__getGuidStat);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getGuidStat[n];
		if (size)
			*size = n * sizeof(struct fireman__getGuidStat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getGuidStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getGuidStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getGuidStat %p -> %p\n", q, p));
	*(struct fireman__getGuidStat*)p = *(struct fireman__getGuidStat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getGuidStatResponse(struct soap *soap, const struct fireman__getGuidStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, &a->_getGuidStatReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getGuidStatResponse(struct soap *soap, struct fireman__getGuidStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getGuidStatReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getGuidStatResponse(struct soap *soap, const struct fireman__getGuidStatResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getGuidStatResponse);
	if (soap_out_fireman__getGuidStatResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getGuidStatResponse(struct soap *soap, const char *tag, int id, const struct fireman__getGuidStatResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getGuidStatResponse), type);
	if (a->_getGuidStatReturn)
		soap_element_result(soap, "getGuidStatReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, "getGuidStatReturn", -1, &a->_getGuidStatReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getGuidStatResponse * SOAP_FMAC4 soap_get_fireman__getGuidStatResponse(struct soap *soap, struct fireman__getGuidStatResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getGuidStatResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getGuidStatResponse * SOAP_FMAC4 soap_in_fireman__getGuidStatResponse(struct soap *soap, const char *tag, struct fireman__getGuidStatResponse *a, const char *type)
{
	short soap_flag__getGuidStatReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getGuidStatResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getGuidStatResponse, sizeof(struct fireman__getGuidStatResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getGuidStatResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getGuidStatReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, NULL, &a->_getGuidStatReturn, "glite:GUIDStat"))
				{	soap_flag__getGuidStatReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getGuidStatResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getGuidStatResponse, 0, sizeof(struct fireman__getGuidStatResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getGuidStatResponse * SOAP_FMAC6 soap_new_fireman__getGuidStatResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getGuidStatResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getGuidStatResponse(struct soap *soap, struct fireman__getGuidStatResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getGuidStatResponse * SOAP_FMAC4 soap_instantiate_fireman__getGuidStatResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getGuidStatResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getGuidStatResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getGuidStatResponse;
		if (size)
			*size = sizeof(struct fireman__getGuidStatResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getGuidStatResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getGuidStatResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getGuidStatResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getGuidStatResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getGuidStatResponse %p -> %p\n", q, p));
	*(struct fireman__getGuidStatResponse*)p = *(struct fireman__getGuidStatResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__hasGuid(struct soap *soap, const struct fireman__hasGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__hasGuid(struct soap *soap, struct fireman__hasGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__hasGuid(struct soap *soap, const struct fireman__hasGuid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__hasGuid);
	if (soap_out_fireman__hasGuid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__hasGuid(struct soap *soap, const char *tag, int id, const struct fireman__hasGuid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__hasGuid), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__hasGuid * SOAP_FMAC4 soap_get_fireman__hasGuid(struct soap *soap, struct fireman__hasGuid *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__hasGuid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__hasGuid * SOAP_FMAC4 soap_in_fireman__hasGuid(struct soap *soap, const char *tag, struct fireman__hasGuid *a, const char *type)
{
	short soap_flag__guids = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__hasGuid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__hasGuid, sizeof(struct fireman__hasGuid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__hasGuid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__hasGuid *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__hasGuid, 0, sizeof(struct fireman__hasGuid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__hasGuid * SOAP_FMAC6 soap_new_fireman__hasGuid(struct soap *soap, int n)
{	return soap_instantiate_fireman__hasGuid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__hasGuid(struct soap *soap, struct fireman__hasGuid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__hasGuid * SOAP_FMAC4 soap_instantiate_fireman__hasGuid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__hasGuid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__hasGuid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__hasGuid;
		if (size)
			*size = sizeof(struct fireman__hasGuid);
	}
	else
	{	cp->ptr = (void*)new struct fireman__hasGuid[n];
		if (size)
			*size = n * sizeof(struct fireman__hasGuid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__hasGuid*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__hasGuid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__hasGuid %p -> %p\n", q, p));
	*(struct fireman__hasGuid*)p = *(struct fireman__hasGuid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__hasGuidResponse(struct soap *soap, const struct fireman__hasGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, &a->_hasGuidReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__hasGuidResponse(struct soap *soap, struct fireman__hasGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_hasGuidReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__hasGuidResponse(struct soap *soap, const struct fireman__hasGuidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__hasGuidResponse);
	if (soap_out_fireman__hasGuidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__hasGuidResponse(struct soap *soap, const char *tag, int id, const struct fireman__hasGuidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__hasGuidResponse), type);
	if (a->_hasGuidReturn)
		soap_element_result(soap, "hasGuidReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, "hasGuidReturn", -1, &a->_hasGuidReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__hasGuidResponse * SOAP_FMAC4 soap_get_fireman__hasGuidResponse(struct soap *soap, struct fireman__hasGuidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__hasGuidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__hasGuidResponse * SOAP_FMAC4 soap_in_fireman__hasGuidResponse(struct soap *soap, const char *tag, struct fireman__hasGuidResponse *a, const char *type)
{
	short soap_flag__hasGuidReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__hasGuidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__hasGuidResponse, sizeof(struct fireman__hasGuidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__hasGuidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__hasGuidReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, NULL, &a->_hasGuidReturn, "glite:StringBoolean"))
				{	soap_flag__hasGuidReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__hasGuidResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__hasGuidResponse, 0, sizeof(struct fireman__hasGuidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__hasGuidResponse * SOAP_FMAC6 soap_new_fireman__hasGuidResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__hasGuidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__hasGuidResponse(struct soap *soap, struct fireman__hasGuidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__hasGuidResponse * SOAP_FMAC4 soap_instantiate_fireman__hasGuidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__hasGuidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__hasGuidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__hasGuidResponse;
		if (size)
			*size = sizeof(struct fireman__hasGuidResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__hasGuidResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__hasGuidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__hasGuidResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__hasGuidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__hasGuidResponse %p -> %p\n", q, p));
	*(struct fireman__hasGuidResponse*)p = *(struct fireman__hasGuidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listReplicasByGuid(struct soap *soap, const struct fireman__listReplicasByGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listReplicasByGuid(struct soap *soap, struct fireman__listReplicasByGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
	soap_default_bool(soap, &a->_withPermissions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listReplicasByGuid(struct soap *soap, const struct fireman__listReplicasByGuid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listReplicasByGuid);
	if (soap_out_fireman__listReplicasByGuid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listReplicasByGuid(struct soap *soap, const char *tag, int id, const struct fireman__listReplicasByGuid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listReplicasByGuid), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_out_bool(soap, "withPermissions", -1, &a->_withPermissions, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listReplicasByGuid * SOAP_FMAC4 soap_get_fireman__listReplicasByGuid(struct soap *soap, struct fireman__listReplicasByGuid *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listReplicasByGuid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listReplicasByGuid * SOAP_FMAC4 soap_in_fireman__listReplicasByGuid(struct soap *soap, const char *tag, struct fireman__listReplicasByGuid *a, const char *type)
{
	short soap_flag__guids = 1, soap_flag__withPermissions = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listReplicasByGuid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listReplicasByGuid, sizeof(struct fireman__listReplicasByGuid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listReplicasByGuid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap_flag__withPermissions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_withPermissions, "xsd:boolean"))
				{	soap_flag__withPermissions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__withPermissions > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listReplicasByGuid *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listReplicasByGuid, 0, sizeof(struct fireman__listReplicasByGuid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listReplicasByGuid * SOAP_FMAC6 soap_new_fireman__listReplicasByGuid(struct soap *soap, int n)
{	return soap_instantiate_fireman__listReplicasByGuid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listReplicasByGuid(struct soap *soap, struct fireman__listReplicasByGuid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listReplicasByGuid * SOAP_FMAC4 soap_instantiate_fireman__listReplicasByGuid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listReplicasByGuid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listReplicasByGuid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listReplicasByGuid;
		if (size)
			*size = sizeof(struct fireman__listReplicasByGuid);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listReplicasByGuid[n];
		if (size)
			*size = n * sizeof(struct fireman__listReplicasByGuid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listReplicasByGuid*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listReplicasByGuid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listReplicasByGuid %p -> %p\n", q, p));
	*(struct fireman__listReplicasByGuid*)p = *(struct fireman__listReplicasByGuid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listReplicasByGuidResponse(struct soap *soap, const struct fireman__listReplicasByGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, &a->_listReplicasByGuidReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listReplicasByGuidResponse(struct soap *soap, struct fireman__listReplicasByGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_listReplicasByGuidReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listReplicasByGuidResponse(struct soap *soap, const struct fireman__listReplicasByGuidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listReplicasByGuidResponse);
	if (soap_out_fireman__listReplicasByGuidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listReplicasByGuidResponse(struct soap *soap, const char *tag, int id, const struct fireman__listReplicasByGuidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listReplicasByGuidResponse), type);
	if (a->_listReplicasByGuidReturn)
		soap_element_result(soap, "listReplicasByGuidReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, "listReplicasByGuidReturn", -1, &a->_listReplicasByGuidReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listReplicasByGuidResponse * SOAP_FMAC4 soap_get_fireman__listReplicasByGuidResponse(struct soap *soap, struct fireman__listReplicasByGuidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listReplicasByGuidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listReplicasByGuidResponse * SOAP_FMAC4 soap_in_fireman__listReplicasByGuidResponse(struct soap *soap, const char *tag, struct fireman__listReplicasByGuidResponse *a, const char *type)
{
	short soap_flag__listReplicasByGuidReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listReplicasByGuidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listReplicasByGuidResponse, sizeof(struct fireman__listReplicasByGuidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listReplicasByGuidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__listReplicasByGuidReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, NULL, &a->_listReplicasByGuidReturn, "glite:RCEntry"))
				{	soap_flag__listReplicasByGuidReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listReplicasByGuidResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listReplicasByGuidResponse, 0, sizeof(struct fireman__listReplicasByGuidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listReplicasByGuidResponse * SOAP_FMAC6 soap_new_fireman__listReplicasByGuidResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__listReplicasByGuidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listReplicasByGuidResponse(struct soap *soap, struct fireman__listReplicasByGuidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listReplicasByGuidResponse * SOAP_FMAC4 soap_instantiate_fireman__listReplicasByGuidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listReplicasByGuidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listReplicasByGuidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listReplicasByGuidResponse;
		if (size)
			*size = sizeof(struct fireman__listReplicasByGuidResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listReplicasByGuidResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__listReplicasByGuidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listReplicasByGuidResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listReplicasByGuidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listReplicasByGuidResponse %p -> %p\n", q, p));
	*(struct fireman__listReplicasByGuidResponse*)p = *(struct fireman__listReplicasByGuidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listSurlsByGuid(struct soap *soap, const struct fireman__listSurlsByGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listSurlsByGuid(struct soap *soap, struct fireman__listSurlsByGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listSurlsByGuid(struct soap *soap, const struct fireman__listSurlsByGuid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listSurlsByGuid);
	if (soap_out_fireman__listSurlsByGuid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listSurlsByGuid(struct soap *soap, const char *tag, int id, const struct fireman__listSurlsByGuid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listSurlsByGuid), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listSurlsByGuid * SOAP_FMAC4 soap_get_fireman__listSurlsByGuid(struct soap *soap, struct fireman__listSurlsByGuid *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listSurlsByGuid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listSurlsByGuid * SOAP_FMAC4 soap_in_fireman__listSurlsByGuid(struct soap *soap, const char *tag, struct fireman__listSurlsByGuid *a, const char *type)
{
	short soap_flag__guids = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listSurlsByGuid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listSurlsByGuid, sizeof(struct fireman__listSurlsByGuid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listSurlsByGuid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listSurlsByGuid *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listSurlsByGuid, 0, sizeof(struct fireman__listSurlsByGuid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listSurlsByGuid * SOAP_FMAC6 soap_new_fireman__listSurlsByGuid(struct soap *soap, int n)
{	return soap_instantiate_fireman__listSurlsByGuid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listSurlsByGuid(struct soap *soap, struct fireman__listSurlsByGuid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listSurlsByGuid * SOAP_FMAC4 soap_instantiate_fireman__listSurlsByGuid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listSurlsByGuid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listSurlsByGuid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listSurlsByGuid;
		if (size)
			*size = sizeof(struct fireman__listSurlsByGuid);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listSurlsByGuid[n];
		if (size)
			*size = n * sizeof(struct fireman__listSurlsByGuid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listSurlsByGuid*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listSurlsByGuid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listSurlsByGuid %p -> %p\n", q, p));
	*(struct fireman__listSurlsByGuid*)p = *(struct fireman__listSurlsByGuid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listSurlsByGuidResponse(struct soap *soap, const struct fireman__listSurlsByGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_listSurlsByGuidReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listSurlsByGuidResponse(struct soap *soap, struct fireman__listSurlsByGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_listSurlsByGuidReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listSurlsByGuidResponse(struct soap *soap, const struct fireman__listSurlsByGuidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listSurlsByGuidResponse);
	if (soap_out_fireman__listSurlsByGuidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listSurlsByGuidResponse(struct soap *soap, const char *tag, int id, const struct fireman__listSurlsByGuidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listSurlsByGuidResponse), type);
	if (a->_listSurlsByGuidReturn)
		soap_element_result(soap, "listSurlsByGuidReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "listSurlsByGuidReturn", -1, &a->_listSurlsByGuidReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listSurlsByGuidResponse * SOAP_FMAC4 soap_get_fireman__listSurlsByGuidResponse(struct soap *soap, struct fireman__listSurlsByGuidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listSurlsByGuidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listSurlsByGuidResponse * SOAP_FMAC4 soap_in_fireman__listSurlsByGuidResponse(struct soap *soap, const char *tag, struct fireman__listSurlsByGuidResponse *a, const char *type)
{
	short soap_flag__listSurlsByGuidReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listSurlsByGuidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listSurlsByGuidResponse, sizeof(struct fireman__listSurlsByGuidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listSurlsByGuidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__listSurlsByGuidReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_listSurlsByGuidReturn, "glite:StringPair"))
				{	soap_flag__listSurlsByGuidReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listSurlsByGuidResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listSurlsByGuidResponse, 0, sizeof(struct fireman__listSurlsByGuidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listSurlsByGuidResponse * SOAP_FMAC6 soap_new_fireman__listSurlsByGuidResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__listSurlsByGuidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listSurlsByGuidResponse(struct soap *soap, struct fireman__listSurlsByGuidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listSurlsByGuidResponse * SOAP_FMAC4 soap_instantiate_fireman__listSurlsByGuidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listSurlsByGuidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listSurlsByGuidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listSurlsByGuidResponse;
		if (size)
			*size = sizeof(struct fireman__listSurlsByGuidResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listSurlsByGuidResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__listSurlsByGuidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listSurlsByGuidResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listSurlsByGuidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listSurlsByGuidResponse %p -> %p\n", q, p));
	*(struct fireman__listSurlsByGuidResponse*)p = *(struct fireman__listSurlsByGuidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getMasterReplica(struct soap *soap, const struct fireman__getMasterReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getMasterReplica(struct soap *soap, struct fireman__getMasterReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getMasterReplica(struct soap *soap, const struct fireman__getMasterReplica *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getMasterReplica);
	if (soap_out_fireman__getMasterReplica(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getMasterReplica(struct soap *soap, const char *tag, int id, const struct fireman__getMasterReplica *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getMasterReplica), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getMasterReplica * SOAP_FMAC4 soap_get_fireman__getMasterReplica(struct soap *soap, struct fireman__getMasterReplica *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getMasterReplica(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getMasterReplica * SOAP_FMAC4 soap_in_fireman__getMasterReplica(struct soap *soap, const char *tag, struct fireman__getMasterReplica *a, const char *type)
{
	short soap_flag__guids = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getMasterReplica *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getMasterReplica, sizeof(struct fireman__getMasterReplica), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getMasterReplica(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getMasterReplica *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getMasterReplica, 0, sizeof(struct fireman__getMasterReplica), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getMasterReplica * SOAP_FMAC6 soap_new_fireman__getMasterReplica(struct soap *soap, int n)
{	return soap_instantiate_fireman__getMasterReplica(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getMasterReplica(struct soap *soap, struct fireman__getMasterReplica *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getMasterReplica * SOAP_FMAC4 soap_instantiate_fireman__getMasterReplica(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getMasterReplica(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getMasterReplica, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getMasterReplica;
		if (size)
			*size = sizeof(struct fireman__getMasterReplica);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getMasterReplica[n];
		if (size)
			*size = n * sizeof(struct fireman__getMasterReplica);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getMasterReplica*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getMasterReplica(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getMasterReplica %p -> %p\n", q, p));
	*(struct fireman__getMasterReplica*)p = *(struct fireman__getMasterReplica*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getMasterReplicaResponse(struct soap *soap, const struct fireman__getMasterReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_getMasterReplicaReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getMasterReplicaResponse(struct soap *soap, struct fireman__getMasterReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getMasterReplicaReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getMasterReplicaResponse(struct soap *soap, const struct fireman__getMasterReplicaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getMasterReplicaResponse);
	if (soap_out_fireman__getMasterReplicaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getMasterReplicaResponse(struct soap *soap, const char *tag, int id, const struct fireman__getMasterReplicaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getMasterReplicaResponse), type);
	if (a->_getMasterReplicaReturn)
		soap_element_result(soap, "getMasterReplicaReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "getMasterReplicaReturn", -1, &a->_getMasterReplicaReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getMasterReplicaResponse * SOAP_FMAC4 soap_get_fireman__getMasterReplicaResponse(struct soap *soap, struct fireman__getMasterReplicaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getMasterReplicaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getMasterReplicaResponse * SOAP_FMAC4 soap_in_fireman__getMasterReplicaResponse(struct soap *soap, const char *tag, struct fireman__getMasterReplicaResponse *a, const char *type)
{
	short soap_flag__getMasterReplicaReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getMasterReplicaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getMasterReplicaResponse, sizeof(struct fireman__getMasterReplicaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getMasterReplicaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getMasterReplicaReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_getMasterReplicaReturn, "glite:StringPair"))
				{	soap_flag__getMasterReplicaReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getMasterReplicaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getMasterReplicaResponse, 0, sizeof(struct fireman__getMasterReplicaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getMasterReplicaResponse * SOAP_FMAC6 soap_new_fireman__getMasterReplicaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getMasterReplicaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getMasterReplicaResponse(struct soap *soap, struct fireman__getMasterReplicaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getMasterReplicaResponse * SOAP_FMAC4 soap_instantiate_fireman__getMasterReplicaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getMasterReplicaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getMasterReplicaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getMasterReplicaResponse;
		if (size)
			*size = sizeof(struct fireman__getMasterReplicaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getMasterReplicaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getMasterReplicaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getMasterReplicaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getMasterReplicaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getMasterReplicaResponse %p -> %p\n", q, p));
	*(struct fireman__getMasterReplicaResponse*)p = *(struct fireman__getMasterReplicaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getGuidForSurl(struct soap *soap, const struct fireman__getGuidForSurl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_surls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getGuidForSurl(struct soap *soap, struct fireman__getGuidForSurl *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_surls = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getGuidForSurl(struct soap *soap, const struct fireman__getGuidForSurl *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getGuidForSurl);
	if (soap_out_fireman__getGuidForSurl(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getGuidForSurl(struct soap *soap, const char *tag, int id, const struct fireman__getGuidForSurl *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getGuidForSurl), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "surls", -1, &a->_surls, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getGuidForSurl * SOAP_FMAC4 soap_get_fireman__getGuidForSurl(struct soap *soap, struct fireman__getGuidForSurl *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getGuidForSurl(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getGuidForSurl * SOAP_FMAC4 soap_in_fireman__getGuidForSurl(struct soap *soap, const char *tag, struct fireman__getGuidForSurl *a, const char *type)
{
	short soap_flag__surls = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getGuidForSurl *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getGuidForSurl, sizeof(struct fireman__getGuidForSurl), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getGuidForSurl(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__surls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_surls, "xsd:string"))
				{	soap_flag__surls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getGuidForSurl *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getGuidForSurl, 0, sizeof(struct fireman__getGuidForSurl), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getGuidForSurl * SOAP_FMAC6 soap_new_fireman__getGuidForSurl(struct soap *soap, int n)
{	return soap_instantiate_fireman__getGuidForSurl(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getGuidForSurl(struct soap *soap, struct fireman__getGuidForSurl *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getGuidForSurl * SOAP_FMAC4 soap_instantiate_fireman__getGuidForSurl(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getGuidForSurl(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getGuidForSurl, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getGuidForSurl;
		if (size)
			*size = sizeof(struct fireman__getGuidForSurl);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getGuidForSurl[n];
		if (size)
			*size = n * sizeof(struct fireman__getGuidForSurl);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getGuidForSurl*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getGuidForSurl(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getGuidForSurl %p -> %p\n", q, p));
	*(struct fireman__getGuidForSurl*)p = *(struct fireman__getGuidForSurl*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getGuidForSurlResponse(struct soap *soap, const struct fireman__getGuidForSurlResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_getGuidForSurlReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getGuidForSurlResponse(struct soap *soap, struct fireman__getGuidForSurlResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getGuidForSurlReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getGuidForSurlResponse(struct soap *soap, const struct fireman__getGuidForSurlResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getGuidForSurlResponse);
	if (soap_out_fireman__getGuidForSurlResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getGuidForSurlResponse(struct soap *soap, const char *tag, int id, const struct fireman__getGuidForSurlResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getGuidForSurlResponse), type);
	if (a->_getGuidForSurlReturn)
		soap_element_result(soap, "getGuidForSurlReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "getGuidForSurlReturn", -1, &a->_getGuidForSurlReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getGuidForSurlResponse * SOAP_FMAC4 soap_get_fireman__getGuidForSurlResponse(struct soap *soap, struct fireman__getGuidForSurlResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getGuidForSurlResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getGuidForSurlResponse * SOAP_FMAC4 soap_in_fireman__getGuidForSurlResponse(struct soap *soap, const char *tag, struct fireman__getGuidForSurlResponse *a, const char *type)
{
	short soap_flag__getGuidForSurlReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getGuidForSurlResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getGuidForSurlResponse, sizeof(struct fireman__getGuidForSurlResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getGuidForSurlResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getGuidForSurlReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_getGuidForSurlReturn, "glite:StringPair"))
				{	soap_flag__getGuidForSurlReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getGuidForSurlResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getGuidForSurlResponse, 0, sizeof(struct fireman__getGuidForSurlResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getGuidForSurlResponse * SOAP_FMAC6 soap_new_fireman__getGuidForSurlResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getGuidForSurlResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getGuidForSurlResponse(struct soap *soap, struct fireman__getGuidForSurlResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getGuidForSurlResponse * SOAP_FMAC4 soap_instantiate_fireman__getGuidForSurlResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getGuidForSurlResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getGuidForSurlResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getGuidForSurlResponse;
		if (size)
			*size = sizeof(struct fireman__getGuidForSurlResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getGuidForSurlResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getGuidForSurlResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getGuidForSurlResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getGuidForSurlResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getGuidForSurlResponse %p -> %p\n", q, p));
	*(struct fireman__getGuidForSurlResponse*)p = *(struct fireman__getGuidForSurlResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setDefaultGlobalPermission(struct soap *soap, const struct fireman__setDefaultGlobalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToglite__Permission(soap, &a->_defaultPermission);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setDefaultGlobalPermission(struct soap *soap, struct fireman__setDefaultGlobalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_defaultPermission = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setDefaultGlobalPermission(struct soap *soap, const struct fireman__setDefaultGlobalPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setDefaultGlobalPermission);
	if (soap_out_fireman__setDefaultGlobalPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setDefaultGlobalPermission(struct soap *soap, const char *tag, int id, const struct fireman__setDefaultGlobalPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setDefaultGlobalPermission), type);
	soap_out_PointerToglite__Permission(soap, "defaultPermission", -1, &a->_defaultPermission, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setDefaultGlobalPermission * SOAP_FMAC4 soap_get_fireman__setDefaultGlobalPermission(struct soap *soap, struct fireman__setDefaultGlobalPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setDefaultGlobalPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setDefaultGlobalPermission * SOAP_FMAC4 soap_in_fireman__setDefaultGlobalPermission(struct soap *soap, const char *tag, struct fireman__setDefaultGlobalPermission *a, const char *type)
{
	short soap_flag__defaultPermission = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setDefaultGlobalPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setDefaultGlobalPermission, sizeof(struct fireman__setDefaultGlobalPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setDefaultGlobalPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__defaultPermission && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, NULL, &a->_defaultPermission, "glite:Permission"))
				{	soap_flag__defaultPermission--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setDefaultGlobalPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setDefaultGlobalPermission, 0, sizeof(struct fireman__setDefaultGlobalPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setDefaultGlobalPermission * SOAP_FMAC6 soap_new_fireman__setDefaultGlobalPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__setDefaultGlobalPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setDefaultGlobalPermission(struct soap *soap, struct fireman__setDefaultGlobalPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setDefaultGlobalPermission * SOAP_FMAC4 soap_instantiate_fireman__setDefaultGlobalPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setDefaultGlobalPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setDefaultGlobalPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setDefaultGlobalPermission;
		if (size)
			*size = sizeof(struct fireman__setDefaultGlobalPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setDefaultGlobalPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__setDefaultGlobalPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setDefaultGlobalPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setDefaultGlobalPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setDefaultGlobalPermission %p -> %p\n", q, p));
	*(struct fireman__setDefaultGlobalPermission*)p = *(struct fireman__setDefaultGlobalPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, const struct fireman__setDefaultGlobalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, struct fireman__setDefaultGlobalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, const struct fireman__setDefaultGlobalPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse);
	if (soap_out_fireman__setDefaultGlobalPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__setDefaultGlobalPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setDefaultGlobalPermissionResponse * SOAP_FMAC4 soap_get_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, struct fireman__setDefaultGlobalPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setDefaultGlobalPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setDefaultGlobalPermissionResponse * SOAP_FMAC4 soap_in_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, const char *tag, struct fireman__setDefaultGlobalPermissionResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setDefaultGlobalPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse, sizeof(struct fireman__setDefaultGlobalPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setDefaultGlobalPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setDefaultGlobalPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse, 0, sizeof(struct fireman__setDefaultGlobalPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setDefaultGlobalPermissionResponse * SOAP_FMAC6 soap_new_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__setDefaultGlobalPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, struct fireman__setDefaultGlobalPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setDefaultGlobalPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setDefaultGlobalPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setDefaultGlobalPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setDefaultGlobalPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__setDefaultGlobalPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setDefaultGlobalPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__setDefaultGlobalPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setDefaultGlobalPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setDefaultGlobalPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setDefaultGlobalPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__setDefaultGlobalPermissionResponse*)p = *(struct fireman__setDefaultGlobalPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setDefaultPrincipalPermission(struct soap *soap, const struct fireman__setDefaultPrincipalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_principal);
	soap_serialize_PointerToglite__Permission(soap, &a->_defaultPermission);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setDefaultPrincipalPermission(struct soap *soap, struct fireman__setDefaultPrincipalPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_principal);
	a->_defaultPermission = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setDefaultPrincipalPermission(struct soap *soap, const struct fireman__setDefaultPrincipalPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setDefaultPrincipalPermission);
	if (soap_out_fireman__setDefaultPrincipalPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setDefaultPrincipalPermission(struct soap *soap, const char *tag, int id, const struct fireman__setDefaultPrincipalPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setDefaultPrincipalPermission), type);
	soap_out_string(soap, "principal", -1, &a->_principal, "");
	soap_out_PointerToglite__Permission(soap, "defaultPermission", -1, &a->_defaultPermission, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setDefaultPrincipalPermission * SOAP_FMAC4 soap_get_fireman__setDefaultPrincipalPermission(struct soap *soap, struct fireman__setDefaultPrincipalPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setDefaultPrincipalPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setDefaultPrincipalPermission * SOAP_FMAC4 soap_in_fireman__setDefaultPrincipalPermission(struct soap *soap, const char *tag, struct fireman__setDefaultPrincipalPermission *a, const char *type)
{
	short soap_flag__principal = 1, soap_flag__defaultPermission = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setDefaultPrincipalPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setDefaultPrincipalPermission, sizeof(struct fireman__setDefaultPrincipalPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setDefaultPrincipalPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__principal && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_principal, "xsd:string"))
				{	soap_flag__principal--;
					continue;
				}
			if (soap_flag__defaultPermission && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Permission(soap, NULL, &a->_defaultPermission, "glite:Permission"))
				{	soap_flag__defaultPermission--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setDefaultPrincipalPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setDefaultPrincipalPermission, 0, sizeof(struct fireman__setDefaultPrincipalPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setDefaultPrincipalPermission * SOAP_FMAC6 soap_new_fireman__setDefaultPrincipalPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__setDefaultPrincipalPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setDefaultPrincipalPermission(struct soap *soap, struct fireman__setDefaultPrincipalPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setDefaultPrincipalPermission * SOAP_FMAC4 soap_instantiate_fireman__setDefaultPrincipalPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setDefaultPrincipalPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setDefaultPrincipalPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setDefaultPrincipalPermission;
		if (size)
			*size = sizeof(struct fireman__setDefaultPrincipalPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setDefaultPrincipalPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__setDefaultPrincipalPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setDefaultPrincipalPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setDefaultPrincipalPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setDefaultPrincipalPermission %p -> %p\n", q, p));
	*(struct fireman__setDefaultPrincipalPermission*)p = *(struct fireman__setDefaultPrincipalPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, const struct fireman__setDefaultPrincipalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, struct fireman__setDefaultPrincipalPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, const struct fireman__setDefaultPrincipalPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse);
	if (soap_out_fireman__setDefaultPrincipalPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__setDefaultPrincipalPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setDefaultPrincipalPermissionResponse * SOAP_FMAC4 soap_get_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, struct fireman__setDefaultPrincipalPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setDefaultPrincipalPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setDefaultPrincipalPermissionResponse * SOAP_FMAC4 soap_in_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, const char *tag, struct fireman__setDefaultPrincipalPermissionResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setDefaultPrincipalPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse, sizeof(struct fireman__setDefaultPrincipalPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setDefaultPrincipalPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setDefaultPrincipalPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse, 0, sizeof(struct fireman__setDefaultPrincipalPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setDefaultPrincipalPermissionResponse * SOAP_FMAC6 soap_new_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__setDefaultPrincipalPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, struct fireman__setDefaultPrincipalPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setDefaultPrincipalPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setDefaultPrincipalPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setDefaultPrincipalPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setDefaultPrincipalPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__setDefaultPrincipalPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setDefaultPrincipalPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__setDefaultPrincipalPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setDefaultPrincipalPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setDefaultPrincipalPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setDefaultPrincipalPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__setDefaultPrincipalPermissionResponse*)p = *(struct fireman__setDefaultPrincipalPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeGuid(struct soap *soap, const struct fireman__removeGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeGuid(struct soap *soap, struct fireman__removeGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeGuid(struct soap *soap, const struct fireman__removeGuid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeGuid);
	if (soap_out_fireman__removeGuid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeGuid(struct soap *soap, const char *tag, int id, const struct fireman__removeGuid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeGuid), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeGuid * SOAP_FMAC4 soap_get_fireman__removeGuid(struct soap *soap, struct fireman__removeGuid *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeGuid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeGuid * SOAP_FMAC4 soap_in_fireman__removeGuid(struct soap *soap, const char *tag, struct fireman__removeGuid *a, const char *type)
{
	short soap_flag__guids = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeGuid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeGuid, sizeof(struct fireman__removeGuid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeGuid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeGuid *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeGuid, 0, sizeof(struct fireman__removeGuid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeGuid * SOAP_FMAC6 soap_new_fireman__removeGuid(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeGuid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeGuid(struct soap *soap, struct fireman__removeGuid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeGuid * SOAP_FMAC4 soap_instantiate_fireman__removeGuid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeGuid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeGuid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeGuid;
		if (size)
			*size = sizeof(struct fireman__removeGuid);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeGuid[n];
		if (size)
			*size = n * sizeof(struct fireman__removeGuid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeGuid*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeGuid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeGuid %p -> %p\n", q, p));
	*(struct fireman__removeGuid*)p = *(struct fireman__removeGuid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeGuidResponse(struct soap *soap, const struct fireman__removeGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeGuidResponse(struct soap *soap, struct fireman__removeGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeGuidResponse(struct soap *soap, const struct fireman__removeGuidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeGuidResponse);
	if (soap_out_fireman__removeGuidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeGuidResponse(struct soap *soap, const char *tag, int id, const struct fireman__removeGuidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeGuidResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeGuidResponse * SOAP_FMAC4 soap_get_fireman__removeGuidResponse(struct soap *soap, struct fireman__removeGuidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeGuidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeGuidResponse * SOAP_FMAC4 soap_in_fireman__removeGuidResponse(struct soap *soap, const char *tag, struct fireman__removeGuidResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeGuidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeGuidResponse, sizeof(struct fireman__removeGuidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeGuidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeGuidResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeGuidResponse, 0, sizeof(struct fireman__removeGuidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeGuidResponse * SOAP_FMAC6 soap_new_fireman__removeGuidResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeGuidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeGuidResponse(struct soap *soap, struct fireman__removeGuidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeGuidResponse * SOAP_FMAC4 soap_instantiate_fireman__removeGuidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeGuidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeGuidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeGuidResponse;
		if (size)
			*size = sizeof(struct fireman__removeGuidResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeGuidResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__removeGuidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeGuidResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeGuidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeGuidResponse %p -> %p\n", q, p));
	*(struct fireman__removeGuidResponse*)p = *(struct fireman__removeGuidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeGuidReplica(struct soap *soap, const struct fireman__removeGuidReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_guidSurls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeGuidReplica(struct soap *soap, struct fireman__removeGuidReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guidSurls = NULL;
	soap_default_bool(soap, &a->_removeGuidOnLastReplica);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeGuidReplica(struct soap *soap, const struct fireman__removeGuidReplica *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeGuidReplica);
	if (soap_out_fireman__removeGuidReplica(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeGuidReplica(struct soap *soap, const char *tag, int id, const struct fireman__removeGuidReplica *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeGuidReplica), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "guidSurls", -1, &a->_guidSurls, "");
	soap_out_bool(soap, "removeGuidOnLastReplica", -1, &a->_removeGuidOnLastReplica, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeGuidReplica * SOAP_FMAC4 soap_get_fireman__removeGuidReplica(struct soap *soap, struct fireman__removeGuidReplica *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeGuidReplica(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeGuidReplica * SOAP_FMAC4 soap_in_fireman__removeGuidReplica(struct soap *soap, const char *tag, struct fireman__removeGuidReplica *a, const char *type)
{
	short soap_flag__guidSurls = 1, soap_flag__removeGuidOnLastReplica = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeGuidReplica *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeGuidReplica, sizeof(struct fireman__removeGuidReplica), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeGuidReplica(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guidSurls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_guidSurls, "glite:StringPair"))
				{	soap_flag__guidSurls--;
					continue;
				}
			if (soap_flag__removeGuidOnLastReplica && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_removeGuidOnLastReplica, "xsd:boolean"))
				{	soap_flag__removeGuidOnLastReplica--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__removeGuidOnLastReplica > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeGuidReplica *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeGuidReplica, 0, sizeof(struct fireman__removeGuidReplica), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeGuidReplica * SOAP_FMAC6 soap_new_fireman__removeGuidReplica(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeGuidReplica(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeGuidReplica(struct soap *soap, struct fireman__removeGuidReplica *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeGuidReplica * SOAP_FMAC4 soap_instantiate_fireman__removeGuidReplica(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeGuidReplica(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeGuidReplica, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeGuidReplica;
		if (size)
			*size = sizeof(struct fireman__removeGuidReplica);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeGuidReplica[n];
		if (size)
			*size = n * sizeof(struct fireman__removeGuidReplica);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeGuidReplica*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeGuidReplica(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeGuidReplica %p -> %p\n", q, p));
	*(struct fireman__removeGuidReplica*)p = *(struct fireman__removeGuidReplica*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeGuidReplicaResponse(struct soap *soap, const struct fireman__removeGuidReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeGuidReplicaResponse(struct soap *soap, struct fireman__removeGuidReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeGuidReplicaResponse(struct soap *soap, const struct fireman__removeGuidReplicaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeGuidReplicaResponse);
	if (soap_out_fireman__removeGuidReplicaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeGuidReplicaResponse(struct soap *soap, const char *tag, int id, const struct fireman__removeGuidReplicaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeGuidReplicaResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeGuidReplicaResponse * SOAP_FMAC4 soap_get_fireman__removeGuidReplicaResponse(struct soap *soap, struct fireman__removeGuidReplicaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeGuidReplicaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeGuidReplicaResponse * SOAP_FMAC4 soap_in_fireman__removeGuidReplicaResponse(struct soap *soap, const char *tag, struct fireman__removeGuidReplicaResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeGuidReplicaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeGuidReplicaResponse, sizeof(struct fireman__removeGuidReplicaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeGuidReplicaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeGuidReplicaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeGuidReplicaResponse, 0, sizeof(struct fireman__removeGuidReplicaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeGuidReplicaResponse * SOAP_FMAC6 soap_new_fireman__removeGuidReplicaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeGuidReplicaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeGuidReplicaResponse(struct soap *soap, struct fireman__removeGuidReplicaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeGuidReplicaResponse * SOAP_FMAC4 soap_instantiate_fireman__removeGuidReplicaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeGuidReplicaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeGuidReplicaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeGuidReplicaResponse;
		if (size)
			*size = sizeof(struct fireman__removeGuidReplicaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeGuidReplicaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__removeGuidReplicaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeGuidReplicaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeGuidReplicaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeGuidReplicaResponse %p -> %p\n", q, p));
	*(struct fireman__removeGuidReplicaResponse*)p = *(struct fireman__removeGuidReplicaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setMasterReplica(struct soap *soap, const struct fireman__setMasterReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_guidSurls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setMasterReplica(struct soap *soap, struct fireman__setMasterReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guidSurls = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setMasterReplica(struct soap *soap, const struct fireman__setMasterReplica *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setMasterReplica);
	if (soap_out_fireman__setMasterReplica(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setMasterReplica(struct soap *soap, const char *tag, int id, const struct fireman__setMasterReplica *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setMasterReplica), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "guidSurls", -1, &a->_guidSurls, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setMasterReplica * SOAP_FMAC4 soap_get_fireman__setMasterReplica(struct soap *soap, struct fireman__setMasterReplica *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setMasterReplica(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setMasterReplica * SOAP_FMAC4 soap_in_fireman__setMasterReplica(struct soap *soap, const char *tag, struct fireman__setMasterReplica *a, const char *type)
{
	short soap_flag__guidSurls = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setMasterReplica *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setMasterReplica, sizeof(struct fireman__setMasterReplica), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setMasterReplica(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guidSurls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_guidSurls, "glite:StringPair"))
				{	soap_flag__guidSurls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setMasterReplica *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setMasterReplica, 0, sizeof(struct fireman__setMasterReplica), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setMasterReplica * SOAP_FMAC6 soap_new_fireman__setMasterReplica(struct soap *soap, int n)
{	return soap_instantiate_fireman__setMasterReplica(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setMasterReplica(struct soap *soap, struct fireman__setMasterReplica *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setMasterReplica * SOAP_FMAC4 soap_instantiate_fireman__setMasterReplica(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setMasterReplica(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setMasterReplica, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setMasterReplica;
		if (size)
			*size = sizeof(struct fireman__setMasterReplica);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setMasterReplica[n];
		if (size)
			*size = n * sizeof(struct fireman__setMasterReplica);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setMasterReplica*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setMasterReplica(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setMasterReplica %p -> %p\n", q, p));
	*(struct fireman__setMasterReplica*)p = *(struct fireman__setMasterReplica*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setMasterReplicaResponse(struct soap *soap, const struct fireman__setMasterReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setMasterReplicaResponse(struct soap *soap, struct fireman__setMasterReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setMasterReplicaResponse(struct soap *soap, const struct fireman__setMasterReplicaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setMasterReplicaResponse);
	if (soap_out_fireman__setMasterReplicaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setMasterReplicaResponse(struct soap *soap, const char *tag, int id, const struct fireman__setMasterReplicaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setMasterReplicaResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setMasterReplicaResponse * SOAP_FMAC4 soap_get_fireman__setMasterReplicaResponse(struct soap *soap, struct fireman__setMasterReplicaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setMasterReplicaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setMasterReplicaResponse * SOAP_FMAC4 soap_in_fireman__setMasterReplicaResponse(struct soap *soap, const char *tag, struct fireman__setMasterReplicaResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setMasterReplicaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setMasterReplicaResponse, sizeof(struct fireman__setMasterReplicaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setMasterReplicaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setMasterReplicaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setMasterReplicaResponse, 0, sizeof(struct fireman__setMasterReplicaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setMasterReplicaResponse * SOAP_FMAC6 soap_new_fireman__setMasterReplicaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__setMasterReplicaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setMasterReplicaResponse(struct soap *soap, struct fireman__setMasterReplicaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setMasterReplicaResponse * SOAP_FMAC4 soap_instantiate_fireman__setMasterReplicaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setMasterReplicaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setMasterReplicaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setMasterReplicaResponse;
		if (size)
			*size = sizeof(struct fireman__setMasterReplicaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setMasterReplicaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__setMasterReplicaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setMasterReplicaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setMasterReplicaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setMasterReplicaResponse %p -> %p\n", q, p));
	*(struct fireman__setMasterReplicaResponse*)p = *(struct fireman__setMasterReplicaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateSurlStat(struct soap *soap, const struct fireman__updateSurlStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_guid);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, &a->_surlStats);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateSurlStat(struct soap *soap, struct fireman__updateSurlStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_guid);
	a->_surlStats = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateSurlStat(struct soap *soap, const struct fireman__updateSurlStat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateSurlStat);
	if (soap_out_fireman__updateSurlStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateSurlStat(struct soap *soap, const char *tag, int id, const struct fireman__updateSurlStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateSurlStat), type);
	soap_out_string(soap, "guid", -1, &a->_guid, "");
	soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, "surlStats", -1, &a->_surlStats, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateSurlStat * SOAP_FMAC4 soap_get_fireman__updateSurlStat(struct soap *soap, struct fireman__updateSurlStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateSurlStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateSurlStat * SOAP_FMAC4 soap_in_fireman__updateSurlStat(struct soap *soap, const char *tag, struct fireman__updateSurlStat *a, const char *type)
{
	short soap_flag__guid = 1, soap_flag__surlStats = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateSurlStat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateSurlStat, sizeof(struct fireman__updateSurlStat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateSurlStat(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guid && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_guid, "xsd:string"))
				{	soap_flag__guid--;
					continue;
				}
			if (soap_flag__surlStats && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, &a->_surlStats, "glite:SURLEntry"))
				{	soap_flag__surlStats--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateSurlStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateSurlStat, 0, sizeof(struct fireman__updateSurlStat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateSurlStat * SOAP_FMAC6 soap_new_fireman__updateSurlStat(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateSurlStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateSurlStat(struct soap *soap, struct fireman__updateSurlStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateSurlStat * SOAP_FMAC4 soap_instantiate_fireman__updateSurlStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateSurlStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateSurlStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateSurlStat;
		if (size)
			*size = sizeof(struct fireman__updateSurlStat);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateSurlStat[n];
		if (size)
			*size = n * sizeof(struct fireman__updateSurlStat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateSurlStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateSurlStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateSurlStat %p -> %p\n", q, p));
	*(struct fireman__updateSurlStat*)p = *(struct fireman__updateSurlStat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateSurlStatResponse(struct soap *soap, const struct fireman__updateSurlStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateSurlStatResponse(struct soap *soap, struct fireman__updateSurlStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateSurlStatResponse(struct soap *soap, const struct fireman__updateSurlStatResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateSurlStatResponse);
	if (soap_out_fireman__updateSurlStatResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateSurlStatResponse(struct soap *soap, const char *tag, int id, const struct fireman__updateSurlStatResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateSurlStatResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateSurlStatResponse * SOAP_FMAC4 soap_get_fireman__updateSurlStatResponse(struct soap *soap, struct fireman__updateSurlStatResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateSurlStatResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateSurlStatResponse * SOAP_FMAC4 soap_in_fireman__updateSurlStatResponse(struct soap *soap, const char *tag, struct fireman__updateSurlStatResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateSurlStatResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateSurlStatResponse, sizeof(struct fireman__updateSurlStatResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateSurlStatResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateSurlStatResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateSurlStatResponse, 0, sizeof(struct fireman__updateSurlStatResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateSurlStatResponse * SOAP_FMAC6 soap_new_fireman__updateSurlStatResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateSurlStatResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateSurlStatResponse(struct soap *soap, struct fireman__updateSurlStatResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateSurlStatResponse * SOAP_FMAC4 soap_instantiate_fireman__updateSurlStatResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateSurlStatResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateSurlStatResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateSurlStatResponse;
		if (size)
			*size = sizeof(struct fireman__updateSurlStatResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateSurlStatResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__updateSurlStatResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateSurlStatResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateSurlStatResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateSurlStatResponse %p -> %p\n", q, p));
	*(struct fireman__updateSurlStatResponse*)p = *(struct fireman__updateSurlStatResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateGuidStat(struct soap *soap, const struct fireman__updateGuidStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, &a->_stats);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateGuidStat(struct soap *soap, struct fireman__updateGuidStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
	a->_stats = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateGuidStat(struct soap *soap, const struct fireman__updateGuidStat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateGuidStat);
	if (soap_out_fireman__updateGuidStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateGuidStat(struct soap *soap, const char *tag, int id, const struct fireman__updateGuidStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateGuidStat), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, "stats", -1, &a->_stats, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateGuidStat * SOAP_FMAC4 soap_get_fireman__updateGuidStat(struct soap *soap, struct fireman__updateGuidStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateGuidStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateGuidStat * SOAP_FMAC4 soap_in_fireman__updateGuidStat(struct soap *soap, const char *tag, struct fireman__updateGuidStat *a, const char *type)
{
	short soap_flag__guids = 1, soap_flag__stats = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateGuidStat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateGuidStat, sizeof(struct fireman__updateGuidStat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateGuidStat(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap_flag__stats && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, NULL, &a->_stats, "glite:GUIDStat"))
				{	soap_flag__stats--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateGuidStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateGuidStat, 0, sizeof(struct fireman__updateGuidStat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateGuidStat * SOAP_FMAC6 soap_new_fireman__updateGuidStat(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateGuidStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateGuidStat(struct soap *soap, struct fireman__updateGuidStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateGuidStat * SOAP_FMAC4 soap_instantiate_fireman__updateGuidStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateGuidStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateGuidStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateGuidStat;
		if (size)
			*size = sizeof(struct fireman__updateGuidStat);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateGuidStat[n];
		if (size)
			*size = n * sizeof(struct fireman__updateGuidStat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateGuidStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateGuidStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateGuidStat %p -> %p\n", q, p));
	*(struct fireman__updateGuidStat*)p = *(struct fireman__updateGuidStat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateGuidStatResponse(struct soap *soap, const struct fireman__updateGuidStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateGuidStatResponse(struct soap *soap, struct fireman__updateGuidStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateGuidStatResponse(struct soap *soap, const struct fireman__updateGuidStatResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateGuidStatResponse);
	if (soap_out_fireman__updateGuidStatResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateGuidStatResponse(struct soap *soap, const char *tag, int id, const struct fireman__updateGuidStatResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateGuidStatResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateGuidStatResponse * SOAP_FMAC4 soap_get_fireman__updateGuidStatResponse(struct soap *soap, struct fireman__updateGuidStatResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateGuidStatResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateGuidStatResponse * SOAP_FMAC4 soap_in_fireman__updateGuidStatResponse(struct soap *soap, const char *tag, struct fireman__updateGuidStatResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateGuidStatResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateGuidStatResponse, sizeof(struct fireman__updateGuidStatResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateGuidStatResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateGuidStatResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateGuidStatResponse, 0, sizeof(struct fireman__updateGuidStatResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateGuidStatResponse * SOAP_FMAC6 soap_new_fireman__updateGuidStatResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateGuidStatResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateGuidStatResponse(struct soap *soap, struct fireman__updateGuidStatResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateGuidStatResponse * SOAP_FMAC4 soap_instantiate_fireman__updateGuidStatResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateGuidStatResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateGuidStatResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateGuidStatResponse;
		if (size)
			*size = sizeof(struct fireman__updateGuidStatResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateGuidStatResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__updateGuidStatResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateGuidStatResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateGuidStatResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateGuidStatResponse %p -> %p\n", q, p));
	*(struct fireman__updateGuidStatResponse*)p = *(struct fireman__updateGuidStatResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__addGuidReplica(struct soap *soap, const struct fireman__addGuidReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_guid);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, &a->_newSurls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__addGuidReplica(struct soap *soap, struct fireman__addGuidReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_guid);
	a->_newSurls = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__addGuidReplica(struct soap *soap, const struct fireman__addGuidReplica *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__addGuidReplica);
	if (soap_out_fireman__addGuidReplica(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__addGuidReplica(struct soap *soap, const char *tag, int id, const struct fireman__addGuidReplica *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__addGuidReplica), type);
	soap_out_string(soap, "guid", -1, &a->_guid, "");
	soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, "newSurls", -1, &a->_newSurls, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__addGuidReplica * SOAP_FMAC4 soap_get_fireman__addGuidReplica(struct soap *soap, struct fireman__addGuidReplica *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__addGuidReplica(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__addGuidReplica * SOAP_FMAC4 soap_in_fireman__addGuidReplica(struct soap *soap, const char *tag, struct fireman__addGuidReplica *a, const char *type)
{
	short soap_flag__guid = 1, soap_flag__newSurls = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__addGuidReplica *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__addGuidReplica, sizeof(struct fireman__addGuidReplica), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__addGuidReplica(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guid && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_guid, "xsd:string"))
				{	soap_flag__guid--;
					continue;
				}
			if (soap_flag__newSurls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, &a->_newSurls, "glite:SURLEntry"))
				{	soap_flag__newSurls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__addGuidReplica *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__addGuidReplica, 0, sizeof(struct fireman__addGuidReplica), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__addGuidReplica * SOAP_FMAC6 soap_new_fireman__addGuidReplica(struct soap *soap, int n)
{	return soap_instantiate_fireman__addGuidReplica(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__addGuidReplica(struct soap *soap, struct fireman__addGuidReplica *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__addGuidReplica * SOAP_FMAC4 soap_instantiate_fireman__addGuidReplica(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__addGuidReplica(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__addGuidReplica, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__addGuidReplica;
		if (size)
			*size = sizeof(struct fireman__addGuidReplica);
	}
	else
	{	cp->ptr = (void*)new struct fireman__addGuidReplica[n];
		if (size)
			*size = n * sizeof(struct fireman__addGuidReplica);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__addGuidReplica*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__addGuidReplica(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__addGuidReplica %p -> %p\n", q, p));
	*(struct fireman__addGuidReplica*)p = *(struct fireman__addGuidReplica*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__addGuidReplicaResponse(struct soap *soap, const struct fireman__addGuidReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__addGuidReplicaResponse(struct soap *soap, struct fireman__addGuidReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__addGuidReplicaResponse(struct soap *soap, const struct fireman__addGuidReplicaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__addGuidReplicaResponse);
	if (soap_out_fireman__addGuidReplicaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__addGuidReplicaResponse(struct soap *soap, const char *tag, int id, const struct fireman__addGuidReplicaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__addGuidReplicaResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__addGuidReplicaResponse * SOAP_FMAC4 soap_get_fireman__addGuidReplicaResponse(struct soap *soap, struct fireman__addGuidReplicaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__addGuidReplicaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__addGuidReplicaResponse * SOAP_FMAC4 soap_in_fireman__addGuidReplicaResponse(struct soap *soap, const char *tag, struct fireman__addGuidReplicaResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__addGuidReplicaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__addGuidReplicaResponse, sizeof(struct fireman__addGuidReplicaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__addGuidReplicaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__addGuidReplicaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__addGuidReplicaResponse, 0, sizeof(struct fireman__addGuidReplicaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__addGuidReplicaResponse * SOAP_FMAC6 soap_new_fireman__addGuidReplicaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__addGuidReplicaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__addGuidReplicaResponse(struct soap *soap, struct fireman__addGuidReplicaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__addGuidReplicaResponse * SOAP_FMAC4 soap_instantiate_fireman__addGuidReplicaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__addGuidReplicaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__addGuidReplicaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__addGuidReplicaResponse;
		if (size)
			*size = sizeof(struct fireman__addGuidReplicaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__addGuidReplicaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__addGuidReplicaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__addGuidReplicaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__addGuidReplicaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__addGuidReplicaResponse %p -> %p\n", q, p));
	*(struct fireman__addGuidReplicaResponse*)p = *(struct fireman__addGuidReplicaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__createGuid(struct soap *soap, const struct fireman__createGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, &a->_entries);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__createGuid(struct soap *soap, struct fireman__createGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_entries = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__createGuid(struct soap *soap, const struct fireman__createGuid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__createGuid);
	if (soap_out_fireman__createGuid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__createGuid(struct soap *soap, const char *tag, int id, const struct fireman__createGuid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__createGuid), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, "entries", -1, &a->_entries, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__createGuid * SOAP_FMAC4 soap_get_fireman__createGuid(struct soap *soap, struct fireman__createGuid *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__createGuid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__createGuid * SOAP_FMAC4 soap_in_fireman__createGuid(struct soap *soap, const char *tag, struct fireman__createGuid *a, const char *type)
{
	short soap_flag__entries = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__createGuid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__createGuid, sizeof(struct fireman__createGuid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__createGuid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__entries && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, NULL, &a->_entries, "glite:RCEntry"))
				{	soap_flag__entries--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__createGuid *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__createGuid, 0, sizeof(struct fireman__createGuid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__createGuid * SOAP_FMAC6 soap_new_fireman__createGuid(struct soap *soap, int n)
{	return soap_instantiate_fireman__createGuid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__createGuid(struct soap *soap, struct fireman__createGuid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__createGuid * SOAP_FMAC4 soap_instantiate_fireman__createGuid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__createGuid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__createGuid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__createGuid;
		if (size)
			*size = sizeof(struct fireman__createGuid);
	}
	else
	{	cp->ptr = (void*)new struct fireman__createGuid[n];
		if (size)
			*size = n * sizeof(struct fireman__createGuid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__createGuid*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__createGuid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__createGuid %p -> %p\n", q, p));
	*(struct fireman__createGuid*)p = *(struct fireman__createGuid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__createGuidResponse(struct soap *soap, const struct fireman__createGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__createGuidResponse(struct soap *soap, struct fireman__createGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__createGuidResponse(struct soap *soap, const struct fireman__createGuidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__createGuidResponse);
	if (soap_out_fireman__createGuidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__createGuidResponse(struct soap *soap, const char *tag, int id, const struct fireman__createGuidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__createGuidResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__createGuidResponse * SOAP_FMAC4 soap_get_fireman__createGuidResponse(struct soap *soap, struct fireman__createGuidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__createGuidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__createGuidResponse * SOAP_FMAC4 soap_in_fireman__createGuidResponse(struct soap *soap, const char *tag, struct fireman__createGuidResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__createGuidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__createGuidResponse, sizeof(struct fireman__createGuidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__createGuidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__createGuidResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__createGuidResponse, 0, sizeof(struct fireman__createGuidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__createGuidResponse * SOAP_FMAC6 soap_new_fireman__createGuidResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__createGuidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__createGuidResponse(struct soap *soap, struct fireman__createGuidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__createGuidResponse * SOAP_FMAC4 soap_instantiate_fireman__createGuidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__createGuidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__createGuidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__createGuidResponse;
		if (size)
			*size = sizeof(struct fireman__createGuidResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__createGuidResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__createGuidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__createGuidResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__createGuidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__createGuidResponse %p -> %p\n", q, p));
	*(struct fireman__createGuidResponse*)p = *(struct fireman__createGuidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateStatus(struct soap *soap, const struct fireman__updateStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateStatus(struct soap *soap, struct fireman__updateStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
	soap_default_int(soap, &a->_status);
	soap_default_int(soap, &a->_mask);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateStatus(struct soap *soap, const struct fireman__updateStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateStatus);
	if (soap_out_fireman__updateStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateStatus(struct soap *soap, const char *tag, int id, const struct fireman__updateStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateStatus), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_out_int(soap, "status", -1, &a->_status, "");
	soap_out_int(soap, "mask", -1, &a->_mask, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateStatus * SOAP_FMAC4 soap_get_fireman__updateStatus(struct soap *soap, struct fireman__updateStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateStatus * SOAP_FMAC4 soap_in_fireman__updateStatus(struct soap *soap, const char *tag, struct fireman__updateStatus *a, const char *type)
{
	short soap_flag__guids = 1, soap_flag__status = 1, soap_flag__mask = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateStatus, sizeof(struct fireman__updateStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap_flag__status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_status, "xsd:int"))
				{	soap_flag__status--;
					continue;
				}
			if (soap_flag__mask && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_mask, "xsd:int"))
				{	soap_flag__mask--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__status > 0 || soap_flag__mask > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateStatus, 0, sizeof(struct fireman__updateStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateStatus * SOAP_FMAC6 soap_new_fireman__updateStatus(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateStatus(struct soap *soap, struct fireman__updateStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateStatus * SOAP_FMAC4 soap_instantiate_fireman__updateStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateStatus;
		if (size)
			*size = sizeof(struct fireman__updateStatus);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateStatus[n];
		if (size)
			*size = n * sizeof(struct fireman__updateStatus);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateStatus %p -> %p\n", q, p));
	*(struct fireman__updateStatus*)p = *(struct fireman__updateStatus*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateStatusResponse(struct soap *soap, const struct fireman__updateStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateStatusResponse(struct soap *soap, struct fireman__updateStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateStatusResponse(struct soap *soap, const struct fireman__updateStatusResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateStatusResponse);
	if (soap_out_fireman__updateStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateStatusResponse(struct soap *soap, const char *tag, int id, const struct fireman__updateStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateStatusResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateStatusResponse * SOAP_FMAC4 soap_get_fireman__updateStatusResponse(struct soap *soap, struct fireman__updateStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateStatusResponse * SOAP_FMAC4 soap_in_fireman__updateStatusResponse(struct soap *soap, const char *tag, struct fireman__updateStatusResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateStatusResponse, sizeof(struct fireman__updateStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateStatusResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateStatusResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateStatusResponse, 0, sizeof(struct fireman__updateStatusResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateStatusResponse * SOAP_FMAC6 soap_new_fireman__updateStatusResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateStatusResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateStatusResponse(struct soap *soap, struct fireman__updateStatusResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateStatusResponse * SOAP_FMAC4 soap_instantiate_fireman__updateStatusResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateStatusResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateStatusResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateStatusResponse;
		if (size)
			*size = sizeof(struct fireman__updateStatusResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateStatusResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__updateStatusResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateStatusResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateStatusResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateStatusResponse %p -> %p\n", q, p));
	*(struct fireman__updateStatusResponse*)p = *(struct fireman__updateStatusResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listAttributes(struct soap *soap, const struct fireman__listAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listAttributes(struct soap *soap, struct fireman__listAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listAttributes(struct soap *soap, const struct fireman__listAttributes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listAttributes);
	if (soap_out_fireman__listAttributes(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listAttributes(struct soap *soap, const char *tag, int id, const struct fireman__listAttributes *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listAttributes), type);
	soap_out_string(soap, "item", -1, &a->_item, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listAttributes * SOAP_FMAC4 soap_get_fireman__listAttributes(struct soap *soap, struct fireman__listAttributes *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listAttributes(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listAttributes * SOAP_FMAC4 soap_in_fireman__listAttributes(struct soap *soap, const char *tag, struct fireman__listAttributes *a, const char *type)
{
	short soap_flag__item = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listAttributes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listAttributes, sizeof(struct fireman__listAttributes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listAttributes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__item && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_item, "xsd:string"))
				{	soap_flag__item--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listAttributes *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listAttributes, 0, sizeof(struct fireman__listAttributes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listAttributes * SOAP_FMAC6 soap_new_fireman__listAttributes(struct soap *soap, int n)
{	return soap_instantiate_fireman__listAttributes(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listAttributes(struct soap *soap, struct fireman__listAttributes *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listAttributes * SOAP_FMAC4 soap_instantiate_fireman__listAttributes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listAttributes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listAttributes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listAttributes;
		if (size)
			*size = sizeof(struct fireman__listAttributes);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listAttributes[n];
		if (size)
			*size = n * sizeof(struct fireman__listAttributes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listAttributes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listAttributes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listAttributes %p -> %p\n", q, p));
	*(struct fireman__listAttributes*)p = *(struct fireman__listAttributes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listAttributesResponse(struct soap *soap, const struct fireman__listAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, &a->_listAttributesReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listAttributesResponse(struct soap *soap, struct fireman__listAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_listAttributesReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listAttributesResponse(struct soap *soap, const struct fireman__listAttributesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listAttributesResponse);
	if (soap_out_fireman__listAttributesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listAttributesResponse(struct soap *soap, const char *tag, int id, const struct fireman__listAttributesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listAttributesResponse), type);
	if (a->_listAttributesReturn)
		soap_element_result(soap, "listAttributesReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, "listAttributesReturn", -1, &a->_listAttributesReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listAttributesResponse * SOAP_FMAC4 soap_get_fireman__listAttributesResponse(struct soap *soap, struct fireman__listAttributesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listAttributesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listAttributesResponse * SOAP_FMAC4 soap_in_fireman__listAttributesResponse(struct soap *soap, const char *tag, struct fireman__listAttributesResponse *a, const char *type)
{
	short soap_flag__listAttributesReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listAttributesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listAttributesResponse, sizeof(struct fireman__listAttributesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listAttributesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__listAttributesReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, NULL, &a->_listAttributesReturn, "glite:Attribute"))
				{	soap_flag__listAttributesReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listAttributesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listAttributesResponse, 0, sizeof(struct fireman__listAttributesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listAttributesResponse * SOAP_FMAC6 soap_new_fireman__listAttributesResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__listAttributesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listAttributesResponse(struct soap *soap, struct fireman__listAttributesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listAttributesResponse * SOAP_FMAC4 soap_instantiate_fireman__listAttributesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listAttributesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listAttributesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listAttributesResponse;
		if (size)
			*size = sizeof(struct fireman__listAttributesResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listAttributesResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__listAttributesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listAttributesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listAttributesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listAttributesResponse %p -> %p\n", q, p));
	*(struct fireman__listAttributesResponse*)p = *(struct fireman__listAttributesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__clearAttributes(struct soap *soap, const struct fireman__clearAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_item);
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_attributeNames);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__clearAttributes(struct soap *soap, struct fireman__clearAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_item);
	a->_attributeNames = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__clearAttributes(struct soap *soap, const struct fireman__clearAttributes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__clearAttributes);
	if (soap_out_fireman__clearAttributes(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__clearAttributes(struct soap *soap, const char *tag, int id, const struct fireman__clearAttributes *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__clearAttributes), type);
	soap_out_string(soap, "item", -1, &a->_item, "");
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "attributeNames", -1, &a->_attributeNames, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__clearAttributes * SOAP_FMAC4 soap_get_fireman__clearAttributes(struct soap *soap, struct fireman__clearAttributes *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__clearAttributes(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__clearAttributes * SOAP_FMAC4 soap_in_fireman__clearAttributes(struct soap *soap, const char *tag, struct fireman__clearAttributes *a, const char *type)
{
	short soap_flag__item = 1, soap_flag__attributeNames = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__clearAttributes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__clearAttributes, sizeof(struct fireman__clearAttributes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__clearAttributes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__item && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_item, "xsd:string"))
				{	soap_flag__item--;
					continue;
				}
			if (soap_flag__attributeNames && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_attributeNames, "xsd:string"))
				{	soap_flag__attributeNames--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__clearAttributes *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__clearAttributes, 0, sizeof(struct fireman__clearAttributes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__clearAttributes * SOAP_FMAC6 soap_new_fireman__clearAttributes(struct soap *soap, int n)
{	return soap_instantiate_fireman__clearAttributes(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__clearAttributes(struct soap *soap, struct fireman__clearAttributes *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__clearAttributes * SOAP_FMAC4 soap_instantiate_fireman__clearAttributes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__clearAttributes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__clearAttributes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__clearAttributes;
		if (size)
			*size = sizeof(struct fireman__clearAttributes);
	}
	else
	{	cp->ptr = (void*)new struct fireman__clearAttributes[n];
		if (size)
			*size = n * sizeof(struct fireman__clearAttributes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__clearAttributes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__clearAttributes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__clearAttributes %p -> %p\n", q, p));
	*(struct fireman__clearAttributes*)p = *(struct fireman__clearAttributes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__clearAttributesResponse(struct soap *soap, const struct fireman__clearAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__clearAttributesResponse(struct soap *soap, struct fireman__clearAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__clearAttributesResponse(struct soap *soap, const struct fireman__clearAttributesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__clearAttributesResponse);
	if (soap_out_fireman__clearAttributesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__clearAttributesResponse(struct soap *soap, const char *tag, int id, const struct fireman__clearAttributesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__clearAttributesResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__clearAttributesResponse * SOAP_FMAC4 soap_get_fireman__clearAttributesResponse(struct soap *soap, struct fireman__clearAttributesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__clearAttributesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__clearAttributesResponse * SOAP_FMAC4 soap_in_fireman__clearAttributesResponse(struct soap *soap, const char *tag, struct fireman__clearAttributesResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__clearAttributesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__clearAttributesResponse, sizeof(struct fireman__clearAttributesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__clearAttributesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__clearAttributesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__clearAttributesResponse, 0, sizeof(struct fireman__clearAttributesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__clearAttributesResponse * SOAP_FMAC6 soap_new_fireman__clearAttributesResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__clearAttributesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__clearAttributesResponse(struct soap *soap, struct fireman__clearAttributesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__clearAttributesResponse * SOAP_FMAC4 soap_instantiate_fireman__clearAttributesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__clearAttributesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__clearAttributesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__clearAttributesResponse;
		if (size)
			*size = sizeof(struct fireman__clearAttributesResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__clearAttributesResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__clearAttributesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__clearAttributesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__clearAttributesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__clearAttributesResponse %p -> %p\n", q, p));
	*(struct fireman__clearAttributesResponse*)p = *(struct fireman__clearAttributesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setAttributes(struct soap *soap, const struct fireman__setAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_item);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, &a->_attributes);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setAttributes(struct soap *soap, struct fireman__setAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_item);
	a->_attributes = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setAttributes(struct soap *soap, const struct fireman__setAttributes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setAttributes);
	if (soap_out_fireman__setAttributes(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setAttributes(struct soap *soap, const char *tag, int id, const struct fireman__setAttributes *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setAttributes), type);
	soap_out_string(soap, "item", -1, &a->_item, "");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, "attributes", -1, &a->_attributes, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setAttributes * SOAP_FMAC4 soap_get_fireman__setAttributes(struct soap *soap, struct fireman__setAttributes *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setAttributes(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setAttributes * SOAP_FMAC4 soap_in_fireman__setAttributes(struct soap *soap, const char *tag, struct fireman__setAttributes *a, const char *type)
{
	short soap_flag__item = 1, soap_flag__attributes = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setAttributes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setAttributes, sizeof(struct fireman__setAttributes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setAttributes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__item && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_item, "xsd:string"))
				{	soap_flag__item--;
					continue;
				}
			if (soap_flag__attributes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, NULL, &a->_attributes, "glite:Attribute"))
				{	soap_flag__attributes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setAttributes *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setAttributes, 0, sizeof(struct fireman__setAttributes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setAttributes * SOAP_FMAC6 soap_new_fireman__setAttributes(struct soap *soap, int n)
{	return soap_instantiate_fireman__setAttributes(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setAttributes(struct soap *soap, struct fireman__setAttributes *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setAttributes * SOAP_FMAC4 soap_instantiate_fireman__setAttributes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setAttributes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setAttributes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setAttributes;
		if (size)
			*size = sizeof(struct fireman__setAttributes);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setAttributes[n];
		if (size)
			*size = n * sizeof(struct fireman__setAttributes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setAttributes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setAttributes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setAttributes %p -> %p\n", q, p));
	*(struct fireman__setAttributes*)p = *(struct fireman__setAttributes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setAttributesResponse(struct soap *soap, const struct fireman__setAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setAttributesResponse(struct soap *soap, struct fireman__setAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setAttributesResponse(struct soap *soap, const struct fireman__setAttributesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setAttributesResponse);
	if (soap_out_fireman__setAttributesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setAttributesResponse(struct soap *soap, const char *tag, int id, const struct fireman__setAttributesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setAttributesResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setAttributesResponse * SOAP_FMAC4 soap_get_fireman__setAttributesResponse(struct soap *soap, struct fireman__setAttributesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setAttributesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setAttributesResponse * SOAP_FMAC4 soap_in_fireman__setAttributesResponse(struct soap *soap, const char *tag, struct fireman__setAttributesResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setAttributesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setAttributesResponse, sizeof(struct fireman__setAttributesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setAttributesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setAttributesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setAttributesResponse, 0, sizeof(struct fireman__setAttributesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setAttributesResponse * SOAP_FMAC6 soap_new_fireman__setAttributesResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__setAttributesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setAttributesResponse(struct soap *soap, struct fireman__setAttributesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setAttributesResponse * SOAP_FMAC4 soap_instantiate_fireman__setAttributesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setAttributesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setAttributesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setAttributesResponse;
		if (size)
			*size = sizeof(struct fireman__setAttributesResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setAttributesResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__setAttributesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setAttributesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setAttributesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setAttributesResponse %p -> %p\n", q, p));
	*(struct fireman__setAttributesResponse*)p = *(struct fireman__setAttributesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__query(struct soap *soap, const struct fireman__query *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_query);
	soap_serialize_string(soap, &a->_type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__query(struct soap *soap, struct fireman__query *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_query);
	soap_default_string(soap, &a->_type);
	soap_default_int(soap, &a->_limit);
	soap_default_int(soap, &a->_offset);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__query(struct soap *soap, const struct fireman__query *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__query);
	if (soap_out_fireman__query(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__query(struct soap *soap, const char *tag, int id, const struct fireman__query *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__query), type);
	soap_out_string(soap, "query", -1, &a->_query, "");
	soap_out_string(soap, "type", -1, &a->_type, "");
	soap_out_int(soap, "limit", -1, &a->_limit, "");
	soap_out_int(soap, "offset", -1, &a->_offset, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__query * SOAP_FMAC4 soap_get_fireman__query(struct soap *soap, struct fireman__query *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__query(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__query * SOAP_FMAC4 soap_in_fireman__query(struct soap *soap, const char *tag, struct fireman__query *a, const char *type)
{
	short soap_flag__query = 1, soap_flag__type = 1, soap_flag__limit = 1, soap_flag__offset = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__query *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__query, sizeof(struct fireman__query), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__query(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__query && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_query, "xsd:string"))
				{	soap_flag__query--;
					continue;
				}
			if (soap_flag__type && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_type, "xsd:string"))
				{	soap_flag__type--;
					continue;
				}
			if (soap_flag__limit && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_limit, "xsd:int"))
				{	soap_flag__limit--;
					continue;
				}
			if (soap_flag__offset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_offset, "xsd:int"))
				{	soap_flag__offset--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__limit > 0 || soap_flag__offset > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__query *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__query, 0, sizeof(struct fireman__query), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__query * SOAP_FMAC6 soap_new_fireman__query(struct soap *soap, int n)
{	return soap_instantiate_fireman__query(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__query(struct soap *soap, struct fireman__query *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__query * SOAP_FMAC4 soap_instantiate_fireman__query(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__query(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__query, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__query;
		if (size)
			*size = sizeof(struct fireman__query);
	}
	else
	{	cp->ptr = (void*)new struct fireman__query[n];
		if (size)
			*size = n * sizeof(struct fireman__query);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__query*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__query(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__query %p -> %p\n", q, p));
	*(struct fireman__query*)p = *(struct fireman__query*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__queryResponse(struct soap *soap, const struct fireman__queryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_queryReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__queryResponse(struct soap *soap, struct fireman__queryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_queryReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__queryResponse(struct soap *soap, const struct fireman__queryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__queryResponse);
	if (soap_out_fireman__queryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__queryResponse(struct soap *soap, const char *tag, int id, const struct fireman__queryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__queryResponse), type);
	if (a->_queryReturn)
		soap_element_result(soap, "queryReturn");
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "queryReturn", -1, &a->_queryReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__queryResponse * SOAP_FMAC4 soap_get_fireman__queryResponse(struct soap *soap, struct fireman__queryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__queryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__queryResponse * SOAP_FMAC4 soap_in_fireman__queryResponse(struct soap *soap, const char *tag, struct fireman__queryResponse *a, const char *type)
{
	short soap_flag__queryReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__queryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__queryResponse, sizeof(struct fireman__queryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__queryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__queryReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_queryReturn, "xsd:string"))
				{	soap_flag__queryReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__queryResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__queryResponse, 0, sizeof(struct fireman__queryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__queryResponse * SOAP_FMAC6 soap_new_fireman__queryResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__queryResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__queryResponse(struct soap *soap, struct fireman__queryResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__queryResponse * SOAP_FMAC4 soap_instantiate_fireman__queryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__queryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__queryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__queryResponse;
		if (size)
			*size = sizeof(struct fireman__queryResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__queryResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__queryResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__queryResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__queryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__queryResponse %p -> %p\n", q, p));
	*(struct fireman__queryResponse*)p = *(struct fireman__queryResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getAttributes(struct soap *soap, const struct fireman__getAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_item);
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_attributeNames);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getAttributes(struct soap *soap, struct fireman__getAttributes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_item);
	a->_attributeNames = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getAttributes(struct soap *soap, const struct fireman__getAttributes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getAttributes);
	if (soap_out_fireman__getAttributes(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getAttributes(struct soap *soap, const char *tag, int id, const struct fireman__getAttributes *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getAttributes), type);
	soap_out_string(soap, "item", -1, &a->_item, "");
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "attributeNames", -1, &a->_attributeNames, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getAttributes * SOAP_FMAC4 soap_get_fireman__getAttributes(struct soap *soap, struct fireman__getAttributes *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getAttributes(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getAttributes * SOAP_FMAC4 soap_in_fireman__getAttributes(struct soap *soap, const char *tag, struct fireman__getAttributes *a, const char *type)
{
	short soap_flag__item = 1, soap_flag__attributeNames = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getAttributes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getAttributes, sizeof(struct fireman__getAttributes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getAttributes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__item && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_item, "xsd:string"))
				{	soap_flag__item--;
					continue;
				}
			if (soap_flag__attributeNames && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_attributeNames, "xsd:string"))
				{	soap_flag__attributeNames--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getAttributes *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getAttributes, 0, sizeof(struct fireman__getAttributes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getAttributes * SOAP_FMAC6 soap_new_fireman__getAttributes(struct soap *soap, int n)
{	return soap_instantiate_fireman__getAttributes(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getAttributes(struct soap *soap, struct fireman__getAttributes *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getAttributes * SOAP_FMAC4 soap_instantiate_fireman__getAttributes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getAttributes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getAttributes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getAttributes;
		if (size)
			*size = sizeof(struct fireman__getAttributes);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getAttributes[n];
		if (size)
			*size = n * sizeof(struct fireman__getAttributes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getAttributes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getAttributes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getAttributes %p -> %p\n", q, p));
	*(struct fireman__getAttributes*)p = *(struct fireman__getAttributes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getAttributesResponse(struct soap *soap, const struct fireman__getAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, &a->_getAttributesReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getAttributesResponse(struct soap *soap, struct fireman__getAttributesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getAttributesReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getAttributesResponse(struct soap *soap, const struct fireman__getAttributesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getAttributesResponse);
	if (soap_out_fireman__getAttributesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getAttributesResponse(struct soap *soap, const char *tag, int id, const struct fireman__getAttributesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getAttributesResponse), type);
	if (a->_getAttributesReturn)
		soap_element_result(soap, "getAttributesReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, "getAttributesReturn", -1, &a->_getAttributesReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getAttributesResponse * SOAP_FMAC4 soap_get_fireman__getAttributesResponse(struct soap *soap, struct fireman__getAttributesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getAttributesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getAttributesResponse * SOAP_FMAC4 soap_in_fireman__getAttributesResponse(struct soap *soap, const char *tag, struct fireman__getAttributesResponse *a, const char *type)
{
	short soap_flag__getAttributesReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getAttributesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getAttributesResponse, sizeof(struct fireman__getAttributesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getAttributesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getAttributesReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, NULL, &a->_getAttributesReturn, "glite:Attribute"))
				{	soap_flag__getAttributesReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getAttributesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getAttributesResponse, 0, sizeof(struct fireman__getAttributesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getAttributesResponse * SOAP_FMAC6 soap_new_fireman__getAttributesResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getAttributesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getAttributesResponse(struct soap *soap, struct fireman__getAttributesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getAttributesResponse * SOAP_FMAC4 soap_instantiate_fireman__getAttributesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getAttributesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getAttributesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getAttributesResponse;
		if (size)
			*size = sizeof(struct fireman__getAttributesResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getAttributesResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getAttributesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getAttributesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getAttributesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getAttributesResponse %p -> %p\n", q, p));
	*(struct fireman__getAttributesResponse*)p = *(struct fireman__getAttributesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getServiceMetadata(struct soap *soap, const struct fireman__getServiceMetadata *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_key);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getServiceMetadata(struct soap *soap, struct fireman__getServiceMetadata *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_key);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getServiceMetadata(struct soap *soap, const struct fireman__getServiceMetadata *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getServiceMetadata);
	if (soap_out_fireman__getServiceMetadata(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getServiceMetadata(struct soap *soap, const char *tag, int id, const struct fireman__getServiceMetadata *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getServiceMetadata), type);
	soap_out_string(soap, "key", -1, &a->_key, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getServiceMetadata * SOAP_FMAC4 soap_get_fireman__getServiceMetadata(struct soap *soap, struct fireman__getServiceMetadata *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getServiceMetadata(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getServiceMetadata * SOAP_FMAC4 soap_in_fireman__getServiceMetadata(struct soap *soap, const char *tag, struct fireman__getServiceMetadata *a, const char *type)
{
	short soap_flag__key = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getServiceMetadata *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getServiceMetadata, sizeof(struct fireman__getServiceMetadata), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getServiceMetadata(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__key && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_key, "xsd:string"))
				{	soap_flag__key--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getServiceMetadata *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getServiceMetadata, 0, sizeof(struct fireman__getServiceMetadata), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getServiceMetadata * SOAP_FMAC6 soap_new_fireman__getServiceMetadata(struct soap *soap, int n)
{	return soap_instantiate_fireman__getServiceMetadata(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getServiceMetadata(struct soap *soap, struct fireman__getServiceMetadata *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getServiceMetadata * SOAP_FMAC4 soap_instantiate_fireman__getServiceMetadata(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getServiceMetadata(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getServiceMetadata, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getServiceMetadata;
		if (size)
			*size = sizeof(struct fireman__getServiceMetadata);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getServiceMetadata[n];
		if (size)
			*size = n * sizeof(struct fireman__getServiceMetadata);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getServiceMetadata*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getServiceMetadata(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getServiceMetadata %p -> %p\n", q, p));
	*(struct fireman__getServiceMetadata*)p = *(struct fireman__getServiceMetadata*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getServiceMetadataResponse(struct soap *soap, const struct fireman__getServiceMetadataResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_getServiceMetadataReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getServiceMetadataResponse(struct soap *soap, struct fireman__getServiceMetadataResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_getServiceMetadataReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getServiceMetadataResponse(struct soap *soap, const struct fireman__getServiceMetadataResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getServiceMetadataResponse);
	if (soap_out_fireman__getServiceMetadataResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getServiceMetadataResponse(struct soap *soap, const char *tag, int id, const struct fireman__getServiceMetadataResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getServiceMetadataResponse), type);
	if (a->_getServiceMetadataReturn)
		soap_element_result(soap, "getServiceMetadataReturn");
	soap_out_string(soap, "getServiceMetadataReturn", -1, &a->_getServiceMetadataReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getServiceMetadataResponse * SOAP_FMAC4 soap_get_fireman__getServiceMetadataResponse(struct soap *soap, struct fireman__getServiceMetadataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getServiceMetadataResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getServiceMetadataResponse * SOAP_FMAC4 soap_in_fireman__getServiceMetadataResponse(struct soap *soap, const char *tag, struct fireman__getServiceMetadataResponse *a, const char *type)
{
	short soap_flag__getServiceMetadataReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getServiceMetadataResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getServiceMetadataResponse, sizeof(struct fireman__getServiceMetadataResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getServiceMetadataResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getServiceMetadataReturn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_getServiceMetadataReturn, "xsd:string"))
				{	soap_flag__getServiceMetadataReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getServiceMetadataResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getServiceMetadataResponse, 0, sizeof(struct fireman__getServiceMetadataResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getServiceMetadataResponse * SOAP_FMAC6 soap_new_fireman__getServiceMetadataResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getServiceMetadataResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getServiceMetadataResponse(struct soap *soap, struct fireman__getServiceMetadataResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getServiceMetadataResponse * SOAP_FMAC4 soap_instantiate_fireman__getServiceMetadataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getServiceMetadataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getServiceMetadataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getServiceMetadataResponse;
		if (size)
			*size = sizeof(struct fireman__getServiceMetadataResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getServiceMetadataResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getServiceMetadataResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getServiceMetadataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getServiceMetadataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getServiceMetadataResponse %p -> %p\n", q, p));
	*(struct fireman__getServiceMetadataResponse*)p = *(struct fireman__getServiceMetadataResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getInterfaceVersion(struct soap *soap, const struct fireman__getInterfaceVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getInterfaceVersion(struct soap *soap, struct fireman__getInterfaceVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getInterfaceVersion(struct soap *soap, const struct fireman__getInterfaceVersion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getInterfaceVersion);
	if (soap_out_fireman__getInterfaceVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getInterfaceVersion(struct soap *soap, const char *tag, int id, const struct fireman__getInterfaceVersion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getInterfaceVersion), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getInterfaceVersion * SOAP_FMAC4 soap_get_fireman__getInterfaceVersion(struct soap *soap, struct fireman__getInterfaceVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getInterfaceVersion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getInterfaceVersion * SOAP_FMAC4 soap_in_fireman__getInterfaceVersion(struct soap *soap, const char *tag, struct fireman__getInterfaceVersion *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getInterfaceVersion *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getInterfaceVersion, sizeof(struct fireman__getInterfaceVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getInterfaceVersion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getInterfaceVersion *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getInterfaceVersion, 0, sizeof(struct fireman__getInterfaceVersion), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getInterfaceVersion * SOAP_FMAC6 soap_new_fireman__getInterfaceVersion(struct soap *soap, int n)
{	return soap_instantiate_fireman__getInterfaceVersion(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getInterfaceVersion(struct soap *soap, struct fireman__getInterfaceVersion *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getInterfaceVersion * SOAP_FMAC4 soap_instantiate_fireman__getInterfaceVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getInterfaceVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getInterfaceVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getInterfaceVersion;
		if (size)
			*size = sizeof(struct fireman__getInterfaceVersion);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getInterfaceVersion[n];
		if (size)
			*size = n * sizeof(struct fireman__getInterfaceVersion);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getInterfaceVersion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getInterfaceVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getInterfaceVersion %p -> %p\n", q, p));
	*(struct fireman__getInterfaceVersion*)p = *(struct fireman__getInterfaceVersion*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getInterfaceVersionResponse(struct soap *soap, const struct fireman__getInterfaceVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->getInterfaceVersionReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getInterfaceVersionResponse(struct soap *soap, struct fireman__getInterfaceVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->getInterfaceVersionReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getInterfaceVersionResponse(struct soap *soap, const struct fireman__getInterfaceVersionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getInterfaceVersionResponse);
	if (soap_out_fireman__getInterfaceVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getInterfaceVersionResponse(struct soap *soap, const char *tag, int id, const struct fireman__getInterfaceVersionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getInterfaceVersionResponse), type);
	if (a->getInterfaceVersionReturn)
		soap_element_result(soap, "getInterfaceVersionReturn");
	soap_out_string(soap, "getInterfaceVersionReturn", -1, &a->getInterfaceVersionReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getInterfaceVersionResponse * SOAP_FMAC4 soap_get_fireman__getInterfaceVersionResponse(struct soap *soap, struct fireman__getInterfaceVersionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getInterfaceVersionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getInterfaceVersionResponse * SOAP_FMAC4 soap_in_fireman__getInterfaceVersionResponse(struct soap *soap, const char *tag, struct fireman__getInterfaceVersionResponse *a, const char *type)
{
	short soap_flag_getInterfaceVersionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getInterfaceVersionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getInterfaceVersionResponse, sizeof(struct fireman__getInterfaceVersionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getInterfaceVersionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getInterfaceVersionReturn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "getInterfaceVersionReturn", &a->getInterfaceVersionReturn, "xsd:string"))
				{	soap_flag_getInterfaceVersionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getInterfaceVersionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getInterfaceVersionResponse, 0, sizeof(struct fireman__getInterfaceVersionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getInterfaceVersionResponse * SOAP_FMAC6 soap_new_fireman__getInterfaceVersionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getInterfaceVersionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getInterfaceVersionResponse(struct soap *soap, struct fireman__getInterfaceVersionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getInterfaceVersionResponse * SOAP_FMAC4 soap_instantiate_fireman__getInterfaceVersionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getInterfaceVersionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getInterfaceVersionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getInterfaceVersionResponse;
		if (size)
			*size = sizeof(struct fireman__getInterfaceVersionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getInterfaceVersionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getInterfaceVersionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getInterfaceVersionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getInterfaceVersionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getInterfaceVersionResponse %p -> %p\n", q, p));
	*(struct fireman__getInterfaceVersionResponse*)p = *(struct fireman__getInterfaceVersionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getSchemaVersion(struct soap *soap, const struct fireman__getSchemaVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getSchemaVersion(struct soap *soap, struct fireman__getSchemaVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getSchemaVersion(struct soap *soap, const struct fireman__getSchemaVersion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getSchemaVersion);
	if (soap_out_fireman__getSchemaVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getSchemaVersion(struct soap *soap, const char *tag, int id, const struct fireman__getSchemaVersion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getSchemaVersion), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getSchemaVersion * SOAP_FMAC4 soap_get_fireman__getSchemaVersion(struct soap *soap, struct fireman__getSchemaVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getSchemaVersion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getSchemaVersion * SOAP_FMAC4 soap_in_fireman__getSchemaVersion(struct soap *soap, const char *tag, struct fireman__getSchemaVersion *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getSchemaVersion *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getSchemaVersion, sizeof(struct fireman__getSchemaVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getSchemaVersion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getSchemaVersion *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getSchemaVersion, 0, sizeof(struct fireman__getSchemaVersion), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getSchemaVersion * SOAP_FMAC6 soap_new_fireman__getSchemaVersion(struct soap *soap, int n)
{	return soap_instantiate_fireman__getSchemaVersion(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getSchemaVersion(struct soap *soap, struct fireman__getSchemaVersion *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getSchemaVersion * SOAP_FMAC4 soap_instantiate_fireman__getSchemaVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getSchemaVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getSchemaVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getSchemaVersion;
		if (size)
			*size = sizeof(struct fireman__getSchemaVersion);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getSchemaVersion[n];
		if (size)
			*size = n * sizeof(struct fireman__getSchemaVersion);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getSchemaVersion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getSchemaVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getSchemaVersion %p -> %p\n", q, p));
	*(struct fireman__getSchemaVersion*)p = *(struct fireman__getSchemaVersion*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getSchemaVersionResponse(struct soap *soap, const struct fireman__getSchemaVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->getSchemaVersionReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getSchemaVersionResponse(struct soap *soap, struct fireman__getSchemaVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->getSchemaVersionReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getSchemaVersionResponse(struct soap *soap, const struct fireman__getSchemaVersionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getSchemaVersionResponse);
	if (soap_out_fireman__getSchemaVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getSchemaVersionResponse(struct soap *soap, const char *tag, int id, const struct fireman__getSchemaVersionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getSchemaVersionResponse), type);
	if (a->getSchemaVersionReturn)
		soap_element_result(soap, "getSchemaVersionReturn");
	soap_out_string(soap, "getSchemaVersionReturn", -1, &a->getSchemaVersionReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getSchemaVersionResponse * SOAP_FMAC4 soap_get_fireman__getSchemaVersionResponse(struct soap *soap, struct fireman__getSchemaVersionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getSchemaVersionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getSchemaVersionResponse * SOAP_FMAC4 soap_in_fireman__getSchemaVersionResponse(struct soap *soap, const char *tag, struct fireman__getSchemaVersionResponse *a, const char *type)
{
	short soap_flag_getSchemaVersionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getSchemaVersionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getSchemaVersionResponse, sizeof(struct fireman__getSchemaVersionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getSchemaVersionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getSchemaVersionReturn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "getSchemaVersionReturn", &a->getSchemaVersionReturn, "xsd:string"))
				{	soap_flag_getSchemaVersionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getSchemaVersionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getSchemaVersionResponse, 0, sizeof(struct fireman__getSchemaVersionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getSchemaVersionResponse * SOAP_FMAC6 soap_new_fireman__getSchemaVersionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getSchemaVersionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getSchemaVersionResponse(struct soap *soap, struct fireman__getSchemaVersionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getSchemaVersionResponse * SOAP_FMAC4 soap_instantiate_fireman__getSchemaVersionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getSchemaVersionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getSchemaVersionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getSchemaVersionResponse;
		if (size)
			*size = sizeof(struct fireman__getSchemaVersionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getSchemaVersionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getSchemaVersionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getSchemaVersionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getSchemaVersionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getSchemaVersionResponse %p -> %p\n", q, p));
	*(struct fireman__getSchemaVersionResponse*)p = *(struct fireman__getSchemaVersionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getVersion(struct soap *soap, const struct fireman__getVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getVersion(struct soap *soap, struct fireman__getVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getVersion(struct soap *soap, const struct fireman__getVersion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getVersion);
	if (soap_out_fireman__getVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getVersion(struct soap *soap, const char *tag, int id, const struct fireman__getVersion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getVersion), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getVersion * SOAP_FMAC4 soap_get_fireman__getVersion(struct soap *soap, struct fireman__getVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getVersion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getVersion * SOAP_FMAC4 soap_in_fireman__getVersion(struct soap *soap, const char *tag, struct fireman__getVersion *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getVersion *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getVersion, sizeof(struct fireman__getVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getVersion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getVersion *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getVersion, 0, sizeof(struct fireman__getVersion), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getVersion * SOAP_FMAC6 soap_new_fireman__getVersion(struct soap *soap, int n)
{	return soap_instantiate_fireman__getVersion(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getVersion(struct soap *soap, struct fireman__getVersion *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getVersion * SOAP_FMAC4 soap_instantiate_fireman__getVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getVersion;
		if (size)
			*size = sizeof(struct fireman__getVersion);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getVersion[n];
		if (size)
			*size = n * sizeof(struct fireman__getVersion);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getVersion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getVersion %p -> %p\n", q, p));
	*(struct fireman__getVersion*)p = *(struct fireman__getVersion*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getVersionResponse(struct soap *soap, const struct fireman__getVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->getVersionReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getVersionResponse(struct soap *soap, struct fireman__getVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->getVersionReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getVersionResponse(struct soap *soap, const struct fireman__getVersionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getVersionResponse);
	if (soap_out_fireman__getVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getVersionResponse(struct soap *soap, const char *tag, int id, const struct fireman__getVersionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getVersionResponse), type);
	if (a->getVersionReturn)
		soap_element_result(soap, "getVersionReturn");
	soap_out_string(soap, "getVersionReturn", -1, &a->getVersionReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getVersionResponse * SOAP_FMAC4 soap_get_fireman__getVersionResponse(struct soap *soap, struct fireman__getVersionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getVersionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getVersionResponse * SOAP_FMAC4 soap_in_fireman__getVersionResponse(struct soap *soap, const char *tag, struct fireman__getVersionResponse *a, const char *type)
{
	short soap_flag_getVersionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getVersionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getVersionResponse, sizeof(struct fireman__getVersionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getVersionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getVersionReturn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "getVersionReturn", &a->getVersionReturn, "xsd:string"))
				{	soap_flag_getVersionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getVersionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getVersionResponse, 0, sizeof(struct fireman__getVersionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getVersionResponse * SOAP_FMAC6 soap_new_fireman__getVersionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getVersionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getVersionResponse(struct soap *soap, struct fireman__getVersionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getVersionResponse * SOAP_FMAC4 soap_instantiate_fireman__getVersionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getVersionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getVersionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getVersionResponse;
		if (size)
			*size = sizeof(struct fireman__getVersionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getVersionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getVersionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getVersionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getVersionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getVersionResponse %p -> %p\n", q, p));
	*(struct fireman__getVersionResponse*)p = *(struct fireman__getVersionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setPermission(struct soap *soap, const struct fireman__setPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, &a->_permissions);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setPermission(struct soap *soap, struct fireman__setPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_permissions = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setPermission(struct soap *soap, const struct fireman__setPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setPermission);
	if (soap_out_fireman__setPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setPermission(struct soap *soap, const char *tag, int id, const struct fireman__setPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setPermission), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, "permissions", -1, &a->_permissions, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setPermission * SOAP_FMAC4 soap_get_fireman__setPermission(struct soap *soap, struct fireman__setPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setPermission * SOAP_FMAC4 soap_in_fireman__setPermission(struct soap *soap, const char *tag, struct fireman__setPermission *a, const char *type)
{
	short soap_flag__permissions = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setPermission, sizeof(struct fireman__setPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__permissions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, NULL, &a->_permissions, "glite:PermissionEntry"))
				{	soap_flag__permissions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setPermission, 0, sizeof(struct fireman__setPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setPermission * SOAP_FMAC6 soap_new_fireman__setPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__setPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setPermission(struct soap *soap, struct fireman__setPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setPermission * SOAP_FMAC4 soap_instantiate_fireman__setPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setPermission;
		if (size)
			*size = sizeof(struct fireman__setPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__setPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setPermission %p -> %p\n", q, p));
	*(struct fireman__setPermission*)p = *(struct fireman__setPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__setPermissionResponse(struct soap *soap, const struct fireman__setPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__setPermissionResponse(struct soap *soap, struct fireman__setPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__setPermissionResponse(struct soap *soap, const struct fireman__setPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__setPermissionResponse);
	if (soap_out_fireman__setPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__setPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__setPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__setPermissionResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__setPermissionResponse * SOAP_FMAC4 soap_get_fireman__setPermissionResponse(struct soap *soap, struct fireman__setPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__setPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__setPermissionResponse * SOAP_FMAC4 soap_in_fireman__setPermissionResponse(struct soap *soap, const char *tag, struct fireman__setPermissionResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__setPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__setPermissionResponse, sizeof(struct fireman__setPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__setPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__setPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__setPermissionResponse, 0, sizeof(struct fireman__setPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__setPermissionResponse * SOAP_FMAC6 soap_new_fireman__setPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__setPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__setPermissionResponse(struct soap *soap, struct fireman__setPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__setPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__setPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__setPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__setPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__setPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__setPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__setPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__setPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__setPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__setPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__setPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__setPermissionResponse*)p = *(struct fireman__setPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getPermission(struct soap *soap, const struct fireman__getPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_items);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getPermission(struct soap *soap, struct fireman__getPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_items = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getPermission(struct soap *soap, const struct fireman__getPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getPermission);
	if (soap_out_fireman__getPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getPermission(struct soap *soap, const char *tag, int id, const struct fireman__getPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getPermission), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "items", -1, &a->_items, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getPermission * SOAP_FMAC4 soap_get_fireman__getPermission(struct soap *soap, struct fireman__getPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getPermission * SOAP_FMAC4 soap_in_fireman__getPermission(struct soap *soap, const char *tag, struct fireman__getPermission *a, const char *type)
{
	short soap_flag__items = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getPermission, sizeof(struct fireman__getPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__items && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_items, "xsd:string"))
				{	soap_flag__items--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getPermission, 0, sizeof(struct fireman__getPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getPermission * SOAP_FMAC6 soap_new_fireman__getPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__getPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getPermission(struct soap *soap, struct fireman__getPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getPermission * SOAP_FMAC4 soap_instantiate_fireman__getPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getPermission;
		if (size)
			*size = sizeof(struct fireman__getPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__getPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getPermission %p -> %p\n", q, p));
	*(struct fireman__getPermission*)p = *(struct fireman__getPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getPermissionResponse(struct soap *soap, const struct fireman__getPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, &a->_getPermissionReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getPermissionResponse(struct soap *soap, struct fireman__getPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getPermissionReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getPermissionResponse(struct soap *soap, const struct fireman__getPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getPermissionResponse);
	if (soap_out_fireman__getPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__getPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getPermissionResponse), type);
	if (a->_getPermissionReturn)
		soap_element_result(soap, "getPermissionReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, "getPermissionReturn", -1, &a->_getPermissionReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getPermissionResponse * SOAP_FMAC4 soap_get_fireman__getPermissionResponse(struct soap *soap, struct fireman__getPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getPermissionResponse * SOAP_FMAC4 soap_in_fireman__getPermissionResponse(struct soap *soap, const char *tag, struct fireman__getPermissionResponse *a, const char *type)
{
	short soap_flag__getPermissionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getPermissionResponse, sizeof(struct fireman__getPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getPermissionReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, NULL, &a->_getPermissionReturn, "glite:PermissionEntry"))
				{	soap_flag__getPermissionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getPermissionResponse, 0, sizeof(struct fireman__getPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getPermissionResponse * SOAP_FMAC6 soap_new_fireman__getPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getPermissionResponse(struct soap *soap, struct fireman__getPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__getPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__getPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__getPermissionResponse*)p = *(struct fireman__getPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__checkPermission(struct soap *soap, const struct fireman__checkPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_items);
	soap_serialize_PointerToglite__Perm(soap, &a->_perm);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__checkPermission(struct soap *soap, struct fireman__checkPermission *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_items = NULL;
	a->_perm = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__checkPermission(struct soap *soap, const struct fireman__checkPermission *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__checkPermission);
	if (soap_out_fireman__checkPermission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__checkPermission(struct soap *soap, const char *tag, int id, const struct fireman__checkPermission *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__checkPermission), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "items", -1, &a->_items, "");
	soap_out_PointerToglite__Perm(soap, "perm", -1, &a->_perm, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__checkPermission * SOAP_FMAC4 soap_get_fireman__checkPermission(struct soap *soap, struct fireman__checkPermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__checkPermission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__checkPermission * SOAP_FMAC4 soap_in_fireman__checkPermission(struct soap *soap, const char *tag, struct fireman__checkPermission *a, const char *type)
{
	short soap_flag__items = 1, soap_flag__perm = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__checkPermission *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__checkPermission, sizeof(struct fireman__checkPermission), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__checkPermission(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__items && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_items, "xsd:string"))
				{	soap_flag__items--;
					continue;
				}
			if (soap_flag__perm && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToglite__Perm(soap, NULL, &a->_perm, "glite:Perm"))
				{	soap_flag__perm--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__checkPermission *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__checkPermission, 0, sizeof(struct fireman__checkPermission), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__checkPermission * SOAP_FMAC6 soap_new_fireman__checkPermission(struct soap *soap, int n)
{	return soap_instantiate_fireman__checkPermission(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__checkPermission(struct soap *soap, struct fireman__checkPermission *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__checkPermission * SOAP_FMAC4 soap_instantiate_fireman__checkPermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__checkPermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__checkPermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__checkPermission;
		if (size)
			*size = sizeof(struct fireman__checkPermission);
	}
	else
	{	cp->ptr = (void*)new struct fireman__checkPermission[n];
		if (size)
			*size = n * sizeof(struct fireman__checkPermission);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__checkPermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__checkPermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__checkPermission %p -> %p\n", q, p));
	*(struct fireman__checkPermission*)p = *(struct fireman__checkPermission*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__checkPermissionResponse(struct soap *soap, const struct fireman__checkPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__checkPermissionResponse(struct soap *soap, struct fireman__checkPermissionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__checkPermissionResponse(struct soap *soap, const struct fireman__checkPermissionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__checkPermissionResponse);
	if (soap_out_fireman__checkPermissionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__checkPermissionResponse(struct soap *soap, const char *tag, int id, const struct fireman__checkPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__checkPermissionResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__checkPermissionResponse * SOAP_FMAC4 soap_get_fireman__checkPermissionResponse(struct soap *soap, struct fireman__checkPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__checkPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__checkPermissionResponse * SOAP_FMAC4 soap_in_fireman__checkPermissionResponse(struct soap *soap, const char *tag, struct fireman__checkPermissionResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__checkPermissionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__checkPermissionResponse, sizeof(struct fireman__checkPermissionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__checkPermissionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__checkPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__checkPermissionResponse, 0, sizeof(struct fireman__checkPermissionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__checkPermissionResponse * SOAP_FMAC6 soap_new_fireman__checkPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__checkPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__checkPermissionResponse(struct soap *soap, struct fireman__checkPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__checkPermissionResponse * SOAP_FMAC4 soap_instantiate_fireman__checkPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__checkPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__checkPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__checkPermissionResponse;
		if (size)
			*size = sizeof(struct fireman__checkPermissionResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__checkPermissionResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__checkPermissionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__checkPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__checkPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__checkPermissionResponse %p -> %p\n", q, p));
	*(struct fireman__checkPermissionResponse*)p = *(struct fireman__checkPermissionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getFileCatalogEntry(struct soap *soap, const struct fireman__getFileCatalogEntry *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getFileCatalogEntry(struct soap *soap, struct fireman__getFileCatalogEntry *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getFileCatalogEntry(struct soap *soap, const struct fireman__getFileCatalogEntry *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getFileCatalogEntry);
	if (soap_out_fireman__getFileCatalogEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getFileCatalogEntry(struct soap *soap, const char *tag, int id, const struct fireman__getFileCatalogEntry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getFileCatalogEntry), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getFileCatalogEntry * SOAP_FMAC4 soap_get_fireman__getFileCatalogEntry(struct soap *soap, struct fireman__getFileCatalogEntry *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getFileCatalogEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getFileCatalogEntry * SOAP_FMAC4 soap_in_fireman__getFileCatalogEntry(struct soap *soap, const char *tag, struct fireman__getFileCatalogEntry *a, const char *type)
{
	short soap_flag__lfns = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getFileCatalogEntry *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getFileCatalogEntry, sizeof(struct fireman__getFileCatalogEntry), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getFileCatalogEntry(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getFileCatalogEntry *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getFileCatalogEntry, 0, sizeof(struct fireman__getFileCatalogEntry), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getFileCatalogEntry * SOAP_FMAC6 soap_new_fireman__getFileCatalogEntry(struct soap *soap, int n)
{	return soap_instantiate_fireman__getFileCatalogEntry(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getFileCatalogEntry(struct soap *soap, struct fireman__getFileCatalogEntry *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getFileCatalogEntry * SOAP_FMAC4 soap_instantiate_fireman__getFileCatalogEntry(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getFileCatalogEntry(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getFileCatalogEntry, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getFileCatalogEntry;
		if (size)
			*size = sizeof(struct fireman__getFileCatalogEntry);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getFileCatalogEntry[n];
		if (size)
			*size = n * sizeof(struct fireman__getFileCatalogEntry);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getFileCatalogEntry*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getFileCatalogEntry(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getFileCatalogEntry %p -> %p\n", q, p));
	*(struct fireman__getFileCatalogEntry*)p = *(struct fireman__getFileCatalogEntry*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getFileCatalogEntryResponse(struct soap *soap, const struct fireman__getFileCatalogEntryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, &a->_getFileCatalogEntryReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getFileCatalogEntryResponse(struct soap *soap, struct fireman__getFileCatalogEntryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getFileCatalogEntryReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getFileCatalogEntryResponse(struct soap *soap, const struct fireman__getFileCatalogEntryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getFileCatalogEntryResponse);
	if (soap_out_fireman__getFileCatalogEntryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getFileCatalogEntryResponse(struct soap *soap, const char *tag, int id, const struct fireman__getFileCatalogEntryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getFileCatalogEntryResponse), type);
	if (a->_getFileCatalogEntryReturn)
		soap_element_result(soap, "getFileCatalogEntryReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, "getFileCatalogEntryReturn", -1, &a->_getFileCatalogEntryReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getFileCatalogEntryResponse * SOAP_FMAC4 soap_get_fireman__getFileCatalogEntryResponse(struct soap *soap, struct fireman__getFileCatalogEntryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getFileCatalogEntryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getFileCatalogEntryResponse * SOAP_FMAC4 soap_in_fireman__getFileCatalogEntryResponse(struct soap *soap, const char *tag, struct fireman__getFileCatalogEntryResponse *a, const char *type)
{
	short soap_flag__getFileCatalogEntryReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getFileCatalogEntryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getFileCatalogEntryResponse, sizeof(struct fireman__getFileCatalogEntryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getFileCatalogEntryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getFileCatalogEntryReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, NULL, &a->_getFileCatalogEntryReturn, "glite:FCEntry"))
				{	soap_flag__getFileCatalogEntryReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getFileCatalogEntryResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getFileCatalogEntryResponse, 0, sizeof(struct fireman__getFileCatalogEntryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getFileCatalogEntryResponse * SOAP_FMAC6 soap_new_fireman__getFileCatalogEntryResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getFileCatalogEntryResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getFileCatalogEntryResponse(struct soap *soap, struct fireman__getFileCatalogEntryResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getFileCatalogEntryResponse * SOAP_FMAC4 soap_instantiate_fireman__getFileCatalogEntryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getFileCatalogEntryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getFileCatalogEntryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getFileCatalogEntryResponse;
		if (size)
			*size = sizeof(struct fireman__getFileCatalogEntryResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getFileCatalogEntryResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getFileCatalogEntryResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getFileCatalogEntryResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getFileCatalogEntryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getFileCatalogEntryResponse %p -> %p\n", q, p));
	*(struct fireman__getFileCatalogEntryResponse*)p = *(struct fireman__getFileCatalogEntryResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getLfnForGuid(struct soap *soap, const struct fireman__getLfnForGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_guids);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getLfnForGuid(struct soap *soap, struct fireman__getLfnForGuid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_guids = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getLfnForGuid(struct soap *soap, const struct fireman__getLfnForGuid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getLfnForGuid);
	if (soap_out_fireman__getLfnForGuid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getLfnForGuid(struct soap *soap, const char *tag, int id, const struct fireman__getLfnForGuid *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getLfnForGuid), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "guids", -1, &a->_guids, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getLfnForGuid * SOAP_FMAC4 soap_get_fireman__getLfnForGuid(struct soap *soap, struct fireman__getLfnForGuid *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getLfnForGuid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getLfnForGuid * SOAP_FMAC4 soap_in_fireman__getLfnForGuid(struct soap *soap, const char *tag, struct fireman__getLfnForGuid *a, const char *type)
{
	short soap_flag__guids = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getLfnForGuid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getLfnForGuid, sizeof(struct fireman__getLfnForGuid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getLfnForGuid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__guids && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_guids, "xsd:string"))
				{	soap_flag__guids--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getLfnForGuid *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getLfnForGuid, 0, sizeof(struct fireman__getLfnForGuid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getLfnForGuid * SOAP_FMAC6 soap_new_fireman__getLfnForGuid(struct soap *soap, int n)
{	return soap_instantiate_fireman__getLfnForGuid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getLfnForGuid(struct soap *soap, struct fireman__getLfnForGuid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getLfnForGuid * SOAP_FMAC4 soap_instantiate_fireman__getLfnForGuid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getLfnForGuid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getLfnForGuid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getLfnForGuid;
		if (size)
			*size = sizeof(struct fireman__getLfnForGuid);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getLfnForGuid[n];
		if (size)
			*size = n * sizeof(struct fireman__getLfnForGuid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getLfnForGuid*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getLfnForGuid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getLfnForGuid %p -> %p\n", q, p));
	*(struct fireman__getLfnForGuid*)p = *(struct fireman__getLfnForGuid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getLfnForGuidResponse(struct soap *soap, const struct fireman__getLfnForGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_getLfnForGuidReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getLfnForGuidResponse(struct soap *soap, struct fireman__getLfnForGuidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getLfnForGuidReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getLfnForGuidResponse(struct soap *soap, const struct fireman__getLfnForGuidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getLfnForGuidResponse);
	if (soap_out_fireman__getLfnForGuidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getLfnForGuidResponse(struct soap *soap, const char *tag, int id, const struct fireman__getLfnForGuidResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getLfnForGuidResponse), type);
	if (a->_getLfnForGuidReturn)
		soap_element_result(soap, "getLfnForGuidReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "getLfnForGuidReturn", -1, &a->_getLfnForGuidReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getLfnForGuidResponse * SOAP_FMAC4 soap_get_fireman__getLfnForGuidResponse(struct soap *soap, struct fireman__getLfnForGuidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getLfnForGuidResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getLfnForGuidResponse * SOAP_FMAC4 soap_in_fireman__getLfnForGuidResponse(struct soap *soap, const char *tag, struct fireman__getLfnForGuidResponse *a, const char *type)
{
	short soap_flag__getLfnForGuidReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getLfnForGuidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getLfnForGuidResponse, sizeof(struct fireman__getLfnForGuidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getLfnForGuidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getLfnForGuidReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_getLfnForGuidReturn, "glite:StringPair"))
				{	soap_flag__getLfnForGuidReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getLfnForGuidResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getLfnForGuidResponse, 0, sizeof(struct fireman__getLfnForGuidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getLfnForGuidResponse * SOAP_FMAC6 soap_new_fireman__getLfnForGuidResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getLfnForGuidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getLfnForGuidResponse(struct soap *soap, struct fireman__getLfnForGuidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getLfnForGuidResponse * SOAP_FMAC4 soap_instantiate_fireman__getLfnForGuidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getLfnForGuidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getLfnForGuidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getLfnForGuidResponse;
		if (size)
			*size = sizeof(struct fireman__getLfnForGuidResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getLfnForGuidResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getLfnForGuidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getLfnForGuidResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getLfnForGuidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getLfnForGuidResponse %p -> %p\n", q, p));
	*(struct fireman__getLfnForGuidResponse*)p = *(struct fireman__getLfnForGuidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getGuidForLfn(struct soap *soap, const struct fireman__getGuidForLfn *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getGuidForLfn(struct soap *soap, struct fireman__getGuidForLfn *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getGuidForLfn(struct soap *soap, const struct fireman__getGuidForLfn *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getGuidForLfn);
	if (soap_out_fireman__getGuidForLfn(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getGuidForLfn(struct soap *soap, const char *tag, int id, const struct fireman__getGuidForLfn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getGuidForLfn), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getGuidForLfn * SOAP_FMAC4 soap_get_fireman__getGuidForLfn(struct soap *soap, struct fireman__getGuidForLfn *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getGuidForLfn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getGuidForLfn * SOAP_FMAC4 soap_in_fireman__getGuidForLfn(struct soap *soap, const char *tag, struct fireman__getGuidForLfn *a, const char *type)
{
	short soap_flag__lfns = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getGuidForLfn *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getGuidForLfn, sizeof(struct fireman__getGuidForLfn), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getGuidForLfn(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getGuidForLfn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getGuidForLfn, 0, sizeof(struct fireman__getGuidForLfn), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getGuidForLfn * SOAP_FMAC6 soap_new_fireman__getGuidForLfn(struct soap *soap, int n)
{	return soap_instantiate_fireman__getGuidForLfn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getGuidForLfn(struct soap *soap, struct fireman__getGuidForLfn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getGuidForLfn * SOAP_FMAC4 soap_instantiate_fireman__getGuidForLfn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getGuidForLfn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getGuidForLfn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getGuidForLfn;
		if (size)
			*size = sizeof(struct fireman__getGuidForLfn);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getGuidForLfn[n];
		if (size)
			*size = n * sizeof(struct fireman__getGuidForLfn);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getGuidForLfn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getGuidForLfn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getGuidForLfn %p -> %p\n", q, p));
	*(struct fireman__getGuidForLfn*)p = *(struct fireman__getGuidForLfn*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getGuidForLfnResponse(struct soap *soap, const struct fireman__getGuidForLfnResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_getGuidForLfnReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getGuidForLfnResponse(struct soap *soap, struct fireman__getGuidForLfnResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getGuidForLfnReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getGuidForLfnResponse(struct soap *soap, const struct fireman__getGuidForLfnResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getGuidForLfnResponse);
	if (soap_out_fireman__getGuidForLfnResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getGuidForLfnResponse(struct soap *soap, const char *tag, int id, const struct fireman__getGuidForLfnResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getGuidForLfnResponse), type);
	if (a->_getGuidForLfnReturn)
		soap_element_result(soap, "getGuidForLfnReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "getGuidForLfnReturn", -1, &a->_getGuidForLfnReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getGuidForLfnResponse * SOAP_FMAC4 soap_get_fireman__getGuidForLfnResponse(struct soap *soap, struct fireman__getGuidForLfnResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getGuidForLfnResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getGuidForLfnResponse * SOAP_FMAC4 soap_in_fireman__getGuidForLfnResponse(struct soap *soap, const char *tag, struct fireman__getGuidForLfnResponse *a, const char *type)
{
	short soap_flag__getGuidForLfnReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getGuidForLfnResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getGuidForLfnResponse, sizeof(struct fireman__getGuidForLfnResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getGuidForLfnResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getGuidForLfnReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_getGuidForLfnReturn, "glite:StringPair"))
				{	soap_flag__getGuidForLfnReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getGuidForLfnResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getGuidForLfnResponse, 0, sizeof(struct fireman__getGuidForLfnResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getGuidForLfnResponse * SOAP_FMAC6 soap_new_fireman__getGuidForLfnResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getGuidForLfnResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getGuidForLfnResponse(struct soap *soap, struct fireman__getGuidForLfnResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getGuidForLfnResponse * SOAP_FMAC4 soap_instantiate_fireman__getGuidForLfnResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getGuidForLfnResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getGuidForLfnResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getGuidForLfnResponse;
		if (size)
			*size = sizeof(struct fireman__getGuidForLfnResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getGuidForLfnResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getGuidForLfnResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getGuidForLfnResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getGuidForLfnResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getGuidForLfnResponse %p -> %p\n", q, p));
	*(struct fireman__getGuidForLfnResponse*)p = *(struct fireman__getGuidForLfnResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__readDir(struct soap *soap, const struct fireman__readDir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_path);
	soap_serialize_string(soap, &a->_pattern);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__readDir(struct soap *soap, struct fireman__readDir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_path);
	soap_default_string(soap, &a->_pattern);
	soap_default_LONG64(soap, &a->_limit);
	soap_default_LONG64(soap, &a->_offset);
	soap_default_bool(soap, &a->_withPermissions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__readDir(struct soap *soap, const struct fireman__readDir *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__readDir);
	if (soap_out_fireman__readDir(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__readDir(struct soap *soap, const char *tag, int id, const struct fireman__readDir *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__readDir), type);
	soap_out_string(soap, "path", -1, &a->_path, "");
	soap_out_string(soap, "pattern", -1, &a->_pattern, "");
	soap_out_LONG64(soap, "limit", -1, &a->_limit, "");
	soap_out_LONG64(soap, "offset", -1, &a->_offset, "");
	soap_out_bool(soap, "withPermissions", -1, &a->_withPermissions, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__readDir * SOAP_FMAC4 soap_get_fireman__readDir(struct soap *soap, struct fireman__readDir *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__readDir(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__readDir * SOAP_FMAC4 soap_in_fireman__readDir(struct soap *soap, const char *tag, struct fireman__readDir *a, const char *type)
{
	short soap_flag__path = 1, soap_flag__pattern = 1, soap_flag__limit = 1, soap_flag__offset = 1, soap_flag__withPermissions = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__readDir *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__readDir, sizeof(struct fireman__readDir), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__readDir(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__path && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_path, "xsd:string"))
				{	soap_flag__path--;
					continue;
				}
			if (soap_flag__pattern && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_pattern, "xsd:string"))
				{	soap_flag__pattern--;
					continue;
				}
			if (soap_flag__limit && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_limit, "xsd:long"))
				{	soap_flag__limit--;
					continue;
				}
			if (soap_flag__offset && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_offset, "xsd:long"))
				{	soap_flag__offset--;
					continue;
				}
			if (soap_flag__withPermissions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_withPermissions, "xsd:boolean"))
				{	soap_flag__withPermissions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__limit > 0 || soap_flag__offset > 0 || soap_flag__withPermissions > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__readDir *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__readDir, 0, sizeof(struct fireman__readDir), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__readDir * SOAP_FMAC6 soap_new_fireman__readDir(struct soap *soap, int n)
{	return soap_instantiate_fireman__readDir(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__readDir(struct soap *soap, struct fireman__readDir *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__readDir * SOAP_FMAC4 soap_instantiate_fireman__readDir(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__readDir(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__readDir, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__readDir;
		if (size)
			*size = sizeof(struct fireman__readDir);
	}
	else
	{	cp->ptr = (void*)new struct fireman__readDir[n];
		if (size)
			*size = n * sizeof(struct fireman__readDir);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__readDir*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__readDir(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__readDir %p -> %p\n", q, p));
	*(struct fireman__readDir*)p = *(struct fireman__readDir*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__readDirResponse(struct soap *soap, const struct fireman__readDirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, &a->_readDirReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__readDirResponse(struct soap *soap, struct fireman__readDirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_readDirReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__readDirResponse(struct soap *soap, const struct fireman__readDirResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__readDirResponse);
	if (soap_out_fireman__readDirResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__readDirResponse(struct soap *soap, const char *tag, int id, const struct fireman__readDirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__readDirResponse), type);
	if (a->_readDirReturn)
		soap_element_result(soap, "readDirReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, "readDirReturn", -1, &a->_readDirReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__readDirResponse * SOAP_FMAC4 soap_get_fireman__readDirResponse(struct soap *soap, struct fireman__readDirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__readDirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__readDirResponse * SOAP_FMAC4 soap_in_fireman__readDirResponse(struct soap *soap, const char *tag, struct fireman__readDirResponse *a, const char *type)
{
	short soap_flag__readDirReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__readDirResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__readDirResponse, sizeof(struct fireman__readDirResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__readDirResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__readDirReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, NULL, &a->_readDirReturn, "glite:FCEntry"))
				{	soap_flag__readDirReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__readDirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__readDirResponse, 0, sizeof(struct fireman__readDirResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__readDirResponse * SOAP_FMAC6 soap_new_fireman__readDirResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__readDirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__readDirResponse(struct soap *soap, struct fireman__readDirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__readDirResponse * SOAP_FMAC4 soap_instantiate_fireman__readDirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__readDirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__readDirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__readDirResponse;
		if (size)
			*size = sizeof(struct fireman__readDirResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__readDirResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__readDirResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__readDirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__readDirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__readDirResponse %p -> %p\n", q, p));
	*(struct fireman__readDirResponse*)p = *(struct fireman__readDirResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateValidityTime(struct soap *soap, const struct fireman__updateValidityTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateValidityTime(struct soap *soap, struct fireman__updateValidityTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
	soap_default_LONG64(soap, &a->_time);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateValidityTime(struct soap *soap, const struct fireman__updateValidityTime *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateValidityTime);
	if (soap_out_fireman__updateValidityTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateValidityTime(struct soap *soap, const char *tag, int id, const struct fireman__updateValidityTime *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateValidityTime), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_out_LONG64(soap, "time", -1, &a->_time, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateValidityTime * SOAP_FMAC4 soap_get_fireman__updateValidityTime(struct soap *soap, struct fireman__updateValidityTime *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateValidityTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateValidityTime * SOAP_FMAC4 soap_in_fireman__updateValidityTime(struct soap *soap, const char *tag, struct fireman__updateValidityTime *a, const char *type)
{
	short soap_flag__lfns = 1, soap_flag__time = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateValidityTime *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateValidityTime, sizeof(struct fireman__updateValidityTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateValidityTime(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap_flag__time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_time, "xsd:long"))
				{	soap_flag__time--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__time > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateValidityTime *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateValidityTime, 0, sizeof(struct fireman__updateValidityTime), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateValidityTime * SOAP_FMAC6 soap_new_fireman__updateValidityTime(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateValidityTime(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateValidityTime(struct soap *soap, struct fireman__updateValidityTime *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateValidityTime * SOAP_FMAC4 soap_instantiate_fireman__updateValidityTime(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateValidityTime(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateValidityTime, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateValidityTime;
		if (size)
			*size = sizeof(struct fireman__updateValidityTime);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateValidityTime[n];
		if (size)
			*size = n * sizeof(struct fireman__updateValidityTime);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateValidityTime*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateValidityTime(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateValidityTime %p -> %p\n", q, p));
	*(struct fireman__updateValidityTime*)p = *(struct fireman__updateValidityTime*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateValidityTimeResponse(struct soap *soap, const struct fireman__updateValidityTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateValidityTimeResponse(struct soap *soap, struct fireman__updateValidityTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateValidityTimeResponse(struct soap *soap, const struct fireman__updateValidityTimeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateValidityTimeResponse);
	if (soap_out_fireman__updateValidityTimeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateValidityTimeResponse(struct soap *soap, const char *tag, int id, const struct fireman__updateValidityTimeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateValidityTimeResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateValidityTimeResponse * SOAP_FMAC4 soap_get_fireman__updateValidityTimeResponse(struct soap *soap, struct fireman__updateValidityTimeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateValidityTimeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateValidityTimeResponse * SOAP_FMAC4 soap_in_fireman__updateValidityTimeResponse(struct soap *soap, const char *tag, struct fireman__updateValidityTimeResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateValidityTimeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateValidityTimeResponse, sizeof(struct fireman__updateValidityTimeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateValidityTimeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateValidityTimeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateValidityTimeResponse, 0, sizeof(struct fireman__updateValidityTimeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateValidityTimeResponse * SOAP_FMAC6 soap_new_fireman__updateValidityTimeResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateValidityTimeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateValidityTimeResponse(struct soap *soap, struct fireman__updateValidityTimeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateValidityTimeResponse * SOAP_FMAC4 soap_instantiate_fireman__updateValidityTimeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateValidityTimeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateValidityTimeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateValidityTimeResponse;
		if (size)
			*size = sizeof(struct fireman__updateValidityTimeResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateValidityTimeResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__updateValidityTimeResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateValidityTimeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateValidityTimeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateValidityTimeResponse %p -> %p\n", q, p));
	*(struct fireman__updateValidityTimeResponse*)p = *(struct fireman__updateValidityTimeResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateModifyTime(struct soap *soap, const struct fireman__updateModifyTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateModifyTime(struct soap *soap, struct fireman__updateModifyTime *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
	soap_default_LONG64(soap, &a->_time);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateModifyTime(struct soap *soap, const struct fireman__updateModifyTime *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateModifyTime);
	if (soap_out_fireman__updateModifyTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateModifyTime(struct soap *soap, const char *tag, int id, const struct fireman__updateModifyTime *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateModifyTime), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_out_LONG64(soap, "time", -1, &a->_time, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateModifyTime * SOAP_FMAC4 soap_get_fireman__updateModifyTime(struct soap *soap, struct fireman__updateModifyTime *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateModifyTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateModifyTime * SOAP_FMAC4 soap_in_fireman__updateModifyTime(struct soap *soap, const char *tag, struct fireman__updateModifyTime *a, const char *type)
{
	short soap_flag__lfns = 1, soap_flag__time = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateModifyTime *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateModifyTime, sizeof(struct fireman__updateModifyTime), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateModifyTime(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap_flag__time && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_time, "xsd:long"))
				{	soap_flag__time--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__time > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateModifyTime *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateModifyTime, 0, sizeof(struct fireman__updateModifyTime), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateModifyTime * SOAP_FMAC6 soap_new_fireman__updateModifyTime(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateModifyTime(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateModifyTime(struct soap *soap, struct fireman__updateModifyTime *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateModifyTime * SOAP_FMAC4 soap_instantiate_fireman__updateModifyTime(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateModifyTime(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateModifyTime, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateModifyTime;
		if (size)
			*size = sizeof(struct fireman__updateModifyTime);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateModifyTime[n];
		if (size)
			*size = n * sizeof(struct fireman__updateModifyTime);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateModifyTime*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateModifyTime(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateModifyTime %p -> %p\n", q, p));
	*(struct fireman__updateModifyTime*)p = *(struct fireman__updateModifyTime*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__updateModifyTimeResponse(struct soap *soap, const struct fireman__updateModifyTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__updateModifyTimeResponse(struct soap *soap, struct fireman__updateModifyTimeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__updateModifyTimeResponse(struct soap *soap, const struct fireman__updateModifyTimeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__updateModifyTimeResponse);
	if (soap_out_fireman__updateModifyTimeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__updateModifyTimeResponse(struct soap *soap, const char *tag, int id, const struct fireman__updateModifyTimeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__updateModifyTimeResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__updateModifyTimeResponse * SOAP_FMAC4 soap_get_fireman__updateModifyTimeResponse(struct soap *soap, struct fireman__updateModifyTimeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__updateModifyTimeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__updateModifyTimeResponse * SOAP_FMAC4 soap_in_fireman__updateModifyTimeResponse(struct soap *soap, const char *tag, struct fireman__updateModifyTimeResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__updateModifyTimeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__updateModifyTimeResponse, sizeof(struct fireman__updateModifyTimeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__updateModifyTimeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__updateModifyTimeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__updateModifyTimeResponse, 0, sizeof(struct fireman__updateModifyTimeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__updateModifyTimeResponse * SOAP_FMAC6 soap_new_fireman__updateModifyTimeResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__updateModifyTimeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__updateModifyTimeResponse(struct soap *soap, struct fireman__updateModifyTimeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__updateModifyTimeResponse * SOAP_FMAC4 soap_instantiate_fireman__updateModifyTimeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__updateModifyTimeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__updateModifyTimeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__updateModifyTimeResponse;
		if (size)
			*size = sizeof(struct fireman__updateModifyTimeResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__updateModifyTimeResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__updateModifyTimeResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__updateModifyTimeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__updateModifyTimeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__updateModifyTimeResponse %p -> %p\n", q, p));
	*(struct fireman__updateModifyTimeResponse*)p = *(struct fireman__updateModifyTimeResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__mv(struct soap *soap, const struct fireman__mv *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_entries);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__mv(struct soap *soap, struct fireman__mv *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_entries = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__mv(struct soap *soap, const struct fireman__mv *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__mv);
	if (soap_out_fireman__mv(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__mv(struct soap *soap, const char *tag, int id, const struct fireman__mv *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__mv), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "entries", -1, &a->_entries, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__mv * SOAP_FMAC4 soap_get_fireman__mv(struct soap *soap, struct fireman__mv *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__mv(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__mv * SOAP_FMAC4 soap_in_fireman__mv(struct soap *soap, const char *tag, struct fireman__mv *a, const char *type)
{
	short soap_flag__entries = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__mv *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__mv, sizeof(struct fireman__mv), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__mv(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__entries && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_entries, "glite:StringPair"))
				{	soap_flag__entries--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__mv *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__mv, 0, sizeof(struct fireman__mv), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__mv * SOAP_FMAC6 soap_new_fireman__mv(struct soap *soap, int n)
{	return soap_instantiate_fireman__mv(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__mv(struct soap *soap, struct fireman__mv *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__mv * SOAP_FMAC4 soap_instantiate_fireman__mv(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__mv(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__mv, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__mv;
		if (size)
			*size = sizeof(struct fireman__mv);
	}
	else
	{	cp->ptr = (void*)new struct fireman__mv[n];
		if (size)
			*size = n * sizeof(struct fireman__mv);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__mv*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__mv(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__mv %p -> %p\n", q, p));
	*(struct fireman__mv*)p = *(struct fireman__mv*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__mvResponse(struct soap *soap, const struct fireman__mvResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__mvResponse(struct soap *soap, struct fireman__mvResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__mvResponse(struct soap *soap, const struct fireman__mvResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__mvResponse);
	if (soap_out_fireman__mvResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__mvResponse(struct soap *soap, const char *tag, int id, const struct fireman__mvResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__mvResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__mvResponse * SOAP_FMAC4 soap_get_fireman__mvResponse(struct soap *soap, struct fireman__mvResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__mvResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__mvResponse * SOAP_FMAC4 soap_in_fireman__mvResponse(struct soap *soap, const char *tag, struct fireman__mvResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__mvResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__mvResponse, sizeof(struct fireman__mvResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__mvResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__mvResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__mvResponse, 0, sizeof(struct fireman__mvResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__mvResponse * SOAP_FMAC6 soap_new_fireman__mvResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__mvResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__mvResponse(struct soap *soap, struct fireman__mvResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__mvResponse * SOAP_FMAC4 soap_instantiate_fireman__mvResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__mvResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__mvResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__mvResponse;
		if (size)
			*size = sizeof(struct fireman__mvResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__mvResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__mvResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__mvResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__mvResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__mvResponse %p -> %p\n", q, p));
	*(struct fireman__mvResponse*)p = *(struct fireman__mvResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__unlink(struct soap *soap, const struct fireman__unlink *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__unlink(struct soap *soap, struct fireman__unlink *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__unlink(struct soap *soap, const struct fireman__unlink *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__unlink);
	if (soap_out_fireman__unlink(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__unlink(struct soap *soap, const char *tag, int id, const struct fireman__unlink *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__unlink), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__unlink * SOAP_FMAC4 soap_get_fireman__unlink(struct soap *soap, struct fireman__unlink *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__unlink(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__unlink * SOAP_FMAC4 soap_in_fireman__unlink(struct soap *soap, const char *tag, struct fireman__unlink *a, const char *type)
{
	short soap_flag__lfns = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__unlink *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__unlink, sizeof(struct fireman__unlink), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__unlink(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__unlink *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__unlink, 0, sizeof(struct fireman__unlink), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__unlink * SOAP_FMAC6 soap_new_fireman__unlink(struct soap *soap, int n)
{	return soap_instantiate_fireman__unlink(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__unlink(struct soap *soap, struct fireman__unlink *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__unlink * SOAP_FMAC4 soap_instantiate_fireman__unlink(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__unlink(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__unlink, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__unlink;
		if (size)
			*size = sizeof(struct fireman__unlink);
	}
	else
	{	cp->ptr = (void*)new struct fireman__unlink[n];
		if (size)
			*size = n * sizeof(struct fireman__unlink);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__unlink*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__unlink(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__unlink %p -> %p\n", q, p));
	*(struct fireman__unlink*)p = *(struct fireman__unlink*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__unlinkResponse(struct soap *soap, const struct fireman__unlinkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__unlinkResponse(struct soap *soap, struct fireman__unlinkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__unlinkResponse(struct soap *soap, const struct fireman__unlinkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__unlinkResponse);
	if (soap_out_fireman__unlinkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__unlinkResponse(struct soap *soap, const char *tag, int id, const struct fireman__unlinkResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__unlinkResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__unlinkResponse * SOAP_FMAC4 soap_get_fireman__unlinkResponse(struct soap *soap, struct fireman__unlinkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__unlinkResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__unlinkResponse * SOAP_FMAC4 soap_in_fireman__unlinkResponse(struct soap *soap, const char *tag, struct fireman__unlinkResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__unlinkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__unlinkResponse, sizeof(struct fireman__unlinkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__unlinkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__unlinkResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__unlinkResponse, 0, sizeof(struct fireman__unlinkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__unlinkResponse * SOAP_FMAC6 soap_new_fireman__unlinkResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__unlinkResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__unlinkResponse(struct soap *soap, struct fireman__unlinkResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__unlinkResponse * SOAP_FMAC4 soap_instantiate_fireman__unlinkResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__unlinkResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__unlinkResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__unlinkResponse;
		if (size)
			*size = sizeof(struct fireman__unlinkResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__unlinkResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__unlinkResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__unlinkResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__unlinkResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__unlinkResponse %p -> %p\n", q, p));
	*(struct fireman__unlinkResponse*)p = *(struct fireman__unlinkResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__createFile(struct soap *soap, const struct fireman__createFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, &a->_entries);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__createFile(struct soap *soap, struct fireman__createFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_entries = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__createFile(struct soap *soap, const struct fireman__createFile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__createFile);
	if (soap_out_fireman__createFile(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__createFile(struct soap *soap, const char *tag, int id, const struct fireman__createFile *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__createFile), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, "entries", -1, &a->_entries, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__createFile * SOAP_FMAC4 soap_get_fireman__createFile(struct soap *soap, struct fireman__createFile *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__createFile(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__createFile * SOAP_FMAC4 soap_in_fireman__createFile(struct soap *soap, const char *tag, struct fireman__createFile *a, const char *type)
{
	short soap_flag__entries = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__createFile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__createFile, sizeof(struct fireman__createFile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__createFile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__entries && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, NULL, &a->_entries, "glite:FCEntry"))
				{	soap_flag__entries--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__createFile *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__createFile, 0, sizeof(struct fireman__createFile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__createFile * SOAP_FMAC6 soap_new_fireman__createFile(struct soap *soap, int n)
{	return soap_instantiate_fireman__createFile(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__createFile(struct soap *soap, struct fireman__createFile *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__createFile * SOAP_FMAC4 soap_instantiate_fireman__createFile(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__createFile(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__createFile, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__createFile;
		if (size)
			*size = sizeof(struct fireman__createFile);
	}
	else
	{	cp->ptr = (void*)new struct fireman__createFile[n];
		if (size)
			*size = n * sizeof(struct fireman__createFile);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__createFile*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__createFile(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__createFile %p -> %p\n", q, p));
	*(struct fireman__createFile*)p = *(struct fireman__createFile*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__createFileResponse(struct soap *soap, const struct fireman__createFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__createFileResponse(struct soap *soap, struct fireman__createFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__createFileResponse(struct soap *soap, const struct fireman__createFileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__createFileResponse);
	if (soap_out_fireman__createFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__createFileResponse(struct soap *soap, const char *tag, int id, const struct fireman__createFileResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__createFileResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__createFileResponse * SOAP_FMAC4 soap_get_fireman__createFileResponse(struct soap *soap, struct fireman__createFileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__createFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__createFileResponse * SOAP_FMAC4 soap_in_fireman__createFileResponse(struct soap *soap, const char *tag, struct fireman__createFileResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__createFileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__createFileResponse, sizeof(struct fireman__createFileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__createFileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__createFileResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__createFileResponse, 0, sizeof(struct fireman__createFileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__createFileResponse * SOAP_FMAC6 soap_new_fireman__createFileResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__createFileResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__createFileResponse(struct soap *soap, struct fireman__createFileResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__createFileResponse * SOAP_FMAC4 soap_instantiate_fireman__createFileResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__createFileResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__createFileResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__createFileResponse;
		if (size)
			*size = sizeof(struct fireman__createFileResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__createFileResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__createFileResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__createFileResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__createFileResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__createFileResponse %p -> %p\n", q, p));
	*(struct fireman__createFileResponse*)p = *(struct fireman__createFileResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__rmdir(struct soap *soap, const struct fireman__rmdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_directories);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__rmdir(struct soap *soap, struct fireman__rmdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_directories = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__rmdir(struct soap *soap, const struct fireman__rmdir *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__rmdir);
	if (soap_out_fireman__rmdir(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__rmdir(struct soap *soap, const char *tag, int id, const struct fireman__rmdir *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__rmdir), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "directories", -1, &a->_directories, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__rmdir * SOAP_FMAC4 soap_get_fireman__rmdir(struct soap *soap, struct fireman__rmdir *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__rmdir(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__rmdir * SOAP_FMAC4 soap_in_fireman__rmdir(struct soap *soap, const char *tag, struct fireman__rmdir *a, const char *type)
{
	short soap_flag__directories = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__rmdir *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__rmdir, sizeof(struct fireman__rmdir), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__rmdir(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__directories && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_directories, "xsd:string"))
				{	soap_flag__directories--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__rmdir *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__rmdir, 0, sizeof(struct fireman__rmdir), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__rmdir * SOAP_FMAC6 soap_new_fireman__rmdir(struct soap *soap, int n)
{	return soap_instantiate_fireman__rmdir(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__rmdir(struct soap *soap, struct fireman__rmdir *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__rmdir * SOAP_FMAC4 soap_instantiate_fireman__rmdir(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__rmdir(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__rmdir, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__rmdir;
		if (size)
			*size = sizeof(struct fireman__rmdir);
	}
	else
	{	cp->ptr = (void*)new struct fireman__rmdir[n];
		if (size)
			*size = n * sizeof(struct fireman__rmdir);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__rmdir*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__rmdir(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__rmdir %p -> %p\n", q, p));
	*(struct fireman__rmdir*)p = *(struct fireman__rmdir*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__rmdirResponse(struct soap *soap, const struct fireman__rmdirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__rmdirResponse(struct soap *soap, struct fireman__rmdirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__rmdirResponse(struct soap *soap, const struct fireman__rmdirResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__rmdirResponse);
	if (soap_out_fireman__rmdirResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__rmdirResponse(struct soap *soap, const char *tag, int id, const struct fireman__rmdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__rmdirResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__rmdirResponse * SOAP_FMAC4 soap_get_fireman__rmdirResponse(struct soap *soap, struct fireman__rmdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__rmdirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__rmdirResponse * SOAP_FMAC4 soap_in_fireman__rmdirResponse(struct soap *soap, const char *tag, struct fireman__rmdirResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__rmdirResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__rmdirResponse, sizeof(struct fireman__rmdirResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__rmdirResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__rmdirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__rmdirResponse, 0, sizeof(struct fireman__rmdirResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__rmdirResponse * SOAP_FMAC6 soap_new_fireman__rmdirResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__rmdirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__rmdirResponse(struct soap *soap, struct fireman__rmdirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__rmdirResponse * SOAP_FMAC4 soap_instantiate_fireman__rmdirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__rmdirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__rmdirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__rmdirResponse;
		if (size)
			*size = sizeof(struct fireman__rmdirResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__rmdirResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__rmdirResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__rmdirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__rmdirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__rmdirResponse %p -> %p\n", q, p));
	*(struct fireman__rmdirResponse*)p = *(struct fireman__rmdirResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__symlink(struct soap *soap, const struct fireman__symlink *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_symlinks);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__symlink(struct soap *soap, struct fireman__symlink *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_symlinks = NULL;
	soap_default_bool(soap, &a->_copyPermFromParent);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__symlink(struct soap *soap, const struct fireman__symlink *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__symlink);
	if (soap_out_fireman__symlink(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__symlink(struct soap *soap, const char *tag, int id, const struct fireman__symlink *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__symlink), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "symlinks", -1, &a->_symlinks, "");
	soap_out_bool(soap, "copyPermFromParent", -1, &a->_copyPermFromParent, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__symlink * SOAP_FMAC4 soap_get_fireman__symlink(struct soap *soap, struct fireman__symlink *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__symlink(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__symlink * SOAP_FMAC4 soap_in_fireman__symlink(struct soap *soap, const char *tag, struct fireman__symlink *a, const char *type)
{
	short soap_flag__symlinks = 1, soap_flag__copyPermFromParent = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__symlink *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__symlink, sizeof(struct fireman__symlink), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__symlink(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__symlinks && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_symlinks, "glite:StringPair"))
				{	soap_flag__symlinks--;
					continue;
				}
			if (soap_flag__copyPermFromParent && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_copyPermFromParent, "xsd:boolean"))
				{	soap_flag__copyPermFromParent--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__copyPermFromParent > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__symlink *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__symlink, 0, sizeof(struct fireman__symlink), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__symlink * SOAP_FMAC6 soap_new_fireman__symlink(struct soap *soap, int n)
{	return soap_instantiate_fireman__symlink(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__symlink(struct soap *soap, struct fireman__symlink *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__symlink * SOAP_FMAC4 soap_instantiate_fireman__symlink(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__symlink(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__symlink, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__symlink;
		if (size)
			*size = sizeof(struct fireman__symlink);
	}
	else
	{	cp->ptr = (void*)new struct fireman__symlink[n];
		if (size)
			*size = n * sizeof(struct fireman__symlink);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__symlink*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__symlink(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__symlink %p -> %p\n", q, p));
	*(struct fireman__symlink*)p = *(struct fireman__symlink*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__symlinkResponse(struct soap *soap, const struct fireman__symlinkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__symlinkResponse(struct soap *soap, struct fireman__symlinkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__symlinkResponse(struct soap *soap, const struct fireman__symlinkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__symlinkResponse);
	if (soap_out_fireman__symlinkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__symlinkResponse(struct soap *soap, const char *tag, int id, const struct fireman__symlinkResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__symlinkResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__symlinkResponse * SOAP_FMAC4 soap_get_fireman__symlinkResponse(struct soap *soap, struct fireman__symlinkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__symlinkResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__symlinkResponse * SOAP_FMAC4 soap_in_fireman__symlinkResponse(struct soap *soap, const char *tag, struct fireman__symlinkResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__symlinkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__symlinkResponse, sizeof(struct fireman__symlinkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__symlinkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__symlinkResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__symlinkResponse, 0, sizeof(struct fireman__symlinkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__symlinkResponse * SOAP_FMAC6 soap_new_fireman__symlinkResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__symlinkResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__symlinkResponse(struct soap *soap, struct fireman__symlinkResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__symlinkResponse * SOAP_FMAC4 soap_instantiate_fireman__symlinkResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__symlinkResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__symlinkResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__symlinkResponse;
		if (size)
			*size = sizeof(struct fireman__symlinkResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__symlinkResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__symlinkResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__symlinkResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__symlinkResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__symlinkResponse %p -> %p\n", q, p));
	*(struct fireman__symlinkResponse*)p = *(struct fireman__symlinkResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__locate(struct soap *soap, const struct fireman__locate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_startDir);
	soap_serialize_string(soap, &a->_pattern);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__locate(struct soap *soap, struct fireman__locate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_startDir);
	soap_default_string(soap, &a->_pattern);
	soap_default_LONG64(soap, &a->_limit);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__locate(struct soap *soap, const struct fireman__locate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__locate);
	if (soap_out_fireman__locate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__locate(struct soap *soap, const char *tag, int id, const struct fireman__locate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__locate), type);
	soap_out_string(soap, "startDir", -1, &a->_startDir, "");
	soap_out_string(soap, "pattern", -1, &a->_pattern, "");
	soap_out_LONG64(soap, "limit", -1, &a->_limit, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__locate * SOAP_FMAC4 soap_get_fireman__locate(struct soap *soap, struct fireman__locate *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__locate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__locate * SOAP_FMAC4 soap_in_fireman__locate(struct soap *soap, const char *tag, struct fireman__locate *a, const char *type)
{
	short soap_flag__startDir = 1, soap_flag__pattern = 1, soap_flag__limit = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__locate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__locate, sizeof(struct fireman__locate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__locate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__startDir && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_startDir, "xsd:string"))
				{	soap_flag__startDir--;
					continue;
				}
			if (soap_flag__pattern && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_pattern, "xsd:string"))
				{	soap_flag__pattern--;
					continue;
				}
			if (soap_flag__limit && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_limit, "xsd:long"))
				{	soap_flag__limit--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__limit > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__locate *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__locate, 0, sizeof(struct fireman__locate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__locate * SOAP_FMAC6 soap_new_fireman__locate(struct soap *soap, int n)
{	return soap_instantiate_fireman__locate(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__locate(struct soap *soap, struct fireman__locate *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__locate * SOAP_FMAC4 soap_instantiate_fireman__locate(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__locate(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__locate, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__locate;
		if (size)
			*size = sizeof(struct fireman__locate);
	}
	else
	{	cp->ptr = (void*)new struct fireman__locate[n];
		if (size)
			*size = n * sizeof(struct fireman__locate);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__locate*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__locate(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__locate %p -> %p\n", q, p));
	*(struct fireman__locate*)p = *(struct fireman__locate*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__locateResponse(struct soap *soap, const struct fireman__locateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_locateReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__locateResponse(struct soap *soap, struct fireman__locateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_locateReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__locateResponse(struct soap *soap, const struct fireman__locateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__locateResponse);
	if (soap_out_fireman__locateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__locateResponse(struct soap *soap, const char *tag, int id, const struct fireman__locateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__locateResponse), type);
	if (a->_locateReturn)
		soap_element_result(soap, "locateReturn");
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "locateReturn", -1, &a->_locateReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__locateResponse * SOAP_FMAC4 soap_get_fireman__locateResponse(struct soap *soap, struct fireman__locateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__locateResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__locateResponse * SOAP_FMAC4 soap_in_fireman__locateResponse(struct soap *soap, const char *tag, struct fireman__locateResponse *a, const char *type)
{
	short soap_flag__locateReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__locateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__locateResponse, sizeof(struct fireman__locateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__locateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__locateReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_locateReturn, "xsd:string"))
				{	soap_flag__locateReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__locateResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__locateResponse, 0, sizeof(struct fireman__locateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__locateResponse * SOAP_FMAC6 soap_new_fireman__locateResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__locateResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__locateResponse(struct soap *soap, struct fireman__locateResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__locateResponse * SOAP_FMAC4 soap_instantiate_fireman__locateResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__locateResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__locateResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__locateResponse;
		if (size)
			*size = sizeof(struct fireman__locateResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__locateResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__locateResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__locateResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__locateResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__locateResponse %p -> %p\n", q, p));
	*(struct fireman__locateResponse*)p = *(struct fireman__locateResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__mkdir(struct soap *soap, const struct fireman__mkdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_directories);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__mkdir(struct soap *soap, struct fireman__mkdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_directories = NULL;
	soap_default_bool(soap, &a->_createParents);
	soap_default_bool(soap, &a->_copyPermFromParent);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__mkdir(struct soap *soap, const struct fireman__mkdir *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__mkdir);
	if (soap_out_fireman__mkdir(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__mkdir(struct soap *soap, const char *tag, int id, const struct fireman__mkdir *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__mkdir), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "directories", -1, &a->_directories, "");
	soap_out_bool(soap, "createParents", -1, &a->_createParents, "");
	soap_out_bool(soap, "copyPermFromParent", -1, &a->_copyPermFromParent, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__mkdir * SOAP_FMAC4 soap_get_fireman__mkdir(struct soap *soap, struct fireman__mkdir *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__mkdir(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__mkdir * SOAP_FMAC4 soap_in_fireman__mkdir(struct soap *soap, const char *tag, struct fireman__mkdir *a, const char *type)
{
	short soap_flag__directories = 1, soap_flag__createParents = 1, soap_flag__copyPermFromParent = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__mkdir *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__mkdir, sizeof(struct fireman__mkdir), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__mkdir(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__directories && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_directories, "xsd:string"))
				{	soap_flag__directories--;
					continue;
				}
			if (soap_flag__createParents && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_createParents, "xsd:boolean"))
				{	soap_flag__createParents--;
					continue;
				}
			if (soap_flag__copyPermFromParent && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_copyPermFromParent, "xsd:boolean"))
				{	soap_flag__copyPermFromParent--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__createParents > 0 || soap_flag__copyPermFromParent > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__mkdir *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__mkdir, 0, sizeof(struct fireman__mkdir), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__mkdir * SOAP_FMAC6 soap_new_fireman__mkdir(struct soap *soap, int n)
{	return soap_instantiate_fireman__mkdir(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__mkdir(struct soap *soap, struct fireman__mkdir *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__mkdir * SOAP_FMAC4 soap_instantiate_fireman__mkdir(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__mkdir(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__mkdir, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__mkdir;
		if (size)
			*size = sizeof(struct fireman__mkdir);
	}
	else
	{	cp->ptr = (void*)new struct fireman__mkdir[n];
		if (size)
			*size = n * sizeof(struct fireman__mkdir);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__mkdir*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__mkdir(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__mkdir %p -> %p\n", q, p));
	*(struct fireman__mkdir*)p = *(struct fireman__mkdir*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__mkdirResponse(struct soap *soap, const struct fireman__mkdirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__mkdirResponse(struct soap *soap, struct fireman__mkdirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__mkdirResponse(struct soap *soap, const struct fireman__mkdirResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__mkdirResponse);
	if (soap_out_fireman__mkdirResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__mkdirResponse(struct soap *soap, const char *tag, int id, const struct fireman__mkdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__mkdirResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__mkdirResponse * SOAP_FMAC4 soap_get_fireman__mkdirResponse(struct soap *soap, struct fireman__mkdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__mkdirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__mkdirResponse * SOAP_FMAC4 soap_in_fireman__mkdirResponse(struct soap *soap, const char *tag, struct fireman__mkdirResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__mkdirResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__mkdirResponse, sizeof(struct fireman__mkdirResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__mkdirResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__mkdirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__mkdirResponse, 0, sizeof(struct fireman__mkdirResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__mkdirResponse * SOAP_FMAC6 soap_new_fireman__mkdirResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__mkdirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__mkdirResponse(struct soap *soap, struct fireman__mkdirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__mkdirResponse * SOAP_FMAC4 soap_instantiate_fireman__mkdirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__mkdirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__mkdirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__mkdirResponse;
		if (size)
			*size = sizeof(struct fireman__mkdirResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__mkdirResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__mkdirResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__mkdirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__mkdirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__mkdirResponse %p -> %p\n", q, p));
	*(struct fireman__mkdirResponse*)p = *(struct fireman__mkdirResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__associateDirWithSchema(struct soap *soap, const struct fireman__associateDirWithSchema *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_directoryLfn);
	soap_serialize_string(soap, &a->_schemaName);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__associateDirWithSchema(struct soap *soap, struct fireman__associateDirWithSchema *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_directoryLfn);
	soap_default_string(soap, &a->_schemaName);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__associateDirWithSchema(struct soap *soap, const struct fireman__associateDirWithSchema *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__associateDirWithSchema);
	if (soap_out_fireman__associateDirWithSchema(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__associateDirWithSchema(struct soap *soap, const char *tag, int id, const struct fireman__associateDirWithSchema *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__associateDirWithSchema), type);
	soap_out_string(soap, "directoryLfn", -1, &a->_directoryLfn, "");
	soap_out_string(soap, "schemaName", -1, &a->_schemaName, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__associateDirWithSchema * SOAP_FMAC4 soap_get_fireman__associateDirWithSchema(struct soap *soap, struct fireman__associateDirWithSchema *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__associateDirWithSchema(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__associateDirWithSchema * SOAP_FMAC4 soap_in_fireman__associateDirWithSchema(struct soap *soap, const char *tag, struct fireman__associateDirWithSchema *a, const char *type)
{
	short soap_flag__directoryLfn = 1, soap_flag__schemaName = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__associateDirWithSchema *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__associateDirWithSchema, sizeof(struct fireman__associateDirWithSchema), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__associateDirWithSchema(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__directoryLfn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_directoryLfn, "xsd:string"))
				{	soap_flag__directoryLfn--;
					continue;
				}
			if (soap_flag__schemaName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_schemaName, "xsd:string"))
				{	soap_flag__schemaName--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__associateDirWithSchema *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__associateDirWithSchema, 0, sizeof(struct fireman__associateDirWithSchema), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__associateDirWithSchema * SOAP_FMAC6 soap_new_fireman__associateDirWithSchema(struct soap *soap, int n)
{	return soap_instantiate_fireman__associateDirWithSchema(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__associateDirWithSchema(struct soap *soap, struct fireman__associateDirWithSchema *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__associateDirWithSchema * SOAP_FMAC4 soap_instantiate_fireman__associateDirWithSchema(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__associateDirWithSchema(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__associateDirWithSchema, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__associateDirWithSchema;
		if (size)
			*size = sizeof(struct fireman__associateDirWithSchema);
	}
	else
	{	cp->ptr = (void*)new struct fireman__associateDirWithSchema[n];
		if (size)
			*size = n * sizeof(struct fireman__associateDirWithSchema);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__associateDirWithSchema*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__associateDirWithSchema(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__associateDirWithSchema %p -> %p\n", q, p));
	*(struct fireman__associateDirWithSchema*)p = *(struct fireman__associateDirWithSchema*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__associateDirWithSchemaResponse(struct soap *soap, const struct fireman__associateDirWithSchemaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__associateDirWithSchemaResponse(struct soap *soap, struct fireman__associateDirWithSchemaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__associateDirWithSchemaResponse(struct soap *soap, const struct fireman__associateDirWithSchemaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__associateDirWithSchemaResponse);
	if (soap_out_fireman__associateDirWithSchemaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__associateDirWithSchemaResponse(struct soap *soap, const char *tag, int id, const struct fireman__associateDirWithSchemaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__associateDirWithSchemaResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__associateDirWithSchemaResponse * SOAP_FMAC4 soap_get_fireman__associateDirWithSchemaResponse(struct soap *soap, struct fireman__associateDirWithSchemaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__associateDirWithSchemaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__associateDirWithSchemaResponse * SOAP_FMAC4 soap_in_fireman__associateDirWithSchemaResponse(struct soap *soap, const char *tag, struct fireman__associateDirWithSchemaResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__associateDirWithSchemaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__associateDirWithSchemaResponse, sizeof(struct fireman__associateDirWithSchemaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__associateDirWithSchemaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__associateDirWithSchemaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__associateDirWithSchemaResponse, 0, sizeof(struct fireman__associateDirWithSchemaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__associateDirWithSchemaResponse * SOAP_FMAC6 soap_new_fireman__associateDirWithSchemaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__associateDirWithSchemaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__associateDirWithSchemaResponse(struct soap *soap, struct fireman__associateDirWithSchemaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__associateDirWithSchemaResponse * SOAP_FMAC4 soap_instantiate_fireman__associateDirWithSchemaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__associateDirWithSchemaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__associateDirWithSchemaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__associateDirWithSchemaResponse;
		if (size)
			*size = sizeof(struct fireman__associateDirWithSchemaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__associateDirWithSchemaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__associateDirWithSchemaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__associateDirWithSchemaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__associateDirWithSchemaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__associateDirWithSchemaResponse %p -> %p\n", q, p));
	*(struct fireman__associateDirWithSchemaResponse*)p = *(struct fireman__associateDirWithSchemaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeReplica(struct soap *soap, const struct fireman__removeReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_lfnSurls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeReplica(struct soap *soap, struct fireman__removeReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfnSurls = NULL;
	soap_default_bool(soap, &a->_removeLfnOnLastReplica);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeReplica(struct soap *soap, const struct fireman__removeReplica *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeReplica);
	if (soap_out_fireman__removeReplica(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeReplica(struct soap *soap, const char *tag, int id, const struct fireman__removeReplica *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeReplica), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "lfnSurls", -1, &a->_lfnSurls, "");
	soap_out_bool(soap, "removeLfnOnLastReplica", -1, &a->_removeLfnOnLastReplica, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeReplica * SOAP_FMAC4 soap_get_fireman__removeReplica(struct soap *soap, struct fireman__removeReplica *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeReplica(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeReplica * SOAP_FMAC4 soap_in_fireman__removeReplica(struct soap *soap, const char *tag, struct fireman__removeReplica *a, const char *type)
{
	short soap_flag__lfnSurls = 1, soap_flag__removeLfnOnLastReplica = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeReplica *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeReplica, sizeof(struct fireman__removeReplica), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeReplica(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfnSurls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_lfnSurls, "glite:StringPair"))
				{	soap_flag__lfnSurls--;
					continue;
				}
			if (soap_flag__removeLfnOnLastReplica && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_removeLfnOnLastReplica, "xsd:boolean"))
				{	soap_flag__removeLfnOnLastReplica--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__removeLfnOnLastReplica > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeReplica *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeReplica, 0, sizeof(struct fireman__removeReplica), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeReplica * SOAP_FMAC6 soap_new_fireman__removeReplica(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeReplica(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeReplica(struct soap *soap, struct fireman__removeReplica *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeReplica * SOAP_FMAC4 soap_instantiate_fireman__removeReplica(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeReplica(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeReplica, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeReplica;
		if (size)
			*size = sizeof(struct fireman__removeReplica);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeReplica[n];
		if (size)
			*size = n * sizeof(struct fireman__removeReplica);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeReplica*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeReplica(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeReplica %p -> %p\n", q, p));
	*(struct fireman__removeReplica*)p = *(struct fireman__removeReplica*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeReplicaResponse(struct soap *soap, const struct fireman__removeReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeReplicaResponse(struct soap *soap, struct fireman__removeReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeReplicaResponse(struct soap *soap, const struct fireman__removeReplicaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeReplicaResponse);
	if (soap_out_fireman__removeReplicaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeReplicaResponse(struct soap *soap, const char *tag, int id, const struct fireman__removeReplicaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeReplicaResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeReplicaResponse * SOAP_FMAC4 soap_get_fireman__removeReplicaResponse(struct soap *soap, struct fireman__removeReplicaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeReplicaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeReplicaResponse * SOAP_FMAC4 soap_in_fireman__removeReplicaResponse(struct soap *soap, const char *tag, struct fireman__removeReplicaResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeReplicaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeReplicaResponse, sizeof(struct fireman__removeReplicaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeReplicaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeReplicaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeReplicaResponse, 0, sizeof(struct fireman__removeReplicaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeReplicaResponse * SOAP_FMAC6 soap_new_fireman__removeReplicaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeReplicaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeReplicaResponse(struct soap *soap, struct fireman__removeReplicaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeReplicaResponse * SOAP_FMAC4 soap_instantiate_fireman__removeReplicaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeReplicaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeReplicaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeReplicaResponse;
		if (size)
			*size = sizeof(struct fireman__removeReplicaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeReplicaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__removeReplicaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeReplicaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeReplicaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeReplicaResponse %p -> %p\n", q, p));
	*(struct fireman__removeReplicaResponse*)p = *(struct fireman__removeReplicaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__addReplica(struct soap *soap, const struct fireman__addReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_lfn);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, &a->_newSurls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__addReplica(struct soap *soap, struct fireman__addReplica *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_lfn);
	a->_newSurls = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__addReplica(struct soap *soap, const struct fireman__addReplica *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__addReplica);
	if (soap_out_fireman__addReplica(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__addReplica(struct soap *soap, const char *tag, int id, const struct fireman__addReplica *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__addReplica), type);
	soap_out_string(soap, "lfn", -1, &a->_lfn, "");
	soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, "newSurls", -1, &a->_newSurls, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__addReplica * SOAP_FMAC4 soap_get_fireman__addReplica(struct soap *soap, struct fireman__addReplica *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__addReplica(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__addReplica * SOAP_FMAC4 soap_in_fireman__addReplica(struct soap *soap, const char *tag, struct fireman__addReplica *a, const char *type)
{
	short soap_flag__lfn = 1, soap_flag__newSurls = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__addReplica *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__addReplica, sizeof(struct fireman__addReplica), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__addReplica(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_lfn, "xsd:string"))
				{	soap_flag__lfn--;
					continue;
				}
			if (soap_flag__newSurls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, NULL, &a->_newSurls, "glite:SURLEntry"))
				{	soap_flag__newSurls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__addReplica *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__addReplica, 0, sizeof(struct fireman__addReplica), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__addReplica * SOAP_FMAC6 soap_new_fireman__addReplica(struct soap *soap, int n)
{	return soap_instantiate_fireman__addReplica(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__addReplica(struct soap *soap, struct fireman__addReplica *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__addReplica * SOAP_FMAC4 soap_instantiate_fireman__addReplica(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__addReplica(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__addReplica, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__addReplica;
		if (size)
			*size = sizeof(struct fireman__addReplica);
	}
	else
	{	cp->ptr = (void*)new struct fireman__addReplica[n];
		if (size)
			*size = n * sizeof(struct fireman__addReplica);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__addReplica*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__addReplica(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__addReplica %p -> %p\n", q, p));
	*(struct fireman__addReplica*)p = *(struct fireman__addReplica*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__addReplicaResponse(struct soap *soap, const struct fireman__addReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__addReplicaResponse(struct soap *soap, struct fireman__addReplicaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__addReplicaResponse(struct soap *soap, const struct fireman__addReplicaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__addReplicaResponse);
	if (soap_out_fireman__addReplicaResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__addReplicaResponse(struct soap *soap, const char *tag, int id, const struct fireman__addReplicaResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__addReplicaResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__addReplicaResponse * SOAP_FMAC4 soap_get_fireman__addReplicaResponse(struct soap *soap, struct fireman__addReplicaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__addReplicaResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__addReplicaResponse * SOAP_FMAC4 soap_in_fireman__addReplicaResponse(struct soap *soap, const char *tag, struct fireman__addReplicaResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__addReplicaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__addReplicaResponse, sizeof(struct fireman__addReplicaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__addReplicaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__addReplicaResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__addReplicaResponse, 0, sizeof(struct fireman__addReplicaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__addReplicaResponse * SOAP_FMAC6 soap_new_fireman__addReplicaResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__addReplicaResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__addReplicaResponse(struct soap *soap, struct fireman__addReplicaResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__addReplicaResponse * SOAP_FMAC4 soap_instantiate_fireman__addReplicaResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__addReplicaResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__addReplicaResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__addReplicaResponse;
		if (size)
			*size = sizeof(struct fireman__addReplicaResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__addReplicaResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__addReplicaResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__addReplicaResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__addReplicaResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__addReplicaResponse %p -> %p\n", q, p));
	*(struct fireman__addReplicaResponse*)p = *(struct fireman__addReplicaResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getStat(struct soap *soap, const struct fireman__getStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getStat(struct soap *soap, struct fireman__getStat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getStat(struct soap *soap, const struct fireman__getStat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getStat);
	if (soap_out_fireman__getStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getStat(struct soap *soap, const char *tag, int id, const struct fireman__getStat *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getStat), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getStat * SOAP_FMAC4 soap_get_fireman__getStat(struct soap *soap, struct fireman__getStat *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getStat * SOAP_FMAC4 soap_in_fireman__getStat(struct soap *soap, const char *tag, struct fireman__getStat *a, const char *type)
{
	short soap_flag__lfns = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getStat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getStat, sizeof(struct fireman__getStat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getStat(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getStat *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getStat, 0, sizeof(struct fireman__getStat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getStat * SOAP_FMAC6 soap_new_fireman__getStat(struct soap *soap, int n)
{	return soap_instantiate_fireman__getStat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getStat(struct soap *soap, struct fireman__getStat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getStat * SOAP_FMAC4 soap_instantiate_fireman__getStat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getStat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getStat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getStat;
		if (size)
			*size = sizeof(struct fireman__getStat);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getStat[n];
		if (size)
			*size = n * sizeof(struct fireman__getStat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getStat*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getStat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getStat %p -> %p\n", q, p));
	*(struct fireman__getStat*)p = *(struct fireman__getStat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__getStatResponse(struct soap *soap, const struct fireman__getStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStat(soap, &a->_getStatReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__getStatResponse(struct soap *soap, struct fireman__getStatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getStatReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__getStatResponse(struct soap *soap, const struct fireman__getStatResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__getStatResponse);
	if (soap_out_fireman__getStatResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__getStatResponse(struct soap *soap, const char *tag, int id, const struct fireman__getStatResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__getStatResponse), type);
	if (a->_getStatReturn)
		soap_element_result(soap, "getStatReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStat(soap, "getStatReturn", -1, &a->_getStatReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__getStatResponse * SOAP_FMAC4 soap_get_fireman__getStatResponse(struct soap *soap, struct fireman__getStatResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__getStatResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__getStatResponse * SOAP_FMAC4 soap_in_fireman__getStatResponse(struct soap *soap, const char *tag, struct fireman__getStatResponse *a, const char *type)
{
	short soap_flag__getStatReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__getStatResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__getStatResponse, sizeof(struct fireman__getStatResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__getStatResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getStatReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStat(soap, NULL, &a->_getStatReturn, "glite:Stat"))
				{	soap_flag__getStatReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__getStatResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__getStatResponse, 0, sizeof(struct fireman__getStatResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__getStatResponse * SOAP_FMAC6 soap_new_fireman__getStatResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__getStatResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__getStatResponse(struct soap *soap, struct fireman__getStatResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__getStatResponse * SOAP_FMAC4 soap_instantiate_fireman__getStatResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__getStatResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__getStatResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__getStatResponse;
		if (size)
			*size = sizeof(struct fireman__getStatResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__getStatResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__getStatResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__getStatResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__getStatResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__getStatResponse %p -> %p\n", q, p));
	*(struct fireman__getStatResponse*)p = *(struct fireman__getStatResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listLfn(struct soap *soap, const struct fireman__listLfn *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_surls);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listLfn(struct soap *soap, struct fireman__listLfn *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_surls = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listLfn(struct soap *soap, const struct fireman__listLfn *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listLfn);
	if (soap_out_fireman__listLfn(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listLfn(struct soap *soap, const char *tag, int id, const struct fireman__listLfn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listLfn), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "surls", -1, &a->_surls, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listLfn * SOAP_FMAC4 soap_get_fireman__listLfn(struct soap *soap, struct fireman__listLfn *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listLfn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listLfn * SOAP_FMAC4 soap_in_fireman__listLfn(struct soap *soap, const char *tag, struct fireman__listLfn *a, const char *type)
{
	short soap_flag__surls = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listLfn *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listLfn, sizeof(struct fireman__listLfn), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listLfn(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__surls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_surls, "xsd:string"))
				{	soap_flag__surls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listLfn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listLfn, 0, sizeof(struct fireman__listLfn), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listLfn * SOAP_FMAC6 soap_new_fireman__listLfn(struct soap *soap, int n)
{	return soap_instantiate_fireman__listLfn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listLfn(struct soap *soap, struct fireman__listLfn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listLfn * SOAP_FMAC4 soap_instantiate_fireman__listLfn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listLfn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listLfn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listLfn;
		if (size)
			*size = sizeof(struct fireman__listLfn);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listLfn[n];
		if (size)
			*size = n * sizeof(struct fireman__listLfn);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listLfn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listLfn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listLfn %p -> %p\n", q, p));
	*(struct fireman__listLfn*)p = *(struct fireman__listLfn*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listLfnResponse(struct soap *soap, const struct fireman__listLfnResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, &a->_listLfnReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listLfnResponse(struct soap *soap, struct fireman__listLfnResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_listLfnReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listLfnResponse(struct soap *soap, const struct fireman__listLfnResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listLfnResponse);
	if (soap_out_fireman__listLfnResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listLfnResponse(struct soap *soap, const char *tag, int id, const struct fireman__listLfnResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listLfnResponse), type);
	if (a->_listLfnReturn)
		soap_element_result(soap, "listLfnReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, "listLfnReturn", -1, &a->_listLfnReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listLfnResponse * SOAP_FMAC4 soap_get_fireman__listLfnResponse(struct soap *soap, struct fireman__listLfnResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listLfnResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listLfnResponse * SOAP_FMAC4 soap_in_fireman__listLfnResponse(struct soap *soap, const char *tag, struct fireman__listLfnResponse *a, const char *type)
{
	short soap_flag__listLfnReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listLfnResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listLfnResponse, sizeof(struct fireman__listLfnResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listLfnResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__listLfnReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, NULL, &a->_listLfnReturn, "glite:StringPair"))
				{	soap_flag__listLfnReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listLfnResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listLfnResponse, 0, sizeof(struct fireman__listLfnResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listLfnResponse * SOAP_FMAC6 soap_new_fireman__listLfnResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__listLfnResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listLfnResponse(struct soap *soap, struct fireman__listLfnResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listLfnResponse * SOAP_FMAC4 soap_instantiate_fireman__listLfnResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listLfnResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listLfnResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listLfnResponse;
		if (size)
			*size = sizeof(struct fireman__listLfnResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listLfnResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__listLfnResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listLfnResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listLfnResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listLfnResponse %p -> %p\n", q, p));
	*(struct fireman__listLfnResponse*)p = *(struct fireman__listLfnResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listReplicas(struct soap *soap, const struct fireman__listReplicas *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listReplicas(struct soap *soap, struct fireman__listReplicas *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
	soap_default_bool(soap, &a->_withPermissions);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listReplicas(struct soap *soap, const struct fireman__listReplicas *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listReplicas);
	if (soap_out_fireman__listReplicas(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listReplicas(struct soap *soap, const char *tag, int id, const struct fireman__listReplicas *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listReplicas), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_out_bool(soap, "withPermissions", -1, &a->_withPermissions, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listReplicas * SOAP_FMAC4 soap_get_fireman__listReplicas(struct soap *soap, struct fireman__listReplicas *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listReplicas(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listReplicas * SOAP_FMAC4 soap_in_fireman__listReplicas(struct soap *soap, const char *tag, struct fireman__listReplicas *a, const char *type)
{
	short soap_flag__lfns = 1, soap_flag__withPermissions = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listReplicas *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listReplicas, sizeof(struct fireman__listReplicas), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listReplicas(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap_flag__withPermissions && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_withPermissions, "xsd:boolean"))
				{	soap_flag__withPermissions--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__withPermissions > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listReplicas *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listReplicas, 0, sizeof(struct fireman__listReplicas), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listReplicas * SOAP_FMAC6 soap_new_fireman__listReplicas(struct soap *soap, int n)
{	return soap_instantiate_fireman__listReplicas(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listReplicas(struct soap *soap, struct fireman__listReplicas *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listReplicas * SOAP_FMAC4 soap_instantiate_fireman__listReplicas(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listReplicas(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listReplicas, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listReplicas;
		if (size)
			*size = sizeof(struct fireman__listReplicas);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listReplicas[n];
		if (size)
			*size = n * sizeof(struct fireman__listReplicas);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listReplicas*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listReplicas(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listReplicas %p -> %p\n", q, p));
	*(struct fireman__listReplicas*)p = *(struct fireman__listReplicas*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__listReplicasResponse(struct soap *soap, const struct fireman__listReplicasResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, &a->_listReplicasReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__listReplicasResponse(struct soap *soap, struct fireman__listReplicasResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_listReplicasReturn = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__listReplicasResponse(struct soap *soap, const struct fireman__listReplicasResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__listReplicasResponse);
	if (soap_out_fireman__listReplicasResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__listReplicasResponse(struct soap *soap, const char *tag, int id, const struct fireman__listReplicasResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__listReplicasResponse), type);
	if (a->_listReplicasReturn)
		soap_element_result(soap, "listReplicasReturn");
	soap_out_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, "listReplicasReturn", -1, &a->_listReplicasReturn, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__listReplicasResponse * SOAP_FMAC4 soap_get_fireman__listReplicasResponse(struct soap *soap, struct fireman__listReplicasResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__listReplicasResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__listReplicasResponse * SOAP_FMAC4 soap_in_fireman__listReplicasResponse(struct soap *soap, const char *tag, struct fireman__listReplicasResponse *a, const char *type)
{
	short soap_flag__listReplicasReturn = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__listReplicasResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__listReplicasResponse, sizeof(struct fireman__listReplicasResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__listReplicasResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__listReplicasReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, NULL, &a->_listReplicasReturn, "glite:FRCEntry"))
				{	soap_flag__listReplicasReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__listReplicasResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__listReplicasResponse, 0, sizeof(struct fireman__listReplicasResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__listReplicasResponse * SOAP_FMAC6 soap_new_fireman__listReplicasResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__listReplicasResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__listReplicasResponse(struct soap *soap, struct fireman__listReplicasResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__listReplicasResponse * SOAP_FMAC4 soap_instantiate_fireman__listReplicasResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__listReplicasResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__listReplicasResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__listReplicasResponse;
		if (size)
			*size = sizeof(struct fireman__listReplicasResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__listReplicasResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__listReplicasResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__listReplicasResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__listReplicasResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__listReplicasResponse %p -> %p\n", q, p));
	*(struct fireman__listReplicasResponse*)p = *(struct fireman__listReplicasResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__create(struct soap *soap, const struct fireman__create *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, &a->_entries);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__create(struct soap *soap, struct fireman__create *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_entries = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__create(struct soap *soap, const struct fireman__create *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__create);
	if (soap_out_fireman__create(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__create(struct soap *soap, const char *tag, int id, const struct fireman__create *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__create), type);
	soap_out_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, "entries", -1, &a->_entries, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__create * SOAP_FMAC4 soap_get_fireman__create(struct soap *soap, struct fireman__create *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__create(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__create * SOAP_FMAC4 soap_in_fireman__create(struct soap *soap, const char *tag, struct fireman__create *a, const char *type)
{
	short soap_flag__entries = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__create *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__create, sizeof(struct fireman__create), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__create(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__entries && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, NULL, &a->_entries, "glite:FRCEntry"))
				{	soap_flag__entries--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__create *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__create, 0, sizeof(struct fireman__create), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__create * SOAP_FMAC6 soap_new_fireman__create(struct soap *soap, int n)
{	return soap_instantiate_fireman__create(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__create(struct soap *soap, struct fireman__create *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__create * SOAP_FMAC4 soap_instantiate_fireman__create(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__create(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__create, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__create;
		if (size)
			*size = sizeof(struct fireman__create);
	}
	else
	{	cp->ptr = (void*)new struct fireman__create[n];
		if (size)
			*size = n * sizeof(struct fireman__create);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__create*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__create(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__create %p -> %p\n", q, p));
	*(struct fireman__create*)p = *(struct fireman__create*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__createResponse(struct soap *soap, const struct fireman__createResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__createResponse(struct soap *soap, struct fireman__createResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__createResponse(struct soap *soap, const struct fireman__createResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__createResponse);
	if (soap_out_fireman__createResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__createResponse(struct soap *soap, const char *tag, int id, const struct fireman__createResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__createResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__createResponse * SOAP_FMAC4 soap_get_fireman__createResponse(struct soap *soap, struct fireman__createResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__createResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__createResponse * SOAP_FMAC4 soap_in_fireman__createResponse(struct soap *soap, const char *tag, struct fireman__createResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__createResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__createResponse, sizeof(struct fireman__createResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__createResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__createResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__createResponse, 0, sizeof(struct fireman__createResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__createResponse * SOAP_FMAC6 soap_new_fireman__createResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__createResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__createResponse(struct soap *soap, struct fireman__createResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__createResponse * SOAP_FMAC4 soap_instantiate_fireman__createResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__createResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__createResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__createResponse;
		if (size)
			*size = sizeof(struct fireman__createResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__createResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__createResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__createResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__createResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__createResponse %p -> %p\n", q, p));
	*(struct fireman__createResponse*)p = *(struct fireman__createResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__remove(struct soap *soap, const struct fireman__remove *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, &a->_lfns);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__remove(struct soap *soap, struct fireman__remove *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lfns = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__remove(struct soap *soap, const struct fireman__remove *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__remove);
	if (soap_out_fireman__remove(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__remove(struct soap *soap, const char *tag, int id, const struct fireman__remove *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__remove), type);
	soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, "lfns", -1, &a->_lfns, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__remove * SOAP_FMAC4 soap_get_fireman__remove(struct soap *soap, struct fireman__remove *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__remove(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__remove * SOAP_FMAC4 soap_in_fireman__remove(struct soap *soap, const char *tag, struct fireman__remove *a, const char *type)
{
	short soap_flag__lfns = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__remove *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__remove, sizeof(struct fireman__remove), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__remove(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lfns && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, NULL, &a->_lfns, "xsd:string"))
				{	soap_flag__lfns--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__remove *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__remove, 0, sizeof(struct fireman__remove), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__remove * SOAP_FMAC6 soap_new_fireman__remove(struct soap *soap, int n)
{	return soap_instantiate_fireman__remove(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__remove(struct soap *soap, struct fireman__remove *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__remove * SOAP_FMAC4 soap_instantiate_fireman__remove(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__remove(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__remove, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__remove;
		if (size)
			*size = sizeof(struct fireman__remove);
	}
	else
	{	cp->ptr = (void*)new struct fireman__remove[n];
		if (size)
			*size = n * sizeof(struct fireman__remove);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__remove*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__remove(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__remove %p -> %p\n", q, p));
	*(struct fireman__remove*)p = *(struct fireman__remove*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_fireman__removeResponse(struct soap *soap, const struct fireman__removeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_fireman__removeResponse(struct soap *soap, struct fireman__removeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_fireman__removeResponse(struct soap *soap, const struct fireman__removeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_fireman__removeResponse);
	if (soap_out_fireman__removeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_fireman__removeResponse(struct soap *soap, const char *tag, int id, const struct fireman__removeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_fireman__removeResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct fireman__removeResponse * SOAP_FMAC4 soap_get_fireman__removeResponse(struct soap *soap, struct fireman__removeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_fireman__removeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct fireman__removeResponse * SOAP_FMAC4 soap_in_fireman__removeResponse(struct soap *soap, const char *tag, struct fireman__removeResponse *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct fireman__removeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_fireman__removeResponse, sizeof(struct fireman__removeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_fireman__removeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct fireman__removeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_fireman__removeResponse, 0, sizeof(struct fireman__removeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct fireman__removeResponse * SOAP_FMAC6 soap_new_fireman__removeResponse(struct soap *soap, int n)
{	return soap_instantiate_fireman__removeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_fireman__removeResponse(struct soap *soap, struct fireman__removeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct fireman__removeResponse * SOAP_FMAC4 soap_instantiate_fireman__removeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_fireman__removeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_fireman__removeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct fireman__removeResponse;
		if (size)
			*size = sizeof(struct fireman__removeResponse);
	}
	else
	{	cp->ptr = (void*)new struct fireman__removeResponse[n];
		if (size)
			*size = n * sizeof(struct fireman__removeResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct fireman__removeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_fireman__removeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct fireman__removeResponse %p -> %p\n", q, p));
	*(struct fireman__removeResponse*)p = *(struct fireman__removeResponse*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringBoolean *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringBoolean *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringBoolean);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREStringBoolean *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringBoolean ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringBoolean **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringBoolean ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREStringBoolean(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREStringBoolean **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREStringBoolean **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREStringBoolean *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREStringBoolean *)soap_instantiate_ArrayOf_USCOREtns1_USCOREStringBoolean(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREStringBoolean **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringBoolean, sizeof(ArrayOf_USCOREtns1_USCOREStringBoolean), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREGUIDStat *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREGUIDStat *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREGUIDStat);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREGUIDStat *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREGUIDStat ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREGUIDStat **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREGUIDStat ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREGUIDStat(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREGUIDStat **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREGUIDStat **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREGUIDStat *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREGUIDStat *)soap_instantiate_ArrayOf_USCOREtns1_USCOREGUIDStat(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREGUIDStat **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREGUIDStat, sizeof(ArrayOf_USCOREtns1_USCOREGUIDStat), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORERCEntry *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORERCEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERCEntry);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCORERCEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERCEntry ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORERCEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCORERCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERCEntry ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCORERCEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERCEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCORERCEntry **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCORERCEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCORERCEntry *)soap_instantiate_ArrayOf_USCOREtns1_USCORERCEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERCEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERCEntry, sizeof(ArrayOf_USCOREtns1_USCORERCEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, ArrayOf_USCOREtns1_USCOREAttribute *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, ArrayOf_USCOREtns1_USCOREAttribute *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREAttribute);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREAttribute *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREAttribute ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, ArrayOf_USCOREtns1_USCOREAttribute **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREAttribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREAttribute ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREAttribute(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREAttribute **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREAttribute **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREAttribute *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREAttribute *)soap_instantiate_ArrayOf_USCOREtns1_USCOREAttribute(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREAttribute **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREAttribute, sizeof(ArrayOf_USCOREtns1_USCOREAttribute), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREPermissionEntry *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREPermissionEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREPermissionEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREPermissionEntry ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREPermissionEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREPermissionEntry ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREPermissionEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREPermissionEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREPermissionEntry **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREPermissionEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREPermissionEntry *)soap_instantiate_ArrayOf_USCOREtns1_USCOREPermissionEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREPermissionEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREPermissionEntry, sizeof(ArrayOf_USCOREtns1_USCOREPermissionEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFCEntry *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFCEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFCEntry);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREFCEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFCEntry ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFCEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREFCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFCEntry ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREFCEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREFCEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREFCEntry **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREFCEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREFCEntry *)soap_instantiate_ArrayOf_USCOREtns1_USCOREFCEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREFCEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFCEntry, sizeof(ArrayOf_USCOREtns1_USCOREFCEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORESURLEntry *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORESURLEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORESURLEntry);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCORESURLEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORESURLEntry ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, ArrayOf_USCOREtns1_USCORESURLEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORESURLEntry ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCORESURLEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORESURLEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCORESURLEntry **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCORESURLEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCORESURLEntry *)soap_instantiate_ArrayOf_USCOREtns1_USCORESURLEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORESURLEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORESURLEntry, sizeof(ArrayOf_USCOREtns1_USCORESURLEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREStat *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREStat *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStat);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREStat(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREStat *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStat ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREStat(struct soap *soap, ArrayOf_USCOREtns1_USCOREStat **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStat ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREStat(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREStat **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREStat **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREStat *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREStat *)soap_instantiate_ArrayOf_USCOREtns1_USCOREStat(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREStat **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStat, sizeof(ArrayOf_USCOREtns1_USCOREStat), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringPair *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringPair *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREStringPair);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREStringPair *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringPair ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, ArrayOf_USCOREtns1_USCOREStringPair **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREStringPair ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREStringPair(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREStringPair **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREStringPair **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREStringPair *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREStringPair *)soap_instantiate_ArrayOf_USCOREtns1_USCOREStringPair(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREStringPair **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREStringPair, sizeof(ArrayOf_USCOREtns1_USCOREStringPair), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFRCEntry *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFRCEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCOREFRCEntry);
	if (soap_out_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, const char *tag, int id, ArrayOf_USCOREtns1_USCOREFRCEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFRCEntry ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, ArrayOf_USCOREtns1_USCOREFRCEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCOREFRCEntry ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREtns1_USCOREFRCEntry(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCOREFRCEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREtns1_USCOREFRCEntry **)soap_malloc(soap, sizeof(ArrayOf_USCOREtns1_USCOREFRCEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREtns1_USCOREFRCEntry *)soap_instantiate_ArrayOf_USCOREtns1_USCOREFRCEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCOREFRCEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREtns1_USCOREFRCEntry, sizeof(ArrayOf_USCOREtns1_USCOREFRCEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, ArrayOf_USCOREsoapenc_USCOREstring *const*a)
{
	if (*a)
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, ArrayOf_USCOREsoapenc_USCOREstring *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCOREsoapenc_USCOREstring);
	if (soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, const char *tag, int id, ArrayOf_USCOREsoapenc_USCOREstring *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ArrayOf_USCOREsoapenc_USCOREstring ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, ArrayOf_USCOREsoapenc_USCOREstring **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ArrayOf_USCOREsoapenc_USCOREstring ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCOREsoapenc_USCOREstring(struct soap *soap, const char *tag, ArrayOf_USCOREsoapenc_USCOREstring **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (ArrayOf_USCOREsoapenc_USCOREstring **)soap_malloc(soap, sizeof(ArrayOf_USCOREsoapenc_USCOREstring *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ArrayOf_USCOREsoapenc_USCOREstring *)soap_instantiate_ArrayOf_USCOREsoapenc_USCOREstring(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREsoapenc_USCOREstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCOREsoapenc_USCOREstring, sizeof(ArrayOf_USCOREsoapenc_USCOREstring), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__NotExistsException(struct soap *soap, glite__NotExistsException *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__NotExistsException))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__NotExistsException(struct soap *soap, glite__NotExistsException *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__NotExistsException);
	if (soap_out_PointerToglite__NotExistsException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__NotExistsException(struct soap *soap, const char *tag, int id, glite__NotExistsException *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__NotExistsException);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__NotExistsException ** SOAP_FMAC4 soap_get_PointerToglite__NotExistsException(struct soap *soap, glite__NotExistsException **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__NotExistsException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__NotExistsException ** SOAP_FMAC4 soap_in_PointerToglite__NotExistsException(struct soap *soap, const char *tag, glite__NotExistsException **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__NotExistsException **)soap_malloc(soap, sizeof(glite__NotExistsException *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__NotExistsException *)soap_instantiate_glite__NotExistsException(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__NotExistsException **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__NotExistsException, sizeof(glite__NotExistsException), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__InvalidArgumentException(struct soap *soap, glite__InvalidArgumentException *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__InvalidArgumentException))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__InvalidArgumentException(struct soap *soap, glite__InvalidArgumentException *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__InvalidArgumentException);
	if (soap_out_PointerToglite__InvalidArgumentException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__InvalidArgumentException(struct soap *soap, const char *tag, int id, glite__InvalidArgumentException *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__InvalidArgumentException);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__InvalidArgumentException ** SOAP_FMAC4 soap_get_PointerToglite__InvalidArgumentException(struct soap *soap, glite__InvalidArgumentException **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__InvalidArgumentException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__InvalidArgumentException ** SOAP_FMAC4 soap_in_PointerToglite__InvalidArgumentException(struct soap *soap, const char *tag, glite__InvalidArgumentException **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__InvalidArgumentException **)soap_malloc(soap, sizeof(glite__InvalidArgumentException *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__InvalidArgumentException *)soap_instantiate_glite__InvalidArgumentException(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__InvalidArgumentException **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__InvalidArgumentException, sizeof(glite__InvalidArgumentException), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__InternalException(struct soap *soap, glite__InternalException *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__InternalException))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__InternalException(struct soap *soap, glite__InternalException *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__InternalException);
	if (soap_out_PointerToglite__InternalException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__InternalException(struct soap *soap, const char *tag, int id, glite__InternalException *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__InternalException);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__InternalException ** SOAP_FMAC4 soap_get_PointerToglite__InternalException(struct soap *soap, glite__InternalException **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__InternalException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__InternalException ** SOAP_FMAC4 soap_in_PointerToglite__InternalException(struct soap *soap, const char *tag, glite__InternalException **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__InternalException **)soap_malloc(soap, sizeof(glite__InternalException *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__InternalException *)soap_instantiate_glite__InternalException(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__InternalException **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__InternalException, sizeof(glite__InternalException), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__ExistsException(struct soap *soap, glite__ExistsException *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__ExistsException))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__ExistsException(struct soap *soap, glite__ExistsException *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__ExistsException);
	if (soap_out_PointerToglite__ExistsException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__ExistsException(struct soap *soap, const char *tag, int id, glite__ExistsException *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__ExistsException);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__ExistsException ** SOAP_FMAC4 soap_get_PointerToglite__ExistsException(struct soap *soap, glite__ExistsException **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__ExistsException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__ExistsException ** SOAP_FMAC4 soap_in_PointerToglite__ExistsException(struct soap *soap, const char *tag, glite__ExistsException **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__ExistsException **)soap_malloc(soap, sizeof(glite__ExistsException *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__ExistsException *)soap_instantiate_glite__ExistsException(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__ExistsException **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__ExistsException, sizeof(glite__ExistsException), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__AuthorizationException(struct soap *soap, glite__AuthorizationException *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__AuthorizationException))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__AuthorizationException(struct soap *soap, glite__AuthorizationException *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__AuthorizationException);
	if (soap_out_PointerToglite__AuthorizationException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__AuthorizationException(struct soap *soap, const char *tag, int id, glite__AuthorizationException *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__AuthorizationException);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__AuthorizationException ** SOAP_FMAC4 soap_get_PointerToglite__AuthorizationException(struct soap *soap, glite__AuthorizationException **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__AuthorizationException(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__AuthorizationException ** SOAP_FMAC4 soap_in_PointerToglite__AuthorizationException(struct soap *soap, const char *tag, glite__AuthorizationException **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__AuthorizationException **)soap_malloc(soap, sizeof(glite__AuthorizationException *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__AuthorizationException *)soap_instantiate_glite__AuthorizationException(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__AuthorizationException **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__AuthorizationException, sizeof(glite__AuthorizationException), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__ACLEntry(struct soap *soap, glite__ACLEntry **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__ACLEntry))
		soap_serialize_PointerToglite__ACLEntry(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__ACLEntry(struct soap *soap, glite__ACLEntry **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__ACLEntry);
	if (soap_out_PointerToPointerToglite__ACLEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__ACLEntry(struct soap *soap, const char *tag, int id, glite__ACLEntry **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__ACLEntry);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__ACLEntry(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__ACLEntry *** SOAP_FMAC4 soap_get_PointerToPointerToglite__ACLEntry(struct soap *soap, glite__ACLEntry ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__ACLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__ACLEntry *** SOAP_FMAC4 soap_in_PointerToPointerToglite__ACLEntry(struct soap *soap, const char *tag, glite__ACLEntry ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__ACLEntry ***)soap_malloc(soap, sizeof(glite__ACLEntry **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__ACLEntry(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__ACLEntry ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__ACLEntry, sizeof(glite__ACLEntry *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__ACLEntry(struct soap *soap, glite__ACLEntry *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__ACLEntry))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__ACLEntry(struct soap *soap, glite__ACLEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__ACLEntry);
	if (soap_out_PointerToglite__ACLEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__ACLEntry(struct soap *soap, const char *tag, int id, glite__ACLEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__ACLEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__ACLEntry ** SOAP_FMAC4 soap_get_PointerToglite__ACLEntry(struct soap *soap, glite__ACLEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__ACLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__ACLEntry ** SOAP_FMAC4 soap_in_PointerToglite__ACLEntry(struct soap *soap, const char *tag, glite__ACLEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__ACLEntry **)soap_malloc(soap, sizeof(glite__ACLEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__ACLEntry *)soap_instantiate_glite__ACLEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__ACLEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__ACLEntry, sizeof(glite__ACLEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__StringBoolean(struct soap *soap, glite__StringBoolean **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__StringBoolean))
		soap_serialize_PointerToglite__StringBoolean(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__StringBoolean(struct soap *soap, glite__StringBoolean **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__StringBoolean);
	if (soap_out_PointerToPointerToglite__StringBoolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__StringBoolean(struct soap *soap, const char *tag, int id, glite__StringBoolean **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__StringBoolean);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__StringBoolean(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__StringBoolean *** SOAP_FMAC4 soap_get_PointerToPointerToglite__StringBoolean(struct soap *soap, glite__StringBoolean ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__StringBoolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__StringBoolean *** SOAP_FMAC4 soap_in_PointerToPointerToglite__StringBoolean(struct soap *soap, const char *tag, glite__StringBoolean ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__StringBoolean ***)soap_malloc(soap, sizeof(glite__StringBoolean **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__StringBoolean(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__StringBoolean ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__StringBoolean, sizeof(glite__StringBoolean *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__StringBoolean(struct soap *soap, glite__StringBoolean *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__StringBoolean))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__StringBoolean(struct soap *soap, glite__StringBoolean *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__StringBoolean);
	if (soap_out_PointerToglite__StringBoolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__StringBoolean(struct soap *soap, const char *tag, int id, glite__StringBoolean *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__StringBoolean);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__StringBoolean ** SOAP_FMAC4 soap_get_PointerToglite__StringBoolean(struct soap *soap, glite__StringBoolean **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__StringBoolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__StringBoolean ** SOAP_FMAC4 soap_in_PointerToglite__StringBoolean(struct soap *soap, const char *tag, glite__StringBoolean **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__StringBoolean **)soap_malloc(soap, sizeof(glite__StringBoolean *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__StringBoolean *)soap_instantiate_glite__StringBoolean(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__StringBoolean **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__StringBoolean, sizeof(glite__StringBoolean), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__GUIDStat(struct soap *soap, glite__GUIDStat **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__GUIDStat))
		soap_serialize_PointerToglite__GUIDStat(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__GUIDStat(struct soap *soap, glite__GUIDStat **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__GUIDStat);
	if (soap_out_PointerToPointerToglite__GUIDStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__GUIDStat(struct soap *soap, const char *tag, int id, glite__GUIDStat **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__GUIDStat);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__GUIDStat(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__GUIDStat *** SOAP_FMAC4 soap_get_PointerToPointerToglite__GUIDStat(struct soap *soap, glite__GUIDStat ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__GUIDStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__GUIDStat *** SOAP_FMAC4 soap_in_PointerToPointerToglite__GUIDStat(struct soap *soap, const char *tag, glite__GUIDStat ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__GUIDStat ***)soap_malloc(soap, sizeof(glite__GUIDStat **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__GUIDStat(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__GUIDStat ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__GUIDStat, sizeof(glite__GUIDStat *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__RCEntry(struct soap *soap, glite__RCEntry **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__RCEntry))
		soap_serialize_PointerToglite__RCEntry(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__RCEntry(struct soap *soap, glite__RCEntry **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__RCEntry);
	if (soap_out_PointerToPointerToglite__RCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__RCEntry(struct soap *soap, const char *tag, int id, glite__RCEntry **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__RCEntry);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__RCEntry(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__RCEntry *** SOAP_FMAC4 soap_get_PointerToPointerToglite__RCEntry(struct soap *soap, glite__RCEntry ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__RCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__RCEntry *** SOAP_FMAC4 soap_in_PointerToPointerToglite__RCEntry(struct soap *soap, const char *tag, glite__RCEntry ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__RCEntry ***)soap_malloc(soap, sizeof(glite__RCEntry **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__RCEntry(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__RCEntry ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__RCEntry, sizeof(glite__RCEntry *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__RCEntry(struct soap *soap, glite__RCEntry *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__RCEntry))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__RCEntry(struct soap *soap, glite__RCEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__RCEntry);
	if (soap_out_PointerToglite__RCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__RCEntry(struct soap *soap, const char *tag, int id, glite__RCEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__RCEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__RCEntry ** SOAP_FMAC4 soap_get_PointerToglite__RCEntry(struct soap *soap, glite__RCEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__RCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__RCEntry ** SOAP_FMAC4 soap_in_PointerToglite__RCEntry(struct soap *soap, const char *tag, glite__RCEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__RCEntry **)soap_malloc(soap, sizeof(glite__RCEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__RCEntry *)soap_instantiate_glite__RCEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__RCEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__RCEntry, sizeof(glite__RCEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__Attribute(struct soap *soap, glite__Attribute **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__Attribute))
		soap_serialize_PointerToglite__Attribute(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__Attribute(struct soap *soap, glite__Attribute **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__Attribute);
	if (soap_out_PointerToPointerToglite__Attribute(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__Attribute(struct soap *soap, const char *tag, int id, glite__Attribute **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__Attribute);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__Attribute(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__Attribute *** SOAP_FMAC4 soap_get_PointerToPointerToglite__Attribute(struct soap *soap, glite__Attribute ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__Attribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__Attribute *** SOAP_FMAC4 soap_in_PointerToPointerToglite__Attribute(struct soap *soap, const char *tag, glite__Attribute ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__Attribute ***)soap_malloc(soap, sizeof(glite__Attribute **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__Attribute(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__Attribute ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__Attribute, sizeof(glite__Attribute *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__Attribute(struct soap *soap, glite__Attribute *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__Attribute))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__Attribute(struct soap *soap, glite__Attribute *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__Attribute);
	if (soap_out_PointerToglite__Attribute(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__Attribute(struct soap *soap, const char *tag, int id, glite__Attribute *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__Attribute);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__Attribute ** SOAP_FMAC4 soap_get_PointerToglite__Attribute(struct soap *soap, glite__Attribute **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__Attribute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__Attribute ** SOAP_FMAC4 soap_in_PointerToglite__Attribute(struct soap *soap, const char *tag, glite__Attribute **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__Attribute **)soap_malloc(soap, sizeof(glite__Attribute *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__Attribute *)soap_instantiate_glite__Attribute(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__Attribute **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__Attribute, sizeof(glite__Attribute), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__PermissionEntry(struct soap *soap, glite__PermissionEntry **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__PermissionEntry))
		soap_serialize_PointerToglite__PermissionEntry(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__PermissionEntry(struct soap *soap, glite__PermissionEntry **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__PermissionEntry);
	if (soap_out_PointerToPointerToglite__PermissionEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__PermissionEntry(struct soap *soap, const char *tag, int id, glite__PermissionEntry **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__PermissionEntry);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__PermissionEntry(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__PermissionEntry *** SOAP_FMAC4 soap_get_PointerToPointerToglite__PermissionEntry(struct soap *soap, glite__PermissionEntry ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__PermissionEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__PermissionEntry *** SOAP_FMAC4 soap_in_PointerToPointerToglite__PermissionEntry(struct soap *soap, const char *tag, glite__PermissionEntry ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__PermissionEntry ***)soap_malloc(soap, sizeof(glite__PermissionEntry **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__PermissionEntry(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__PermissionEntry ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__PermissionEntry, sizeof(glite__PermissionEntry *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__PermissionEntry(struct soap *soap, glite__PermissionEntry *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__PermissionEntry))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__PermissionEntry(struct soap *soap, glite__PermissionEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__PermissionEntry);
	if (soap_out_PointerToglite__PermissionEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__PermissionEntry(struct soap *soap, const char *tag, int id, glite__PermissionEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__PermissionEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__PermissionEntry ** SOAP_FMAC4 soap_get_PointerToglite__PermissionEntry(struct soap *soap, glite__PermissionEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__PermissionEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__PermissionEntry ** SOAP_FMAC4 soap_in_PointerToglite__PermissionEntry(struct soap *soap, const char *tag, glite__PermissionEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__PermissionEntry **)soap_malloc(soap, sizeof(glite__PermissionEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__PermissionEntry *)soap_instantiate_glite__PermissionEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__PermissionEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__PermissionEntry, sizeof(glite__PermissionEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__FCEntry(struct soap *soap, glite__FCEntry **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__FCEntry))
		soap_serialize_PointerToglite__FCEntry(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__FCEntry(struct soap *soap, glite__FCEntry **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__FCEntry);
	if (soap_out_PointerToPointerToglite__FCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__FCEntry(struct soap *soap, const char *tag, int id, glite__FCEntry **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__FCEntry);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__FCEntry(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__FCEntry *** SOAP_FMAC4 soap_get_PointerToPointerToglite__FCEntry(struct soap *soap, glite__FCEntry ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__FCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__FCEntry *** SOAP_FMAC4 soap_in_PointerToPointerToglite__FCEntry(struct soap *soap, const char *tag, glite__FCEntry ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__FCEntry ***)soap_malloc(soap, sizeof(glite__FCEntry **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__FCEntry(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__FCEntry ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__FCEntry, sizeof(glite__FCEntry *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__FCEntry(struct soap *soap, glite__FCEntry *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__FCEntry))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__FCEntry(struct soap *soap, glite__FCEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__FCEntry);
	if (soap_out_PointerToglite__FCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__FCEntry(struct soap *soap, const char *tag, int id, glite__FCEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__FCEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__FCEntry ** SOAP_FMAC4 soap_get_PointerToglite__FCEntry(struct soap *soap, glite__FCEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__FCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__FCEntry ** SOAP_FMAC4 soap_in_PointerToglite__FCEntry(struct soap *soap, const char *tag, glite__FCEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__FCEntry **)soap_malloc(soap, sizeof(glite__FCEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__FCEntry *)soap_instantiate_glite__FCEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__FCEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__FCEntry, sizeof(glite__FCEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__Stat(struct soap *soap, glite__Stat **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__Stat))
		soap_serialize_PointerToglite__Stat(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__Stat(struct soap *soap, glite__Stat **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__Stat);
	if (soap_out_PointerToPointerToglite__Stat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__Stat(struct soap *soap, const char *tag, int id, glite__Stat **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__Stat);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__Stat(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__Stat *** SOAP_FMAC4 soap_get_PointerToPointerToglite__Stat(struct soap *soap, glite__Stat ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__Stat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__Stat *** SOAP_FMAC4 soap_in_PointerToPointerToglite__Stat(struct soap *soap, const char *tag, glite__Stat ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__Stat ***)soap_malloc(soap, sizeof(glite__Stat **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__Stat(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__Stat ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__Stat, sizeof(glite__Stat *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__Stat(struct soap *soap, glite__Stat *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__Stat))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__Stat(struct soap *soap, glite__Stat *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__Stat);
	if (soap_out_PointerToglite__Stat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__Stat(struct soap *soap, const char *tag, int id, glite__Stat *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__Stat);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__Stat ** SOAP_FMAC4 soap_get_PointerToglite__Stat(struct soap *soap, glite__Stat **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__Stat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__Stat ** SOAP_FMAC4 soap_in_PointerToglite__Stat(struct soap *soap, const char *tag, glite__Stat **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__Stat **)soap_malloc(soap, sizeof(glite__Stat *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__Stat *)soap_instantiate_glite__Stat(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__Stat **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__Stat, sizeof(glite__Stat), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__StringPair(struct soap *soap, glite__StringPair **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__StringPair))
		soap_serialize_PointerToglite__StringPair(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__StringPair(struct soap *soap, glite__StringPair **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__StringPair);
	if (soap_out_PointerToPointerToglite__StringPair(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__StringPair(struct soap *soap, const char *tag, int id, glite__StringPair **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__StringPair);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__StringPair(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__StringPair *** SOAP_FMAC4 soap_get_PointerToPointerToglite__StringPair(struct soap *soap, glite__StringPair ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__StringPair(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__StringPair *** SOAP_FMAC4 soap_in_PointerToPointerToglite__StringPair(struct soap *soap, const char *tag, glite__StringPair ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__StringPair ***)soap_malloc(soap, sizeof(glite__StringPair **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__StringPair(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__StringPair ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__StringPair, sizeof(glite__StringPair *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__StringPair(struct soap *soap, glite__StringPair *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__StringPair))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__StringPair(struct soap *soap, glite__StringPair *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__StringPair);
	if (soap_out_PointerToglite__StringPair(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__StringPair(struct soap *soap, const char *tag, int id, glite__StringPair *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__StringPair);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__StringPair ** SOAP_FMAC4 soap_get_PointerToglite__StringPair(struct soap *soap, glite__StringPair **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__StringPair(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__StringPair ** SOAP_FMAC4 soap_in_PointerToglite__StringPair(struct soap *soap, const char *tag, glite__StringPair **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__StringPair **)soap_malloc(soap, sizeof(glite__StringPair *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__StringPair *)soap_instantiate_glite__StringPair(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__StringPair **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__StringPair, sizeof(glite__StringPair), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__FRCEntry(struct soap *soap, glite__FRCEntry **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__FRCEntry))
		soap_serialize_PointerToglite__FRCEntry(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__FRCEntry(struct soap *soap, glite__FRCEntry **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__FRCEntry);
	if (soap_out_PointerToPointerToglite__FRCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__FRCEntry(struct soap *soap, const char *tag, int id, glite__FRCEntry **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__FRCEntry);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__FRCEntry(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__FRCEntry *** SOAP_FMAC4 soap_get_PointerToPointerToglite__FRCEntry(struct soap *soap, glite__FRCEntry ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__FRCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__FRCEntry *** SOAP_FMAC4 soap_in_PointerToPointerToglite__FRCEntry(struct soap *soap, const char *tag, glite__FRCEntry ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__FRCEntry ***)soap_malloc(soap, sizeof(glite__FRCEntry **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__FRCEntry(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__FRCEntry ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__FRCEntry, sizeof(glite__FRCEntry *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__FRCEntry(struct soap *soap, glite__FRCEntry *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__FRCEntry))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__FRCEntry(struct soap *soap, glite__FRCEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__FRCEntry);
	if (soap_out_PointerToglite__FRCEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__FRCEntry(struct soap *soap, const char *tag, int id, glite__FRCEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__FRCEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__FRCEntry ** SOAP_FMAC4 soap_get_PointerToglite__FRCEntry(struct soap *soap, glite__FRCEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__FRCEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__FRCEntry ** SOAP_FMAC4 soap_in_PointerToglite__FRCEntry(struct soap *soap, const char *tag, glite__FRCEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__FRCEntry **)soap_malloc(soap, sizeof(glite__FRCEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__FRCEntry *)soap_instantiate_glite__FRCEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__FRCEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__FRCEntry, sizeof(glite__FRCEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostring(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_string))
		soap_serialize_string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostring(struct soap *soap, char **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostring);
	if (soap_out_PointerTostring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostring(struct soap *soap, const char *tag, int id, char **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_string);
	if (id < 0)
		return soap->error;
	return soap_out_string(soap, tag, id, *a, type);
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_get_PointerTostring(struct soap *soap, char ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostring(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_in_PointerTostring(struct soap *soap, const char *tag, char ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (char ***)soap_malloc(soap, sizeof(char **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (char ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_string, sizeof(char *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__LFNStat(struct soap *soap, glite__LFNStat *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__LFNStat))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__LFNStat(struct soap *soap, glite__LFNStat *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__LFNStat);
	if (soap_out_PointerToglite__LFNStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__LFNStat(struct soap *soap, const char *tag, int id, glite__LFNStat *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__LFNStat);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__LFNStat ** SOAP_FMAC4 soap_get_PointerToglite__LFNStat(struct soap *soap, glite__LFNStat **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__LFNStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__LFNStat ** SOAP_FMAC4 soap_in_PointerToglite__LFNStat(struct soap *soap, const char *tag, glite__LFNStat **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__LFNStat **)soap_malloc(soap, sizeof(glite__LFNStat *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__LFNStat *)soap_instantiate_glite__LFNStat(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__LFNStat **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__LFNStat, sizeof(glite__LFNStat), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToglite__SURLEntry(struct soap *soap, glite__SURLEntry **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToglite__SURLEntry))
		soap_serialize_PointerToglite__SURLEntry(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToglite__SURLEntry(struct soap *soap, glite__SURLEntry **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToglite__SURLEntry);
	if (soap_out_PointerToPointerToglite__SURLEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToglite__SURLEntry(struct soap *soap, const char *tag, int id, glite__SURLEntry **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToglite__SURLEntry);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToglite__SURLEntry(soap, tag, id, *a, type);
}

SOAP_FMAC3 glite__SURLEntry *** SOAP_FMAC4 soap_get_PointerToPointerToglite__SURLEntry(struct soap *soap, glite__SURLEntry ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToglite__SURLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__SURLEntry *** SOAP_FMAC4 soap_in_PointerToPointerToglite__SURLEntry(struct soap *soap, const char *tag, glite__SURLEntry ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__SURLEntry ***)soap_malloc(soap, sizeof(glite__SURLEntry **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToglite__SURLEntry(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (glite__SURLEntry ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToglite__SURLEntry, sizeof(glite__SURLEntry *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__SURLEntry(struct soap *soap, glite__SURLEntry *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__SURLEntry))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__SURLEntry(struct soap *soap, glite__SURLEntry *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__SURLEntry);
	if (soap_out_PointerToglite__SURLEntry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__SURLEntry(struct soap *soap, const char *tag, int id, glite__SURLEntry *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__SURLEntry);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__SURLEntry ** SOAP_FMAC4 soap_get_PointerToglite__SURLEntry(struct soap *soap, glite__SURLEntry **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__SURLEntry(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__SURLEntry ** SOAP_FMAC4 soap_in_PointerToglite__SURLEntry(struct soap *soap, const char *tag, glite__SURLEntry **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__SURLEntry **)soap_malloc(soap, sizeof(glite__SURLEntry *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__SURLEntry *)soap_instantiate_glite__SURLEntry(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__SURLEntry **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__SURLEntry, sizeof(glite__SURLEntry), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__Permission(struct soap *soap, glite__Permission *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__Permission))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__Permission(struct soap *soap, glite__Permission *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__Permission);
	if (soap_out_PointerToglite__Permission(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__Permission(struct soap *soap, const char *tag, int id, glite__Permission *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__Permission);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__Permission ** SOAP_FMAC4 soap_get_PointerToglite__Permission(struct soap *soap, glite__Permission **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__Permission(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__Permission ** SOAP_FMAC4 soap_in_PointerToglite__Permission(struct soap *soap, const char *tag, glite__Permission **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__Permission **)soap_malloc(soap, sizeof(glite__Permission *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__Permission *)soap_instantiate_glite__Permission(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__Permission **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__Permission, sizeof(glite__Permission), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__GUIDStat(struct soap *soap, glite__GUIDStat *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__GUIDStat))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__GUIDStat(struct soap *soap, glite__GUIDStat *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__GUIDStat);
	if (soap_out_PointerToglite__GUIDStat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__GUIDStat(struct soap *soap, const char *tag, int id, glite__GUIDStat *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__GUIDStat);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__GUIDStat ** SOAP_FMAC4 soap_get_PointerToglite__GUIDStat(struct soap *soap, glite__GUIDStat **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__GUIDStat(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__GUIDStat ** SOAP_FMAC4 soap_in_PointerToglite__GUIDStat(struct soap *soap, const char *tag, glite__GUIDStat **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__GUIDStat **)soap_malloc(soap, sizeof(glite__GUIDStat *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__GUIDStat *)soap_instantiate_glite__GUIDStat(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__GUIDStat **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__GUIDStat, sizeof(glite__GUIDStat), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToglite__Perm(struct soap *soap, glite__Perm *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_glite__Perm))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToglite__Perm(struct soap *soap, glite__Perm *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToglite__Perm);
	if (soap_out_PointerToglite__Perm(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToglite__Perm(struct soap *soap, const char *tag, int id, glite__Perm *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_glite__Perm);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 glite__Perm ** SOAP_FMAC4 soap_get_PointerToglite__Perm(struct soap *soap, glite__Perm **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToglite__Perm(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 glite__Perm ** SOAP_FMAC4 soap_in_PointerToglite__Perm(struct soap *soap, const char *tag, glite__Perm **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (glite__Perm **)soap_malloc(soap, sizeof(glite__Perm *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (glite__Perm *)soap_instantiate_glite__Perm(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (glite__Perm **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_glite__Perm, sizeof(glite__Perm), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__SOAP_ENC__arrayType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__SOAP_ENC__arrayType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__SOAP_ENC__arrayType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__SOAP_ENC__arrayType);
	if (soap_out__SOAP_ENC__arrayType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__SOAP_ENC__arrayType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__SOAP_ENC__arrayType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__SOAP_ENC__arrayType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__SOAP_ENC__arrayType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__SOAP_ENC__arrayType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__SOAP_ENC__arrayType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

/* End of fireman_soapC.cpp */
