#include "../../std.h"

#include "fireman_soapH.h"
#include "identity_fireman.h"
#include "permission_fireman.h"

#include "object_access_fireman.h"

ObjectAccessFireman::ObjectAccessFireman(void) {
}

ObjectAccessFireman::ObjectAccessFireman(const ObjectAccess& o):ObjectAccess(o) {
}

//ObjectAccessFireman::ObjectAccessFireman(const glite__Permission* ) {
//}

ObjectAccessFireman::~ObjectAccessFireman(void) {
}

glite__Permission* ObjectAccessFireman::get(struct soap* sp) {
  if(!sp) return NULL;
  glite__Permission* p = soap_new_glite__Permission(sp,-1);
  if(!p) return NULL;
  p->otherPerm=NULL;
  p->userName=NULL;
  p->userPerm=NULL;
  p->groupName=NULL;
  p->groupPerm=NULL;
  p->acl=NULL;
  p->__sizeacl=0;
  int n = 0;
  Item* item;
  Identity* id;
  Permission* perm;
  int l = size();
  if(l > 2) {
    p->acl=(glite__ACLEntry**)soap_malloc(sp,
                      sizeof(glite__ACLEntry*)*(l-2));
    if(p->acl) {
      memset(p->acl,0,sizeof(glite__ACLEntry*)*(l-2));
    } else {
      l=2;
    };
    p->__sizeacl=l-2;
  };
  for(;n<l;++n) {
    item=(*this)[n]; if(!item) break;
    id=item->id(); perm=item->permission(); 
    if((!id) || (!perm)) continue;
    IdentityFireman id_f(*id);
    char* id_g = soap_strdup(sp,id_f.get().c_str());
    if(!id_g) continue;
    PermissionFireman perm_f(*perm);
    glite__Perm* perm_g = soap_new_glite__Perm(sp,-1);
    if(!perm_g) { soap_dealloc(sp,id_g); continue; };
    perm_g->permission=perm_f.allowPermission();
    perm_g->remove=perm_f.allowRemove();
    perm_g->read=perm_f.allowRead();
    perm_g->write=perm_f.allowWrite();
    perm_g->list=perm_f.allowList();
    perm_g->execute=perm_f.allowExecute();
    perm_g->getMetadata=perm_f.allowGetMetadata();
    perm_g->setMetadata=perm_f.allowSetMetadata();
    if(n == 0) {
      p->userName=id_g;
      p->userPerm=perm_g;
    } else if(n == 1) {
      p->groupName=id_g;
      p->groupPerm=perm_g;
    } else {
      glite__ACLEntry* acl = soap_new_glite__ACLEntry(sp,-1);
      if(!acl) {
        soap_dealloc(sp,id_g);
        soap_delete_glite__Perm(sp,perm_g);
        continue;
      };
      acl->principal=id_g;
      acl->principalPerm=perm_g;
      p->acl[n-2]=acl;
    };
  };
  return p;
}

