#ifndef __ARC_HTTPS_TIMESTAMPS_H__
#define __ARC_HTTPS_TIMESTAMPS_H__

#include <string>

class HTTP_Time {
 private:
  unsigned int weekday;
  unsigned int year;
  unsigned int month;
  unsigned int day;
  unsigned int hours;
  unsigned int minutes;
  unsigned int seconds;
  bool defined;
  bool set(const char* s);
  bool set(time_t t);
  bool set(const struct tm& t);
 public:
  HTTP_Time(void):defined(false) { };
  HTTP_Time(const char* s) { set(s); };
  HTTP_Time(time_t t) { set(t); };
  HTTP_Time(const struct tm& t) { set(t); };
  ~HTTP_Time(void) {};
  void operator=(const char* s) { set(s); };
  void operator=(time_t t) { set(t); };
  void operator=(const struct tm& t) { set(t); };
  operator bool(void) const { return defined; };
  unsigned int Weekday(void) const { return weekday+1; };
  unsigned int Year(void) const { return year; };
  unsigned int Month(void) const { return month; };
  unsigned int Day(void) const { return day+1; };
  unsigned int Hours(void) const { return hours; };
  unsigned int Minutes(void) const { return minutes; };
  unsigned int Seconds(void) const { return seconds; };
  time_t Get(struct tm *tm = NULL) const;
  std::string Str(void) const;
};

#endif // __ARC_HTTPS_TIMESTAMPS_H__
