// TODO: Run multiple clients in parallel

#include "../../std.h"

#include "logger_client.h"
#include "logger_common.h"

#include "../../misc/log_time.h"

#define print_element(name) \
  if(j.name.length()) o<<#name<<"="<<j.name<<std::endl;

#define print_optional_element(name) \
  if(j.name) o<<#name<<"="<<*(j.name)<<std::endl;

#define print_optional_element_date(name) \
  if(j.name) o<<#name<<"="<<ctime(j.name);


void print_vector(std::ostream& o,std::string name, std::vector<std::string> v) {
  for(int i=0;i < v.size(); i++) { 
	if(i == 0) o<<name<<"="; 
	o<<v[i]; 
	if(i == v.size()-1) o<<std::endl; 
  }
}

std::ostream& operator<<(std::ostream& o,const nl2__UsageRecord& j) {
  print_element(globaljobid);
  print_element(globaluserid);
  print_element(cluster);
  print_optional_element(jobdescription);
  print_optional_element(projectname);
  print_optional_element(jobname);
  print_optional_element(submithost);
  print_optional_element(requestedcputime);
  print_optional_element(requestedmemory);
  print_optional_element(requesteddisk);
  print_optional_element_date(submissiontime);
  print_optional_element(localuserid);
  print_optional_element(queue);
  print_optional_element(lrms);
  print_optional_element(lrmssubmissiontime);
  print_optional_element(lrmsendtime);
  o<<"here comes vector"<<std::endl;
  print_vector(o, "nodename", j.nodename);
  print_optional_element(nodecount);
  print_optional_element(exitcode);
  print_optional_element(failurestring);
  print_optional_element(usedcputime);
  print_optional_element(usedmemory);
  print_optional_element(usedwalltime);
  print_optional_element(useddisk);
  print_optional_element(status);
  print_optional_element_date(endtime);
  print_optional_element(downloadtime);
  print_optional_element(uploadtime);
  return o;
}



typedef struct {
  bool start,end,cluster,user,id,name,failure,lrms,queue,rsl,ui,usedcpu,usedmem;
} elements_t;

#define set_element(v,e,name) if(strcmp(name,v) == 0) { e=true; }

void MaskElements(nl2__UsageRecord& j,const elements_t& e) {
  if(!e.start)   j.submissiontime=NULL;
  if(!e.end)     j.endtime=NULL;
  if(!e.usedcpu) j.usedcputime=NULL;
  if(!e.usedmem) j.usedmemory=0;
  //if(!e.cluster) j.cluster=NULL;
  //if(!e.user) 
  //if(!e.id) 
  if(!e.name)    j.jobname=NULL;
  if(!e.failure) j.failurestring=NULL;
  if(!e.lrms)    j.lrms=NULL;
  if(!e.queue)   j.queue=NULL;
  if(!e.rsl)     j.jobdescription=NULL;
  if(!e.ui)      j.submithost=NULL;
}

int query(const char* url,char const * q,unsigned long int offset,unsigned int size,bool xml_out,const elements_t& e);
 
int main(int argc,char* argv[]) {
  char* url = NULL;
  elements_t e = { true, true, true, true, true, true, true, true, true, true, true, true, true };

  opterr=0;
  bool xml_out = false;
  unsigned long int offset = 0;
  unsigned long int size = 100;
  int n;
  while((n=getopt(argc,argv,":hxe:u:d:o:s:")) != -1) {
    switch(n) {
      case ':': { olog<<"Missing argument\n"; return 1; };
      case '?': { olog<<"Unrecognized option\n"; return 1; };
      case 'h': {
        std::cout<<"arclogq [-h] [-d level] [-u url] [-x] [-o offset] [-s size] [-e element,element,...] [query]"<<std::endl;
         return 0;
      };
      case 'u': {
        url=optarg;
      }; break;
      case 'd': {
        char* p;
        int i = strtol(optarg,&p,10);
        if(((*p) != 0) || (i<0)) {
          olog<<"Improper debug level '"<<optarg<<"'"<<std::endl;
          exit(1);
        };
        LogTime::Level(NotifyLevel(FATAL+i));
      }; break;
      case 'e': {
        e.start=false; e.end=false; e.cluster=false; e.user=false;
        e.id=false; e.name=false; e.failure=false; e.lrms=false;
        e.queue=false; e.rsl=false; e.ui=false; e.usedcpu=false;
        e.usedmem=false;
        for(const char* p=optarg;*p;) {
          const char* pp = strchr(p,',');
          std::string name;
          if(pp) { name.assign(p,pp-p); } else { name.assign(p); };
          set_element(name.c_str(),e.start,"start")
          else set_element(name.c_str(),e.end,"end")
          else set_element(name.c_str(),e.cluster,"cluster")
          else set_element(name.c_str(),e.user,"user")
          else set_element(name.c_str(),e.id,"id")
          else set_element(name.c_str(),e.name,"name")
          else set_element(name.c_str(),e.failure,"failure")
          else set_element(name.c_str(),e.lrms,"lrms")
          else set_element(name.c_str(),e.queue,"queue")
          else set_element(name.c_str(),e.ui,"ui")
          else set_element(name.c_str(),e.usedcpu,"usedcpu")
          else set_element(name.c_str(),e.usedmem,"usedmem");
          if(!pp) break;
          p=pp+1;
        };
      }; break;
      case 'o': {
        char* p;
        int i = strtol(optarg,&p,10);
        if(((*p) != 0) || (i<0)) {
          olog<<"Improper offset '"<<optarg<<"'"<<std::endl;
          exit(1);
        };
        offset=i;
      }; break;
      case 's': {
        char* p;
        int i = strtol(optarg,&p,10);
        if(((*p) != 0) || (i<=0)) {
          olog<<"Improper size '"<<optarg<<"'"<<std::endl;
          exit(1);
        };
        size=i;
      }; break;
      case 'x': {
        xml_out=true;
      }; break;
      default: { olog<<"Options processing error\n"; return 1; };
    };
  };
  if(xml_out) { e.start=true; e.end=true; };
  return query(url,argv[optind],offset,size,xml_out,e);
}

int query(const char* url,char const * q,unsigned long int offset,unsigned int size,bool xml_out,const elements_t& e) {
  if(url == NULL) {
    odlog(ERROR)<<"URL is needed"<<std::endl;
    return 1;
  };
  if(globus_module_activate(GLOBUS_IO_MODULE) != GLOBUS_SUCCESS) exit(1);
  std::list<nl2__UsageRecord> info;
  bool res = true;
  unsigned long int o = offset;
  // already read size
  unsigned int pre_size = 0;
  // size for single query, limited by 100
  unsigned int q_size = 0;
  {
    LoggerClient client;
    for(;pre_size<size;) {
      q_size = (size-pre_size)>100 ? 100: (size-pre_size);
      res = client.Query(url,q,o,q_size,info);
      if(!res) break;
      if(info.size() < pre_size+q_size) break;
      pre_size=info.size(); o=info.size();
    };
    if(!res && !(info.size())) {
      odlog(ERROR)<<"Failed to retrieve information"<<std::endl;
    } else if(info.size()) {
      if(!res) odlog(ERROR)<<"Warning: not full information was retrieved"<<std::endl;
      res=true;
      int i = 0;
      for(std::list<nl2__UsageRecord>::iterator i=info.begin();
                                                 i!=info.end();i++) {
        MaskElements(*i,e);
      };
      if(!xml_out) {
        for(std::list<nl2__UsageRecord>::iterator i=info.begin();
                                                   i!=info.end();i++) {
          std::cout<<*i;
        };
      } else { // serialize using gSOAP
        struct soap sp;
        soap_init(&sp);
        sp.namespaces=logger2_soap_namespaces;
        for(std::list<nl2__UsageRecord>::iterator i=info.begin();
                                                   i!=info.end();i++) {
          soap_begin(&sp);
          soap_set_omode(&sp,SOAP_XML_GRAPH | SOAP_XML_CANONICAL);
          i->soap_serialize(&sp);
          sp.os=&std::cout;
          soap_begin_send(&sp);
          i->soap_put(&sp,"job","nl2::UsageRecord");
          soap_end_send(&sp);
          soap_end(&sp);
        };
        soap_done(&sp);
      };
    } else {
      odlog(ERROR)<<"Warning: no data was retrieved"<<std::endl;
    };
  };
  globus_module_deactivate(GLOBUS_IO_MODULE);
  if(!res) return 1;
  return 0;
}
