/* logger2_soapC.cpp
   Generated by gSOAP 2.7.8a from logger2_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "logger2_soapH.h"

SOAP_SOURCE_STAMP("@(#) logger2_soapC.cpp ver 2.7.8a 2009-04-06 10:51:35 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_nl2__ResultCode:
		return soap_in_nl2__ResultCode(soap, NULL, NULL, "nl2:ResultCode");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_nl2__getResponse:
		return soap_in_nl2__getResponse(soap, NULL, NULL, "nl2:getResponse");
	case SOAP_TYPE_nl2__getRequest:
		return soap_in_nl2__getRequest(soap, NULL, NULL, "nl2:getRequest");
	case SOAP_TYPE_nl2__addResponse:
		return soap_in_nl2__addResponse(soap, NULL, NULL, "nl2:addResponse");
	case SOAP_TYPE_nl2__addRequest:
		return soap_in_nl2__addRequest(soap, NULL, NULL, "nl2:addRequest");
	case SOAP_TYPE_nl2__UsageRecord:
		return soap_in_nl2__UsageRecord(soap, NULL, NULL, "nl2:UsageRecord");
	case SOAP_TYPE_nl2__Result:
		return soap_in_nl2__Result(soap, NULL, NULL, "nl2:Result");
	case SOAP_TYPE_PointerTonl2__getResponse:
		return soap_in_PointerTonl2__getResponse(soap, NULL, NULL, "nl2:getResponse");
	case SOAP_TYPE_PointerTonl2__getRequest:
		return soap_in_PointerTonl2__getRequest(soap, NULL, NULL, "nl2:getRequest");
	case SOAP_TYPE_PointerTonl2__addResponse:
		return soap_in_PointerTonl2__addResponse(soap, NULL, NULL, "nl2:addResponse");
	case SOAP_TYPE_PointerTonl2__addRequest:
		return soap_in_PointerTonl2__addRequest(soap, NULL, NULL, "nl2:addRequest");
	case SOAP_TYPE_PointerTonl2__Result:
		return soap_in_PointerTonl2__Result(soap, NULL, NULL, "nl2:Result");
	case SOAP_TYPE_PointerTonl2__UsageRecord:
		return soap_in_PointerTonl2__UsageRecord(soap, NULL, NULL, "nl2:UsageRecord");
	case SOAP_TYPE_PointerTotime:
		return soap_in_PointerTotime(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:ResultCode"))
		{	*type = SOAP_TYPE_nl2__ResultCode;
			return soap_in_nl2__ResultCode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:getResponse"))
		{	*type = SOAP_TYPE_nl2__getResponse;
			return soap_in_nl2__getResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:getRequest"))
		{	*type = SOAP_TYPE_nl2__getRequest;
			return soap_in_nl2__getRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:addResponse"))
		{	*type = SOAP_TYPE_nl2__addResponse;
			return soap_in_nl2__addResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:addRequest"))
		{	*type = SOAP_TYPE_nl2__addRequest;
			return soap_in_nl2__addRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:UsageRecord"))
		{	*type = SOAP_TYPE_nl2__UsageRecord;
			return soap_in_nl2__UsageRecord(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "nl2:Result"))
		{	*type = SOAP_TYPE_nl2__Result;
			return soap_in_nl2__Result(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_nl2__ResultCode:
		return soap_out_nl2__ResultCode(soap, tag, id, (const enum nl2__ResultCode *)ptr, "nl2:ResultCode");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE_nl2__getResponse:
		return ((nl2__getResponse *)ptr)->soap_out(soap, tag, id, "nl2:getResponse");
	case SOAP_TYPE_nl2__getRequest:
		return ((nl2__getRequest *)ptr)->soap_out(soap, tag, id, "nl2:getRequest");
	case SOAP_TYPE_nl2__addResponse:
		return ((nl2__addResponse *)ptr)->soap_out(soap, tag, id, "nl2:addResponse");
	case SOAP_TYPE_nl2__addRequest:
		return ((nl2__addRequest *)ptr)->soap_out(soap, tag, id, "nl2:addRequest");
	case SOAP_TYPE_nl2__UsageRecord:
		return ((nl2__UsageRecord *)ptr)->soap_out(soap, tag, id, "nl2:UsageRecord");
	case SOAP_TYPE_nl2__Result:
		return ((nl2__Result *)ptr)->soap_out(soap, tag, id, "nl2:Result");
	case SOAP_TYPE_PointerTonl2__getResponse:
		return soap_out_PointerTonl2__getResponse(soap, tag, id, (nl2__getResponse *const*)ptr, "nl2:getResponse");
	case SOAP_TYPE_PointerTonl2__getRequest:
		return soap_out_PointerTonl2__getRequest(soap, tag, id, (nl2__getRequest *const*)ptr, "nl2:getRequest");
	case SOAP_TYPE_PointerTonl2__addResponse:
		return soap_out_PointerTonl2__addResponse(soap, tag, id, (nl2__addResponse *const*)ptr, "nl2:addResponse");
	case SOAP_TYPE_PointerTonl2__addRequest:
		return soap_out_PointerTonl2__addRequest(soap, tag, id, (nl2__addRequest *const*)ptr, "nl2:addRequest");
	case SOAP_TYPE_PointerTonl2__Result:
		return soap_out_PointerTonl2__Result(soap, tag, id, (nl2__Result *const*)ptr, "nl2:Result");
	case SOAP_TYPE_PointerTonl2__UsageRecord:
		return soap_out_PointerTonl2__UsageRecord(soap, tag, id, (nl2__UsageRecord *const*)ptr, "nl2:UsageRecord");
	case SOAP_TYPE_PointerTotime:
		return soap_out_PointerTotime(soap, tag, id, (time_t *const*)ptr, "xsd:dateTime");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_nl2__getResponse:
		((nl2__getResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_nl2__getRequest:
		((nl2__getRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_nl2__addResponse:
		((nl2__addResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_nl2__addRequest:
		((nl2__addRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_nl2__UsageRecord:
		((nl2__UsageRecord *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_nl2__Result:
		((nl2__Result *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___nl2__get:
		soap_serialize___nl2__get(soap, (const struct __nl2__get *)ptr);
		break;
	case SOAP_TYPE___nl2__add:
		soap_serialize___nl2__add(soap, (const struct __nl2__add *)ptr);
		break;
	case SOAP_TYPE_PointerTonl2__getResponse:
		soap_serialize_PointerTonl2__getResponse(soap, (nl2__getResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTonl2__getRequest:
		soap_serialize_PointerTonl2__getRequest(soap, (nl2__getRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTonl2__addResponse:
		soap_serialize_PointerTonl2__addResponse(soap, (nl2__addResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTonl2__addRequest:
		soap_serialize_PointerTonl2__addRequest(soap, (nl2__addRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTonl2__Result:
		soap_serialize_PointerTonl2__Result(soap, (nl2__Result *const*)ptr);
		break;
	case SOAP_TYPE_PointerTonl2__UsageRecord:
		soap_serialize_PointerTonl2__UsageRecord(soap, (nl2__UsageRecord *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotime:
		soap_serialize_PointerTotime(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_nl2__Result:
		return (void*)soap_instantiate_nl2__Result(soap, -1, type, arrayType, n);
	case SOAP_TYPE_nl2__UsageRecord:
		return (void*)soap_instantiate_nl2__UsageRecord(soap, -1, type, arrayType, n);
	case SOAP_TYPE_nl2__addRequest:
		return (void*)soap_instantiate_nl2__addRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_nl2__addResponse:
		return (void*)soap_instantiate_nl2__addResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_nl2__getRequest:
		return (void*)soap_instantiate_nl2__getRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_nl2__getResponse:
		return (void*)soap_instantiate_nl2__getResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___nl2__add:
		return (void*)soap_instantiate___nl2__add(soap, -1, type, arrayType, n);
	case SOAP_TYPE___nl2__get:
		return (void*)soap_instantiate___nl2__get(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTonl2__UsageRecord:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfint:
		return (void*)soap_instantiate_std__vectorTemplateOfint(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		return (void*)soap_instantiate_std__vectorTemplateOfstd__string(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_nl2__Result:
		if (p->size < 0)
			delete (nl2__Result*)p->ptr;
		else
			delete[] (nl2__Result*)p->ptr;
		break;
	case SOAP_TYPE_nl2__UsageRecord:
		if (p->size < 0)
			delete (nl2__UsageRecord*)p->ptr;
		else
			delete[] (nl2__UsageRecord*)p->ptr;
		break;
	case SOAP_TYPE_nl2__addRequest:
		if (p->size < 0)
			delete (nl2__addRequest*)p->ptr;
		else
			delete[] (nl2__addRequest*)p->ptr;
		break;
	case SOAP_TYPE_nl2__addResponse:
		if (p->size < 0)
			delete (nl2__addResponse*)p->ptr;
		else
			delete[] (nl2__addResponse*)p->ptr;
		break;
	case SOAP_TYPE_nl2__getRequest:
		if (p->size < 0)
			delete (nl2__getRequest*)p->ptr;
		else
			delete[] (nl2__getRequest*)p->ptr;
		break;
	case SOAP_TYPE_nl2__getResponse:
		if (p->size < 0)
			delete (nl2__getResponse*)p->ptr;
		else
			delete[] (nl2__getResponse*)p->ptr;
		break;
	case SOAP_TYPE___nl2__add:
		if (p->size < 0)
			delete (struct __nl2__add*)p->ptr;
		else
			delete[] (struct __nl2__add*)p->ptr;
		break;
	case SOAP_TYPE___nl2__get:
		if (p->size < 0)
			delete (struct __nl2__get*)p->ptr;
		else
			delete[] (struct __nl2__get*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTonl2__UsageRecord:
		if (p->size < 0)
			delete (std::vector<nl2__UsageRecord * >*)p->ptr;
		else
			delete[] (std::vector<nl2__UsageRecord * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfint:
		if (p->size < 0)
			delete (std::vector<int >*)p->ptr;
		else
			delete[] (std::vector<int >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfPointerTonl2__UsageRecord:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<nl2__UsageRecord * >*)p)[len] = *(nl2__UsageRecord **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfint:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<int >*)p)[len] = *(int *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<std::string >*)p)[len] = *(std::string *)q;
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_nl2__ResultCode(struct soap *soap, enum nl2__ResultCode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_nl2__ResultCode
	*a = SOAP_DEFAULT_nl2__ResultCode;
#else
	*a = (enum nl2__ResultCode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_nl2__ResultCode(struct soap *soap, const enum nl2__ResultCode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_nl2__ResultCode);
	if (soap_out_nl2__ResultCode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_nl2__ResultCode[] =
{	{ (long)nl2__ResultCode__NoError, "NoError" },
	{ (long)nl2__ResultCode__UndefinedError, "UndefinedError" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_nl2__ResultCode2s(struct soap *soap, enum nl2__ResultCode n)
{	const char *s = soap_code_str(soap_codes_nl2__ResultCode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__ResultCode(struct soap *soap, const char *tag, int id, const enum nl2__ResultCode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__ResultCode), type);
	soap_send(soap, soap_nl2__ResultCode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum nl2__ResultCode * SOAP_FMAC4 soap_get_nl2__ResultCode(struct soap *soap, enum nl2__ResultCode *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__ResultCode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2nl2__ResultCode(struct soap *soap, const char *s, enum nl2__ResultCode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_nl2__ResultCode, s);
	if (map)
		*a = (enum nl2__ResultCode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum nl2__ResultCode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum nl2__ResultCode * SOAP_FMAC4 soap_in_nl2__ResultCode(struct soap *soap, const char *tag, enum nl2__ResultCode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum nl2__ResultCode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__ResultCode, sizeof(enum nl2__ResultCode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2nl2__ResultCode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum nl2__ResultCode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__ResultCode, 0, sizeof(enum nl2__ResultCode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *p)
{	(void)soap; (void)p; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_std__string(struct soap *soap, int n)
{	return soap_instantiate_std__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__string(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void nl2__getResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTonl2__Result(soap, &((nl2__getResponse*)this)->result);
	soap_serialize_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, &((nl2__getResponse*)this)->job);
	/* transient soap skipped */
}

void nl2__getResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((nl2__getResponse*)this)->result = NULL;
	soap_default_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, &((nl2__getResponse*)this)->job);
	/* transient soap skipped */
}

int nl2__getResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_nl2__getResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int nl2__getResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_nl2__getResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__getResponse(struct soap *soap, const char *tag, int id, const nl2__getResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__getResponse), type);
	soap_out_PointerTonl2__Result(soap, "result", -1, &(((nl2__getResponse*)a)->result), "");
	soap_out_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, "job", -1, &(((nl2__getResponse*)a)->job), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *nl2__getResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_nl2__getResponse(soap, this, tag, type);
}

SOAP_FMAC3 nl2__getResponse * SOAP_FMAC4 soap_get_nl2__getResponse(struct soap *soap, nl2__getResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__getResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *nl2__getResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_nl2__getResponse(soap, tag, this, type);
}

SOAP_FMAC3 nl2__getResponse * SOAP_FMAC4 soap_in_nl2__getResponse(struct soap *soap, const char *tag, nl2__getResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (nl2__getResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__getResponse, sizeof(nl2__getResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_nl2__getResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (nl2__getResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_result1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTonl2__Result(soap, "result", &(((nl2__getResponse*)a)->result), "nl2:Result"))
				{	soap_flag_result1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, "job", &(((nl2__getResponse*)a)->job), "nl2:UsageRecord"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_result1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (nl2__getResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__getResponse, 0, sizeof(nl2__getResponse), 0, soap_copy_nl2__getResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 nl2__getResponse * SOAP_FMAC6 soap_new_nl2__getResponse(struct soap *soap, int n)
{	return soap_instantiate_nl2__getResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_nl2__getResponse(struct soap *soap, nl2__getResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 nl2__getResponse * SOAP_FMAC4 soap_instantiate_nl2__getResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_nl2__getResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_nl2__getResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new nl2__getResponse;
		if (size)
			*size = sizeof(nl2__getResponse);
		((nl2__getResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new nl2__getResponse[n];
		if (size)
			*size = n * sizeof(nl2__getResponse);
		for (int i = 0; i < n; i++)
			((nl2__getResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (nl2__getResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_nl2__getResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying nl2__getResponse %p -> %p\n", q, p));
	*(nl2__getResponse*)p = *(nl2__getResponse*)q;
}

void nl2__getRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &((nl2__getRequest*)this)->query);
	/* transient soap skipped */
}

void nl2__getRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((nl2__getRequest*)this)->query = NULL;
	soap_default_unsignedInt(soap, &((nl2__getRequest*)this)->offset);
	soap_default_unsignedInt(soap, &((nl2__getRequest*)this)->size);
	/* transient soap skipped */
}

int nl2__getRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_nl2__getRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int nl2__getRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_nl2__getRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__getRequest(struct soap *soap, const char *tag, int id, const nl2__getRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__getRequest), type);
	soap_out_PointerTostd__string(soap, "query", -1, &(((nl2__getRequest*)a)->query), "");
	soap_out_unsignedInt(soap, "offset", -1, &(((nl2__getRequest*)a)->offset), "");
	soap_out_unsignedInt(soap, "size", -1, &(((nl2__getRequest*)a)->size), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *nl2__getRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_nl2__getRequest(soap, this, tag, type);
}

SOAP_FMAC3 nl2__getRequest * SOAP_FMAC4 soap_get_nl2__getRequest(struct soap *soap, nl2__getRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__getRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *nl2__getRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_nl2__getRequest(soap, tag, this, type);
}

SOAP_FMAC3 nl2__getRequest * SOAP_FMAC4 soap_in_nl2__getRequest(struct soap *soap, const char *tag, nl2__getRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (nl2__getRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__getRequest, sizeof(nl2__getRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_nl2__getRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (nl2__getRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_query1 = 1, soap_flag_offset1 = 1, soap_flag_size1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_query1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "query", &(((nl2__getRequest*)a)->query), "xsd:string"))
				{	soap_flag_query1--;
					continue;
				}
			if (soap_flag_offset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "offset", &(((nl2__getRequest*)a)->offset), "xsd:unsignedInt"))
				{	soap_flag_offset1--;
					continue;
				}
			if (soap_flag_size1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "size", &(((nl2__getRequest*)a)->size), "xsd:unsignedInt"))
				{	soap_flag_size1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_offset1 > 0 || soap_flag_size1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (nl2__getRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__getRequest, 0, sizeof(nl2__getRequest), 0, soap_copy_nl2__getRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 nl2__getRequest * SOAP_FMAC6 soap_new_nl2__getRequest(struct soap *soap, int n)
{	return soap_instantiate_nl2__getRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_nl2__getRequest(struct soap *soap, nl2__getRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 nl2__getRequest * SOAP_FMAC4 soap_instantiate_nl2__getRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_nl2__getRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_nl2__getRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new nl2__getRequest;
		if (size)
			*size = sizeof(nl2__getRequest);
		((nl2__getRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new nl2__getRequest[n];
		if (size)
			*size = n * sizeof(nl2__getRequest);
		for (int i = 0; i < n; i++)
			((nl2__getRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (nl2__getRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_nl2__getRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying nl2__getRequest %p -> %p\n", q, p));
	*(nl2__getRequest*)p = *(nl2__getRequest*)q;
}

void nl2__addResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTonl2__Result(soap, &((nl2__addResponse*)this)->result);
	/* transient soap skipped */
}

void nl2__addResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((nl2__addResponse*)this)->result = NULL;
	/* transient soap skipped */
}

int nl2__addResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_nl2__addResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int nl2__addResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_nl2__addResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__addResponse(struct soap *soap, const char *tag, int id, const nl2__addResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__addResponse), type);
	soap_out_PointerTonl2__Result(soap, "result", -1, &(((nl2__addResponse*)a)->result), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *nl2__addResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_nl2__addResponse(soap, this, tag, type);
}

SOAP_FMAC3 nl2__addResponse * SOAP_FMAC4 soap_get_nl2__addResponse(struct soap *soap, nl2__addResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__addResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *nl2__addResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_nl2__addResponse(soap, tag, this, type);
}

SOAP_FMAC3 nl2__addResponse * SOAP_FMAC4 soap_in_nl2__addResponse(struct soap *soap, const char *tag, nl2__addResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (nl2__addResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__addResponse, sizeof(nl2__addResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_nl2__addResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (nl2__addResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_result1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTonl2__Result(soap, "result", &(((nl2__addResponse*)a)->result), "nl2:Result"))
				{	soap_flag_result1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_result1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (nl2__addResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__addResponse, 0, sizeof(nl2__addResponse), 0, soap_copy_nl2__addResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 nl2__addResponse * SOAP_FMAC6 soap_new_nl2__addResponse(struct soap *soap, int n)
{	return soap_instantiate_nl2__addResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_nl2__addResponse(struct soap *soap, nl2__addResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 nl2__addResponse * SOAP_FMAC4 soap_instantiate_nl2__addResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_nl2__addResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_nl2__addResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new nl2__addResponse;
		if (size)
			*size = sizeof(nl2__addResponse);
		((nl2__addResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new nl2__addResponse[n];
		if (size)
			*size = n * sizeof(nl2__addResponse);
		for (int i = 0; i < n; i++)
			((nl2__addResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (nl2__addResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_nl2__addResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying nl2__addResponse %p -> %p\n", q, p));
	*(nl2__addResponse*)p = *(nl2__addResponse*)q;
}

void nl2__addRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, &((nl2__addRequest*)this)->job);
	/* transient soap skipped */
}

void nl2__addRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, &((nl2__addRequest*)this)->job);
	/* transient soap skipped */
}

int nl2__addRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_nl2__addRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int nl2__addRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_nl2__addRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__addRequest(struct soap *soap, const char *tag, int id, const nl2__addRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__addRequest), type);
	soap_out_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, "job", -1, &(((nl2__addRequest*)a)->job), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *nl2__addRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_nl2__addRequest(soap, this, tag, type);
}

SOAP_FMAC3 nl2__addRequest * SOAP_FMAC4 soap_get_nl2__addRequest(struct soap *soap, nl2__addRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__addRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *nl2__addRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_nl2__addRequest(soap, tag, this, type);
}

SOAP_FMAC3 nl2__addRequest * SOAP_FMAC4 soap_in_nl2__addRequest(struct soap *soap, const char *tag, nl2__addRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (nl2__addRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__addRequest, sizeof(nl2__addRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_nl2__addRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (nl2__addRequest *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, "job", &(((nl2__addRequest*)a)->job), "nl2:UsageRecord"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (nl2__addRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__addRequest, 0, sizeof(nl2__addRequest), 0, soap_copy_nl2__addRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 nl2__addRequest * SOAP_FMAC6 soap_new_nl2__addRequest(struct soap *soap, int n)
{	return soap_instantiate_nl2__addRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_nl2__addRequest(struct soap *soap, nl2__addRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 nl2__addRequest * SOAP_FMAC4 soap_instantiate_nl2__addRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_nl2__addRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_nl2__addRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new nl2__addRequest;
		if (size)
			*size = sizeof(nl2__addRequest);
		((nl2__addRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new nl2__addRequest[n];
		if (size)
			*size = n * sizeof(nl2__addRequest);
		for (int i = 0; i < n; i++)
			((nl2__addRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (nl2__addRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_nl2__addRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying nl2__addRequest %p -> %p\n", q, p));
	*(nl2__addRequest*)p = *(nl2__addRequest*)q;
}

void nl2__UsageRecord::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((nl2__UsageRecord*)this)->globaljobid, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((nl2__UsageRecord*)this)->globaljobid);
	soap_embedded(soap, &((nl2__UsageRecord*)this)->globaluserid, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((nl2__UsageRecord*)this)->globaluserid);
	soap_embedded(soap, &((nl2__UsageRecord*)this)->cluster, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((nl2__UsageRecord*)this)->cluster);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->jobdescription);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->projectname);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->jobname);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->submithost);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->requestedcputime);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->requestedwalltime);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->requestedmemory);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->requesteddisk);
	soap_serialize_PointerTotime(soap, &((nl2__UsageRecord*)this)->submissiontime);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->localuserid);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->queue);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->lrms);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->localjobid);
	soap_serialize_PointerTotime(soap, &((nl2__UsageRecord*)this)->lrmssubmissiontime);
	soap_serialize_PointerTotime(soap, &((nl2__UsageRecord*)this)->lrmsendtime);
	soap_serialize_std__vectorTemplateOfstd__string(soap, &((nl2__UsageRecord*)this)->nodename);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->nodecount);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->processors);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->exitcode);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->failurestring);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->usedcputime);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->usedwalltime);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->usedmemory);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->useddisk);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->status);
	soap_serialize_PointerTotime(soap, &((nl2__UsageRecord*)this)->endtime);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->downloadtime);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->uploadtime);
	soap_serialize_std__vectorTemplateOfint(soap, &((nl2__UsageRecord*)this)->processid);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->charge);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->network);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->stageindata);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->stageoutdata);
	soap_serialize_PointerToint(soap, &((nl2__UsageRecord*)this)->usedswap);
	soap_serialize_PointerTostd__string(soap, &((nl2__UsageRecord*)this)->servicelevel);
	soap_serialize_std__vectorTemplateOfstd__string(soap, &((nl2__UsageRecord*)this)->runtimeenvironment);
	/* transient soap skipped */
}

void nl2__UsageRecord::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((nl2__UsageRecord*)this)->globaljobid);
	soap_default_std__string(soap, &((nl2__UsageRecord*)this)->globaluserid);
	soap_default_std__string(soap, &((nl2__UsageRecord*)this)->cluster);
	((nl2__UsageRecord*)this)->jobdescription = NULL;
	((nl2__UsageRecord*)this)->projectname = NULL;
	((nl2__UsageRecord*)this)->jobname = NULL;
	((nl2__UsageRecord*)this)->submithost = NULL;
	((nl2__UsageRecord*)this)->requestedcputime = NULL;
	((nl2__UsageRecord*)this)->requestedwalltime = NULL;
	((nl2__UsageRecord*)this)->requestedmemory = NULL;
	((nl2__UsageRecord*)this)->requesteddisk = NULL;
	((nl2__UsageRecord*)this)->submissiontime = NULL;
	((nl2__UsageRecord*)this)->localuserid = NULL;
	((nl2__UsageRecord*)this)->queue = NULL;
	((nl2__UsageRecord*)this)->lrms = NULL;
	((nl2__UsageRecord*)this)->localjobid = NULL;
	((nl2__UsageRecord*)this)->lrmssubmissiontime = NULL;
	((nl2__UsageRecord*)this)->lrmsendtime = NULL;
	soap_default_std__vectorTemplateOfstd__string(soap, &((nl2__UsageRecord*)this)->nodename);
	((nl2__UsageRecord*)this)->nodecount = NULL;
	((nl2__UsageRecord*)this)->processors = NULL;
	((nl2__UsageRecord*)this)->exitcode = NULL;
	((nl2__UsageRecord*)this)->failurestring = NULL;
	((nl2__UsageRecord*)this)->usedcputime = NULL;
	((nl2__UsageRecord*)this)->usedwalltime = NULL;
	((nl2__UsageRecord*)this)->usedmemory = NULL;
	((nl2__UsageRecord*)this)->useddisk = NULL;
	((nl2__UsageRecord*)this)->status = NULL;
	((nl2__UsageRecord*)this)->endtime = NULL;
	((nl2__UsageRecord*)this)->downloadtime = NULL;
	((nl2__UsageRecord*)this)->uploadtime = NULL;
	soap_default_std__vectorTemplateOfint(soap, &((nl2__UsageRecord*)this)->processid);
	((nl2__UsageRecord*)this)->charge = NULL;
	((nl2__UsageRecord*)this)->network = NULL;
	((nl2__UsageRecord*)this)->stageindata = NULL;
	((nl2__UsageRecord*)this)->stageoutdata = NULL;
	((nl2__UsageRecord*)this)->usedswap = NULL;
	((nl2__UsageRecord*)this)->servicelevel = NULL;
	soap_default_std__vectorTemplateOfstd__string(soap, &((nl2__UsageRecord*)this)->runtimeenvironment);
	((nl2__UsageRecord*)this)->__any = NULL;
	/* transient soap skipped */
}

int nl2__UsageRecord::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_nl2__UsageRecord);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int nl2__UsageRecord::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_nl2__UsageRecord(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__UsageRecord(struct soap *soap, const char *tag, int id, const nl2__UsageRecord *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__UsageRecord), type);
	soap_out_std__string(soap, "globaljobid", -1, &(((nl2__UsageRecord*)a)->globaljobid), "");
	soap_out_std__string(soap, "globaluserid", -1, &(((nl2__UsageRecord*)a)->globaluserid), "");
	soap_out_std__string(soap, "cluster", -1, &(((nl2__UsageRecord*)a)->cluster), "");
	soap_out_PointerTostd__string(soap, "jobdescription", -1, &(((nl2__UsageRecord*)a)->jobdescription), "");
	soap_out_PointerTostd__string(soap, "projectname", -1, &(((nl2__UsageRecord*)a)->projectname), "");
	soap_out_PointerTostd__string(soap, "jobname", -1, &(((nl2__UsageRecord*)a)->jobname), "");
	soap_out_PointerTostd__string(soap, "submithost", -1, &(((nl2__UsageRecord*)a)->submithost), "");
	soap_out_PointerToint(soap, "requestedcputime", -1, &(((nl2__UsageRecord*)a)->requestedcputime), "");
	soap_out_PointerToint(soap, "requestedwalltime", -1, &(((nl2__UsageRecord*)a)->requestedwalltime), "");
	soap_out_PointerToint(soap, "requestedmemory", -1, &(((nl2__UsageRecord*)a)->requestedmemory), "");
	soap_out_PointerToint(soap, "requesteddisk", -1, &(((nl2__UsageRecord*)a)->requesteddisk), "");
	soap_out_PointerTotime(soap, "submissiontime", -1, &(((nl2__UsageRecord*)a)->submissiontime), "");
	soap_out_PointerTostd__string(soap, "localuserid", -1, &(((nl2__UsageRecord*)a)->localuserid), "");
	soap_out_PointerTostd__string(soap, "queue", -1, &(((nl2__UsageRecord*)a)->queue), "");
	soap_out_PointerTostd__string(soap, "lrms", -1, &(((nl2__UsageRecord*)a)->lrms), "");
	soap_out_PointerTostd__string(soap, "localjobid", -1, &(((nl2__UsageRecord*)a)->localjobid), "");
	soap_out_PointerTotime(soap, "lrmssubmissiontime", -1, &(((nl2__UsageRecord*)a)->lrmssubmissiontime), "");
	soap_out_PointerTotime(soap, "lrmsendtime", -1, &(((nl2__UsageRecord*)a)->lrmsendtime), "");
	soap_out_std__vectorTemplateOfstd__string(soap, "nodename", -1, &(((nl2__UsageRecord*)a)->nodename), "");
	soap_out_PointerToint(soap, "nodecount", -1, &(((nl2__UsageRecord*)a)->nodecount), "");
	soap_out_PointerToint(soap, "processors", -1, &(((nl2__UsageRecord*)a)->processors), "");
	soap_out_PointerToint(soap, "exitcode", -1, &(((nl2__UsageRecord*)a)->exitcode), "");
	soap_out_PointerTostd__string(soap, "failurestring", -1, &(((nl2__UsageRecord*)a)->failurestring), "");
	soap_out_PointerToint(soap, "usedcputime", -1, &(((nl2__UsageRecord*)a)->usedcputime), "");
	soap_out_PointerToint(soap, "usedwalltime", -1, &(((nl2__UsageRecord*)a)->usedwalltime), "");
	soap_out_PointerToint(soap, "usedmemory", -1, &(((nl2__UsageRecord*)a)->usedmemory), "");
	soap_out_PointerToint(soap, "useddisk", -1, &(((nl2__UsageRecord*)a)->useddisk), "");
	soap_out_PointerTostd__string(soap, "status", -1, &(((nl2__UsageRecord*)a)->status), "");
	soap_out_PointerTotime(soap, "endtime", -1, &(((nl2__UsageRecord*)a)->endtime), "");
	soap_out_PointerToint(soap, "downloadtime", -1, &(((nl2__UsageRecord*)a)->downloadtime), "");
	soap_out_PointerToint(soap, "uploadtime", -1, &(((nl2__UsageRecord*)a)->uploadtime), "");
	soap_out_std__vectorTemplateOfint(soap, "processid", -1, &(((nl2__UsageRecord*)a)->processid), "");
	soap_out_PointerToint(soap, "charge", -1, &(((nl2__UsageRecord*)a)->charge), "");
	soap_out_PointerTostd__string(soap, "network", -1, &(((nl2__UsageRecord*)a)->network), "");
	soap_out_PointerToint(soap, "stageindata", -1, &(((nl2__UsageRecord*)a)->stageindata), "");
	soap_out_PointerToint(soap, "stageoutdata", -1, &(((nl2__UsageRecord*)a)->stageoutdata), "");
	soap_out_PointerToint(soap, "usedswap", -1, &(((nl2__UsageRecord*)a)->usedswap), "");
	soap_out_PointerTostd__string(soap, "servicelevel", -1, &(((nl2__UsageRecord*)a)->servicelevel), "");
	soap_out_std__vectorTemplateOfstd__string(soap, "runtimeenvironment", -1, &(((nl2__UsageRecord*)a)->runtimeenvironment), "");
	soap_outliteral(soap, "-any", &(((nl2__UsageRecord*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *nl2__UsageRecord::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_nl2__UsageRecord(soap, this, tag, type);
}

SOAP_FMAC3 nl2__UsageRecord * SOAP_FMAC4 soap_get_nl2__UsageRecord(struct soap *soap, nl2__UsageRecord *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__UsageRecord(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *nl2__UsageRecord::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_nl2__UsageRecord(soap, tag, this, type);
}

SOAP_FMAC3 nl2__UsageRecord * SOAP_FMAC4 soap_in_nl2__UsageRecord(struct soap *soap, const char *tag, nl2__UsageRecord *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (nl2__UsageRecord *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__UsageRecord, sizeof(nl2__UsageRecord), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_nl2__UsageRecord)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (nl2__UsageRecord *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_globaljobid1 = 1, soap_flag_globaluserid1 = 1, soap_flag_cluster1 = 1, soap_flag_jobdescription1 = 1, soap_flag_projectname1 = 1, soap_flag_jobname1 = 1, soap_flag_submithost1 = 1, soap_flag_requestedcputime1 = 1, soap_flag_requestedwalltime1 = 1, soap_flag_requestedmemory1 = 1, soap_flag_requesteddisk1 = 1, soap_flag_submissiontime1 = 1, soap_flag_localuserid1 = 1, soap_flag_queue1 = 1, soap_flag_lrms1 = 1, soap_flag_localjobid1 = 1, soap_flag_lrmssubmissiontime1 = 1, soap_flag_lrmsendtime1 = 1, soap_flag_nodecount1 = 1, soap_flag_processors1 = 1, soap_flag_exitcode1 = 1, soap_flag_failurestring1 = 1, soap_flag_usedcputime1 = 1, soap_flag_usedwalltime1 = 1, soap_flag_usedmemory1 = 1, soap_flag_useddisk1 = 1, soap_flag_status1 = 1, soap_flag_endtime1 = 1, soap_flag_downloadtime1 = 1, soap_flag_uploadtime1 = 1, soap_flag_charge1 = 1, soap_flag_network1 = 1, soap_flag_stageindata1 = 1, soap_flag_stageoutdata1 = 1, soap_flag_usedswap1 = 1, soap_flag_servicelevel1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_globaljobid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "globaljobid", &(((nl2__UsageRecord*)a)->globaljobid), "xsd:string"))
				{	soap_flag_globaljobid1--;
					continue;
				}
			if (soap_flag_globaluserid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "globaluserid", &(((nl2__UsageRecord*)a)->globaluserid), "xsd:string"))
				{	soap_flag_globaluserid1--;
					continue;
				}
			if (soap_flag_cluster1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "cluster", &(((nl2__UsageRecord*)a)->cluster), "xsd:string"))
				{	soap_flag_cluster1--;
					continue;
				}
			if (soap_flag_jobdescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jobdescription", &(((nl2__UsageRecord*)a)->jobdescription), "xsd:string"))
				{	soap_flag_jobdescription1--;
					continue;
				}
			if (soap_flag_projectname1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "projectname", &(((nl2__UsageRecord*)a)->projectname), "xsd:string"))
				{	soap_flag_projectname1--;
					continue;
				}
			if (soap_flag_jobname1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jobname", &(((nl2__UsageRecord*)a)->jobname), "xsd:string"))
				{	soap_flag_jobname1--;
					continue;
				}
			if (soap_flag_submithost1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "submithost", &(((nl2__UsageRecord*)a)->submithost), "xsd:string"))
				{	soap_flag_submithost1--;
					continue;
				}
			if (soap_flag_requestedcputime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "requestedcputime", &(((nl2__UsageRecord*)a)->requestedcputime), "xsd:int"))
				{	soap_flag_requestedcputime1--;
					continue;
				}
			if (soap_flag_requestedwalltime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "requestedwalltime", &(((nl2__UsageRecord*)a)->requestedwalltime), "xsd:int"))
				{	soap_flag_requestedwalltime1--;
					continue;
				}
			if (soap_flag_requestedmemory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "requestedmemory", &(((nl2__UsageRecord*)a)->requestedmemory), "xsd:int"))
				{	soap_flag_requestedmemory1--;
					continue;
				}
			if (soap_flag_requesteddisk1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "requesteddisk", &(((nl2__UsageRecord*)a)->requesteddisk), "xsd:int"))
				{	soap_flag_requesteddisk1--;
					continue;
				}
			if (soap_flag_submissiontime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "submissiontime", &(((nl2__UsageRecord*)a)->submissiontime), "xsd:dateTime"))
				{	soap_flag_submissiontime1--;
					continue;
				}
			if (soap_flag_localuserid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "localuserid", &(((nl2__UsageRecord*)a)->localuserid), "xsd:string"))
				{	soap_flag_localuserid1--;
					continue;
				}
			if (soap_flag_queue1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "queue", &(((nl2__UsageRecord*)a)->queue), "xsd:string"))
				{	soap_flag_queue1--;
					continue;
				}
			if (soap_flag_lrms1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "lrms", &(((nl2__UsageRecord*)a)->lrms), "xsd:string"))
				{	soap_flag_lrms1--;
					continue;
				}
			if (soap_flag_localjobid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "localjobid", &(((nl2__UsageRecord*)a)->localjobid), "xsd:string"))
				{	soap_flag_localjobid1--;
					continue;
				}
			if (soap_flag_lrmssubmissiontime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "lrmssubmissiontime", &(((nl2__UsageRecord*)a)->lrmssubmissiontime), "xsd:dateTime"))
				{	soap_flag_lrmssubmissiontime1--;
					continue;
				}
			if (soap_flag_lrmsendtime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "lrmsendtime", &(((nl2__UsageRecord*)a)->lrmsendtime), "xsd:dateTime"))
				{	soap_flag_lrmsendtime1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "nodename", &(((nl2__UsageRecord*)a)->nodename), "xsd:string"))
					continue;
			if (soap_flag_nodecount1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "nodecount", &(((nl2__UsageRecord*)a)->nodecount), "xsd:int"))
				{	soap_flag_nodecount1--;
					continue;
				}
			if (soap_flag_processors1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "processors", &(((nl2__UsageRecord*)a)->processors), "xsd:int"))
				{	soap_flag_processors1--;
					continue;
				}
			if (soap_flag_exitcode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "exitcode", &(((nl2__UsageRecord*)a)->exitcode), "xsd:int"))
				{	soap_flag_exitcode1--;
					continue;
				}
			if (soap_flag_failurestring1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "failurestring", &(((nl2__UsageRecord*)a)->failurestring), "xsd:string"))
				{	soap_flag_failurestring1--;
					continue;
				}
			if (soap_flag_usedcputime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "usedcputime", &(((nl2__UsageRecord*)a)->usedcputime), "xsd:int"))
				{	soap_flag_usedcputime1--;
					continue;
				}
			if (soap_flag_usedwalltime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "usedwalltime", &(((nl2__UsageRecord*)a)->usedwalltime), "xsd:int"))
				{	soap_flag_usedwalltime1--;
					continue;
				}
			if (soap_flag_usedmemory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "usedmemory", &(((nl2__UsageRecord*)a)->usedmemory), "xsd:int"))
				{	soap_flag_usedmemory1--;
					continue;
				}
			if (soap_flag_useddisk1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "useddisk", &(((nl2__UsageRecord*)a)->useddisk), "xsd:int"))
				{	soap_flag_useddisk1--;
					continue;
				}
			if (soap_flag_status1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "status", &(((nl2__UsageRecord*)a)->status), "xsd:string"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_endtime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "endtime", &(((nl2__UsageRecord*)a)->endtime), "xsd:dateTime"))
				{	soap_flag_endtime1--;
					continue;
				}
			if (soap_flag_downloadtime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "downloadtime", &(((nl2__UsageRecord*)a)->downloadtime), "xsd:int"))
				{	soap_flag_downloadtime1--;
					continue;
				}
			if (soap_flag_uploadtime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "uploadtime", &(((nl2__UsageRecord*)a)->uploadtime), "xsd:int"))
				{	soap_flag_uploadtime1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfint(soap, "processid", &(((nl2__UsageRecord*)a)->processid), "xsd:int"))
					continue;
			if (soap_flag_charge1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "charge", &(((nl2__UsageRecord*)a)->charge), "xsd:int"))
				{	soap_flag_charge1--;
					continue;
				}
			if (soap_flag_network1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "network", &(((nl2__UsageRecord*)a)->network), "xsd:string"))
				{	soap_flag_network1--;
					continue;
				}
			if (soap_flag_stageindata1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "stageindata", &(((nl2__UsageRecord*)a)->stageindata), "xsd:int"))
				{	soap_flag_stageindata1--;
					continue;
				}
			if (soap_flag_stageoutdata1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "stageoutdata", &(((nl2__UsageRecord*)a)->stageoutdata), "xsd:int"))
				{	soap_flag_stageoutdata1--;
					continue;
				}
			if (soap_flag_usedswap1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "usedswap", &(((nl2__UsageRecord*)a)->usedswap), "xsd:int"))
				{	soap_flag_usedswap1--;
					continue;
				}
			if (soap_flag_servicelevel1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "servicelevel", &(((nl2__UsageRecord*)a)->servicelevel), "xsd:string"))
				{	soap_flag_servicelevel1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "runtimeenvironment", &(((nl2__UsageRecord*)a)->runtimeenvironment), "xsd:string"))
					continue;
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((nl2__UsageRecord*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_globaljobid1 > 0 || soap_flag_globaluserid1 > 0 || soap_flag_cluster1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (nl2__UsageRecord *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__UsageRecord, 0, sizeof(nl2__UsageRecord), 0, soap_copy_nl2__UsageRecord);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 nl2__UsageRecord * SOAP_FMAC6 soap_new_nl2__UsageRecord(struct soap *soap, int n)
{	return soap_instantiate_nl2__UsageRecord(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_nl2__UsageRecord(struct soap *soap, nl2__UsageRecord *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 nl2__UsageRecord * SOAP_FMAC4 soap_instantiate_nl2__UsageRecord(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_nl2__UsageRecord(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_nl2__UsageRecord, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new nl2__UsageRecord;
		if (size)
			*size = sizeof(nl2__UsageRecord);
		((nl2__UsageRecord*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new nl2__UsageRecord[n];
		if (size)
			*size = n * sizeof(nl2__UsageRecord);
		for (int i = 0; i < n; i++)
			((nl2__UsageRecord*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (nl2__UsageRecord*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_nl2__UsageRecord(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying nl2__UsageRecord %p -> %p\n", q, p));
	*(nl2__UsageRecord*)p = *(nl2__UsageRecord*)q;
}

void nl2__Result::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &((nl2__Result*)this)->Description);
	/* transient soap skipped */
}

void nl2__Result::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_nl2__ResultCode(soap, &((nl2__Result*)this)->Code);
	((nl2__Result*)this)->Description = NULL;
	/* transient soap skipped */
}

int nl2__Result::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_nl2__Result);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int nl2__Result::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_nl2__Result(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_nl2__Result(struct soap *soap, const char *tag, int id, const nl2__Result *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_nl2__Result), type);
	soap_out_nl2__ResultCode(soap, "Code", -1, &(((nl2__Result*)a)->Code), "");
	soap_out_PointerTostd__string(soap, "Description", -1, &(((nl2__Result*)a)->Description), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *nl2__Result::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_nl2__Result(soap, this, tag, type);
}

SOAP_FMAC3 nl2__Result * SOAP_FMAC4 soap_get_nl2__Result(struct soap *soap, nl2__Result *p, const char *tag, const char *type)
{
	if ((p = soap_in_nl2__Result(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *nl2__Result::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_nl2__Result(soap, tag, this, type);
}

SOAP_FMAC3 nl2__Result * SOAP_FMAC4 soap_in_nl2__Result(struct soap *soap, const char *tag, nl2__Result *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (nl2__Result *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_nl2__Result, sizeof(nl2__Result), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_nl2__Result)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (nl2__Result *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Code1 = 1, soap_flag_Description1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Code1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_nl2__ResultCode(soap, "Code", &(((nl2__Result*)a)->Code), "nl2:ResultCode"))
				{	soap_flag_Code1--;
					continue;
				}
			if (soap_flag_Description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "Description", &(((nl2__Result*)a)->Description), "xsd:string"))
				{	soap_flag_Description1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Code1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (nl2__Result *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_nl2__Result, 0, sizeof(nl2__Result), 0, soap_copy_nl2__Result);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 nl2__Result * SOAP_FMAC6 soap_new_nl2__Result(struct soap *soap, int n)
{	return soap_instantiate_nl2__Result(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_nl2__Result(struct soap *soap, nl2__Result *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 nl2__Result * SOAP_FMAC4 soap_instantiate_nl2__Result(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_nl2__Result(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_nl2__Result, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new nl2__Result;
		if (size)
			*size = sizeof(nl2__Result);
		((nl2__Result*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new nl2__Result[n];
		if (size)
			*size = n * sizeof(nl2__Result);
		for (int i = 0; i < n; i++)
			((nl2__Result*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (nl2__Result*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_nl2__Result(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying nl2__Result %p -> %p\n", q, p));
	*(nl2__Result*)p = *(nl2__Result*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___nl2__get(struct soap *soap, const struct __nl2__get *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTonl2__getRequest(soap, &a->nl2__get);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___nl2__get(struct soap *soap, struct __nl2__get *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->nl2__get = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___nl2__get(struct soap *soap, const struct __nl2__get *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___nl2__get(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___nl2__get(struct soap *soap, const char *tag, int id, const struct __nl2__get *a, const char *type)
{
	soap_out_PointerTonl2__getRequest(soap, "nl2:get", -1, &a->nl2__get, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __nl2__get * SOAP_FMAC4 soap_get___nl2__get(struct soap *soap, struct __nl2__get *p, const char *tag, const char *type)
{
	if ((p = soap_in___nl2__get(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __nl2__get * SOAP_FMAC4 soap_in___nl2__get(struct soap *soap, const char *tag, struct __nl2__get *a, const char *type)
{
	short soap_flag_nl2__get = 1;
	a = (struct __nl2__get *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___nl2__get, sizeof(struct __nl2__get), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___nl2__get(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_nl2__get && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTonl2__getRequest(soap, "nl2:get", &a->nl2__get, "nl2:getRequest"))
				{	soap_flag_nl2__get--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __nl2__get * SOAP_FMAC6 soap_new___nl2__get(struct soap *soap, int n)
{	return soap_instantiate___nl2__get(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___nl2__get(struct soap *soap, struct __nl2__get *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __nl2__get * SOAP_FMAC4 soap_instantiate___nl2__get(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___nl2__get(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___nl2__get, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __nl2__get;
		if (size)
			*size = sizeof(struct __nl2__get);
	}
	else
	{	cp->ptr = (void*)new struct __nl2__get[n];
		if (size)
			*size = n * sizeof(struct __nl2__get);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __nl2__get*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___nl2__get(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __nl2__get %p -> %p\n", q, p));
	*(struct __nl2__get*)p = *(struct __nl2__get*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___nl2__add(struct soap *soap, const struct __nl2__add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTonl2__addRequest(soap, &a->nl2__add);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___nl2__add(struct soap *soap, struct __nl2__add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->nl2__add = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___nl2__add(struct soap *soap, const struct __nl2__add *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___nl2__add(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___nl2__add(struct soap *soap, const char *tag, int id, const struct __nl2__add *a, const char *type)
{
	soap_out_PointerTonl2__addRequest(soap, "nl2:add", -1, &a->nl2__add, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __nl2__add * SOAP_FMAC4 soap_get___nl2__add(struct soap *soap, struct __nl2__add *p, const char *tag, const char *type)
{
	if ((p = soap_in___nl2__add(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __nl2__add * SOAP_FMAC4 soap_in___nl2__add(struct soap *soap, const char *tag, struct __nl2__add *a, const char *type)
{
	short soap_flag_nl2__add = 1;
	a = (struct __nl2__add *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___nl2__add, sizeof(struct __nl2__add), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___nl2__add(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_nl2__add && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTonl2__addRequest(soap, "nl2:add", &a->nl2__add, "nl2:addRequest"))
				{	soap_flag_nl2__add--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC5 struct __nl2__add * SOAP_FMAC6 soap_new___nl2__add(struct soap *soap, int n)
{	return soap_instantiate___nl2__add(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete___nl2__add(struct soap *soap, struct __nl2__add *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct __nl2__add * SOAP_FMAC4 soap_instantiate___nl2__add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___nl2__add(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___nl2__add, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct __nl2__add;
		if (size)
			*size = sizeof(struct __nl2__add);
	}
	else
	{	cp->ptr = (void*)new struct __nl2__add[n];
		if (size)
			*size = n * sizeof(struct __nl2__add);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __nl2__add*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___nl2__add(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __nl2__add %p -> %p\n", q, p));
	*(struct __nl2__add*)p = *(struct __nl2__add*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTonl2__getResponse(struct soap *soap, nl2__getResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_nl2__getResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTonl2__getResponse(struct soap *soap, nl2__getResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTonl2__getResponse);
	if (soap_out_PointerTonl2__getResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTonl2__getResponse(struct soap *soap, const char *tag, int id, nl2__getResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_nl2__getResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 nl2__getResponse ** SOAP_FMAC4 soap_get_PointerTonl2__getResponse(struct soap *soap, nl2__getResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTonl2__getResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 nl2__getResponse ** SOAP_FMAC4 soap_in_PointerTonl2__getResponse(struct soap *soap, const char *tag, nl2__getResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (nl2__getResponse **)soap_malloc(soap, sizeof(nl2__getResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (nl2__getResponse *)soap_instantiate_nl2__getResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (nl2__getResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_nl2__getResponse, sizeof(nl2__getResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTonl2__getRequest(struct soap *soap, nl2__getRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_nl2__getRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTonl2__getRequest(struct soap *soap, nl2__getRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTonl2__getRequest);
	if (soap_out_PointerTonl2__getRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTonl2__getRequest(struct soap *soap, const char *tag, int id, nl2__getRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_nl2__getRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 nl2__getRequest ** SOAP_FMAC4 soap_get_PointerTonl2__getRequest(struct soap *soap, nl2__getRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTonl2__getRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 nl2__getRequest ** SOAP_FMAC4 soap_in_PointerTonl2__getRequest(struct soap *soap, const char *tag, nl2__getRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (nl2__getRequest **)soap_malloc(soap, sizeof(nl2__getRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (nl2__getRequest *)soap_instantiate_nl2__getRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (nl2__getRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_nl2__getRequest, sizeof(nl2__getRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTonl2__addResponse(struct soap *soap, nl2__addResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_nl2__addResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTonl2__addResponse(struct soap *soap, nl2__addResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTonl2__addResponse);
	if (soap_out_PointerTonl2__addResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTonl2__addResponse(struct soap *soap, const char *tag, int id, nl2__addResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_nl2__addResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 nl2__addResponse ** SOAP_FMAC4 soap_get_PointerTonl2__addResponse(struct soap *soap, nl2__addResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTonl2__addResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 nl2__addResponse ** SOAP_FMAC4 soap_in_PointerTonl2__addResponse(struct soap *soap, const char *tag, nl2__addResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (nl2__addResponse **)soap_malloc(soap, sizeof(nl2__addResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (nl2__addResponse *)soap_instantiate_nl2__addResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (nl2__addResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_nl2__addResponse, sizeof(nl2__addResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTonl2__addRequest(struct soap *soap, nl2__addRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_nl2__addRequest))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTonl2__addRequest(struct soap *soap, nl2__addRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTonl2__addRequest);
	if (soap_out_PointerTonl2__addRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTonl2__addRequest(struct soap *soap, const char *tag, int id, nl2__addRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_nl2__addRequest);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 nl2__addRequest ** SOAP_FMAC4 soap_get_PointerTonl2__addRequest(struct soap *soap, nl2__addRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTonl2__addRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 nl2__addRequest ** SOAP_FMAC4 soap_in_PointerTonl2__addRequest(struct soap *soap, const char *tag, nl2__addRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (nl2__addRequest **)soap_malloc(soap, sizeof(nl2__addRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (nl2__addRequest *)soap_instantiate_nl2__addRequest(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (nl2__addRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_nl2__addRequest, sizeof(nl2__addRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTonl2__Result(struct soap *soap, nl2__Result *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_nl2__Result))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTonl2__Result(struct soap *soap, nl2__Result *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTonl2__Result);
	if (soap_out_PointerTonl2__Result(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTonl2__Result(struct soap *soap, const char *tag, int id, nl2__Result *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_nl2__Result);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 nl2__Result ** SOAP_FMAC4 soap_get_PointerTonl2__Result(struct soap *soap, nl2__Result **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTonl2__Result(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 nl2__Result ** SOAP_FMAC4 soap_in_PointerTonl2__Result(struct soap *soap, const char *tag, nl2__Result **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (nl2__Result **)soap_malloc(soap, sizeof(nl2__Result *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (nl2__Result *)soap_instantiate_nl2__Result(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (nl2__Result **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_nl2__Result, sizeof(nl2__Result), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTonl2__UsageRecord(struct soap *soap, nl2__UsageRecord *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_nl2__UsageRecord))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTonl2__UsageRecord(struct soap *soap, nl2__UsageRecord *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTonl2__UsageRecord);
	if (soap_out_PointerTonl2__UsageRecord(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTonl2__UsageRecord(struct soap *soap, const char *tag, int id, nl2__UsageRecord *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_nl2__UsageRecord);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 nl2__UsageRecord ** SOAP_FMAC4 soap_get_PointerTonl2__UsageRecord(struct soap *soap, nl2__UsageRecord **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTonl2__UsageRecord(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 nl2__UsageRecord ** SOAP_FMAC4 soap_in_PointerTonl2__UsageRecord(struct soap *soap, const char *tag, nl2__UsageRecord **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (nl2__UsageRecord **)soap_malloc(soap, sizeof(nl2__UsageRecord *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (nl2__UsageRecord *)soap_instantiate_nl2__UsageRecord(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (nl2__UsageRecord **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_nl2__UsageRecord, sizeof(nl2__UsageRecord), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTotime(struct soap *soap, time_t *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_time);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTotime(struct soap *soap, time_t *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTotime);
	if (soap_out_PointerTotime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTotime(struct soap *soap, const char *tag, int id, time_t *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_time);
	if (id < 0)
		return soap->error;
	return soap_out_time(soap, tag, id, *a, type);
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_get_PointerTotime(struct soap *soap, time_t **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTotime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_in_PointerTotime(struct soap *soap, const char *tag, time_t **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (time_t **)soap_malloc(soap, sizeof(time_t *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_time(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (time_t **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_time, sizeof(time_t), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
	if (soap_out_PointerToint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
	if (id < 0)
		return soap->error;
	return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToint(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__string(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__string))
		soap_serialize_std__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__string(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__string);
	if (soap_out_PointerTostd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__string(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__string);
	if (id < 0)
		return soap->error;
	return soap_out_std__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTostd__string(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTostd__string(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_std__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__string, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, const std::vector<nl2__UsageRecord * >*a)
{
	for (std::vector<nl2__UsageRecord * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTonl2__UsageRecord(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, std::vector<nl2__UsageRecord * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, const char *tag, int id, const std::vector<nl2__UsageRecord * >*a, const char *type)
{
	for (std::vector<nl2__UsageRecord * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTonl2__UsageRecord(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<nl2__UsageRecord * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, const char *tag, std::vector<nl2__UsageRecord * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, -1)))
		return NULL;
	nl2__UsageRecord *n;
	nl2__UsageRecord **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_nl2__UsageRecord, SOAP_TYPE_std__vectorTemplateOfPointerTonl2__UsageRecord, sizeof(nl2__UsageRecord), 1))
				break;
			if (!(p = soap_in_PointerTonl2__UsageRecord(soap, tag, NULL, "nl2:UsageRecord")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTonl2__UsageRecord(soap, tag, &n, "nl2:UsageRecord"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<nl2__UsageRecord * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTonl2__UsageRecord(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, std::vector<nl2__UsageRecord * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<nl2__UsageRecord * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTonl2__UsageRecord(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTonl2__UsageRecord, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<nl2__UsageRecord * >;
		if (size)
			*size = sizeof(std::vector<nl2__UsageRecord * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<nl2__UsageRecord * >[n];
		if (size)
			*size = n * sizeof(std::vector<nl2__UsageRecord * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<nl2__UsageRecord * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTonl2__UsageRecord(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<nl2__UsageRecord * > %p -> %p\n", q, p));
	*(std::vector<nl2__UsageRecord * >*)p = *(std::vector<nl2__UsageRecord * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfint(struct soap *soap, const std::vector<int >*a)
{
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfint(struct soap *soap, std::vector<int >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfint(struct soap *soap, const char *tag, int id, const std::vector<int >*a, const char *type)
{
	for (std::vector<int >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_int(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<int >* SOAP_FMAC4 soap_in_std__vectorTemplateOfint(struct soap *soap, const char *tag, std::vector<int >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfint(soap, -1)))
		return NULL;
	int n;
	int *p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_int, SOAP_TYPE_std__vectorTemplateOfint, sizeof(int), 0))
				break;
			if (!(p = soap_in_int(soap, tag, NULL, "xsd:int")))
				break;
		}
		else
		{	soap_default_int(soap, &n);
			if (!soap_in_int(soap, tag, &n, "xsd:int"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<int > * SOAP_FMAC6 soap_new_std__vectorTemplateOfint(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfint(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfint(struct soap *soap, std::vector<int >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<int > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfint(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfint(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfint, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<int >;
		if (size)
			*size = sizeof(std::vector<int >);
	}
	else
	{	cp->ptr = (void*)new std::vector<int >[n];
		if (size)
			*size = n * sizeof(std::vector<int >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<int >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfint(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<int > %p -> %p\n", q, p));
	*(std::vector<int >*)p = *(std::vector<int >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfstd__string(struct soap *soap, const std::vector<std::string >*a)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_std__string(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, int id, const std::vector<std::string >*a, const char *type)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_std__string(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<std::string >* SOAP_FMAC4 soap_in_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, std::vector<std::string >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfstd__string(soap, -1)))
		return NULL;
	std::string n;
	std::string *p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_std__string, SOAP_TYPE_std__vectorTemplateOfstd__string, sizeof(std::string), 0))
				break;
			if (!(p = soap_in_std__string(soap, tag, NULL, "xsd:string")))
				break;
		}
		else
		{	soap_default_std__string(soap, &n);
			if (!soap_in_std__string(soap, tag, &n, "xsd:string"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<std::string > * SOAP_FMAC6 soap_new_std__vectorTemplateOfstd__string(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfstd__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<std::string > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfstd__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfstd__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfstd__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<std::string >;
		if (size)
			*size = sizeof(std::vector<std::string >);
	}
	else
	{	cp->ptr = (void*)new std::vector<std::string >[n];
		if (size)
			*size = n * sizeof(std::vector<std::string >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<std::string >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfstd__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<std::string > %p -> %p\n", q, p));
	*(std::vector<std::string >*)p = *(std::vector<std::string >*)q;
}

/* End of logger2_soapC.cpp */
