#include "../../std.h"

#include "disk_space.h"

#include "../../misc/log_time.h"

DiskSpace::DiskSpace(void) {
  blocks_=0;
  path_="";
  bsize_=0;
}

DiskSpace::DiskSpace(const char* p) {
  blocks_=0;
  path_=p;
  bsize_=0;
  struct statfs dst;
  if(statfs((char*)(path_.c_str()),&dst) != 0) return;
  bsize_=dst.f_bsize;
}

DiskSpace::~DiskSpace(void) {
}

bool DiskSpace::request(uint64_t si_new,uint64_t si_old) {
  if(!bsize_) return false;
  uint64_t b_new = (si_new+bsize_-1)/bsize_;
  uint64_t b_old = (si_old+bsize_-1)/bsize_;
  if(b_new <= b_old) {
    if((b_old-b_new) > blocks_) return false; // sync lost
    blocks_-=(b_old-b_new);
    return true;
  };
  struct statfs dst;
  if(statfs((char*)(path_.c_str()),&dst) != 0) return false;
  if(((b_new-b_old)+blocks_) > dst.f_bavail) {
    odlog(INFO)<<"Not enough space to allocate "<<(b_new-b_old)<<
              " blocks in addition to "<<blocks_<<
              " from physically available "<<dst.f_bavail<<")"<<std::endl;
    return false; // not enough space
  };
  blocks_+=(b_new-b_old);
  return true;
}

class DiskSpaceList {
 private:
 public:
  DiskSpaceList(void);
  ~DiskSpaceList(void);
};

DiskSpaceLink::DiskSpaceLink(uint64_t si,DiskSpace& sp):space_(sp),size_(0) {
  space_.block();
  if(space_) if(space_.request(si,0)) size_=si;
  space_.unblock();
}

bool DiskSpaceLink::request(uint64_t si) {
  space_.block();
  bool res=false;
  if(space_) {
    if(space_.request(size_+si,size_)) {
      size_+=si; res=true;
    };
  };
  space_.unblock();
  return res;
}

bool DiskSpaceLink::release(uint64_t si) {
  space_.block();
  bool res=false;
  if(space_) {
    if(si<=size_) {
      if(space_.request(size_-si,size_)) { size_-=si; res=true; };
    } else {
      if(space_.request(0,size_)) { size_=0; res=true; };
    };
  };
  space_.unblock();
  return res;
}

DiskSpaceLink::~DiskSpaceLink(void) {
  space_.block();
  if(space_) space_.request(0,size_);
  space_.unblock();
}

