/* file_soapServer.cpp
   Generated by gSOAP 2.7.8a from file_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
#include "file_soapH.h"

SOAP_SOURCE_STAMP("@(#) file_soapServer.cpp ver 2.7.8a 2009-04-06 10:45:31 GMT")


SOAP_FMAC5 int SOAP_FMAC6 file_soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || file_soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 file_soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "ns:add"))
		return soap_serve_ns__add(soap);
	if (!soap_match_tag(soap, soap->tag, "ns:update"))
		return soap_serve_ns__update(soap);
	if (!soap_match_tag(soap, soap->tag, "ns:info"))
		return soap_serve_ns__info(soap);
	if (!soap_match_tag(soap, soap->tag, "ns:acl"))
		return soap_serve_ns__acl(soap);
	if (!soap_match_tag(soap, soap->tag, "ns:del"))
		return soap_serve_ns__del(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns__add(struct soap *soap)
{	struct ns__add soap_tmp_ns__add;
	struct ns__addResponse r;
	soap_default_ns__addResponse(soap, &r);
	soap_default_ns__add(soap, &soap_tmp_ns__add);
	soap->encodingStyle = NULL;
	if (!soap_get_ns__add(soap, &soap_tmp_ns__add, "ns:add", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns__add(soap, soap_tmp_ns__add.file, soap_tmp_ns__add.__size_source, soap_tmp_ns__add.source, r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns__addResponse(soap, &r);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns__addResponse(soap, &r, "ns:addResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns__addResponse(soap, &r, "ns:addResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns__update(struct soap *soap)
{	struct ns__update soap_tmp_ns__update;
	struct ns__updateResponse r;
	soap_default_ns__updateResponse(soap, &r);
	soap_default_ns__update(soap, &soap_tmp_ns__update);
	soap->encodingStyle = NULL;
	if (!soap_get_ns__update(soap, &soap_tmp_ns__update, "ns:update", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns__update(soap, soap_tmp_ns__update.file, r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns__updateResponse(soap, &r);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns__updateResponse(soap, &r, "ns:updateResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns__updateResponse(soap, &r, "ns:updateResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns__info(struct soap *soap)
{	struct ns__info soap_tmp_ns__info;
	struct ns__infoResponse r;
	soap_default_ns__infoResponse(soap, &r);
	soap_default_ns__info(soap, &soap_tmp_ns__info);
	soap->encodingStyle = NULL;
	if (!soap_get_ns__info(soap, &soap_tmp_ns__info, "ns:info", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns__info(soap, soap_tmp_ns__info.pattern, r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns__infoResponse(soap, &r);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns__infoResponse(soap, &r, "ns:infoResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns__infoResponse(soap, &r, "ns:infoResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns__acl(struct soap *soap)
{	struct ns__acl soap_tmp_ns__acl;
	struct ns__aclResponse r;
	soap_default_ns__aclResponse(soap, &r);
	soap_default_ns__acl(soap, &soap_tmp_ns__acl);
	soap->encodingStyle = NULL;
	if (!soap_get_ns__acl(soap, &soap_tmp_ns__acl, "ns:acl", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns__acl(soap, soap_tmp_ns__acl.acl, r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns__aclResponse(soap, &r);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns__aclResponse(soap, &r, "ns:aclResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns__aclResponse(soap, &r, "ns:aclResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns__del(struct soap *soap)
{	struct ns__del soap_tmp_ns__del;
	struct ns__delResponse r;
	soap_default_ns__delResponse(soap, &r);
	soap_default_ns__del(soap, &soap_tmp_ns__del);
	soap->encodingStyle = NULL;
	if (!soap_get_ns__del(soap, &soap_tmp_ns__del, "ns:del", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns__del(soap, r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns__delResponse(soap, &r);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns__delResponse(soap, &r, "ns:delResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns__delResponse(soap, &r, "ns:delResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

/* End of file_soapServer.cpp */
