#include "../../std.h"

#include "../../misc/log_time.h"

#include "se_ns.h"
#include "se_ns_none.h"
#include "se_ns_rc.h"
#include "se_ns_rls.h"
#include "se_ns_lrc.h"

SENameServer* create_ns(const char* contact,const char* se_url) {
  SENameServer* ns = NULL;
  if((contact == NULL) || (contact[0] == 0) || 
     (strcasecmp(contact,"none")==0)) {
    odlog(ERROR)<<"SE: 'none' nameserver"<<std::endl;
    ns = new SENameServerNone(contact,se_url);
  } else if(strncasecmp("rc://",contact,5) == 0) {
    odlog(ERROR)<<"SE: ReplicaCatalog nameserver: "<<contact<<std::endl;
    ns = new SENameServerRC(contact,se_url);
#ifdef HAVE_GLOBUS_RLS_CLIENT_H
  } else if(strncasecmp("rls://",contact,6) == 0) {
    odlog(ERROR)<<"SE: Replica Location Service (Index) nameserver: "<<contact<<std::endl;
    ns = new SENameServerRLS(contact,se_url);
  } else if(strncasecmp("lrc://",contact,6) == 0) {
    odlog(ERROR)<<"SE: Replica Location Service (Catalog) nameserver: "<<contact<<std::endl;
    ns = new SENameServerLRC(contact,se_url);
#endif
  } else {
    odlog(ERROR)<<"SE: unrecognized nameserver"<<std::endl;
  };
  if(ns) if(!(*ns)) { delete ns; ns=NULL; };
  if(!ns) { odlog(ERROR)<<"SE: failed to create nameserver"<<std::endl; };
  return ns;
};

std::string SENameServer::url(SEAttributes& file) {
  std::string url = contact();
  url+="/"; url+=file.id();
  return url;
};

