#ifdef HAVE_GLOBUS_RLS_CLIENT_H

#include <ldap.h>
#include <string>
#include <list>

#include "../../misc/url_options.h"
#include "../../misc/time_utils.h"
#include "file.h"
#include "se_ns.h"

class SENameServerLRC: public SENameServer {
 private:
  bool valid;
  LockSimple lock;
  std::list<std::string> urls;
  TimeInterval delta;
 public:
  SENameServerLRC(const char* contact,const char* se_url);
  virtual ~SENameServerLRC(void);
  virtual int Register(SEFile& file,bool require_unique);
  virtual int Unregister(SEFile& file,bool allow_last);
  virtual int Modify(SEFile& file);
  virtual int Get(SEAttributes& file);
  virtual int Maintain(void);
  virtual operator bool(void) { return valid; };
  virtual std::string url(SEAttributes& file);
};

#endif
