#include "../../std.h"

#ifdef HAVE_GLOBUS_RLS_CLIENT_H

extern "C" {
#include <globus_rls_client.h>
#include <globus_rls_rpc.h>
};

#include "se_ns_rls.h"

#define RLI_UPDATE "rli_update"
#define RLI_MAXLFNS 200

// Collect lfns to lists

// On list overflow register

// On timeout register

// 

static std::string fix_se_url(const char* url) {
  std::string u(url);
  //if(strncasecmp(u.c_str(),"httpg://",8) == 0) {
  //  u.replace(0,5,"se");
  //} else { 
  //  return u;
  //};
  std::string::size_type p = u.find('/',5);
  for(;p != std::string::npos;) {
    u.replace(p,1,"\\"); p = u.find('/',p+1);
  };
  return u;
}

SENameServerRLS::SENameServerRLS(const char* contact,const char* se_url):SENameServer(contact,fix_se_url(se_url).c_str()),rli_vec_n(0) {
  valid=false;
  globus_module_activate(GLOBUS_COMMON_MODULE);
  globus_module_activate(GLOBUS_IO_MODULE);
  globus_module_activate(GLOBUS_RLS_CLIENT_MODULE);
  valid=true;
};

int SENameServerRLS::Connect(void) { return 0; };

int SENameServerRLS::Disconnect(void) {
  lock.block();
  int r = send_registration();
  lock.unblock();
  if(r != GLOBUS_RLS_SUCCESS) return -1;
  return 0;
};

int SENameServerRLS::Register(SEFile& file,bool require_unique) {
  lock.block();
  if(rli_vec_n < 2) rli_vec_n=2;
  int l = strlen(file.id());
  rli_vec[rli_vec_n].iov_base = (char*)malloc(l+2);
  if(rli_vec[rli_vec_n].iov_base==NULL) return -1;
  ((char*)(rli_vec[rli_vec_n].iov_base))[0]='A';
  memcpy(((char*)(rli_vec[rli_vec_n].iov_base))+1,file.id(),l+1);
  rli_vec[rli_vec_n].iov_len=l+2;
  rli_vec_n++;
  if(rli_vec_n>=(rli_vec_size-1)) {
    // run real registration (TODO - timeouts)
    if(send_registration() != 0) {
      rli_vec_n--; // remove last added lfn
      free(rli_vec[rli_vec_n].iov_base);
      lock.unblock();
      return 1;
    };
  };
  lock.unblock();
  return 0;
};

int SENameServerRLS::Unregister(SEFile& file,bool allow_last) {
  lock.block();
  if(rli_vec_n < 2) rli_vec_n=2;
  int l = strlen(file.id());
  rli_vec[rli_vec_n].iov_base = (char*)malloc(l+2);
  if(rli_vec[rli_vec_n].iov_base==NULL) return -1;
  ((char*)(rli_vec[rli_vec_n].iov_base))[0]='D';
  memcpy(((char*)(rli_vec[rli_vec_n].iov_base))+1,file.id(),l+1);
  rli_vec[rli_vec_n].iov_len=l+2;
  rli_vec_n++;
  if(rli_vec_n>=(rli_vec_size-1)) {
    // run real registration (TODO - timeouts)
    if(send_registration() != 0) {
      rli_vec_n--; // remove last added lfn
      free(rli_vec[rli_vec_n].iov_base);
      lock.unblock();
      return 1;
    };
  };
  lock.unblock();
  return 0;
};

int SENameServerRLS::send_registration(void) {
  globus_rls_handle_t* h;
  char errbuf[MAXERRMSG];
  globus_size_t nb;
  globus_result_t r;
  int rc;
  BUFFER b;

  rli_vec[0].iov_base=(void*)(RLI_UPDATE);
  rli_vec[0].iov_len=sizeof(RLI_UPDATE);
  rli_vec[1].iov_base=(void*)se_url();
  rli_vec[1].iov_len=strlen(se_url())+1;
  if(rli_vec_n < 2) rli_vec_n=2;
  rli_vec[rli_vec_n].iov_base=(void*)("");
  rli_vec[rli_vec_n].iov_len=1;
  errbuf[0]=0;
  if((r=globus_rls_client_connect((char*)(contact()),&h)) != GLOBUS_SUCCESS){
    globus_rls_client_error_info(r,NULL,errbuf,sizeof(errbuf),GLOBUS_FALSE);
    std::cerr<<"globus_rls_client_connect failed: "<<errbuf<<std::endl;
    return -1;
  };
std::cerr<<"rrpc_writev: "<<rli_vec_n<<std::endl;
for(int i = 0; i<=rli_vec_n; i++) {
  std::cerr<<" "<<rli_vec[i].iov_len<<" - "<<(char*)(rli_vec[i].iov_base)<<std::endl;
};
  if((rc=rrpc_writev(&h->handle,rli_vec,rli_vec_n+1,&nb,errbuf))
                                                       == GLOBUS_RLS_SUCCESS) {
    std::cerr<<"getting result"<<std::endl;
    rc=rrpc_getresult(h,&b,errbuf);
  };
  std::cerr<<"Result: "<<rc<<" - "<<errbuf<<std::endl;
  globus_rls_client_close(h);
  if(rc==0) {
    for(;rli_vec_n>2;rli_vec_n--) free(rli_vec[rli_vec_n].iov_base);
    rli_vec_n=2;
  };
  return rc;
}

int SENameServerRLS::Modify(SEFile& file) { return 0; };

int SENameServerRLS::Get(SEAttributes& file) { return 0; };

SENameServerRLS::~SENameServerRLS(void) {
  globus_module_deactivate(GLOBUS_RLS_CLIENT_MODULE);
  globus_module_deactivate(GLOBUS_IO_MODULE);
  globus_module_deactivate(GLOBUS_COMMON_MODULE);
}

#endif
