#ifndef __ARC_TIME_UTILS_H__
#define __ARC_TIME_UTILS_H__

#include <time.h>
#include <string>

int stringtotime(struct tm &t,const std::string &s);
int timetostring(const struct tm &t,std::string &s);
std::string timetostring(const struct tm &t);
int stringtotime(time_t &t,const std::string &s);
int timetostring(const time_t &t,std::string &s);
std::string timetostring(const time_t &t);

class TimeInterval {
 private:
  unsigned int delta;
  time_t last;
 public:
  TimeInterval(unsigned int d):delta(d) {
    reset();
  };
  bool test(void) {
    bool r = false;
    time_t current = time(NULL);
    while( ((unsigned int)(current - last)) > delta ) {
      r=true; last+=delta;
    };
    return r;
  };
  void reset(void) {
    last=time(NULL)-delta;
  };
};

#endif // __ARC_TIME_UTILS_H__
