#ifndef __URL_MAP_H__
#define __URL_MAP_H__

#include <string>
#include <list>

class UrlMap {
 private:
  class map_entry {
   public:
    std::string initial;
    std::string replacement;
    std::string access;
    map_entry(void):initial(""),replacement(""),access("") {
    };
    map_entry(const std::string &templ,const std::string &repl,const std::string &accs = "") {
      initial=templ; replacement=repl; access=accs;
    };
    map_entry(const char* templ,const char* repl,const char* accs = "") {
      initial=templ; replacement=repl; access=accs;
    };
  };
  std::list<map_entry> entries;
 public:
  UrlMap(void);
  ~UrlMap(void);
  bool map(std::string &url) const;
  bool local(const std::string &url) const;
  void add(const std::string &templ,const std::string &repl,const std::string &accs = "");
  void add(const char* templ,const char* repl,const char* accs = "");
};

#endif
