#include "../std.h"
#include <cstdio>
#include <fstream>
#include "../jobs/users.h"
#include "../jobs/states.h"
#include "../jobs/plugins.h"
#include "../config/conf.h"
#include "../config/environment.h"
#include "../config/config_file.h"
#include "../files/info_types.h"
#include "../files/info_files.h"
#include "../misc/time_utils.h"

#ifdef NG_WRAPPER
#include "../../userinterface/wrapper.cpp"
#endif

bool job_log_make_file(const JobDescription &desc,JobUser &user,const std::string &url) {
  return false;
}

int main(int argc,char* argv[]) {
#ifdef NG_WRAPPER
  if((!getenv("NORDUGRID_ENVIRONMENT_SETUP")) &&
     (!getenv("ARC_ENVIRONMENT_SETUP"))) wrapper(argv);
#endif
  int n;
  bool short_output = true;
  bool quit_early = false;
  std::string my_username("");
  std::string control_dir("");
  uid_t my_uid=getuid();
  JobUser *my_user = NULL;
  while((n=getopt(argc,argv,"hlZqu:U:c:d:")) != -1) {
    switch(n) {
      case ':': { std::cerr<<"Missing argument\n"; return 1; };
      case 'h': {
        std::cout<<"gm-jobs [-h] [-l] [-q] [-u uid] [-U name] [-Z] [-c config_file] [-d control_dir]\n";
        return 0;
      };
      case 'l': {
        short_output=false;
      }; break;
      case 'q': {
        quit_early=true;
      }; break;
      case 'u': {
        char* p;
        my_uid=strtol(optarg,&p,0);
        if((p == optarg) || (*p != 0)) {
          std::cerr<<"Bad user id"<<std::endl; return -1;
        };
      }; break;
      case 'U': {
        {
          struct passwd pw_;
          struct passwd *pw;
          char buf[BUFSIZ];
          getpwnam_r(optarg,&pw_,buf,BUFSIZ,&pw);
          if(pw == NULL) {
            std::cerr<<"Unknown user: "<<optarg<<std::endl; return -1;
          };
          my_uid=pw->pw_uid;
        };
      }; break;
      case 'Z': {
        central_configuration=true;
      }; break;
      case 'c': {
        nordugrid_config_loc=optarg;
      }; break;
      case 'd': {
        control_dir = optarg;
      }; break;
      default: break;
    };
  };
  if(!read_env_vars()) exit(1);
  JobUsers users;
  /* recognize itself */
  {
    struct passwd pw_;
    struct passwd *pw;
    char buf[BUFSIZ];
    getpwuid_r(my_uid,&pw_,buf,BUFSIZ,&pw);
    if(pw != NULL) { my_username=pw->pw_name; };
  };
  if(my_username.length() == 0) {
    std::cerr << "Can't recognize myself." << std::endl; return -1;
  };
  if (control_dir.empty()) {
    my_user = new JobUser(my_username);
    if(!configure_serviced_users(users,my_uid,my_username,*my_user)) {
      std::cout<<"Error processing configuration."<<std::endl; return -1;
    };
    if(users.size() == 0) {
      std::cout<<"No suitable users found in configuration."<<std::endl; return -1;
    };
    print_serviced_users(users);
  }
  else {
    ContinuationPlugins plugins;
    JobUsers::iterator jobuser = users.AddUser(my_username, NULL, control_dir);
    JobsList *jobs = new JobsList(*jobuser,plugins); 
    (*jobuser)=jobs; 
  }

  if(quit_early) return 0;

  std::cout << "Looking for current jobs" << std::endl;
  unsigned int counters[JOB_STATE_NUM];
  unsigned int counters_pending[JOB_STATE_NUM];
  for(int i=0;i<JOB_STATE_NUM;i++) { counters[i]=0; counters_pending[i]=0; };
  unsigned int jobs_total = 0;
  for(JobUsers::iterator user = users.begin();user != users.end();++user) {
    user->get_jobs()->ScanNewJobs(false);
    for(JobsList::iterator i=user->get_jobs()->begin();i!=user->get_jobs()->end();++i) {
      std::cout << "Job: "<<i->get_id();
      jobs_total++;
      bool pending;
      job_state_t new_state=job_state_read_file(i->get_id(),*user,pending);
      time_t job_time = job_state_time(i->get_id(),*user);
      counters[new_state]++;
      if(pending) counters_pending[new_state]++;
      if(new_state == JOB_STATE_UNDEFINED) {
        std::cout<<" : ERROR : Unrecognizable state"<<std::endl; continue;
      };
      JobLocalDescription job_desc;
      if(!job_local_read_file(i->get_id(),*user,job_desc)) {
        std::cout<<" : ERROR : No local information."<<std::endl; continue;
      };
      if(short_output) {
        std::string s(""); if(job_time) timetostring(job_time,s);
        std::cout<<" : "<<states_all[new_state].name<<" : "<<job_desc.DN<<" : "<<s<<std::endl;
        continue;
      };
      std::cout<<std::endl;
      std::cout<<"\tState: "<<states_all[new_state].name;
      if(pending) std::cout<<" (PENDING)";
      std::cout<<std::endl;
      if(job_time) {
        std::string s; timetostring(job_time,s);
        std::cout<<"\tModified: "<<s<<std::endl;
      };
      std::cout<<"\tUser: "<<job_desc.DN<<std::endl;
      if(job_desc.localid.length()) std::cout<<"\tLRMS id: "<<job_desc.localid<<std::endl;
      if(job_desc.jobname.length()) std::cout<<"\tName: "<<job_desc.jobname<<std::endl;
      if(job_desc.clientname.length()) std::cout<<"\tFrom: "<<job_desc.clientname<<std::endl;
    };
  };
  std::cout<<"Jobs total: "<<jobs_total<<std::endl;
  for(int i=0;i<JOB_STATE_UNDEFINED;i++) {
    std::cout<<" "<<states_all[i].name<<": "<<counters[i]<<" ("<<counters_pending[i]<<")"<<std::endl;
  };
  int max;
  int max_running;
  int max_processing;
  int max_processing_emergency;
  int max_down;
  JobsList::GetMaxJobs(max,max_running);
  JobsList::GetMaxJobsLoad(max_processing,max_processing_emergency,max_down);
  #undef jobs_pending
  #define jobs_pending 0
  #undef jobs_num
  #define jobs_num counters
  int accepted = JOB_NUM_ACCEPTED;
  int running = JOB_NUM_RUNNING;
  #undef jobs_num
  #define jobs_num counters_pending
  //accepted-=JOB_NUM_ACCEPTED;
  running-=JOB_NUM_RUNNING;
  std::cout<<" Accepted: "<<accepted<<"/"<<max<<std::endl;
  std::cout<<" Running: "<<running<<"/"<<max_running<<std::endl;
  std::cout<<" Processing: "<<
    counters[JOB_STATE_PREPARING]-counters_pending[JOB_STATE_PREPARING]<<"+"<<
    counters[JOB_STATE_FINISHING]-counters_pending[JOB_STATE_FINISHING]<<"/"<<
    max_processing<<"+"<<max_processing_emergency<<std::endl;
  return 0;
}

/* Gross hack */
#include "../run/run.h"
#include "../run/run_commands.h"

RunElement* RunCommands::fork(const JobUser& user,const char* cmdname) {
  return NULL;
}

int RunCommands::wait(RunElement* re,int timeout,char* cmdname) {
  return -1;
}

int mkdir(JobUser& user,const char *pathname, mode_t mode) { return -1; }
int open(JobUser& user,const char *pathname, int flags) { return -1; }
int open(JobUser& user,const char *pathname, int flags, mode_t mode) { return -1; }
int creat(JobUser& user,const char *pathname, mode_t mode)  { return -1; }
int stat(JobUser& user,const char *file_name, struct stat *buf) { return -1; }
int lstat(JobUser& user,const char *file_name, struct stat *buf) { return -1; }
int delete_all_files(JobUser& user,const std::string &dir_base,
  std::list<FileData> &files,bool excl,bool lfn_exs,bool lfn_mis) { return -1; }
int remove(JobUser& user,const char *pathname)  { return -1; }
int rmdir(JobUser& user,const char *pathname) { return -1; }
int unlink(JobUser& user,const char *pathname) { return -1; }
bool fix_file_permissions(JobUser& user,const std::string &fname,bool executable) { return false; }

bool Run::plain_run_redirected(char *const args[],int din,int dout,int derr,int& timeout,int* result) { return false; }

#include <arc/notify.h>

Notify* Notify::getNotifier(void) { return NULL; }

void Notify::SetOutStream(std::ostream&) { };

void Notify::SetNotifyLevel(const NotifyLevel) { };

void Notify::SetNotifyTimeStamp(bool) { };
