#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>
#include <vector>
#include <algorithm>
#include <ctype.h>

#include "Environment.h"

// need to wrap for gcc 3.2
inline int to_lower (int x) { return tolower(x); }


EnvVersion::EnvVersion (const long long int v1, const long long int v2,
			const long long int v3, const long long int v4) {

  version [0] = v1;
  version [1] = v2;
  version [2] = v3;
  version [3] = v4;
}

EnvVersion::EnvVersion (const std::string & vers) {

  std::string::size_type pos = 0;
  for (int level = 0; level < 4; level++) {
    if (pos != std::string::npos) pos = vers.find_first_of ("0123456789", pos);
    if (pos != std::string::npos) {
      std::string::size_type ppos = vers.find_first_not_of ("0123456789", pos);
      if (ppos != std::string::npos)
	version [level] = atoll (vers.substr (pos, ppos - pos).c_str());
      else
	version [level] = atoll (vers.substr (pos).c_str());
      pos = ppos;
    }
    else
      version [level] = 0;
  }
}

bool EnvVersion::operator== (const EnvVersion & vers) const {

  return (version [0] == vers.version [0] &&
	  version [1] == vers.version [1] &&
	  version [2] == vers.version [2] &&
	  version [3] == vers.version [3]);
}

bool EnvVersion::operator!= (const EnvVersion & vers) const {

  return !(*this == vers);
}

bool EnvVersion::operator> (const EnvVersion & vers) const {

  if (version [0] > vers.version [0])
    return true;
  else if (version [0] == vers.version [0])
    if (version [1] > vers.version [1])
      return true;
    else if (version [1] == vers.version [1])
      if (version [2] > vers.version [2])
	return true;
      else if (version [2] == vers.version [2])
	if (version [3] > vers.version [3])
	  return true;
  return false;
}

bool EnvVersion::operator< (const EnvVersion & vers) const {

  if (version [0] < vers.version [0])
    return true;
  else if (version [0] == vers.version [0])
    if (version [1] < vers.version [1])
      return true;
    else if (version [1] == vers.version [1])
      if (version [2] < vers.version [2])
	return true;
      else if (version [2] == vers.version [2])
	if (version [3] < vers.version [3])
	  return true;
  return false;
}

bool EnvVersion::operator>= (const EnvVersion & vers) const {

  return !(*this < vers);
}

bool EnvVersion::operator<= (const EnvVersion & vers) const {

  return !(*this > vers);
}

bool EnvVersion::operator! () const {

  return (!version[0] && !version[1] && !version[2] && !version[3]);
}

std::ostream & operator<< (std::ostream & os, const EnvVersion & vers) {

  os << vers.version [0] << '.' << vers.version [1] << '.'
     << vers.version [2] << '.' << vers.version [3];
  return os;
}


EnvVersionWithSign::EnvVersionWithSign (const short int v1,
					const short int v2,
					const short int v3,
					const short int v4,
					const Env::Sign s) : EnvVersion (v1,
									 v2,
									 v3,
									 v4),
							     sgn (s) {}

EnvVersionWithSign::EnvVersionWithSign (const std::string & vers,
					const Env::Sign s) : EnvVersion (vers),
							     sgn (s) {}

EnvVersionWithSign::EnvVersionWithSign (const EnvVersion & vers,
					const Env::Sign s) : EnvVersion (vers),
							     sgn (s) {}

Env::Sign EnvVersionWithSign::GetSign () const { return sgn; }


Environment::Environment (const std::string & env) : original (env) {

  std::string::size_type pos = env.find_first_of (" -");
  while ((pos != std::string::npos) && !(isdigit (env [pos + 1])))
    pos = env.find_first_of (" -", pos + 1);
  if (pos != std::string::npos) {
    envname = env.substr (0, pos);
    version = env.substr (pos + 1);
  }
  else
    envname = env;
  std::transform (envname.begin(), envname.end(), envname.begin(), to_lower);
}

const std::string & Environment::GetOriginal () const { return original; }

const std::string & Environment::GetName () const { return envname; }

const EnvVersion & Environment::GetVersion () const { return version; }

std::ostream & operator<< (std::ostream & os, const Environment & env) {

  os << env.envname << '-' << env.version;
  return os;
}


EnvironmentTest::EnvironmentTest (const Environment & env, const Env::Sign s) {

  envname = env.GetName();
  if ((env.GetOriginal().length() == envname.length()) && (s == Env::eq))
    version.push_back (EnvVersionWithSign (env.GetVersion(), Env::ge));
  else
    version.push_back (EnvVersionWithSign (env.GetVersion(), s));
}

bool EnvironmentTest::AddCondition (const Environment & env, const Env::Sign s) {

  if (env.GetName() == envname) {
    if ((env.GetOriginal().length() == envname.length()) && (s == Env::eq))
      version.push_back (EnvVersionWithSign (env.GetVersion(), Env::ge));
    else
      version.push_back (EnvVersionWithSign (env.GetVersion(), s));
    return true;
  }
  return false;
}

bool EnvironmentTest::Test (const Environment & env) const {

  if (env.GetName() != envname) return false;
  for (std::vector <EnvVersionWithSign>::const_iterator vevi = version.begin();
       vevi != version.end(); vevi++) {
    switch (vevi->GetSign()) {
    case Env::eq:
      if (env.GetVersion() != *vevi) return false;
      break;
    case Env::ne:
      if (env.GetVersion() == *vevi) return false;
      break;
    case Env::lt:
      if (env.GetVersion() >= *vevi) return false;
      break;
    case Env::gt:
      if (env.GetVersion() <= *vevi) return false;
      break;
    case Env::le:
      if (env.GetVersion() > *vevi) return false;
      break;
    case Env::ge:
      if (env.GetVersion() < *vevi) return false;
      break;
    }
  }
  return true;
}
