#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "LdapQuery.h"

#ifndef UI_GIIS
#define UI_GIIS

class Giis {

 public:
  Giis () {};   // Added because of Swig
  Giis (const std::string & url);
  Giis (const std::string & host_, int port_, const std::string & basedn_);
  ~Giis () {};
  bool operator== (const Giis & giis) const;
  bool operator! () const;
  int Connect (const std::string & usersn, bool anonymous,
	       int timeout, int debug = 0);
  int Query (const std::string & usersn, int timeout, int debug = 0);
  int Result (void callback (const std::string & attr,
			     const std::string & value,
			     void * ref),
	      void * ref, int timeout, int debug = 0);
 private:
  std::string host;
  int port;
  std::string basedn;
  LdapQuery ldap;
};


int GetGiises (const std::vector <std::string> & giisurls, std::vector <Giis> & giislist);

#endif
