#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#ifndef UI_LDAPQUERY
#define UI_LDAPQUERY

typedef struct ldap LDAP;


class LdapQuery {

 public:
  LdapQuery ();
  ~LdapQuery () {};
  enum Scope { base, onelevel, subtree };
  int Connect (const std::string & ldaphost,
	       int ldapport,
	       const std::string & usersn,
	       bool anonymous,
	       int timeout,
	       int debug = 0);
  int Query (const std::string & base,
	     const std::string & filter,
	     const std::vector <std::string> & attributes,
	     Scope scope,
	     int timeout,
	     int debug = 0);
  int Result (void callback (const std::string & attr,
			     const std::string & value,
			     void * ref),
	      void * ref,
	      int timeout,
	      int debug = 0);
  int Find (const std::string & ldaphost,
	    int ldapport,
	    const std::string & usersn,
	    const std::string & base,
	    const std::string & filter,
	    const std::vector <std::string> & attributes,
	    Scope scope,
	    void callback (const std::string & attr,
			   const std::string & value,
			   void * ref),
	    void * ref,
	    bool anonymous,
	    int timeout,
	    int debug = 0);
 private:
  std::string host;
  int port;
  LDAP * connection;
  int messageid;
};

#endif
