#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>
#include <map>

#ifndef UI_REMOTEQUERY
#define UI_REMOTEQUERY

class Cluster;
class Queue;


enum FileLocation {
  REMOTE,
  LOCAL,
  REMOTENOCACHE,
  LOCALNOCACHE,
  CACHED,
  NOLOCATION,
  IOERROR
};


class LocationInfo {

 public:
  LocationInfo (const std::string & url);
  ~LocationInfo () {};
  const std::string & GetUrl () const;
  const std::string   GetHost () const;
 private:
  std::string url;
};


class Location {

 public:
  Location (const std::string & url, const std::string & optstring);
  ~Location () {};
  const std::string & GetUrl () const;
  bool GetBooleanOption (const std::string & opt, bool * value) const;
 private:
  std::string url;
  std::map <std::string, std::string> options;
};


class RemoteFileInfo {

 public:
  RemoteFileInfo (const std::string & url);
  ~RemoteFileInfo () {};
  bool operator== (const RemoteFileInfo & file) const;
  int Query ();
  const std::string & GetUrl () const;
  long long int GetSize ();
  bool IsCatalog () const;
  void RegisterCachedFile (const std::string & cluster);
  bool IsCached (const std::string & cluster) const;
  std::vector <LocationInfo> loclist;
 private:
  std::string url;
  std::vector <std::string> cached;
  long long int size;
  bool queried;
  bool iscatalog;
};


class RemoteFile {

 public:
  RemoteFile (const std::string & url,
	      const std::string & optstring,
	      const std::string & locstring);
  ~RemoteFile () {};
  FileLocation Local (Cluster * c, const bool defaultcache) const;
  long long int GetSize () const;
  bool IsCatalog () const;
  void RegisterCachedFile (const std::string & cluster) const;
 private:
  RemoteFileInfo * fileinfo;
  std::map <std::string, std::string> options;
  std::vector <Location> loclist;
  std::map <std::string, std::string> defaultoptions;
  static std::vector <RemoteFileInfo *> filecloud;
};


class RemoteFileQuery {

 public:
  RemoteFileQuery () {};
  RemoteFileQuery (const RemoteFileQuery & query);
  ~RemoteFileQuery ();
  RemoteFileQuery & operator= (const RemoteFileQuery & query);
  void AddFile (RemoteFile * const file);
  int AddSizes (Cluster * c,
		long long int * cachesize,
		long long int * sessdirsize,
		long long int * remotesize,
		long long int * localsize,
		const bool defaultcache) const;
  int RegisterCachedFiles (Cluster * c, const bool defaultcache) const;
 private:
  std::vector <RemoteFile *> filelist;
};


#endif
