#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>
#include <map>

#include <globus_common.h>
#include <globus_rsl.h>

#ifndef UI_XRSL
#define UI_XRSL

class Target;

class Xrsl {

 public:
  Xrsl (const std::string & xrslstring);
  Xrsl (const std::string & xrslfile, int dummy);
  Xrsl (const Xrsl & axrsl);
  Xrsl (globus_rsl_t * axrsl);
  ~Xrsl ();
  Xrsl & operator= (const Xrsl & axrsl);
  bool operator! () const;
  bool valid() const;
  Xrsl operator[] (const int ix) const;
  void Print () const;
  const std::string str () const;
  void AddSimpleRelation (const std::string & attr, const std::string & value);
  void AddSimpleRelationSet (const std::string & attr,
			     const std::vector <std::string> & values, bool select);
  int RemoveRelation (const std::string & attr, globus_rsl_t * axrsl = NULL);
  int UpdateAttribute (const std::string & attr, const std::string & value);
  int Check (globus_rsl_t * axrsl = NULL) const;
  int FixJoin ();
  int FixInOut (const std::string & stdattr, const std::string & inoutattr);
  int FixExec ();
  int FixExecs ();
  int FixStdin ();
  int FixTime (const std::string & attr);
  int FixPeriod (const std::string & attr);
  int PrepareUpload (std::vector <std::string> & filelist);
  int Collect (Target & target, const std::string & attr,
	       globus_rsl_t * axrsl = NULL);
  int GetJobName (std::string & jobname) const;
  std::string GetName () const;
  int GetCount (int * count) const;
  int GetCpuCount () const;
  int GetCpuTime (long int * time) const;
  int GetWallTime (long int * time) const;
  int GetGridTime (long int * time) const;
  int GetBenchmarks (std::map<std::string, std::pair<float, long int> > & bmrk) const;
  int GetDisk (long long int * disk) const;
  int GetClientXrsl (std::string & xrslstring) const;
  int GetInputFiles (std::vector <std::string> & filelist) const;
  int GetRc (std::string & rc) const;
  int GetDefaultCache (bool * cache) const;
  void Eval ();
  int Test (Target & target, std::string & failattr,
	    globus_rsl_t * axrsl = NULL) const;
  std::string TestTarget (Target & target) const;
  // "-1" indicates error
 private:
  int FindRelation (const std::string & attr, globus_rsl_t ** relation,
		    globus_rsl_t * axrsl = NULL) const;
  globus_list_t ** FindHead ();
  globus_rsl_t * xrsl;
};

#endif
