#ifndef ARCLIB_JOBLIST
#define ARCLIB_JOBLIST

#include <list>
#include <map>
#include <string>

#include <arc/error.h>

class Time;

/** This method gets a list of jobids from the .ngjobs respecting the
 *  clusterselect and clusterreject list passed. If both jobs and clusterselect
 *  are empty all jobs are returned (except those that match clusterreject).
 */
std::multimap<std::string, std::string> GetJobIDs(
      const std::list<std::string>& jobs = std::list<std::string>(),
      const std::list<std::string>& clusterselect = std::list<std::string>(),
      const std::list<std::string>& clusterreject = std::list<std::string>());

/** Same as above, but returns a std::list with only the jobids. */
std::list<std::string> GetJobIDsList(
      const std::list<std::string>& jobs = std::list<std::string>(),
      const std::list<std::string>& clusterselect = std::list<std::string>(),
      const std::list<std::string>& clusterreject = std::list<std::string>());

/** This method adds a jobid and corresponding jobname to the .ngjobs file. */
void AddJobID(const std::string& jobid, const std::string& jobname);

/** This method removes a jobid from the .ngjobs file. */
void RemoveJobID(const std::string& jobid);

/** This method retrieves the job-history from the .nghistory file. */
std::map<std::string, Time> GetJobHistory();

#endif // ARCLIB_JOBLIST
