workdir=`pwd`
if [ "$1" ]; then cd "$1" > /dev/null; fi

topdir=`pwd`

if [ ! -f $topdir/setup.sh ];
then
  echo "Please execute from the same directory where setup.sh is residing"
  echo "    OR supply that directory as argument to this script."
  cd "$workdir" > /dev/null
  return 1
fi

NORDUGRID_LOCATION=$topdir
GLOBUS_LOCATION=$topdir
GRID_SECURITY_DIR=$GLOBUS_LOCATION/etc
X509_CERT_DIR=$GLOBUS_LOCATION/share/certificates
export PYTHONPATH
export NORDUGRID_LOCATION
export GLOBUS_LOCATION
export GRID_SECURITY_DIR
export X509_CERT_DIR
. $GLOBUS_LOCATION/etc/globus-user-env.sh

DELIM=
if test -n "$PYTHONPATH"
then
    DELIM=:
fi
if test -r $NORDUGRID_LOCATION/lib*/python*/site-packages/_arclib.so
then
  export PYTHONPATH=`dirname $NORDUGRID_LOCATION/lib*/python*/site-packages/_arclib.so`${DELIM}${PYTHONPATH}
fi

if [ ! -f $topdir/ng-installed ] || [ "$topdir" != "`cat $topdir/ng-installed`" ]; then
  $topdir/bin/ng-finalize-setup
  echo $topdir > $topdir/ng-installed
fi

cd "$workdir" > /dev/null
