/*
 * Representation of GIIS-servers.
 */
#ifndef ARCLIB_GIIS
#define ARCLIB_GIIS

#include <list>
#include <string>

#include <arc/error.h>
#include <arc/url.h>

/**
 * GIIS exception. Is thrown by GIISLocations on error.
 */
class GIISError : public ARCLibError {
	public:
		/** Constructor for the GIISError exception. */
		GIISError(std::string message) : ARCLibError(message) {}
};


/**
 * Reads in a list of GIIS strings from standard locations. The following
 * files are read in order: $HOME/.nggiistlist,
 * $NORDUGRID_LOCATION/etc/giislist and /etc/giislist. If nothing is found,
 * a GIIS exception is thrown.
 */
std::list<URL> GetGIISList();

/**
 * Converts a list of strings to a list of URLs.
 */
std::list<URL> ConvertToURLs(std::list<std::string>);

#endif // ARCLIB_GIIS
